/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.visuals;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class FlatSplitPane
extends JPanel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    protected JSplitPane splitter;
    protected int topLeftOffset = -1;
    protected int bottomRightOffset = -1;
    protected boolean visible = true;

    public FlatSplitPane() {
        this(2, -1, -1);
    }

    public FlatSplitPane(int orientation) {
        this(orientation, -1, -1);
    }

    public FlatSplitPane(int orientation, int offsetTopLeft, int offsetBottomRight) {
        this.topLeftOffset = offsetTopLeft;
        this.bottomRightOffset = offsetBottomRight;
        this.setLayout(new BorderLayout(0, 0));
        this.splitter = orientation == 2 ? new JSplitPane(0){

            @Override
            public void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (!FlatSplitPane.this.visible) {
                    g.setColor(UIManager.getColor("control"));
                    g.fillRect(this.getDividerLocation(), 0, this.getDividerSize(), this.getHeight());
                    return;
                }
                int location = this.getDividerLocation();
                int leftOffset = FlatSplitPane.this.topLeftOffset == -1 ? this.getWidth() / 7 : (FlatSplitPane.this.topLeftOffset < -1 ? this.getWidth() / (-1 * FlatSplitPane.this.topLeftOffset) : FlatSplitPane.this.topLeftOffset);
                int rightOffset = FlatSplitPane.this.bottomRightOffset == -1 ? this.getWidth() / 7 : (FlatSplitPane.this.bottomRightOffset < -1 ? this.getWidth() / (-1 * FlatSplitPane.this.bottomRightOffset) : FlatSplitPane.this.bottomRightOffset);
                g.setColor(UIManager.getColor("control"));
                g.fillRect(0, location, this.getWidth(), this.getDividerSize());
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(leftOffset, location + this.getDividerSize(), leftOffset, location);
                g.drawLine(leftOffset, location, this.getWidth() - rightOffset, location);
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(this.getWidth() - rightOffset, location, this.getWidth() - rightOffset, location + this.getDividerSize());
                g.drawLine(this.getWidth() - rightOffset, location + this.getDividerSize(), leftOffset, location + this.getDividerSize());
            }
        } : new JSplitPane(1){

            @Override
            public void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (!FlatSplitPane.this.visible) {
                    g.setColor(UIManager.getColor("control"));
                    g.fillRect(this.getDividerLocation(), 0, this.getDividerSize(), this.getHeight());
                    return;
                }
                int location = this.getDividerLocation();
                int topOffset = FlatSplitPane.this.topLeftOffset == -1 ? this.getHeight() / 7 : (FlatSplitPane.this.topLeftOffset < -1 ? this.getHeight() / (-1 * FlatSplitPane.this.topLeftOffset) : FlatSplitPane.this.topLeftOffset);
                int bottomOffset = FlatSplitPane.this.bottomRightOffset == -1 ? this.getHeight() / 7 : (FlatSplitPane.this.bottomRightOffset < -1 ? this.getHeight() / (-1 * FlatSplitPane.this.bottomRightOffset) : FlatSplitPane.this.bottomRightOffset);
                g.setColor(UIManager.getColor("control"));
                g.fillRect(location, 0, this.getDividerSize(), this.getHeight());
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(location, this.getHeight() - bottomOffset, location, topOffset);
                g.drawLine(location, topOffset, location + this.getDividerSize(), topOffset);
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(location + this.getDividerSize(), topOffset, location + this.getDividerSize(), this.getHeight() - bottomOffset);
                g.drawLine(location + this.getDividerSize(), this.getHeight() - bottomOffset, location, this.getHeight() - bottomOffset);
            }
        };
        this.splitter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add("Center", this.splitter);
        this.addAllListeners();
    }

    public JSplitPane getSplitter() {
        return this.splitter;
    }

    @Override
    public void setVisible(boolean mode) {
        this.visible = mode;
    }

    protected void addAllListeners() {
        this.splitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("UI")) {
                    FlatSplitPane.this.splitter.paint(FlatSplitPane.this.splitter.getGraphics());
                }
            }
        });
    }
}

