/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.DefaultOperationList;
import com.sas.expressions.visuals.OperationInterface;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.expressions.visuals.OperationToolbarListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class OperationToolbar
extends JPanel {
    transient OperationListInterface _operationList = null;
    transient OperationButtonsActionListener _operationButtonListener = null;
    transient Component[] _componentsAdded = new Component[0];
    transient List _toolbarListeners = new ArrayList();
    GridBagConstraints _stdConstraints = null;
    GridBagConstraints _thinConstraints = null;
    boolean _isUserBorderSet = false;

    public OperationToolbar() {
        this(new DefaultOperationList());
    }

    public OperationToolbar(OperationListInterface operationList) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this._stdConstraints = new GridBagConstraints();
        this._stdConstraints.weightx = 1.0;
        this._stdConstraints.fill = 2;
        this._thinConstraints = (GridBagConstraints)this._stdConstraints.clone();
        this._thinConstraints.weightx = 0.25;
        this._operationButtonListener = new OperationButtonsActionListener();
        this._operationList = operationList;
        this.buildToolbar();
    }

    public OperationListInterface getOperationList() {
        return this._operationList;
    }

    public void setOperationList(OperationListInterface operationList) {
        if (operationList.equals(this._operationList)) {
            return;
        }
        this._operationList = operationList;
        for (int i = 0; i < this._componentsAdded.length; ++i) {
            Component item = this._componentsAdded[i];
            if (item instanceof OperationButton) {
                OperationButton operButton = (OperationButton)item;
                operButton.removeActionListener(this._operationButtonListener);
            }
            this._componentsAdded[i] = null;
        }
        this.removeAll();
        this.buildToolbar();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this._isUserBorderSet = true;
    }

    void buildToolbar() {
        Object item;
        OperationListInterface operList = this.getOperationList();
        List operations = new ArrayList();
        if (operList != null) {
            operations = operList.getOperations();
        }
        this._componentsAdded = new Component[operations.size()];
        if (!this._isUserBorderSet) {
            if (operations.size() > 0) {
                super.setBorder(BorderFactory.createLoweredBevelBorder());
            } else {
                super.setBorder(null);
            }
        }
        Iterator iter = operations.iterator();
        int j = 0;
        while (iter.hasNext()) {
            JComponent newComponent = null;
            item = iter.next();
            if (item instanceof OperationInterface) {
                OperationInterface operFormat = (OperationInterface)item;
                newComponent = new OperationButton(operFormat, this._operationButtonListener);
            } else {
                String name = "";
                if (item != null) {
                    name = item.toString();
                }
                newComponent = new OperationSeperator(name);
            }
            this._componentsAdded[j++] = newComponent;
        }
        for (int i = 0; i < this._componentsAdded.length; ++i) {
            item = this._componentsAdded[i];
            if (item instanceof OperationButton) {
                this.add((Component)item, this._stdConstraints);
                continue;
            }
            this.add((Component)item, this._thinConstraints);
        }
    }

    public void addOperationToolbarListener(OperationToolbarListener listener) {
        if (!this._toolbarListeners.contains(listener)) {
            this._toolbarListeners.add(listener);
        }
    }

    public void removeOperationToolbarListener(OperationToolbarListener listener) {
        if (this._toolbarListeners.contains(listener)) {
            this._toolbarListeners.remove(listener);
        }
    }

    private void notifyOperationToolbarListeners(ActionEvent event, OperationInterface operation) {
        for (Object tmp : this._toolbarListeners) {
            if (!(tmp instanceof OperationToolbarListener)) continue;
            OperationToolbarListener listener = (OperationToolbarListener)tmp;
            listener.operationPerformed(event, operation);
        }
    }

    class OperationButtonsActionListener
    implements ActionListener {
        OperationButtonsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source instanceof OperationButton) {
                OperationButton operButton = (OperationButton)source;
                try {
                    OperationInterface operation = operButton.getOperationInterface();
                    OperationToolbar.this.notifyOperationToolbarListeners(event, operation);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    class OperationButton
    extends JButton {
        OperationInterface _operation = null;

        public OperationButton(OperationInterface operation, OperationButtonsActionListener listener) {
            this._operation = operation;
            this.setName(operation.getDisplayName());
            Icon imageIcon = operation.getImageIcon();
            if (imageIcon != null) {
                this.setIcon(imageIcon);
            } else {
                this.setText(operation.getSymbol());
            }
            String toolTip = operation.getToolTip();
            if (toolTip != null && toolTip.trim().length() == 0) {
                toolTip = null;
            }
            this.setToolTipText(toolTip);
            this.setMargin(new Insets(2, 2, 2, 2));
            this.addActionListener(listener);
        }

        public OperationInterface getOperationInterface() {
            return this._operation;
        }
    }

    class OperationSeperator
    extends JPanel {
        public OperationSeperator(String name) {
            this.setName(name);
            this.setOpaque(false);
        }
    }
}

