/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class Mnemonics {
    private static String mnemonicCache = null;
    private static String stringWithoutMnemonic = null;
    private static int mnemonic = -1;
    private static int mnemonicPosition = -1;

    public static JLabel newMnemonicLabel(String item) {
        JLabel aLabel = new JLabel(item);
        Mnemonics.setMnemonicLabel(aLabel, item);
        return aLabel;
    }

    public static void setMnemonicLabel(JLabel aLabel, String item) {
        int index;
        if (aLabel == null) {
            return;
        }
        if (item == null) {
            return;
        }
        String text = Mnemonics.getLabelWithoutMnemonic(item);
        if (text != null) {
            aLabel.setText(text);
        }
        if ((index = Mnemonics.getDisplayedMnemonicIndex(item)) > -1) {
            int mnemonic = Mnemonics.getDisplayedMnemonic(item);
            aLabel.setDisplayedMnemonic(mnemonic);
            aLabel.setDisplayedMnemonicIndex(index);
        }
    }

    public static JButton newNmemonicButton(Icon icon, String item) {
        JButton button = new JButton(icon);
        Mnemonics.setMnemonicButton(button, item);
        return button;
    }

    public static JButton newNmemonicButton(String item) {
        JButton button = new JButton();
        Mnemonics.setMnemonicButton(button, item);
        return button;
    }

    public static void setMnemonicButton(JButton aButton, String item) {
        int index;
        if (aButton == null) {
            return;
        }
        if (item == null) {
            return;
        }
        String text = Mnemonics.getLabelWithoutMnemonic(item);
        if (text != null) {
            aButton.setText(text);
        }
        if ((index = Mnemonics.getDisplayedMnemonicIndex(item)) > -1) {
            int mnemonic = Mnemonics.getDisplayedMnemonic(item);
            aButton.setMnemonic(mnemonic);
            aButton.setDisplayedMnemonicIndex(index);
        }
    }

    public static void addMnemoicTab(JTabbedPane aTabbedPane, String item, Icon icon, Component component, String tooltip) {
        String text = Mnemonics.getLabelWithoutMnemonic(item);
        aTabbedPane.addTab(text, icon, component, tooltip);
        Mnemonics.setMnemonicTab(aTabbedPane, component, item);
    }

    public static void setMnemonicTab(JTabbedPane aTabbedPane, Component component, String item) {
        String text = Mnemonics.getLabelWithoutMnemonic(item);
        int tabIndex = aTabbedPane.indexOfComponent(component);
        aTabbedPane.setTitleAt(tabIndex, text);
        int mnemonicIndex = Mnemonics.getDisplayedMnemonicIndex(item);
        if (mnemonicIndex > -1) {
            int mnemonic = Mnemonics.getDisplayedMnemonic(item);
            aTabbedPane.setDisplayedMnemonicIndexAt(tabIndex, mnemonicIndex);
            aTabbedPane.setMnemonicAt(tabIndex, mnemonic);
        }
    }

    public static int getKeyMapping(String key) {
        if (key.equals("VK_0")) {
            return 48;
        }
        if (key.equals("VK_1")) {
            return 49;
        }
        if (key.equals("VK_2")) {
            return 50;
        }
        if (key.equals("VK_3")) {
            return 51;
        }
        if (key.equals("VK_4")) {
            return 52;
        }
        if (key.equals("VK_5")) {
            return 53;
        }
        if (key.equals("VK_6")) {
            return 54;
        }
        if (key.equals("VK_7")) {
            return 55;
        }
        if (key.equals("VK_8")) {
            return 56;
        }
        if (key.equals("VK_9")) {
            return 57;
        }
        if (key.equals("VK_SEMICOLON")) {
            return 59;
        }
        if (key.equals("VK_EQUALS")) {
            return 61;
        }
        if (key.equals("VK_A")) {
            return 65;
        }
        if (key.equals("VK_B")) {
            return 66;
        }
        if (key.equals("VK_C")) {
            return 67;
        }
        if (key.equals("VK_D")) {
            return 68;
        }
        if (key.equals("VK_E")) {
            return 69;
        }
        if (key.equals("VK_F")) {
            return 70;
        }
        if (key.equals("VK_G")) {
            return 71;
        }
        if (key.equals("VK_H")) {
            return 72;
        }
        if (key.equals("VK_I")) {
            return 73;
        }
        if (key.equals("VK_J")) {
            return 74;
        }
        if (key.equals("VK_K")) {
            return 75;
        }
        if (key.equals("VK_L")) {
            return 76;
        }
        if (key.equals("VK_M")) {
            return 77;
        }
        if (key.equals("VK_N")) {
            return 78;
        }
        if (key.equals("VK_O")) {
            return 79;
        }
        if (key.equals("VK_P")) {
            return 80;
        }
        if (key.equals("VK_Q")) {
            return 81;
        }
        if (key.equals("VK_R")) {
            return 82;
        }
        if (key.equals("VK_S")) {
            return 83;
        }
        if (key.equals("VK_T")) {
            return 84;
        }
        if (key.equals("VK_U")) {
            return 85;
        }
        if (key.equals("VK_V")) {
            return 86;
        }
        if (key.equals("VK_W")) {
            return 87;
        }
        if (key.equals("VK_X")) {
            return 88;
        }
        if (key.equals("VK_Y")) {
            return 89;
        }
        if (key.equals("VK_Z")) {
            return 90;
        }
        if (key.equals("VK_OPEN_BRACKET")) {
            return 91;
        }
        if (key.equals("VK_BACK_SLASH")) {
            return 92;
        }
        if (key.equals("VK_CLOSE_BRACKET")) {
            return 93;
        }
        if (key.equals("VK_NUMPAD0")) {
            return 96;
        }
        if (key.equals("VK_NUMPAD1")) {
            return 97;
        }
        if (key.equals("VK_NUMPAD2")) {
            return 98;
        }
        if (key.equals("VK_NUMPAD3")) {
            return 99;
        }
        if (key.equals("VK_NUMPAD4")) {
            return 100;
        }
        if (key.equals("VK_NUMPAD5")) {
            return 101;
        }
        if (key.equals("VK_NUMPAD6")) {
            return 102;
        }
        if (key.equals("VK_NUMPAD7")) {
            return 103;
        }
        if (key.equals("VK_NUMPAD8")) {
            return 104;
        }
        if (key.equals("VK_NUMPAD9")) {
            return 105;
        }
        if (key.equals("VK_COMMA")) {
            return 44;
        }
        if (key.equals("VK_PERIOD")) {
            return 46;
        }
        if (key.equals("VK_SLASH")) {
            return 47;
        }
        if (key.equals("VK_ENTER")) {
            return 10;
        }
        if (key.equals("VK_BACK_SPACE")) {
            return 8;
        }
        if (key.equals("VK_BACK_SPACE")) {
            return 9;
        }
        if (key.equals("VK_CANCEL")) {
            return 3;
        }
        if (key.equals("VK_CLEAR")) {
            return 12;
        }
        if (key.equals("VK_SHIFT")) {
            return 16;
        }
        if (key.equals("VK_CONTROL")) {
            return 17;
        }
        if (key.equals("VK_ALT")) {
            return 18;
        }
        if (key.equals("VK_PAUSE")) {
            return 19;
        }
        if (key.equals("VK_CAPS_LOCK")) {
            return 20;
        }
        if (key.equals("VK_ESCAPE")) {
            return 27;
        }
        if (key.equals("VK_SPACE")) {
            return 32;
        }
        if (key.equals("VK_PAGE_UP")) {
            return 33;
        }
        if (key.equals("VK_DOWN")) {
            return 34;
        }
        if (key.equals("VK_END")) {
            return 35;
        }
        if (key.equals("VK_HOME")) {
            return 36;
        }
        if (key.equals("VK_LEFT")) {
            return 37;
        }
        if (key.equals("VK_UP")) {
            return 38;
        }
        if (key.equals("VK_RIGHT")) {
            return 39;
        }
        if (key.equals("VK_DOWN")) {
            return 40;
        }
        if (key.equals("VK_MULTIPLY")) {
            return 106;
        }
        if (key.equals("VK_ADD")) {
            return 107;
        }
        if (key.equals("VK_SEPARATER")) {
            return 108;
        }
        if (key.equals("VK_SUBTRACT")) {
            return 109;
        }
        if (key.equals("VK_DECIMAL")) {
            return 110;
        }
        if (key.equals("VK_DIVIDE")) {
            return 111;
        }
        if (key.equals("VK_DELETE")) {
            return 127;
        }
        if (key.equals("VK_NUM_LOCK")) {
            return 144;
        }
        if (key.equals("VK_SCROLL_LOCK")) {
            return 145;
        }
        if (key.equals("VK_F1")) {
            return 112;
        }
        if (key.equals("VK_F2")) {
            return 113;
        }
        if (key.equals("VK_F3")) {
            return 114;
        }
        if (key.equals("VK_F4")) {
            return 115;
        }
        if (key.equals("VK_F5")) {
            return 116;
        }
        if (key.equals("VK_F6")) {
            return 117;
        }
        if (key.equals("VK_F7")) {
            return 118;
        }
        if (key.equals("VK_F8")) {
            return 119;
        }
        if (key.equals("VK_F9")) {
            return 120;
        }
        if (key.equals("VK_F10")) {
            return 121;
        }
        if (key.equals("VK_F11")) {
            return 122;
        }
        if (key.equals("VK_F12")) {
            return 123;
        }
        if (key.equals("VK_F13")) {
            return 61440;
        }
        if (key.equals("VK_F14")) {
            return 61441;
        }
        if (key.equals("VK_F15")) {
            return 61442;
        }
        if (key.equals("VK_F16")) {
            return 61443;
        }
        if (key.equals("VK_F17")) {
            return 61444;
        }
        if (key.equals("VK_F18")) {
            return 61445;
        }
        if (key.equals("VK_F19")) {
            return 61446;
        }
        if (key.equals("VK_F20")) {
            return 61447;
        }
        if (key.equals("VK_F21")) {
            return 61448;
        }
        if (key.equals("VK_F22")) {
            return 61449;
        }
        if (key.equals("VK_F23")) {
            return 61450;
        }
        if (key.equals("VK_F24")) {
            return 61451;
        }
        if (key.equals("VK_PRINTSCREEN")) {
            return 154;
        }
        if (key.equals("VK_INSERT")) {
            return 155;
        }
        if (key.equals("VK_HELP")) {
            return 156;
        }
        if (key.equals("VK_META")) {
            return 157;
        }
        if (key.equals("VK_BACK_QUOTE")) {
            return 192;
        }
        if (key.equals("VK_QUOTE")) {
            return 222;
        }
        if (key.equals("VK_KP_UP")) {
            return 224;
        }
        if (key.equals("VK_KP_DOWN")) {
            return 225;
        }
        if (key.equals("VK_KP_LEFT")) {
            return 226;
        }
        if (key.equals("VK_KP_RIGHT")) {
            return 227;
        }
        if (key.equals("VK_DEAD_GRAVE")) {
            return 128;
        }
        if (key.equals("VK_DEAD_ACUTE")) {
            return 129;
        }
        if (key.equals("VK_DEAD_CIRCUMFLEX")) {
            return 130;
        }
        if (key.equals("VK_DEAD_TILDE")) {
            return 131;
        }
        if (key.equals("VK_DEAD_MACRON")) {
            return 132;
        }
        if (key.equals("VK_DEAD_BREVE")) {
            return 133;
        }
        if (key.equals("VK_DEAD_ABOVEDOT")) {
            return 134;
        }
        if (key.equals("VK_DEAD_DIAERESIS")) {
            return 135;
        }
        if (key.equals("VK_DEAD_ABOVERING")) {
            return 136;
        }
        if (key.equals("VK_DEAD_DOUBLEACUTE")) {
            return 137;
        }
        if (key.equals("VK_DEAD_CARON")) {
            return 138;
        }
        if (key.equals("VK_DEAD_CEDILLA")) {
            return 139;
        }
        if (key.equals("VK_DEAD_OGONEK")) {
            return 140;
        }
        if (key.equals("VK_DEAD_IOTA")) {
            return 141;
        }
        if (key.equals("VK_DEAD_VOICED_SOUND")) {
            return 142;
        }
        if (key.equals("VK_DEAD_SEMIVOICED_SOUND")) {
            return 143;
        }
        if (key.equals("VK_AMPERSAND")) {
            return 150;
        }
        if (key.equals("VK_ASTERISK")) {
            return 151;
        }
        if (key.equals("VK_QUOTEDBL")) {
            return 152;
        }
        if (key.equals("VK_LESS")) {
            return 153;
        }
        if (key.equals("VK_GREATER")) {
            return 160;
        }
        if (key.equals("VK_BRACELEFT")) {
            return 161;
        }
        if (key.equals("VK_BRACERIGHT")) {
            return 162;
        }
        if (key.equals("VK_AT")) {
            return 512;
        }
        if (key.equals("VK_COLON")) {
            return 513;
        }
        if (key.equals("VK_CIRCUMFLEX")) {
            return 514;
        }
        if (key.equals("VK_DOLLAR")) {
            return 515;
        }
        if (key.equals("VK_EURO_SIGN")) {
            return 516;
        }
        if (key.equals("VK_EXCLAMATION_MARK")) {
            return 517;
        }
        if (key.equals("VK_INVERTED_EXCLAMATION_MARK")) {
            return 518;
        }
        if (key.equals("VK_LEFT_PARENTHESIS")) {
            return 519;
        }
        if (key.equals("VK_NUMBER_SIGN")) {
            return 520;
        }
        if (key.equals("VK_MINUS")) {
            return 45;
        }
        if (key.equals("VK_PLUS")) {
            return 521;
        }
        if (key.equals("VK_RIGHT_PARENTHESIS")) {
            return 522;
        }
        if (key.equals("VK_UNDERSCORE")) {
            return 523;
        }
        if (key.equals("VK_FINAL")) {
            return 24;
        }
        if (key.equals("VK_CONVERT")) {
            return 28;
        }
        if (key.equals("VK_NONCONVERT")) {
            return 29;
        }
        if (key.equals("VK_ACCEPT")) {
            return 30;
        }
        if (key.equals("VK_MODECHANGE")) {
            return 31;
        }
        if (key.equals("VK_KANA")) {
            return 21;
        }
        if (key.equals("VK_KANJI")) {
            return 25;
        }
        if (key.equals("VK_ALPHANUMERIC")) {
            return 240;
        }
        if (key.equals("VK_KATAKANA")) {
            return 241;
        }
        if (key.equals("VK_HIRAGANA")) {
            return 242;
        }
        if (key.equals("VK_FULL_WIDTH")) {
            return 243;
        }
        if (key.equals("VK_HALF_WIDTH")) {
            return 244;
        }
        if (key.equals("VK_ROMAN_CHARACTERS")) {
            return 245;
        }
        if (key.equals("VK_ALL_CANDIDATES")) {
            return 256;
        }
        if (key.equals("VK_PREVIOUS_CANDIDATE")) {
            return 257;
        }
        if (key.equals("VK_CODE_INPUT")) {
            return 258;
        }
        if (key.equals("VK_JAPANESE_KATAKANA")) {
            return 259;
        }
        if (key.equals("VK_JAPANESE_HIRAGANA")) {
            return 260;
        }
        if (key.equals("VK_JAPANESE_ROMAN")) {
            return 261;
        }
        if (key.equals("VK_KANA_LOCK")) {
            return 262;
        }
        if (key.equals("VK_INPUT_METHOD_ON_OFF")) {
            return 263;
        }
        if (key.equals("VK_AGAIN")) {
            return 65481;
        }
        if (key.equals("VK_UNDO")) {
            return 65483;
        }
        if (key.equals("VK_COPY")) {
            return 65485;
        }
        if (key.equals("VK_PASTE")) {
            return 65487;
        }
        if (key.equals("VK_CUT")) {
            return 65489;
        }
        if (key.equals("VK_FIND")) {
            return 65488;
        }
        if (key.equals("VK_PROPS")) {
            return 65482;
        }
        if (key.equals("VK_STOP")) {
            return 65480;
        }
        if (key.equals("VK_COMPOSE")) {
            return 65312;
        }
        if (key.equals("VK_ALT_GRAPH")) {
            return 65406;
        }
        return -1;
    }

    public static synchronized int getDisplayedMnemonic(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Mnemonics.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return mnemonic;
    }

    public static synchronized int getDisplayedMnemonicIndex(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Mnemonics.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return mnemonicPosition;
    }

    public static synchronized String getLabelWithoutMnemonic(String label) {
        if (mnemonicCache == null || !mnemonicCache.equals(label)) {
            Mnemonics.parseForMnemonic(label);
            mnemonicCache = label;
        }
        return stringWithoutMnemonic;
    }

    private static synchronized void parseForMnemonic(String label) {
        StringBuffer parsedLabel = new StringBuffer();
        mnemonic = -1;
        mnemonicPosition = -1;
        stringWithoutMnemonic = null;
        if (label != null) {
            boolean foundAmpersand = false;
            int len = label.length();
            for (int i = 0; i < len; ++i) {
                if ('&' == label.charAt(i)) {
                    if (foundAmpersand || i + 3 < len && "&gt;".equals(label.substring(i, i + 4)) || i + 3 < len && "&lt;".equals(label.substring(i, i + 4)) || i + 4 < len && "&amp;".equals(label.substring(i, i + 5)) || i + 5 < len && "&copy;".equals(label.substring(i, i + 6)) || i + 2 < len && "&#".equals(label.substring(i, i + 2))) {
                        parsedLabel.append(label.substring(i, i + 1));
                        foundAmpersand = false;
                        continue;
                    }
                    foundAmpersand = true;
                    continue;
                }
                if (foundAmpersand) {
                    String mnemonicString = label.substring(i, i + 1);
                    parsedLabel.append(mnemonicString);
                    if (mnemonic == -1) {
                        mnemonic = Mnemonics.getKeyMapping("VK_" + mnemonicString.toUpperCase());
                    }
                    if (mnemonicPosition == -1) {
                        mnemonicPosition = parsedLabel.length() - 1;
                    }
                } else {
                    parsedLabel.append(label.substring(i, i + 1));
                }
                foundAmpersand = false;
            }
        }
        stringWithoutMnemonic = parsedLabel.toString();
    }
}

