/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.DoublePartDescriptionPanel;
import com.sas.expressions.visuals.FunctionFormatInterface;
import com.sas.expressions.visuals.FunctionListInterface;
import com.sas.expressions.visuals.FunctionNodeInterface;
import com.sas.expressions.visuals.FunctionTreeInterface;
import com.sas.expressions.visuals.FunctionTreeSelectorEvent;
import com.sas.expressions.visuals.Mnemonics;
import com.sas.expressions.visuals.RB;
import com.sas.swing.visuals.FlatSplitPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FunctionTreeSelector
extends JPanel {
    public static final String RB_KEY = "FunctionTreeSelector.";
    protected JSplitPane JSplitPane_CategoriesFunctionsAndDescription;
    protected JSplitPane JSplitPane_CategoriesAndFunctions;
    protected JPanel JPanel_LabelAndCategories;
    protected JLabel JLabel_Categories;
    protected JScrollPane JScrollPane_Categories;
    protected JTree JTree_Categories;
    protected JPanel JPanel_LabelAndFunctions;
    protected JLabel JLabel_Functions;
    protected JScrollPane JScrollPane_Functions;
    protected JList JList_Functions;
    protected DoublePartDescriptionPanel _descriptionPanel;
    protected JButton JButton_Insert_OnFunctions;
    protected boolean _insertButtonVisible = false;
    protected boolean _insertButtonEnabled = false;
    protected String _insertButtonLabel = RB.getStringResource("FunctionTreeSelector.", "InsertButton.Label.txt");
    protected Icon _insertButtonIcon = null;
    protected String _insertButtonToolTip = RB.getStringResource("FunctionTreeSelector.", "InsertButton.ToolTip.Initial.txt");
    protected boolean doubleClickInsertEnabled = false;
    protected boolean doubleClickInsertListValueEnabled = true;
    protected boolean doubleClickInsertTreeLeafEnabled = true;
    protected String _categoryTreeLabel = RB.getStringResource("FunctionTreeSelector.", "CategoryTree.Label.txt");
    protected String _functionListLabel = RB.getStringResource("FunctionTreeSelector.", "FunctionList.Label.txt");
    protected String _insertButtonToolTipWhenFunctionPicked = RB.getStringResource("FunctionTreeSelector.", "InsertButton.ToolTip.FunctionPicked.txt");
    List _functionTreeSelectorActionEventListeners = new ArrayList();

    public FunctionTreeSelector() {
        this.init();
    }

    private void init() {
        FunctionTreeSelector functionsTab = this;
        functionsTab.setBorder(new EmptyBorder(new Insets(2, 2, 2, 4)));
        functionsTab.setLayout(new GridBagLayout());
        functionsTab.setName("JPanel_FunctionsTab");
        functionsTab.setOpaque(false);
        this.JLabel_Categories = Mnemonics.newMnemonicLabel(this._categoryTreeLabel);
        this.JLabel_Categories.setOpaque(false);
        this.JTree_Categories = new JTree();
        this.JTree_Categories.setCellRenderer(new DefaultTreeCellRenderer());
        this.JTree_Categories.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("JTree")));
        this.JTree_Categories.setName("JTree_Categories");
        this.JTree_Categories.setRootVisible(false);
        this.JTree_Categories.setShowsRootHandles(false);
        this.JTree_Categories.setBorder(null);
        this.JTree_Categories.getSelectionModel().setSelectionMode(1);
        this.JTree_Categories.setAutoscrolls(true);
        this.JLabel_Categories.setLabelFor(this.JTree_Categories);
        this.JScrollPane_Categories = new JScrollPane(this.JTree_Categories);
        this.JScrollPane_Categories.setName("JScrollPane_Categories");
        this.JPanel_LabelAndCategories = new JPanel();
        this.JPanel_LabelAndCategories.setLayout(new GridBagLayout());
        this.JPanel_LabelAndCategories.setName("JPanel_LabelAndCategories");
        this.JPanel_LabelAndCategories.setOpaque(false);
        this.JPanel_LabelAndCategories.add((Component)this.JLabel_Categories, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.JPanel_LabelAndCategories.add((Component)this.JScrollPane_Categories, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 5), 1, 1));
        this.JLabel_Functions = Mnemonics.newMnemonicLabel(this._functionListLabel);
        this.JLabel_Functions.setOpaque(false);
        this.JList_Functions = new JList();
        this.JList_Functions.setModel(new DefaultListModel());
        this.JList_Functions.setName("JList_Functions");
        this.JList_Functions.setSelectionMode(0);
        this.JList_Functions.setBorder(null);
        this.JList_Functions.setAutoscrolls(true);
        this.JLabel_Functions.setLabelFor(this.JList_Functions);
        this.JScrollPane_Functions = new JScrollPane(this.JList_Functions);
        this.JScrollPane_Functions.setName("JScrollPane_Functions");
        this.JScrollPane_Functions.setAutoscrolls(true);
        this.JPanel_LabelAndFunctions = new JPanel();
        this.JPanel_LabelAndFunctions.setLayout(new GridBagLayout());
        this.JPanel_LabelAndFunctions.setName("JPanel_LabelAndFunctions");
        this.JPanel_LabelAndFunctions.setOpaque(false);
        this.JPanel_LabelAndFunctions.add((Component)this.JLabel_Functions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.JPanel_LabelAndFunctions.add((Component)this.JScrollPane_Functions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 7, 0, 0), 1, 1));
        this.JPanel_LabelAndCategories.setMinimumSize(new Dimension(60, 100));
        this.JPanel_LabelAndCategories.setPreferredSize(new Dimension(80, 150));
        this.JPanel_LabelAndFunctions.setMinimumSize(new Dimension(80, 100));
        this.JPanel_LabelAndFunctions.setPreferredSize(new Dimension(100, 150));
        FlatSplitPane splitCategoriesAndFunctions = new FlatSplitPane(1);
        this.JSplitPane_CategoriesAndFunctions = splitCategoriesAndFunctions.getSplitter();
        this.JSplitPane_CategoriesAndFunctions.setContinuousLayout(true);
        this.JSplitPane_CategoriesAndFunctions.setLeftComponent(this.JPanel_LabelAndCategories);
        this.JSplitPane_CategoriesAndFunctions.setRightComponent(this.JPanel_LabelAndFunctions);
        this.JSplitPane_CategoriesAndFunctions.setDividerSize(3);
        this.JSplitPane_CategoriesAndFunctions.setName("JSplitPane_CategoriesAndFunctions");
        this.JSplitPane_CategoriesAndFunctions.setResizeWeight(0.5);
        functionsTab.add((Component)this.JSplitPane_CategoriesAndFunctions, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._descriptionPanel = new DoublePartDescriptionPanel();
        this._descriptionPanel.setName("FunctionDescriptionTexts");
        functionsTab.add((Component)this._descriptionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.JButton_Insert_OnFunctions = Mnemonics.newNmemonicButton(this._insertButtonIcon, this._insertButtonLabel);
        this.JButton_Insert_OnFunctions.setName("JButton_Insert_OnFunctions");
        this.JButton_Insert_OnFunctions.setToolTipText(this._insertButtonToolTip);
        this.JButton_Insert_OnFunctions.setEnabled(this._insertButtonEnabled);
        this.JButton_Insert_OnFunctions.setVisible(this._insertButtonVisible);
        functionsTab.add((Component)this.JButton_Insert_OnFunctions, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 2, 2), 0, 0));
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                FunctionFormatInterface fmt;
                Component basic = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String hint = null;
                if (value != null && index != -1 && value instanceof FunctionFormatInterface && (hint = (fmt = (FunctionFormatInterface)value).getDescription()) != null && hint.trim().length() == 0) {
                    hint = null;
                }
                this.setToolTipText(hint);
                return this;
            }
        };
        this.JList_Functions.setCellRenderer(cellRenderer);
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == FunctionTreeSelector.this.JTree_Categories) {
                        TreePath path = FunctionTreeSelector.this.JTree_Categories.getSelectionPath();
                        if (path != null) {
                            FunctionTreeSelector.this.JTree_Categories.scrollPathToVisible(path);
                        }
                        FunctionTreeSelector.this.JList_Functions.clearSelection();
                        FunctionTreeSelector.this.JList_Functions.removeAll();
                        FunctionTreeSelector.this.setInsertButtonToolTip(null);
                        FunctionTreeSelector.this.setInsertButtonEnabled(false);
                        Object selection = FunctionTreeSelector.this.getFunctionTreeSelectedObject();
                        if (selection == null) {
                            FunctionTreeSelector.this.setFunctionDescriptionText(null, null);
                        } else if (selection instanceof FunctionNodeInterface) {
                            String descText;
                            FunctionNodeInterface functionNode = (FunctionNodeInterface)selection;
                            String fmtText = functionNode.getDisplayName().trim();
                            if (fmtText.compareToIgnoreCase(descText = functionNode.getDescription().trim()) == 0) {
                                descText = "";
                            }
                            FunctionTreeSelector.this.setFunctionDescriptionText(fmtText, descText);
                            FunctionTreeSelector.this.loadFunctionList(functionNode);
                            FunctionTreeSelector.this.JTree_Categories.getAccessibleContext().setAccessibleDescription(fmtText);
                        } else {
                            FunctionTreeSelector.this.setFunctionDescriptionText(selection.toString(), "");
                            if (selection instanceof List) {
                                FunctionTreeSelector.this.addAndSortIntoFunctionListData((List)selection);
                            }
                        }
                        FunctionTreeSelector.this.fireActionListeners(2003, event.toString(), selection);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JTree_Categories.addTreeSelectionListener(treeSelectionListener);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                try {
                    Object source = event.getSource();
                    if (source == FunctionTreeSelector.this.JList_Functions) {
                        FunctionFormatInterface fmt;
                        int index = FunctionTreeSelector.this.JList_Functions.getSelectedIndex();
                        if (index != -1) {
                            FunctionTreeSelector.this.JList_Functions.scrollRectToVisible(FunctionTreeSelector.this.JList_Functions.getCellBounds(index, index));
                        }
                        String newFncDescText = "";
                        String newFmtDescText = "";
                        Object item = FunctionTreeSelector.this.JList_Functions.getSelectedValue();
                        if (item != null && item instanceof FunctionFormatInterface && (newFmtDescText = (fmt = (FunctionFormatInterface)item).getFormatDesc()).equals(newFncDescText = fmt.getDescription())) {
                            newFncDescText = "";
                        }
                        FunctionTreeSelector.this.setFunctionDescriptionText(newFmtDescText, newFncDescText);
                        FunctionTreeSelector.this.setInsertButtonToolTip(FunctionTreeSelector.this._insertButtonToolTipWhenFunctionPicked);
                        FunctionTreeSelector.this.setInsertButtonEnabled(true);
                        FunctionTreeSelector.this.fireActionListeners(2004, event.toString(), item);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JList_Functions.addListSelectionListener(listSelectionListener);
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }

            @Override
            public void mouseEntered(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent event) {
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    boolean dblClick;
                    Object source = event.getSource();
                    int modifier = event.getModifiers();
                    boolean button1 = (modifier & 0x10) != 0;
                    boolean bl = dblClick = event.getClickCount() == 2;
                    if (button1 && dblClick) {
                        if (source == FunctionTreeSelector.this.JList_Functions) {
                            Object item;
                            if ((FunctionTreeSelector.this.isDoubleClickInsertEnabled() || FunctionTreeSelector.this.isDoubleClickInsertListValueEnabled()) && (item = FunctionTreeSelector.this.JList_Functions.getSelectedValue()) != null) {
                                FunctionTreeSelector.this.fireActionListeners(2002, event.toString(), item);
                            }
                            return;
                        }
                        if (source == FunctionTreeSelector.this.JTree_Categories) {
                            Object item;
                            Object selection;
                            boolean doIt = FunctionTreeSelector.this.isDoubleClickInsertEnabled();
                            if (!doIt && FunctionTreeSelector.this.isDoubleClickInsertTreeLeafEnabled() && (selection = FunctionTreeSelector.this.JTree_Categories.getLastSelectedPathComponent()) != null) {
                                doIt = FunctionTreeSelector.this.JTree_Categories.getModel().isLeaf(selection);
                            }
                            if (doIt && (item = FunctionTreeSelector.this.getFunctionTreeSelectedObject()) != null) {
                                FunctionTreeSelector.this.fireActionListeners(2001, event.toString(), item);
                            }
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JTree_Categories.addMouseListener(mouseListener);
        this.JList_Functions.addMouseListener(mouseListener);
        ActionListener insertButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == FunctionTreeSelector.this.JButton_Insert_OnFunctions) {
                        Object item = null;
                        item = FunctionTreeSelector.this.getSelectedObject();
                        if (item != null) {
                            boolean isFunction = FunctionTreeSelector.this.isSelectionFromList();
                            if (isFunction) {
                                FunctionTreeSelector.this.fireActionListeners(2002, event.toString(), item);
                            } else {
                                FunctionTreeSelector.this.fireActionListeners(2001, event.toString(), item);
                            }
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JButton_Insert_OnFunctions.addActionListener(insertButtonActionListener);
    }

    protected Object getFunctionTreeSelectedObject() {
        Object selection = this.JTree_Categories.getLastSelectedPathComponent();
        if (selection == null) {
            return null;
        }
        Object nodeInfo = null;
        if (selection instanceof DefaultMutableTreeNode) {
            nodeInfo = ((DefaultMutableTreeNode)selection).getUserObject();
        }
        if (nodeInfo == null) {
            return selection;
        }
        if (nodeInfo instanceof FunctionNodeInterface) {
            return nodeInfo;
        }
        if (selection instanceof FunctionNodeInterface) {
            return selection;
        }
        return nodeInfo;
    }

    protected void setFunctionDescriptionText(String infoText, String descText) {
        this._descriptionPanel.setUpperText(infoText);
        this._descriptionPanel.setLowerText(descText);
        this._descriptionPanel.refresh();
    }

    protected synchronized void loadFunctionList(FunctionNodeInterface nodeInfo) {
        String hint;
        List values = new Vector();
        FunctionListInterface functions = nodeInfo.getFunctionListInterface();
        if (functions != null) {
            values = functions.getFunctionsFormatsList();
        }
        if ((hint = nodeInfo.getDescription()) != null && hint.trim().length() == 0) {
            hint = nodeInfo.getDisplayName();
        }
        if (hint != null && hint.trim().length() == 0) {
            hint = null;
        }
        this.JList_Functions.setToolTipText(hint);
        this.addAndSortIntoFunctionListData(values);
    }

    protected void addAndSortIntoFunctionListData(List values) {
        Object[] sortData = values.toArray();
        Arrays.sort(sortData, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        values = Arrays.asList(sortData);
        Vector<Object> listData = new Vector<Object>(values);
        this.JList_Functions.setListData(listData);
    }

    public void addActionEventListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this._functionTreeSelectorActionEventListeners.contains(listener)) {
            return;
        }
        this._functionTreeSelectorActionEventListeners.add(listener);
    }

    public void removeActionEventListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (!this._functionTreeSelectorActionEventListeners.contains(listener)) {
            return;
        }
        this._functionTreeSelectorActionEventListeners.remove(listener);
    }

    protected void fireActionListeners(int id, String action, Object item) {
        FunctionTreeSelectorEvent event = new FunctionTreeSelectorEvent((Object)this, id, action, item);
        for (ActionListener listener : this._functionTreeSelectorActionEventListeners) {
            listener.actionPerformed(event);
        }
    }

    public boolean isInsertButtonVisible() {
        return this.JButton_Insert_OnFunctions.isVisible();
    }

    public void setInsertButtonVisible(boolean visible) {
        this.JButton_Insert_OnFunctions.setVisible(visible);
    }

    public void setInsertButtonEnabled(boolean enable) {
        this._insertButtonEnabled = enable;
        this.JButton_Insert_OnFunctions.setEnabled(enable);
    }

    public boolean isInsertButtonEnabled() {
        return this._insertButtonEnabled;
    }

    public void setInsertButtonToolTip(String tooltip) {
        if (tooltip != null && tooltip.trim().length() == 0) {
            tooltip = null;
        }
        this._insertButtonToolTip = tooltip;
        this.JButton_Insert_OnFunctions.setToolTipText(this._insertButtonToolTip);
    }

    public String getInsertButtonToolTip() {
        return this._insertButtonToolTip;
    }

    public void setInsertButtonIcon(Icon icon) {
        this.JButton_Insert_OnFunctions.setIcon(icon);
    }

    public void setInsertButtonLabel(String label) {
        Mnemonics.setMnemonicButton(this.JButton_Insert_OnFunctions, label);
    }

    public void setDoubleClickInsertEnabled(boolean enable) {
        this.doubleClickInsertEnabled = enable;
    }

    public boolean isDoubleClickInsertEnabled() {
        return this.doubleClickInsertEnabled;
    }

    public void setdoubleClickInsertListValueEnabled(boolean enable) {
        this.doubleClickInsertListValueEnabled = enable;
    }

    public boolean isDoubleClickInsertListValueEnabled() {
        return this.doubleClickInsertListValueEnabled;
    }

    public void setDoubleClickInsertTreeLeafEnabled(boolean enable) {
        this.doubleClickInsertTreeLeafEnabled = enable;
    }

    public boolean isDoubleClickInsertTreeLeafEnabled() {
        return this.doubleClickInsertTreeLeafEnabled;
    }

    public String getCategoryTreeLabel() {
        return this._categoryTreeLabel;
    }

    public void setCategoryTreeLabel(String label) {
        Mnemonics.setMnemonicLabel(this.JLabel_Categories, label);
        this._categoryTreeLabel = label;
    }

    public String getFunctionListLabel() {
        return this._functionListLabel;
    }

    public void setFunctionListLabel(String label) {
        Mnemonics.setMnemonicLabel(this.JLabel_Functions, label);
        this._functionListLabel = label;
    }

    public TreeModel getFunctionListTreeModel() {
        return this.JTree_Categories.getModel();
    }

    public void setFunctionListTreeModel(TreeModel value) {
        String toolTip = value == null ? null : (value.getRoot() == null ? value.toString() : value.getRoot().toString());
        if (toolTip != null && toolTip.trim().length() == 0) {
            toolTip = null;
        }
        this.JList_Functions.clearSelection();
        this.JList_Functions.setListData(new Vector());
        this.JTree_Categories.setToolTipText(toolTip);
        this.JTree_Categories.setModel(value);
        if (value instanceof FunctionTreeInterface) {
            FunctionTreeInterface fti = (FunctionTreeInterface)value;
            String treeLabel = fti.getFunctionTreeLabel();
            TreeCellRenderer newCellRenderer = fti.getJTreeCellRenderer(this.JTree_Categories);
            if (newCellRenderer != null) {
                this.JTree_Categories.setCellRenderer(newCellRenderer);
            }
        }
    }

    public Object getSelectedObject() {
        Object item = this.JList_Functions.getSelectedValue();
        if (item != null) {
            return item;
        }
        item = this.getFunctionTreeSelectedObject();
        if (item != null) {
            return item;
        }
        return null;
    }

    public boolean isSelectionFromList() {
        Object item = this.JList_Functions.getSelectedValue();
        return item != null;
    }
}

