/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.FunctionFormatInterface;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FunctionFormat
implements FunctionFormatInterface {
    String _name = null;
    String _displayName = null;
    String _description = null;
    String _toolTip = null;
    String _formatString = null;
    List _argList = null;

    public FunctionFormat() {
    }

    public FunctionFormat(String name, String displayName, String description, String toolTip, String fmtString, List args) {
        this._name = name;
        this._displayName = displayName;
        this._description = description;
        this._toolTip = toolTip;
        this._formatString = fmtString;
        this._argList = args;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getFormatDesc() {
        return MessageFormat.format(this.getFormatString(), this.getArgDisplayNames());
    }

    @Override
    public String getToolTip() {
        return this._toolTip;
    }

    protected String getFormatString() {
        return this._formatString;
    }

    protected List getArgList() {
        return this._argList;
    }

    protected String getArgDisplayName(Object obj) {
        return obj.toString();
    }

    private String[] getArgDisplayNames() {
        ArrayList<String> displayNames = new ArrayList<String>();
        Iterator iter = this.getArgList().iterator();
        while (iter.hasNext()) {
            displayNames.add(this.getArgDisplayName(iter.next()));
        }
        return displayNames.toArray(new String[displayNames.size()]);
    }

    @Override
    public String formatSelectedText(String text) {
        String[] argDisplayNames = this.getArgDisplayNames();
        String format = this.getFormatString();
        String retValue = FunctionFormat.formatSelectedText(format, argDisplayNames, text);
        return retValue;
    }

    @Override
    public String formatSelectedText(String text, int[] selStartEnd) {
        String[] argDisplayNames = this.getArgDisplayNames();
        String format = this.getFormatString();
        String retValue = FunctionFormat.formatSelectedText(format, argDisplayNames, text, selStartEnd);
        return retValue;
    }

    public String toString() {
        return this._displayName;
    }

    public static String formatSelectedText(String format, String[] argNames, String text) {
        String newText = text;
        newText = newText.replaceAll("'", "\bx\b");
        newText = newText.replaceAll("[{]", "\by\b");
        newText = newText.replaceAll("[}]", "\bz\b");
        Object[] newArgs = new String[argNames.length];
        if (newArgs.length > 0) {
            newArgs[0] = newText != null && newText.length() > 0 ? newText : argNames[0];
            for (int i = 1; i < newArgs.length; ++i) {
                newArgs[i] = argNames[i];
            }
        }
        String retValue = MessageFormat.format(format, newArgs);
        retValue = retValue.replaceAll("\bx\b", "'");
        retValue = retValue.replaceAll("\by\b", "{");
        retValue = retValue.replaceAll("\bz\b", "}");
        return retValue;
    }

    static void findNewStartEnd(String format, String[] argDisplayNames, int selLength, int[] selStartEnd) {
        String argString;
        String sub;
        int argIndex;
        int j;
        String tmp;
        int i;
        int selStart = selStartEnd[0];
        int selEnd = selStartEnd[1];
        MessageFormat msgFormat = new MessageFormat(format);
        Format[] formats = msgFormat.getFormats();
        int cntFormats = formats.length;
        String spacer = "";
        for (int i2 = 0; i2 < selLength; ++i2) {
            spacer = spacer + " ";
        }
        Object[] newArgs = new String[cntFormats];
        if (newArgs.length > 0) {
            newArgs[0] = selLength > 0 ? spacer : "\b0\b";
            for (int i3 = 1; i3 < cntFormats; ++i3) {
                newArgs[i3] = "\b" + i3 + "\b";
            }
        }
        if ((i = (tmp = MessageFormat.format(format, newArgs)).indexOf(8)) != -1 && i < tmp.length() - 1 && (j = tmp.indexOf(8, i + 1)) > i + 1 && j < tmp.length() - 1 && (argIndex = Integer.parseInt(sub = tmp.substring(i + 1, j))) < argDisplayNames.length && (argString = argDisplayNames[argIndex]).length() > 0) {
            selStart = i;
            selEnd = selStart + argString.length();
        }
        selStartEnd[0] = argDisplayNames.length == 0 ? selEnd : selStart;
        selStartEnd[1] = selEnd;
    }

    public static String formatSelectedText(String format, String[] argDisplayNames, String text, int[] selStartEnd) {
        int selStart = selStartEnd[0];
        int selEnd = selStartEnd[1];
        if (selStart == -1) {
            selStart = 0;
        }
        if (selEnd == -1) {
            selEnd = text.length();
        }
        String prefix = text.substring(0, selStart);
        String selection = text.substring(selStart, selEnd);
        String suffix = text.substring(selEnd);
        String retValue = FunctionFormat.formatSelectedText(format, argDisplayNames, selection);
        selEnd = selStart + retValue.length();
        selStartEnd[0] = selStart;
        selStartEnd[1] = selEnd;
        FunctionFormat.findNewStartEnd(format, argDisplayNames, selection.length(), selStartEnd);
        return prefix + retValue + suffix;
    }
}

