/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.ExpressionTextPaneCaret;
import com.sas.expressions.visuals.ExpressionTextUndoManager;
import com.sas.expressions.visuals.FunctionFormatInterface;
import com.sas.expressions.visuals.OperationInterface;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class ExpressionTextPane
extends JTextPane {
    private UndoManager _undoManager;
    private Action _undoAction;
    private Action _redoAction;

    public ExpressionTextPane() {
        this.init();
    }

    public ExpressionTextPane(StyledDocument doc) {
        super(doc);
        this.init();
    }

    public Action getUndoAction() {
        return this._undoAction;
    }

    public void undo() {
        this.getUndoAction().actionPerformed(null);
    }

    public boolean isUndoAvailable() {
        return this._undoManager.canUndo();
    }

    public Action getRedoAction() {
        return this._redoAction;
    }

    public void redo() {
        this.getRedoAction().actionPerformed(null);
    }

    public boolean isRedoAvailable() {
        return this._undoManager.canRedo();
    }

    private void init() {
        this.setSelectedTextColor(SystemColor.textHighlightText);
        this.setSelectionColor(SystemColor.textHighlight);
        ExpressionTextPaneCaret caret = new ExpressionTextPaneCaret();
        this.setCaret(caret);
        this._undoManager = new ExpressionTextUndoManager(this);
        this._undoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ExpressionTextPane.this._undoManager.canUndo()) {
                    ExpressionTextPane.this.getToolkit().beep();
                    return;
                }
                try {
                    ExpressionTextPane.this._undoManager.undo();
                    ExpressionTextPane.this.requestFocus();
                }
                catch (CannotUndoException ex) {
                    System.err.println(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
            }
        };
        this._redoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ExpressionTextPane.this._undoManager.canRedo()) {
                    ExpressionTextPane.this.getToolkit().beep();
                    return;
                }
                try {
                    ExpressionTextPane.this._undoManager.redo();
                    ExpressionTextPane.this.requestFocus();
                }
                catch (CannotRedoException ex) {
                    System.err.println(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
            }
        };
        Keymap parentkm = this.getKeymap();
        Keymap childkm = ExpressionTextPane.addKeymap("ExpressionTextKeys", parentkm);
        this.setKeymap(childkm);
        KeyStroke keyUndo = KeyStroke.getKeyStroke(90, 2);
        childkm.addActionForKeyStroke(keyUndo, this.getUndoAction());
        KeyStroke keyRedo = KeyStroke.getKeyStroke(89, 2);
        childkm.addActionForKeyStroke(keyRedo, this.getRedoAction());
    }

    public void dispose() {
        ExpressionTextPane.removeKeymap("ExpressionTextKeys");
    }

    protected synchronized void replaceSelectionWithTextAndUnselect(String text) {
        int iSelectionStart = this.getSelectionStart();
        int iSelectionNewEnd = iSelectionStart + text.length();
        this.replaceSelection(text);
        this.requestFocus();
        this.setCaretPosition(iSelectionNewEnd);
    }

    protected synchronized void replaceSelectionWithText(String text) {
        this.replaceSelection(text);
    }

    public void setSelection(int start, int end) {
        int len = this.getText().length();
        if (end > len) {
            end = len;
        }
        this.requestFocus();
        this.select(start, end);
    }

    public void setCursorPosition(int position) {
        this.setCaretPosition(position);
    }

    protected void updateSelection(int oldStart, int oldEnd, int newStart, int newEnd) {
        int len = this.getText().length();
        newStart = newStart == -1 ? oldStart : (newStart += oldStart);
        newEnd = newEnd == -1 ? oldEnd : (newEnd += oldStart);
        if (newEnd > len) {
            newEnd = len;
        }
        this.requestFocus();
        if (newStart != newEnd) {
            this.select(newStart, newEnd);
        } else {
            this.setCaretPosition(newEnd);
        }
    }

    protected synchronized void wrapSelectionWithText(String textStart, String textEnd) {
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        String text = textStart + selectedText + textEnd;
        this.replaceSelectionWithTextAndUnselect(text);
    }

    protected synchronized void formatSelection(FunctionFormatInterface function) {
        int oldStart = this.getSelectionStart();
        int oldEnd = this.getSelectionEnd();
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        int[] selStartEnd = new int[]{-1, -1};
        String newText = function.formatSelectedText(selectedText, selStartEnd);
        this.replaceSelectionWithText(newText);
        this.updateSelection(oldStart, oldEnd, selStartEnd[0], selStartEnd[1]);
    }

    protected synchronized void insertOperation(OperationInterface operation) {
        int oldStart = this.getSelectionStart();
        int oldEnd = this.getSelectionEnd();
        String selectedText = this.getSelectedText();
        if (selectedText == null) {
            selectedText = "";
        }
        int[] selStartEnd = new int[]{-1, -1};
        String newText = operation.formatSelectedText(selectedText, selStartEnd);
        this.replaceSelectionWithText(newText);
        this.updateSelection(oldStart, oldEnd, selStartEnd[0], selStartEnd[1]);
    }
}

