/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class DoublePartDescriptionPane
extends JScrollPane {
    protected JTextArea _upperTextArea;
    protected JTextArea _lowerTextArea;
    protected JPanel _bothTextAreas;
    private String _upperText = null;
    private String _lowerText = null;
    private boolean _ignoreResize = false;
    boolean _dirty = false;

    public DoublePartDescriptionPane() {
        this.init();
    }

    private void init() {
        this._bothTextAreas = new JPanel(new GridBagLayout());
        this._bothTextAreas.setName("bothTextAreas");
        this._bothTextAreas.setMinimumSize(new Dimension(10, 30));
        this._upperTextArea = this.newTextArea("upperTextArea", "");
        this._lowerTextArea = this.newTextArea("lowerTextArea", "");
        this._bothTextAreas.add((Component)this._upperTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._bothTextAreas.add((Component)this._lowerTextArea, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setViewportView(this._bothTextAreas);
        this.setOpaque(false);
        this.getVerticalScrollBar().setUnitIncrement(14);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.doit();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            void doit() {
                Component test = DoublePartDescriptionPane.this.getViewport().getView();
                if (test != null && !DoublePartDescriptionPane.this._ignoreResize) {
                    DoublePartDescriptionPane.this.refresh();
                }
            }
        });
    }

    public void setIgnoreResize(boolean ignore) {
        this._ignoreResize = ignore;
    }

    public boolean isIgoringResize() {
        return this._ignoreResize;
    }

    public void setUpperText(String upperText) {
        this._upperText = upperText != null ? upperText.trim() : null;
    }

    public void setLowerText(String lowerText) {
        this._lowerText = lowerText != null ? lowerText.trim() : null;
    }

    public void refresh() {
        int rows = 0;
        String text1 = "";
        String text2 = "";
        boolean showUpperText = false;
        if (this._upperText != null && this._upperText.length() > 0) {
            text1 = this._upperText;
            showUpperText = true;
            ++rows;
        }
        boolean showLowerText = false;
        if (this._lowerText != null && this._lowerText.length() > 0 && this._upperText != null && this._lowerText.compareToIgnoreCase(this._upperText) != 0) {
            text2 = this._lowerText;
            showLowerText = true;
            ++rows;
        }
        if (rows == 0) {
            showUpperText = true;
            text1 = " ";
        }
        this._bothTextAreas.removeAll();
        this._upperTextArea = null;
        this._lowerTextArea = null;
        if (showUpperText) {
            this._upperTextArea = this.newTextArea("upperTextArea", text1);
            this._bothTextAreas.add((Component)this._upperTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, rows == 1 ? 1.0 : 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (showLowerText) {
            this._lowerTextArea = this.newTextArea("lowerTextArea", text2);
            this._bothTextAreas.add((Component)this._lowerTextArea, new GridBagConstraints(0, rows, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (rows > 1) {
                Border textborder = this._upperTextArea.getBorder();
                MatteBorder seperator = BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.darkGray);
                this._lowerTextArea.setBorder(BorderFactory.createCompoundBorder(seperator, textborder));
            }
        }
        Runnable threadSafeLaunch = new Runnable(){

            @Override
            public void run() {
                boolean saveIgnore = DoublePartDescriptionPane.this._ignoreResize;
                DoublePartDescriptionPane.this._ignoreResize = true;
                DoublePartDescriptionPane.this.setViewportView(DoublePartDescriptionPane.this._bothTextAreas);
                DoublePartDescriptionPane.this._ignoreResize = saveIgnore;
            }
        };
        SwingUtilities.invokeLater(threadSafeLaunch);
    }

    private JTextArea newTextArea(String name, String text) {
        JTextPane fontpane = new JTextPane();
        Font f = fontpane.getFont();
        JTextArea textArea = new JTextArea(text, 1, 0);
        textArea.setName(name);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setDisabledTextColor(SystemColor.textText);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setMinimumSize(new Dimension(60, 24));
        textArea.setFont(f);
        textArea.setMargin(new Insets(1, 2, 1, 2));
        return textArea;
    }
}

