/*
 * Decompiled with CFR 0.152.
 */
package com.sas.expressions.visuals;

import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DataSourceTreeSelectorEvent;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.DoublePartDescriptionPanel;
import com.sas.expressions.visuals.Mnemonics;
import com.sas.expressions.visuals.RB;
import com.sas.swing.visuals.FlatSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DataSourceTreeSelector
extends JPanel {
    public static final String RB_KEY = "DataSourceTreeSelector.";
    protected JButton JButton_Insert_OnDataSources;
    protected JSplitPane JSplitPane_SourcesAndValues;
    protected JPanel JPanel_LabelAndSources;
    protected JLabel JLabel_Sources;
    protected JScrollPane JScrollPane_Sources;
    protected JTree JTree_Sources;
    protected FlatSplitPane splitCategoriesAndFunctions;
    protected JPanel JPanel_LabelAndValues;
    protected JLabel JLabel_Values;
    protected JScrollPane JScrollPane_Values;
    protected JList JList_Values;
    protected DoublePartDescriptionPanel _descriptionPanel;
    protected boolean _insertButtonVisible = false;
    protected boolean _insertButtonEnabled = false;
    protected String _insertButtonLabel = RB.getStringResource("DataSourceTreeSelector.", "InsertButton.Label.txt");
    protected Icon _insertButtonIcon = null;
    protected String _insertButtonToolTip = RB.getStringResource("DataSourceTreeSelector.", "InsertButton.ToolTip.Initial.txt");
    protected boolean doubleClickInsertEnabled = false;
    protected boolean doubleClickInsertListValueEnabled = true;
    protected boolean doubleClickInsertTreeLeafEnabled = true;
    protected String _dataElementsTreeLabel = RB.getStringResource("DataSourceTreeSelector.", "DataElementsTree.Label.txt");
    protected String _dataValuesLabel = RB.getStringResource("DataSourceTreeSelector.", "DataValuesList.Label.txt");
    protected String _insertButtonToolTipWhenValuePicked = RB.getStringResource("DataSourceTreeSelector.", "InsertButton.ToolTip.ValuePicked.txt");
    protected String _insertButtonToolTipWhenSourcePicked = RB.getStringResource("DataSourceTreeSelector.", "InsertButton.ToolTip.DataSourcePicked.txt");
    protected JButton JButton_LoadValues;
    protected boolean _loadValuesButtonVisible = false;
    protected String _loadValuesButtonLabel = RB.getStringResource("DataSourceTreeSelector.", "LoadValuesButton.Label.txt");
    protected String _loadValuesButtonToolTip = null;
    protected String _loadValuesNodeToolTipMsg = RB.getStringResource("DataSourceTreeSelector.", "LoadValuesButton.FromNode.ToolTip.fmt.txt");
    protected String _loadValuesListToolTipMsg = RB.getStringResource("DataSourceTreeSelector.", "LoadValuesButton.FromList.ToolTip.fmt.txt");
    protected DataSourceNodeInterface selectedDataSourceNode = null;
    protected String _progressLoadingTitle = RB.getStringResource("DataSourceTreeSelector.", "LoadingProgressTitle.txt");
    protected String _cancelLoadingLabel = RB.getStringResource("DataSourceTreeSelector.", "CancelLoadingButtonLabel.txt");
    protected boolean isBusyForExpand = false;
    protected int savedSplitLoc = 100;
    protected Map cachedValuesRead = new HashMap();
    protected Map cachedValuesReadStatus = new HashMap();
    protected Integer VALUESREAD_READING = new Integer(1);
    protected Integer VALUESREAD_CANCELLED = new Integer(2);
    protected Integer VALUESREAD_DONE = new Integer(3);
    protected Thread distinctValuesReaderThread = null;
    protected DataSourceNodeInterface distinctValuesReaderNodeInfo = null;
    protected long _delayLoadingDialog = 1500L;
    private static int GULP_SIZE = 1000;
    private static int MAXIMUM_DRINK = 10000;
    boolean _debugThreads = false;
    JDialog progressDialog = null;
    List _dataSourceTreeSelectorActionEventListeners = new ArrayList();

    public DataSourceTreeSelector() {
        this.init();
    }

    private void init() {
        DataSourceTreeSelector dataSourcesTab = this;
        dataSourcesTab.setVisible(false);
        dataSourcesTab.setBorder(new EmptyBorder(new Insets(2, 2, 2, 4)));
        dataSourcesTab.setLayout(new GridBagLayout());
        dataSourcesTab.setName("JPanel_DataSourcesTab");
        dataSourcesTab.setOpaque(false);
        this.JLabel_Sources = Mnemonics.newMnemonicLabel(this._dataElementsTreeLabel);
        this.JLabel_Sources.setOpaque(false);
        this.JTree_Sources = new JTree();
        this.JTree_Sources.setCellRenderer(new DefaultTreeCellRenderer());
        this.JTree_Sources.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("JTree")));
        this.JTree_Sources.setName("JTree_Sources");
        this.JTree_Sources.setRootVisible(false);
        this.JTree_Sources.setShowsRootHandles(true);
        this.JTree_Sources.setBorder(null);
        this.JTree_Sources.setEnabled(false);
        this.JTree_Sources.getSelectionModel().setSelectionMode(1);
        this.JTree_Sources.setAutoscrolls(true);
        this.JLabel_Sources.setLabelFor(this.JTree_Sources);
        this.JScrollPane_Sources = new JScrollPane(this.JTree_Sources);
        this.JScrollPane_Sources.setName("JScrollPane_Sources");
        this.JPanel_LabelAndSources = new JPanel();
        this.JPanel_LabelAndSources.setLayout(new GridBagLayout());
        this.JPanel_LabelAndSources.setName("JPanel_LabelAndSources");
        this.JPanel_LabelAndSources.setOpaque(false);
        this.JPanel_LabelAndSources.add((Component)this.JLabel_Sources, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 5, 2, 0), 0, 0));
        this.JPanel_LabelAndSources.add((Component)this.JScrollPane_Sources, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 5), 1, 1));
        this.JLabel_Values = Mnemonics.newMnemonicLabel(this._dataValuesLabel);
        this.JLabel_Values.setOpaque(false);
        this.JList_Values = new JList();
        this.JList_Values.setModel(new DefaultListModel());
        this.JList_Values.setName("JList_Values");
        this.JList_Values.setSelectionMode(0);
        this.JList_Values.setBorder(null);
        this.JList_Values.setAutoscrolls(true);
        this.JLabel_Values.setLabelFor(this.JList_Values);
        this.JScrollPane_Values = new JScrollPane(this.JList_Values);
        this.JScrollPane_Values.setName("JScrollPane_Values");
        this.JScrollPane_Values.setAutoscrolls(true);
        this.JPanel_LabelAndValues = new JPanel();
        this.JPanel_LabelAndValues.setLayout(new GridBagLayout());
        this.JPanel_LabelAndValues.setName("JPanel_LabelAndValues");
        this.JPanel_LabelAndValues.setOpaque(false);
        this.JPanel_LabelAndValues.add((Component)this.JLabel_Values, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 7, 2, 0), 0, 0));
        this.JPanel_LabelAndValues.add((Component)this.JScrollPane_Values, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 7, 0, 0), 1, 1));
        this.JPanel_LabelAndSources.setMinimumSize(new Dimension(80, 80));
        this.JPanel_LabelAndSources.setPreferredSize(new Dimension(100, 90));
        this.JPanel_LabelAndValues.setMinimumSize(new Dimension(80, 80));
        this.JPanel_LabelAndValues.setPreferredSize(new Dimension(100, 90));
        this.splitCategoriesAndFunctions = new FlatSplitPane(1);
        this.JSplitPane_SourcesAndValues = this.splitCategoriesAndFunctions.getSplitter();
        this.JSplitPane_SourcesAndValues.setContinuousLayout(true);
        this.JSplitPane_SourcesAndValues.setLeftComponent(this.JPanel_LabelAndSources);
        this.JSplitPane_SourcesAndValues.setRightComponent(this.JPanel_LabelAndValues);
        this.JSplitPane_SourcesAndValues.setDividerSize(3);
        this.JSplitPane_SourcesAndValues.setName("JSplitPane_SourcesAndValues");
        this.JSplitPane_SourcesAndValues.setResizeWeight(0.5);
        this.JSplitPane_SourcesAndValues.setOpaque(false);
        dataSourcesTab.add((Component)this.JSplitPane_SourcesAndValues, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._descriptionPanel = new DoublePartDescriptionPanel();
        this._descriptionPanel.setName("SourceDescriptionTexts");
        dataSourcesTab.add((Component)this._descriptionPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
        this.JButton_LoadValues = Mnemonics.newNmemonicButton(this._loadValuesButtonLabel);
        this.JButton_LoadValues.setName("JButton_LoadValues");
        this.JButton_LoadValues.setVisible(this._loadValuesButtonVisible);
        dataSourcesTab.add((Component)this.JButton_LoadValues, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 2, 2), 0, 0));
        this.JButton_Insert_OnDataSources = Mnemonics.newNmemonicButton(this._insertButtonIcon, this._insertButtonLabel);
        this.JButton_Insert_OnDataSources.setName("JButton_Insert_OnDataSources");
        this.JButton_Insert_OnDataSources.setToolTipText(this._insertButtonToolTip);
        this.JButton_Insert_OnDataSources.setEnabled(this._insertButtonEnabled);
        this.JButton_Insert_OnDataSources.setVisible(this._insertButtonVisible);
        dataSourcesTab.add((Component)this.JButton_Insert_OnDataSources, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 2, 2), 0, 0));
        this.JTree_Sources.setEnabled(false);
        this.JScrollPane_Sources.setEnabled(false);
        this.relayoutValuesPanel();
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component basic = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                String hint = null;
                if (value != null && index != -1 && (hint = DataSourceTreeSelector.this.getTextFromListSelectedObject(value)) != null && hint.trim().length() == 0) {
                    hint = null;
                }
                this.setToolTipText(hint);
                return this;
            }
        };
        this.JList_Values.setCellRenderer(cellRenderer);
        this.JTree_Sources.addTreeExpansionListener(new InnerTreeExpansionListener());
        this.JTree_Sources.addTreeWillExpandListener(new InnerTreeWillExpandListener());
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == DataSourceTreeSelector.this.JTree_Sources) {
                        TreePath path = DataSourceTreeSelector.this.JTree_Sources.getSelectionPath();
                        if (path != null) {
                            DataSourceTreeSelector.this.JTree_Sources.scrollPathToVisible(path);
                        }
                        DataSourceTreeSelector.this.selectedDataSourceNode = null;
                        DataSourceTreeSelector.this.JList_Values.clearSelection();
                        DataSourceTreeSelector.this.JList_Values.setListData(new Vector());
                        boolean enableInsert = false;
                        Object selection = DataSourceTreeSelector.this.getSourceTreeSelectedObject();
                        DataSourceTreeSelector.this._descriptionPanel.setIgnoreRepaint(true);
                        DataSourceTreeSelector.this.enableLoadValuesButton(selection);
                        String description = "";
                        String tooltip = "";
                        if (selection != null) {
                            if (selection instanceof DataSourceNodeInterface) {
                                DataSourceNodeInterface sourceNode = (DataSourceNodeInterface)selection;
                                description = sourceNode.getDescription();
                                tooltip = sourceNode.getToolTip();
                                String insertName = sourceNode.getInsertName();
                                enableInsert = insertName != null;
                            } else if (selection instanceof List) {
                                description = "";
                            }
                        }
                        DataSourceTreeSelector.this.setInsertButtonToolTip(enableInsert ? DataSourceTreeSelector.this._insertButtonToolTipWhenSourcePicked : null);
                        DataSourceTreeSelector.this.setInsertButtonEnabled(enableInsert);
                        DataSourceTreeSelector.this.relayoutValuesPanel();
                        DataSourceTreeSelector.this._descriptionPanel.setIgnoreRepaint(false);
                        DataSourceTreeSelector.this.setDataSourceDescriptionText(tooltip, description);
                        DataSourceTreeSelector.this.fireActionListeners(2003, event.toString(), selection);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JTree_Sources.addTreeSelectionListener(treeSelectionListener);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                try {
                    Object source = event.getSource();
                    if (source == DataSourceTreeSelector.this.JList_Values) {
                        int index = DataSourceTreeSelector.this.JList_Values.getSelectedIndex();
                        if (index != -1) {
                            DataSourceTreeSelector.this.JList_Values.scrollRectToVisible(DataSourceTreeSelector.this.JList_Values.getCellBounds(index, index));
                        }
                        String text = "";
                        Object item = DataSourceTreeSelector.this.JList_Values.getSelectedValue();
                        if (item != null) {
                            text = DataSourceTreeSelector.this.getTextFromListSelectedObject(item);
                        }
                        DataSourceTreeSelector.this.setInsertButtonToolTip(DataSourceTreeSelector.this._insertButtonToolTipWhenValuePicked);
                        DataSourceTreeSelector.this.setInsertButtonEnabled(true);
                        DataSourceTreeSelector.this.setDataSourceDescriptionText(text, null);
                        DataSourceTreeSelector.this.fireActionListeners(2004, event.toString(), item);
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JList_Values.addListSelectionListener(listSelectionListener);
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }

            @Override
            public void mouseEntered(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent event) {
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                try {
                    boolean dblClick;
                    Object source = event.getSource();
                    int modifier = event.getModifiers();
                    boolean button1 = (modifier & 0x10) != 0;
                    boolean bl = dblClick = event.getClickCount() == 2;
                    if (button1 && dblClick) {
                        if (source == DataSourceTreeSelector.this.JList_Values) {
                            Object item;
                            if ((DataSourceTreeSelector.this.isDoubleClickInsertEnabled() || DataSourceTreeSelector.this.isDoubleClickInsertListValueEnabled()) && (item = DataSourceTreeSelector.this.JList_Values.getSelectedValue()) != null) {
                                DataSourceTreeSelector.this.fireActionListeners(2002, event.toString(), item);
                            }
                            return;
                        }
                        if (source == DataSourceTreeSelector.this.JTree_Sources) {
                            Object item;
                            Object selection;
                            boolean doIt = DataSourceTreeSelector.this.isDoubleClickInsertEnabled();
                            if (!doIt && DataSourceTreeSelector.this.isDoubleClickInsertTreeLeafEnabled() && (selection = DataSourceTreeSelector.this.JTree_Sources.getLastSelectedPathComponent()) != null) {
                                doIt = DataSourceTreeSelector.this.JTree_Sources.getModel().isLeaf(selection);
                            }
                            if (doIt && (item = DataSourceTreeSelector.this.getSourceTreeSelectedObject()) != null) {
                                DataSourceTreeSelector.this.fireActionListeners(2001, event.toString(), item);
                            }
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JTree_Sources.addMouseListener(mouseListener);
        this.JList_Values.addMouseListener(mouseListener);
        ActionListener insertButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == DataSourceTreeSelector.this.JButton_Insert_OnDataSources) {
                        Object item = null;
                        item = DataSourceTreeSelector.this.getSelectedObject();
                        if (item != null) {
                            boolean isFunction = DataSourceTreeSelector.this.isSelectionFromList();
                            if (isFunction) {
                                DataSourceTreeSelector.this.fireActionListeners(2002, event.toString(), item);
                            } else {
                                DataSourceTreeSelector.this.fireActionListeners(2001, event.toString(), item);
                            }
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JButton_Insert_OnDataSources.addActionListener(insertButtonActionListener);
        ActionListener loadButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Object source = event.getSource();
                    if (source == DataSourceTreeSelector.this.JButton_LoadValues) {
                        Object selection = DataSourceTreeSelector.this.getSourceTreeSelectedObject();
                        if (selection == null) {
                            return;
                        }
                        if (selection instanceof DataSourceNodeInterface) {
                            DataSourceNodeInterface sourceNode = (DataSourceNodeInterface)selection;
                            if (sourceNode == null) {
                                return;
                            }
                            DataSourceTreeSelector.this.loadDistinctValues(sourceNode);
                            return;
                        }
                        if (selection instanceof List) {
                            Vector data = new Vector((List)selection);
                            DataSourceTreeSelector.this.JList_Values.setListData(data);
                            DataSourceTreeSelector.this.cachedValuesRead.put(selection, data);
                            DataSourceTreeSelector.this.cachedValuesReadStatus.put(selection, DataSourceTreeSelector.this.VALUESREAD_DONE);
                            DataSourceTreeSelector.this.setLoadValuesButtonVisible(false);
                            return;
                        }
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.JButton_LoadValues.addActionListener(loadButtonActionListener);
    }

    public boolean isSourceDescriptionEnabled() {
        return this._descriptionPanel.isVisible();
    }

    public void setSourceDescriptionEnabled(boolean enable) {
        this._descriptionPanel.setVisible(enable);
        if (enable) {
            this.add((Component)this.JButton_Insert_OnDataSources, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(4, 4, 2, 2), 0, 0));
        } else {
            this.add((Component)this.JButton_Insert_OnDataSources, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 2, 2), 0, 0));
        }
    }

    protected Object getSourceTreeSelectedObject() {
        Object selection = this.JTree_Sources.getLastSelectedPathComponent();
        if (selection == null) {
            return null;
        }
        Object nodeInfo = null;
        if (selection instanceof DefaultMutableTreeNode) {
            nodeInfo = ((DefaultMutableTreeNode)selection).getUserObject();
        }
        if (nodeInfo == null) {
            return selection;
        }
        if (nodeInfo instanceof DataSourceNodeInterface) {
            return nodeInfo;
        }
        if (selection instanceof DataSourceNodeInterface) {
            return selection;
        }
        return nodeInfo;
    }

    protected void relayoutValuesPanel() {
        boolean enable;
        ListModel lm = this.JList_Values.getModel();
        boolean bl = enable = lm != null && lm.getSize() > 0;
        if (this.JList_Values.isEnabled() != enable) {
            this.JList_Values.setEnabled(enable);
        }
        if (this.JPanel_LabelAndValues.isEnabled() != enable) {
            this.JPanel_LabelAndValues.setEnabled(enable);
        }
        if (this.JPanel_LabelAndValues.isVisible() != enable) {
            if (this.JPanel_LabelAndValues.isVisible()) {
                this.savedSplitLoc = this.JSplitPane_SourcesAndValues.getDividerLocation();
            }
            this.JPanel_LabelAndValues.setVisible(enable);
            this.splitCategoriesAndFunctions.setVisible(enable);
            if (this.JPanel_LabelAndValues.isVisible()) {
                this.JSplitPane_SourcesAndValues.setDividerLocation(this.savedSplitLoc);
            }
        }
    }

    protected synchronized void loadDistinctValues(DataSourceNodeInterface nodeInfo) {
        this._loadDistinctValuesStart(nodeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _loadDistinctValues(DataSourceNodeInterface nodeInfo) {
        int numReadValues = 0;
        Vector valuesList = new Vector();
        DistinctValuesInterface valuesInterface = nodeInfo.getDistinctValuesInterface();
        if (valuesInterface != null && valuesInterface.supportsDistinctValues()) {
            DataSourceTreeSelector.busyOn(this);
            try {
                List newValues = null;
                newValues = valuesInterface.getDistinctValueSet(GULP_SIZE);
                while (valuesInterface.isThereAnotherDistinctValue() && newValues != null) {
                    numReadValues += newValues.size();
                    valuesList.addAll(newValues);
                    newValues = null;
                    if (numReadValues >= MAXIMUM_DRINK) break;
                    newValues = valuesInterface.getNextDistinctValueSet(GULP_SIZE);
                }
                if (newValues != null) {
                    numReadValues += newValues.size();
                    valuesList.addAll(newValues);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                DataSourceTreeSelector.busyOff(this);
            }
        }
        this.selectedDataSourceNode = nodeInfo;
        String hint = nodeInfo.getDescription();
        if (hint != null && hint.trim().length() == 0) {
            hint = nodeInfo.getDisplayName();
        }
        if (hint != null && hint.trim().length() == 0) {
            hint = null;
        }
        this.JList_Values.setToolTipText(hint);
        this.JList_Values.setListData(new Vector(valuesList));
        this.relayoutValuesPanel();
    }

    protected void _loadDistinctValuesStart(DataSourceNodeInterface nodeInfo) {
        if (this._debugThreads) {
            System.err.println("_loadDistinctValueStart called on " + nodeInfo + " readerThread=" + this.distinctValuesReaderThread);
        }
        if (this.distinctValuesReaderThread != null) {
            return;
        }
        if (nodeInfo == null) {
            return;
        }
        List valuesList = null;
        Integer status = null;
        if (this.cachedValuesRead.containsKey(nodeInfo)) {
            valuesList = (List)this.cachedValuesRead.get(nodeInfo);
            status = (Integer)this.cachedValuesReadStatus.get(nodeInfo);
        } else {
            valuesList = new ArrayList();
        }
        this.selectedDataSourceNode = nodeInfo;
        String hint = this.selectedDataSourceNode.getDescription();
        if (hint != null && hint.trim().length() == 0) {
            hint = this.selectedDataSourceNode.getDisplayName();
        }
        if (hint != null && hint.trim().length() == 0) {
            hint = null;
        }
        this.JList_Values.setToolTipText(hint);
        this.distinctValuesReaderNodeInfo = nodeInfo;
        if (this._debugThreads) {
            System.err.println("_loadDistinctValueStart: Status = " + status);
        }
        if (status == this.VALUESREAD_DONE) {
            if (this._debugThreads) {
                System.err.println("_loadDistinctValueStart: DONE");
            }
            this._loadDistinctValuesFinished();
        } else {
            if (this._debugThreads) {
                System.err.println("_loadDistinctValueStart: LOADNG");
            }
            this.cachedValuesRead.put(nodeInfo, valuesList);
            DistinctValuesInterface valuesInterface = this.distinctValuesReaderNodeInfo.getDistinctValuesInterface();
            if (valuesInterface != null && valuesInterface.supportsDistinctValues()) {
                this.cachedValuesReadStatus.put(nodeInfo, this.VALUESREAD_READING);
                this._loadDistinctValuesLauncher();
            } else {
                this._loadDistinctValuesFinished();
            }
        }
    }

    public void setDelayLoadingDialog(long millisecs) {
        this._delayLoadingDialog = millisecs;
    }

    public long getDelayLoadingDialog() {
        return this._delayLoadingDialog;
    }

    protected void _loadDistinctValuesLauncher() {
        if (this._debugThreads) {
            System.err.println("1. Called _loadDistinctValuesLauncher()");
        }
        this.createProgressDialog();
        this.distinctValuesReaderThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int numReadValuesStarting;
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("A. Starting reader thread");
                }
                DataSourceTreeSelector.busyOn(DataSourceTreeSelector.this);
                Thread.yield();
                DataSourceNodeInterface nodeInfo = DataSourceTreeSelector.this.distinctValuesReaderNodeInfo;
                List valuesList = (List)DataSourceTreeSelector.this.cachedValuesRead.get(nodeInfo);
                int numReadValuesCurrent = numReadValuesStarting = valuesList.size();
                int numReadValuesMaximum = numReadValuesStarting + MAXIMUM_DRINK;
                boolean cancelled = false;
                DistinctValuesInterface valuesInterface = nodeInfo.getDistinctValuesInterface();
                try {
                    int numNewValues;
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("B. Starting to get data");
                    }
                    List newValues = null;
                    newValues = valuesInterface.getDistinctValueSet(GULP_SIZE);
                    while (valuesInterface.isThereAnotherDistinctValue() && newValues != null && numReadValuesCurrent + (numNewValues = newValues.size()) < numReadValuesMaximum) {
                        numReadValuesCurrent += numNewValues;
                        valuesList.addAll(newValues);
                        newValues = null;
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        Thread.yield();
                        newValues = valuesInterface.getNextDistinctValueSet(GULP_SIZE);
                    }
                    if (newValues != null) {
                        numReadValuesCurrent += newValues.size();
                        valuesList.addAll(newValues);
                    } else {
                        if (DataSourceTreeSelector.this._debugThreads) {
                            System.err.println("B... interrupt because read failed");
                        }
                        DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_CANCELLED);
                    }
                    if (Thread.interrupted()) {
                        if (DataSourceTreeSelector.this._debugThreads) {
                            System.err.println("B... interrupt pending during read");
                        }
                        DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_CANCELLED);
                    }
                }
                catch (InterruptedException e) {
                    DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_CANCELLED);
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("B... interrupted");
                    }
                    e.printStackTrace();
                }
                catch (Throwable ex) {
                    DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_CANCELLED);
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("B... exception");
                    }
                    ex.printStackTrace();
                }
                finally {
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("C. Finally done with getting data");
                    }
                    DataSourceTreeSelector.this.distinctValuesReaderThread = null;
                    DataSourceTreeSelector.this.progressDialog.setVisible(false);
                    if (DataSourceTreeSelector.this.cachedValuesReadStatus.get(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo) == DataSourceTreeSelector.this.VALUESREAD_READING) {
                        DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_DONE);
                    }
                    DataSourceTreeSelector.this._loadDistinctValuesFinished();
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("D. Ending reader thread");
                    }
                }
            }
        };
        this.distinctValuesReaderThread.start();
        if (this._delayLoadingDialog > -1L) {
            Runnable threadSafeLaunch = new Runnable(){

                @Override
                public void run() {
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("i. starting show dialog thread: Pausing before showing progressDialog");
                    }
                    try {
                        Thread.sleep(DataSourceTreeSelector.this._delayLoadingDialog);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("ii. launching progressDialog");
                    }
                    DataSourceTreeSelector.this._launchProgressDialog();
                }
            };
            SwingUtilities.invokeLater(threadSafeLaunch);
        }
        if (this._debugThreads) {
            System.err.println("2. Leaving _loadDistinctValuesLauncher()");
        }
    }

    protected void _launchProgressDialog() {
        Runnable threadSafeLaunch = new Runnable(){

            @Override
            public void run() {
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("i. starting launch progressDialog");
                }
                if (DataSourceTreeSelector.this.distinctValuesReaderThread != null) {
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("ii. Value reading not done, showing progressDialog");
                    }
                    DataSourceTreeSelector.this.progressDialog.setVisible(true);
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("iii. progressDialog not visible anymore");
                    }
                    if (DataSourceTreeSelector.this.distinctValuesReaderThread != null) {
                        DataSourceTreeSelector.this.distinctValuesReaderThread.interrupt();
                        if (DataSourceTreeSelector.this._debugThreads) {
                            System.err.println("iiia. killed thread");
                        }
                    }
                    DataSourceTreeSelector.this.progressDialog.dispose();
                }
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("iv. Ending show dialog thread");
                }
            }
        };
        SwingUtilities.invokeLater(threadSafeLaunch);
    }

    protected void _loadDistinctValuesFinished() {
        if (this._debugThreads) {
            System.err.println("?. load finished");
        }
        this.distinctValuesReaderThread = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("a, starting: update components thread");
                }
                Integer status = (Integer)DataSourceTreeSelector.this.cachedValuesReadStatus.get(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo);
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("   updating the list component, status=" + status);
                }
                DataSourceTreeSelector.this.showCachedValues(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo);
                DataSourceTreeSelector.busyOff(DataSourceTreeSelector.this);
                DataSourceTreeSelector.this.setLoadValuesButtonVisible(status != DataSourceTreeSelector.this.VALUESREAD_DONE);
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("b. ending: update components thread");
                }
            }
        });
    }

    protected void showCachedValues(Object node) {
        List valuesList = (List)this.cachedValuesRead.get(node);
        this.JList_Values.setListData(new Vector(valuesList));
        this.relayoutValuesPanel();
    }

    protected void createProgressDialog() {
        Frame frame = DataSourceTreeSelector.getParentFrame(this);
        this.progressDialog = new JDialog(frame, this._progressLoadingTitle, true);
        this.progressDialog.getContentPane().setLayout(new BorderLayout());
        JProgressBar localProgress = new JProgressBar();
        BevelBorder innerBorder = new BevelBorder(1);
        EmptyBorder outerBorder = new EmptyBorder(new Insets(5, 4, 5, 4));
        CompoundBorder fullBorder = new CompoundBorder(outerBorder, innerBorder);
        localProgress.setBorder(fullBorder);
        localProgress.setIndeterminate(true);
        this.progressDialog.getContentPane().add((Component)localProgress, "Center");
        JButton button = Mnemonics.newNmemonicButton(this._cancelLoadingLabel);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("?. cancel pressed");
                }
                DataSourceTreeSelector.this.cachedValuesReadStatus.put(DataSourceTreeSelector.this.distinctValuesReaderNodeInfo, DataSourceTreeSelector.this.VALUESREAD_CANCELLED);
                if (DataSourceTreeSelector.this.distinctValuesReaderThread != null) {
                    DataSourceTreeSelector.this.distinctValuesReaderThread.interrupt();
                    if (DataSourceTreeSelector.this._debugThreads) {
                        System.err.println("??. cancel interrupted reader");
                    }
                }
                if (DataSourceTreeSelector.this._debugThreads) {
                    System.err.println("???. cancel hiding dialog");
                }
                DataSourceTreeSelector.this.progressDialog.setVisible(false);
            }
        });
        JPanel panel = new JPanel();
        panel.add(button);
        this.progressDialog.getContentPane().add((Component)panel, "South");
        this.progressDialog.setLocationRelativeTo(frame);
        this.progressDialog.setResizable(false);
        this.progressDialog.pack();
    }

    private void setLoadValuesButtonVisible(boolean visible) {
        this.JButton_LoadValues.setVisible(visible);
        this.JButton_LoadValues.getParent().validate();
    }

    void enableLoadValuesButton(Object selection) {
        if (selection == null) {
            this.JButton_LoadValues.setVisible(false);
            return;
        }
        Integer status = null;
        if (this.cachedValuesRead.containsKey(selection)) {
            status = (Integer)this.cachedValuesReadStatus.get(selection);
        }
        if (status == this.VALUESREAD_DONE) {
            this.setLoadValuesButtonVisible(false);
            this.showCachedValues(selection);
            return;
        }
        if (status == null) {
            if (selection instanceof DataSourceNodeInterface) {
                DataSourceNodeInterface dsn = (DataSourceNodeInterface)selection;
                DistinctValuesInterface dvi = dsn.getDistinctValuesInterface();
                if (dvi != null && dvi.supportsDistinctValues()) {
                    this.setLoadValuesButtonVisible(true);
                    String msg = this._loadValuesNodeToolTipMsg;
                    Object[] args = new Object[]{((DataSourceNodeInterface)selection).getName()};
                    String hint = MessageFormat.format(msg, args);
                    if (hint != null && hint.trim().length() == 0) {
                        hint = null;
                    }
                    this._loadValuesButtonToolTip = hint;
                    this.JButton_LoadValues.setToolTipText(this._loadValuesButtonToolTip);
                } else {
                    this.setLoadValuesButtonVisible(false);
                }
                return;
            }
            if (selection instanceof List) {
                this.setLoadValuesButtonVisible(true);
                String msg = this._loadValuesListToolTipMsg;
                Object[] args = new Object[]{selection.toString()};
                String hint = MessageFormat.format(msg, args);
                if (hint != null && hint.trim().length() == 0) {
                    hint = null;
                }
                this._loadValuesButtonToolTip = hint;
                this.JButton_LoadValues.setToolTipText(this._loadValuesButtonToolTip);
                return;
            }
        } else {
            this.setLoadValuesButtonVisible(true);
            this.showCachedValues(selection);
            return;
        }
        this.setLoadValuesButtonVisible(false);
    }

    public void addActionEventListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this._dataSourceTreeSelectorActionEventListeners.contains(listener)) {
            return;
        }
        this._dataSourceTreeSelectorActionEventListeners.add(listener);
    }

    public void removeActionEventListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (!this._dataSourceTreeSelectorActionEventListeners.contains(listener)) {
            return;
        }
        this._dataSourceTreeSelectorActionEventListeners.remove(listener);
    }

    protected void fireActionListeners(int id, String action, Object item) {
        DataSourceTreeSelectorEvent event = new DataSourceTreeSelectorEvent((Object)this, id, action, item);
        for (ActionListener listener : this._dataSourceTreeSelectorActionEventListeners) {
            listener.actionPerformed(event);
        }
    }

    public boolean isInsertButtonVisible() {
        return this.JButton_Insert_OnDataSources.isVisible();
    }

    public void setInsertButtonVisible(boolean visible) {
        this.JButton_Insert_OnDataSources.setVisible(visible);
    }

    public void setInsertButtonEnabled(boolean enable) {
        this._insertButtonEnabled = enable;
        this.JButton_Insert_OnDataSources.setEnabled(enable);
    }

    public boolean isInsertButtonEnabled() {
        return this._insertButtonEnabled;
    }

    public void setInsertButtonToolTip(String tooltip) {
        if (tooltip != null && tooltip.trim().length() == 0) {
            tooltip = null;
        }
        this._insertButtonToolTip = tooltip;
        this.JButton_Insert_OnDataSources.setToolTipText(this._insertButtonToolTip);
    }

    public String getInsertButtonToolTip() {
        return this._insertButtonToolTip;
    }

    public void setInsertButtonIcon(Icon icon) {
        this.JButton_Insert_OnDataSources.setIcon(icon);
    }

    public void setInsertButtonLabel(String label) {
        Mnemonics.setMnemonicButton(this.JButton_Insert_OnDataSources, label);
    }

    public void setDoubleClickInsertEnabled(boolean enable) {
        this.doubleClickInsertEnabled = enable;
    }

    public boolean isDoubleClickInsertEnabled() {
        return this.doubleClickInsertEnabled;
    }

    public void setdoubleClickInsertListValueEnabled(boolean enable) {
        this.doubleClickInsertListValueEnabled = enable;
    }

    public boolean isDoubleClickInsertListValueEnabled() {
        return this.doubleClickInsertListValueEnabled;
    }

    public void setDoubleClickInsertTreeLeafEnabled(boolean enable) {
        this.doubleClickInsertTreeLeafEnabled = enable;
    }

    public boolean isDoubleClickInsertTreeLeafEnabled() {
        return this.doubleClickInsertTreeLeafEnabled;
    }

    public String getDataElementsTreeLabel() {
        return this._dataElementsTreeLabel;
    }

    public void setDataElementsTreeLabel(String label) {
        Mnemonics.setMnemonicLabel(this.JLabel_Sources, label);
        this._dataElementsTreeLabel = label;
    }

    public String getDataValuesListLabel() {
        return this._dataValuesLabel;
    }

    public void setDataValuesListLabel(String label) {
        Mnemonics.setMnemonicLabel(this.JLabel_Values, label);
        this._dataValuesLabel = label;
    }

    public TreeModel getDataSourceTreeModel() {
        return this.JTree_Sources.getModel();
    }

    public void setDataSourceTreeModel(TreeModel value) {
        TreeModel tm;
        DataSourceTreeInterface dsti;
        TreeCellRenderer newCellRenderer;
        TreeModel oldValue = this.JTree_Sources.getModel();
        if (oldValue == value) {
            return;
        }
        String toolTip = value == null ? null : (value.getRoot() == null ? value.toString() : value.getRoot().toString());
        if (toolTip != null && toolTip.trim().length() == 0) {
            toolTip = null;
        }
        this.JTree_Sources.setToolTipText(toolTip);
        this.JTree_Sources.setModel(value);
        if (value instanceof DataSourceTreeInterface && (newCellRenderer = (dsti = (DataSourceTreeInterface)value).getJTreeCellRenderer(this.JTree_Sources)) != null) {
            this.JTree_Sources.setCellRenderer(newCellRenderer);
        }
        boolean enable = (tm = this.JTree_Sources.getModel()) != null && tm.getRoot() != null && tm.getChildCount(tm.getRoot()) != 0;
        this.JTree_Sources.setEnabled(enable);
        this.JScrollPane_Sources.setEnabled(enable);
    }

    public Object getSelectedObject() {
        Object item = this.JList_Values.getSelectedValue();
        if (item != null) {
            return item;
        }
        item = this.getSourceTreeSelectedObject();
        if (item != null) {
            return item;
        }
        return null;
    }

    public boolean isSelectionFromList() {
        Object item = this.JList_Values.getSelectedValue();
        return item != null;
    }

    public String getTextFromListSelectedObject(Object item) {
        if (item == null) {
            return null;
        }
        DistinctValuesInterface valuesInterface = null;
        if (this.selectedDataSourceNode != null) {
            valuesInterface = this.selectedDataSourceNode.getDistinctValuesInterface();
        } else {
            Object treeSelection = this.getSourceTreeSelectedObject();
            if (treeSelection != null && treeSelection instanceof DataSourceNodeInterface) {
                DataSourceNodeInterface dataSourceSelection = (DataSourceNodeInterface)treeSelection;
                valuesInterface = dataSourceSelection.getDistinctValuesInterface();
            }
        }
        String text = null;
        text = valuesInterface != null ? valuesInterface.getInsertValue(item) : item.toString();
        return text;
    }

    public String getTextFromTreeSelectedObject(Object item) {
        String insertName = null;
        insertName = item instanceof DataSourceNodeInterface ? ((DataSourceNodeInterface)item).getInsertName() : item.toString();
        return insertName;
    }

    protected void setDataSourceDescriptionText(String infoText, String descText) {
        this._descriptionPanel.setUpperText(infoText);
        this._descriptionPanel.setLowerText(descText);
        this._descriptionPanel.refresh();
    }

    public static final void busyOn(Component awtComponent) {
        DataSourceTreeSelector.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Component awtComponent) {
        DataSourceTreeSelector.getParentFrame(awtComponent).setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JComponent c) {
        c.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(JDialog c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static final void busyOn(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final void busyOff(Frame c) {
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static Frame getParentFrame(Component comp) {
        Frame parentFrame = null;
        Component parent = comp;
        while (parent != null) {
            if (parent instanceof Frame) {
                parentFrame = (Frame)parent;
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
        return parentFrame;
    }

    class InnerTreeExpansionListener
    implements TreeExpansionListener {
        InnerTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (DataSourceTreeSelector.this.isBusyForExpand) {
                DataSourceTreeSelector.busyOff(DataSourceTreeSelector.this);
                DataSourceTreeSelector.this.isBusyForExpand = false;
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }

    class InnerTreeWillExpandListener
    implements TreeWillExpandListener {
        InnerTreeWillExpandListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            if (!DataSourceTreeSelector.this.isBusyForExpand) {
                DataSourceTreeSelector.this.isBusyForExpand = true;
                DataSourceTreeSelector.busyOn(DataSourceTreeSelector.this);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }
}

