/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.ui;

import com.sas.graphics.applets.statgraph.StatGraph;
import java.awt.Shape;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class ImageMap {
    private Region[] regions = new Region[0];

    public ImageMap(Region[] regions) {
        if (regions != null && regions.length > 0) {
            this.regions = regions;
        }
    }

    public Region[] getRegions() {
        return this.regions;
    }

    public static class Region {
        private Shape coords;
        private String href;
        private String alt;

        public Region(Shape coords, String href, String alt) {
            this.coords = coords;
            this.href = href;
            this.alt = alt;
        }

        public Shape getCoords() {
            return this.coords;
        }

        public String getHREF() {
            return Region.cleanString(this.href);
        }

        public String getALT() {
            return Region.cleanString(this.alt);
        }

        static String cleanString(String str) {
            Charset charset;
            if (str == null) {
                return str;
            }
            CharsetEncoder encoder = null;
            if (StatGraph.xmlEncoding != null && (charset = Charset.forName(StatGraph.xmlEncoding)) != null) {
                encoder = charset.newEncoder();
            }
            String newStr = "";
            block7: for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (encoder != null && !encoder.canEncode(c) || encoder == null && Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN) {
                    int code = str.codePointAt(i);
                    newStr = newStr + "&#x" + Integer.toHexString(code) + ";";
                    continue;
                }
                switch (c) {
                    case '&': {
                        newStr = newStr + "&amp;";
                        continue block7;
                    }
                    case '<': {
                        newStr = newStr + "&lt;";
                        continue block7;
                    }
                    case '>': {
                        newStr = newStr + "&gt;";
                        continue block7;
                    }
                    case '\'': {
                        newStr = newStr + "&#39;";
                        continue block7;
                    }
                    case '\"': {
                        newStr = newStr + "&quot;";
                        continue block7;
                    }
                    default: {
                        newStr = newStr + c;
                    }
                }
            }
            return newStr;
        }
    }
}

