/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.legend.AutoContinuousLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class Region
extends JComponent
implements AutoContinuousLegendInterface,
UserDefinedMarkerInterface {
    protected String name = null;
    protected String stmt = null;
    protected String legendLabel = null;
    protected double dataTransparency = 0.0;
    protected boolean useDataTransparency = false;
    protected CRD crd = null;
    protected DataModel dataModel;
    protected HashMap roles = new HashMap();
    protected Variable[] dataTipVars = null;
    protected boolean antialiased = true;
    protected BooleanVector chPipe;
    protected boolean tooltipEnabled = true;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    protected int categoryOrder = 0;
    protected int groupOrder = 0;
    boolean rebuild = true;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected double rotation = 0.0;

    public boolean isConditionalHilited() {
        return this.chPipe != null && !this.chPipe.isEmpty();
    }

    public void setCHPipe(BooleanVector bv) {
        this.chPipe = bv;
    }

    public BooleanVector getCHPipe() {
        return this.chPipe;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getStmt() {
        return this.stmt;
    }

    public void setStmt(String stmt) {
        this.stmt = stmt;
    }

    public double getDataTransparency() {
        return this.dataTransparency;
    }

    public void setDataTransparency(double dataTransparency) {
        this.dataTransparency = dataTransparency;
        this.useDataTransparency = true;
    }

    public Color applyDataTransparency(Color c, FillAttrs fa) {
        double tr = fa.getTransparency() >= 0.0 ? fa.getTransparency() : this.dataTransparency;
        return this.applyTransparency(c, tr);
    }

    public Color applyDataTransparency(Color c) {
        return this.applyTransparency(c, this.dataTransparency);
    }

    public Color applyTransparency(Color c, double tr) {
        if (c == null || tr == 0.0) {
            return c;
        }
        int a = (int)(255.0 * (1.0 - tr));
        Color nc = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        return nc;
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public void setLegendLabel(String legendLabel) {
        this.legendLabel = legendLabel;
    }

    public void addRole(String role, Object colMeta) {
        ColumnMetadata meta = (ColumnMetadata)colMeta;
        ColumnMetadata cmd = new ColumnMetadata(meta.getName(), meta.getType());
        cmd.setLabel(meta.getLabel());
        if (meta.getFormat() != null) {
            cmd.setFormat(meta.getFormat().getName());
        }
        this.roles.put(role, cmd);
    }

    public ColumnMetadata getRoleMetadata(String role) {
        if (!this.roles.containsKey(role)) {
            return null;
        }
        return (ColumnMetadata)this.roles.get(role);
    }

    public void setDataTipVars(Variable[] tips) {
        this.dataTipVars = tips;
    }

    protected Vector computeSelectableShapes() {
        return null;
    }

    public ImageMap getImageMap() {
        if (!this.tooltipEnabled) {
            return null;
        }
        ImageMap imageMap = null;
        Vector selectableShapes = this.computeSelectableShapes();
        if (selectableShapes == null) {
            return null;
        }
        Point location = this.getAbsLocation();
        SelectableShape.translate((Vector)selectableShapes, (int)location.x, (int)location.y);
        if (selectableShapes.size() > 0) {
            String alt = null;
            String href = null;
            ArrayList<ImageMap.Region> rs = new ArrayList<ImageMap.Region>(selectableShapes.size());
            for (int i = selectableShapes.size() - 1; i >= 0; --i) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.elementAt(i);
                SelectResult sr = selectableShape.getSelectResult();
                Shape coords = selectableShape.getShape();
                SelectDetail sd = sr.getDetail();
                alt = this.getTipText(sd);
                href = this.getURL(sd);
                if (alt == null) continue;
                ImageMap.Region r = new ImageMap.Region(coords, href, alt);
                rs.add(r);
            }
            ImageMap.Region[] regions = new ImageMap.Region[rs.size()];
            for (int i = 0; i < rs.size(); ++i) {
                regions[i] = (ImageMap.Region)rs.get(i);
            }
            imageMap = new ImageMap(regions);
        }
        return imageMap;
    }

    protected Point getAbsLocation() {
        Point location = this.getLocation();
        for (Container parent = this.getParent(); parent != null && !(parent instanceof StatGraphPanel) && !(parent instanceof JLayeredPane); parent = parent.getParent()) {
            location.x += parent.getX();
            location.y += parent.getY();
        }
        return location;
    }

    protected String getTipText(SelectDetail sd) {
        return null;
    }

    protected String getURL(SelectDetail sd) {
        return null;
    }

    public void forceResize() {
        this.rebuild = true;
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }

    protected String getWhereExpression() {
        return this.crd.whereExpression;
    }

    protected Variable[] getWhereClauseVars() {
        Vector<StringVectorVariable> vars = new Vector<StringVectorVariable>();
        if (this.crd.whereExpression != null) {
            for (int i = 0; i < this.crd.whereVars.length; ++i) {
                StringVectorVariable sv;
                if (this.crd.whereVars[i] == null) continue;
                Object object = sv = this.crd.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.crd.whereVarsOnSeparateModel) {
                    DataModel dm = this.crd.getSrcModel();
                    int wcol = dm.getColumn(this.crd.whereVars[i].getName());
                    sv.setName(this.crd.whereVars[i].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.crd.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.crd.whereVars[i]);
                }
                vars.add(sv);
            }
        }
        return vars.toArray(new Variable[vars.size()]);
    }

    protected Variable connectCategory(short role, boolean includeMissing) {
        boolean numeric;
        if (!this.crd.isAvailable(role)) {
            return null;
        }
        StringVectorVariable outVar = new StringVectorVariable();
        ColumnMetadata cmd = (ColumnMetadata)this.crd.getColumnLabel(role);
        boolean bl = numeric = this.crd.getColumnClass(role) == Double.class;
        if (numeric) {
            outVar.connectFrom(this.crd.getDoubleAsClassColumn(role, includeMissing));
        } else {
            outVar.connectFrom(this.crd.getStringAsClassColumn(role, includeMissing));
        }
        outVar.setBlankMissing(false);
        outVar.setLabel(this.getLabel(role));
        return outVar;
    }

    protected String getLabel(short role) {
        ColumnMetadata cmd;
        String l;
        Object o = this.crd.getColumnLabel(role);
        if (o instanceof ColumnMetadata && (l = (cmd = (ColumnMetadata)o).getLabel()) != null) {
            return l;
        }
        return o.toString();
    }

    public CRD getCRD() {
        return this.crd;
    }

    public void setCRD(CRD crd) {
        this.crd = crd;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        return null;
    }

    @Override
    public String getDefaultSizeLegendTitle() {
        return null;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    public double getMarkerOffsetX() {
        return this.xOffset;
    }

    public void setMarkerOffsetX(double offset) {
        this.xOffset = offset;
    }

    public double getMarkerOffsetY() {
        return this.yOffset;
    }

    public void setMarkerOffsetY(double offset) {
        this.yOffset = offset;
    }

    public double getMarkerScaleX() {
        return this.xScale;
    }

    public void setMarkerScaleX(double scale) {
        this.xScale = scale;
    }

    public double getMarkerScaleY() {
        return this.yScale;
    }

    public void setMarkerScaleY(double scale) {
        this.yScale = scale;
    }

    public double getMarkerRotation() {
        return this.rotation;
    }

    public void setMarkerRotation(double angle) {
        this.rotation = angle;
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
        int width = (int)(this.xScale * (double)w);
        int height = (int)(this.yScale * (double)h);
        Graphics2D gc = (Graphics2D)g2d.create();
        this.setBounds(0, 0, width, height);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        gc.translate(x - width / 2, y - height / 2);
        this.paint(gc);
        gc.dispose();
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
        int width = (int)(this.xScale * (double)w);
        int height = (int)(this.yScale * (double)h);
        Graphics2D gc = (Graphics2D)g2d.create();
        this.setBounds(0, 0, width, height);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        gc.translate(x - (double)width / 2.0, y - (double)height / 2.0);
        this.paint(gc);
        gc.dispose();
    }

    public int getCategoryOrder() {
        return this.categoryOrder;
    }

    public void setCategoryOrder(int categoryOrder) {
        this.categoryOrder = categoryOrder;
    }

    public int getGroupOrder() {
        return this.groupOrder;
    }

    public void setGroupOrder(int groupOrder) {
        this.groupOrder = groupOrder;
    }
}

