/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.regions.RB;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.LineConnectorDetail;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.gtk.gl.RectangularAxis;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;

public class MosaicRegion
extends Region
implements DiscreteLegendInterface,
AutoLegendInterface,
ContinuousLegendInterface,
MarginInterface {
    public static final String RB_KEY = "MosaicRegion.";
    protected String[] categoryVarNames;
    protected String countVarName;
    protected String colorResponseVarName;
    protected String urlVarName;
    protected Channel channel;
    protected NetworkRoot networkRoot;
    protected StringVectorVariable[] categoryVars = null;
    protected NumericVectorVariable freqVar = null;
    protected NumericVectorVariable freqTipVar = null;
    protected NumericVectorVariable colorResponseVar = null;
    protected StringVectorVariable urlVar = null;
    protected int colorGroupIndex = -1;
    protected DiscreteAttrMapper colorDAM;
    protected RangeAttrMapper colorRAM;
    protected ColorMapper colorMapper;
    protected FillAttrs fillStyle = new FillAttrs();
    protected LineAttrs outlineStyle = new LineAttrs();
    protected TextAttrs dataLabelStyle = new TextAttrs();
    protected TextAttrs insideDataLabelStyle = new TextAttrs();
    protected TextAttrs labelStyle = new TextAttrs();
    protected Color wallColor = null;
    protected java.awt.Rectangle wallRect;
    protected java.awt.Rectangle dataRect;
    protected Insets outerMargin = new Insets(0, 0, 0, 0);
    private LinkedHashMap cat1Count = new LinkedHashMap();
    private HashMap cat1AccumCount = new HashMap();
    private HashMap cat12Count = new HashMap();
    private final String separator = "@:)";
    private int[] laIndices = null;
    private double totalCount = 0.0;
    private NumericVector xAxisTickPos = new NumericVector();
    private NumericVector yAxisTickPos = new NumericVector();
    private NumericVector xCoord = new NumericVector();
    private NumericVector yCoord = new NumericVector();
    private NumericVector xSize = new NumericVector();
    private NumericVector ySize = new NumericVector();
    private NumericVector labelX = new NumericVector();
    private NumericVector labelY = new NumericVector();
    private StringVector splitLabel = new StringVector();
    private StringVector x2AxisLabels = new StringVector();
    private NumericVector x2AxisTickPos = new NumericVector();
    private RectangularAxis xAxis;
    private RectangularAxis x2Axis;
    private RectangularAxis yAxis;
    private boolean fillOn = true;
    private boolean outlineOn = true;
    private boolean percentAxesOn = true;
    private boolean valuesOn = true;
    private boolean labelsOn = true;
    private boolean ticksOn = false;
    public static final int VALUE_AUTO = 0;
    public static final int VALUE_OUTSIDE = 1;
    public static final int VALUE_INSIDE = 2;
    private int valueLocation = 0;
    private boolean firstCategoryFull = true;
    private boolean yAxisLabelCollided = false;
    private boolean verticalOutsideValues = false;
    private boolean horizontalOutsideValuesFitting = true;
    public static final int INSIDE_VALUE_FITTING_NONE = 0;
    public static final int INSIDE_VALUE_FITTING_SPLIT = 1;
    public static final int INSIDE_VALUE_FITTING_SPLITALWAYS = 2;
    private int insideValueFitting = 0;
    private int skinType = 0;
    private int minimumGutter = 3;
    private int[] gutters = null;
    private boolean squared = false;
    private Color missingFillColor = null;
    private Color missingEdgeColor = null;
    private Probe probe;
    private int lineOffset = 0;
    private boolean rebuild = true;
    private boolean useFillTransparency = false;

    public MosaicRegion() {
        this.channel = new Channel((Component)this, 2);
        this.channel.glEnable(29);
        this.channel.glDisable(3);
        this.channel.glDisable(4);
        this.channel.glDisable(1);
        this.networkRoot = new NetworkRoot(this.channel);
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
    }

    public String[] getCategoryVarNames() {
        return this.categoryVarNames;
    }

    public void setCategoryVarNames(String[] by) {
        this.categoryVarNames = by;
    }

    public int getDimension() {
        return this.categoryVarNames.length;
    }

    public String getCountVarName() {
        return this.countVarName;
    }

    public void setCountVarName(String count) {
        this.countVarName = count;
    }

    public String getColorResponseVarName() {
        return this.colorResponseVarName;
    }

    public void setColorResponseVarName(String colorResponseVarName) {
        this.colorResponseVarName = colorResponseVarName;
    }

    public String getURLVarName() {
        return this.urlVarName;
    }

    public void setURLVarName(String urlVarName) {
        this.urlVarName = urlVarName;
    }

    public StringVectorVariable[] getCategoryVars() {
        return this.categoryVars;
    }

    public int getColorGroupIndex() {
        return this.colorGroupIndex;
    }

    public void setColorGroupIndex(int idx) {
        this.colorGroupIndex = idx;
    }

    public RangeAttrMapper getColorRAM() {
        return this.colorRAM;
    }

    public void setColorRAM(RangeAttrMapper colorRAM) {
        this.colorRAM = colorRAM;
    }

    public DiscreteAttrMapper getColorDAM() {
        return this.colorDAM;
    }

    public void setColorDAM(DiscreteAttrMapper colorDAM) {
        this.colorDAM = colorDAM;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillAttrs fillStyle) {
        this.fillStyle = fillStyle;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public void setWallColor(Color wallColor) {
        this.wallColor = wallColor;
    }

    public LineAttrs getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(LineAttrs outlineStyle) {
        this.outlineStyle = outlineStyle;
    }

    public TextAttrs getDataLabelStyle() {
        return this.dataLabelStyle;
    }

    public void setDataLabelStyle(TextAttrs dataLabelStyle) {
        this.dataLabelStyle = dataLabelStyle;
    }

    public TextAttrs getInsideDataLabelStyle() {
        return this.insideDataLabelStyle;
    }

    public void setInsideDataLabelStyle(TextAttrs insideDataLabelStyle) {
        this.insideDataLabelStyle = insideDataLabelStyle;
    }

    public TextAttrs getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextAttrs abelStyle) {
        this.labelStyle = abelStyle;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean fillOn) {
        this.fillOn = fillOn;
    }

    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    public void setOutlineOn(boolean outlineOn) {
        this.outlineOn = outlineOn;
    }

    public boolean isValuesOn() {
        return this.valuesOn;
    }

    public void setValuesOn(boolean valuesOn) {
        this.valuesOn = valuesOn;
    }

    public boolean isLabelsOn() {
        return this.labelsOn;
    }

    public void setLabelsOn(boolean labelsOn) {
        this.labelsOn = labelsOn;
    }

    public boolean isTicksOn() {
        return this.ticksOn;
    }

    public void setTicksOn(boolean ticksOn) {
        this.ticksOn = ticksOn;
    }

    public int getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(int valueLocation) {
        this.valueLocation = valueLocation;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setSkinType(int skinType) {
        this.skinType = skinType;
    }

    public boolean isPercentAxesOn() {
        return this.percentAxesOn;
    }

    public void setPercentAxesOn(boolean percentAxesOn) {
        this.percentAxesOn = percentAxesOn;
    }

    public int getMinimumGutter() {
        return this.minimumGutter;
    }

    public void setMinimumGutter(int minimumGutter) {
        this.minimumGutter = minimumGutter;
    }

    public void setGutters(int[] gutters) {
        this.gutters = gutters;
    }

    public boolean isVerticalOutsideValues() {
        return this.verticalOutsideValues;
    }

    public void setVerticalOutsideValues(boolean verticalOutsideValues) {
        this.verticalOutsideValues = verticalOutsideValues;
    }

    public boolean isHorizontalOutsideValuesFitting() {
        return this.horizontalOutsideValuesFitting;
    }

    public void setHorizontalOutsideValuesFitting(boolean horizontalOutsideValuesFitting) {
        this.horizontalOutsideValuesFitting = horizontalOutsideValuesFitting;
    }

    public int getInsideValueFitting() {
        return this.insideValueFitting;
    }

    public void setInsideValueFitting(int insideValueFitting) {
        this.insideValueFitting = insideValueFitting;
    }

    public boolean isSquared() {
        return this.squared;
    }

    public void setSquared(boolean squared) {
        this.squared = squared;
    }

    public Color getMissingFillColor() {
        return this.missingFillColor;
    }

    public void setMissingFillColor(Color missingColor) {
        this.missingFillColor = missingColor;
    }

    public Color getMissingEdgeColor() {
        return this.missingEdgeColor;
    }

    public void setMissingEdgeColor(Color missingColor) {
        this.missingEdgeColor = missingColor;
    }

    protected void connectVars() {
        int i;
        boolean userGutters;
        boolean bl = userGutters = this.gutters != null;
        if (!userGutters) {
            this.gutters = new int[this.categoryVarNames.length];
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.categoryVarNames != null && this.categoryVarNames.length > 0) {
            this.categoryVars = new StringVectorVariable[this.categoryVarNames.length];
            for (i = 0; i < this.categoryVarNames.length; ++i) {
                if (userGutters) {
                    int n = i;
                    this.gutters[n] = (int)((double)this.gutters[n] * StatGraph.dataDPIScaleFactor);
                } else {
                    this.gutters[this.categoryVarNames.length - i - 1] = (int)(StatGraph.dataDPIScaleFactor * (double)this.minimumGutter) * (i + 1);
                }
                int tvIDX = this.dataModel.getColumn(this.categoryVarNames[i]);
                this.categoryVars[i] = new StringVectorVariable();
                this.categoryVars[i].connectFrom(this.dataModel.getColumnAsClassColumn(tvIDX, true));
                this.categoryVars[i].setBlankMissing(false);
                ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(tvIDX);
                this.categoryVars[i].setLabel(cmd.getLabel());
                this.categoryVars[i].setFormat(new GTKFormat((Format)cmd.getFormat()));
                vp.addGroupVariable((Variable)this.categoryVars[i]);
            }
        }
        if (this.countVarName != null) {
            this.freqVar = new NumericVectorVariable();
            int cvIDX = this.dataModel.getColumn(this.countVarName);
            this.freqVar.connectFrom(this.dataModel.getDoubleColumn(cvIDX));
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(cvIDX);
            this.freqVar.setLabel(cmd.getLabel());
            this.freqVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
            vp.addVariable((Variable)this.freqVar, 0);
            vp.setWhereExpression("^(" + this.freqVar.getName() + " IS MISSING)");
        }
        if (this.colorResponseVarName != null) {
            this.colorResponseVar = new NumericVectorVariable();
            int crIDX = this.dataModel.getColumn(this.colorResponseVarName);
            this.colorResponseVar.connectFrom(this.dataModel.getDoubleColumn(crIDX));
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(crIDX);
            this.colorResponseVar.setLabel(cmd.getLabel());
            this.colorResponseVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
            vp.addVariable((Variable)this.colorResponseVar, 0);
        }
        if (this.urlVarName != null) {
            this.urlVar = new StringVectorVariable();
            int urlIDX = this.dataModel.getColumn(this.urlVarName);
            this.urlVar.connectFrom(this.dataModel.getColumnAsClassColumn(urlIDX, false));
            vp.addVariable((Variable)this.urlVar, 0);
        }
        if (this.dataTipVars != null) {
            for (i = 0; i < this.dataTipVars.length; ++i) {
                vp.addVariable(this.dataTipVars[i], 0);
            }
        }
    }

    private void checkData() {
        VariableProcessor vp = new VariableProcessor();
        StringVectorVariable[] tempCategoryVars = new StringVectorVariable[this.categoryVarNames.length];
        for (int i = 0; i < this.categoryVarNames.length; ++i) {
            int tvIDX = this.dataModel.getColumn(this.categoryVarNames[i]);
            StringVectorVariable tempCategoryVar = new StringVectorVariable();
            tempCategoryVar.connectFrom(this.dataModel.getColumnAsClassColumn(tvIDX, true));
            vp.addGroupVariable((Variable)tempCategoryVar);
        }
        FrequencyVariable freq = new FrequencyVariable();
        vp.addVariable((Variable)freq, 2);
        if (this.countVarName != null) {
            NumericVectorVariable cntVar = new NumericVectorVariable();
            int cvIDX = this.dataModel.getColumn(this.countVarName);
            cntVar.connectFrom(this.dataModel.getDoubleColumn(cvIDX));
            vp.addVariable((Variable)cntVar);
            vp.setWhereExpression("^(" + cntVar.getName() + " IS MISSING)");
        }
        if (freq.getMax() > 1.0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "nonsummarized.txt"));
        }
    }

    @Override
    public void setCRD(CRD crd) {
        super.setCRD(crd);
        this.dataModel = crd.getSrcModel();
        this.checkData();
        this.connectVars();
        this.preprocessData();
        this.summarizeData();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (x == this.getX() && y == this.getY() && w == this.getWidth() && h == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, w, h);
        this.rebuild = true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.rebuild) {
            this.build(g);
            this.rebuild = false;
        }
        if (this.antialiased) {
            this.channel.glEnable(14);
            this.channel.glEnable(13);
        } else {
            this.channel.glDisable(14);
            this.channel.glDisable(13);
        }
        this.channel.setSingleBufferGraphics(g);
        this.networkRoot.draw(this.channel, false);
    }

    private void setupViewport(Dimension d, Graphics g) {
        int depth = Math.max(d.width, d.height);
        double do2 = depth / 2;
        double wo2 = (double)d.width / 2.0;
        double ho2 = (double)d.height / 2.0;
        this.channel.glViewport(0, 0, d.width, d.height);
        this.channel.gluLookAt(wo2, ho2, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.channel.glOrtho(-wo2, wo2, -ho2 - 1.0, ho2, -1000.0 * (double)depth, 1000.0 * (double)depth);
        this.channel.setSingleBufferGraphics(g);
    }

    private void setupCategoryAxisStyle(AxisStyle axisStyle, boolean primary) {
        if (primary) {
            axisStyle.getTitleStyle().setVerticalJustification(0);
        } else {
            axisStyle.getTitleStyle().setVerticalJustification(3);
        }
        axisStyle.setShowThinnedTicks(true);
        axisStyle.getMajorTickStyle().setLength(0.4);
        axisStyle.getMinorTickStyle().setLength(0.2);
        axisStyle.setHorizontalLabelSpace(0.25);
        axisStyle.setVerticalLabelSpace(0.25);
        if (this.ticksOn || this.valuesOn) {
            axisStyle.setTitleSpace(0.25);
        }
        axisStyle.getMajorTickStyle().setColor(this.dataLabelStyle.getColor());
        axisStyle.getLabelStyle().setFont(this.dataLabelStyle.getFont());
        axisStyle.getTitleStyle().setFont(this.labelStyle.getFont());
        axisStyle.getTitleStyle().setColor(this.labelStyle.getColor());
        axisStyle.getMajorTickStyle().setLineWidth((int)StatGraph.dataDPIScaleFactor);
        axisStyle.setMajorTickMarksOn(this.ticksOn);
        axisStyle.setAxisLineOn(false);
        axisStyle.setLabelsOn(this.valuesOn);
        axisStyle.setTitleOn(this.labelsOn);
    }

    private void setupNumericXAxisStyle(AxisStyle axisStyle) {
        axisStyle.getTitleStyle().setVerticalJustification(0);
        axisStyle.setShowThinnedTicks(true);
        axisStyle.getMajorTickStyle().setLength(0.4);
        axisStyle.getMinorTickStyle().setLength(0.2);
        axisStyle.setHorizontalLabelSpace(0.25);
        axisStyle.setVerticalLabelSpace(0.25);
        axisStyle.setTitleSpace(0.25);
        axisStyle.getMajorTickStyle().setColor(this.dataLabelStyle.getColor());
        axisStyle.getLabelStyle().setFont(this.dataLabelStyle.getFont());
        axisStyle.getTitleStyle().setFont(this.labelStyle.getFont());
        axisStyle.getTitleStyle().setColor(this.labelStyle.getColor());
        axisStyle.setLabelsOn(this.valuesOn);
        axisStyle.setTitleOn(this.labelsOn);
    }

    private void setupYAxisStyle(AxisStyle axisStyle) {
        axisStyle.getTitleStyle().setHorizontalJustification(2);
        axisStyle.setShowThinnedTicks(true);
        axisStyle.getMajorTickStyle().setLength(0.4);
        axisStyle.getMinorTickStyle().setLength(0.2);
        axisStyle.setHorizontalLabelSpace(0.25);
        axisStyle.setVerticalLabelSpace(0.25);
        if (this.ticksOn || this.valuesOn) {
            axisStyle.setTitleSpace(0.5);
        }
        axisStyle.getTitleStyle().setAngle(90.0);
        axisStyle.getTitleStyle().setVerticalJustification(1);
        axisStyle.getMajorTickStyle().setColor(this.dataLabelStyle.getColor());
        if (this.verticalOutsideValues && !this.percentAxesOn) {
            axisStyle.getLabelStyle().setAngle(90.0);
        }
        axisStyle.getLabelStyle().setFont(this.dataLabelStyle.getFont());
        axisStyle.getTitleStyle().setFont(this.labelStyle.getFont());
        axisStyle.getTitleStyle().setColor(this.labelStyle.getColor());
        axisStyle.setAxisLineOn(this.percentAxesOn);
        if (this.isLabelsInside()) {
            axisStyle.setMajorTickMarksOn(false);
            axisStyle.setLabelsOn(false);
            axisStyle.setTitleOn(this.labelsOn);
        } else {
            axisStyle.setMajorTickMarksOn(this.ticksOn);
            axisStyle.setLabelsOn(this.valuesOn);
            axisStyle.setTitleOn(this.labelsOn);
        }
    }

    private StringVector getPercentLabelVector() {
        StringVector sv = new StringVector();
        sv.addValue("0%");
        sv.addValue("20%");
        sv.addValue("40%");
        sv.addValue("60%");
        sv.addValue("80%");
        sv.addValue("100%");
        return sv;
    }

    private NumericVector getPercentOffsetVector(int len) {
        NumericVector nv = new NumericVector();
        nv.addValue(0.0);
        nv.addValue(0.2 * (double)len);
        nv.addValue(0.4 * (double)len);
        nv.addValue(0.6 * (double)len);
        nv.addValue(0.8 * (double)len);
        nv.addValue((double)len);
        return nv;
    }

    private void setup1DAxes(Dimension d) {
        ContinuousRangeToNumericMap nm = new ContinuousRangeToNumericMap();
        this.xAxis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
        if (this.percentAxesOn) {
            this.x2Axis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
            this.x2Axis.setPrimary(false);
        }
        this.layoutTiles();
        this.xAxis.setLength((double)d.width);
        if (this.x2Axis != null) {
            this.x2Axis.setLength((double)d.width);
        }
        this.layoutTiles();
        this.xAxis.setLineOffset((double)this.lineOffset);
        if (this.horizontalOutsideValuesFitting) {
            this.xAxis.setFitAlgorithm(new String[]{"angle315"});
        } else {
            this.xAxis.setForceFitAlgorithm("");
        }
        if (this.x2Axis != null) {
            this.x2Axis.setLineOffset((double)this.lineOffset);
            if (this.horizontalOutsideValuesFitting) {
                this.x2Axis.setFitAlgorithm(new String[]{"angle45"});
            } else {
                this.x2Axis.setForceFitAlgorithm("");
            }
        }
        this.xAxis.labelColor.setValue(this.dataLabelStyle.getColor());
        if (this.percentAxesOn) {
            this.setupNumericXAxisStyle(this.xAxis.getStyle());
            this.xAxis.labels.connectFrom((StringPipe)this.getPercentLabelVector());
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(d.width));
            this.setupCategoryAxisStyle(this.x2Axis.getStyle(), false);
            this.x2Axis.title.setValue(this.categoryVars[0].getLabel());
            this.x2Axis.labels.connectFrom(this.categoryVars[0].uniqueValue);
            this.x2Axis.labelOffset.connectFrom((NumericPipe)this.xAxisTickPos);
        } else {
            this.setupCategoryAxisStyle(this.xAxis.getStyle(), true);
            this.xAxis.title.setValue(this.categoryVars[0].getLabel());
            this.xAxis.labels.connectFrom(this.categoryVars[0].uniqueValue);
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.xAxisTickPos);
        }
    }

    private void setup2DAxes(Dimension d) {
        ContinuousRangeToNumericMap nm = new ContinuousRangeToNumericMap();
        if (this.squared) {
            int size = Math.min(d.width, d.height);
            this.xAxis = RectangularAxis.getXAxis((NumericMap)nm, (double)size);
            this.yAxis = RectangularAxis.getYAxis((NumericMap)nm, (double)size);
            if (this.percentAxesOn) {
                this.x2Axis = RectangularAxis.getXAxis((NumericMap)nm, (double)size);
                this.x2Axis.setPrimary(false);
                this.valueLocation = 2;
            }
        } else {
            this.xAxis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
            this.yAxis = RectangularAxis.getYAxis((NumericMap)nm, (double)d.height);
            if (this.percentAxesOn) {
                this.x2Axis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
                this.x2Axis.setPrimary(false);
                this.valueLocation = 2;
            }
        }
        if (this.valueLocation == 1) {
            if (this.verticalOutsideValues) {
                this.yAxis.setForceFitAlgorithm("angle90");
            } else {
                this.yAxis.setForceFitAlgorithm("");
            }
        } else {
            this.yAxis.setFitAlgorithm(new String[]{"thin"});
        }
        this.yAxis.setLineOffset((double)this.lineOffset);
        this.layoutTiles();
        this.setupYAxisStyle(this.yAxis.getStyle());
        this.yAxis.labelColor.setValue(this.dataLabelStyle.getColor());
        if (this.percentAxesOn) {
            this.yAxis.labels.connectFrom((StringPipe)this.getPercentLabelVector());
            this.yAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(d.height));
        } else {
            this.yAxis.title.setValue(this.categoryVars[1].getLabel());
            this.yAxis.labels.connectFrom(this.categoryVars[1].formattedUniqueValue);
            this.yAxis.labelOffset.connectFrom((NumericPipe)this.yAxisTickPos);
        }
        this.xAxis.setLength((double)d.width - this.yAxis.getMetrics(this.channel).getWidth());
        if (this.x2Axis != null) {
            if (this.yAxis != null) {
                this.x2Axis.setLength((double)d.width - this.yAxis.getMetrics(this.channel).getWidth());
            } else {
                this.x2Axis.setLength((double)d.width);
            }
        }
        this.layoutTiles();
        this.xAxis.setLineOffset((double)this.lineOffset);
        if (this.horizontalOutsideValuesFitting) {
            this.xAxis.setFitAlgorithm(new String[]{"angle315"});
        } else {
            this.xAxis.setForceFitAlgorithm("");
        }
        if (this.x2Axis != null) {
            this.x2Axis.setLineOffset((double)this.lineOffset);
            if (this.horizontalOutsideValuesFitting) {
                this.x2Axis.setFitAlgorithm(new String[]{"angle45"});
            } else {
                this.x2Axis.setForceFitAlgorithm("");
            }
        }
        this.xAxis.labelColor.setValue(this.dataLabelStyle.getColor());
        if (this.percentAxesOn) {
            this.setupNumericXAxisStyle(this.xAxis.getStyle());
            this.xAxis.labels.connectFrom((StringPipe)this.getPercentLabelVector());
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(d.width));
            this.setupCategoryAxisStyle(this.x2Axis.getStyle(), false);
            this.x2Axis.title.setValue(this.categoryVars[0].getLabel());
            this.x2Axis.labels.connectFrom(this.categoryVars[0].uniqueValue);
            this.x2Axis.labelOffset.connectFrom((NumericPipe)this.xAxisTickPos);
        } else {
            this.setupCategoryAxisStyle(this.xAxis.getStyle(), true);
            this.xAxis.title.setValue(this.categoryVars[0].getLabel());
            this.xAxis.labels.connectFrom(this.categoryVars[0].uniqueValue);
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.xAxisTickPos);
        }
    }

    private void setup3DAxes(Dimension d) {
        ContinuousRangeToNumericMap nm = new ContinuousRangeToNumericMap();
        this.valueLocation = 1;
        if (this.squared) {
            int size = Math.min(d.width, d.height);
            this.xAxis = RectangularAxis.getXAxis((NumericMap)nm, (double)size);
            this.x2Axis = RectangularAxis.getXAxis((NumericMap)nm, (double)size);
            this.x2Axis.setPrimary(false);
            this.yAxis = RectangularAxis.getYAxis((NumericMap)nm, (double)size);
        } else {
            this.xAxis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
            this.x2Axis = RectangularAxis.getXAxis((NumericMap)nm, (double)d.width);
            this.x2Axis.setPrimary(false);
            this.yAxis = RectangularAxis.getYAxis((NumericMap)nm, (double)d.height);
        }
        if (this.verticalOutsideValues) {
            this.yAxis.setForceFitAlgorithm("angle90");
        } else {
            this.yAxis.setForceFitAlgorithm("");
        }
        this.yAxis.setLineOffset((double)this.lineOffset);
        this.layoutTiles();
        this.setupYAxisStyle(this.yAxis.getStyle());
        this.yAxis.labelColor.setValue(this.dataLabelStyle.getColor());
        this.yAxis.title.setValue(this.categoryVars[1].getLabel());
        this.yAxis.labels.connectFrom(this.categoryVars[1].formattedUniqueValue);
        this.yAxis.labelOffset.connectFrom((NumericPipe)this.yAxisTickPos);
        this.xAxis.setLength((double)d.width - this.yAxis.getMetrics(this.channel).getWidth());
        this.x2Axis.setLength((double)d.width - this.yAxis.getMetrics(this.channel).getWidth());
        this.layoutTiles();
        this.xAxis.setLineOffset((double)this.lineOffset);
        this.x2Axis.setLineOffset((double)this.lineOffset);
        if (this.horizontalOutsideValuesFitting) {
            this.xAxis.setFitAlgorithm(new String[]{"angle315"});
            this.x2Axis.setFitAlgorithm(new String[]{"angle45"});
        } else {
            this.xAxis.setForceFitAlgorithm("");
            this.x2Axis.setForceFitAlgorithm("");
        }
        this.xAxis.labelColor.setValue(this.dataLabelStyle.getColor());
        this.setupCategoryAxisStyle(this.xAxis.getStyle(), true);
        this.xAxis.title.setValue(this.categoryVars[0].getLabel());
        this.xAxis.labels.connectFrom(this.categoryVars[0].uniqueValue);
        this.xAxis.labelOffset.connectFrom((NumericPipe)this.xAxisTickPos);
        this.x2Axis.labelColor.setValue(this.dataLabelStyle.getColor());
        this.setupCategoryAxisStyle(this.x2Axis.getStyle(), false);
        this.x2Axis.title.setValue(this.categoryVars[2].getLabel());
        this.x2Axis.labels.connectFrom((StringPipe)this.x2AxisLabels);
        this.x2Axis.labelOffset.connectFrom((NumericPipe)this.x2AxisTickPos);
    }

    private void setupAxes(Dimension d) {
        switch (this.getDimension()) {
            case 1: {
                this.setup1DAxes(d);
                break;
            }
            case 2: {
                this.setup2DAxes(d);
                break;
            }
            case 3: {
                this.setup3DAxes(d);
            }
        }
    }

    private boolean isLabelsInside() {
        if (!this.valuesOn || this.getDimension() != 2) {
            return false;
        }
        return this.valueLocation == 2 || this.valueLocation == 0 && (this.yAxisLabelCollided || !this.firstCategoryFull);
    }

    private ColorPipe getColorPipe() {
        ColorMapper colorPipe = null;
        if (this.colorMapper != null) {
            double fillTransparency;
            if (this.colorGroupIndex >= 0) {
                ((StringToColorMapper)this.colorMapper).input.connectFrom(this.categoryVars[this.colorGroupIndex].value);
            } else {
                ((ContinuousRangeToColorMapper)this.colorMapper).input.connectFrom(this.colorResponseVar.value);
            }
            double d = fillTransparency = this.fillStyle.getTransparency() >= 0.0 ? this.fillStyle.getTransparency() : this.dataTransparency;
            if (this.colorRAM != null) {
                double max;
                int crIDX = this.dataModel.getColumn(this.colorResponseVarName);
                ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(crIDX);
                double min = cmd.getMin();
                String error = this.colorRAM.createColorMapper(min, max = cmd.getMax());
                if (error != null) {
                    StatGraph.printWarning(error);
                } else {
                    if (this.fillOn) {
                        this.colorRAM.setTransparency(fillTransparency);
                    } else {
                        this.colorRAM.setTransparency(this.dataTransparency);
                    }
                    this.colorRAM.variable = this.colorResponseVar.value;
                    colorPipe = this.colorRAM.color;
                }
            } else if (this.colorDAM != null) {
                this.colorDAM.setFillTransparency(fillTransparency);
                this.colorDAM.setUseFillTransparency(this.useFillTransparency);
                this.colorDAM.setLineTransparency(this.dataTransparency);
                this.colorDAM.variable = this.categoryVars[this.colorGroupIndex].value;
                this.colorDAM.fillColorMapper = this.colorMapper;
                this.colorDAM.lineColorMapper = this.colorMapper;
                colorPipe = this.fillOn ? this.colorDAM.fillColor : this.colorDAM.lineColor;
            } else {
                colorPipe = this.colorMapper;
            }
        }
        return colorPipe;
    }

    private ColorPipe getEdgeColorPipe() {
        ColorVector cv = new ColorVector();
        for (int i = 0; i < this.freqVar.getValueCount(); ++i) {
            try {
                double f = this.freqVar.value.getValue(i);
                if (f == 0.0) {
                    cv.addValue(this.applyDataTransparency(this.missingEdgeColor));
                    continue;
                }
                cv.addValue(this.applyDataTransparency(this.outlineStyle.getColor()));
                continue;
            }
            catch (MissingValueException mve) {
                cv.addValue(this.applyDataTransparency(this.missingEdgeColor));
            }
        }
        return cv;
    }

    private void calcBBox(Dimension d) {
        if (this.getDimension() > 1 && this.squared) {
            int yoff;
            int xoff;
            boolean yShorter = true;
            int size = d.width - this.outerMargin.left - this.outerMargin.right - 1;
            if (d.height - this.outerMargin.top - this.outerMargin.bottom < size) {
                size = d.height - this.outerMargin.top - this.outerMargin.bottom;
                yShorter = false;
            }
            int n = xoff = yShorter ? 0 : (d.width - size) / 2 - this.outerMargin.left;
            if (xoff < 0) {
                xoff = 0;
            }
            int n2 = yoff = yShorter ? (d.height - size) / 2 - this.outerMargin.bottom : 0;
            if (yoff < 0) {
                yoff = 0;
            }
            this.wallRect = new java.awt.Rectangle(this.outerMargin.left + xoff, this.outerMargin.bottom + yoff, size, size);
        } else {
            this.wallRect = new java.awt.Rectangle(this.outerMargin.left, this.outerMargin.bottom, d.width - this.outerMargin.left - this.outerMargin.right - 1, d.height - this.outerMargin.top - this.outerMargin.bottom);
        }
        this.dataRect = new java.awt.Rectangle(this.wallRect.x + this.lineOffset, this.wallRect.y + this.lineOffset, this.wallRect.width - 2 * this.lineOffset, this.wallRect.height - 2 * this.lineOffset);
    }

    private Rectangle createWall() {
        Rectangle wall = new Rectangle();
        wall.set2D(true);
        wall.fillOn.setValue(true);
        wall.edgeOn.setValue(false);
        wall.color.setValue(this.wallColor);
        wall.transform.translateX.setValue((double)this.dataRect.x);
        wall.transform.translateY.setValue((double)this.dataRect.y);
        wall.sizeX.setValue((double)this.dataRect.width);
        wall.sizeY.setValue((double)this.dataRect.height);
        wall.origin.setValue(5);
        return wall;
    }

    private Rectangle createTile() {
        Rectangle tile = new Rectangle();
        tile.set2D(true);
        tile.fillOn.setValue(this.fillOn);
        tile.edgeOn.setValue(this.outlineOn);
        ColorPipe cp = this.getColorPipe();
        if (cp != null) {
            tile.color.connectFrom(cp);
        } else {
            tile.color.setValue(this.applyDataTransparency(this.fillStyle.getColor(), this.fillStyle));
        }
        if (this.fillOn) {
            tile.edgeColor.setValue(this.applyDataTransparency(this.outlineStyle.getColor()));
        } else if (cp != null) {
            tile.edgeColor.connectFrom(cp);
        } else {
            tile.edgeColor.setValue(this.applyDataTransparency(this.outlineStyle.getColor()));
        }
        tile.edgePattern.setValue(this.outlineStyle.getLinePattern());
        tile.edgeWidth.setValue(this.outlineStyle.getWidth());
        tile.transform.translateX.setValue((double)(this.wallRect.x + this.lineOffset));
        tile.transform.translateY.setValue((double)(this.wallRect.y + this.lineOffset));
        tile.coordX.connectFrom((NumericPipe)this.xCoord);
        tile.sizeX.connectFrom((NumericPipe)this.xSize);
        if (this.getDimension() == 1) {
            tile.coordY.setValue(0.0);
            tile.sizeY.setValue((double)this.dataRect.height);
        } else {
            tile.coordY.connectFrom((NumericPipe)this.yCoord);
            tile.sizeY.connectFrom((NumericPipe)this.ySize);
        }
        tile.origin.setValue(5);
        tile.setUserData((Object)this.probe);
        return tile;
    }

    private void build1DNetwork(Dimension d, Graphics g) {
        this.networkRoot.addElement((Element)this.xAxis);
        AxisMetrics xam = this.xAxis.getMetrics(this.channel);
        AxisMetrics x2am = null;
        if (this.x2Axis != null) {
            this.networkRoot.addElement((Element)this.x2Axis);
            x2am = this.x2Axis.getMetrics(this.channel);
        }
        this.outerMargin.left = (int)xam.getLowExtender();
        this.outerMargin.top = this.x2Axis == null ? 0 : (int)x2am.getHeight();
        this.outerMargin.right = (int)xam.getHighExtender();
        this.outerMargin.bottom = (int)xam.getHeight();
        this.calcBBox(d);
        this.xAxis.setLength(this.dataRect.getWidth());
        if (this.x2Axis != null) {
            this.x2Axis.setLength(this.dataRect.getWidth());
        }
        this.xAxis.setForceFitAlgorithm(xam.getFittingAlgorithm());
        this.layoutTiles();
        if (this.wallColor != null) {
            this.networkRoot.addElement((Element)this.createWall());
        }
        this.xAxis.transform.translateX.setValue((double)this.wallRect.x);
        this.xAxis.transform.translateY.setValue((double)this.wallRect.y);
        if (this.percentAxesOn) {
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(this.dataRect.width));
            this.x2Axis.transform.translateX.setValue((double)this.wallRect.x);
            this.x2Axis.transform.translateY.setValue((double)(this.wallRect.y + this.wallRect.height));
        }
        this.networkRoot.addElement((Element)this.createTile());
    }

    private void build2DNetwork(Dimension d, Graphics g) {
        this.networkRoot.addElement((Element)this.xAxis);
        this.networkRoot.addElement((Element)this.yAxis);
        AxisMetrics xam = this.xAxis.getMetrics(this.channel);
        AxisMetrics yam = this.yAxis.getMetrics(this.channel);
        this.yAxisLabelCollided = !yam.getFittingAlgorithm().equals("");
        AxisMetrics x2am = null;
        if (this.x2Axis != null) {
            this.networkRoot.addElement((Element)this.x2Axis);
            x2am = this.x2Axis.getMetrics(this.channel);
        }
        if (this.isLabelsInside()) {
            this.outerMargin.left = x2am != null ? Math.max((int)xam.getLowExtender(), (int)x2am.getLowExtender()) : (int)xam.getLowExtender();
            if (this.percentAxesOn || this.labelsOn) {
                this.outerMargin.left = Math.max(this.outerMargin.left, (int)yam.getWidth());
            }
            this.outerMargin.top = x2am != null ? (int)x2am.getHeight() : 0;
            this.outerMargin.right = x2am != null ? Math.max((int)xam.getHighExtender(), (int)x2am.getHighExtender()) : (int)xam.getHighExtender();
            this.outerMargin.bottom = (int)xam.getHeight();
        } else {
            this.outerMargin.left = Math.max((int)yam.getWidth(), (int)xam.getLowExtender());
            if (this.x2Axis != null) {
                this.outerMargin.left = Math.max(this.outerMargin.left, (int)x2am.getLowExtender());
            }
            this.outerMargin.top = (int)yam.getHighExtender();
            if (this.x2Axis != null) {
                this.outerMargin.top = Math.max(this.outerMargin.top, (int)x2am.getHeight());
            }
            this.outerMargin.right = (int)xam.getHighExtender();
            if (this.x2Axis != null) {
                this.outerMargin.right = Math.max(this.outerMargin.right, (int)x2am.getHighExtender());
            }
            this.outerMargin.bottom = Math.max((int)xam.getHeight(), (int)yam.getLowExtender());
        }
        this.calcBBox(d);
        this.xAxis.setLength(this.dataRect.getWidth());
        this.yAxis.setLength(this.dataRect.getHeight());
        if (this.x2Axis != null) {
            this.x2Axis.setLength(this.dataRect.getWidth());
        }
        this.xAxis.setForceFitAlgorithm(xam.getFittingAlgorithm());
        this.layoutTiles();
        if (this.wallColor != null) {
            this.networkRoot.addElement((Element)this.createWall());
        }
        this.xAxis.transform.translateX.setValue((double)this.wallRect.x);
        this.xAxis.transform.translateY.setValue((double)this.wallRect.y);
        this.yAxis.transform.translateX.setValue((double)this.wallRect.x);
        this.yAxis.transform.translateY.setValue((double)this.wallRect.y);
        if (this.percentAxesOn) {
            this.yAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(this.dataRect.height));
            this.xAxis.labelOffset.connectFrom((NumericPipe)this.getPercentOffsetVector(this.dataRect.width));
            this.x2Axis.transform.translateX.setValue((double)this.wallRect.x);
            this.x2Axis.transform.translateY.setValue((double)(this.wallRect.y + this.wallRect.height));
        }
        this.networkRoot.addElement((Element)this.createTile());
        if (this.isLabelsInside()) {
            RasterLabel label = new RasterLabel();
            if (this.insideValueFitting != 0) {
                label.string.connectFrom((StringPipe)this.splitLabel);
            } else {
                label.string.connectFrom(this.categoryVars[1].uniqueValue);
            }
            label.transform.translateX.setValue((double)(this.wallRect.x + this.lineOffset));
            label.transform.translateY.setValue((double)(this.wallRect.y + this.lineOffset));
            label.coordX.connectFrom((NumericPipe)this.labelX);
            label.coordY.connectFrom((NumericPipe)this.labelY);
            label.horizontalJustification.setValue(1);
            label.verticalJustification.setValue(1);
            label.color.setValue(this.applyDataTransparency(this.insideDataLabelStyle.getColor()));
            label.fontName.setValue(this.insideDataLabelStyle.getFont().getName());
            label.fontSize.setValue(this.insideDataLabelStyle.getFont().getSize());
            label.fontStyle.setValue(this.insideDataLabelStyle.getFont().getStyle());
            this.networkRoot.addElement((Element)label);
        }
    }

    private void build3DNetwork(Dimension d, Graphics g) {
        this.networkRoot.addElement((Element)this.xAxis);
        this.networkRoot.addElement((Element)this.yAxis);
        this.networkRoot.addElement((Element)this.x2Axis);
        AxisMetrics xam = this.xAxis.getMetrics(this.channel);
        AxisMetrics yam = this.yAxis.getMetrics(this.channel);
        AxisMetrics x2am = this.x2Axis.getMetrics(this.channel);
        this.outerMargin.left = Math.max((int)yam.getWidth(), (int)xam.getLowExtender());
        this.outerMargin.left = Math.max(this.outerMargin.left, (int)x2am.getLowExtender());
        this.outerMargin.top = Math.max((int)yam.getHighExtender(), (int)x2am.getHeight());
        this.outerMargin.right = Math.max((int)xam.getHighExtender(), (int)x2am.getHighExtender());
        this.outerMargin.bottom = Math.max((int)xam.getHeight(), (int)yam.getLowExtender());
        this.calcBBox(d);
        this.xAxis.setLength(this.dataRect.getWidth());
        this.yAxis.setLength(this.dataRect.getHeight());
        this.x2Axis.setLength(this.dataRect.getWidth());
        String oldXFit = xam.getFittingAlgorithm();
        String oldX2Fit = x2am.getFittingAlgorithm();
        String oldYFit = yam.getFittingAlgorithm();
        this.layoutTiles();
        xam = this.xAxis.getMetrics(this.channel);
        x2am = this.x2Axis.getMetrics(this.channel);
        yam = this.yAxis.getMetrics(this.channel);
        if (xam.getFittingAlgorithm().equals(oldXFit) && x2am.getFittingAlgorithm().equals(oldX2Fit) && yam.getFittingAlgorithm().equals(oldYFit)) {
            this.xAxis.setForceFitAlgorithm(xam.getFittingAlgorithm());
            this.x2Axis.setForceFitAlgorithm(x2am.getFittingAlgorithm());
            this.yAxis.setForceFitAlgorithm(yam.getFittingAlgorithm());
        } else {
            this.outerMargin.left = Math.max((int)yam.getWidth(), (int)xam.getLowExtender());
            this.outerMargin.left = Math.max(this.outerMargin.left, (int)x2am.getLowExtender());
            this.outerMargin.top = Math.max((int)yam.getHighExtender(), (int)x2am.getHeight());
            this.outerMargin.right = Math.max((int)xam.getHighExtender(), (int)x2am.getHighExtender());
            this.outerMargin.bottom = Math.max((int)xam.getHeight(), (int)yam.getLowExtender());
            this.calcBBox(d);
            this.xAxis.setLength(this.dataRect.getWidth());
            this.yAxis.setLength(this.dataRect.getHeight());
            this.x2Axis.setLength(this.dataRect.getWidth());
            this.xAxis.setForceFitAlgorithm(xam.getFittingAlgorithm());
            this.x2Axis.setForceFitAlgorithm(x2am.getFittingAlgorithm());
            this.yAxis.setForceFitAlgorithm(yam.getFittingAlgorithm());
            this.layoutTiles();
        }
        if (this.wallColor != null) {
            this.networkRoot.addElement((Element)this.createWall());
        }
        this.xAxis.transform.translateX.setValue((double)this.wallRect.x);
        this.xAxis.transform.translateY.setValue((double)this.wallRect.y);
        this.yAxis.transform.translateX.setValue((double)this.wallRect.x);
        this.yAxis.transform.translateY.setValue((double)this.wallRect.y);
        this.x2Axis.transform.translateX.setValue((double)this.wallRect.x);
        this.x2Axis.transform.translateY.setValue((double)(this.wallRect.y + this.wallRect.height));
        this.networkRoot.addElement((Element)this.createTile());
    }

    private void build(Graphics g) {
        Dimension d = this.getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        if (this.percentAxesOn) {
            for (int i = 0; i < this.gutters.length; ++i) {
                this.gutters[i] = 0;
            }
        }
        this.setupViewport(d, g);
        this.setupAxes(d);
        this.networkRoot.removeAllElements();
        switch (this.getDimension()) {
            case 1: {
                this.build1DNetwork(d, g);
                break;
            }
            case 2: {
                this.build2DNetwork(d, g);
                break;
            }
            case 3: {
                this.build3DNetwork(d, g);
            }
        }
    }

    private boolean isColumnAdded(String name, Probe p) {
        Probe.ProbeEntryEnumerator existed = p.enumerate();
        if (existed == null) {
            return false;
        }
        while (existed.hasMoreElements()) {
            Probe.ProbeEntry pe = (Probe.ProbeEntry)existed.nextElement();
            if (!pe.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private void preprocessData() {
        int i;
        double[] clr;
        int i2;
        if (this.categoryOrder != 0) {
            int order = this.categoryOrder == 1 ? 1 : 2;
            for (int i3 = 0; i3 < this.categoryVars.length; ++i3) {
                this.categoryVars[i3].setUniqueValueSort(order);
            }
        }
        if (this.getDimension() == 1) {
            this.probe = new Probe();
            this.probe.setTrimOn(true);
            if (this.urlVar != null) {
                this.probe.addPipe("_URL_", (Pipe)this.urlVar.value);
            }
            if (this.dataTipVars != null) {
                for (int i4 = 0; i4 < this.dataTipVars.length; ++i4) {
                    if (this.isColumnAdded(this.dataTipVars[i4].getLabel(), this.probe)) continue;
                    if (this.dataTipVars[i4] instanceof StringVariable) {
                        this.probe.addPipe(this.dataTipVars[i4].getLabel(), (Pipe)((StringVariable)this.dataTipVars[i4]).value);
                        continue;
                    }
                    this.probe.addPipe(this.dataTipVars[i4].getLabel(), (Pipe)((NumericVariable)this.dataTipVars[i4]).value);
                }
            } else {
                this.probe.addPipe(this.categoryVars[0].getLabel(), (Pipe)this.categoryVars[0].value);
                if (!this.isColumnAdded(this.freqVar.getLabel(), this.probe)) {
                    this.probe.addPipe(this.freqVar.getLabel(), (Pipe)this.freqVar.value);
                }
                if (this.colorResponseVar != null && !this.isColumnAdded(this.colorResponseVar.getLabel(), this.probe)) {
                    this.probe.addPipe(this.colorResponseVar.getLabel(), (Pipe)this.colorResponseVar.value);
                }
            }
            return;
        }
        int[] catNums = new int[this.categoryVars.length];
        int nobs = 1;
        for (int i5 = 0; i5 < this.categoryVars.length; ++i5) {
            catNums[i5] = this.categoryVars[i5].getUniqueValueCount();
            nobs *= catNums[i5];
        }
        String[][] categories = new String[this.categoryVars.length][];
        for (int i6 = 0; i6 < this.categoryVars.length; ++i6) {
            categories[i6] = new String[nobs];
            for (int j = 0; j < nobs; ++j) {
                categories[i6][j] = " ";
            }
        }
        String[][] datatips = null;
        if (this.dataTipVars != null) {
            datatips = new String[this.dataTipVars.length][];
            for (i2 = 0; i2 < this.dataTipVars.length; ++i2) {
                datatips[i2] = new String[nobs];
            }
        }
        for (i2 = 0; i2 < nobs; ++i2) {
            try {
                int j;
                int[] idx = new int[this.categoryVars.length];
                int div = 1;
                for (j = 0; j < this.categoryVars.length; ++j) {
                    int jj = this.categoryVars.length - 1 - j;
                    idx[jj] = i2 / div % catNums[jj];
                    div *= catNums[jj];
                }
                for (j = 0; j < this.categoryVars.length; ++j) {
                    categories[j][i2] = this.categoryVars[j].uniqueValue.getValue(idx[j]);
                }
                continue;
            }
            catch (MissingValueException idx) {
                // empty catch block
            }
        }
        double[] freq = new double[nobs];
        double[] dArray = clr = this.colorResponseVar == null ? null : new double[nobs];
        if (clr != null) {
            for (int i7 = 0; i7 < nobs; ++i7) {
                clr[i7] = Double.NaN;
            }
        }
        double[] freqTip = new double[nobs];
        ArrayList<Integer> firstCategoryContents = new ArrayList<Integer>();
        int obs = -1;
        for (i = 0; i < this.freqVar.getValueCount(); ++i) {
            try {
                Integer itg;
                int j;
                int[] idx = new int[this.categoryVars.length];
                for (j = 0; j < this.categoryVars.length; ++j) {
                    idx[j] = this.categoryVars[j].category.getValue(i);
                }
                obs = idx[this.categoryVars.length - 1];
                for (j = 1; j < this.categoryVars.length; ++j) {
                    int rj = this.categoryVars.length - 1 - j;
                    int mul = 1;
                    for (int k = 1; k <= j; ++k) {
                        mul *= catNums[rj + k];
                    }
                    obs += idx[rj] * mul;
                }
                double f = this.freqVar.value.getValue(i);
                if (this.getDimension() == 2 && idx[0] == 0 && f > 0.0 && !firstCategoryContents.contains(itg = new Integer(idx[1]))) {
                    firstCategoryContents.add(itg);
                }
                freq[obs] = f;
                freqTip[obs] = f;
                if (clr == null) continue;
                clr[obs] = this.colorResponseVar.value.getValue(i);
                continue;
            }
            catch (MissingValueException mve) {
                if (obs < 0) continue;
                freqTip[obs] = Double.NaN;
            }
        }
        if (datatips != null) {
            for (int l = 0; l < this.dataTipVars.length; ++l) {
                for (int i8 = 0; i8 < this.freqVar.getValueCount(); ++i8) {
                    try {
                        int j;
                        int[] idx = new int[this.categoryVars.length];
                        for (j = 0; j < this.categoryVars.length; ++j) {
                            idx[j] = this.categoryVars[j].category.getValue(i8);
                        }
                        obs = idx[this.categoryVars.length - 1];
                        for (j = 1; j < this.categoryVars.length; ++j) {
                            int rj = this.categoryVars.length - 1 - j;
                            int mul = 1;
                            for (int k = 1; k <= j; ++k) {
                                mul *= catNums[rj + k];
                            }
                            obs += idx[rj] * mul;
                        }
                        if (this.dataTipVars[l] instanceof StringVariable) {
                            datatips[l][obs] = ((StringVariable)this.dataTipVars[l]).value.getValue(i8);
                            continue;
                        }
                        double val = ((NumericVariable)this.dataTipVars[l]).value.getValue(i8);
                        if (this.dataTipVars[l].getFormat() != null) {
                            datatips[l][obs] = this.dataTipVars[l].getFormat().format((Object)new Double(val));
                            continue;
                        }
                        datatips[l][obs] = DataModel.defaultFormat.format((Object)new Double(val));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
        }
        this.firstCategoryFull = firstCategoryContents.size() == catNums[1];
        for (i = 0; i < this.categoryVars.length; ++i) {
            this.categoryVars[i].connectFrom(categories[i]);
        }
        this.freqVar.connectFrom(freq);
        this.freqTipVar = new NumericVectorVariable();
        this.freqTipVar.setLabel(this.freqVar.getLabel());
        this.freqTipVar.setFormat(this.freqVar.getFormat());
        this.freqTipVar.connectFrom(freqTip);
        if (clr != null) {
            this.colorResponseVar.connectFrom(clr);
        }
        if (datatips != null) {
            for (i = 0; i < this.dataTipVars.length; ++i) {
                ((StringVectorVariable)this.dataTipVars[i]).connectFrom(datatips[i]);
            }
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)this.urlVar.value);
        }
        if (this.dataTipVars != null) {
            for (i = 0; i < this.dataTipVars.length; ++i) {
                if (this.isColumnAdded(this.dataTipVars[i].getLabel(), this.probe)) continue;
                if (this.dataTipVars[i] instanceof StringVariable) {
                    this.probe.addPipe(this.dataTipVars[i].getLabel(), (Pipe)((StringVariable)this.dataTipVars[i]).value);
                    continue;
                }
                this.probe.addPipe(this.dataTipVars[i].getLabel(), (Pipe)((NumericVariable)this.dataTipVars[i]).value);
            }
        } else {
            for (i = 0; i < this.categoryVars.length; ++i) {
                if (this.isColumnAdded(this.categoryVars[i].getLabel(), this.probe)) continue;
                this.probe.addPipe(this.categoryVars[i].getLabel(), (Pipe)this.categoryVars[i].value);
            }
            if (!this.isColumnAdded(this.freqVar.getLabel(), this.probe)) {
                this.probe.addPipe(this.freqVar.getLabel(), (Pipe)this.freqTipVar.value);
            }
            if (this.colorResponseVar != null && !this.isColumnAdded(this.colorResponseVar.getLabel(), this.probe)) {
                this.probe.addPipe(this.colorResponseVar.getLabel(), (Pipe)this.colorResponseVar.value);
            }
        }
    }

    private void summarizeData() {
        String cat1;
        int i;
        this.totalCount = 0.0;
        for (i = 0; i < this.freqVar.getValueCount(); ++i) {
            try {
                this.totalCount += this.freqVar.value.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.cat1Count.clear();
        this.cat12Count.clear();
        this.cat1AccumCount.clear();
        for (i = 0; i < this.freqVar.getValueCount(); ++i) {
            try {
                double cnt = this.freqVar.value.getValue(i);
                cat1 = this.categoryVars[0].value.getValue(i);
                if (this.cat1Count.containsKey(cat1)) {
                    double currentCnt = (Double)this.cat1Count.get(cat1);
                    this.cat1Count.put(cat1, new Double(currentCnt + cnt));
                } else {
                    this.cat1Count.put(cat1, new Double(cnt));
                }
                if (this.getDimension() <= 1) continue;
                String cat2 = this.categoryVars[1].value.getValue(i);
                String cat12 = cat1 + "@:)" + cat2;
                if (this.cat12Count.containsKey(cat12)) {
                    double currentCnt = (Double)this.cat12Count.get(cat12);
                    this.cat12Count.put(cat12, new Double(currentCnt + cnt));
                    continue;
                }
                this.cat12Count.put(cat12, new Double(cnt));
                continue;
            }
            catch (MissingValueException cnt) {
                // empty catch block
            }
        }
        Iterator it = this.cat1Count.keySet().iterator();
        double accum = 0.0;
        while (it.hasNext()) {
            cat1 = (String)it.next();
            this.cat1AccumCount.put(cat1, new Double(accum));
            double cnt = (Double)this.cat1Count.get(cat1);
            accum += cnt;
        }
    }

    private void layoutTiles1D() {
        int i;
        this.xAxisTickPos.removeAllValues();
        int cat1Num = this.categoryVars[0].getUniqueValueCount();
        double xlen = this.xAxis.getLength() - (double)(this.gutters[0] * (cat1Num - 1));
        double accum = this.lineOffset;
        for (i = 0; i < cat1Num; ++i) {
            try {
                String cat = this.categoryVars[0].uniqueValue.getValue(i);
                double cnt = (Double)this.cat1Count.get(cat);
                double proportion = xlen * cnt / this.totalCount;
                this.xAxisTickPos.addValue(accum + proportion / 2.0);
                accum += proportion + (double)this.gutters[0];
                continue;
            }
            catch (MissingValueException cat) {
                // empty catch block
            }
        }
        this.xCoord.removeAllValues();
        this.xSize.removeAllValues();
        for (i = 0; i < this.categoryVars[0].getValueCount(); ++i) {
            try {
                String cat1 = this.categoryVars[0].value.getValue(i);
                double cnt1 = (Double)this.cat1Count.get(cat1);
                double accum_cnt1 = (Double)this.cat1AccumCount.get(cat1);
                double xProportion = xlen * cnt1 / this.totalCount;
                int idx1 = this.categoryVars[0].category.getValue(i);
                double xAccumProportion = xlen * accum_cnt1 / this.totalCount + (double)(idx1 * this.gutters[0]);
                this.xCoord.addValue(xAccumProportion);
                this.xSize.addValue(xProportion);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private void layoutTiles2D() {
        int i;
        if (this.isLabelsInside()) {
            this.laIndices = new int[this.categoryVars[1].getUniqueValueCount()];
            double[] largestArea = new double[this.categoryVars[1].getUniqueValueCount()];
            for (int i2 = 0; i2 < this.freqVar.getValueCount(); ++i2) {
                try {
                    double f = this.freqVar.value.getValue(i2);
                    int idx1 = this.categoryVars[0].category.getValue(i2);
                    int idx2 = this.categoryVars[1].category.getValue(i2);
                    String cat1 = this.categoryVars[0].value.getValue(i2);
                    double catCnt = (Double)this.cat1Count.get(cat1);
                    double xs = catCnt / this.totalCount;
                    double ys = f / catCnt;
                    if (!(largestArea[idx2] < xs * ys)) continue;
                    largestArea[idx2] = xs * ys;
                    this.laIndices[idx2] = idx1;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        this.xAxisTickPos.removeAllValues();
        int cat1Num = this.categoryVars[0].getUniqueValueCount();
        double xlen = this.xAxis.getLength() - (double)(this.gutters[0] * (cat1Num - 1));
        double accum = this.lineOffset;
        String firstCategory = null;
        for (int i3 = 0; i3 < cat1Num; ++i3) {
            try {
                String cat = this.categoryVars[0].uniqueValue.getValue(i3);
                if (firstCategory == null) {
                    firstCategory = cat;
                }
                double cnt = (Double)this.cat1Count.get(cat);
                double proportion = xlen * cnt / this.totalCount;
                this.xAxisTickPos.addValue(accum + proportion / 2.0);
                accum += proportion + (double)this.gutters[0];
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.xCoord.removeAllValues();
        this.xSize.removeAllValues();
        this.yCoord.removeAllValues();
        this.ySize.removeAllValues();
        this.yAxisTickPos.removeAllValues();
        double ylen = this.yAxis.getLength() - (double)(this.gutters[1] * (this.categoryVars[1].getUniqueValueCount() - 1));
        for (int i4 = 0; i4 < this.categoryVars[0].getValueCount(); ++i4) {
            try {
                String cat1 = this.categoryVars[0].value.getValue(i4);
                double cnt1 = (Double)this.cat1Count.get(cat1);
                double accum_cnt1 = (Double)this.cat1AccumCount.get(cat1);
                double xProportion = xlen * cnt1 / this.totalCount;
                int idx1 = this.categoryVars[0].category.getValue(i4);
                double xAccumProportion = xlen * accum_cnt1 / this.totalCount + (double)(idx1 * this.gutters[0]);
                this.xCoord.addValue(xAccumProportion);
                this.xSize.addValue(xProportion);
                int idx2 = this.categoryVars[1].category.getValue(i4);
                double cnt2 = this.freqVar.value.getValue(i4);
                double yProportion = cnt1 == 0.0 ? ylen / (double)this.categoryVars[1].getUniqueValueCount() : ylen * cnt2 / cnt1;
                this.ySize.addValue(yProportion);
                if (!cat1.equals(firstCategory)) continue;
                this.yAxisTickPos.addValue(yProportion);
                continue;
            }
            catch (MissingValueException cat1) {
                // empty catch block
            }
        }
        BidirectionalAccumulatorByCategory bi = new BidirectionalAccumulatorByCategory();
        bi.category.connectFrom(this.categoryVars[0].category);
        bi.input.connectFrom((NumericPipe)this.ySize);
        bi.setPostAccumulate(true);
        bi.init(new AInitAction());
        for (i = 0; i < this.xCoord.getValueCount(); ++i) {
            try {
                int idx2 = this.categoryVars[1].category.getValue(i);
                this.yCoord.addValue(bi.getValue(i) + (double)(idx2 * this.gutters[1]));
                continue;
            }
            catch (MissingValueException mve) {
                this.yCoord.addValue(0.0);
            }
        }
        accum = this.lineOffset;
        for (i = 0; i < this.yAxisTickPos.getValueCount(); ++i) {
            try {
                double curr = this.yAxisTickPos.getValue(i);
                this.yAxisTickPos.setValueAt(accum + curr / 2.0 + (double)(i * this.gutters[1]), i);
                accum += curr;
                continue;
            }
            catch (MissingValueException curr) {
                // empty catch block
            }
        }
        if (this.isLabelsInside()) {
            this.labelX.removeAllValues();
            this.labelY.removeAllValues();
            for (i = 0; i < this.laIndices.length; ++i) {
                int idx = this.laIndices[i] * this.laIndices.length + i;
                try {
                    double x = this.xCoord.getValue(idx) + this.xSize.getValue(idx) / 2.0;
                    this.labelX.addValue(x);
                    double y = this.yCoord.getValue(idx) + this.ySize.getValue(idx) / 2.0;
                    this.labelY.addValue(y);
                    continue;
                }
                catch (MissingValueException x) {
                    // empty catch block
                }
            }
            if (this.insideValueFitting != 0) {
                this.splitLabel.removeAllValues();
                for (i = 0; i < this.categoryVars[0].getValueCount(); ++i) {
                    try {
                        String label = this.categoryVars[1].uniqueValue.getValue(i);
                        double w = this.xSize.getValue(i);
                        String[] splitted = Overlay.splitLabel(label, this.insideValueFitting == 2, w, true, new char[]{' '}, StatGraph.getFontMetrics(this.insideDataLabelStyle.getFont()));
                        this.splitLabel.addValue(Overlay.makeMultiLineLabel(splitted, false));
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void layoutTiles3D() {
        int idx2;
        int i;
        int i2;
        int cat1Num = this.categoryVars[0].getUniqueValueCount();
        int cat2Num = this.categoryVars[1].getUniqueValueCount();
        int cat3Num = this.categoryVars[2].getUniqueValueCount();
        double xlen = this.xAxis.getLength() - (double)(this.gutters[0] * (cat1Num - 1)) - (double)(this.gutters[2] * (cat3Num - 1) * cat1Num);
        double accum = this.lineOffset;
        this.xAxisTickPos.removeAllValues();
        for (i2 = 0; i2 < cat1Num; ++i2) {
            try {
                String cat = this.categoryVars[0].uniqueValue.getValue(i2);
                double cnt = (Double)this.cat1Count.get(cat);
                double proportion = xlen * cnt / this.totalCount;
                this.xAxisTickPos.addValue(accum + (proportion + (double)(this.gutters[2] * (cat3Num - 1))) / 2.0);
                accum += proportion + (double)this.gutters[0] + (double)(this.gutters[2] * (cat3Num - 1));
                continue;
            }
            catch (MissingValueException cat) {
                // empty catch block
            }
        }
        this.x2AxisLabels.removeAllValues();
        for (i2 = 0; i2 < cat1Num; ++i2) {
            for (int j = 0; j < cat3Num; ++j) {
                try {
                    this.x2AxisLabels.addValue(this.categoryVars[2].uniqueValue.getValue(j));
                    continue;
                }
                catch (MissingValueException mve) {
                    this.x2AxisLabels.addValue("");
                }
            }
        }
        this.xCoord.removeAllValues();
        this.xSize.removeAllValues();
        this.yCoord.removeAllValues();
        this.ySize.removeAllValues();
        double ylen = this.yAxis.getLength() - (double)(this.gutters[1] * (cat2Num - 1));
        double x123Accum = 0.0;
        int oldIDX1 = 0;
        int oldIDX2 = 0;
        for (int i3 = 0; i3 < this.categoryVars[0].getValueCount(); ++i3) {
            try {
                String cat1 = this.categoryVars[0].value.getValue(i3);
                int idx1 = this.categoryVars[0].category.getValue(i3);
                double cnt1 = (Double)this.cat1Count.get(cat1);
                String cat2 = this.categoryVars[1].value.getValue(i3);
                int idx22 = this.categoryVars[1].category.getValue(i3);
                double cnt2 = (Double)this.cat12Count.get(cat1 + "@:)" + cat2);
                int idx3 = this.categoryVars[2].category.getValue(i3);
                double cnt3 = this.freqVar.value.getValue(i3);
                if (oldIDX1 != idx1 || oldIDX2 != idx22) {
                    x123Accum = 0.0;
                }
                double accum_cnt1 = (Double)this.cat1AccumCount.get(cat1);
                double xProportion = xlen * cnt1 / this.totalCount;
                double xAccumProportion = xlen * accum_cnt1 / this.totalCount + (double)(idx1 * (this.gutters[0] + this.gutters[2] * (cat3Num - 1)));
                double x13Proportion = cnt2 == 0.0 ? xProportion / (double)cat3Num : xProportion * cnt3 / cnt2;
                this.xCoord.addValue(xAccumProportion + x123Accum);
                this.xSize.addValue(x13Proportion);
                x123Accum += x13Proportion + (double)this.gutters[2];
                oldIDX1 = idx1;
                oldIDX2 = idx22;
                double yProportion = cnt1 == 0.0 ? ylen / (double)cat2Num : ylen * cnt2 / cnt1;
                this.ySize.addValue(yProportion);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        oldIDX1 = 0;
        double oldYCoord = 0.0;
        for (i = 0; i < this.xCoord.getValueCount(); ++i) {
            try {
                int idx1 = this.categoryVars[0].category.getValue(i);
                if (idx1 != oldIDX1) {
                    oldYCoord = 0.0;
                }
                oldIDX1 = idx1;
                idx2 = this.categoryVars[1].category.getValue(i);
                int idx3 = this.categoryVars[2].category.getValue(i);
                this.yCoord.addValue(oldYCoord);
                if (idx3 != cat3Num - 1) continue;
                oldYCoord += this.ySize.getValue(i) + (double)this.gutters[1];
                continue;
            }
            catch (MissingValueException idx1) {
                // empty catch block
            }
        }
        this.x2AxisTickPos.removeAllValues();
        this.yAxisTickPos.removeAllValues();
        for (i = 0; i < this.xCoord.getValueCount(); ++i) {
            try {
                int idx1 = this.categoryVars[0].category.getValue(i);
                idx2 = this.categoryVars[1].category.getValue(i);
                int idx3 = this.categoryVars[2].category.getValue(i);
                if (idx1 == 0 && idx3 == 0) {
                    this.yAxisTickPos.addValue(this.yCoord.getValue(i) + this.ySize.getValue(i) / 2.0);
                }
                if (idx2 != cat2Num - 1) continue;
                this.x2AxisTickPos.addValue(this.xCoord.getValue(i) + this.xSize.getValue(i) / 2.0);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    private void layoutTiles() {
        switch (this.getDimension()) {
            case 1: {
                this.layoutTiles1D();
                break;
            }
            case 2: {
                this.layoutTiles2D();
                break;
            }
            case 3: {
                this.layoutTiles3D();
            }
        }
    }

    public void setColorMapper(ColorMapper mapper) {
        this.colorMapper = mapper;
        if (this.colorResponseVar != null) {
            ContinuousRangeToColorMapper crcm = (ContinuousRangeToColorMapper)mapper;
            int crIDX = this.dataModel.getColumn(this.colorResponseVarName);
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(crIDX);
            double min = cmd.getMin();
            double max = cmd.getMax();
            double[] cr = new double[3];
            crcm.setInputMin(min);
            crcm.setInputMax(max);
            cr[0] = min;
            cr[1] = (min + max) / 2.0;
            cr[2] = max;
            crcm.setColorSpectrumValues(cr);
        }
    }

    protected boolean isLegendEntryFromAttrMap() {
        if (this.colorDAM == null) {
            return false;
        }
        return this.colorDAM.getAttrMap().getLegendEntryPolicy() == 1;
    }

    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return this.outlineOn ? 11 : 7;
    }

    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.outlineOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    protected LegendItem[] getLegendItemsFromAttrMap(int attrType) {
        LegendItem[] items = this.colorDAM.getAttrMap().getLegendItems(attrType, true);
        this.applyFillTransparency(items);
        this.applyLineTransparency(items);
        return items;
    }

    public LegendItem[] getLegendItems(int attrType) {
        double fillTransparency;
        if (this.colorGroupIndex < 0) {
            if (this.colorResponseVar != null) {
                return null;
            }
            LegendItem[] li = new LegendItem[1];
            if (this.fillOn) {
                FillAttrs fa = new FillAttrs();
                fa.setColor(this.applyDataTransparency(this.fillStyle.getColor(), this.fillStyle));
                if (this.outlineOn) {
                    LineAttrs la = new LineAttrs();
                    la.setColor(this.applyDataTransparency(this.outlineStyle.getColor()));
                    li[0] = new LegendItem((ColorAttr)fa, (ColorAttr)la, this.getLegendLabel(), null);
                } else {
                    li[0] = new LegendItem((ColorAttr)fa, null, this.getLegendLabel(), null);
                }
            } else {
                LineAttrs la = new LineAttrs();
                la.setColor(this.applyDataTransparency(this.outlineStyle.getColor()));
                la.setLinePattern(this.outlineStyle.getLinePattern());
                la.setWidth(this.outlineStyle.getWidth());
                li[0] = new LegendItem((ColorAttr)la, null, this.getLegendLabel(), null);
            }
            return li;
        }
        int cgNum = this.categoryVars[this.colorGroupIndex].getUniqueValueCount();
        LegendItem[] items = new LegendItem[cgNum];
        StringToColorMapper mapper = (StringToColorMapper)this.colorMapper;
        mapper.input.connectFrom(this.categoryVars[this.colorGroupIndex].value);
        StringToColorMap stcm = (StringToColorMap)mapper.getValueMap();
        stcm.init(new AInitAction(null));
        double d = fillTransparency = this.fillStyle.getTransparency() >= 0.0 ? this.fillStyle.getTransparency() : this.dataTransparency;
        if (this.colorDAM != null) {
            this.colorDAM.setFillTransparency(fillTransparency);
            this.colorDAM.setUseFillTransparency(this.useFillTransparency);
            this.colorDAM.setLineTransparency(this.dataTransparency);
            this.colorDAM.variable = this.categoryVars[this.colorGroupIndex].value;
            this.colorDAM.fillColorMapper = this.colorMapper;
            this.colorDAM.init(new AInitAction(null));
        }
        for (int i = 0; i < cgNum; ++i) {
            try {
                Color c;
                FillAttrs attr;
                String cat = this.categoryVars[this.colorGroupIndex].uniqueValue.getValue(i);
                if (this.fillOn) {
                    attr = new FillAttrs();
                    if (this.colorMapper != null) {
                        if (this.colorDAM != null) {
                            c = this.colorDAM.getFillColor(cat);
                            if (c == null) {
                                c = stcm.getValue(cat);
                            }
                            if (this.useFillTransparency) {
                                attr.setColor(this.applyDataTransparency(c, this.fillStyle));
                            } else {
                                attr.setColor(this.applyTransparency(c, this.colorDAM.getFillTransparency(cat)));
                            }
                        } else {
                            attr.setColor(this.applyDataTransparency(stcm.getValue(cat), this.fillStyle));
                        }
                    } else {
                        attr.setColor(this.applyDataTransparency(this.fillStyle.getColor(), this.fillStyle));
                    }
                    if (this.outlineOn) {
                        LineAttrs la = new LineAttrs();
                        la.setColor(this.applyDataTransparency(this.outlineStyle.getColor()));
                        items[i] = new LegendItem((ColorAttr)attr, (ColorAttr)la, cat, null);
                        continue;
                    }
                    items[i] = new LegendItem((ColorAttr)attr, null, cat, null);
                    continue;
                }
                attr = new LineAttrs();
                attr.setWidth(this.outlineStyle.getWidth());
                attr.setLinePattern(this.outlineStyle.getLinePattern());
                if (this.colorMapper != null) {
                    if (this.colorDAM != null) {
                        c = this.colorDAM.getLineColor(cat);
                        if (c == null) {
                            c = stcm.getValue(cat);
                        }
                        attr.setColor(this.applyDataTransparency(c));
                    } else {
                        attr.setColor(this.applyDataTransparency(stcm.getValue(cat)));
                    }
                } else {
                    attr.setColor(this.applyDataTransparency(this.outlineStyle.getColor()));
                }
                items[i] = new LegendItem((ColorAttr)attr, null, cat, null);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.isLegendEntryFromAttrMap()) {
            items = Overlay.margeAttrMapWithPlotLegendItems(this.colorDAM, items, this.fillStyle, this.outlineStyle, false, this.useFillTransparency, this.fillOn, true, true, this.dataTransparency, this.useDataTransparency);
        }
        return items;
    }

    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.outlineOn;
            }
        }
        return false;
    }

    @Override
    public String getLegendLabel() {
        return this.legendLabel != null ? this.legendLabel : this.name;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.colorGroupIndex >= 0) {
            return this.categoryVars[this.colorGroupIndex].getLabel();
        }
        return null;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return this.colorGroupIndex < 0;
    }

    @Override
    protected Vector computeSelectableShapes() {
        Vector selectableShapes = new Vector();
        Vector feedback = new Vector();
        this.channel.glFeedbackBuffer(3, feedback);
        this.channel.glRenderMode(2);
        this.networkRoot.draw(this.channel, true);
        this.channel.glRenderMode(0);
        NetworkRoot.addFeedbackToSelectableShape(feedback, selectableShapes);
        return selectableShapes;
    }

    @Override
    public ImageMap getImageMap() {
        if (!this.tooltipEnabled) {
            return null;
        }
        ImageMap imageMap = null;
        Vector selectableShapes = this.computeSelectableShapes();
        Point location = this.getAbsLocation();
        SelectableShape.translate((Vector)selectableShapes, (int)location.x, (int)location.y);
        if (selectableShapes.size() > 0) {
            String alt = null;
            String href = null;
            ArrayList<ImageMap.Region> rs = new ArrayList<ImageMap.Region>(selectableShapes.size());
            for (int i = selectableShapes.size() - 1; i >= 0; --i) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.elementAt(i);
                SelectResult sr = selectableShape.getSelectResult();
                Shape coords = selectableShape.getShape();
                Probe probe = (Probe)sr.getElement().getUserData();
                href = null;
                if (probe == null) continue;
                String[] allLabels = probe.getLabels();
                int obs = sr.getValueIndex();
                String[] allValues = probe.getValues(obs);
                StringBuffer sb = new StringBuffer();
                boolean interpolation = false;
                if (sr.getElement() instanceof LineConnector && ((LineConnector)sr.getElement()).isSelectionInterpolationEnabled()) {
                    probe.setLineConnectorDetail((LineConnectorDetail)sr.getDetail());
                    allValues = probe.getValues(obs);
                    interpolation = true;
                }
                for (int j = 0; j < allLabels.length; ++j) {
                    if (allLabels[j].indexOf("_URL_") >= 0) {
                        if (allValues[j] == null || allValues[j].length() <= 0) continue;
                        href = allValues[j];
                        continue;
                    }
                    sb = sb.append(allLabels[j] + " = " + allValues[j] + " \n");
                }
                String string = alt = href != null ? sb.toString() : probe.getString(obs);
                if (href == null && interpolation) {
                    alt = sb.toString();
                }
                if (alt.lastIndexOf("\n") > 0) {
                    alt = alt.substring(0, alt.lastIndexOf("\n") - 1);
                }
                ImageMap.Region r = new ImageMap.Region(coords, href, alt);
                rs.add(r);
            }
            ImageMap.Region[] regions = new ImageMap.Region[rs.size()];
            for (int i = 0; i < rs.size(); ++i) {
                regions[i] = (ImageMap.Region)rs.get(i);
            }
            imageMap = new ImageMap(regions);
        }
        return imageMap;
    }

    public Range[] getColorModelRanges(int type) {
        String error;
        if (this.colorResponseVar == null) {
            return null;
        }
        double fillTransparency = this.fillStyle.getTransparency() >= 0.0 ? this.fillStyle.getTransparency() : this.dataTransparency;
        int crIDX = this.dataModel.getColumn(this.colorResponseVarName);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(crIDX);
        double min = cmd.getMin();
        double max = cmd.getMax();
        if (this.colorRAM != null && (error = this.colorRAM.createColorMapper(min, max)) == null) {
            if (this.fillOn) {
                return this.colorRAM.getRangeColorMapper().getFullRanges(fillTransparency);
            }
            return this.colorRAM.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        ContinuousRangeToColorMapper crcm = (ContinuousRangeToColorMapper)this.colorMapper;
        Color[] colors = null;
        try {
            colors = crcm.getColorSpectrumColors();
        }
        catch (MissingValueException mve) {
            return null;
        }
        RangeBound low = new RangeBound(min, true);
        RangeBound high = new RangeBound(max, true);
        ColorModel colorModel = new ColorModel(colors);
        Range[] colorModelRanges = new Range[]{new Range(low, high, colorModel)};
        return colorModelRanges;
    }

    public SASFormat getContinuousLegendFormat() {
        if (this.colorResponseVar == null) {
            return null;
        }
        int clrvIDX = this.dataModel.getColumn(this.colorResponseVarName);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getFormat();
    }

    public Color getMissingColor() {
        if (this.fillOn) {
            return this.missingFillColor;
        }
        return this.missingEdgeColor;
    }

    public boolean hasMissingValue() {
        if (this.colorResponseVar == null) {
            return false;
        }
        int clrvIDX = this.dataModel.getColumn(this.colorResponseVarName);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        if (this.colorResponseVar == null) {
            return null;
        }
        int clrvIDX = this.dataModel.getColumn(this.colorResponseVarName);
        ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(clrvIDX);
        return cmd.getLabel();
    }

    public Insets getPreferredInnerMargin() {
        return null;
    }

    public Insets getPreferredOuterMargin() {
        if (this.rebuild) {
            this.build(this.channel.getBackbufferGC());
            this.rebuild = false;
        }
        return this.outerMargin;
    }

    public void setInnerMargin(Insets margin) {
    }

    public void setOuterMargin(Insets margin) {
    }

    public Insets getInnerMargin() {
        return null;
    }

    public Insets getOuterMargin() {
        if (this.rebuild) {
            this.build(this.channel.getBackbufferGC());
            this.rebuild = false;
        }
        if (this.wallRect != null) {
            return new Insets(this.getHeight() - this.wallRect.y - this.wallRect.height, this.wallRect.x, this.wallRect.y, this.getWidth() - this.wallRect.x - this.wallRect.width);
        }
        return this.outerMargin;
    }

    public void enableMarginPrefCalc() {
    }

    public void disableMarginPrefCalc() {
    }

    public boolean isUseFillTransparency() {
        return this.useFillTransparency;
    }

    public void setUseFillTransparency(boolean useFillTransparency) {
        this.useFillTransparency = useFillTransparency;
    }
}

