/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.regions;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.kpi.BoundaryValue;
import com.sas.graphics.util.gtk.render.kpi.KPIChartRenderer;
import com.sas.graphics.util.gtk.render.kpi.KPIChartRendererModel;
import com.sas.graphics.util.gtk.render.kpi.KPIChartSegmentedRangeColorModel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class KPIRegion
extends Region {
    protected KPIChartRenderer kpi;
    protected KPIChartRendererModel model;
    protected DataModel dataModel;
    protected String actualVar;
    protected double actualValue = Double.NaN;
    protected String targetVar;
    protected double targetValue = Double.NaN;
    protected int statistic = 6;
    protected String valueFormat = null;
    protected String labelFormat = null;

    public KPIRegion() {
        this.kpi = new KPIChartRenderer(false);
        this.model = this.kpi.getRendererModel();
        this.setDefaultValues();
    }

    protected void setDefaultValues() {
        this.model.setKPIChartType(RendererUtil.KPIChartType.DIAL);
        this.model.setRangeValueVisiblityEnabled(true);
        this.model.setActualValueVisiblityEnabled(true);
        this.model.setSkin(RendererUtil.Skin.NONE);
        this.model.setAdjustMagnitudeValueEnabled(false);
    }

    public KPIChartRendererModel getKPIModel() {
        return this.model;
    }

    public int getOrientation() {
        return this.model.getOrientation();
    }

    public void setOrientation(int orient) {
        this.model.setOrientation(orient);
    }

    public RendererUtil.KPIChartType getType() {
        return this.model.getKPIChartType();
    }

    public void setType(RendererUtil.KPIChartType type) {
        this.model.setKPIChartType(type);
    }

    public RendererUtil.Skin getSkin() {
        return this.model.getSkin();
    }

    public void setSkin(RendererUtil.Skin skin) {
        this.model.setSkin(skin);
    }

    public TextStyle getValueTextStyle() {
        return this.model.getActualValueTextStyle();
    }

    public TextStyle getRangeValueTextStyle() {
        return this.model.getRangeValueTextStyle();
    }

    public void createRangeColorModel(double[] range, boolean highBoundary, Color[] colors, Color[] activeColors, Color underflowColor, Color overflowColor) {
        KPIChartSegmentedRangeColorModel colorModel = new KPIChartSegmentedRangeColorModel(range, highBoundary, colors, activeColors, underflowColor, overflowColor);
        this.model.setSegmentedRangeColorModel(colorModel);
    }

    public boolean createRangeColorModel(RangeAttributeMap rangeAttrMap, Color underflowColor, Color overflowColor, boolean reverseBounds) {
        return this.initBoundsFromRangeMap(rangeAttrMap, underflowColor, overflowColor, reverseBounds);
    }

    public String getActualVar() {
        return this.actualVar;
    }

    public void setActualVariable(String actual) {
        this.actualVar = actual;
    }

    public double getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(double actual) {
        this.actualValue = actual;
    }

    public String getTargetVar() {
        return this.targetVar;
    }

    public void setTargetVariable(String target) {
        this.targetVar = target;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(double target) {
        this.targetValue = target;
    }

    public boolean isValueVisible() {
        return this.model.isActualValueVisiblityEnabled();
    }

    public void setValueVisible(boolean visible) {
        this.model.setActualValueVisiblityEnabled(visible);
    }

    public boolean isRangeValueVisible() {
        return this.model.isRangeValueVisiblityEnabled();
    }

    public void setRangeValueVisible(boolean visible) {
        this.model.setRangeValueVisiblityEnabled(visible);
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    protected void connectVars() {
        NumericVectorVariable av = new NumericVectorVariable();
        GTKFormat valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)"BEST6."));
        if (this.actualVar != null) {
            int avIDX = this.dataModel.getColumn(this.actualVar);
            av.connectFrom(this.dataModel.getDoubleColumn(avIDX));
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(avIDX);
            av.setLabel(cmd.getLabel());
            if (cmd.getFormat() != null) {
                valueGTKFormat = new GTKFormat((Format)cmd.getFormat());
            }
        } else {
            av.connectFrom(new double[]{this.actualValue});
        }
        if (this.valueFormat != null) {
            valueGTKFormat = new GTKFormat((Format)SASFormat.getInstance((String)this.valueFormat));
        }
        av.setFormat(valueGTKFormat);
        NumericVectorVariable tv = new NumericVectorVariable();
        if (this.targetVar != null) {
            int tvIDX = this.dataModel.getColumn(this.targetVar);
            tv.connectFrom(this.dataModel.getDoubleColumn(tvIDX));
            ColumnMetadata cmd = (ColumnMetadata)this.dataModel.getColumnLabel(tvIDX);
            tv.setLabel(cmd.getLabel());
            if (cmd.getFormat() != null) {
                tv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
        } else {
            tv.connectFrom(new double[]{this.targetValue});
        }
        if (av.getValueCount() > 1 || tv.getValueCount() > 1) {
            VariableProcessor vp = new VariableProcessor();
            double[] cat = new double[Math.max(av.getValueCount(), tv.getValueCount())];
            NumericVectorVariable catv = new NumericVectorVariable();
            catv.connectFrom(cat);
            vp.addGroupVariable((Variable)catv);
            if (av.getValueCount() > 1) {
                vp.addVariable((Variable)av, this.statistic);
            }
            if (tv.getValueCount() > 1) {
                vp.addVariable((Variable)tv, this.statistic);
            }
        }
        this.model.setActualVariable((NumericVariable)av);
        this.model.setTargetVariable((NumericVariable)tv);
    }

    public void setDataModel(DataModel dm) {
        this.dataModel = dm;
        this.connectVars();
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets in = this.getInsets();
        this.model.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
        this.model.setDataSizeScaleFactor(StatGraph.dataSizeScaleFactor);
        this.model.setGapScaleFactor(StatGraph.gapScaleFactor);
        this.kpi.renderKPI((Graphics2D)g, new Rectangle(in.left, in.top, this.getWidth() - in.left - in.right, this.getHeight() - in.top - in.bottom));
        super.paintComponent(g);
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }

    private boolean initBoundsFromRangeMap(RangeAttributeMap raMap, Color underflowColor, Color overflowColor, boolean reverse) {
        Vector rmapRanges = raMap.getRanges();
        if (!raMap.isValid() || RangeAttributeMap.validateRanges((Vector)rmapRanges) != null) {
            return false;
        }
        ArrayList<BoundaryValue> boundaryValues = new ArrayList<BoundaryValue>(rmapRanges.size() + 1);
        ArrayList<Color> colors = new ArrayList<Color>(rmapRanges.size());
        ArrayList<Color> activeColors = new ArrayList<Color>(rmapRanges.size());
        RangeBound prevRangeBound = null;
        Collections.sort(rmapRanges, new RangeComparator());
        for (int i = 0; i < rmapRanges.size(); ++i) {
            AttributeMapRange aRange = (AttributeMapRange)rmapRanges.get(i);
            RangeBound min = aRange.getMin();
            RangeBound max = aRange.getMax();
            if (min.isKeyword() || max.isKeyword()) continue;
            if (boundaryValues.size() == 0) {
                boundaryValues.add(new BoundaryValue(min.getValue(), min.isInclusive()));
                prevRangeBound = max;
                continue;
            }
            RangeAttrBundle prevRangeBundle = ((AttributeMapRange)rmapRanges.get(i - 1)).getRangeAttrBundle();
            if (prevRangeBound.getValue() != min.getValue()) {
                this.addBoundary(prevRangeBound.getValue(), !prevRangeBound.isInclusive(), boundaryValues, prevRangeBundle, colors, activeColors);
                this.addBoundary(min.getValue(), min.isInclusive(), boundaryValues, raMap.getOtherAttrs(), colors, activeColors);
            } else if (!prevRangeBound.isInclusive() && !min.isInclusive()) {
                this.addBoundary(prevRangeBound.getValue(), true, boundaryValues, prevRangeBundle, colors, activeColors);
                this.addBoundary(min.getValue(), false, boundaryValues, raMap.getOtherAttrs(), colors, activeColors);
            } else if (prevRangeBound.isInclusive() && min.isInclusive()) {
                this.addBoundary(prevRangeBound.getValue(), false, boundaryValues, prevRangeBundle, colors, activeColors);
            } else if (prevRangeBound.isInclusive() != min.isInclusive()) {
                this.addBoundary(prevRangeBound.getValue(), min.isInclusive(), boundaryValues, prevRangeBundle, colors, activeColors);
            }
            if (i == rmapRanges.size() - 1) {
                this.addBoundary(max.getValue(), !max.isInclusive(), boundaryValues, aRange.getRangeAttrBundle(), colors, activeColors);
            }
            prevRangeBound = max;
        }
        if (boundaryValues.size() <= 1) {
            return false;
        }
        if (reverse) {
            Collections.reverse(boundaryValues);
            Collections.reverse(colors);
            Collections.reverse(activeColors);
        }
        KPIChartSegmentedRangeColorModel colorModel = new KPIChartSegmentedRangeColorModel(boundaryValues, colors.toArray(new Color[colors.size()]), activeColors.toArray(new Color[activeColors.size()]), underflowColor, overflowColor);
        this.model.setSegmentedRangeColorModel(colorModel);
        return true;
    }

    private void addBoundary(double val, boolean isInHigherSegment, List<BoundaryValue> values, RangeAttrBundle attrBundle, ArrayList<Color> colors, ArrayList<Color> actColors) {
        values.add(new BoundaryValue(val, isInHigherSegment));
        colors.add(attrBundle.getKPIColor());
        actColors.add(attrBundle.getKPIActiveColor());
    }

    private class RangeComparator
    implements Comparator<AttributeMapRange> {
        private RangeComparator() {
        }

        @Override
        public int compare(AttributeMapRange r1, AttributeMapRange r2) {
            if (r1.getMin().isKeyword() || r1.getMax().isKeyword()) {
                return -1;
            }
            if (r2.getMin().isKeyword() || r2.getMax().isKeyword()) {
                return 1;
            }
            return r1.getMax().compareTo(r2.getMin().getValue());
        }
    }
}

