/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.waterfall.WaterfallParmObject;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.text.Format;

public class WaterfallParmOverlay
extends Overlay {
    WaterfallParmObject waterfall = new WaterfallParmObject();
    Channel thisChannel;
    protected DataRange categoryRange = null;
    protected DataRange responseRange = null;
    protected DataRange colorRange = null;
    protected PositionEncoder categoryEncoder;
    protected PositionEncoder responseEncoder;
    protected ColorEncoder colorEncoder;
    private Variable categoryVar;
    private Variable responseVar;
    private Variable dataLabelVar;
    private Variable urlVar;
    public static final int SKIN_NONE = 0;
    public static final String SKIN_NONE_STRING = "none";
    public static final int SKIN_MODERN = 1;
    public static final String SKIN_MODERN_STRING = "modern";
    public static final int SKIN_SATIN = 2;
    public static final String SKIN_SATIN_STRING = "satin";
    protected int barSkinType = 0;
    protected URL barSkinImageLocation;
    protected Probe initBarProbe;
    protected Probe finalBarProbe;

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
    }

    protected void connectVars() {
        NumericVectorVariable nvv;
        NumericVector nv;
        StringVector sv;
        StringVectorVariable svv;
        ColumnMetadata cmd;
        CRD crd = this.model;
        VariableProcessor vp = null;
        if (crd.isAvailable(1)) {
            this.categoryVar = this.connectRaw((short)1);
            this.waterfall.setCategoryVariable(this.categoryVar);
        } else {
            this.categoryVar = null;
        }
        if (crd.isAvailable(2)) {
            this.responseVar = this.connectRaw((short)2);
            this.waterfall.setResponseVariable(this.responseVar);
            this.setFormat(this.waterfall.getDataRange((byte)2), 2);
        } else {
            this.responseVar = null;
        }
        if (crd.isAvailable(5)) {
            this.dataLabelVar = this.connectRaw((short)5);
            this.waterfall.setDataLabelVariable(this.dataLabelVar);
        }
        this.urlVar = this.connectCategory((short)52, false);
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)this.urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addTooltip(vp, "CATEGORY");
            this.addTooltip(vp, "RESPONSE");
            this.addTooltip(vp, "DATALABEL");
        }
        this.initBarProbe = new Probe();
        this.initBarProbe.setTrimOn(true);
        if (this.waterfall.isShowInitialBar()) {
            cmd = null;
            cmd = this.getRoleMetadata("CATEGORY");
            svv = new StringVectorVariable();
            sv = new StringVector();
            sv.addValue(this.waterfall.getInitialBarTickmarkLabel());
            svv.connectFrom((StringPipe)sv);
            if (cmd.getFormat() != null) {
                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
            this.initBarProbe.setMissingReplacement(StatGraph.missingCharacter);
            this.initBarProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
            nv = new NumericVector();
            nv.addValue(this.waterfall.getInitialBarValue());
            nvv = new NumericVectorVariable();
            cmd = this.getRoleMetadata("RESPONSE");
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            nvv.connectFrom((NumericPipe)nv);
            this.initBarProbe.setMissingReplacement(StatGraph.missingOption);
            this.initBarProbe.addPipe(cmd.getLabel(), (Pipe)nvv.value);
        }
        this.finalBarProbe = new Probe();
        this.finalBarProbe.setTrimOn(true);
        if (this.waterfall.isShowFinalBar()) {
            cmd = null;
            cmd = this.getRoleMetadata("CATEGORY");
            svv = new StringVectorVariable();
            sv = new StringVector();
            sv.addValue(this.waterfall.getFinalBarTickmarkLabel());
            svv.connectFrom((StringPipe)sv);
            if (cmd.getFormat() != null) {
                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
            this.finalBarProbe.setMissingReplacement(StatGraph.missingCharacter);
            this.finalBarProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
            nv = new NumericVector();
            nv.addValue(this.waterfall.getFinalBarValue());
            nvv = new NumericVectorVariable();
            cmd = this.getRoleMetadata("RESPONSE");
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            nvv.connectFrom((NumericPipe)nv);
            this.finalBarProbe.setMissingReplacement(StatGraph.missingOption);
            this.finalBarProbe.addPipe(cmd.getLabel(), (Pipe)nvv.value);
        }
    }

    @Override
    protected boolean connectNetwork() {
        this.applySkinImage();
        this.waterfall.setXLimits(this.categoryEncoder.getLowerLimit(), this.categoryEncoder.getUpperLimit());
        ColorMap colorMap = null;
        if (this.colorEncoder != null) {
            colorMap = (ColorMap)this.colorEncoder.getValueMap();
        }
        this.needConnect = !this.waterfall.connectNetwork((StringToNumericMap)this.categoryEncoder.getValueMap(), (ContinuousRangeToNumericMap)this.responseEncoder.getValueMap(), colorMap, this.probe, this.initBarProbe, this.finalBarProbe);
        return !this.needConnect;
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.waterfall.draw();
    }

    @Override
    public void select() {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.waterfall.select();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        return this.waterfall.getDataRange(dimension);
    }

    @Override
    public void setChannel(Channel channel) {
        this.waterfall.setChannel(channel);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (encoder != null && encoder.equals(this.categoryEncoder) || !(encoder instanceof PositionEncoder)) {
                return;
            }
            this.categoryEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (encoder != null && encoder.equals(this.responseEncoder) || !(encoder instanceof PositionEncoder)) {
                return;
            }
            this.responseEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (encoder != null && encoder.equals(this.colorEncoder) || !(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        int n;
        double offset = 0.0;
        if (dimension == 1) {
            n = Math.max(StatGraph.MPC, this.categoryVar.getUniqueValueCount());
            offset = n > 1 ? (this.categoryEncoder.getUpperLimit() - this.categoryEncoder.getLowerLimit()) / (double)n : 0.25 * (this.categoryEncoder.getUpperLimit() - this.categoryEncoder.getLowerLimit()) / (double)n;
        }
        if (dimension == 2) {
            n = Math.max(StatGraph.MPC, this.responseVar.getUniqueValueCount());
            offset = n > 1 ? (this.responseEncoder.getUpperLimit() - this.responseEncoder.getLowerLimit()) / (double)n : 0.25 * (this.responseEncoder.getUpperLimit() - this.responseEncoder.getLowerLimit()) / (double)n;
        }
        return offset;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        return this.waterfall.getPreferredInnerMargin();
    }

    public void setDisplayMode(String mode) {
        this.waterfall.setDisplayMode(mode);
    }

    public int getBarSkinType() {
        return this.barSkinType;
    }

    public void setBarSkinType(int type) {
        if (type == this.barSkinType) {
            return;
        }
        this.barSkinType = type;
        switch (this.barSkinType) {
            default: {
                this.barSkinImageLocation = null;
                break;
            }
            case 1: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_modern.png");
                break;
            }
            case 2: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_Satin.png");
            }
        }
    }

    public void setDataSkinType(int type) {
        if (type == this.barSkinType) {
            return;
        }
        this.barSkinType = type;
        switch (this.barSkinType) {
            default: {
                this.barSkinImageLocation = null;
                break;
            }
            case 1: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_modern.png");
                break;
            }
            case 2: {
                this.barSkinImageLocation = StatGraph.class.getResource("sgchart/res/VBarEffects_Satin.png");
            }
        }
    }

    public Color getBarOutlineColor() {
        return this.waterfall.getBarEdgeColor();
    }

    public void setBarOutlineColor(Color barOutlineColor) {
        this.waterfall.setBarEdgeColor(barOutlineColor);
    }

    public int getBarOutlineWidth() {
        return this.waterfall.getBarEdgeWidth();
    }

    public void setBarOutlineWidth(int barOutlineWidth) {
        this.waterfall.setBarEdgeWidth(barOutlineWidth);
    }

    public double getBarThicknessAsPercentage() {
        return this.waterfall.getBarThicknessAsPercentage();
    }

    public void setBarThicknessAsPercentage(double barThicknessAsPercentage) {
        this.waterfall.setBarThicknessAsPercentage(barThicknessAsPercentage);
    }

    public double getBarFillColorTransparency() {
        return this.waterfall.getTransactionBarTransparency();
    }

    public void setBarFillColorOpacity(double t) {
        this.waterfall.setTransactionBarTransparency(t);
    }

    public boolean isShowBarLabels() {
        return this.waterfall.isShowBarLabels();
    }

    public void setShowBarLabels(boolean showBarLabels) {
        this.waterfall.setShowBarLabels(showBarLabels);
    }

    public boolean isShowTrendLine() {
        return this.waterfall.isShowTrendLine();
    }

    public void setShowTrendLine(boolean showTrendLine) {
        this.waterfall.setShowTrendLine(showTrendLine);
    }

    public boolean isShowInitialBar() {
        return this.waterfall.isShowInitialBar();
    }

    public void setShowInitialBar(boolean showInitialBar) {
        this.waterfall.setShowInitialBar(showInitialBar);
    }

    public boolean isShowFinalBar() {
        return this.waterfall.isShowFinalBar();
    }

    public double getBaselineIntercept() {
        return this.waterfall.getBaselineIntercept();
    }

    public void setBaselineIntercept(double baselineIntercept) {
        this.waterfall.setBaselineIntercept(baselineIntercept);
    }

    public int getTrendlineType() {
        return this.waterfall.getTrendlineType();
    }

    public void setTrendlineType(int trendlineType) {
        this.waterfall.setTrendlineType(trendlineType);
    }

    public double getInitialBarValue() {
        return this.waterfall.getInitialBarValue();
    }

    public void setInitialBarValue(double initialBarValue) {
        this.waterfall.setInitialBarValue(initialBarValue);
    }

    public Color getInitialBarColor() {
        return this.waterfall.getInitialBarColor();
    }

    public void setInitialBarColor(Color initialBarColor) {
        this.waterfall.setInitialBarColor(initialBarColor);
    }

    public double getInitialBarTransparency() {
        return this.waterfall.getInitialBarTransparency();
    }

    public void setInitialBarTransparency(double initialBarTransparency) {
        this.waterfall.setInitialBarTransparency(initialBarTransparency);
    }

    public String getInitialBarTickmarkLabel() {
        return this.waterfall.getInitialBarTickmarkLabel();
    }

    public void setInitialBarTickmarkLabel(String initialBarTickmarkLabel) {
        this.waterfall.setInitialBarTickmarkLabel(initialBarTickmarkLabel);
    }

    public Color getFinalBarColor() {
        return this.waterfall.getFinalBarColor();
    }

    public void setFinalBarColor(Color finalBarColor) {
        this.waterfall.setFinalBarColor(finalBarColor);
    }

    public double getFinalBarTransparency() {
        return this.waterfall.getFinalBarTransparency();
    }

    public void setFinalBarTransparency(double finalBarTransparency) {
        this.waterfall.setFinalBarTransparency(finalBarTransparency);
    }

    public String getFinalBarTickmarkLabel() {
        return this.waterfall.getFinalBarTickmarkLabel();
    }

    public void setFinalBarTickmarkLabel(String finalBarTickmarkLabel) {
        this.waterfall.setFinalBarTickmarkLabel(finalBarTickmarkLabel);
    }

    public TextStyle getBarLabelStyle() {
        return this.waterfall.getBarLabelStyle();
    }

    public void setBarLabelStyle(TextStyle barLabelStyle) {
        this.waterfall.setBarLabelStyle(barLabelStyle);
    }

    public FillAttrs getTransactionBarFillAttrs() {
        return this.waterfall.getTransactionBarFillAttrs();
    }

    public void setTransactionBarFillAttrs(FillAttrs transactionBarFillAttrs) {
        this.waterfall.setTransactionBarFillAttrs(transactionBarFillAttrs);
    }

    public FillAttrs getInitialBarFillAttrs() {
        return this.waterfall.getInitialBarFillAttrs();
    }

    public void setInitialBarFillAttrs(FillAttrs initialBarFillAttrs) {
        this.waterfall.setInitialBarFillAttrs(initialBarFillAttrs);
    }

    public FillAttrs getFinalBarFillAttrs() {
        return this.waterfall.getFinalBarFillAttrs();
    }

    public double getTransactionBarTransparency() {
        return this.waterfall.getTransactionBarTransparency();
    }

    public void setTransactionBarTransparency(double transparency) {
        this.waterfall.setTransactionBarTransparency(transparency);
    }

    public void setFinalBarFillAttrs(FillAttrs finalBarFillAttrs) {
        this.waterfall.setFinalBarFillAttrs(finalBarFillAttrs);
    }

    public LineAttrs getBarOutlineAttrs() {
        return this.waterfall.getBarOutlineAttrs();
    }

    public void setBarOutlineAttrs(LineAttrs barOutlineAttrs) {
        this.waterfall.setBarOutlineAttrs(barOutlineAttrs);
    }

    public LineAttrs getTrendlineAttrs() {
        return this.waterfall.getTrendlineAttrs();
    }

    public void setTrendlineAttrs(LineAttrs trendlineAttrs) {
        this.waterfall.setTrendlineAttrs(trendlineAttrs);
    }

    private void applySkinImage() {
        if (this.barSkinImageLocation == null || this.waterfall.getChannel() == null) {
            return;
        }
        MediaTracker tracker = new MediaTracker(this.waterfall.getChannel().getComponent());
        try {
            Image barSkinImage = Toolkit.getDefaultToolkit().getImage(this.barSkinImageLocation);
            tracker.addImage(barSkinImage, 0);
            tracker.waitForAll();
            if (this.skinType == 1 || this.skinType == 2 || this.skinType == 6 || this.skinType == 3) {
                this.waterfall.setBarSkin(barSkinImage);
            }
            if (this.skinType != 1 && this.skinType != 2) {
                this.waterfall.setSkinType(this.skinType);
            }
            this.needConnect = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String[] getUniqueValues(short role) {
        if (role == 6) {
            return this.waterfall.getUniqueValues((byte)4);
        }
        return super.getUniqueValues(role);
    }

    public void setBarColorPolicy(int policy) {
        this.waterfall.setBarColorPolicy(policy);
    }

    public int getBarColorPolicy() {
        return this.waterfall.getBarColorPolicy();
    }

    public TextStyle getDataLabelStyle() {
        return this.waterfall.getDataLabelStyle();
    }

    public void setDataLabelStyle(TextStyle dataLabelStyle) {
        this.waterfall.setDataLabelStyle(dataLabelStyle);
    }
}

