/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.BrokenContinuousRangeToNumericMap;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.VisibilityVariable;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Graph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.SplineConnector;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TimeSeriesOverlay
extends Overlay {
    public static final String RB_KEY = "TimeSeriesOverlay.";
    protected DataRange xRange;
    protected DataRange yRange;
    protected DataRange colorRange;
    protected DataRange lineColorRange;
    protected DataRange lineRange;
    protected DataRange shapeRange;
    protected DataRange shapeColorRange;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected ShapeEncoder shapeEncoder;
    protected ColorEncoder shapeColorEncoder;
    protected ColorEncoder shapeFillColorEncoder;
    private NetworkRoot networkRoot;
    private Variable timeVar;
    private Variable responseVar;
    private Variable groupVar;
    private Variable gIndexVar;
    private Variable colorVar;
    private Variable lineColorVar;
    private Variable lineVar;
    private Variable shapeVar;
    private Variable shapeColorVar;
    private Variable shapeFillColorVar;
    private NumericVariable[] multiResponseVars = null;
    private StringVariable stringGroupVar;
    private Variable labelVar;
    private NumericVectorVariable numericResponseVar;
    private String[] multiResponseLabels = null;
    private int responseCount = 0;
    private Variable timeVar_sav;
    private boolean numericResponse = false;
    private boolean numericGroup = false;
    private boolean numericLabel = false;
    private boolean numericDiscreteResp = false;
    private boolean subsetTime;
    private boolean subsetGroup;
    private boolean subset;
    private int[] subsetObs;
    private int subsetObsCount;
    private int[] subsetObs_group;
    private int subsetObsCount_group;
    private int statistic = -1;
    private int connectionOrder = 0;
    private boolean vertical = true;
    private boolean fillOn = false;
    private boolean lineOn = true;
    private boolean markerOn = false;
    private boolean vertexLabelOn = false;
    private boolean baselineOn = false;
    private FillAttrs fillStyle = new FillAttrs();
    private LineAttrs lineStyle = new LineAttrs();
    private LineAttrs baselineStyle = new LineAttrs();
    private MarkerAttrs markerStyle = new MarkerAttrs();
    private TextAttrs labelStyle = new TextAttrs();
    private boolean useLabelColor = false;
    private SASFormat labelFormat = null;
    private boolean smooth = false;
    private boolean breakMissing = false;
    private double baseline = 0.0;
    public static final double DEFAULT_CLUSTER_WIDTH = 0.85;
    private double clusterWidth = 0.85;
    public static final byte CLUSTER = 0;
    public static final byte OVERLAY = 1;
    public static final byte STACKED = 2;
    private int groupDisplay = 1;
    private int[] groupsPerCategory;
    private String overlayID;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    private boolean dataValid = true;
    public static final int BASELINE_AUTO = 0;
    public static final int BASELINE_NUMBER = 1;
    public static final int BASELINE_AXISMIN = 2;
    public static final int BASELINE_AXISMINEXTEND = 3;
    public static final int BASELINE_AXISMAX = 4;
    public static final int BASELINE_AXISMAXEXTEND = 5;
    private int baselineInterceptType = 0;
    public static final int DATALABEL_AUTO = -1;
    public static final int DATALABEL_TOP = 0;
    public static final int DATALABEL_BOTTOM = 1;
    public static final int DATALABEL_LEFT = 2;
    public static final int DATALABEL_RIGHT = 3;
    public static final int DATALABEL_CENTER = 4;
    public static final int DATALABEL_TOPLEFT = 5;
    public static final int DATALABEL_TOPRIGHT = 6;
    public static final int DATALABEL_BOTTOMLEFT = 7;
    public static final int DATALABEL_BOTTOMRIGHT = 8;
    private int dataLabelPosition = -1;
    private boolean filledOutlinedMarker = false;
    private FillAttrs markerFillStyle = new FillAttrs();
    private LineAttrs markerOutlineStyle = new LineAttrs();
    private boolean useMarkerAttrsColor = false;
    private boolean useMarkerOutlineAttrsColor = false;
    private boolean useMarkerOutlineAttrsThickness = false;

    public void setFilledOutlinedMarker(boolean b) {
        this.filledOutlinedMarker = b;
    }

    public boolean isFilledOutlinedMarker() {
        return this.filledOutlinedMarker;
    }

    public void setMarkerFillStyle(FillAttrs fa) {
        this.markerFillStyle = fa;
    }

    public FillAttrs getMarkerFillStyle() {
        return this.markerFillStyle;
    }

    public void setMarkerOutlineStyle(LineAttrs la) {
        this.markerOutlineStyle = la;
    }

    public LineAttrs getMarkerOutlineStyle() {
        return this.markerOutlineStyle;
    }

    public void setUseMarkerAttrsColor(boolean b) {
        this.useMarkerAttrsColor = b;
    }

    public boolean isUseMarkerAttrsColor() {
        return this.useMarkerAttrsColor;
    }

    public void setUseMarkerOutlineAttrsColor(boolean b) {
        this.useMarkerOutlineAttrsColor = b;
    }

    public boolean isUseMarkerOutlineAttrsColor() {
        return this.useMarkerOutlineAttrsColor;
    }

    public void setUseMarkerOutlineAttrsThickness(boolean b) {
        this.useMarkerOutlineAttrsThickness = b;
    }

    public boolean isUseMarkerOutlineAttrsThickness() {
        return this.useMarkerOutlineAttrsThickness;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    public double getBaseline() {
        return this.baseline;
    }

    public void setBaseline(double d) {
        this.baseline = d;
    }

    public int getBaselineInterceptType() {
        return this.baselineInterceptType;
    }

    public void setBaselineInterceptType(int t) {
        this.baselineInterceptType = t;
    }

    public boolean isVertexLabelOn() {
        return this.vertexLabelOn;
    }

    public void setVertexLabelOn(boolean b) {
        this.vertexLabelOn = b;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean b) {
        this.smooth = b;
    }

    public boolean isBreakMissing() {
        return this.breakMissing;
    }

    public void setBreakMissing(boolean b) {
        this.breakMissing = b;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean b) {
        this.vertical = b;
    }

    public boolean isMarkerOn() {
        return this.markerOn;
    }

    public void setMarkerOn(boolean b) {
        this.markerOn = b;
    }

    public boolean isLineOn() {
        return this.lineOn;
    }

    public void setLineOn(boolean b) {
        this.lineOn = b;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public boolean isBaselineOn() {
        return this.baselineOn;
    }

    public void setBaselineOn(boolean b) {
        this.baselineOn = b;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    public void setUseLabelColor(boolean b) {
        this.useLabelColor = b;
    }

    public void setLabelFormat(SASFormat fmt) {
        this.labelFormat = fmt;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(LineAttrs ls) {
        this.lineStyle = ls;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setMarkerStyle(MarkerAttrs ms) {
        this.markerStyle = ms;
    }

    public MarkerAttrs getMarkerStyle() {
        return this.markerStyle;
    }

    public void setLabelStyle(TextAttrs ls) {
        this.labelStyle = ls;
    }

    public TextAttrs getLabelStyle() {
        return this.labelStyle;
    }

    public LineAttrs getBaselineStyle() {
        return this.baselineStyle;
    }

    public void setBaselineStyle(LineAttrs style) {
        this.baselineStyle = style;
    }

    public void setClusterWidth(double width) {
        this.clusterWidth = width;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public void setGroupDisplay(int display) {
        this.groupDisplay = display;
    }

    public int getGroupDisplay() {
        return this.groupDisplay;
    }

    public int getGroupDisplayInUse() {
        if (!this.numericResponse || this.groupVar == null && !this.isMultiResponse()) {
            return 1;
        }
        return this.groupDisplay;
    }

    public void setDataLabelPosition(int position) {
        this.dataLabelPosition = position;
    }

    public int getDataLabelPosition() {
        return this.dataLabelPosition;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    public boolean isMultiResponse() {
        return this.responseCount > 0;
    }

    public void setResponseCount(int n) {
        this.responseCount = n;
    }

    public boolean isAutoPointLabel() {
        return this.vertexLabelOn || this.labelVar != null && this.dataLabelPosition == -1;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 6) {
            if (!(encoder instanceof ShapeEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeEncoder)) {
                return;
            }
            this.shapeEncoder = (ShapeEncoder)encoder;
        } else if (dimension == 16) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeColorEncoder)) {
                return;
            }
            this.shapeColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 24) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeFillColorEncoder)) {
                return;
            }
            this.shapeFillColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 15: {
                return this.lineRange;
            }
            case 17: {
                return this.lineColorRange;
            }
        }
        return null;
    }

    @Override
    ContinuousRange makeContinuousRange(NumericVariable numVar, short role, boolean subset) {
        if (this.subsetTime) {
            NumericVariable nv = StatGraph.isOLAP() ? StatGraph.getOLAPMeasureVar(this.model, role) : (NumericVariable)this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            if (this.subsetGroup) {
                vp.setSubsetByObservation(this.subsetObs_group, this.subsetObsCount_group);
            }
            vp.addVariable((Variable)nv);
            this.addCRDWhereClause(vp);
            return super.makeContinuousRange(nv, role, subset);
        }
        return super.makeContinuousRange(numVar, role, subset);
    }

    protected DataRange getIndRange() {
        ContinuousRange range = null;
        if (this.timeVar != null) {
            int num = this.timeVar.getUniqueValueCount();
            if (num > 0) {
                boolean subset = this.vertical ? !this.xUnionAllPages : !this.yUnionAllPages;
                range = this.makeContinuousRange((NumericVariable)this.timeVar, (short)113, subset);
                range.setLabel(this.timeVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    private DataRange getDepRange() {
        if (this.getGroupDisplayInUse() == 2) {
            this.baselineOn = false;
            this.baseline = 0.0;
            this.baselineInterceptType = 1;
            this.smooth = false;
        }
        Object range = null;
        if (this.isMultiResponse()) {
            range = this.getGroupDisplayInUse() == 2 ? this.getStackedMultiResponseRange() : this.getMultiResponseRange();
            range = this.mergeRangeWithBaseline((DataRange)range);
            String label = this.multiResponseLabels[0];
            for (int i = 1; i < this.multiResponseLabels.length; ++i) {
                label = label + " / " + this.multiResponseLabels[i];
            }
            range.setLabel(label);
        } else if (this.responseVar != null) {
            int num;
            int n = num = this.numericResponse ? this.responseVar.getValueCount() : this.responseVar.getUniqueValueCount();
            if (num > 0) {
                boolean subset;
                boolean bl = this.vertical ? !this.yUnionAllPages : (subset = !this.xUnionAllPages);
                range = this.getGroupDisplayInUse() == 2 ? this.getStackedResponseRange((NumericVariable)this.responseVar, (short)2, subset) : (this.numericResponse ? this.makeContinuousRange((NumericVariable)this.responseVar, (short)2, subset) : (this.numericDiscreteResp ? this.makeOrdinalRange((StringVariable)this.responseVar, num, (NumericVariable)this.numericResponseVar, (short)2, subset) : this.makeDiscreteRange((StringVariable)this.responseVar, num, (short)2, subset)));
                range = this.mergeRangeWithBaseline((DataRange)range);
                range.setLabel(this.responseVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    private DataRange mergeRangeWithBaseline(DataRange range) {
        if (this.baselineInterceptType != 1 || !this.numericResponse) {
            return range;
        }
        if (range != null) {
            double min = ((ContinuousRange)range).getMin();
            double max = ((ContinuousRange)range).getMax();
            if (min == Double.MAX_VALUE || max == -1.7976931348623157E308) {
                return range;
            }
            range = new ContinuousRange(Math.min(min, this.baseline), Math.max(max, this.baseline));
        }
        return range;
    }

    private DataRange getMultiResponseRange() {
        ContinuousRange range;
        boolean subset = this.vertical ? !this.yUnionAllPages : !this.xUnionAllPages;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.multiResponseVars.length; ++i) {
            NumericVariable rVar = this.multiResponseVars[i];
            int num = rVar.getValueCount();
            if (num <= 0) continue;
            range = this.makeContinuousRange(rVar, (short)(610 + i), subset);
            min = Math.min(min, range.getMin());
            max = Math.max(max, range.getMax());
        }
        range = new ContinuousRange(min, max);
        return range;
    }

    private DataRange getSubsettedStackRange(NumericVariable respVar) {
        ContinuousRange range = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
        accumEnd.category.connectFrom(((NumericVariable)this.timeVar).category);
        accumEnd.input.connectFrom(respVar.value);
        accumEnd.setPostAccumulate(false);
        double[] minMax = accumEnd.getAccumulation();
        min = minMax[0];
        max = minMax[1];
        range = respVar.getValueCount() == 0 ? new ContinuousRange(Double.MAX_VALUE, -1.7976931348623157E308) : new ContinuousRange(min, max);
        range.setLabel(respVar.getLabel());
        return range;
    }

    private DataRange getUnionAllStackRange(int respRole, String respLabel) {
        int i;
        double[] count;
        int n;
        boolean Y2;
        ContinuousRange range = null;
        boolean X2 = !this.getXAxis().equalsIgnoreCase("X");
        boolean bl = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (this.vertical) {
            if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
                range.setLabel(respLabel);
                return range;
            }
            if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
                range.setLabel(respLabel);
                return range;
            }
        } else {
            if (!X2 && !Double.isNaN(this.model.getSrcModel().computedXMin) && !Double.isNaN(this.model.getSrcModel().computedXMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedXMin, this.model.getSrcModel().computedXMax);
                range.setLabel(respLabel);
                return range;
            }
            if (X2 && !Double.isNaN(this.model.getSrcModel().computedX2Min) && !Double.isNaN(this.model.getSrcModel().computedX2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedX2Min, this.model.getSrcModel().computedX2Max);
                range.setLabel(respLabel);
                return range;
            }
        }
        Variable tempTimeVar = null;
        Variable tempGroupVar = null;
        NumericVectorVariable tempResponseVar = new NumericVectorVariable();
        if (StatGraph.isOLAP()) {
            tempTimeVar = StatGraph.getOLAPMeasureVar(this.model, (short)113);
            tempGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
            if (this.model.isAvailable(respRole)) {
                tempResponseVar = StatGraph.getOLAPMeasureVar(this.model, (short)respRole);
            } else {
                n = tempTimeVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar = new NumericVectorVariable();
                tempResponseVar.connectFrom(count);
            }
        } else {
            tempTimeVar = this.connectRaw((short)113);
            tempGroupVar = this.connectCategory((short)3, true);
            if (this.model.isAvailable(respRole)) {
                tempResponseVar.connectFrom(this.model.getDoubleColumn(respRole));
            } else {
                n = tempTimeVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar.connectFrom(count);
            }
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (this.vertical) {
            if (Y2) {
                if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                    min = Math.min(min, this.model.getSrcModel().computedY2Min);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                    max = Math.max(max, this.model.getSrcModel().computedY2Max);
                }
            } else {
                if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                    min = Math.min(min, this.model.getSrcModel().computedYMin);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                    max = Math.max(max, this.model.getSrcModel().computedYMax);
                }
            }
        } else if (X2) {
            if (!Double.isNaN(this.model.getSrcModel().computedX2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedX2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedX2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedX2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedXMin)) {
                min = Math.min(min, this.model.getSrcModel().computedXMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedXMax)) {
                max = Math.max(max, this.model.getSrcModel().computedXMax);
            }
        }
        for (int i2 = 0; i2 < this.model.allWhereExpressions.length; ++i2) {
            if (this.model.allWhereExpressions[i2] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            vp.addVariable(tempTimeVar);
            vp.addVariable(tempGroupVar);
            vp.addVariable((Variable)tempResponseVar);
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i2] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i2]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            if (tempResponseVar.getValueCount() == 0) continue;
            int respCount = tempResponseVar.getValueCount();
            boolean allMissing = true;
            for (int j = 0; j < respCount; ++j) {
                try {
                    tempResponseVar.value.getValue(j);
                    allMissing = false;
                    break;
                }
                catch (MissingValueException missingValueException) {
                    continue;
                }
            }
            if (allMissing) continue;
            BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
            accumEnd.category.connectFrom(((NumericVariable)tempTimeVar).category);
            accumEnd.input.connectFrom(tempResponseVar.value);
            accumEnd.setPostAccumulate(false);
            double[] minMax = accumEnd.getAccumulation();
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (this.vertical) {
            if (Y2) {
                this.model.getSrcModel().computedY2Min = min;
                this.model.getSrcModel().computedY2Max = max;
            } else {
                this.model.getSrcModel().computedYMin = min;
                this.model.getSrcModel().computedYMax = max;
            }
        } else if (X2) {
            this.model.getSrcModel().computedX2Min = min;
            this.model.getSrcModel().computedX2Max = max;
        } else {
            this.model.getSrcModel().computedXMin = min;
            this.model.getSrcModel().computedXMax = max;
        }
        range = new ContinuousRange(min, max);
        range.setLabel(respLabel);
        return range;
    }

    private DataRange getStackedResponseRange(NumericVariable numVar, short role, boolean subset) {
        if (subset) {
            return this.getSubsettedStackRange(numVar);
        }
        return this.getUnionAllStackRange(2, this.responseVar.getLabel());
    }

    private DataRange getStackedMultiResponseRange() {
        boolean Y2;
        boolean subset;
        boolean bl = this.vertical ? !this.yUnionAllPages : (subset = !this.xUnionAllPages);
        if (subset) {
            return this.getSubsettedStackRange((NumericVariable)this.responseVar);
        }
        ContinuousRange range = null;
        boolean X2 = !this.getXAxis().equalsIgnoreCase("X");
        boolean bl2 = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (this.vertical) {
            if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
                return range;
            }
            if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
                return range;
            }
        } else {
            if (!X2 && !Double.isNaN(this.model.getSrcModel().computedXMin) && !Double.isNaN(this.model.getSrcModel().computedXMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedXMin, this.model.getSrcModel().computedXMax);
                return range;
            }
            if (X2 && !Double.isNaN(this.model.getSrcModel().computedX2Min) && !Double.isNaN(this.model.getSrcModel().computedX2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedX2Min, this.model.getSrcModel().computedX2Max);
                return range;
            }
        }
        Object tempTimeVar_sav = StatGraph.isOLAP() ? StatGraph.getOLAPMeasureVar(this.model, (short)113) : this.connectRaw((short)113);
        NumericVariable[] tempMultiResponseVars = new NumericVariable[this.responseCount];
        for (int i = 0; i < this.responseCount; ++i) {
            tempMultiResponseVars[i] = new NumericVectorVariable();
            if (StatGraph.isOLAP()) {
                tempMultiResponseVars[i] = StatGraph.getOLAPMeasureVar(this.model, (short)(610 + i));
                continue;
            }
            ((NumericVectorVariable)tempMultiResponseVars[i]).connectFrom(this.model.getDoubleColumn(610 + i));
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (this.vertical) {
            if (Y2) {
                if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                    min = Math.min(min, this.model.getSrcModel().computedY2Min);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                    max = Math.max(max, this.model.getSrcModel().computedY2Max);
                }
            } else {
                if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                    min = Math.min(min, this.model.getSrcModel().computedYMin);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                    max = Math.max(max, this.model.getSrcModel().computedYMax);
                }
            }
        } else if (X2) {
            if (!Double.isNaN(this.model.getSrcModel().computedX2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedX2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedX2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedX2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedXMin)) {
                min = Math.min(min, this.model.getSrcModel().computedXMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedXMax)) {
                max = Math.max(max, this.model.getSrcModel().computedXMax);
            }
        }
        for (int i = 0; i < this.model.allWhereExpressions.length; ++i) {
            int n;
            if (this.model.allWhereExpressions[i] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            vp.addVariable(tempTimeVar_sav);
            for (int r = 0; r < this.responseCount; ++r) {
                vp.addVariable((Variable)tempMultiResponseVars[r]);
            }
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            if ((n = ((NumericVariable)tempTimeVar_sav).getValueCount()) == 0) continue;
            int nResp = this.multiResponseVars.length;
            int rows = n * nResp;
            double[] tvals = new double[rows];
            double[] resps = new double[rows];
            String[] grps = new String[rows];
            for (int r = 0; r < nResp; ++r) {
                int offset = r * n;
                for (int j = 0; j < n; ++j) {
                    try {
                        tvals[offset + j] = ((NumericVariable)tempTimeVar_sav).value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        tvals[offset + j] = Double.NaN;
                    }
                    try {
                        resps[offset + j] = tempMultiResponseVars[r].value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        resps[offset + j] = Double.NaN;
                    }
                    grps[offset + j] = this.multiResponseVars[r].getLabel();
                }
            }
            NumericVectorVariable tempTimeVar = new NumericVectorVariable();
            tempTimeVar.connectFrom(tvals);
            NumericVectorVariable tempResponseVar = new NumericVectorVariable();
            tempResponseVar.connectFrom(resps);
            StringVectorVariable tempGroupVar = new StringVectorVariable();
            tempGroupVar.connectFrom(grps);
            BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
            accumEnd.category.connectFrom(tempTimeVar.category);
            accumEnd.input.connectFrom(tempResponseVar.value);
            accumEnd.setPostAccumulate(false);
            double[] minMax = accumEnd.getAccumulation();
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (this.vertical) {
            if (Y2) {
                this.model.getSrcModel().computedY2Min = min;
                this.model.getSrcModel().computedY2Max = max;
            } else {
                this.model.getSrcModel().computedYMin = min;
                this.model.getSrcModel().computedYMax = max;
            }
        } else if (X2) {
            this.model.getSrcModel().computedX2Min = min;
            this.model.getSrcModel().computedX2Max = max;
        } else {
            this.model.getSrcModel().computedXMin = min;
            this.model.getSrcModel().computedXMax = max;
        }
        range = new ContinuousRange(min, max);
        return range;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.dataValid = this.validateData();
        if (!this.dataValid) {
            return;
        }
        if (this.isMultiResponse()) {
            this.preProcessVars();
        }
        this.updateXRange();
        this.updateYRange();
        this.updateLineColorRange();
        this.updateLineRange();
        this.updateNumberOfGroupPerCategory();
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        if (this.getGroupDisplayInUse() == 1) {
            return;
        }
        NumericVariable catvar = new NumericVariable();
        catvar.connectFrom((NumericVariable)this.timeVar);
        catvar.setFormat(((NumericVariable)this.timeVar).getFormat());
        StringVariable gvar = new StringVariable();
        if (this.groupVar instanceof NumericVariable) {
            gvar.connectFrom((NumericVariable)this.groupVar);
        } else {
            gvar.connectFrom((StringVariable)this.groupVar);
        }
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)catvar);
        vp.addVariable((Variable)gvar, 0);
        vp.addGroupVariable((Variable)catvar);
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)113) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        if ((numCats = catvar.getUniqueValueCount()) == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        int gCount = 1;
        int gIdx = 0;
        String catV = null;
        boolean missingFirst = false;
        for (int i = 0; i < catvar.getValueCount(); ++i) {
            try {
                String xv = catvar.formattedValue.getValue(i);
                if (catV == null && i == 0) {
                    catV = xv;
                    continue;
                }
                if (xv.equals(catV)) {
                    ++gCount;
                    continue;
                }
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = xv;
                continue;
            }
            catch (MissingValueException e) {
                if (catV != null) {
                    this.groupsPerCategory[gIdx] = gCount;
                    if (gCount > maxGroups) {
                        maxGroups = gCount;
                    }
                    ++gIdx;
                    gCount = 1;
                    catV = null;
                    continue;
                }
                if (gIdx != 0) continue;
                missingFirst = true;
            }
        }
        this.groupsPerCategory[gIdx] = gCount;
        if (gCount > maxGroups) {
            maxGroups = gCount;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        ArrayList[] list;
        block12: {
            int i;
            int nCat;
            block11: {
                String[] gvalues = this.getGroupValues();
                nCat = ((NumericVariable)this.timeVar).getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i2 = 0; i2 < nCat; ++i2) {
                    list[i2] = new ArrayList();
                }
                int nGrp = this.groupVar.getUniqueValueCount();
                this.subToColumnGroupCategory = new int[nGrp];
                this.stringGroupVar.getUniqueValueCount();
                HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
                for (int i3 = 0; i3 < nGrp; ++i3) {
                    try {
                        if (this.groupOrder == 0) {
                            String v = this.stringGroupVar.uniqueValue.getValue(i3);
                            int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                            value2ColumnCategory.put(v, new Integer(groupCategory_column));
                            this.subToColumnGroupCategory[i3] = groupCategory_column;
                            continue;
                        }
                        this.subToColumnGroupCategory[i3] = i3;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
                IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
                IntegerPipe category = ((NumericVariable)this.timeVar).category;
                int n = ((NumericVariable)this.timeVar).getValueCount();
                for (i = 0; i < n; ++i) {
                    try {
                        ((NumericVariable)this.timeVar).value.getValue(i);
                        int cat = category.getValue(i);
                        Integer IG = new Integer(groupCategory.getValue(i));
                        if (list[cat].contains(IG)) continue;
                        list[cat].add(IG);
                        continue;
                    }
                    catch (MissingValueException cat) {
                        // empty catch block
                    }
                }
                if (this.groupOrder != 1 && this.groupOrder != 2) break block11;
                for (i = 0; i < nCat; ++i) {
                    Collections.sort(list[i]);
                }
                break block12;
            }
            if (this.groupOrder != 3) break block12;
            for (i = 0; i < nCat; ++i) {
                ArrayList ll = new ArrayList();
                for (int j = list[i].size() - 1; j >= 0; --j) {
                    ll.add(list[i].get(j));
                }
                list[i] = ll;
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    protected void connectVars() {
        int i;
        if (StatGraph.isOLAP()) {
            this.connectOLAPVars();
            return;
        }
        CRD crd = this.model;
        if (crd.isAvailable(113)) {
            this.timeVar = (NumericVectorVariable)this.connectRaw((short)113);
            this.connectionOrder = this.vertical ? 1 : 2;
        } else {
            this.timeVar = null;
        }
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i2 = 0; i2 < this.responseCount; ++i2) {
                if (!crd.isAvailable(610 + i2)) continue;
                this.multiResponseVars[i2] = (NumericVectorVariable)this.connectRaw((short)(610 + i2));
                this.multiResponseLabels[i2] = this.multiResponseVars[i2].getLabel();
            }
            if (this.groupOrder != 0) {
                this.sortMultiResponseLabels();
            }
            this.numericResponse = true;
        } else if (crd.isAvailable(2)) {
            boolean discrete;
            this.numericResponse = crd.getColumnClass(2) == Double.class;
            boolean bl = discrete = this.vertical ? this.discreteY : this.discreteX;
            if (discrete) {
                this.responseVar = this.connectCategory((short)2, true);
                ((StringVectorVariable)this.responseVar).setBlankMissing(true);
            } else {
                this.responseVar = this.connectRaw((short)2);
            }
            if (this.numericResponse && discrete) {
                this.numericResponseVar = new NumericVectorVariable();
                this.numericResponseVar.connectFrom(crd.getDoubleColumn(2));
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(2)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericResponseVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (discrete) {
                this.numericDiscreteResp = this.numericResponse;
                this.numericResponse = false;
            }
        } else {
            this.responseVar = null;
        }
        this.colorVar = crd.isAvailable(6) ? this.connectCategory((short)6, true) : null;
        this.lineColorVar = crd.isAvailable(46) ? this.connectCategory((short)46, true) : null;
        this.lineVar = crd.isAvailable(36) ? this.connectCategory((short)36, true) : null;
        this.shapeColorVar = crd.isAvailable(45) ? this.connectCategory((short)45, true) : null;
        this.shapeFillColorVar = crd.isAvailable(69) ? this.connectCategory((short)69, true) : null;
        this.shapeVar = crd.isAvailable(8) ? this.connectCategory((short)8, true) : null;
        if (crd.isAvailable(3)) {
            this.numericGroup = crd.getColumnClass(3) == Double.class;
            this.groupVar = this.connectRaw((short)3);
            this.groupVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.stringGroupVar = (StringVariable)this.connectCategory((short)3, true);
        } else {
            this.groupVar = null;
        }
        this.gIndexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        if (crd.isAvailable(5)) {
            this.numericLabel = crd.getColumnClass(5) == Double.class;
            this.labelVar = this.connectRaw((short)5);
        } else {
            this.labelVar = null;
        }
        Variable urlVar = this.connectCategory((short)52, false);
        this.labelVisibleVar = new VisibilityVariable();
        this.subset = false;
        this.subsetTime = ((ColumnMetadata)this.model.getColumnLabel(113)).getMissings() > 0;
        boolean bl = this.subsetGroup = this.groupVar != null && ((ColumnMetadata)this.model.getColumnLabel(3)).getMissings() > 0 && !this.missingGroupOn;
        if (this.subsetTime || this.subsetGroup) {
            int count = this.timeVar.getValueCount();
            this.subsetObs = new int[count];
            this.subsetObsCount = 0;
            this.subsetObs_group = new int[count];
            this.subsetObsCount_group = 0;
            for (i = 0; i < count; ++i) {
                if (this.subsetTime && this.subsetGroup) {
                    if (!this.timeVar.isMissing(i) && !this.groupVar.isMissing(i)) {
                        this.subsetObs[this.subsetObsCount++] = i;
                    }
                } else if (this.subsetTime) {
                    if (!this.timeVar.isMissing(i)) {
                        this.subsetObs[this.subsetObsCount++] = i;
                    }
                } else if (this.subsetGroup && !this.groupVar.isMissing(i)) {
                    this.subsetObs[this.subsetObsCount++] = i;
                }
                if (this.subsetGroup && (!this.subsetGroup || this.groupVar.isMissing(i))) continue;
                this.subsetObs_group[this.subsetObsCount_group++] = i;
            }
            if (this.subsetObsCount < count) {
                this.subset = true;
            } else {
                this.subsetObs = null;
            }
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.timeVar.setUniqueValueSort(0);
        if (this.groupVar != null) {
            vp.addVariable(this.groupVar);
            if (this.getGroupOrder() == 1) {
                this.groupVar.setUniqueValueSort(1);
                if (this.isDrawByGroupOrder()) {
                    vp.setSort(this.groupVar, 1);
                }
            } else if (this.getGroupOrder() == 2) {
                this.groupVar.setUniqueValueSort(2);
                if (this.isDrawByGroupOrder()) {
                    vp.setSort(this.groupVar, 2);
                }
            }
            this.groupVar.setSortByFormattedValues(!this.numericGroup);
            vp.addVariable((Variable)this.stringGroupVar);
        }
        if (this.isMultiResponse()) {
            for (i = 0; i < this.multiResponseVars.length; ++i) {
                vp.addVariable((Variable)this.multiResponseVars[i]);
            }
        } else {
            vp.addVariable(this.responseVar);
            if (this.numericResponseVar != null) {
                vp.addVariable((Variable)this.numericResponseVar);
            }
        }
        this.addVarToVP(vp, this.timeVar);
        this.addVarToVP(vp, this.colorVar);
        this.addVarToVP(vp, this.lineColorVar);
        this.addVarToVP(vp, this.lineVar);
        this.addVarToVP(vp, this.shapeColorVar);
        this.addVarToVP(vp, this.shapeFillColorVar);
        this.addVarToVP(vp, this.shapeVar);
        this.addVarToVP(vp, this.gIndexVar);
        this.addVarToVP(vp, this.labelVar);
        this.addVarToVP(vp, urlVar);
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.groupVar != null && this.missingGroupOn) {
            this.probe.setMissingReplacement(this.groupVar instanceof NumericVariable ? StatGraph.missingOption : StatGraph.missingCharacter);
        }
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else if (!this.isMultiResponse()) {
            if (this.timeVar != null) {
                this.addTooltip(vp, "TIME");
            }
            if (this.responseVar != null) {
                this.addTooltip(vp, "RESPONSE");
            }
            if (this.groupVar != null) {
                this.addTooltip(vp, "GROUP");
            }
        }
    }

    private void sortMultiResponseLabels() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < this.responseCount; ++i) {
            list.add(this.multiResponseLabels[i]);
        }
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            Collections.sort(list);
        }
        for (i = 0; i < this.responseCount; ++i) {
            if (this.groupOrder == 1) {
                this.multiResponseLabels[i] = (String)list.get(i);
                continue;
            }
            this.multiResponseLabels[this.responseCount - 1 - i] = (String)list.get(i);
        }
    }

    public boolean isDataValid() {
        return this.dataValid;
    }

    public boolean validateData() {
        if (this.getGroupDisplayInUse() != 2) {
            return true;
        }
        if (this.isMultiResponse()) {
            for (int i = 0; i < this.responseCount; ++i) {
                if (((ColumnMetadata)this.model.getColumnLabel(610 + i)).getMissings() > 0) {
                    return false;
                }
                if (!(((ColumnMetadata)this.model.getColumnLabel(610 + i)).getMin() < 0.0)) continue;
                return false;
            }
            Object tempTimeVar = StatGraph.isOLAP() ? StatGraph.getOLAPMeasureVar(this.model, (short)113) : this.connectRaw((short)113);
            FrequencyVariable freq = new FrequencyVariable();
            if (this.model.allWhereExpressions == null || this.model.allWhereExpressions.length == 0) {
                VariableProcessor vp = new VariableProcessor();
                if (this.subset) {
                    vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                }
                vp.addGroupVariable(tempTimeVar);
                vp.addVariable((Variable)freq, 2);
                if (freq.getMax() > 1.0) {
                    return false;
                }
            } else {
                for (int i = 0; i < this.model.allWhereExpressions.length; ++i) {
                    if (this.model.allWhereExpressions[i] == null) continue;
                    VariableProcessor vp = new VariableProcessor();
                    if (this.subset) {
                        vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                    }
                    vp.addGroupVariable(tempTimeVar);
                    vp.addVariable((Variable)freq, 2);
                    for (int j = 0; j < this.model.whereVars.length; ++j) {
                        if (this.model.whereVars[j] == null) continue;
                        StringVariable sv = new StringVariable();
                        sv.connectFrom(this.model.whereVars[j]);
                        vp.addVariable((Variable)sv);
                    }
                    String curWhere = vp.getWhereExpression();
                    if (curWhere != null) {
                        vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
                    } else {
                        vp.setWhereExpression(this.model.allWhereExpressions[i]);
                    }
                    if (!vp.isWhereExpressionValid()) {
                        StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                    }
                    if (!(freq.getMax() > 1.0)) continue;
                    return false;
                }
            }
        } else {
            Variable tempGroupVar;
            Variable tempTimeVar;
            if (((ColumnMetadata)this.model.getColumnLabel(2)).getMissings() > 0) {
                return false;
            }
            if (((ColumnMetadata)this.model.getColumnLabel(2)).getMin() < 0.0) {
                return false;
            }
            if (StatGraph.isOLAP()) {
                tempTimeVar = StatGraph.getOLAPMeasureVar(this.model, (short)113);
                tempGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
            } else {
                tempTimeVar = this.connectRaw((short)113);
                tempGroupVar = this.connectCategory((short)3, this.missingGroupOn);
            }
            FrequencyVariable freq = new FrequencyVariable();
            if (this.model.allWhereExpressions == null || this.model.allWhereExpressions.length == 0) {
                VariableProcessor vp = new VariableProcessor();
                if (this.subset) {
                    vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                }
                vp.addGroupVariable(tempTimeVar);
                vp.addGroupVariable(tempGroupVar);
                vp.addVariable((Variable)freq, 2);
                if (freq.getMax() > 1.0) {
                    return false;
                }
                if (tempGroupVar.getUniqueValueCount() * tempTimeVar.getUniqueValueCount() != tempTimeVar.getValueCount()) {
                    return false;
                }
            } else {
                for (int i = 0; i < this.model.allWhereExpressions.length; ++i) {
                    if (this.model.allWhereExpressions[i] == null) continue;
                    VariableProcessor vp = new VariableProcessor();
                    if (this.subset) {
                        vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                    }
                    vp.addGroupVariable(tempTimeVar);
                    vp.addGroupVariable(tempGroupVar);
                    vp.addVariable((Variable)freq, 2);
                    for (int j = 0; j < this.model.whereVars.length; ++j) {
                        StringVectorVariable sv;
                        if (this.model.whereVars[j] == null) continue;
                        Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                        if (this.model.whereVarsOnSeparateModel) {
                            DataModel dm = this.model.getSrcModel();
                            int wcol = dm.getColumn(this.model.whereVars[j].getName());
                            sv.setName(this.model.whereVars[j].getName());
                            sv.connectFrom(dm.getColumnAsClassColumn(wcol));
                        } else {
                            sv.connectFrom(this.model.whereVars[j]);
                        }
                        vp.addVariable((Variable)sv);
                    }
                    String curWhere = vp.getWhereExpression();
                    if (curWhere != null) {
                        vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
                    } else {
                        vp.setWhereExpression(this.model.allWhereExpressions[i]);
                    }
                    if (!vp.isWhereExpressionValid()) {
                        StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                    }
                    if (tempTimeVar.getValueCount() == 0) continue;
                    if (freq.getMax() > 1.0) {
                        return false;
                    }
                    if (tempGroupVar.getUniqueValueCount() * tempTimeVar.getUniqueValueCount() == tempTimeVar.getValueCount()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.vertical) {
            newRange = this.getIndRange();
            this.setFormat(newRange, 113);
        } else {
            newRange = this.getDepRange();
            if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, newRange);
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.vertical) {
            newRange = this.getDepRange();
            if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        } else {
            newRange = this.getIndRange();
            this.setFormat(newRange, 113);
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updateColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.colorVar != null) {
            int num = this.colorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.colorVar, num);
                newRange.setLabel(this.colorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    protected void updateLineColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineColorRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.lineColorVar != null) {
            int num = this.lineColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineColorVar, num);
                newRange.setLabel(this.lineColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineColorRange = newRange;
        this.fireRangeEvent((byte)17, oldRange, (DataRange)newRange);
    }

    protected void updateLineRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.lineVar != null) {
            int num = this.lineVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineVar, num);
                newRange.setLabel(this.lineVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineRange = newRange;
        this.fireRangeEvent((byte)15, oldRange, (DataRange)newRange);
    }

    protected void updateShapeRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.shapeRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.shapeVar != null) {
            int num = this.shapeVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.shapeVar, num);
                newRange.setLabel(this.shapeVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.shapeRange = newRange;
        this.fireRangeEvent((byte)6, oldRange, (DataRange)newRange);
    }

    protected void updateShapeColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.shapeColorRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.shapeColorVar != null) {
            int num = this.shapeColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.shapeColorVar, num);
                newRange.setLabel(this.shapeColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.shapeColorRange = newRange;
        this.fireRangeEvent((byte)16, oldRange, (DataRange)newRange);
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (this.groupVar != null && this.groupVar.getValueCount() > 0 || this.isMultiResponse()) {
            return;
        }
        GeneralPath obstacle = new GeneralPath();
        lp.addObstacle(obstacle);
        for (int j = 0; j < l.getValueCount(); ++j) {
            try {
                double xpos = l.x.getValue(j);
                double ypos = (double)yOutputRange - l.y.getValue(j);
                Graph.addObstaclePoint(obstacle, (int)xpos, (int)ypos);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean connectNetwork() {
        DiscreteAttrMapper groupAttrMapper;
        ContinuousRangeToNumericMapper responseMapper;
        ContinuousRangeToNumericMapper timePipe2;
        ContinuousRangeToNumericMapper timePipe;
        double intvl;
        GTKFormat gtkFMT;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xRange == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.vertical) {
                this.timeVar.setFormat(gtkFMT);
            } else {
                this.responseVar.setFormat(gtkFMT);
            }
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.vertical) {
                this.responseVar.setFormat(gtkFMT);
            } else {
                this.timeVar.setFormat(gtkFMT);
            }
        }
        ValueMap map = null;
        PositionEncoder ve = this.vertical ? this.xEncoder : this.yEncoder;
        map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper timeMapper = new ContinuousRangeToNumericMapper();
        timeMapper.setMap((ContinuousRangeToNumericMap)map);
        timeMapper.input.connectFrom(((NumericVariable)this.timeVar).value);
        ContinuousRangeToNumericMapper timeMapper2 = null;
        if (ve instanceof BrokenPositionEncoder) {
            BrokenContinuousRangeToNumericMap map2 = ((BrokenPositionEncoder)ve).getBrokenValueMap();
            timeMapper2 = new ContinuousRangeToNumericMapper();
            timeMapper2.setMap((ContinuousRangeToNumericMap)map2);
            timeMapper2.input.connectFrom(((NumericVariable)this.timeVar).value);
        }
        double stride = (intvl = this.getMinimumInterval((short)113)) == 0.0 ? 0.25 * (this.xEncoder.getUpperLimit() - ve.getLowerLimit()) : this.getDefaultIntervalClusterSize(intvl, ve, true);
        if (this.getGroupDisplayInUse() == 0) {
            NumericVector groupPosition = new NumericVector();
            NumericVector groupPosition2 = timeMapper2 == null ? null : new NumericVector();
            int maxGroups = this.isMultiResponse() ? this.responseCount : (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            this.timeVar.getUniqueValueCount();
            this.groupVar.getUniqueValueCount();
            for (int i = 0; i < this.timeVar.getValueCount(); ++i) {
                try {
                    ((NumericVariable)this.timeVar).value.getValue(i);
                    int category = ((NumericVariable)this.timeVar).category.getValue(i);
                    double offset = timeMapper.getValue(i);
                    int groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                    if (this.isMultiResponse()) {
                        offset -= (double)((int)(((double)maxGroups / 2.0 - 0.5) * groupSize));
                        offset += groupSize * (double)groupCategory;
                    } else {
                        offset -= (double)((int)(((double)this.groupsPerCategory[category] / 2.0 - 0.5) * groupSize));
                        offset += groupSize * (double)this.groupCategoryLists[category].indexOf(groupCategory);
                    }
                    groupPosition.addValue(offset);
                }
                catch (MissingValueException e) {
                    groupPosition.addValue(Double.NaN);
                }
                if (timeMapper2 == null) continue;
                try {
                    timeMapper2.getValue(i);
                    groupPosition2.addValue(groupPosition.getValue(i));
                    continue;
                }
                catch (MissingValueException e) {
                    groupPosition2.addValue(Double.NaN);
                }
            }
            timePipe = groupPosition;
            timePipe2 = groupPosition2 == null ? timePipe : groupPosition2;
        } else {
            timePipe = timeMapper;
            timePipe2 = timeMapper2 == null ? timePipe : timeMapper2;
        }
        ve = this.vertical ? this.yEncoder : this.xEncoder;
        map = ve.getValueMap();
        if (this.numericResponse) {
            responseMapper = new ContinuousRangeToNumericMapper();
            responseMapper.setMap((ContinuousRangeToNumericMap)map);
            responseMapper.input.connectFrom(((NumericVariable)this.responseVar).value);
        } else {
            responseMapper = new StringToNumericMapper();
            ((StringToNumericMapper)responseMapper).setMap((StringToNumericMap)map);
            ((StringToNumericMapper)responseMapper).input.connectFrom(((StringVariable)this.responseVar).value);
        }
        ContinuousRangeToNumericMapper responseMapper2 = responseMapper;
        if (ve instanceof BrokenPositionEncoder) {
            BrokenContinuousRangeToNumericMap map2 = ((BrokenPositionEncoder)ve).getBrokenValueMap();
            responseMapper2 = new ContinuousRangeToNumericMapper();
            responseMapper2.setMap((ContinuousRangeToNumericMap)map2);
            responseMapper2.input.connectFrom(((NumericVariable)this.responseVar).value);
        }
        double baseVal = this.getBaselineValue();
        ContinuousRangeToNumericMapper baselineMapper = null;
        if (this.baselineOn) {
            baselineMapper = new ContinuousRangeToNumericMapper();
            baselineMapper.setMap((ContinuousRangeToNumericMap)map);
            baselineMapper.input.setValue(baseVal);
        }
        ContinuousRangeToNumericMapper responseMapperUnder = new ContinuousRangeToNumericMapper();
        if (this.numericResponse) {
            responseMapperUnder.setMap((ContinuousRangeToNumericMap)map);
            responseMapperUnder.input.setValue(baseVal);
        } else {
            responseMapperUnder.input.setValue(baseVal);
        }
        StringVectorVariable stackedGroupVar = null;
        StringVectorVariable stackedLabelVar = null;
        Probe probe = this.probe;
        if (this.getGroupDisplayInUse() == 2) {
            int n2 = this.groupVar.getUniqueValueCount();
            int[] groupCategoryOrder = new int[n2];
            int[] subGroupCategory = new int[n2];
            for (int i = 0; i < n2; ++i) {
                if (this.groupOrder == 3) {
                    groupCategoryOrder[i] = n2 - 1 - i;
                    subGroupCategory[i] = n2 - 1 - i;
                    continue;
                }
                groupCategoryOrder[i] = i;
                subGroupCategory[i] = i;
            }
            int n1 = this.timeVar.getUniqueValueCount();
            double[] resp = new double[n1 * n2];
            double[] catNo = new double[n1 * n2];
            String[] labels = new String[n1 * n2];
            double[] catOffset = new double[n1];
            int n = this.timeVar.getValueCount();
            int[] indexLookup = new int[n];
            for (int i = 0; i < n; ++i) {
                int c = 0;
                int g = 0;
                int pos = 0;
                try {
                    c = ((NumericVariable)this.timeVar).category.getValue(i);
                    g = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                    pos = groupCategoryOrder[g] * n1 + c;
                    catNo[pos] = c;
                    indexLookup[pos] = i;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                try {
                    catOffset[c] = timePipe.getValue(i);
                }
                catch (MissingValueException e) {
                    catOffset[c] = Double.NaN;
                }
                try {
                    resp[pos] = ((NumericVariable)this.responseVar).value.getValue(i);
                }
                catch (MissingValueException e) {
                    resp[pos] = 0.0;
                }
                if (this.labelVar == null) continue;
                try {
                    labels[pos] = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i) : ((StringVariable)this.labelVar).formattedValue.getValue(i);
                    continue;
                }
                catch (MissingValueException e) {
                    labels[pos] = "";
                }
            }
            NumericVectorVariable tempCatNoVar = new NumericVectorVariable();
            tempCatNoVar.connectFrom(catNo);
            NumericVectorVariable tempRespVar = new NumericVectorVariable();
            tempRespVar.connectFrom(resp);
            BidirectionalAccumulatorByCategory lineAccumulator = new BidirectionalAccumulatorByCategory();
            lineAccumulator.category.connectFrom(tempCatNoVar.value);
            lineAccumulator.input.connectFrom(tempRespVar.value);
            lineAccumulator.setPostAccumulate(false);
            BidirectionalAccumulatorByCategory lineAccumulatorUnder = new BidirectionalAccumulatorByCategory();
            lineAccumulatorUnder.category.connectFrom(tempCatNoVar.value);
            lineAccumulatorUnder.input.connectFrom(tempRespVar.value);
            lineAccumulatorUnder.setPostAccumulate(true);
            lineAccumulator.init(new AInitAction(null));
            lineAccumulatorUnder.init(new AInitAction(null));
            NumericVector catOffsetVector = new NumericVector();
            NumericVector respVector = new NumericVector();
            NumericVector respVectorUnder = new NumericVector();
            StringVector groupVector = new StringVector();
            for (int j = 0; j < n2; ++j) {
                try {
                    int obs;
                    int n3 = obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(subGroupCategory[j]) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(subGroupCategory[j]);
                    if (obs < 0) {
                        obs = this.getFirstMissingValueIndex(this.groupVar);
                    }
                    String grp = this.stringGroupVar.value.getValue(obs);
                    int offset = j * n1;
                    for (int i = 0; i < n1; ++i) {
                        catOffsetVector.addValue(catOffset[i]);
                        respVector.addValue(lineAccumulator.getValue(offset + i));
                        respVectorUnder.addValue(lineAccumulatorUnder.getValue(offset + i));
                        groupVector.addValue(grp);
                    }
                    continue;
                }
                catch (MissingValueException obs) {
                    // empty catch block
                }
            }
            responseMapper.input.connectFrom((NumericPipe)respVector);
            responseMapperUnder.input.connectFrom((NumericPipe)respVectorUnder);
            timePipe = catOffsetVector;
            stackedGroupVar = new StringVectorVariable();
            stackedGroupVar.connectFrom((StringPipe)groupVector);
            stackedGroupVar.setBlankMissing(false);
            if (this.labelVar != null) {
                stackedLabelVar = new StringVectorVariable();
                stackedLabelVar.connectFrom(labels);
            }
            if (!this.isMultiResponse()) {
                probe = this.rearrangeProbePipes(indexLookup);
            }
        }
        StringToColorMapper colorMapper = null;
        if (this.colorVar != null && this.colorEncoder != null) {
            map = this.colorEncoder.getValueMap();
            if (map instanceof StringToColorMap) {
                colorMapper = new StringToColorMapper();
                if (stackedGroupVar != null) {
                    colorMapper.input.connectFrom(stackedGroupVar.value);
                } else {
                    colorMapper.input.connectFrom(((StringVariable)this.colorVar).value);
                }
                colorMapper.setReplaceMissingValues(true);
                if (this.gIndexVar == null) {
                    colorMapper.setMap((StringToColorMap)map);
                } else {
                    for (int i = 0; i < this.colorVar.getUniqueValueCount(); ++i) {
                        Color c = this.getIndexColor(this.colorEncoder, this.colorVar, i, (ColorAttr)this.fillStyle);
                        try {
                            String gval = ((StringVariable)this.colorVar).uniqueValue.getValue(i);
                            colorMapper.add(gval, c);
                            continue;
                        }
                        catch (MissingValueException e) {
                            colorMapper.setMissingReplacement(c, e.getMissingValue());
                        }
                    }
                }
            } else {
                return false;
            }
        }
        StringToColorMapper lineColorMapper = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            HashMap lcht = this.lineColorEncoder.colorList;
            lineColorMapper = new StringToColorMapper();
            if (stackedGroupVar != null) {
                lineColorMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                lineColorMapper.input.connectFrom(((StringVariable)this.lineColorVar).value);
            }
            lineColorMapper.setReplaceMissingValues(true);
            for (int i = 0; i < this.lineColorVar.getUniqueValueCount(); ++i) {
                Color c;
                if (this.gIndexVar == null) {
                    try {
                        String lcval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i);
                        c = (Color)lcht.get(lcval);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency(this.lineStyle.getColor());
                    }
                } else {
                    c = this.getIndexColor(this.lineColorEncoder, this.lineColorVar, i, (ColorAttr)this.lineStyle);
                }
                try {
                    String gval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i);
                    lineColorMapper.add(gval, c);
                    continue;
                }
                catch (MissingValueException e) {
                    lineColorMapper.setMissingReplacement(c, e.getMissingValue());
                }
            }
        }
        StringToNumberMapper lineWidthMapper = null;
        StringToNumberMapper linePatternMapper = null;
        if (this.lineVar != null && this.lineEncoder != null) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            lineWidthMapper = new StringToNumberMapper();
            linePatternMapper = new StringToNumberMapper();
            if (stackedGroupVar != null) {
                lineWidthMapper.input.connectFrom(stackedGroupVar.value);
                linePatternMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                lineWidthMapper.input.connectFrom(((StringVariable)this.lineVar).value);
                linePatternMapper.input.connectFrom(((StringVariable)this.lineVar).value);
            }
            lineWidthMapper.setReplaceMissingValues(true);
            lineWidthMapper.setLabelMissingValues(true);
            linePatternMapper.setReplaceMissingValues(true);
            linePatternMapper.setLabelMissingValues(true);
            for (int i = 0; i < this.lineVar.getUniqueValueCount(); ++i) {
                LineAttrs ls;
                if (this.gIndexVar == null) {
                    try {
                        String lval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                        ls = (LineAttrs)ht.get(lval);
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                } else {
                    int obs = ((StringVariable)this.lineVar).getFirstOccurringValueIndex(i);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        ls = ll[idx % ll.length];
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                }
                try {
                    String gval = ((StringVariable)this.lineVar).uniqueValue.getValue(i);
                    lineWidthMapper.add(gval, (Number)new Double(this.lineStyle.getWidth()));
                    linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                    continue;
                }
                catch (MissingValueException e) {
                    lineWidthMapper.setMissingReplacement((double)this.lineStyle.getWidth(), e.getMissingValue());
                    linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                }
            }
        }
        StringToColorMapper shapeColorMapper = null;
        if (this.shapeColorVar != null && this.shapeColorEncoder != null) {
            HashMap scht = this.shapeColorEncoder.colorList;
            shapeColorMapper = new StringToColorMapper();
            if (stackedGroupVar != null) {
                shapeColorMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeColorMapper.input.connectFrom(((StringVariable)this.shapeColorVar).value);
            }
            shapeColorMapper.setReplaceMissingValues(true);
            for (int i = 0; i < this.shapeColorVar.getUniqueValueCount(); ++i) {
                Color c;
                if (this.gIndexVar == null) {
                    try {
                        String scval = ((StringVariable)this.shapeColorVar).uniqueValue.getValue(i);
                        c = (Color)scht.get(scval);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)this.markerStyle);
                    }
                } else {
                    c = this.getIndexColor(this.shapeColorEncoder, this.shapeColorVar, i, (ColorAttr)this.markerStyle);
                }
                try {
                    String gval = ((StringVariable)this.shapeColorVar).uniqueValue.getValue(i);
                    shapeColorMapper.add(gval, c);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeColorMapper.setMissingReplacement(c, e.getMissingValue());
                }
            }
        }
        this.markerFillStyle.setTransparency(this.markerStyle.getTransparency());
        StringToColorMapper shapeFillColorMapper = null;
        if (this.shapeFillColorVar != null && this.shapeFillColorEncoder != null) {
            HashMap scht = this.shapeFillColorEncoder.colorList;
            shapeFillColorMapper = new StringToColorMapper();
            if (stackedGroupVar != null) {
                shapeFillColorMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeFillColorMapper.input.connectFrom(((StringVariable)this.shapeFillColorVar).value);
            }
            shapeFillColorMapper.setReplaceMissingValues(true);
            for (int i = 0; i < this.shapeFillColorVar.getUniqueValueCount(); ++i) {
                Color c;
                if (this.gIndexVar == null) {
                    try {
                        String scval = ((StringVariable)this.shapeFillColorVar).uniqueValue.getValue(i);
                        c = (Color)scht.get(scval);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)this.markerFillStyle);
                    }
                } else {
                    c = this.getIndexColor(this.shapeFillColorEncoder, this.shapeFillColorVar, i, (ColorAttr)this.markerFillStyle);
                }
                try {
                    String gval = ((StringVariable)this.shapeFillColorVar).uniqueValue.getValue(i);
                    shapeFillColorMapper.add(gval, c);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeFillColorMapper.setMissingReplacement(c, e.getMissingValue());
                }
            }
        }
        StringToNumberMapper shapeMapper = null;
        if (this.shapeVar != null && this.shapeEncoder != null) {
            int[] sl = this.shapeEncoder.shapeArray;
            HashMap scht = this.shapeEncoder.shapeList;
            shapeMapper = new StringToNumberMapper();
            if (stackedGroupVar != null) {
                shapeMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeMapper.input.connectFrom(((StringVariable)this.shapeVar).value);
            }
            shapeMapper.setReplaceMissingValues(true);
            shapeMapper.setLabelMissingValues(true);
            for (int i = 0; i < this.shapeVar.getUniqueValueCount(); ++i) {
                int sh;
                if (this.gIndexVar == null) {
                    try {
                        String sval = ((StringVariable)this.shapeVar).uniqueValue.getValue(i);
                        sh = (Integer)scht.get(sval);
                    }
                    catch (MissingValueException e) {
                        sh = this.markerStyle.getShape();
                    }
                } else {
                    int obs = ((StringVariable)this.shapeVar).getFirstOccurringValueIndex(i);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        sh = sl[idx % sl.length];
                    }
                    catch (MissingValueException e) {
                        sh = this.markerStyle.getShape();
                    }
                }
                try {
                    String gval = ((StringVariable)this.shapeVar).uniqueValue.getValue(i);
                    shapeMapper.add(gval, (Number)sh);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeMapper.setMissingReplacement((double)sh, e.getMissingValue());
                }
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.setMarkerTransparency(this.markerStyle.getTransparency() < 0.0 ? this.dataTransparency : this.markerStyle.getTransparency());
            groupAttrMapper.variable = stackedGroupVar != null ? stackedGroupVar.value : (this.numericGroup ? ((NumericVariable)this.groupVar).formattedValue : ((StringVariable)this.groupVar).formattedValue);
            groupAttrMapper.fillColorMapper = colorMapper;
            groupAttrMapper.lineColorMapper = lineColorMapper;
            groupAttrMapper.linePatternMapper = linePatternMapper;
            groupAttrMapper.markerColorMapper = shapeColorMapper;
            groupAttrMapper.markerSymbolMapper = shapeMapper;
            if (this.filledOutlinedMarker) {
                groupAttrMapper.markerColorMapper = shapeColorMapper;
                groupAttrMapper.markerFillColorMapper = shapeFillColorMapper;
            }
        }
        ColorProperty color = new ColorProperty();
        if (this.colorVar != null && colorMapper != null) {
            if (groupAttrMapper != null) {
                color.connectFrom(groupAttrMapper.fillColor);
            } else {
                color.connectFrom((ColorPipe)colorMapper);
            }
        } else {
            color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        }
        ColorProperty lineColor = new ColorProperty();
        if (this.lineColorVar != null && lineColorMapper != null) {
            if (groupAttrMapper != null) {
                lineColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                lineColor.connectFrom((ColorPipe)lineColorMapper);
            }
        } else {
            lineColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        }
        NumericProperty linePattern = new NumericProperty();
        if (this.lineVar != null && linePatternMapper != null) {
            if (groupAttrMapper != null) {
                linePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            } else {
                linePattern.connectFrom((NumericPipe)linePatternMapper);
            }
        } else {
            linePattern.setValue((double)this.lineStyle.getLinePattern());
        }
        NumericProperty lineWidth = new NumericProperty();
        if (this.lineVar != null && lineWidthMapper != null) {
            lineWidth.connectFrom((NumericPipe)lineWidthMapper);
        } else {
            lineWidth.setValue((double)this.lineStyle.getWidth());
        }
        ColorProperty shapeColor = new ColorProperty();
        if (this.shapeColorVar != null && shapeColorMapper != null) {
            if (this.lineOn && this.lineColorEncoder == null) {
                shapeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency()));
            } else if (groupAttrMapper != null) {
                shapeColor.connectFrom((ColorPipe)groupAttrMapper.markerColor);
            } else {
                shapeColor.connectFrom((ColorPipe)shapeColorMapper);
            }
        } else {
            shapeColor.setValue(this.applyDataTransparency((ColorAttr)this.markerStyle));
        }
        NumericProperty shape = new NumericProperty();
        if (this.shapeVar != null && shapeMapper != null) {
            if (groupAttrMapper != null) {
                shape.connectFrom((IntegerPipe)groupAttrMapper.markerSymbol);
            } else {
                shape.connectFrom((NumericPipe)shapeMapper);
            }
        } else {
            shape.setValue((double)this.markerStyle.getShape());
        }
        ColorProperty labelColor = new ColorProperty();
        labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
        this.networkRoot.removeAllElements();
        if (this.baselineOn) {
            LineSegment baseline = new LineSegment();
            this.networkRoot.addElement((Element)baseline);
            if (this.vertical) {
                baseline.beginX.setValue(this.xEncoder.getLowerLimit());
                baseline.beginY.connectFrom((NumericPipe)baselineMapper);
                baseline.endX.setValue(this.xEncoder.getUpperLimit());
                baseline.endY.connectFrom((NumericPipe)baselineMapper);
            } else {
                baseline.beginY.setValue(this.yEncoder.getLowerLimit());
                baseline.beginX.connectFrom((NumericPipe)baselineMapper);
                baseline.endY.setValue(this.yEncoder.getUpperLimit());
                baseline.endX.connectFrom((NumericPipe)baselineMapper);
            }
            baseline.color.setValue(this.applyDataTransparency(this.baselineStyle.getColor()));
            baseline.lineWidth.setValue((double)this.baselineStyle.getWidth());
            baseline.setStipple(this.baselineStyle.getStipplePattern(), this.baselineStyle.getStippleFactor());
        }
        if (this.lineOn || this.fillOn) {
            Object lineConnector = null;
            lineConnector = this.smooth ? new SplineConnector() : new LineConnector();
            lineConnector.setSubpixelRendering(this.subpixelRendering);
            this.networkRoot.addElement((Element)lineConnector);
            if (this.vertical) {
                lineConnector.pointX.connectFrom((NumericPipe)timePipe);
                lineConnector.pointY.connectFrom((NumericPipe)responseMapper);
            } else {
                lineConnector.pointY.connectFrom((NumericPipe)timePipe);
                lineConnector.pointX.connectFrom((NumericPipe)responseMapper);
            }
            lineConnector.lineOn.setValue(this.lineOn);
            lineConnector.color.connectFrom((ColorPipe)lineColor);
            lineConnector.linePattern.connectFrom((NumericPipe)linePattern);
            lineConnector.lineWidth.connectFrom((NumericPipe)lineWidth);
            lineConnector.fillOn.setValue(this.fillOn);
            lineConnector.fillColor.connectFrom((ColorPipe)color);
            if (this.vertical) {
                lineConnector.pointX2.connectFrom((NumericPipe)timePipe);
                lineConnector.pointY2.connectFrom((NumericPipe)responseMapperUnder);
            } else {
                lineConnector.pointY2.connectFrom((NumericPipe)timePipe);
                lineConnector.pointX2.connectFrom((NumericPipe)responseMapperUnder);
            }
            lineConnector.setSkipMissingOn(this.breakMissing);
            lineConnector.setMultipleGroup(true);
            if (this.groupVar != null) {
                if (stackedGroupVar != null) {
                    lineConnector.stringGroup.connectFrom(stackedGroupVar.value);
                } else if (this.groupVar instanceof StringVariable) {
                    lineConnector.stringGroup.connectFrom(((StringVariable)this.groupVar).formattedValue);
                } else {
                    lineConnector.stringGroup.connectFrom(((NumericVariable)this.groupVar).formattedValue);
                }
            }
            lineConnector.setPresortRequired(true);
            lineConnector.setConnectionOrder(this.connectionOrder);
            lineConnector.setSkinType(this.skinType);
            lineConnector.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            lineConnector.setUserData((Object)probe);
        }
        int markerSize = this.markerStyle.getSize();
        if (this.markerOn) {
            markerSize = this.getScaledMarkerSize(markerSize);
            int edgeWidth = StatGraph.getMarkerEdgeWidth(markerSize, this.markerStyle.getWeight());
            Marker marker = new Marker();
            this.networkRoot.addElement((Element)marker);
            marker.setSVGRender(StatGraph.VGF);
            if (this.vertical) {
                marker.coordX.connectFrom((NumericPipe)timePipe2);
                marker.coordY.connectFrom((NumericPipe)responseMapper2);
            } else {
                marker.coordY.connectFrom((NumericPipe)timePipe2);
                marker.coordX.connectFrom((NumericPipe)responseMapper2);
            }
            marker.weightedEdgeEnabled.setValue(false);
            marker.edgeWeight.setValue(this.markerStyle.getWeight());
            marker.type.connectFrom((NumericPipe)shape);
            marker.size.setValue(markerSize);
            marker.edgeWidth.setValue(edgeWidth);
            marker.color.connectFrom((ColorPipe)shapeColor);
            marker.edgeColor.connectFrom((ColorPipe)shapeColor);
            marker.setSkinType(this.skinType);
            marker.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            marker.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4));
            marker.setUserData((Object)probe);
            if (this.filledOutlinedMarker) {
                ColorProperty shapeFillColor = new ColorProperty();
                if (this.shapeFillColorVar != null && shapeFillColorMapper != null) {
                    if (groupAttrMapper != null) {
                        shapeFillColor.connectFrom(groupAttrMapper.markerFillColor);
                    } else {
                        shapeFillColor.connectFrom((ColorPipe)shapeFillColorMapper);
                    }
                } else {
                    shapeFillColor.setValue(this.applyDataTransparency((ColorAttr)this.markerFillStyle));
                }
                ColorProperty shapeOutlineColor = new ColorProperty();
                boolean undoAlpha = false;
                if (!this.useMarkerOutlineAttrsColor && this.shapeColorVar != null && shapeColorMapper != null) {
                    if (groupAttrMapper != null) {
                        if (this.lineOn && this.lineColorVar == null) {
                            shapeOutlineColor.connectFrom((ColorPipe)lineColor);
                        } else {
                            shapeOutlineColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                        }
                    } else if (this.lineOn) {
                        shapeOutlineColor.connectFrom((ColorPipe)lineColor);
                    } else {
                        shapeOutlineColor.connectFrom((ColorPipe)shapeColorMapper);
                        undoAlpha = true;
                    }
                } else {
                    shapeOutlineColor.setValue(this.applyDataTransparency((ColorAttr)this.markerOutlineStyle));
                }
                marker.type.init(new AInitAction(null));
                marker.color.init(new AInitAction(null));
                marker.edgeColor.init(new AInitAction(null));
                marker.edgeWidth.init(new AInitAction(null));
                marker.size.init(new AInitAction(null));
                shapeFillColor.init(new AInitAction(null));
                shapeOutlineColor.init(new AInitAction(null));
                IntegerVector type = new IntegerVector();
                ColorVector mColor = new ColorVector();
                ColorVector eColor = new ColorVector();
                NumericVector eWidth = new NumericVector();
                NumericVector size = new NumericVector();
                int n = this.timeVar.getValueCount();
                try {
                    for (int i = 0; i < n; ++i) {
                        int s = marker.type.getValue(i);
                        if (Markers.isFilled((int)s)) {
                            double ew = marker.edgeWidth.getValue(i);
                            Color fc = shapeFillColor.getValue(i);
                            Color oc = shapeOutlineColor.getValue(i);
                            if (undoAlpha) {
                                oc = this.applyNewTransparency(oc, this.markerOutlineStyle.getTransparency());
                            }
                            if (this.useMarkerOutlineAttrsThickness) {
                                if (this.markerOutlineStyle.getWidth() < 1) {
                                    eWidth.addValue(ew);
                                    oc = fc;
                                } else {
                                    eWidth.addValue((double)this.markerOutlineStyle.getWidth());
                                }
                            } else {
                                eWidth.addValue(ew);
                            }
                            if (this.skinType != 0) {
                                oc = fc;
                            }
                            mColor.addValue(fc);
                            eColor.addValue(oc);
                            if (ew > 1.0 && !fc.equals(oc)) {
                                size.addValue((double)marker.size.getValue(i) + ew);
                            } else {
                                size.addValue((double)marker.size.getValue(i));
                            }
                        } else {
                            if (this.useMarkerAttrsColor) {
                                mColor.addValue(this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()));
                                eColor.addValue(this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()));
                            } else {
                                mColor.addValue(marker.color.getValue(i));
                                eColor.addValue(marker.edgeColor.getValue(i));
                            }
                            eWidth.addValue((double)marker.edgeWidth.getValue(i));
                            size.addValue((double)marker.size.getValue(i));
                        }
                        if (s == 0) {
                            type.addValue(187);
                            continue;
                        }
                        if (s == 16) {
                            type.addValue(188);
                            continue;
                        }
                        type.addValue(s);
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                marker.color.connectFrom((ColorPipe)mColor);
                marker.edgeColor.connectFrom((ColorPipe)eColor);
                marker.edgeWidth.connectFrom((NumericPipe)eWidth);
                marker.size.connectFrom((NumericPipe)size);
                marker.type.connectFrom((IntegerPipe)type);
            }
        }
        if (this.vertexLabelOn || this.labelVar != null && this.dataLabelPosition == -1) {
            if (this.labelVar != null) {
                if (stackedLabelVar != null) {
                    this.plLayout.label.connectFrom(stackedLabelVar.value);
                } else if (this.numericLabel) {
                    this.plLayout.label.connectFrom(((NumericVariable)this.labelVar).formattedValue);
                } else {
                    this.plLayout.label.connectFrom(((StringVariable)this.labelVar).formattedValue);
                }
            } else {
                NumericVectorVariable labelVar;
                if (this.numericResponse) {
                    labelVar = new NumericVectorVariable();
                    labelVar.connectFrom((NumericPipe)responseMapper.input);
                } else {
                    labelVar = new StringVectorVariable();
                    ((StringVectorVariable)labelVar).connectFrom((StringPipe)((StringToNumericMapper)responseMapper).input);
                }
                if (this.labelFormat != null) {
                    labelVar.setFormat(new GTKFormat((Format)this.labelFormat));
                } else {
                    SASFormat fmt = this.isMultiResponse() ? this.getFormat(610) : this.getFormat(2);
                    fmt = fmt == null && this.numericResponse ? DataModel.defaultFormat : TimeSeriesOverlay.getFormatWithMaxWidth(fmt);
                    labelVar.setFormat(new GTKFormat((Format)fmt));
                }
                this.plLayout.label.connectFrom(labelVar.formattedValue);
            }
            if (this.markerOn) {
                this.plLayout.setMarkerSize(markerSize + 2);
            } else {
                this.plLayout.setMarkerSize(2);
            }
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            this.plLayout.setFontMetrics(fm);
            if (this.vertical) {
                this.plLayout.x.connectFrom((NumericPipe)timePipe);
                this.plLayout.y.connectFrom((NumericPipe)responseMapper);
            } else {
                this.plLayout.y.connectFrom((NumericPipe)timePipe);
                this.plLayout.x.connectFrom((NumericPipe)responseMapper);
            }
            RasterLabel label = new RasterLabel();
            this.networkRoot.addElement((Element)label);
            label.trimOn.setValue(true);
            label.string.connectFrom((StringPipe)this.plLayout.adjustedLabel);
            label.transform.translateX.connectFrom(this.plLayout.xpos);
            label.transform.translateY.connectFrom(this.plLayout.ypos);
            label.horizontalJustification.connectFrom(this.plLayout.hAlign);
            label.verticalJustification.connectFrom(this.plLayout.vAlign);
            label.color.connectFrom((ColorPipe)labelColor);
            label.fontName.setValue(this.labelStyle.getFont().getName());
            label.fontSize.setValue(this.labelStyle.getFont().getSize());
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        }
        if (this.isConditionalHilited()) {
            for (int i = 0; i < this.getNumCHPipes(); ++i) {
                BooleanVector bv = this.getCHPipe(i);
                com.sas.graphics.util.gtk.gl.Image tag = RPFUtil.newTagElement(i, true, this.networkRoot.getChannel().getComponent());
                this.networkRoot.addElement((Element)tag);
                tag.transform.translateX.connectFrom((NumericPipe)timePipe);
                tag.transform.translateY.connectFrom((NumericPipe)responseMapper);
                tag.horizontalJustification.setValue(2);
                tag.verticalJustification.setValue(0);
                tag.visibility.connectFrom((BooleanPipe)bv);
            }
        }
        this.needConnect = false;
        return true;
    }

    private Color applyNewTransparency(Color c, double transparency) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        Color c2 = new Color(r, g, b);
        return this.applyDataTransparency(c2, transparency);
    }

    private double getDefaultIntervalClusterSize(double minInterval, PositionEncoder encoder, boolean estimate) {
        return this.getMaximumIntervalSize(minInterval, encoder, estimate);
    }

    private int getFirstMissingValueIndex(Variable var) {
        int n = var.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                if (var instanceof NumericVariable) {
                    ((NumericVariable)var).value.getValue(i);
                    continue;
                }
                ((StringVariable)var).value.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                return i;
            }
        }
        return -1;
    }

    private void preProcessVars() {
        this.timeVar_sav = this.timeVar;
        int n = ((NumericVariable)this.timeVar).getValueCount();
        int nResp = this.multiResponseVars.length;
        int rows = n * nResp;
        double[] tval = new double[rows];
        double[] resp = new double[rows];
        String[] grp = new String[rows];
        StringVector probeInfoTime = new StringVector();
        StringVector probeInfoResp = new StringVector();
        probeInfoTime.setSize(rows);
        probeInfoResp.setSize(rows);
        for (int i = 0; i < nResp; ++i) {
            String g = this.multiResponseVars[i].getLabel();
            int offset = i * n;
            if (this.groupOrder != 0) {
                for (int l = 0; l < this.responseCount; ++l) {
                    if (!this.multiResponseLabels[l].equals(g)) continue;
                    offset = l * n;
                    break;
                }
            }
            String tLabel = this.timeVar_sav.getLabel();
            String rLabel = g;
            for (int j = 0; j < n; ++j) {
                String formattedRespV;
                String formattedTimeV;
                try {
                    tval[offset + j] = ((NumericVariable)this.timeVar).value.getValue(j);
                    formattedTimeV = ((NumericVariable)this.timeVar).formattedValue.getValue(j);
                }
                catch (MissingValueException e) {
                    tval[offset + j] = Double.NaN;
                    formattedTimeV = ".";
                }
                try {
                    resp[offset + j] = this.multiResponseVars[i].value.getValue(j);
                    formattedRespV = this.multiResponseVars[i].formattedValue.getValue(j);
                }
                catch (MissingValueException e) {
                    resp[offset + j] = Double.NaN;
                    formattedRespV = ".";
                }
                grp[offset + j] = g;
                probeInfoTime.setValueAt(tLabel + " = " + formattedTimeV, offset + j);
                probeInfoResp.setValueAt(rLabel + " = " + formattedRespV, offset + j);
            }
        }
        this.timeVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.timeVar).connectFrom(tval);
        this.timeVar.setLabel(this.timeVar_sav.getLabel());
        this.responseVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.responseVar).connectFrom(resp);
        this.groupVar = new StringVectorVariable();
        ((StringVectorVariable)this.groupVar).connectFrom(grp);
        this.colorVar = this.groupVar;
        this.lineVar = this.groupVar;
        this.lineColorVar = this.groupVar;
        this.shapeVar = this.groupVar;
        this.shapeColorVar = this.groupVar;
        this.stringGroupVar = (StringVariable)this.groupVar;
        if (this.filledOutlinedMarker) {
            this.shapeFillColorVar = this.groupVar;
        }
        if (this.probe != null) {
            this.probe.removeAll();
            this.probe.addPipe(" ", (Pipe)probeInfoTime);
            this.probe.addPipe(" ", (Pipe)probeInfoResp);
            this.probe.setConnectionString("");
        }
    }

    private void postProcessVars() {
        this.timeVar = this.timeVar_sav;
        this.groupVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.shapeVar = null;
        this.shapeColorVar = null;
        this.stringGroupVar = null;
        this.shapeFillColorVar = null;
    }

    private Color getIndexColor(ColorEncoder encoder, Variable colorvar, int i, ColorAttr defaultAttr) {
        Color c;
        Color[] cl = encoder.colorArray;
        int obs = ((StringVariable)colorvar).getFirstOccurringValueIndex(i);
        try {
            int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
            c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
        }
        catch (MissingValueException e) {
            c = this.applyDataTransparency(defaultAttr);
        }
        return c;
    }

    private int getScaledMarkerSize(int size) {
        if (this.scaleMarkers) {
            double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
            double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
            int newSize = (int)((double)size * Math.pow(Math.min(ratio_w, ratio_h), 0.25) + 0.5);
            size = Math.min(size, Math.max(5, newSize));
        }
        return size;
    }

    private double getBaselineValue() {
        PositionEncoder encoder;
        double baseVal = 0.0;
        PositionEncoder positionEncoder = encoder = this.vertical ? this.yEncoder : this.xEncoder;
        if (!this.numericResponse) {
            return encoder.getLowerLimit();
        }
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)encoder.getValueMap();
        double min = crnm.getInputMin();
        double max = crnm.getInputMax();
        double minExtend = crnm.getInverseValue(encoder.getLowerLimit());
        double maxExtend = crnm.getInverseValue(encoder.getUpperLimit());
        if (encoder.isReversed()) {
            double tmp = min;
            min = max;
            max = tmp;
            tmp = minExtend;
            minExtend = maxExtend;
            maxExtend = tmp;
        }
        switch (this.baselineInterceptType) {
            default: {
                if (max * min <= 0.0) {
                    baseVal = 0.0;
                    break;
                }
                if (min > 0.0) {
                    baseVal = minExtend;
                    break;
                }
                baseVal = maxExtend;
                break;
            }
            case 2: {
                baseVal = min;
                break;
            }
            case 3: {
                baseVal = minExtend;
                break;
            }
            case 4: {
                baseVal = max;
                break;
            }
            case 5: {
                baseVal = maxExtend;
                break;
            }
            case 1: {
                baseVal = this.baseline;
            }
        }
        return baseVal;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        if (this.isConditionalHilited()) {
            left = Math.max(left, RPFUtil.getCalloutTagWidth());
            bottom = Math.max(bottom, RPFUtil.getCalloutTagHeight());
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double offset = 0.0;
        if (this.vertical) {
            if (dimension == 1) {
                ValueMap vm = this.xEncoder.getValueMap();
                if (this.getGroupDisplayInUse() == 0) {
                    double intvl = this.getMinimumInterval((short)113);
                    if (intvl == 0.0) {
                        offset = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    } else {
                        offset = this.getDefaultIntervalClusterSize(intvl, this.xEncoder, true);
                        int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                        double groupSize = offset / (double)maxGroups;
                        int scale = this.getElementOffset();
                        if ((double)scale > groupSize) {
                            offset += (double)scale - groupSize;
                        }
                        offset += (double)(2 * StatGraph.getExtraPadding());
                    }
                } else {
                    offset = this.getElementOffset() + 2 * StatGraph.getExtraPadding();
                }
            } else if (dimension == 2) {
                offset = this.getElementOffset() + 2 * StatGraph.getExtraPadding();
            }
        } else if (dimension == 1) {
            offset = this.getElementOffset() + 2 * StatGraph.getExtraPadding();
        } else if (dimension == 2) {
            ValueMap vm = this.yEncoder.getValueMap();
            if (this.getGroupDisplayInUse() == 0) {
                double intvl = this.getMinimumInterval((short)113);
                if (intvl == 0.0) {
                    offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                } else {
                    offset = this.getDefaultIntervalClusterSize(intvl, this.yEncoder, true);
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double groupSize = offset / (double)maxGroups;
                    int scale = this.getElementOffset();
                    if ((double)scale > groupSize) {
                        offset += (double)scale - groupSize;
                    }
                    offset += (double)(2 * StatGraph.getExtraPadding());
                }
            } else {
                offset = this.getElementOffset() + 2 * StatGraph.getExtraPadding();
            }
        }
        return offset;
    }

    private int getElementOffset() {
        double lw = this.lineStyle.getWidth();
        int offset = (int)lw * 2 - 1;
        if (this.isMarkerOn()) {
            int ms = this.getScaledMarkerSize(this.markerStyle.getSize());
            int edgeWidth = StatGraph.getMarkerEdgeWidth(ms, this.markerStyle.getWeight());
            offset = Math.max(offset, ms + edgeWidth);
        }
        return offset;
    }

    @Override
    public String[] getRawUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        return super.getRawUniqueValues(role);
    }

    @Override
    public String[] getUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        StringVariable group = (StringVariable)this.connectCategory(role, true);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        if (this.groupVar != null) {
            StringVariable rawGroup = StatGraph.isOLAP() ? group : this.connectRaw((short)3);
            vp.addVariable((Variable)rawGroup);
            if (this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
                int sort;
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort((Variable)rawGroup, sort);
                } else {
                    vp.setSort((Variable)group, sort);
                }
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                if (this.groupOrder == 3) {
                    gv[i] = group.uniqueValue.getValue(gv.length - 1 - i);
                    continue;
                }
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    @Override
    public int[] getLinePatterns() {
        if (!this.isLineOn()) {
            return new int[0];
        }
        if (this.lineEncoder == null) {
            return new int[]{this.lineStyle.getLinePattern()};
        }
        if (this.isMultiResponse()) {
            return this.getResponsePatterns();
        }
        return this.getGroupPatterns();
    }

    @Override
    public int[] getLineWidths() {
        return new int[]{this.lineStyle.getWidth()};
    }

    @Override
    public Color[] getLineColors() {
        if (!this.isLineOn()) {
            return new Color[0];
        }
        if (this.lineColorEncoder == null) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor())};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(46);
        }
        return this.getGroupColors(46);
    }

    @Override
    public Color[] getFillColors() {
        if (!this.isFillOn()) {
            return new Color[0];
        }
        if (this.colorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(6);
        }
        return this.getGroupColors(6);
    }

    public Color[] getMarkerColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        if (this.shapeColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerStyle)};
        }
        if (this.isMultiResponse()) {
            if (this.lineOn && this.lineColorEncoder == null) {
                return new Color[]{this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency())};
            }
            return this.getResponseColors(45);
        }
        if (this.lineOn && this.lineColorEncoder == null) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency())};
        }
        return this.getGroupColors(45);
    }

    public Color[] getMarkerFillColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        this.markerFillStyle.setTransparency(this.markerStyle.getTransparency());
        if (this.shapeFillColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerFillStyle)};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(69);
        }
        return this.getGroupColors(69);
    }

    public Color[] getMarkerOutlineColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        if (this.useMarkerOutlineAttrsColor || this.shapeColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerOutlineStyle)};
        }
        if (this.isMultiResponse()) {
            if (!this.lineOn) {
                return this.getResponseColors(70);
            }
            return this.getLineColors();
        }
        if (!this.lineOn || this.hasAttrVar("GROUP") && this.lineColorVar != null) {
            return this.getGroupColors(70);
        }
        return this.getLineColors();
    }

    @Override
    public int[] getMarkerShapes() {
        if (!this.isMarkerOn()) {
            return new int[0];
        }
        if (this.shapeEncoder == null) {
            return new int[]{this.markerStyle.getShape()};
        }
        if (this.isMultiResponse()) {
            return this.getResponseShapes();
        }
        return this.getGroupShapes();
    }

    @Override
    public int[] getMarkerWidths() {
        return new int[]{this.markerStyle.getSize()};
    }

    @Override
    public int[] getMarkerWeights() {
        return new int[]{this.markerStyle.getWeight()};
    }

    @Override
    public String[] getGroupValues() {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        if (this.groupVar != null) {
            if (this.groupVar instanceof OLAPLevelVariable) {
                OLAPVariableFactory fac = this.model.getOLAPVarFactory();
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.groupVar.getColumnName());
                DataTreeGroupNode n = fac.createSubTree(list);
                String[] values = new String[n.getChildCount()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = n.getChildAt(i).toString();
                }
                return values;
            }
            if (this.groupOrder == 0 || this.groupOrder == 3) {
                return this.getUniqueGroupValues((short)3);
            }
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return new String[0];
    }

    private int[] getGroupShapes() {
        NumericVectorVariable indexV;
        DiscreteAttrMapper groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        StringVariable shapeV = (StringVariable)this.connectCategory((short)8, true);
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)shapeV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        int[] shapes = new int[]{};
        HashMap ht = this.shapeEncoder.shapeList;
        int[] sl = this.shapeEncoder.shapeArray;
        String[] values = this.getUniqueValues((short)8);
        shapes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            shapes[i] = -1;
            String gval = values[i];
            if (groupAttrMapper != null) {
                shapes[i] = groupAttrMapper.getMarkerSymbol(gval);
            }
            if (shapes[i] >= 0) continue;
            if (indexV == null) {
                shapes[i] = (Integer)ht.get(gval);
                continue;
            }
            int obs = this.groupOrder == 3 ? shapeV.getFirstOccurringValueIndex(values.length - 1 - i) : shapeV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                shapes[i] = sl[idx % sl.length];
                continue;
            }
            catch (MissingValueException e) {
                shapes[i] = this.markerStyle.getShape();
            }
        }
        return shapes;
    }

    private Color[] getGroupColors(int role) {
        NumericVectorVariable indexV;
        DiscreteAttrMapper groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        StringVariable colorV = null;
        HashMap ht = null;
        Color[] cl = null;
        String[] values = null;
        if (StatGraph.isOLAP()) {
            values = this.getUniqueValues((short)46);
            ht = this.colorEncoder.colorList;
            cl = new Color[this.getGroupValues().length];
            ArrayList<String> gValues = new ArrayList<String>();
            int cnt = 0;
            for (int i = 0; i < values.length; ++i) {
                String str = Overlay.getTopLevelValue(values[i]);
                if (gValues.contains(str)) continue;
                cl[cnt++] = (Color)ht.get(values[i]);
                gValues.add(str);
            }
            return cl;
        }
        FillAttrs defaultAttr = null;
        switch (role) {
            case 6: {
                colorV = (StringVariable)this.connectCategory((short)6, true);
                ht = this.colorEncoder.colorList;
                cl = this.colorEncoder.colorArray;
                values = this.getUniqueValues((short)6);
                defaultAttr = this.fillStyle;
                break;
            }
            case 46: {
                colorV = (StringVariable)this.connectCategory((short)46, true);
                ht = this.lineColorEncoder.colorList;
                cl = this.lineColorEncoder.colorArray;
                values = this.getUniqueValues((short)46);
                defaultAttr = this.lineStyle;
                break;
            }
            case 45: {
                colorV = (StringVariable)this.connectCategory((short)45, true);
                ht = this.shapeColorEncoder.colorList;
                cl = this.shapeColorEncoder.colorArray;
                values = this.getUniqueValues((short)45);
                defaultAttr = this.markerStyle;
                break;
            }
            case 69: {
                colorV = (StringVariable)this.connectCategory((short)69, true);
                ht = this.shapeFillColorEncoder.colorList;
                cl = this.shapeFillColorEncoder.colorArray;
                values = this.getUniqueValues((short)69);
                defaultAttr = this.markerFillStyle;
                break;
            }
            case 70: {
                colorV = (StringVariable)this.connectCategory((short)45, true);
                ht = this.shapeColorEncoder.colorList;
                cl = this.shapeColorEncoder.colorArray;
                values = this.getUniqueValues((short)45);
                defaultAttr = this.markerOutlineStyle;
            }
        }
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)colorV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            String gval = values[i];
            if (groupAttrMapper != null) {
                Color c = null;
                switch (role) {
                    case 6: {
                        c = groupAttrMapper.getFillColor(gval);
                        break;
                    }
                    case 46: 
                    case 70: {
                        c = groupAttrMapper.getLineColor(gval);
                        break;
                    }
                    case 45: {
                        c = groupAttrMapper.getMarkerColor(gval);
                        break;
                    }
                    case 69: {
                        c = groupAttrMapper.getFillColor(gval);
                    }
                }
                if (c != null) {
                    colors[i] = this.applyDataTransparency(c, defaultAttr.getTransparency());
                }
            }
            if (colors[i] != null) continue;
            if (indexV == null) {
                colors[i] = (Color)ht.get(gval);
                if (role != 70) continue;
                colors[i] = this.applyNewTransparency(colors[i], defaultAttr.getTransparency());
                continue;
            }
            int obs = this.groupOrder == 3 ? colorV.getFirstOccurringValueIndex(values.length - 1 - i) : colorV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                colors[i] = this.applyDataTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
                continue;
            }
            catch (MissingValueException e) {
                colors[i] = this.applyDataTransparency((ColorAttr)defaultAttr);
            }
        }
        return colors;
    }

    private int[] getGroupPatterns() {
        NumericVectorVariable indexV;
        if (StatGraph.isOLAP()) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            String[] values = this.getUniqueValues((short)36);
            int[] pattern = new int[this.getGroupValues().length];
            ArrayList<String> gValues = new ArrayList<String>();
            int cnt = 0;
            for (int i = 0; i < values.length; ++i) {
                String str = Overlay.getTopLevelValue(values[i]);
                if (gValues.contains(str)) continue;
                pattern[cnt++] = ((LineAttrs)ht.get(values[i])).getLinePattern();
                gValues.add(str);
            }
            return pattern;
        }
        StringVariable lineV = (StringVariable)this.connectCategory((short)36, true);
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)lineV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        LineAttrs[] ll = this.lineEncoder.styleArray;
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getUniqueValues((short)36);
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = -1;
            String gval = values[i];
            if (this.hasAttrVar("GROUP")) {
                DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                pattern[i] = groupAttrMapper.getLinePattern(gval);
            }
            if (pattern[i] != -1) continue;
            if (indexV == null) {
                pattern[i] = ((LineAttrs)ht.get(gval)).getLinePattern();
                continue;
            }
            int obs = this.groupOrder == 3 ? lineV.getFirstOccurringValueIndex(values.length - 1 - i) : lineV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                pattern[i] = ll[idx % ll.length].getLinePattern();
                continue;
            }
            catch (MissingValueException e) {
                pattern[i] = this.lineStyle.getLinePattern();
            }
        }
        return pattern;
    }

    private Color[] getResponseColors(int role) {
        HashMap ht = null;
        String[] values = null;
        switch (role) {
            case 6: {
                ht = this.colorEncoder.colorList;
                values = this.getUniqueValues((short)6);
                break;
            }
            case 46: {
                ht = this.lineColorEncoder.colorList;
                values = this.getUniqueValues((short)46);
                break;
            }
            case 45: 
            case 70: {
                ht = this.shapeColorEncoder.colorList;
                values = this.getUniqueValues((short)45);
                break;
            }
            case 69: {
                ht = this.shapeFillColorEncoder.colorList;
                values = this.getUniqueValues((short)69);
            }
        }
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            colors[i] = (Color)ht.get(values[i]);
            if (role != 70) continue;
            colors[i] = this.applyNewTransparency(colors[i], this.markerOutlineStyle.getTransparency());
        }
        return colors;
    }

    private int[] getResponsePatterns() {
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getUniqueValues((short)36);
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = ((LineAttrs)ht.get(values[i])).getLinePattern();
        }
        return pattern;
    }

    private int[] getResponseShapes() {
        int[] shapes = new int[]{};
        HashMap ht = this.shapeEncoder.shapeList;
        String[] values = this.getUniqueValues((short)8);
        shapes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            shapes[i] = (Integer)ht.get(values[i]);
        }
        return shapes;
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return this.markerOn;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
        }
        return false;
    }

    private Color[] getCombinedMarkerColor(String[] values, int[] shape, Color[] color, Color[] fColor) {
        int n = values.length;
        Color[] combinedColor = new Color[n];
        for (int i = 0; i < n; ++i) {
            int s = shape[i % shape.length];
            combinedColor[i] = Markers.isFilled((int)s) ? fColor[i % fColor.length] : (this.useMarkerAttrsColor ? this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()) : color[i % color.length]);
        }
        return combinedColor;
    }

    private int[] getModifiedMarkerShapes(int[] shapes) {
        if (shapes == null || shapes.length < 1) {
            return shapes;
        }
        int[] s = new int[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            s[i] = shapes[i] == 0 ? 187 : (shapes[i] == 16 ? 188 : shapes[i]);
        }
        return s;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        boolean lineOnly;
        String[] values;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        switch (attrType) {
            default: {
                values = this.getGroupValues();
                break;
            }
            case 4: {
                if (this.lineColorVar != null) {
                    values = this.getUniqueValues((short)46);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 5: {
                if (this.lineVar != null) {
                    values = this.getUniqueValues((short)36);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 1: {
                if (this.shapeVar != null) {
                    values = this.getUniqueValues((short)8);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 3: {
                values = this.shapeColorVar != null ? this.getUniqueValues((short)45) : this.getGroupValues();
            }
        }
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        int[] shape = this.getMarkerShapes();
        if (this.filledOutlinedMarker) {
            shape = this.getModifiedMarkerShapes(shape);
        }
        boolean bl = lineOnly = attrType == 10 || attrType == 4 || attrType == 5;
        if (shape.length == 0 || lineOnly || this.fillOn) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            Color[] fcolor = this.getFillColors();
            int n = values.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = null;
                if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                    attr = new LineAttrs();
                    attr.setColor(lcolor[i % lcolor.length]);
                    attr.setLinePattern(pattern[i % pattern.length]);
                    attr.setWidth(width[i % width.length]);
                }
                if (fcolor.length > 0) {
                    FillAttrs fillattr = new FillAttrs();
                    fillattr.setColor(fcolor[i % fcolor.length]);
                    entries[i] = new LegendItem((ColorAttr)fillattr, (ColorAttr)attr, values[i], null);
                    continue;
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType, false);
            }
            return entries;
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        int[] size = this.getMarkerWidths();
        int[] weight = this.getMarkerWeights();
        Color[] color = this.getMarkerColors();
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        Color[] olcolor = null;
        if (this.filledOutlinedMarker) {
            olcolor = this.getMarkerOutlineColors();
            Color[] fcolor = this.getMarkerFillColors();
            color = this.getCombinedMarkerColor(values, shape, color, fcolor);
        }
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                LineAttrs attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
                entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, null, this.skinType, false);
                entries[i].setPixelBenderImages(legendPixelBender);
            } else {
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType, legendPixelBender);
            }
            if (!this.filledOutlinedMarker) continue;
            LineAttrs outlineAttrs = null;
            int s = shape[i % shape.length];
            if (!Markers.isFilled((int)s)) continue;
            outlineAttrs = new LineAttrs();
            outlineAttrs.setColor(olcolor[i % olcolor.length]);
            if (this.useMarkerOutlineAttrsThickness) {
                outlineAttrs.setWidth(this.markerOutlineStyle.getWidth());
            } else {
                outlineAttrs.setWidth(-1);
            }
            entries[i].setMarkerOutlineAttrs(outlineAttrs);
        }
        return entries;
    }

    protected void connectOLAPVars() {
        CRD crd = this.model;
        if (crd.isAvailable(113)) {
            this.timeVar = StatGraph.getOLAPMeasureVar(crd, (short)113);
            if (!this.isVertical()) {
                crd.getSrcModel().yCategoryVar = this.timeVar.getColumnName();
            } else {
                crd.getSrcModel().xCategoryVar = this.timeVar.getColumnName();
            }
        }
        this.groupVar = crd.isAvailable(3) ? StatGraph.getOLAPLevelVar(crd, (short)3) : null;
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i = 0; i < this.responseCount; ++i) {
                if (!crd.isAvailable(610 + i)) continue;
                this.multiResponseVars[i] = StatGraph.getOLAPMeasureVar(crd, (short)(610 + i));
                this.multiResponseLabels[i] = this.multiResponseVars[i].getLabel();
            }
            if (this.groupOrder != 0) {
                this.sortMultiResponseLabels();
            }
        } else if (crd.isAvailable(2)) {
            this.responseVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
        }
        this.colorVar = crd.isAvailable(6) ? StatGraph.getOLAPLevelVar(crd, (short)6) : null;
        this.lineColorVar = crd.isAvailable(46) ? StatGraph.getOLAPLevelVar(crd, (short)46) : null;
        this.lineVar = crd.isAvailable(36) ? StatGraph.getOLAPLevelVar(crd, (short)36) : null;
        this.shapeColorVar = crd.isAvailable(45) ? StatGraph.getOLAPLevelVar(crd, (short)45) : null;
        this.shapeVar = crd.isAvailable(8) ? StatGraph.getOLAPLevelVar(crd, (short)8) : null;
        this.labelVisibleVar = new VisibilityVariable();
        VariableProcessor vp = new VariableProcessor();
        this.timeVar.setUniqueValueSort(0);
        vp.addVariable(this.timeVar);
        if (this.groupVar != null) {
            vp.addVariable(this.groupVar);
            if (this.getGroupOrder() == 1) {
                this.groupVar.setUniqueValueSort(1);
            } else if (this.getGroupOrder() == 2) {
                this.groupVar.setUniqueValueSort(2);
            }
            this.groupVar.setSortByFormattedValues(!this.numericGroup);
        }
        if (this.isMultiResponse()) {
            for (int i = 0; i < this.multiResponseVars.length; ++i) {
                vp.addVariable((Variable)this.multiResponseVars[i]);
            }
        } else {
            vp.addVariable(this.responseVar);
        }
        this.addVarToVP(vp, this.colorVar);
        this.addVarToVP(vp, this.lineColorVar);
        this.addVarToVP(vp, this.lineVar);
        this.addVarToVP(vp, this.shapeColorVar);
        this.addVarToVP(vp, this.shapeVar);
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.isMultiResponse() && !this.model.isAvailable(3);
    }

    @Override
    public String getDefaultLegendTitle() {
        String title = null;
        if (this.model.isAvailable(3)) {
            if (StatGraph.isOLAP()) {
                OLAPLevelVariable olv = (OLAPLevelVariable)this.groupVar;
                OLAPVariableFactory fac = olv.getFactory();
                List list = fac.getLevelNamesForHeirarchy(olv.getHierachyName());
                String levelName = (String)list.get(0);
                title = fac.getLabel(levelName).trim();
            } else {
                ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
                title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
            }
        }
        return title;
    }

    @Override
    public String[] getLabels(byte dim) {
        if (dim == 2 && this.isMultiResponse() && this.vertical) {
            return this.multiResponseLabels;
        }
        return super.getLabels(dim);
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        if (StatGraph.isOLAP()) {
            String label = null;
            if (this.responseVar != null) {
                label = this.responseVar.getLabel();
                if (label == null) {
                    label = this.responseVar.getColumnName();
                }
            } else {
                label = this.timeVar.getLabel();
                if (label == null) {
                    label = this.timeVar.getColumnName();
                }
            }
            return label;
        }
        ColumnMetadata cmd = null;
        cmd = this.model.isAvailable(2) ? (ColumnMetadata)this.model.getColumnLabel(2) : (ColumnMetadata)this.model.getColumnLabel(113);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.groupVar == null ? 1 : this.groupVar.getUniqueValueCount();
    }
}

