/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.TriangleConnector;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.text.Format;

public class SurfaceOverlay
extends Overlay {
    public static final String RB_KEY = "SurfaceOverlay.";
    protected boolean fillOn = true;
    protected boolean edgeOn = false;
    protected Color outlineColor = Color.black;
    protected FillAttrs fillStyle = new FillAttrs();
    protected int stripSize = 0;
    protected NumericVectorVariable xvalueVar;
    protected NumericVectorVariable yvalueVar;
    protected NumericVectorVariable zvalueVar;
    protected NumericVectorVariable colorVar;
    private NetworkRoot networkRoot;
    private TriangleConnector connector = new TriangleConnector();
    private NumericMapper xvalueMapper;
    private NumericMapper yvalueMapper;
    private NumericMapper zvalueMapper;
    protected ColorMapper colorMapper;
    protected RangeAttrMapper colorAttrMapper = null;
    private int rowSampleSize = 1;
    private int columnSampleSize = 1;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange zRange = null;
    protected DataRange colorRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected PositionEncoder zEncoder;
    protected ColorEncoder colorEncoder;

    public void setSampleSize(int rs, int cs) {
        this.connector.setRowSampleSize(rs);
        this.connector.setColumnSampleSize(cs);
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean edgeOn) {
        boolean oldEO = this.edgeOn;
        this.edgeOn = edgeOn;
        if (edgeOn != oldEO) {
            this.connector.edgeOn.setValue(edgeOn);
        }
        if (this.fillOn && edgeOn) {
            this.connector.setMaximumGridSampleSize(15);
            this.connector.setSamplePolicy(1);
        } else {
            this.connector.setMaximumGridSampleSize(Integer.MAX_VALUE);
        }
    }

    public boolean getFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean fillOn) {
        boolean oldFO = this.fillOn;
        this.fillOn = fillOn;
        if (fillOn != oldFO) {
            this.connector.fillOn.setValue(fillOn);
        }
        if (fillOn && this.edgeOn) {
            this.connector.setMaximumGridSampleSize(15);
            this.connector.setSamplePolicy(1);
        } else {
            this.connector.setMaximumGridSampleSize(Integer.MAX_VALUE);
        }
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillAttrs style) {
        this.fillStyle = style;
        if (this.fillOn && this.colorMapper == null) {
            this.connector.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        }
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color aColor) {
        this.outlineColor = aColor;
        if (this.edgeOn) {
            this.connector.edgeColor.setValue(this.applyDataTransparency(this.outlineColor));
        }
    }

    public void enableFastRender() {
        this.connector.color.disconnect();
        this.connector.fillOn.setValue(false);
        this.connector.edgeOn.setValue(true);
        this.connector.color.setValue(this.fillStyle.getColor());
        this.connector.edgeColor.setValue(this.fillStyle.getColor());
        this.setSampleSize(3, 3);
    }

    public void disableFastRender() {
        this.connector.fillOn.setValue(this.fillOn);
        if (this.fillOn && this.colorMapper == null) {
            this.connector.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        } else if (this.fillOn) {
            if (this.colorAttrMapper != null) {
                this.connector.color.connectFrom(this.colorAttrMapper.color);
            } else {
                this.connector.color.connectFrom((ColorPipe)this.colorMapper);
            }
        } else if (this.colorMapper != null) {
            if (this.colorAttrMapper != null) {
                this.connector.color.connectFrom(this.colorAttrMapper.color);
            } else {
                this.connector.color.connectFrom((ColorPipe)this.colorMapper);
            }
        } else {
            this.connector.color.setValue(this.applyDataTransparency(this.outlineColor));
        }
        this.connector.edgeOn.setValue(this.edgeOn);
        this.connector.edgeColor.setValue(this.applyDataTransparency(this.outlineColor));
        this.setSampleSize(1, 1);
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num = this.xvalueVar.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages);
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num = this.yvalueVar.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages);
                newRange.setLabel(this.yvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 11);
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    protected void updateZRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.zRange;
        if (this.zvalueVar != null) {
            int num = this.zvalueVar.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange((NumericVariable)this.zvalueVar, (short)12, true);
                newRange.setLabel(this.zvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 12);
        this.zRange = newRange;
        this.fireRangeEvent((byte)3, oldRange, (DataRange)newRange);
    }

    protected void updateColorRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.colorRange;
        if (this.colorVar != null) {
            int num = this.colorVar.getValueCount();
            if (num > 0) {
                newRange = this.makeContinuousRange((NumericVariable)this.colorVar, (short)6, false);
                newRange.setLabel(this.colorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 6);
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        if (dimension == 3) {
            return this.zRange;
        }
        if (dimension == 4) {
            return this.colorRange;
        }
        return null;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 3: {
                return this.zEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        channel.glDisable(1);
        this.networkRoot.draw(channel, false);
        channel.glEnable(1);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        switch (dimension) {
            case 1: {
                if (!(encoder instanceof PositionEncoder)) {
                    return;
                }
                this.xEncoder = (PositionEncoder)encoder;
                break;
            }
            case 2: {
                if (!(encoder instanceof PositionEncoder)) {
                    return;
                }
                this.yEncoder = (PositionEncoder)encoder;
                break;
            }
            case 3: {
                if (!(encoder instanceof PositionEncoder)) {
                    return;
                }
                this.zEncoder = (PositionEncoder)encoder;
                break;
            }
            case 4: {
                if (!(encoder instanceof ColorEncoder)) {
                    return;
                }
                this.colorEncoder = (ColorEncoder)encoder;
            }
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        if (!this.computeStripSize()) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "data.txt"));
            this.xvalueVar = null;
            this.yvalueVar = null;
            this.zvalueVar = null;
            return;
        }
        this.updateXRange();
        this.updateYRange();
        this.updateZRange();
        this.updateColorRange();
    }

    protected boolean computeStripSize() {
        double val2;
        int majorAxis;
        int minorAxis;
        double initialDelta;
        if (this.isPresortData()) {
            return this.computeStripSize_cas();
        }
        if (this.xvalueVar == null || this.yvalueVar == null) {
            return false;
        }
        int numRows = 0;
        numRows = this.model.getRowCount();
        double x1 = this.model.getDoubleColumn(10)[0];
        double x2 = this.model.getDoubleColumn(10)[1];
        double z1 = this.model.getDoubleColumn(12)[0];
        double z2 = this.model.getDoubleColumn(12)[1];
        double xDelta = x2 - x1;
        double zDelta = z2 - z1;
        if (Math.abs(xDelta) > Math.abs(zDelta)) {
            initialDelta = xDelta;
            minorAxis = 10;
            majorAxis = 12;
        } else {
            initialDelta = zDelta;
            minorAxis = 12;
            majorAxis = 10;
        }
        if (initialDelta == 0.0) {
            return false;
        }
        int derivedStride = 2;
        double[] minorColumn = this.model.getDoubleColumn(minorAxis);
        while (true) {
            if (derivedStride > numRows / 2) {
                return false;
            }
            double curr = minorColumn[derivedStride];
            double prev = minorColumn[derivedStride - 1];
            double thisDelta = curr - prev;
            if (initialDelta > 0.0 && thisDelta < 0.0 || initialDelta < 0.0 && thisDelta > 0.0) break;
            ++derivedStride;
        }
        double val1 = this.model.getDoubleColumn(majorAxis)[derivedStride];
        if (val1 == (val2 = this.model.getDoubleColumn(majorAxis)[0]) || numRows % derivedStride != 0) {
            return false;
        }
        this.stripSize = derivedStride;
        return true;
    }

    protected boolean computeStripSize_cas() {
        double val2;
        NumericVectorVariable majorVar;
        NumericVectorVariable minorVar;
        double initialDelta;
        if (this.xvalueVar == null || this.yvalueVar == null) {
            return false;
        }
        this.xvalueVar.getUniqueValueCount();
        this.zvalueVar.getUniqueValueCount();
        int numRows = 0;
        numRows = this.xvalueVar.getValueCount();
        double x1 = (Double)Variable.getValue((Variable)this.xvalueVar, (int)0, (boolean)false);
        double x2 = (Double)Variable.getValue((Variable)this.xvalueVar, (int)1, (boolean)false);
        double z1 = (Double)Variable.getValue((Variable)this.zvalueVar, (int)0, (boolean)false);
        double z2 = (Double)Variable.getValue((Variable)this.zvalueVar, (int)1, (boolean)false);
        double xDelta = x2 - x1;
        double zDelta = z2 - z1;
        if (Math.abs(xDelta) > Math.abs(zDelta)) {
            initialDelta = xDelta;
            minorVar = this.xvalueVar;
            majorVar = this.zvalueVar;
        } else {
            initialDelta = zDelta;
            minorVar = this.zvalueVar;
            majorVar = this.xvalueVar;
        }
        if (initialDelta == 0.0) {
            return false;
        }
        int derivedStride = 2;
        while (true) {
            if (derivedStride > numRows / 2) {
                return false;
            }
            double curr = (Double)Variable.getValue((Variable)minorVar, (int)derivedStride, (boolean)false);
            double prev = (Double)Variable.getValue((Variable)minorVar, (int)(derivedStride - 1), (boolean)false);
            double thisDelta = curr - prev;
            if (initialDelta > 0.0 && thisDelta < 0.0 || initialDelta < 0.0 && thisDelta > 0.0) break;
            ++derivedStride;
        }
        double val1 = (Double)Variable.getValue((Variable)majorVar, (int)derivedStride, (boolean)false);
        if (val1 == (val2 = ((Double)Variable.getValue((Variable)majorVar, (int)0, (boolean)false)).doubleValue()) || numRows % derivedStride != 0) {
            return false;
        }
        this.stripSize = derivedStride;
        return true;
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xvalueVar == null || this.yvalueVar == null || this.zvalueVar == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.xvalueMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        if (this.yEncoder == null) {
            return false;
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.yvalueMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        if (this.zEncoder == null) {
            return false;
        }
        map = this.zEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.zvalueMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.zvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        if (this.colorEncoder != null) {
            map = this.colorEncoder.getValueMap();
            if (!(map instanceof ContinuousRangeToColorMap)) {
                return false;
            }
            this.colorMapper = new ContinuousRangeToColorMapper();
            ((ContinuousRangeToColorMapper)this.colorMapper).setMap((ContinuousRangeToColorMap)map);
        }
        SASFormat xformat = this.xEncoder.getInput().getFormat();
        SASFormat yformat = this.yEncoder.getInput().getFormat();
        SASFormat zformat = this.zEncoder.getInput().getFormat();
        ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(this.xvalueVar.value);
        if (xformat != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)xformat));
        }
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(this.yvalueVar.value);
        if (yformat != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)yformat));
        }
        ((ContinuousRangeToNumericMapper)this.zvalueMapper).input.connectFrom(this.zvalueVar.value);
        if (zformat != null) {
            this.zvalueVar.setFormat(new GTKFormat((Format)zformat));
        }
        if (this.colorMapper != null) {
            ((ContinuousRangeToColorMapper)this.colorMapper).input.connectFrom(this.colorVar.value);
        }
        this.colorAttrMapper = null;
        if (this.hasAttrVar("SURFACECOLORGRADIENT")) {
            this.colorAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("SURFACECOLORGRADIENT");
            String error = this.colorAttrMapper.createColorMapper(this.colorVar.getMin(), this.colorVar.getMax());
            if (error != null) {
                this.colorAttrMapper = null;
                StatGraph.printWarning(error);
            } else {
                this.colorAttrMapper.setTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
                this.colorAttrMapper.variable = this.colorVar.value;
            }
        }
        this.networkRoot.removeAllElements();
        this.networkRoot.addElement((Element)this.connector);
        this.connector.setWidth(this.stripSize);
        this.connector.fillOn.setValue(this.fillOn);
        if (this.fillOn && this.colorMapper == null) {
            this.connector.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        } else if (this.fillOn) {
            if (this.colorAttrMapper != null) {
                this.connector.color.connectFrom(this.colorAttrMapper.color);
            } else {
                this.connector.color.connectFrom((ColorPipe)this.colorMapper);
            }
        } else if (this.colorMapper != null) {
            if (this.colorAttrMapper != null) {
                this.connector.color.connectFrom(this.colorAttrMapper.color);
            } else {
                this.connector.color.connectFrom((ColorPipe)this.colorMapper);
            }
        } else {
            this.connector.color.setValue(this.applyDataTransparency(this.outlineColor));
        }
        this.connector.edgeOn.setValue(this.edgeOn);
        this.connector.edgeColor.setValue(this.applyDataTransparency(this.outlineColor));
        this.connector.selectDetailEnabled.setValue(true);
        this.connector.setUserData((Object)this.probe);
        this.connector.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        this.connector.pointY.connectFrom((NumericPipe)this.yvalueMapper);
        this.connector.pointZ.connectFrom((NumericPipe)this.zvalueMapper);
        this.needConnect = false;
        return true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        return 5.0;
    }

    protected void connectVars() {
        VariableProcessor vp;
        if (this.isPresortData()) {
            short[] sortRoles = new short[]{10, 12};
            int[] sortTypes = new int[]{1, 1};
            this.model.sortByRoles(sortRoles, sortTypes);
        }
        this.xvalueVar = null;
        if (this.model != null && this.model.isAvailable(10)) {
            if (this.model.getColumnClass(10) != Double.class) {
                StatGraph.printDebug("VSurface : XVALUE must be numeric");
            } else {
                this.xvalueVar = (NumericVectorVariable)this.connectRaw((short)10);
            }
        }
        this.yvalueVar = null;
        if (this.model != null && this.model.isAvailable(11)) {
            if (this.model.getColumnClass(11) != Double.class) {
                StatGraph.printDebug("VSurface : YVALUE must be numeric");
            } else {
                this.yvalueVar = (NumericVectorVariable)this.connectRaw((short)11);
            }
        }
        this.zvalueVar = null;
        if (this.model != null && this.model.isAvailable(12)) {
            if (this.model.getColumnClass(12) != Double.class) {
                StatGraph.printDebug("VBar : ZVALUE must be numeric");
            } else {
                this.zvalueVar = (NumericVectorVariable)this.connectRaw((short)12);
            }
        }
        this.colorVar = null;
        if (this.model != null && this.model.isAvailable(6)) {
            if (this.model.getColumnClass(6) != Double.class) {
                StatGraph.printDebug("VBar : COLOR must be numeric");
            } else {
                this.colorVar = (NumericVectorVariable)this.connectRaw((short)6);
            }
        }
        if (this.isPresortData()) {
            vp = new VariableProcessor();
            if (this.xvalueVar != null) {
                vp.addVariable((Variable)this.xvalueVar);
                vp.addGroupVariable((Variable)this.xvalueVar);
            }
            if (this.zvalueVar != null) {
                vp.addVariable((Variable)this.zvalueVar);
                vp.addGroupVariable((Variable)this.zvalueVar);
            }
            if (this.yvalueVar != null) {
                vp.addVariable((Variable)this.yvalueVar, 11);
            }
            if (this.colorVar != null) {
                vp.addVariable((Variable)this.colorVar, 11);
            }
            if (this.model.whereExpression != null) {
                this.addCRDWhereClause(vp);
            }
        } else if (this.model.whereExpression != null) {
            vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)this.xvalueVar);
            this.addVarToVP(vp, (Variable)this.yvalueVar);
            this.addVarToVP(vp, (Variable)this.zvalueVar);
            this.addVarToVP(vp, (Variable)this.colorVar);
            this.addCRDWhereClause(vp);
        }
        this.probe = new Probe();
        if (this.xvalueVar != null) {
            this.probe.addPipe(this.xvalueVar.getLabel(), (Pipe)this.xvalueVar.formattedValue);
        }
        if (this.yvalueVar != null && this.xvalueVar.getLabel() != this.yvalueVar.getLabel()) {
            this.probe.addPipe(this.yvalueVar.getLabel(), (Pipe)this.yvalueVar.formattedValue);
        }
        if (this.zvalueVar != null && this.zvalueVar.getLabel() != this.xvalueVar.getLabel() && this.zvalueVar.getLabel() != this.yvalueVar.getLabel()) {
            this.probe.addPipe(this.zvalueVar.getLabel(), (Pipe)this.zvalueVar.formattedValue);
        }
        if (this.colorVar != null && this.colorVar.getLabel() != this.xvalueVar.getLabel() && this.colorVar.getLabel() != this.yvalueVar.getLabel() && this.colorVar.getLabel() != this.zvalueVar.getLabel()) {
            this.probe.addPipe(this.colorVar.getLabel(), (Pipe)this.colorVar.formattedValue);
        }
    }

    @Override
    public int[] getLinePatterns() {
        return new int[]{1};
    }

    @Override
    public int[] getLineWidths() {
        return new int[]{1};
    }

    @Override
    public Color[] getLineColors() {
        Color[] colorArray;
        if (this.isEdgeOn()) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = this.outlineColor;
        } else {
            colorArray = new Color[]{};
        }
        return colorArray;
    }

    @Override
    public Color[] getFillColors() {
        Color[] colorArray;
        if (this.getFillOn()) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = this.applyDataTransparency((ColorAttr)this.fillStyle);
        } else {
            colorArray = new Color[]{};
        }
        return colorArray;
    }

    public boolean isGradientTopColor() {
        return this.model != null && this.model.isAvailable(6);
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(11);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        if (type == 1) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            ContinuousRange range = (ContinuousRange)ce.getInput();
            this.colorAttrMapper = null;
            if (this.hasAttrVar("SURFACECOLORGRADIENT")) {
                this.colorAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("SURFACECOLORGRADIENT");
                String error = this.colorAttrMapper.createColorMapper(range.getMin(), range.getMax());
                if (error != null) {
                    this.colorAttrMapper = null;
                    StatGraph.printWarning(error);
                } else {
                    this.colorAttrMapper.setTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
                    this.colorAttrMapper.variable = this.colorVar.value;
                }
            }
            if (this.colorAttrMapper != null) {
                return this.colorAttrMapper.getRangeColorMapper().getFullRanges(this.getAttrTransparency((ColorAttr)this.fillStyle));
            }
            Color[] colors = ce.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        return null;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }
}

