/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.APolygonElement;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PolygonElement;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.text.Format;
import java.util.HashMap;
import java.util.Iterator;

public class PolygonOverlay
extends Overlay {
    public static final String RB_KEY = "PolygonOverlay.";
    protected boolean outlineOn = true;
    protected LineAttrs outlineStyle = new LineAttrs();
    protected boolean fillOn = true;
    protected FillAttrs fillStyle = new FillAttrs();
    protected boolean labelOn = true;
    protected TextAttrs labelStyle = new TextAttrs();
    protected boolean fillPatternOn = false;
    protected FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    protected int labelLocation = 0;
    protected int labelPosition = 1;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange colorRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder fillColorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected ColorEncoder labelColorEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericID = true;
    private Variable idVar;
    private Variable rawIDVar;
    private Variable xvalueVar;
    private Variable yvalueVar;
    private Variable groupVar;
    private Variable rawGroupVar;
    private Variable colorResponseVar;
    private Variable labelVar;
    private Variable xoVar;
    private Variable yoVar;
    private Variable rotateVar;
    protected NetworkRoot networkRoot;
    protected NumericMapper xvalueMapper;
    protected NumericMapper yvalueMapper;
    private NetworkRoot networkRoot2;
    private Color missingGradientColor = Color.black;
    protected double xDiscreteOffset = 0.0;
    protected double yDiscreteOffset = 0.0;
    private boolean useLabelColor = false;
    private boolean rotatedPolygon = false;
    private double rotate = 0.0;
    private int labelRotate = 0;
    private double labelBacklight = 0.0;
    private int gap = 4;
    private double alignmentOffsetX = this.gap;
    private double alignmentOffsetX2 = this.gap;
    private double alignmentOffsetY = this.gap;
    private double alignmentOffsetY2 = this.gap;

    public void setLabelBacklight(double light) {
        this.labelBacklight = light;
    }

    public double getLabelBacklight() {
        return this.labelBacklight;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    public void setOutlineOn(boolean b) {
        this.outlineOn = b;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public LineAttrs getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(LineAttrs aLineStyle) {
        this.outlineStyle = aLineStyle;
    }

    public void setFillPatternStyle(FillPatternAttrs fps) {
        this.fillPatternStyle = fps;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    public TextAttrs getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextAttrs labelStyle) {
        this.labelStyle = labelStyle;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public int getLabelLocation() {
        return this.labelLocation;
    }

    public void setLabelLocation(int labelLocation) {
        this.labelLocation = labelLocation;
    }

    public double getXDiscreteOffset() {
        return this.xDiscreteOffset;
    }

    public void setXDiscreteOffset(double discreteOffset) {
        this.xDiscreteOffset = discreteOffset;
    }

    public double getYDiscreteOffset() {
        return this.yDiscreteOffset;
    }

    public void setYDiscreteOffset(double discreteOffset) {
        this.yDiscreteOffset = discreteOffset;
    }

    @Override
    public String[] getGroupValues() {
        if (this.model.isAvailable(3)) {
            return this.getUniqueGroupValues((short)3);
        }
        return null;
    }

    @Override
    public Color[] getFillColors() {
        Color[] fc;
        if (!this.isFillOn() || this.colorResponseVar != null) {
            return new Color[0];
        }
        if (this.groupVar == null || this.fillColorEncoder == null) {
            fc = new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
        } else {
            HashMap ht = this.fillColorEncoder.colorList;
            String[] values = this.getGroupValues();
            fc = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    Color c = groupAttrMapper.getFillColor(values[i]);
                    if (c != null) {
                        if (this.useFillTransparency) {
                            fc[i] = this.applyDataTransparency(c, this.getAttrTransparency((ColorAttr)this.fillStyle));
                            continue;
                        }
                        fc[i] = PolygonOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(values[i]));
                        continue;
                    }
                    fc[i] = (Color)ht.get(values[i]);
                    continue;
                }
                fc[i] = (Color)ht.get(values[i]);
            }
        }
        return fc;
    }

    @Override
    public Color[] getLineColors() {
        Color[] lc;
        if (!this.isOutlineOn() || this.colorResponseVar != null) {
            return new Color[0];
        }
        if (this.groupVar == null || this.lineColorEncoder == null) {
            lc = new Color[]{this.applyDataTransparency(this.outlineStyle.getColor())};
        } else {
            HashMap ht = this.lineColorEncoder.colorList;
            String[] values = this.getLineColorValues();
            lc = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    Color c = groupAttrMapper.getLineColor(values[i]);
                    if (c != null) {
                        lc[i] = this.applyDataTransparency(c);
                        continue;
                    }
                    lc[i] = (Color)ht.get(values[i]);
                    continue;
                }
                lc[i] = (Color)ht.get(values[i]);
            }
        }
        return lc;
    }

    @Override
    public int[] getLineWidths() {
        if (!this.fillOn) {
            if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
                return new int[]{this.outlineStyle.getWidth()};
            }
            return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.outlineStyle.getWidth());
        }
        return new int[]{(int)Math.round(StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor)};
    }

    @Override
    public int[] getLinePatterns() {
        int[] lp;
        if (this.lineEncoder == null) {
            lp = new int[]{this.outlineStyle.getLinePattern()};
        } else {
            HashMap ht = this.lineEncoder.styleList;
            String[] values = this.getLinePatternValues();
            lp = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                LineAttrs ls = (LineAttrs)ht.get(values[i]);
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    int p = groupAttrMapper.getLinePattern(values[i]);
                    if (p >= 0) {
                        lp[i] = p;
                        continue;
                    }
                    lp[i] = ls.getLinePattern();
                    continue;
                }
                lp[i] = ls.getLinePattern();
            }
        }
        return lp;
    }

    @Override
    public Color[] getFillPatternColors() {
        Color[] fpc;
        if (!this.isFillPatternOn() || this.colorResponseVar != null) {
            return new Color[0];
        }
        if (this.groupVar == null || this.fillPatternColorEncoder == null) {
            fpc = new Color[]{this.applyDataTransparency(this.fillPatternStyle.getColor())};
        } else {
            HashMap ht = this.fillPatternColorEncoder.colorList;
            String[] values = this.getGroupValues();
            fpc = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    Color c = groupAttrMapper.getLineColor(values[i]);
                    if (c != null) {
                        fpc[i] = this.applyDataTransparency(c);
                        continue;
                    }
                    fpc[i] = (Color)ht.get(values[i]);
                    continue;
                }
                fpc[i] = (Color)ht.get(values[i]);
            }
        }
        return fpc;
    }

    @Override
    public int[] getFillPatterns() {
        if (!this.isFillPatternOn()) {
            return new int[0];
        }
        if (this.groupVar == null || this.fillPatternEncoder == null) {
            return new int[]{this.fillPatternStyle.getPattern()};
        }
        HashMap ht = this.fillPatternEncoder.patternList;
        String[] values = this.getGroupValues();
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = (Integer)ht.get(values[i]);
        }
        return pattern;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, !this.xUnionAllPages);
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num;
            int n = num = this.numericY ? this.yvalueVar.getValueCount() : this.yvalueVar.getUniqueValueCount();
            if (num == 1 && this.numericY && this.yvalueVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                if (this.numericY) {
                    ContinuousRange r = this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages);
                    double min = r.getMin();
                    double max = r.getMax();
                    newRange = new ContinuousRange(min, max);
                } else {
                    newRange = this.makeDiscreteRange((StringVariable)this.yvalueVar, num, (short)11, !this.yUnionAllPages);
                }
                newRange.setLabel(this.yvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updateColorRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.colorRange;
        if (this.colorResponseVar != null) {
            newRange = this.makeContinuousRange((NumericVariable)this.colorResponseVar, (short)108, false);
            newRange.setLabel(this.colorResponseVar.getLabel());
            this.setFormat((DataRange)newRange, 108);
        } else if (this.groupVar != null) {
            int num = this.groupVar.getUniqueValueCount();
            newRange = Overlay.makeDiscreteRange((StringVariable)this.groupVar, num);
            newRange.setLabel(this.groupVar.getLabel());
            this.setFormat((DataRange)newRange, 3);
        } else {
            newRange = null;
        }
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        Object cr = null;
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                return this.colorRange;
            }
            case 17: {
                return this.colorRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void drawNoneClipped(Graphics g) {
        if (this.networkRoot2 == null) {
            return;
        }
        Channel channel = this.networkRoot2.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot2.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillColorEncoder)) {
                return;
            }
            this.fillColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.fillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        } else if (dimension == 25) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.labelColorEncoder)) {
                return;
            }
            this.labelColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateColorRange();
    }

    private int reverseLabelPosition(int position) {
        if (position == 2 && this.xEncoder.isReversed()) {
            return 3;
        }
        if (position == 3 && this.xEncoder.isReversed()) {
            return 2;
        }
        if (position == 4 && this.yEncoder.isReversed()) {
            return 5;
        }
        if (position == 5 && this.yEncoder.isReversed()) {
            return 4;
        }
        return position;
    }

    @Override
    public boolean connectNetwork() {
        double stride;
        DiscreteAttrMapper groupAttrMapper;
        SASFormat format;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xvalueVar == null || this.xRange == null) {
            return false;
        }
        if (this.yvalueVar == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
        }
        if (this.yEncoder == null) {
            return false;
        }
        map = this.yEncoder.getValueMap();
        if (this.numericY) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.yvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof StringToNumericMapper)) {
                this.yvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.yvalueMapper).setMap((StringToNumericMap)map);
        }
        ContinuousRangeToColorMapper fillColorMapper = null;
        if (this.fillColorEncoder != null) {
            map = this.fillColorEncoder.getValueMap();
            if (this.colorResponseVar != null) {
                fillColorMapper = new ContinuousRangeToColorMapper();
                fillColorMapper.setMap((ContinuousRangeToColorMap)map);
                fillColorMapper.setReplaceMissingValues(true);
                fillColorMapper.setMissingReplacement(this.missingGradientColor);
            } else {
                fillColorMapper = new StringToColorMapper();
                ((StringToColorMapper)fillColorMapper).setMap((StringToColorMap)map);
            }
        }
        ContinuousRangeToColorMapper lineColorMapper = null;
        if (this.lineColorEncoder != null) {
            map = this.lineColorEncoder.getValueMap();
            if (this.colorResponseVar != null) {
                lineColorMapper = new ContinuousRangeToColorMapper();
                lineColorMapper.setMap((ContinuousRangeToColorMap)map);
                lineColorMapper.setReplaceMissingValues(true);
                lineColorMapper.setMissingReplacement(this.missingGradientColor);
            } else {
                lineColorMapper = new StringToColorMapper();
                ((StringToColorMapper)lineColorMapper).setMap((StringToColorMap)map);
            }
        }
        StringToNumberMapper linePatternMapper = null;
        if (this.lineEncoder != null) {
            HashMap ht = this.lineEncoder.styleList;
            linePatternMapper = new StringToNumberMapper();
            linePatternMapper.input.connectFrom(((StringVariable)this.groupVar).value);
            for (int i = 0; i < this.groupVar.getUniqueValueCount(); ++i) {
                LineAttrs ls;
                try {
                    String gval = ((StringVariable)this.groupVar).uniqueValue.getValue(i);
                    ls = (LineAttrs)ht.get(gval);
                    linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                    continue;
                }
                catch (MissingValueException e) {
                    ls = this.outlineStyle;
                    linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                }
            }
        }
        StringToNumberMapper fillPatternMapper = null;
        StringToNumberMapper fillPatternWidthMapper = null;
        if (this.fillPatternEncoder != null) {
            HashMap ht = this.fillPatternEncoder.patternList;
            fillPatternMapper = new StringToNumberMapper();
            fillPatternWidthMapper = new StringToNumberMapper();
            fillPatternMapper.input.connectFrom(((StringVariable)this.groupVar).value);
            fillPatternWidthMapper.input.connectFrom(((StringVariable)this.groupVar).value);
            fillPatternMapper.setReplaceMissingValues(true);
            fillPatternMapper.setLabelMissingValues(true);
            fillPatternWidthMapper.setReplaceMissingValues(true);
            fillPatternWidthMapper.setLabelMissingValues(true);
            for (int i = 0; i < this.groupVar.getUniqueValueCount(); ++i) {
                int p;
                try {
                    String gval = ((StringVariable)this.groupVar).uniqueValue.getValue(i);
                    p = (Integer)ht.get(gval);
                    fillPatternWidthMapper.add(gval, (Number)new Double(FillPatternAttrs.getPatternWidth((int)p)));
                    fillPatternMapper.add(gval, (Number)new Double(BarOverlay.getGLFillPattern(p)));
                    continue;
                }
                catch (MissingValueException e) {
                    p = this.fillPatternStyle.getPattern();
                    fillPatternWidthMapper.setMissingReplacement((double)FillPatternAttrs.getPatternWidth((int)p), e.getMissingValue());
                    fillPatternMapper.setMissingReplacement((double)BarOverlay.getGLFillPattern(p), e.getMissingValue());
                }
            }
        }
        ContinuousRangeToColorMapper fillPatternColorMapper = null;
        if (this.fillPatternColorEncoder != null) {
            map = this.fillPatternColorEncoder.getValueMap();
            if (this.colorResponseVar != null) {
                fillPatternColorMapper = new ContinuousRangeToColorMapper();
                fillPatternColorMapper.setMap((ContinuousRangeToColorMap)map);
                fillPatternColorMapper.setReplaceMissingValues(true);
                fillPatternColorMapper.setMissingReplacement(this.missingGradientColor);
            } else {
                fillPatternColorMapper = new StringToColorMapper();
                ((StringToColorMapper)fillPatternColorMapper).setMap((StringToColorMap)map);
            }
        }
        StringToColorMapper labelColorMapper = null;
        if (this.labelColorEncoder != null) {
            map = this.labelColorEncoder.getValueMap();
            labelColorMapper = new StringToColorMapper();
            labelColorMapper.setMap((StringToColorMap)map);
        }
        if ((format = this.xEncoder.getInput().getFormat()) != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        if (this.numericY) {
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(((NumericVariable)this.yvalueVar).value);
        } else {
            ((StringToNumericMapper)this.yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
        }
        if (fillColorMapper != null) {
            if (this.colorResponseVar != null) {
                fillColorMapper.input.connectFrom(((NumericVariable)this.colorResponseVar).value);
            } else {
                ((StringToColorMapper)fillColorMapper).input.connectFrom(((StringVariable)this.groupVar).value);
            }
        }
        if (lineColorMapper != null) {
            if (this.colorResponseVar != null) {
                lineColorMapper.input.connectFrom(((NumericVariable)this.colorResponseVar).value);
            } else {
                ((StringToColorMapper)lineColorMapper).input.connectFrom(((StringVariable)this.groupVar).value);
            }
        }
        if (fillPatternColorMapper != null) {
            if (this.colorResponseVar != null) {
                fillPatternColorMapper.input.connectFrom(((NumericVariable)this.colorResponseVar).value);
            } else {
                ((StringToColorMapper)fillPatternColorMapper).input.connectFrom(((StringVariable)this.groupVar).value);
            }
        }
        if (labelColorMapper != null) {
            labelColorMapper.input.connectFrom(((StringVariable)this.groupVar).value);
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.variable = ((StringVectorVariable)this.groupVar).value;
            groupAttrMapper.fillColorMapper = fillColorMapper;
            groupAttrMapper.lineColorMapper = lineColorMapper != null ? lineColorMapper : fillPatternColorMapper;
            groupAttrMapper.linePatternMapper = linePatternMapper;
            groupAttrMapper.addLineThicknessPipe("outline", this.outlineStyle.getWidth());
        }
        RangeAttrMapper responseAttrMapper = null;
        if (this.hasAttrVar("COLORRESPONSE")) {
            double max;
            ContinuousRangeToColorMapper cm;
            double min;
            responseAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
            String error = responseAttrMapper.createColorMapper(min = (cm = fillColorMapper == null ? lineColorMapper : fillColorMapper).getInputMin(), max = cm.getInputMax(), !this.fillOn);
            if (error != null) {
                responseAttrMapper = null;
                StatGraph.printWarning(error);
            } else {
                double dt = this.dataTransparency;
                if (this.fillOn && this.fillStyle.getTransparency() >= 0.0) {
                    dt = this.fillStyle.getTransparency();
                }
                responseAttrMapper.setTransparency(dt);
                responseAttrMapper.variable = cm.input;
            }
        }
        this.networkRoot.removeAllElements();
        PolygonElement poly = new PolygonElement();
        poly.setSubpixelRendering(this.subpixelRendering);
        poly.setUserData(this.probe);
        poly.setSkinType(this.fillOn ? this.skinType : 0);
        poly.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        poly.labelOutlineOn.setValue(this.getLabelBacklight() != 0.0);
        poly.labelOutlineWidth.setValue(ScatterOverlay.getLabelOutlineWidth(this.labelStyle.getFont().getSize()));
        poly.labelBacklight.setValue(this.getLabelBacklight());
        poly.setRotatedPolygon(this.rotatedPolygon);
        if (this.rotatedPolygon) {
            if (this.rotateVar != null) {
                poly.rotate.connectFrom(((NumericVariable)this.rotateVar).value);
            } else {
                poly.rotate.setValue(this.rotate);
            }
        }
        poly.setLabelRotation(this.labelRotate);
        poly.fillOn.setValue(this.fillOn);
        poly.edgeOn.setValue(this.outlineOn);
        poly.fillPatternOn.setValue(this.fillPatternOn);
        poly.edgeWidth.setValue(this.outlineStyle.getWidth());
        if (groupAttrMapper != null && !this.useLineThickness) {
            poly.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("outline"));
        }
        if (responseAttrMapper != null) {
            if (this.fillOn) {
                poly.color.connectFrom(responseAttrMapper.color);
                poly.edgeColor.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
                if (this.fillPatternOn) {
                    poly.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
                }
            } else {
                poly.color.connectFrom(responseAttrMapper.color);
                poly.edgeColor.connectFrom(responseAttrMapper.color);
                if (this.fillPatternOn) {
                    poly.fillPatternColor.connectFrom(responseAttrMapper.color);
                }
            }
        } else if (this.colorResponseVar == null && groupAttrMapper != null) {
            if (this.fillOn) {
                if (fillColorMapper != null) {
                    poly.color.connectFrom(groupAttrMapper.fillColor);
                } else {
                    poly.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                }
                if (lineColorMapper != null) {
                    poly.edgeColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                } else {
                    poly.edgeColor.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
                }
            } else if (lineColorMapper != null) {
                poly.edgeColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                poly.color.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                poly.color.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
                poly.edgeColor.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
            }
            if (this.fillPatternOn) {
                if (fillPatternColorMapper != null) {
                    poly.fillPatternColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                } else {
                    poly.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
                }
            }
        } else {
            if (this.fillOn) {
                if (fillColorMapper != null) {
                    poly.color.connectFrom((ColorPipe)fillColorMapper);
                } else {
                    poly.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                }
                if (lineColorMapper != null) {
                    poly.edgeColor.connectFrom((ColorPipe)lineColorMapper);
                } else {
                    poly.edgeColor.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
                }
            } else if (lineColorMapper != null) {
                poly.edgeColor.connectFrom((ColorPipe)lineColorMapper);
                poly.color.connectFrom((ColorPipe)lineColorMapper);
            } else {
                poly.edgeColor.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
                poly.color.setValue(this.applyDataTransparency((ColorAttr)this.outlineStyle));
            }
            if (this.fillPatternOn) {
                if (fillPatternColorMapper != null) {
                    poly.fillPatternColor.connectFrom((ColorPipe)fillPatternColorMapper);
                } else {
                    poly.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
                }
            }
        }
        if (!this.fillOn) {
            if (groupAttrMapper != null) {
                if (linePatternMapper != null) {
                    poly.edgePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
                } else {
                    poly.edgePattern.setValue(this.outlineStyle.getLinePattern());
                }
            } else if (linePatternMapper != null) {
                poly.edgePattern.connectFrom((NumericPipe)linePatternMapper);
            } else {
                poly.edgePattern.setValue(this.outlineStyle.getLinePattern());
            }
        } else {
            poly.edgePattern.setValue(this.outlineStyle.getLinePattern());
        }
        if (this.fillPatternOn) {
            if (fillPatternMapper != null) {
                poly.fillPatternType.connectFrom((NumericPipe)fillPatternMapper);
                poly.fillPatternWidth.connectFrom((NumericPipe)fillPatternWidthMapper);
            } else {
                int p = this.fillPatternStyle.getPattern();
                poly.fillPatternType.setValue(BarOverlay.getGLFillPattern(p));
                poly.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)p));
            }
            poly.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        if (this.discreteX) {
            stride = ((StringToNumericMap)this.xEncoder.getValueMap()).getStrideValue();
            NumericPipe xoPipe = this.xoVar != null ? ((NumericVariable)this.xoVar).value : null;
            poly.coordX.connectFrom(this.makeOffsetCalculator((NumericPipe)this.xvalueMapper, stride, xoPipe, this.xDiscreteOffset, this.xEncoder.isReversed()));
        } else {
            poly.coordX.connectFrom((NumericPipe)this.xvalueMapper);
        }
        if (this.discreteY) {
            stride = ((StringToNumericMap)this.yEncoder.getValueMap()).getStrideValue();
            NumericPipe yoPipe = this.yoVar != null ? ((NumericVariable)this.yoVar).value : null;
            poly.coordY.connectFrom(this.makeOffsetCalculator((NumericPipe)this.yvalueMapper, stride, yoPipe, this.yDiscreteOffset, this.yEncoder.isReversed()));
        } else {
            poly.coordY.connectFrom((NumericPipe)this.yvalueMapper);
        }
        if (this.idVar == null) {
            poly.id.setValue(0.0);
        } else if (this.numericID) {
            poly.id.connectFrom(((NumericVariable)this.idVar).value);
        } else {
            poly.stringID.connectFrom(((StringVariable)this.idVar).value);
        }
        poly.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        if (this.labelVar != null && this.labelLocation != 2) {
            poly.setLabelSplit(this.dataLabelSplit);
            poly.setMultiLineJustify(this.dataLabelSplitJustify);
            poly.setLabelLocation(this.labelLocation);
            poly.setLabelPosition(this.reverseLabelPosition(this.labelPosition));
            poly.setWallBounds(this.xEncoder.getLowerLimit(), this.xEncoder.getUpperLimit(), this.yEncoder.getLowerLimit(), this.yEncoder.getUpperLimit());
            poly.setFont(this.labelStyle.getFont());
            if (this.useLabelColor) {
                poly.labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
            } else if (this.colorResponseVar != null) {
                if (this.outlineOn) {
                    poly.labelColor.connectFrom((ColorPipe)poly.edgeColor);
                } else {
                    poly.labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
                }
            } else if (poly.edgeColor.isConnected()) {
                poly.labelColor.connectFrom((ColorPipe)poly.edgeColor);
            } else {
                poly.labelColor.connectFrom((ColorPipe)labelColorMapper);
            }
            StringVector labelPipe = new StringVector();
            for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                try {
                    String formattedLabel = this.labelVar.formattedValue.getValue(i).trim();
                    if (this.dataLabelSplit) {
                        String[] splitted = Overlay.splitLabel(formattedLabel, true, -1.0, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, StatGraph.getFontMetrics(this.labelStyle.getFont()));
                        String multiLines = Overlay.makeMultiLineLabel(splitted, false);
                        labelPipe.addValue(multiLines);
                        continue;
                    }
                    labelPipe.addValue(formattedLabel);
                    continue;
                }
                catch (MissingValueException mve) {
                    labelPipe.addValue("");
                }
            }
            poly.label.connectFrom((StringPipe)labelPipe);
        } else if (this.labelVar != null) {
            double stride2;
            this.networkRoot2 = new NetworkRoot(this.networkRoot.getChannel());
            PolygonElement polyOutsideLabel = new PolygonElement(true);
            polyOutsideLabel.labelOutlineOn.setValue(this.getLabelBacklight() != 0.0);
            polyOutsideLabel.labelOutlineWidth.setValue(ScatterOverlay.getLabelOutlineWidth(this.labelStyle.getFont().getSize()));
            polyOutsideLabel.labelBacklight.setValue(this.getLabelBacklight());
            polyOutsideLabel.setLabelSplit(this.dataLabelSplit);
            polyOutsideLabel.setMultiLineJustify(this.dataLabelSplitJustify);
            polyOutsideLabel.setLabelRotation(this.labelRotate);
            if (this.discreteX) {
                stride2 = ((StringToNumericMap)this.xEncoder.getValueMap()).getStrideValue();
                NumericPipe xoPipe = this.xoVar != null ? ((NumericVariable)this.xoVar).value : null;
                polyOutsideLabel.coordX.connectFrom(this.makeOffsetCalculator((NumericPipe)this.xvalueMapper, stride2, xoPipe, this.xDiscreteOffset, this.xEncoder.isReversed()));
            } else {
                polyOutsideLabel.coordX.connectFrom((NumericPipe)this.xvalueMapper);
            }
            if (this.discreteY && this.yoVar != null) {
                stride2 = ((StringToNumericMap)this.yEncoder.getValueMap()).getStrideValue();
                NumericPipe yoPipe = this.yoVar != null ? ((NumericVariable)this.yoVar).value : null;
                polyOutsideLabel.coordY.connectFrom(this.makeOffsetCalculator((NumericPipe)this.yvalueMapper, stride2, yoPipe, this.yDiscreteOffset, this.yEncoder.isReversed()));
            } else {
                polyOutsideLabel.coordY.connectFrom((NumericPipe)this.yvalueMapper);
            }
            if (this.idVar == null) {
                polyOutsideLabel.id.setValue(0.0);
            } else if (this.numericID) {
                polyOutsideLabel.id.connectFrom(((NumericVariable)this.idVar).value);
            } else {
                polyOutsideLabel.stringID.connectFrom(((StringVariable)this.idVar).value);
            }
            polyOutsideLabel.setLabelLocation(this.labelLocation);
            polyOutsideLabel.setLabelPosition(this.reverseLabelPosition(this.labelPosition));
            polyOutsideLabel.setWallBounds(this.xEncoder.getLowerLimit(), this.xEncoder.getUpperLimit(), this.yEncoder.getLowerLimit(), this.yEncoder.getUpperLimit());
            polyOutsideLabel.setFont(this.labelStyle.getFont());
            if (this.useLabelColor || labelColorMapper == null) {
                polyOutsideLabel.labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
            } else {
                polyOutsideLabel.labelColor.connectFrom((ColorPipe)labelColorMapper);
            }
            StringVector labelPipe = new StringVector();
            for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                try {
                    String formattedLabel = this.labelVar.formattedValue.getValue(i).trim();
                    if (this.dataLabelSplit) {
                        String[] splitted = Overlay.splitLabel(formattedLabel, true, -1.0, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, StatGraph.getFontMetrics(this.labelStyle.getFont()));
                        String multiLines = Overlay.makeMultiLineLabel(splitted, false);
                        labelPipe.addValue(multiLines);
                        continue;
                    }
                    labelPipe.addValue(formattedLabel);
                    continue;
                }
                catch (MissingValueException mve) {
                    labelPipe.addValue("");
                }
            }
            polyOutsideLabel.label.connectFrom((StringPipe)labelPipe);
            polyOutsideLabel.setAlignmentOffsetX(this.alignmentOffsetX);
            polyOutsideLabel.setAlignmentOffsetX2(this.alignmentOffsetX2);
            polyOutsideLabel.setAlignmentOffsetY(this.alignmentOffsetY);
            polyOutsideLabel.setAlignmentOffsetY2(this.alignmentOffsetY2);
            this.networkRoot2.addElement((Element)polyOutsideLabel);
        }
        this.networkRoot.addElement((Element)poly);
        this.needConnect = false;
        return true;
    }

    @Override
    public Insets getPreferredOuterMargin() {
        if (this.labelVar == null || this.labelLocation != 2) {
            return zeroInsets;
        }
        return this.getPreferredLabelMargin();
    }

    private Insets getPreferredLabelMargin() {
        Insets labelMargin = new Insets(0, 0, 0, 0);
        int labelSize = 0;
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        int lp = this.reverseLabelPosition(this.labelPosition);
        boolean vertical = lp == 4 || lp == 5;
        for (int i = 0; i < this.labelVar.getUniqueValueCount(); ++i) {
            try {
                String theLabel;
                String finalLabel = theLabel = this.labelVar.formattedUniqueValue.getValue(i).trim();
                if (this.dataLabelSplit) {
                    String[] splitted = Overlay.splitLabel(theLabel, true, -1.0, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, fm);
                    finalLabel = Overlay.makeMultiLineLabel(splitted, false);
                }
                if (vertical) {
                    if (this.labelRotate == 2) {
                        labelSize = Math.max(labelSize, Overlay.getTextWidth(fm, finalLabel));
                        continue;
                    }
                    labelSize = Math.max(labelSize, Overlay.getTextHeight(fm, finalLabel));
                    continue;
                }
                if (this.labelRotate == 2) {
                    labelSize = Math.max(labelSize, Overlay.getTextHeight(fm, finalLabel));
                    continue;
                }
                labelSize = Math.max(labelSize, Overlay.getTextWidth(fm, finalLabel));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.labelBacklight != 0.0) {
            labelSize += ScatterOverlay.getLabelOutlineWidth(this.labelStyle.getFont().getSize()) + 1;
        }
        switch (lp) {
            case 2: {
                if (this.labelLocation == 2) {
                    labelMargin.left = labelSize + (int)Math.ceil(this.alignmentOffsetY);
                    break;
                }
                labelMargin.left = labelSize + APolygonElement.DEFAULT_INSIDELABEL_GAP;
                break;
            }
            case 3: {
                if (this.labelLocation == 2) {
                    labelMargin.right = labelSize + (int)Math.ceil(this.alignmentOffsetY2);
                    break;
                }
                labelMargin.right = labelSize + APolygonElement.DEFAULT_INSIDELABEL_GAP;
                break;
            }
            case 4: {
                if (this.labelLocation == 2) {
                    labelMargin.bottom = labelSize + (int)Math.ceil(this.alignmentOffsetX);
                    break;
                }
                labelMargin.bottom = labelSize + APolygonElement.DEFAULT_INSIDELABEL_GAP;
                break;
            }
            case 5: {
                labelMargin.top = this.labelLocation == 2 ? labelSize + (int)Math.ceil(this.alignmentOffsetX2) : labelSize + APolygonElement.DEFAULT_INSIDELABEL_GAP;
            }
        }
        return labelMargin;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        double max;
        double min;
        double stride;
        int top;
        int left;
        Insets in = this.labelVar == null || this.labelLocation != 1 ? super.getPreferredInnerMargin() : this.getPreferredLabelMargin();
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        left = Math.max(left, in.left);
        right = Math.max(right, in.right);
        top = Math.max(top, in.top);
        bottom = Math.max(bottom, in.bottom);
        if (this.discreteX) {
            stride = ((StringToNumericMap)this.xEncoder.getValueMap()).getStrideValue();
            if (this.xoVar != null) {
                min = ((NumericVariable)this.xoVar).getMin();
                if (min < 0.0) {
                    left = (int)((double)left + Math.abs(min) * stride);
                }
                if ((max = ((NumericVariable)this.xoVar).getMax()) > 0.0) {
                    right = (int)((double)right + max * stride);
                }
            } else if (this.xDiscreteOffset < 0.0) {
                left = (int)((double)left + Math.abs(this.xDiscreteOffset) * stride);
            } else if (this.xDiscreteOffset > 0.0) {
                right = (int)((double)right + this.xDiscreteOffset * stride);
            }
        }
        if (this.discreteY) {
            stride = ((StringToNumericMap)this.yEncoder.getValueMap()).getStrideValue();
            if (this.yoVar != null) {
                min = ((NumericVariable)this.yoVar).getMin();
                if (min < 0.0) {
                    bottom = (int)((double)bottom + Math.abs(min) * stride);
                }
                if ((max = ((NumericVariable)this.yoVar).getMax()) > 0.0) {
                    top = (int)((double)top + max * stride);
                }
            } else if (this.yDiscreteOffset < 0.0) {
                bottom = (int)((double)bottom + Math.abs(this.yDiscreteOffset) * stride);
            } else if (this.yDiscreteOffset > 0.0) {
                top = (int)((double)top + this.yDiscreteOffset * stride);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double lw = this.outlineStyle.getWidth();
        double scale = (int)lw * 2 - 1;
        if (scale != 0.0) {
            return Math.max(2.0 * scale, 5.0);
        }
        return 0.0;
    }

    protected void connectVars() {
        int i;
        double[] newValues;
        double[] values;
        ColumnMetadata cmd;
        CRD crd = this.model;
        if (crd.isAvailable(10)) {
            this.numericX = crd.getColumnClass(10) == Double.class;
            this.xvalueVar = this.discreteX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10);
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
        }
        if (crd.isAvailable(11)) {
            this.numericY = crd.getColumnClass(11) == Double.class;
            this.yvalueVar = this.discreteY ? this.connectCategory((short)11, this.missingCategoryOn) : this.connectRaw((short)11);
            if (this.discreteY) {
                this.numericDiscreteY = this.numericY;
                this.numericY = false;
            }
        } else {
            this.yvalueVar = null;
        }
        if (crd.isAvailable(23)) {
            this.numericID = crd.getColumnClass(23) == Double.class;
            this.idVar = !this.numericID ? this.connectCategory((short)23, true) : this.connectRaw((short)23);
            this.rawIDVar = this.connectRaw((short)23);
        } else {
            this.idVar = null;
            this.rawIDVar = null;
        }
        if (crd.isAvailable(5)) {
            this.labelVar = this.connectRaw((short)5);
            this.labelVar.setFormattedValueMissingValueExceptionsEnabled(true);
        } else {
            this.labelVar = null;
        }
        this.colorResponseVar = crd.isAvailable(108) ? this.connectRaw((short)108) : null;
        if (crd.isAvailable(3)) {
            this.groupVar = this.connectCategory((short)3, true);
            this.rawGroupVar = this.connectRaw((short)3);
            if (crd.getColumn((short)3) == crd.getColumn((short)23)) {
                this.missingGroupOn = false;
            }
        } else {
            this.groupVar = null;
            this.rawGroupVar = null;
        }
        if (crd.isAvailable(37)) {
            cmd = (ColumnMetadata)this.model.getColumnLabel(37);
            this.xoVar = new NumericVectorVariable();
            values = this.model.getDoubleColumn(37);
            newValues = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                newValues[i] = values[i] != values[i] ? 0.0 : values[i];
            }
            ((NumericVectorVariable)this.xoVar).connectFrom(newValues);
            if (cmd.getFormat() != null) {
                this.xoVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                this.xoVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            this.xoVar.setLabel(this.getLabel((short)37));
        } else {
            this.xoVar = null;
        }
        if (crd.isAvailable(38)) {
            cmd = (ColumnMetadata)this.model.getColumnLabel(38);
            this.yoVar = new NumericVectorVariable();
            values = this.model.getDoubleColumn(38);
            newValues = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                newValues[i] = values[i] != values[i] ? 0.0 : values[i];
            }
            ((NumericVectorVariable)this.yoVar).connectFrom(newValues);
            if (cmd.getFormat() != null) {
                this.yoVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                this.yoVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            this.yoVar.setLabel(this.getLabel((short)38));
        } else {
            this.yoVar = null;
        }
        if (crd.isAvailable(118)) {
            cmd = (ColumnMetadata)this.model.getColumnLabel(118);
            this.rotateVar = new NumericVectorVariable();
            values = this.model.getDoubleColumn(118);
            newValues = new double[values.length];
            for (i = 0; i < values.length; ++i) {
                if (values[i] != values[i]) {
                    newValues[i] = 0.0;
                    continue;
                }
                newValues[i] = values[i] % 360.0;
                if (!(newValues[i] < 0.0)) continue;
                int n = i;
                newValues[n] = newValues[n] + 360.0;
            }
            ((NumericVectorVariable)this.rotateVar).connectFrom(newValues);
            if (cmd.getFormat() != null) {
                this.rotateVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                this.rotateVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            this.rotateVar.setLabel(this.getLabel((short)118));
        } else {
            this.rotateVar = null;
        }
        Variable urlVar = this.connectCategory((short)52, false);
        VariableProcessor vp = null;
        if (crd.whereExpression != null || this.idVar != null || this.groupVar != null && !this.missingGroupOn) {
            vp = new VariableProcessor();
            this.addVarToVP(vp, this.xvalueVar);
            this.addVarToVP(vp, this.yvalueVar);
            this.addVarToVP(vp, this.idVar);
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 12);
            }
            if (this.colorResponseVar != null) {
                vp.addVariable(this.colorResponseVar, 12);
            }
            if (this.labelVar != null) {
                vp.addVariable(this.labelVar, 12);
            }
            this.addVarToVP(vp, this.xoVar);
            this.addVarToVP(vp, this.yoVar);
            this.addVarToVP(vp, this.rotateVar);
            if (urlVar != null) {
                vp.addVariable(urlVar);
            }
            if (this.groupVar != null && !this.missingGroupOn) {
                vp.addVariable(this.rawGroupVar);
                vp.setWhereExpression("^(" + this.rawGroupVar.getName() + " IS MISSING)");
                this.whereRoles = new int[]{3};
            }
            vp.addVariable(this.rawIDVar);
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (^" + this.rawIDVar.getName() + " IS MISSING)");
            } else {
                vp.setWhereExpression("^(" + this.rawIDVar.getName() + " IS MISSING)");
            }
            this.addCRDWhereClause(vp);
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.groupVar != null && this.missingGroupOn) {
            this.probe.setMissingReplacement(this.groupVar instanceof NumericVariable ? StatGraph.missingOption : StatGraph.missingCharacter);
        }
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addTooltip(vp, "ID");
            this.addTooltip(vp, "GROUP");
            this.addTooltip(vp, "COLORRESPONSE");
        }
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.fillColorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
            case 15: {
                return this.lineEncoder;
            }
            case 22: {
                return this.fillPatternColorEncoder;
            }
            case 21: {
                return this.fillPatternEncoder;
            }
            case 25: {
                return this.labelColorEncoder;
            }
        }
        return null;
    }

    protected NumericPipe makeOffsetCalculator(NumericPipe np, double strideValue, NumericPipe offsetPipe, double offsetValue, boolean reversed) {
        if (offsetPipe == null && offsetValue == 0.0) {
            return np;
        }
        Calculator offsetCalculator = reversed ? new Calculator("inA-inB*inC") : new Calculator("inA+inB*inC");
        offsetCalculator.inA.connectFrom(np);
        offsetCalculator.inB.setValue(strideValue);
        if (offsetPipe != null) {
            offsetCalculator.inC.connectFrom(offsetPipe);
        } else {
            offsetCalculator.inC.setValue(offsetValue);
        }
        return offsetCalculator;
    }

    public void setAlignmentOffset(double offset, String axis) {
        if (offset <= 0.0) {
            return;
        }
        if (axis.equalsIgnoreCase("X")) {
            this.alignmentOffsetX = offset;
        } else if (axis.equalsIgnoreCase("X2")) {
            this.alignmentOffsetX2 = offset;
        } else if (axis.equalsIgnoreCase("Y")) {
            this.alignmentOffsetY = offset;
        } else if (axis.equalsIgnoreCase("Y2")) {
            this.alignmentOffsetY2 = offset;
        }
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.outlineOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return this.outlineOn ? 11 : 7;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.fillOn || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.outlineOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.colorResponseVar != null) {
            return null;
        }
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        return super.getLegendItems(attrType);
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return this.fillOn && this.groupVar != null && this.fillColorEncoder != null;
            }
            case 11: {
                return this.outlineOn && this.groupVar != null && this.lineColorEncoder != null;
            }
            case 3: {
                return this.outlineOn && this.lineEncoder != null;
            }
            case 14: {
                return this.fillPatternOn && this.groupVar != null && this.fillPatternColorEncoder != null;
            }
            case 5: {
                return this.fillPatternOn && this.groupVar != null && this.fillPatternEncoder != null;
            }
            case 4: {
                return !this.fillOn && !this.useLineThickness;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return this.fillStyle;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return this.outlineStyle;
    }

    @Override
    protected FillPatternAttrs getAttrMapDefaultFillPatternAttrs() {
        return this.fillPatternStyle;
    }

    @Override
    public Color getMissingColor() {
        return this.missingGradientColor;
    }

    public Color getMissingGradientColor() {
        return this.missingGradientColor;
    }

    public void setMissingGradientColor(Color missingGradientColor) {
        this.missingGradientColor = missingGradientColor;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce == null) {
            ce = (ColorEncoder)this.getEncoder((byte)17);
        }
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper mapper;
        String error;
        if (type == 1) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce == null) {
            ce = (ColorEncoder)this.getEncoder((byte)17);
        }
        if (ce == null || !(ce.getInput() instanceof ContinuousRange)) {
            return null;
        }
        ContinuousRange range = (ContinuousRange)ce.getInput();
        if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(range.getMin(), range.getMax(), !this.fillOn)) == null) {
            double dt = this.dataTransparency;
            if (this.fillOn && this.fillStyle.getTransparency() >= 0.0) {
                dt = this.fillStyle.getTransparency();
            }
            return mapper.getRangeColorMapper().getFullRanges(dt);
        }
        Color[] colors = ce.rampColors;
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public boolean hasMissingValue() {
        if (this.colorResponseVar == null) {
            return false;
        }
        int clrvIDX = this.model.getSrcModel().getColumn(this.model.getColumnName((short)108));
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(clrvIDX);
        return cmd.getMissings() > 0;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    public void setUseLabelColor(boolean useLabelColor) {
        this.useLabelColor = useLabelColor;
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.idVar == null ? 1 : this.idVar.getUniqueValueCount();
    }

    public double getRotate() {
        return this.rotate;
    }

    public void setRotate(double rotate) {
        this.rotate = rotate % 360.0;
        if (this.rotate < 0.0) {
            this.rotate += 360.0;
        }
    }

    public int getLabelRotate() {
        return this.labelRotate;
    }

    public void setLabelRotate(int labelRotate) {
        this.labelRotate = labelRotate;
    }

    public boolean isRotatedPolygon() {
        return this.rotatedPolygon;
    }

    public void setRotatedPolygon(boolean rotatedPolygon) {
        this.rotatedPolygon = rotatedPolygon;
    }

    @Override
    public int getNumOfTooltips() {
        return this.getNumberOfDrawingElements();
    }

    public int getMaxVerticesPerPolygon(int vertexThreshold) {
        int nobs = this.rawIDVar.getValueCount();
        if (nobs <= vertexThreshold) {
            return -1;
        }
        HashMap<String, Integer> vertexCountMap = new HashMap<String, Integer>();
        if (this.rawIDVar == null) {
            String key = this.getStmt();
            int obs = this.yvalueVar.getValueCount();
            int count = 0;
            for (int i = 0; i < obs; ++i) {
                if (this.xvalueVar.isMissing(i) || this.yvalueVar.isMissing(i)) continue;
                ++count;
            }
            vertexCountMap.put(key, count);
        } else {
            for (int i = 0; i < this.rawIDVar.getValueCount(); ++i) {
                if (this.xvalueVar.isMissing(i) || this.yvalueVar.isMissing(i)) continue;
                try {
                    String key = this.numericID ? Double.toString(((NumericVariable)this.rawIDVar).value.getValue(i)) : ((StringVariable)this.rawIDVar).value.getValue(i);
                    Object value = vertexCountMap.get(key);
                    if (value == null) {
                        vertexCountMap.put(key, 1);
                        continue;
                    }
                    vertexCountMap.put(key, (Integer)value + 1);
                    continue;
                }
                catch (MissingValueException key) {
                    // empty catch block
                }
            }
        }
        Iterator valueIterator = vertexCountMap.values().iterator();
        int maxVertices = -1;
        while (valueIterator.hasNext()) {
            int vCount;
            Object value = valueIterator.next();
            if (value == null || (vCount = ((Integer)value).intValue()) <= vertexThreshold) continue;
            maxVertices = Math.max(maxVertices, vCount);
        }
        return maxVertices;
    }
}

