/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridLabelEntry;
import com.sas.graphics.applets.statgraph.sgchart.grid.OneDPlotInterface;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.ObstaclesInterface;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.VisibilityVariable;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.AutoContinuousLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.CarpetOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SpecLimitsOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.ContinuousLegendInterface;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextLayout;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Overlay
implements ObstaclesInterface,
DiscreteLegendInterface,
ContinuousLegendInterface,
AutoLegendInterface,
AutoContinuousLegendInterface,
OneDPlotInterface {
    public static final String RB_KEY = "Overlay.";
    protected boolean visible = true;
    protected CRD model;
    protected RangeChangeListenerList rcList = new RangeChangeListenerList();
    protected Probe probe;
    protected String probeIDLabel = null;
    protected String probeID = null;
    protected boolean primary = false;
    protected String legendLabel;
    protected String xAxis = "x";
    protected String yAxis = "y";
    protected String name = null;
    protected String stmt = null;
    protected String contextName = "GraphDataStyleDefault";
    protected double dataTransparency = 0.0;
    protected boolean useDataTransparency = false;
    protected HashMap roleMap = new HashMap();
    protected boolean needConnect = true;
    protected int[] selectedObs = null;
    protected NetworkRoot hiliteNetworkRoot;
    protected VariableProcessor hiliteProcessor;
    protected boolean dataSelectable = false;
    protected Color selectionColor = new Color(255, 197, 0);
    protected ArrayList chPipes = new ArrayList();
    protected boolean missingGroupOn = true;
    protected boolean missingCategoryOn = StatGraph.includeMissingDiscrete;
    protected int[] whereRoles = null;
    public static final String URL_PIPE_NAME = "_URL_";
    protected int compWidth;
    protected int compHeight;
    protected boolean scaleMarkers = true;
    public static final int CENTER_JUSTIFICATION = 0;
    public static final int TOP_JUSTIFICATION = 1;
    public static final int BOTTOM_JUSTIFICATION = 2;
    public static final int LEFT_JUSTIFICATION = 3;
    public static final int RIGHT_JUSTIFICATION = 4;
    protected int overlayJustification = 0;
    protected int overlayBase = 0;
    public boolean xUnionAllPages = false;
    public boolean yUnionAllPages = false;
    protected boolean discreteX = false;
    protected boolean discreteY = false;
    protected boolean numericDiscreteX = false;
    protected boolean numericDiscreteY = false;
    protected PointLabelLayout plLayout;
    protected VisibilityVariable labelVisibleVar;
    protected int[] initialHideLabelObs = null;
    protected VariableProcessor whereVP = null;
    protected ArrayList nonFormatRoles = new ArrayList();
    protected HashMap tipRoleMap;
    protected HashMap attrVarMap = new HashMap();
    protected boolean initialFitting = true;
    protected int topReservedSpace = 0;
    protected int bottomReservedSpace = 0;
    protected int leftReservedSpace = 0;
    protected int rightReservedSpace = 0;
    public static final int FRONT = 0;
    public static final int BACK = 1;
    public static final int CENTER = 2;
    protected int overlayPosition = 0;
    protected boolean extrudedOverlay = false;
    protected double extrusionDepth = 0.0;
    public static final int SKIN_NONE = 0;
    public static final int SKIN_MODERN = 1;
    public static final int SKIN_SATIN = 2;
    public static final int SKIN_PRESSED = 3;
    public static final int SKIN_SHEEN = 4;
    public static final int SKIN_CRISP = 5;
    public static final int SKIN_GLOSS = 6;
    public static final int SKIN_MATTE = 7;
    protected int skinType = 0;
    protected Image[] pixelBenderImages;
    public static int SPLIT_JUSTIFY_AUTO = 0;
    public static int SPLIT_JUSTIFY_CENTER = 1;
    public static int SPLIT_JUSTIFY_LEFT = 2;
    public static int SPLIT_JUSTIFY_RIGHT = 3;
    protected boolean curveLabelSplit = false;
    protected char[] curveLabelSplitChar = new char[]{' '};
    protected boolean curveLabelSplitCharDrop = true;
    protected int curveLabelSplitJustify = SPLIT_JUSTIFY_AUTO;
    protected NumericVector splitCurveLabelWidth;
    protected NumericVector splitCurveLabelHeight;
    protected boolean dataLabelSplit = false;
    protected char[] dataLabelSplitChar = new char[]{' '};
    protected boolean dataLabelSplitCharDrop = true;
    protected int dataLabelNumSplitChars = 0;
    protected int dataLabelSplitJustify = SPLIT_JUSTIFY_AUTO;
    protected boolean padSplittedCurveLabel = true;
    public static int DATALABEL_FIT_NONE = 0;
    public static int DATALABEL_FIT_AUTO = 1;
    public static int DATALABEL_FIT_SPLIT = 2;
    public static int DATALABEL_FIT_SPLITALWAYS = 3;
    public static int DATALABEL_FIT_ROTATE = 4;
    public static int DATALABEL_FIT_INSIDEPREFERRED = 5;
    protected int dataLabelFitPolicy = DATALABEL_FIT_AUTO;
    protected boolean subpixelRendering = false;
    protected boolean tooltipEnabled = true;
    protected boolean displayGridLabel = false;
    protected boolean labelToGridLabel = false;
    protected boolean uniformPlotSize = false;
    protected int gridLabelTopOffset = 0;
    protected int gridLabelLeftOffset = 0;
    protected int gridLabelBottomOffset = 0;
    protected int gridLabelRightOffset = 0;
    protected double labelMaxWidth = Double.MAX_VALUE;
    protected GridLabelEntry gridLabelEntryT = null;
    protected GridLabelEntry gridLabelEntryL = null;
    protected GridLabelEntry gridLabelEntryB = null;
    protected GridLabelEntry gridLabelEntryR = null;
    protected boolean useFillTransparency = false;
    protected boolean useMarkerTransparency = false;
    protected boolean useLineThickness = false;
    protected boolean useMarkerSize = false;
    protected boolean useMarkerWeight = false;
    protected int maxDataSkinDrawingElements = StatGraph.DATA_SKIN_MAX;
    protected boolean disableAA = false;
    protected Object savedAAHint = null;
    protected boolean savedTextAntialiased = true;
    protected boolean contribXMinOffset = true;
    protected boolean contribXMaxOffset = true;
    protected boolean contribYMinOffset = true;
    protected boolean contribYMaxOffset = true;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int REVERSEDATA = 3;
    protected int groupOrder = 0;
    public static int FILL_SOLID = 0;
    public static int FILL_GRADIENT = 1;
    public static int FILL_ALPHAGRADIENT = 2;
    protected int fillType = FILL_SOLID;
    protected int endAlpha = 0;
    protected Color gradientEndColor = null;
    protected boolean discreteOffsetPadding = true;
    protected int userSkinType = this.skinType;
    protected boolean drawByGroupOrder = false;
    protected double capScale = 1.0;
    protected boolean presortData = false;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    protected static final int ATTR_MAP_MARKER_SYMBOL = 0;
    protected static final int ATTR_MAP_MARKER_SIZE = 1;
    protected static final int ATTR_MAP_MARKER_WEIGHT = 2;
    protected static final int ATTR_MAP_LINE_PATTERN = 3;
    protected static final int ATTR_MAP_LINE_THICKNESS = 4;
    protected static final int ATTR_MAP_FILL_PATTERN = 5;
    protected static final int ATTR_MAP_MARKER_COLOR = 10;
    protected static final int ATTR_MAP_LINE_COLOR = 11;
    protected static final int ATTR_MAP_FILL_COLOR = 12;
    protected static final int ATTR_MAP_TEXT_COLOR = 13;
    protected static final int ATTR_MAP_FILL_PATTERN_COLOR = 14;
    protected static final int ATTR_MAP_MARKER_FILL_COLOR = 15;
    protected static final int ATTR_MAP_MARKER_OUTLINE_COLOR = 16;

    public void setPresortData(boolean b) {
        this.presortData = b;
    }

    public boolean isPresortData() {
        return this.presortData;
    }

    public boolean isDrawByGroupOrder() {
        return this.drawByGroupOrder;
    }

    public void setDrawByGroupOrder(boolean drawByGroupOrder) {
        this.drawByGroupOrder = drawByGroupOrder;
    }

    public static Color alphaColor(Color c, int alpha) {
        if (c == null) {
            return null;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static ColorPipe alphaColor(ColorPipe pipe, int count, int alpha) {
        ColorVector vec = new ColorVector();
        pipe.init(new AInitAction(null));
        for (int i = 0; i < count; ++i) {
            try {
                Color c = pipe.getValue(i);
                vec.addValue(Overlay.alphaColor(c, alpha));
                continue;
            }
            catch (MissingValueException e) {
                vec.addValue((Color)null);
            }
        }
        return vec;
    }

    public void setFillType(int t) {
        this.fillType = t;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setEndAlpha(int a) {
        this.endAlpha = a;
    }

    public int getEndAlpha() {
        return this.endAlpha;
    }

    public void setGradientEndColor(Color c) {
        this.gradientEndColor = c;
    }

    public Color getGradientEndColor() {
        return this.gradientEndColor;
    }

    public void setGroupOrder(int order) {
        this.groupOrder = order;
    }

    public int getGroupOrder() {
        return this.groupOrder;
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public void setDataLabelFitPolicy(int policy) {
        this.dataLabelFitPolicy = policy;
    }

    public int getDataLabelFitPolicy() {
        return this.dataLabelFitPolicy;
    }

    public void setCurveLabelSplit(boolean split) {
        this.curveLabelSplit = split;
    }

    public boolean isCurveLabelSplit() {
        return this.curveLabelSplit;
    }

    public void setCurveLabelSplitChar(char[] schars) {
        this.curveLabelSplitChar = schars;
    }

    public char[] getCurveLabelSplitChar() {
        return this.curveLabelSplitChar;
    }

    public void setCurveLabelSplitCharDrop(boolean b) {
        this.curveLabelSplitCharDrop = b;
    }

    public boolean isCurveLabelSplitCharDrop() {
        return this.curveLabelSplitCharDrop;
    }

    public void setCurveLabelSplitJustify(int justify) {
        this.curveLabelSplitJustify = justify;
    }

    public int getCurveLabelSplitJustify() {
        return this.curveLabelSplitJustify;
    }

    public void setDataLabelSplit(boolean split) {
        this.dataLabelSplit = split;
    }

    public boolean isDataLabelSplit() {
        return this.dataLabelSplit;
    }

    public void setDataLabelSplitChar(char[] schars) {
        this.dataLabelSplitChar = schars;
    }

    public char[] getDataLabelSplitChar() {
        return this.dataLabelSplitChar;
    }

    public void setDataLabelSplitCharDrop(boolean b) {
        this.dataLabelSplitCharDrop = b;
    }

    public boolean isDataLabelSplitCharDrop() {
        return this.dataLabelSplitCharDrop;
    }

    public void setDataLabelSplitJustify(int justify) {
        this.dataLabelSplitJustify = justify;
    }

    public int getDataLabelSplitJustify() {
        return this.dataLabelSplitJustify;
    }

    public boolean isPadSplittedCurveLabel() {
        return this.padSplittedCurveLabel;
    }

    public void setPadSplittedCurveLabel(boolean padding) {
        this.padSplittedCurveLabel = padding;
    }

    public boolean isConditionalHilited() {
        return !this.chPipes.isEmpty();
    }

    public void addCHPipe(BooleanVector bv) {
        if (bv != null) {
            this.chPipes.add(bv);
        }
    }

    public int getNumCHPipes() {
        return this.chPipes.size();
    }

    public BooleanVector getCHPipe(int idx) {
        return (BooleanVector)this.chPipes.get(idx);
    }

    public void setExtrudedOverlay(boolean extruded) {
        this.extrudedOverlay = extruded;
    }

    public boolean isExtrudedOverlay() {
        return this.extrudedOverlay;
    }

    public void setOverlayPosition(int pos) {
        this.overlayPosition = pos;
    }

    public int getOverlayPosition() {
        return this.overlayPosition;
    }

    public void setExtrusionDepth(double d) {
        this.extrusionDepth = d;
    }

    public double getExtrusionDepth() {
        return this.extrusionDepth;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setSkinType(int type) {
        this.skinType = type;
        this.needConnect = true;
    }

    public void setInitialFitting(boolean initial) {
        this.initialFitting = initial;
    }

    public PointLabelLayout getPointLabelLayout() {
        return this.plLayout;
    }

    public void setPointLabelLayout(PointLabelLayout l) {
        this.plLayout = l;
        this.plLayout.setVisibleVariable(this.labelVisibleVar);
        this.plLayout.setObstaclesSource(this);
    }

    public HashMap getRoleMap() {
        return this.roleMap;
    }

    public void setComponentSize(int width, int height) {
        this.compWidth = width;
        this.compHeight = height;
    }

    public void setScaleMarkers(boolean b) {
        this.scaleMarkers = b;
    }

    public void setOverlayJustification(int just) {
        this.overlayJustification = just;
    }

    public int getOverlayJustification() {
        return this.overlayJustification;
    }

    public void setOverlayBase(int base) {
        this.overlayBase = base;
    }

    public int getOverlayBase() {
        return this.overlayBase;
    }

    public boolean isInnerMarginOverlay() {
        return this.overlayJustification == 2 || this.overlayJustification == 1 || this.overlayJustification == 3 || this.overlayJustification == 4;
    }

    public int getOverlayMargin() {
        return 0;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color c) {
        this.selectionColor = c;
    }

    public void reconnect() {
        this.needConnect = true;
    }

    public void addAttrVar(String role, AttrMapper mapper) {
        if (mapper == null) {
            return;
        }
        this.attrVarMap.put(role.toUpperCase(), mapper);
    }

    public void removeAttrVar(String role) {
        this.attrVarMap.remove(role.toUpperCase());
    }

    public AttrMapper getAttrVarMapper(String role) {
        return (AttrMapper)this.attrVarMap.get(role.toUpperCase());
    }

    public boolean hasAttrVar(String role) {
        return this.attrVarMap.containsKey(role.toUpperCase());
    }

    public void addRole(String role, Object colMeta) {
        ColumnMetadata meta = (ColumnMetadata)colMeta;
        ColumnMetadata cmd = new ColumnMetadata(meta.getName(), meta.getType());
        cmd.setLabel(meta.getLabel());
        if (meta.getFormat() != null) {
            cmd.setFormat(meta.getFormat().getName());
        }
        this.roleMap.put(role, cmd);
    }

    public void removeRole(String role) {
        this.roleMap.remove(role);
    }

    public ColumnMetadata getRoleMetadataFromName(String name) {
        Object[] values = this.roleMap.values().toArray();
        for (int i = 0; i < values.length; ++i) {
            ColumnMetadata cmd = (ColumnMetadata)values[i];
            if (!name.equals(cmd.getName())) continue;
            return cmd;
        }
        return null;
    }

    public ColumnMetadata getRoleMetadata(String role) {
        return (ColumnMetadata)this.roleMap.get(role);
    }

    public void setTipRoleMap(HashMap map) {
        this.tipRoleMap = map;
    }

    protected void addTooltip(VariableProcessor vp, String role) {
        this.addTooltip(vp, role, this.probe);
    }

    private boolean isColumnAdded(String name, Probe p) {
        Probe.ProbeEntryEnumerator existed = p.enumerate();
        if (existed == null) {
            return false;
        }
        while (existed.hasMoreElements()) {
            Probe.ProbeEntry pe = (Probe.ProbeEntry)existed.nextElement();
            if (!pe.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected void addTooltip(VariableProcessor vp, String role, Probe currProbe) {
        boolean formatChanged;
        String roleName = role.toUpperCase();
        if (!this.tooltipEnabled || !this.roleMap.containsKey(roleName)) {
            return;
        }
        ColumnMetadata cmd = this.getRoleMetadata(roleName);
        if (this.isColumnAdded(cmd.getLabel(), currProbe)) {
            return;
        }
        int col = this.model.getSrcModel().getColumn(cmd.getName());
        StringVectorVariable svv = new StringVectorVariable();
        ColumnMetadata cmd2 = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(col);
        boolean bl = formatChanged = !this.hasSameFormat(cmd, cmd2);
        if (formatChanged) {
            this.model.getSrcModel().setColumnLabel(col, cmd);
            svv.connectFrom(this.model.getSrcModel().getUpdatedColumnAsClassColumn(col));
        } else {
            svv.connectFrom(this.model.getSrcModel().getColumnAsClassColumn(col, true));
        }
        if (vp != null) {
            vp.addVariable((Variable)svv);
        }
        currProbe.addPipe(cmd.getLabel(), (Pipe)svv.value);
        if (formatChanged) {
            this.model.getSrcModel().setColumnLabel(col, cmd2);
            this.model.getSrcModel().getUpdatedColumnAsClassColumn(col);
        }
    }

    protected void addTooltip(VariableProcessor vp, String role, Probe currProbe, int statistic) {
        String roleName = role.toUpperCase();
        if (!this.tooltipEnabled || !this.roleMap.containsKey(roleName)) {
            return;
        }
        ColumnMetadata cmd = this.getRoleMetadata(roleName);
        if (this.isColumnAdded(cmd.getLabel(), currProbe)) {
            return;
        }
        int col = this.model.getSrcModel().getColumn(cmd.getName());
        if (cmd.getType() == 1) {
            NumericVectorVariable nvv = new NumericVectorVariable();
            nvv.connectFrom(this.model.getSrcModel().getDoubleColumn(col));
            if (vp != null) {
                vp.addVariable((Variable)nvv, statistic);
            }
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            currProbe.setMissingReplacement(StatGraph.missingOption);
            currProbe.addPipe(cmd.getLabel(), (Pipe)nvv.value);
        } else {
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom(this.model.getSrcModel().getStringColumn(col));
            if (vp != null) {
                vp.addVariable((Variable)svv);
            }
            if (cmd.getFormat() != null) {
                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
            currProbe.setMissingReplacement(StatGraph.missingCharacter);
            currProbe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
        }
    }

    protected void addTooltip(VariableProcessor vp, short role) {
        if (!this.tooltipEnabled || !this.model.isAvailable(role)) {
            return;
        }
        ColumnMetadata cmd = this.getRoleMetadataFromName(this.model.getColumnName(role));
        if (this.isColumnAdded(cmd.getLabel(), this.probe)) {
            return;
        }
        int col = this.model.getSrcModel().getColumn(cmd.getName());
        if (cmd.getType() == 1) {
            NumericVectorVariable nvv = new NumericVectorVariable();
            nvv.connectFrom(this.model.getDoubleColumn(role));
            if (vp != null) {
                vp.addVariable((Variable)nvv);
            }
            if (cmd.getFormat() != null) {
                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            } else {
                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            }
            this.probe.setMissingReplacement(StatGraph.missingOption);
            this.probe.addPipe(cmd.getLabel(), (Pipe)nvv.formattedValue);
        } else {
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom(this.model.getStringColumn(role));
            if (vp != null) {
                vp.addVariable((Variable)svv);
            }
            if (cmd.getFormat() != null) {
                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
            }
            this.probe.setMissingReplacement(StatGraph.missingCharacter);
            this.probe.addPipe(cmd.getLabel(), (Pipe)svv.formattedValue);
        }
    }

    protected void addCustomTips(VariableProcessor vp) {
        if (!this.tooltipEnabled) {
            return;
        }
        int cnt = 0;
        while (this.model.isAvailable(300 + cnt)) {
            int r = 300 + cnt;
            if (this.tipRoleMap != null && this.tipRoleMap.get(new Integer(r)) != null) {
                this.addTooltip(vp, (String)this.tipRoleMap.get(new Integer(r)));
            }
            ++cnt;
        }
    }

    protected void addVarToVP(VariableProcessor vp, Variable var) {
        if (var != null) {
            vp.addVariable(var);
            if (this.model.subsetObs != null) {
                vp.setSubsetByObservation(this.model.subsetObs, this.model.subsetObsCount);
            }
        }
    }

    public int[] getAllObsWithoutWhereProcessing() {
        if (this.whereVP == null) {
            return null;
        }
        VariableProcessor.VariableEntry[] ve = this.whereVP.getVariables();
        int[] obs = new int[ve[0].variable.getValueCount()];
        for (int i = 0; i < obs.length; ++i) {
            obs[i] = this.whereVP.getIndexWithoutWhereProcessing(i);
        }
        return obs;
    }

    public int getObsWithoutWhereProcessing(int obs) {
        if (this.whereVP == null) {
            return obs;
        }
        return this.whereVP.getIndexWithoutWhereProcessing(obs);
    }

    protected void addCRDWhereClause(VariableProcessor vp) {
        if (this.model.whereExpression != null) {
            for (int i = 0; i < this.model.whereVars.length; ++i) {
                StringVectorVariable sv;
                if (this.model.whereVars[i] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[i].getName());
                    sv.setName(this.model.whereVars[i].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[i]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.whereExpression + ")");
            } else {
                vp.setWhereExpression(this.model.whereExpression);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            } else {
                this.whereVP = vp;
            }
        } else {
            this.whereVP = vp;
        }
    }

    public static Color applyTransparency(Color c, double transparency) {
        if (c == null) {
            return c;
        }
        int a = (int)(255.0 * (1.0 - transparency));
        if (c.getAlpha() == a) {
            return c;
        }
        Color nc = new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        return nc;
    }

    public Color applyDataTransparency(Color c) {
        return Overlay.applyTransparency(c, this.dataTransparency);
    }

    public double getAttrTransparency(ColorAttr colorAttr) {
        return colorAttr.getTransparency() < 0.0 ? this.dataTransparency : colorAttr.getTransparency();
    }

    public Color applyDataTransparency(ColorAttr colorAttr) {
        return Overlay.applyTransparency(colorAttr.getColor(), this.getAttrTransparency(colorAttr));
    }

    public Color applyDataTransparency(Color c, double attrTransparency) {
        double tr = attrTransparency < 0.0 ? this.dataTransparency : attrTransparency;
        return Overlay.applyTransparency(c, tr);
    }

    public double getDataTransparency() {
        return this.dataTransparency;
    }

    public void setDataTransparency(double b) {
        this.dataTransparency = b;
        this.useDataTransparency = true;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean b) {
        this.primary = b;
    }

    public abstract DataRange getDataRange(byte var1);

    public abstract void setChannel(Channel var1);

    public abstract void draw(Graphics var1);

    public void drawNoneClipped(Graphics g) {
    }

    public void drawSelection(Graphics g) {
        if (!this.isHighlight() || this.hiliteNetworkRoot == null || this.hiliteProcessor == null) {
            return;
        }
        this.hiliteProcessor.setSubsetByObservation(this.selectedObs, this.selectedObs.length);
        this.hiliteNetworkRoot.draw(this.hiliteNetworkRoot.getChannel(), false);
    }

    public boolean isDataSelectable() {
        return this.dataSelectable;
    }

    public void setDataSelectable(boolean sel) {
        this.dataSelectable = sel;
    }

    public int[] getSelection() {
        return this.selectedObs;
    }

    public void setSelection(int[] obs) {
        if (this.isHighlight()) {
            this.selectedObs = obs;
        }
    }

    public Object getID() {
        return this;
    }

    public boolean isHighlight() {
        return false;
    }

    public void updateNetworkElements() {
    }

    public void updateCurveLabelElements() {
    }

    public void updateNetwork() {
        if (this.needConnect) {
            return;
        }
        this.connectNetwork();
    }

    protected boolean connectNetwork() {
        return true;
    }

    public void select() {
    }

    public abstract void setEncoder(byte var1, Encoder var2);

    public double getPreferredOffset(byte dimension) {
        return 0.0;
    }

    public Insets getPreferredOuterMargin() {
        return zeroInsets;
    }

    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        return new Insets(top, left, bottom, right);
    }

    public Encoder getEncoder(byte dimension) {
        return null;
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        this.rcList.remove(l);
    }

    public void removeAllRangeChangeListeners() {
        this.rcList = new RangeChangeListenerList();
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        this.rcList.add(l);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public CRD getModel() {
        if (this.model == null) {
            this.model = new CRD();
        }
        return this.model;
    }

    public void setModel(CRD aModel) {
        this.model = aModel;
    }

    public Probe getProbe() {
        return this.probe;
    }

    public void setProbe(Probe p) {
        this.probe = p;
    }

    public String getProbeIDLabel() {
        return this.probeIDLabel;
    }

    public void setProbeIDLabel(String s) {
        this.probeIDLabel = s;
    }

    public String getProbeID() {
        return this.probeID;
    }

    public void setProbeID(String s) {
        this.probeID = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLegendLabel() {
        if (this.legendLabel == null) {
            return this.getName();
        }
        return this.legendLabel;
    }

    @Override
    public String getDefaultLegendTitle() {
        return null;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return true;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        return null;
    }

    @Override
    public String getDefaultSizeLegendTitle() {
        return null;
    }

    public void setLegendLabel(String aString) {
        this.legendLabel = aString;
    }

    public String getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(String aString) {
        this.xAxis = aString;
    }

    public String getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(String aString) {
        this.yAxis = aString.toLowerCase();
    }

    public int[] getMarkerShapes() {
        return new int[0];
    }

    public int[] getMarkerWidths() {
        return new int[0];
    }

    public int[] getMarkerWeights() {
        return new int[0];
    }

    public int[] getLinePatterns() {
        return new int[0];
    }

    public int[] getLineWidths() {
        return new int[0];
    }

    public Color[] getLineColors() {
        return new Color[0];
    }

    public Color[] getFillColors() {
        return new Color[0];
    }

    public Color[] getFillPatternColors() {
        return new Color[0];
    }

    public int[] getFillPatterns() {
        return new int[0];
    }

    public boolean isGroupAllMissings() {
        if (this.model == null || !this.model.isAvailable(3)) {
            return false;
        }
        String[] groups = this.getGroupValues();
        return groups == null || groups.length == 0;
    }

    public String[] getGroupValues() {
        return new String[0];
    }

    public String[] getMarkerShapeValues() {
        return this.getGroupValues();
    }

    public String[] getMarkerColorValues() {
        return this.getGroupValues();
    }

    public String[] getLinePatternValues() {
        return this.getGroupValues();
    }

    public String[] getLineColorValues() {
        return this.getGroupValues();
    }

    public String[] getUniqueValues(short role) {
        StringVariable group = (StringVariable)this.connectCategory(role, true);
        this.applyWhereClause(new Variable[]{group});
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    public String[] getUniqueValues(short role, int sort) {
        if (sort == 0) {
            return this.getUniqueValues(role);
        }
        StringVectorVariable group = (StringVectorVariable)this.connectCategory(role, true);
        Variable rawGroup = this.connectRaw((short)3);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        vp.addVariable(rawGroup);
        if (rawGroup instanceof NumericVariable) {
            vp.setSort(rawGroup, sort);
        } else {
            vp.setSort((Variable)group, sort);
        }
        if (!this.missingGroupOn) {
            vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    public String[] getSortedUniqueValues(short role, int sort) {
        boolean numeric = this.model.getColumnClass(role) == Double.class;
        String formattedMiss = null;
        if (numeric) {
            SASFormat fmt = this.model.getColumnFormat(role);
            if (fmt == null) {
                fmt = DataModel.defaultFormat;
            }
            if ((formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim()) == null || formattedMiss.equals(".")) {
                formattedMiss = StatGraph.missingOption;
            }
        }
        Variable group = numeric ? this.connectRaw(role) : this.connectCategory(role, true);
        group.setUniqueValueSort(sort);
        group.setSortByFormattedValues(false);
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                gv[i] = group.formattedUniqueValue.getValue(i);
                if (!numeric) continue;
                gv[i] = gv[i].trim();
                continue;
            }
            catch (MissingValueException mve) {
                gv[i] = numeric ? formattedMiss : "";
            }
        }
        return gv;
    }

    public String[] getRawUniqueValues(short role) {
        StringVariable group = (StringVariable)this.connectCategory(role, true);
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    public String[] getUniqueCategoryValues(short role) {
        return this.getUniqueCategoryValues(role, true);
    }

    public String[] getUniqueCategoryValues(short role, boolean includeMissing) {
        StringVariable cat = (StringVariable)this.connectCategory(role, includeMissing);
        this.applyWhereClause(new Variable[]{cat});
        String[] uv = new String[cat.getUniqueValueCount()];
        for (int i = 0; i < uv.length; ++i) {
            try {
                uv[i] = cat.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return uv;
    }

    protected String[] getUniqueGroupValues(short role) {
        return this.getUniqueGroupValues(role, 0);
    }

    protected String[] getUniqueGroupValues(short role, int sort) {
        if (StatGraph.isOLAP()) {
            StringVariable olv = StatGraph.getOLAPLevelVar(this.model, role);
            String[] gv = new String[olv.getUniqueValueCount()];
            for (int i = 0; i < gv.length; ++i) {
                try {
                    gv[i] = olv.uniqueValue.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    gv[i] = "";
                }
            }
            return gv;
        }
        boolean numericGroup = this.model.getColumnClass(role) == Double.class;
        Variable group = this.connectRaw(role);
        if (sort != 0) {
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable(group);
            StringVectorVariable formatedGroup = (StringVectorVariable)this.connectCategory(role, true);
            vp.addVariable((Variable)formatedGroup);
            if (numericGroup) {
                vp.setSort(group, sort);
            } else {
                vp.setSort((Variable)formatedGroup, sort);
            }
        }
        SASFormat format = this.getFormat(role);
        if (!this.missingGroupOn && format != null && ((ColumnMetadata)this.model.getColumnLabel(role)).getMissings() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            for (int n = 0; n < group.getValueCount(); ++n) {
                try {
                    String str = null;
                    if (group instanceof NumericVariable) {
                        double d = ((NumericVariable)group).value.getValue(n);
                        str = format.format((Object)new Double(d)).trim();
                    } else if (group instanceof StringVariable) {
                        String s = ((StringVariable)group).value.getValue(n);
                        str = format.format((Object)s);
                    }
                    if (list.contains(str)) continue;
                    list.add(str);
                    continue;
                }
                catch (MissingValueException str) {
                    // empty catch block
                }
            }
            String[] gv = new String[list.size()];
            for (int i = 0; i < gv.length; ++i) {
                gv[i] = this.groupOrder == 3 ? (String)list.get(gv.length - 1 - i) : (String)list.get(i);
            }
            return gv;
        }
        String[] gv = new String[group.getUniqueValueCount()];
        int idx = 0;
        boolean missing = false;
        String dm = numericGroup ? StatGraph.missingOption : StatGraph.missingCharacter;
        for (int i = 0; i < gv.length; ++i) {
            try {
                String s;
                if (group instanceof NumericVariable) {
                    double d;
                    double d2 = d = this.groupOrder == 3 ? ((NumericVariable)group).uniqueValue.getValue(gv.length - 1 - i) : ((NumericVariable)group).uniqueValue.getValue(i);
                    if (format == null) {
                        gv[idx++] = DataModel.formatNumber(d);
                        continue;
                    }
                    gv[idx++] = format.format((Object)new Double(d)).trim();
                    continue;
                }
                if (!(group instanceof StringVariable)) continue;
                String string = s = this.groupOrder == 3 ? ((StringVariable)group).uniqueValue.getValue(gv.length - 1 - i) : ((StringVariable)group).uniqueValue.getValue(i);
                if (format == null) {
                    gv[idx++] = s;
                    continue;
                }
                gv[idx++] = format.format((Object)s);
                continue;
            }
            catch (MissingValueException mve) {
                if (this.missingGroupOn) {
                    String m;
                    if (format == null) {
                        gv[idx++] = dm;
                        continue;
                    }
                    String string = m = numericGroup ? format.format((Object)new Double(Double.NaN)).trim() : format.format((Object)" ").trim();
                    if (m == null || m.equals(dm)) {
                        gv[idx++] = dm;
                        continue;
                    }
                    gv[idx++] = m;
                    continue;
                }
                missing = true;
            }
        }
        if (missing) {
            String[] gv2 = new String[gv.length - 1];
            for (int i = 0; i < gv2.length; ++i) {
                gv2[i] = gv[i];
            }
            gv = gv2;
        }
        return gv;
    }

    protected void applyWhereClause(Variable[] primaryVars) {
        if (this.whereRoles != null && primaryVars != null) {
            VariableProcessor vp = new VariableProcessor();
            for (int i = 0; i < primaryVars.length; ++i) {
                vp.addVariable(primaryVars[i]);
            }
            String whereExpression = "^(";
            for (int i = 0; i < this.whereRoles.length; ++i) {
                Variable var = this.connectRaw((short)this.whereRoles[i]);
                vp.addVariable(var);
                whereExpression = whereExpression + var.getName();
            }
            whereExpression = whereExpression + " IS MISSING)";
            vp.setWhereExpression(whereExpression);
        }
    }

    public boolean isMissingGroupOn() {
        return this.missingGroupOn;
    }

    public void setMissingGroupOn(boolean b) {
        this.missingGroupOn = b;
    }

    public boolean isDiscreteX() {
        return this.discreteX;
    }

    public void setDiscreteX(boolean b) {
        this.discreteX = b;
    }

    public boolean isDiscreteY() {
        return this.discreteY;
    }

    public void setDiscreteY(boolean b) {
        this.discreteY = b;
    }

    protected String getLabel(short role) {
        ColumnMetadata cmd;
        String l;
        CRD crd = this.model;
        Object o = crd.getColumnLabel(role);
        if (o instanceof ColumnMetadata && (l = (cmd = (ColumnMetadata)o).getLabel()) != null) {
            return l;
        }
        return o.toString();
    }

    protected void setFormat(DataRange range, int column) {
        if (range != null) {
            SASFormat fmt = null;
            if (StatGraph.isOLAP()) {
                String fmtName = StatGraph.getOLAPFormat(this.model, (short)column);
                if (fmtName != null) {
                    fmt = SASFormat.getInstance((String)fmtName);
                }
            } else {
                Object obj = null;
                obj = this.model.getColumnLabel(column);
                if (obj instanceof ColumnMetadata) {
                    ColumnMetadata cmd = (ColumnMetadata)obj;
                    fmt = cmd.getFormat();
                }
            }
            if (fmt != null) {
                if (!this.nonFormatRoles.contains(new Integer(column))) {
                    range.setFormat(fmt);
                } else if (range instanceof DiscreteRange || range instanceof OrdinalRange) {
                    range.setColumnFormat(fmt);
                }
            }
        }
    }

    protected SASFormat getFormat(int column) {
        SASFormat fmt = null;
        if (StatGraph.isOLAP()) {
            String fmtName = StatGraph.getOLAPFormat(this.model, (short)column);
            if (fmtName != null) {
                fmt = SASFormat.getInstance((String)fmtName);
            }
        } else {
            Object obj = this.model.getColumnLabel(column);
            if (obj instanceof ColumnMetadata) {
                ColumnMetadata cmd = (ColumnMetadata)obj;
                fmt = cmd.getFormat();
            }
        }
        return fmt;
    }

    protected void fireRangeEvent(byte dim, DataRange oldRange, DataRange newRange) {
        if (this.rcList.count() == 0) {
            return;
        }
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != null && !oldRange.equals((Object)newRange)) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected Variable connectCategory(short role, boolean includeMissing) {
        boolean numeric;
        if (!this.model.isAvailable(role)) {
            return null;
        }
        if (StatGraph.isOLAP()) {
            return StatGraph.getOLAPLevelVar(this.model, role);
        }
        StringVectorVariable outVar = new StringVectorVariable();
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(role);
        boolean bl = numeric = this.model.getColumnClass(role) == Double.class;
        if (numeric) {
            outVar.connectFrom(this.model.getDoubleAsClassColumn(role, includeMissing));
        } else {
            outVar.connectFrom(this.model.getStringAsClassColumn(role, includeMissing));
        }
        outVar.setBlankMissing(false);
        if (!this.nonFormatRoles.contains(new Integer(role))) {
            this.nonFormatRoles.add(new Integer(role));
        }
        outVar.setLabel(this.getLabel(role));
        return outVar;
    }

    protected Variable connectRaw(short role) {
        NumericVectorVariable outVar;
        boolean numeric;
        if (!this.model.isAvailable(role)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(role);
        boolean bl = numeric = this.model.getColumnClass(role) == Double.class;
        if (numeric) {
            outVar = new NumericVectorVariable();
            outVar.connectFrom(this.model.getDoubleColumn(role));
        } else {
            outVar = new StringVectorVariable();
            ((StringVectorVariable)outVar).connectFrom(this.model.getStringColumn(role));
        }
        if (cmd.getFormat() != null) {
            outVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
        } else if (outVar instanceof NumericVariable) {
            outVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        outVar.setLabel(this.getLabel(role));
        return outVar;
    }

    ContinuousRange makeContinuousRange(NumericVariable numVar) {
        double min = numVar.getMin();
        double max = numVar.getMax();
        return new ContinuousRange(min, max);
    }

    ContinuousRange makeContinuousRange(NumericVariable numVar, short role, boolean subset) {
        double max;
        double min;
        if (subset && this.model.whereExpression != null) {
            min = numVar.getMin();
            max = numVar.getMax();
        } else if (StatGraph.isOLAP()) {
            min = numVar.getMin();
            max = numVar.getMax();
        } else {
            min = this.model.getColumnMin(role);
            max = this.model.getColumnMax(role);
        }
        return new ContinuousRange(min, max);
    }

    static DiscreteRange makeDiscreteRange(StringVariable strVar, int num) {
        Object[] vals = new Object[num];
        for (int i = 0; i < num; ++i) {
            try {
                vals[i] = strVar.uniqueValue.getValue(i);
                continue;
            }
            catch (Exception mve) {
                vals[i] = null;
            }
        }
        return new DiscreteRange(vals);
    }

    DiscreteRange makeDiscreteRange(StringVariable strVar, int num, short role, boolean subset) {
        if (subset) {
            return Overlay.makeDiscreteRange(strVar, num);
        }
        Object[] vals = this.getUniqueCategoryValues(role, this.missingCategoryOn);
        return new DiscreteRange(vals);
    }

    OrdinalRange makeOrdinalRange(StringVariable strVar, int num, NumericVariable rawVar) {
        rawVar.getUniqueValueCount();
        Object[] vals = new Object[num];
        Object[] dvals = new Double[num];
        String fmtMissing = null;
        for (int i = 0; i < num; ++i) {
            try {
                vals[i] = strVar.uniqueValue.getValue(i);
            }
            catch (Exception mve) {
                vals[i] = null;
            }
            try {
                dvals[i] = new Double(rawVar.uniqueValue.getValue(i));
                continue;
            }
            catch (Exception mve) {
                dvals[i] = null;
                fmtMissing = (String)vals[i];
            }
        }
        String miss = null;
        if (StatGraph.includeMissingDiscrete) {
            miss = fmtMissing != null && !fmtMissing.equals(".") ? fmtMissing : StatGraph.missingOption;
        }
        return new OrdinalRange(vals, dvals, miss);
    }

    OrdinalRange makeOrdinalRange(StringVariable strVar, int num, NumericVariable rawVar, short role, boolean subset) {
        if (subset) {
            return this.makeOrdinalRange(strVar, num, rawVar);
        }
        NumericVectorVariable numVar = (NumericVectorVariable)this.connectRaw(role);
        this.applyWhereClause(new Variable[]{numVar});
        num = numVar.getUniqueValueCount();
        Object[] vals = this.getUniqueCategoryValues(role);
        Object[] dvals = new Double[num];
        String fmtMissing = null;
        for (int i = 0; i < num; ++i) {
            try {
                dvals[i] = new Double(numVar.uniqueValue.getValue(i));
                continue;
            }
            catch (Exception mve) {
                dvals[i] = null;
                fmtMissing = vals[i];
            }
        }
        String miss = null;
        if (StatGraph.includeMissingDiscrete) {
            miss = fmtMissing != null && !fmtMissing.equals(".") ? fmtMissing : StatGraph.missingOption;
        }
        return new OrdinalRange(vals, dvals, miss);
    }

    double[] getSubsettedDoubleColumn(short role) {
        double[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            NumericVectorVariable var = (NumericVectorVariable)this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new double[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = Double.NaN;
                }
            }
        } else {
            colData = this.model.getDoubleColumn(role);
        }
        return colData;
    }

    String[] getSubsettedStringColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            StringVectorVariable var = (StringVectorVariable)this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = this.model.getStringColumn(role);
        }
        return colData;
    }

    String[] getSubsettedDoubleAsClassColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            StringVectorVariable var = (StringVectorVariable)this.connectCategory(role, true);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = var.value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = this.model.getDoubleAsClassColumn(role, true);
        }
        return colData;
    }

    String[] getSubsettedStringAsClassColumn(short role) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            Variable var = this.connectCategory(role, true);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    colData[i] = ((StringVariable)var).value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = StatGraph.missingCharacter;
                }
            }
        } else {
            colData = this.model.getStringAsClassColumn(role, true);
        }
        return colData;
    }

    String[] getSubsettedColumnAsClassColumn(short role, boolean numeric) {
        String[] colData = null;
        if (this.model.whereExpression != null || this.model.subsetObs != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            colData = new String[var.getValueCount()];
            for (int i = 0; i < colData.length; ++i) {
                try {
                    if (numeric) {
                        colData[i] = DataModel.formatNumber(((NumericVariable)var).value.getValue(i));
                        continue;
                    }
                    colData[i] = ((StringVariable)var).value.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    colData[i] = null;
                }
            }
        } else {
            colData = numeric ? this.model.getDoubleAsClassColumn(role) : this.model.getStringAsClassColumn(role);
        }
        return colData;
    }

    int getSubsettedValueCount(Variable variable, short role, boolean numeric) {
        if (this.model.whereExpression != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            return var.getValueCount();
        }
        return variable.getValueCount();
    }

    int getSubsettedUniqueValueCount(Variable variable, short role, boolean numeric) {
        if (this.model.whereExpression != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            return var.getUniqueValueCount();
        }
        return variable.getUniqueValueCount();
    }

    protected NumericPipe makeOffsetCalculator(double offsetValue, NumericPipe np) {
        if (offsetValue == 0.0) {
            return np;
        }
        Calculator offsetCalculator = new Calculator("inA+inB");
        offsetCalculator.inA.connectFrom(np);
        offsetCalculator.inB.setValue(offsetValue);
        return offsetCalculator;
    }

    public boolean isConnected() {
        return !this.needConnect;
    }

    public boolean isComputedOverlay() {
        return false;
    }

    protected Variable getSortedVariable(Variable v) {
        NumericVariable sortedV;
        if (v == null) {
            return null;
        }
        if (v instanceof NumericVariable) {
            sortedV = new NumericVariable();
            sortedV.connectFrom((NumericVariable)v);
        } else {
            sortedV = new StringVariable();
            ((StringVariable)sortedV).connectFrom((StringVariable)v);
        }
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)sortedV);
        vp.setSort((Variable)sortedV, 1);
        sortedV.getValueCount();
        return sortedV;
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout layout, int yOutputRange) {
    }

    @Override
    public void setPreferredCandidateList(PointLabelLayout layout, int yOutputRange) {
    }

    public void hideAllPointLabels() {
        if (this.plLayout != null) {
            this.plLayout.hideAll();
        }
    }

    public void showAllPointLabels() {
        if (this.plLayout != null) {
            this.plLayout.showAll();
        }
    }

    public void hidePointLabels(int[] indices) {
        if (this.plLayout != null) {
            this.plLayout.hide(indices);
        }
    }

    public int[] getInitialHideLabelObs() {
        return this.initialHideLabelObs;
    }

    public void setInitialHideLabelObs(int[] initialHideObs) {
        this.initialHideLabelObs = initialHideObs;
    }

    public String getStmt() {
        return this.stmt;
    }

    public void setStmt(String stmt) {
        this.stmt = stmt;
    }

    public Insets getInitialInnerMargin() {
        return new Insets(5, 0, 0, 5);
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public boolean hasLegend(int attrType) {
        return attrType == 0;
    }

    public LegendItem[] getLegendItems(int attrType) {
        String[] values;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if ((values = this.getGroupValues()) == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = this instanceof SpecLimitsOverlay ? ((SpecLimitsOverlay)this).getLegendLabels() : new String[]{this.getLegendLabel()};
        }
        Color[] fcolor = this.getFillColors();
        int[] fpattern = this.getFillPatterns();
        if (fcolor.length == 0 && fpattern.length == 0) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            int n = values.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, null, values[i], null) : new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType);
            }
            return entries;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        Color[] fpColor = this.getFillPatternColors();
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            if (fcolor.length > 0) {
                attr.setColor(fcolor[i % fcolor.length]);
            } else {
                attr.setColor(null);
            }
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = this.skinType == 0 || fcolor.length == 0 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, legendSkin, this.skinType, legendPixelBender);
            if (fpattern.length <= 0) continue;
            FillPatternAttrs attr3 = new FillPatternAttrs();
            attr3.setPattern(fpattern[i % fpattern.length]);
            if (fpColor.length > 0) {
                attr3.setColor(fpColor[i % fpColor.length]);
            }
            entries[i].setFillPatternAttrs(attr3);
        }
        return entries;
    }

    protected static int[] getAttrMapValueIndexInGroup(String[] attrMapValues, String[] groupValues) {
        int[] indices = new int[attrMapValues.length];
        for (int i = 0; i < attrMapValues.length; ++i) {
            String attrV = attrMapValues[i];
            boolean found = false;
            for (int j = 0; j < groupValues.length; ++j) {
                if (!attrV.equals(groupValues[j])) continue;
                indices[i] = j;
                found = true;
                break;
            }
            if (found) continue;
            indices[i] = -1;
        }
        return indices;
    }

    protected int[] margeAttrMapWithGroupAttrs(DiscreteAttrMapper attrMapper, String[] attrMapValues, int[] attrMapValueIndices, int[] groupAttrs, int type, int defaultValue) {
        if (groupAttrs == null || groupAttrs.length == 0) {
            return groupAttrs;
        }
        int[] newAttrs = new int[attrMapValues.length];
        for (int i = 0; i < newAttrs.length; ++i) {
            int attrV = -1;
            if (attrMapValueIndices[i] == -1) {
                switch (type) {
                    case 0: {
                        attrV = attrMapper.getMarkerSymbol(attrMapValues[i]);
                        break;
                    }
                    case 1: {
                        attrV = attrMapper.getMarkerSize(attrMapValues[i]);
                        break;
                    }
                    case 2: {
                        attrV = attrMapper.getMarkerWeight(attrMapValues[i]);
                        break;
                    }
                    case 4: {
                        attrV = attrMapper.getLineThickness(attrMapValues[i]);
                        break;
                    }
                    case 3: {
                        attrV = attrMapper.getLinePattern(attrMapValues[i]);
                        break;
                    }
                }
                if (attrV < 0) {
                    newAttrs[i] = defaultValue;
                    continue;
                }
                newAttrs[i] = attrV;
                continue;
            }
            newAttrs[i] = groupAttrs[attrMapValueIndices[i] % groupAttrs.length];
        }
        return newAttrs;
    }

    protected Color[] margeAttrMapWithGroupAttrs(DiscreteAttrMapper attrMapper, String[] attrMapValues, int[] attrMapValueIndices, Color[] groupAttrs, int type, Color defaultValue, double defaultTranspareny, boolean useDefaultTransparency) {
        if (groupAttrs == null || groupAttrs.length == 0) {
            return groupAttrs;
        }
        Color[] newAttrs = new Color[attrMapValueIndices.length];
        for (int i = 0; i < newAttrs.length; ++i) {
            if (attrMapValueIndices[i] == -1) {
                Color attrV = null;
                double attrTransparency = -1.0;
                switch (type) {
                    case 10: {
                        attrV = attrMapper.getMarkerColor(attrMapValues[i]);
                        attrTransparency = attrMapper.getMarkerTransparency(attrMapValues[i]);
                        break;
                    }
                    case 11: {
                        attrV = attrMapper.getLineColor(attrMapValues[i]);
                        break;
                    }
                    case 12: {
                        attrV = attrMapper.getFillColor(attrMapValues[i]);
                        attrTransparency = attrMapper.getFillTransparency(attrMapValues[i]);
                        break;
                    }
                    case 15: {
                        attrV = attrMapper.getFillColor(attrMapValues[i]);
                        attrTransparency = attrMapper.getMarkerTransparency(attrMapValues[i]);
                        break;
                    }
                    case 16: {
                        attrV = attrMapper.getLineColor(attrMapValues[i]);
                        attrTransparency = attrMapper.getMarkerTransparency(attrMapValues[i]);
                        break;
                    }
                    case 13: {
                        attrV = attrMapper.getTextColor(attrMapValues[i]);
                        break;
                    }
                    case 14: {
                        attrV = attrMapper.getLineColor(attrMapValues[i]);
                    }
                }
                if (attrV == null) {
                    attrV = defaultValue;
                }
                if (useDefaultTransparency) {
                    newAttrs[i] = this.applyDataTransparency(attrV, defaultTranspareny);
                    continue;
                }
                newAttrs[i] = this.applyDataTransparency(attrV, attrTransparency);
                continue;
            }
            newAttrs[i] = groupAttrs[attrMapValueIndices[i] % groupAttrs.length];
        }
        return newAttrs;
    }

    protected Color[] applyAttrMapTransparency(DiscreteAttrMapper attrMapper, String[] attrMapValues, Color[] colors, int type) {
        if (colors == null || colors.length == 0) {
            return colors;
        }
        Color[] newColors = new Color[attrMapValues.length];
        for (int i = 0; i < attrMapValues.length; ++i) {
            double attrTransparency = -1.0;
            Color c = colors[i % colors.length];
            switch (type) {
                case 10: {
                    attrTransparency = attrMapper.getMarkerTransparency(attrMapValues[i]);
                    break;
                }
                case 12: {
                    attrTransparency = attrMapper.getFillTransparency(attrMapValues[i]);
                }
            }
            newColors[i] = attrTransparency >= 0.0 ? this.applyDataTransparency(c, attrTransparency) : c;
        }
        return newColors;
    }

    public static LegendItem[] margeAttrMapWithPlotLegendItems(DiscreteAttrMapper attrMapper, LegendItem[] plotLegendItems, FillAttrs defaultFillAttr, LineAttrs defaultLineAttr, boolean useDefaultFillColor, boolean useDefaultFillTransparency, boolean useDefaultLineColor, boolean useDefaultLinePattern, boolean useDefaultLineThickness, double dataTransparency, boolean useDataTransparency) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        if (plotLegendItems == null || plotLegendItems.length == 0) {
            return plotLegendItems;
        }
        String[] values = new String[plotLegendItems.length];
        for (int i = 0; i < plotLegendItems.length; ++i) {
            values[i] = plotLegendItems[i].getLabel();
        }
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = Overlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        LegendItem[] newItems = new LegendItem[attrMapValueIndices.length];
        int type = plotLegendItems[0].getType();
        for (int i = 0; i < newItems.length; ++i) {
            if (attrMapValueIndices[i] == -1) {
                switch (type) {
                    case 3: {
                        int lt;
                        int lp;
                        Color lc;
                        double transparency;
                        Color fc;
                        Color color = fc = useDefaultFillColor ? defaultFillAttr.getColor() : attrMapper.getFillColor(attrMapValues[i]);
                        if (fc == null) {
                            fc = defaultFillAttr.getColor();
                        }
                        double d = transparency = useDefaultFillTransparency ? defaultFillAttr.getTransparency() : attrMapper.getFillTransparency(attrMapValues[i]);
                        if (transparency < 0.0) {
                            transparency = dataTransparency;
                        }
                        fc = Overlay.applyTransparency(fc, transparency);
                        FillAttrs attr = new FillAttrs();
                        attr.setColor(fc);
                        LineAttrs attr2 = null;
                        if (plotLegendItems[0].getSecondarySymbolAttrs() != null) {
                            Color color2 = lc = useDefaultLineColor ? defaultLineAttr.getColor() : attrMapper.getLineColor(attrMapValues[i]);
                            if (lc == null) {
                                lc = defaultLineAttr.getColor();
                            }
                            lc = useDataTransparency ? Overlay.applyTransparency(lc, dataTransparency) : Overlay.applyTransparency(lc, 0.0);
                            int n = lp = useDefaultLinePattern ? defaultLineAttr.getLinePattern() : attrMapper.getLinePattern(attrMapValues[i]);
                            if (lp < 0) {
                                lp = defaultLineAttr.getLinePattern();
                            }
                            int n2 = lt = useDefaultLineThickness ? defaultLineAttr.getWidth() : attrMapper.getLineThickness(attrMapValues[i]);
                            if (lt < 0) {
                                lt = defaultLineAttr.getWidth();
                            }
                            attr2 = new LineAttrs();
                            attr2.setColor(lc);
                            attr2.setLinePattern(lp);
                            attr2.setWidth(lt);
                        }
                        newItems[i] = plotLegendItems[0].getSkinType() == 0 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, plotLegendItems[0].getSkinImage(), plotLegendItems[0].getSkinType(), plotLegendItems[0].getPixelBenderImages());
                        newItems[i].setFillType(plotLegendItems[0].getFillType());
                        break;
                    }
                    case 2: {
                        int lt;
                        int lp;
                        Color lc;
                        Color color = lc = useDefaultLineColor ? defaultLineAttr.getColor() : attrMapper.getLineColor(attrMapValues[i]);
                        if (lc == null) {
                            lc = defaultLineAttr.getColor();
                        }
                        if (useDataTransparency) {
                            lc = Overlay.applyTransparency(lc, dataTransparency);
                        }
                        int n = lp = useDefaultLinePattern ? defaultLineAttr.getLinePattern() : attrMapper.getLinePattern(attrMapValues[i]);
                        if (lp < 0) {
                            lp = defaultLineAttr.getLinePattern();
                        }
                        int n3 = lt = useDefaultLineThickness ? defaultLineAttr.getWidth() : attrMapper.getLineThickness(attrMapValues[i]);
                        if (lt < 0) {
                            lt = defaultLineAttr.getWidth();
                        }
                        LineAttrs attr2 = new LineAttrs();
                        attr2.setColor(lc);
                        attr2.setLinePattern(lp);
                        attr2.setWidth(lt);
                        newItems[i] = plotLegendItems[0].getSkinType() == 0 ? new LegendItem((ColorAttr)attr2, null, attrMapValues[i], null) : new LegendItem((ColorAttr)attr2, null, attrMapValues[i], null, null, plotLegendItems[0].getSkinType());
                    }
                }
                continue;
            }
            newItems[i] = plotLegendItems[attrMapValueIndices[i]];
        }
        return newItems;
    }

    public LegendItem[] getLegendItemsWithAttrMap(int attrType) {
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
        return this.getLegendItemsWithAttrMap(attrMapper, attrType);
    }

    public LegendItem[] getLegendItemsWithAttrMap(String attrVarName, int attrType) {
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVarName);
        return this.getLegendItemsWithAttrMap(attrMapper, attrType);
    }

    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = Overlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        Color[] fcolor = this.getFillColors();
        if (this.isMargeAttrMapRequired(12)) {
            fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 12, this.getAttrMapDefaultFillAttrs().getColor(), this.getAttrMapDefaultFillAttrs().getTransparency(), this.useFillTransparency);
        }
        if (!this.useFillTransparency) {
            fcolor = this.applyAttrMapTransparency(attrMapper, attrMapValues, fcolor, 12);
        }
        Color[] lcolor = this.getLineColors();
        if (this.isMargeAttrMapRequired(11)) {
            lcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, lcolor, 11, this.getAttrMapDefaultLineAttrs().getColor(), this.dataTransparency, this.useDataTransparency);
        }
        int[] pattern = this.getLinePatterns();
        if (this.isMargeAttrMapRequired(3)) {
            pattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, pattern, 3, this.getAttrMapDefaultLineAttrs().getLinePattern());
        }
        int[] width = this.getLineWidths();
        if (this.isMargeAttrMapRequired(4)) {
            width = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, width, 4, this.getAttrMapDefaultLineAttrs().getWidth());
        }
        int[] fpattern = this.getFillPatterns();
        if (this.isMargeAttrMapRequired(5)) {
            fpattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpattern, 5, this.getAttrMapDefaultFillPatternAttrs().getPattern());
        }
        Color[] fpColor = this.getFillPatternColors();
        if (this.isMargeAttrMapRequired(14)) {
            fpColor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpColor, 14, this.getAttrMapDefaultFillPatternAttrs().getColor(), this.dataTransparency, this.useDataTransparency);
        }
        if (fcolor.length == 0 && fpattern.length == 0) {
            int n = attrMapValues.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = this.skinType == 0 ? new LegendItem((ColorAttr)attr, null, attrMapValues[i], null) : new LegendItem((ColorAttr)attr, null, attrMapValues[i], null, null, this.skinType);
            }
            return entries;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            if (fcolor.length > 0) {
                attr.setColor(fcolor[i % fcolor.length]);
            } else {
                attr.setColor(null);
            }
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = this.skinType == 0 || fcolor.length == 0 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, legendSkin, this.skinType, legendPixelBender);
            if (fpattern.length <= 0) continue;
            FillPatternAttrs attr3 = new FillPatternAttrs();
            attr3.setPattern(fpattern[i % fpattern.length]);
            if (fpColor.length > 0) {
                attr3.setColor(fpColor[i % fpColor.length]);
            }
            entries[i].setFillPatternAttrs(attr3);
        }
        return entries;
    }

    protected boolean isMargeAttrMapRequired(int type) {
        return false;
    }

    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return new FillAttrs();
    }

    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return new LineAttrs();
    }

    protected FillPatternAttrs getAttrMapDefaultFillPatternAttrs() {
        return new FillPatternAttrs();
    }

    public Range[] getColorModelRanges(int type) {
        return null;
    }

    public SASFormat getContinuousLegendFormat() {
        return null;
    }

    public boolean hasMissingValue() {
        return false;
    }

    public Color getMissingColor() {
        return null;
    }

    public double getMaximumIntervalSize(double minInterval, PositionEncoder encoder, boolean estimate) {
        if (encoder instanceof BrokenPositionEncoder) {
            return this.getMaximumIntervalSize(minInterval, (BrokenPositionEncoder)encoder, estimate);
        }
        ValueMap vmap = encoder.getValueMap();
        if (vmap == null || !(vmap instanceof ContinuousRangeToNumericMap)) {
            return 0.0;
        }
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)vmap;
        boolean oneValue = map.getInputMax() == map.getInputMin();
        double size = estimate || oneValue ? minInterval * (encoder.getUpperLimit() - encoder.getLowerLimit()) / (Math.abs(map.getInputMax() - map.getInputMin()) + minInterval) : minInterval * (map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin());
        return Math.abs(size);
    }

    private double getMaximumIntervalSize(double minInterval, BrokenPositionEncoder encoder, boolean estimate) {
        double size;
        boolean oneValue;
        ContinuousRangeToNumericMap map = encoder.getRangeOutputMaps()[0];
        if (map == null) {
            return 0.0;
        }
        boolean bl = oneValue = map.getInputMax() == map.getInputMin();
        if (estimate || oneValue) {
            ContinuousRange[] ir = encoder.getInputRanges();
            double total = 0.0;
            for (int i = 0; i < ir.length; ++i) {
                total += ir[i].getMax() - ir[i].getMin();
            }
            double gap = ((double)BrokenPositionEncoder.BROKEN_GAP + 2.0 * BrokenPositionEncoder.RESERVED_OFFSET) * (double)(ir.length - 1);
            size = minInterval * (encoder.getUpperLimit() - encoder.getLowerLimit() - gap) / (total + minInterval);
        } else {
            size = minInterval * (map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin());
        }
        return Math.abs(size);
    }

    public double getMinimumInterval(short role) {
        NumericVectorVariable var = (NumericVectorVariable)this.connectRaw(role);
        if (var == null) {
            return 0.0;
        }
        return this.getMinimumInterval((NumericVariable)var);
    }

    public double getMinimumInterval(NumericVariable var) {
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)var);
        vp.setSort((Variable)var, 1);
        int n = var.getValueCount();
        if (n <= 1) {
            return 0.0;
        }
        double interval = Double.MAX_VALUE;
        boolean firstValue = false;
        double v1 = Double.NaN;
        for (int i = 0; i < n; ++i) {
            try {
                if (!firstValue) {
                    v1 = var.value.getValue(i);
                    firstValue = true;
                    continue;
                }
                double v2 = var.value.getValue(i);
                double delta = v2 - v1;
                if (delta == 0.0) continue;
                if (delta < interval) {
                    interval = delta;
                }
                v1 = v2;
                continue;
            }
            catch (MissingValueException e) {
                // empty catch block
            }
        }
        if (interval < Double.MAX_VALUE) {
            return interval;
        }
        return 0.0;
    }

    public void setTopReservedSpace(int s) {
        this.topReservedSpace = s;
    }

    public void setBottomReservedSpace(int s) {
        this.bottomReservedSpace = s;
    }

    public void setLeftReservedSpace(int s) {
        this.leftReservedSpace = s;
    }

    public void setRightReservedSpace(int s) {
        this.rightReservedSpace = s;
    }

    public boolean isDependent() {
        return this.isComputedOverlay() || this instanceof BlockOverlay || this instanceof CarpetOverlay || this instanceof RangeAttrMapViewOverlay || this instanceof AxisTable;
    }

    public static String getTopLevelValue(String str) {
        int idx = str.indexOf(",");
        if (idx > 0) {
            str = str.substring(0, idx);
        }
        return str;
    }

    public String[] getLabels(byte dim) {
        DataRange dr = this.getDataRange(dim);
        if (dr != null) {
            return new String[]{dr.getLabel()};
        }
        return null;
    }

    protected Probe rearrangeProbePipes(int[] lookup) {
        if (this.probe == null) {
            return null;
        }
        int ntips = this.probe.getProbeEntryCount();
        Probe newProbe = new Probe();
        for (int t = 0; t < ntips; ++t) {
            StringVector sv;
            int i;
            Probe.ProbeEntry pe = this.probe.getProbeEntry(t);
            String name = pe.getName();
            Pipe p = pe.getPipe();
            p.init(new AInitAction(null));
            Formatter fmt = p.getFormatter();
            if (fmt == null) {
                if (p instanceof NumericPipe) {
                    NumericVector nv = new NumericVector();
                    for (i = 0; i < lookup.length; ++i) {
                        try {
                            nv.addValue(((NumericPipe)p).getValue(lookup[i]));
                            continue;
                        }
                        catch (MissingValueException e) {
                            nv.addValue(Double.NaN);
                        }
                    }
                    newProbe.addPipe(name, (Pipe)nv);
                    continue;
                }
                sv = new StringVector();
                for (i = 0; i < lookup.length; ++i) {
                    try {
                        sv.addValue(((StringPipe)p).getValue(lookup[i]));
                        continue;
                    }
                    catch (MissingValueException e) {
                        sv.addValue("");
                    }
                }
                newProbe.addPipe(name, (Pipe)sv);
                continue;
            }
            sv = new StringVector();
            for (i = 0; i < lookup.length; ++i) {
                try {
                    Object obj = p instanceof NumericPipe ? new Double(((NumericPipe)p).getValue(lookup[i])) : ((StringPipe)p).getValue(lookup[i]);
                    sv.addValue(fmt.format(obj));
                    continue;
                }
                catch (MissingValueException e) {
                    sv.addValue(fmt.format((Object)e.getMissingValue()));
                }
            }
            newProbe.addPipe(name, (Pipe)sv);
        }
        return newProbe;
    }

    public String[] getRangeLabels(RangeColorMapper rcm, short role) {
        NumericVariable sv = (NumericVariable)this.connectRaw(role);
        int obs = sv.getValueCount();
        String[] rLabels = new String[obs];
        SASFormat fmt = this.model.getColumnFormat(role);
        if (fmt == null) {
            fmt = DataModel.defaultFormat;
        }
        for (int i = 0; i < obs; ++i) {
            try {
                rLabels[i] = rcm.getRangeLabel(sv.value.getValue(i));
                continue;
            }
            catch (MissingValueException mve) {
                rLabels[i] = rcm.getRangeLabel(Double.NaN);
            }
        }
        return rLabels;
    }

    public StringVectorVariable getRangeLabelVariable(RangeColorMapper rcm, short role) {
        StringVectorVariable svv = new StringVectorVariable();
        svv.connectFrom(this.getRangeLabels(rcm, role));
        return svv;
    }

    protected Image loadLegendSkinImage() {
        return null;
    }

    protected Image[] loadLegendPixelBenderImages() {
        return null;
    }

    protected Image getLegendSkinImage(NetworkRoot networkRoot, int type) {
        switch (this.skinType) {
            default: {
                return null;
            }
            case 3: 
        }
        URL url = StatGraph.class.getResource("sgchart/res/Legend.png");
        Channel channel = networkRoot.getChannel();
        Component c = channel.getComponent();
        if (c == null) {
            return Toolkit.getDefaultToolkit().getImage(url);
        }
        MediaTracker tracker = new MediaTracker(c);
        Image img = null;
        try {
            img = Toolkit.getDefaultToolkit().getImage(url);
            tracker.addImage(img, 0);
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    protected Image getRectangularSkinImage(NetworkRoot networkRoot, int type, boolean vertical) {
        URL url;
        switch (this.skinType) {
            default: {
                return null;
            }
            case 6: {
                if (vertical) {
                    url = StatGraph.class.getResource("sgchart/res/VerticalBar_Gloss.png");
                    break;
                }
                url = StatGraph.class.getResource("sgchart/res/HorizontalBar_Gloss.png");
                break;
            }
            case 3: {
                if (vertical) {
                    url = StatGraph.class.getResource("sgchart/res/VerticalBar_Pressed.png");
                    break;
                }
                url = StatGraph.class.getResource("sgchart/res/HorizontalBar_Pressed.png");
                break;
            }
            case 1: {
                if (vertical) {
                    url = StatGraph.class.getResource("sgchart/res/VBarEffects_modern.png");
                    break;
                }
                url = StatGraph.class.getResource("sgchart/res/HBarEffects_Modern.png");
                break;
            }
            case 2: {
                url = vertical ? StatGraph.class.getResource("sgchart/res/VBarEffects_Satin.png") : StatGraph.class.getResource("sgchart/res/HBarEffects_Satin.png");
            }
        }
        Channel channel = networkRoot.getChannel();
        Component c = channel.getComponent();
        if (c == null) {
            return Toolkit.getDefaultToolkit().getImage(url);
        }
        MediaTracker tracker = new MediaTracker(c);
        Image img = null;
        try {
            img = Toolkit.getDefaultToolkit().getImage(url);
            tracker.addImage(img, 0);
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    protected Image[] loadPixelBenderImages(NetworkRoot networkRoot, int type, int skinCategory) {
        if (this.dataTransparency == 1.0) {
            return null;
        }
        Image[] blendingImages = null;
        switch (this.skinType) {
            default: {
                return null;
            }
            case 4: 
        }
        URL[] url = new URL[2];
        blendingImages = new Image[2];
        if (skinCategory == 1) {
            url[0] = StatGraph.class.getResource("sgchart/res/BarV_Darken.png");
            url[1] = StatGraph.class.getResource("sgchart/res/BarV_Brighten.png");
        } else if (skinCategory == 2) {
            url[0] = StatGraph.class.getResource("sgchart/res/BarH_Darken.png");
            url[1] = StatGraph.class.getResource("sgchart/res/BarH_Brighten.png");
        } else if (skinCategory == 4) {
            url[0] = StatGraph.class.getResource("sgchart/res/Marker_Darken.png");
            url[1] = StatGraph.class.getResource("sgchart/res/Marker_Brighten.png");
        } else if (skinCategory == 5) {
            url[0] = StatGraph.class.getResource("sgchart/res/Bubble_Darken.png");
            url[1] = StatGraph.class.getResource("sgchart/res/Bubble_Brighten.png");
        }
        Channel channel = networkRoot.getChannel();
        Component c = channel.getComponent();
        if (c == null) {
            for (int i = 0; i < url.length; ++i) {
                blendingImages[i] = Toolkit.getDefaultToolkit().getImage(url[i]);
            }
            return blendingImages;
        }
        MediaTracker tracker = new MediaTracker(c);
        try {
            for (int i = 0; i < url.length; ++i) {
                blendingImages[i] = Toolkit.getDefaultToolkit().getImage(url[i]);
                tracker.addImage(blendingImages[i], 0);
            }
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blendingImages;
    }

    protected Image[] loadLegendPixelBenderImages(NetworkRoot networkRoot, int type, int skinCategory) {
        return this.loadPixelBenderImages(networkRoot, type, 4);
    }

    static SASFormat getFormatWithMaxWidth(SASFormat fmt) {
        SASFormat newFormat = fmt;
        if (fmt != null && fmt.getFormatDescription().isDecimalWidthSupported()) {
            int w = fmt.getFormatDescription().getMaxWidth();
            int d = fmt.getDecimalWidth();
            newFormat = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
            newFormat.setInsertBlanks(false);
        }
        return newFormat;
    }

    protected IntegerPipe makeCurveLabelHJustification(IntegerPipe justPipe) {
        if (!this.curveLabelSplit || this.curveLabelSplitJustify == SPLIT_JUSTIFY_AUTO) {
            return justPipe;
        }
        IntegerProperty just = new IntegerProperty();
        if (this.curveLabelSplitJustify == SPLIT_JUSTIFY_LEFT) {
            just.setValue(0);
        } else if (this.curveLabelSplitJustify == SPLIT_JUSTIFY_RIGHT) {
            just.setValue(2);
        } else {
            just.setValue(1);
        }
        return just;
    }

    protected NumericPipe makeCurveLabelXOffset(NumericPipe xPipe, IntegerPipe justPipe, int length) {
        if (!this.curveLabelSplit || this.curveLabelSplitJustify == SPLIT_JUSTIFY_AUTO) {
            return xPipe;
        }
        return this.makeSplitLabelXOffset(xPipe, justPipe, (NumericPipe)this.splitCurveLabelWidth, length, this.curveLabelSplitJustify);
    }

    protected int makeSplitLabelHJustification(int just, int multiLineJustify) {
        if (multiLineJustify == SPLIT_JUSTIFY_AUTO) {
            return just;
        }
        return this.splitJustifyToGTKJustify(multiLineJustify);
    }

    protected double makeSplitLabelXOffset(double x, String label, int just, int multiLineJustify, FontMetrics fm) {
        double w = Overlay.getTextWidth(fm, label);
        double x2 = x;
        if (just == 2) {
            if (multiLineJustify == SPLIT_JUSTIFY_LEFT) {
                x2 = x - w;
            } else if (multiLineJustify == SPLIT_JUSTIFY_CENTER) {
                x2 = x - w * 0.5;
            }
        } else if (just == 0) {
            if (multiLineJustify == SPLIT_JUSTIFY_RIGHT) {
                x2 = x + w;
            } else if (multiLineJustify == SPLIT_JUSTIFY_CENTER) {
                x2 = x + w * 0.5;
            }
        } else if (just == 1) {
            if (multiLineJustify == SPLIT_JUSTIFY_RIGHT) {
                x2 = x + w * 0.5;
            } else if (multiLineJustify == SPLIT_JUSTIFY_LEFT) {
                x2 = x - w * 0.5;
            }
        }
        return x2;
    }

    protected NumericPipe makeSplitLabelXOffset(NumericPipe xPipe, IntegerPipe justPipe, NumericPipe widthPipe, int length, int multiLineJustify) {
        xPipe.init(new AInitAction(null));
        justPipe.init(new AInitAction(null));
        widthPipe.init(new AInitAction(null));
        NumericVector offset = new NumericVector();
        for (int i = 0; i < length; ++i) {
            try {
                double x = xPipe.getValue(i);
                int just = justPipe.getValue(i);
                double x2 = x;
                if (just == 2) {
                    if (multiLineJustify == SPLIT_JUSTIFY_LEFT) {
                        x2 = x - widthPipe.getValue(i);
                    } else if (multiLineJustify == SPLIT_JUSTIFY_CENTER) {
                        x2 = x - widthPipe.getValue(i) * 0.5;
                    }
                } else if (just == 0) {
                    if (multiLineJustify == SPLIT_JUSTIFY_RIGHT) {
                        x2 = x + widthPipe.getValue(i);
                    } else if (multiLineJustify == SPLIT_JUSTIFY_CENTER) {
                        x2 = x + widthPipe.getValue(i) * 0.5;
                    }
                } else if (just == 1) {
                    if (multiLineJustify == SPLIT_JUSTIFY_RIGHT) {
                        x2 = x + widthPipe.getValue(i) * 0.5;
                    } else if (multiLineJustify == SPLIT_JUSTIFY_LEFT) {
                        x2 = x - widthPipe.getValue(i) * 0.5;
                    }
                }
                offset.addValue(x2);
                continue;
            }
            catch (MissingValueException e) {
                offset.addValue(Double.NaN);
            }
        }
        return offset;
    }

    protected int splitJustifyToGTKJustify(int splitJustify) {
        if (splitJustify == SPLIT_JUSTIFY_LEFT) {
            return 0;
        }
        if (splitJustify == SPLIT_JUSTIFY_RIGHT) {
            return 2;
        }
        if (splitJustify == SPLIT_JUSTIFY_CENTER) {
            return 1;
        }
        return 1;
    }

    protected StringVariable splitCurveLabelVariable(Variable curveLabelVar, FontMetrics fm, boolean spaceAtEnds) {
        int n = curveLabelVar.getValueCount();
        Object[] cLabels = new String[n];
        for (int i = 0; i < n; ++i) {
            try {
                if (curveLabelVar instanceof StringVectorVariable) {
                    cLabels[i] = ((StringVectorVariable)curveLabelVar).formattedValue.getValue(i);
                    continue;
                }
                cLabels[i] = ((NumericVectorVariable)curveLabelVar).formattedValue.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                cLabels[i] = null;
            }
        }
        cLabels = this.splitCurveLabels(cLabels, fm, spaceAtEnds);
        StringVectorVariable sv = new StringVectorVariable();
        sv.connectFrom((String[])cLabels);
        return sv;
    }

    protected String[] splitCurveLabels(Object[] labels, FontMetrics fm, boolean spaceAtEnds) {
        if (labels == null) {
            return null;
        }
        String[] splitLabs = new String[labels.length];
        this.splitCurveLabelWidth = new NumericVector();
        this.splitCurveLabelHeight = new NumericVector();
        boolean splitAlways = true;
        double splitWidth = -1.0;
        for (int i = 0; i < labels.length; ++i) {
            String[] labs;
            if (labels[i] == null) {
                this.splitCurveLabelWidth.addValue(0.0);
                this.splitCurveLabelHeight.addValue(0.0);
                splitLabs[i] = null;
                continue;
            }
            String s = labels[i].toString().trim();
            double w = fm.stringWidth(s);
            double h = fm.getHeight();
            if (!(s.length() < 2 || !splitAlways && !(w > splitWidth) || (labs = Overlay.splitLabel(s, splitAlways, splitWidth, this.curveLabelSplitCharDrop, this.curveLabelSplitChar, fm)).length < 2 && labs[0].equals(s))) {
                s = labs[0];
                if (spaceAtEnds) {
                    s = " " + s + " ";
                }
                w = fm.stringWidth(s);
                for (int j = 1; j < labs.length; ++j) {
                    String s2 = labs[j];
                    if (spaceAtEnds) {
                        s2 = " " + s2 + " ";
                    }
                    w = Math.max(w, (double)fm.stringWidth(s2));
                    s = s + '\n';
                    s = s + s2;
                }
                h *= (double)labs.length;
            }
            this.splitCurveLabelWidth.addValue(w);
            this.splitCurveLabelHeight.addValue(h);
            splitLabs[i] = s;
        }
        return splitLabs;
    }

    public static String makeMultiLineLabel(String[] labs, boolean spaceAtEnds) {
        if (labs == null || labs.length < 1) {
            return null;
        }
        String s = labs[0];
        if (spaceAtEnds && s.length() > 0) {
            s = " " + s + " ";
        }
        for (int j = 1; j < labs.length; ++j) {
            s = s + '\n';
            String s2 = labs[j];
            if (spaceAtEnds && s2.length() > 0) {
                s2 = " " + s2 + " ";
            }
            s = s + s2;
        }
        return s;
    }

    public static String[] splitLabel2(String theLabel, boolean splitAlways, double splitWidth, boolean splitCharDrop, char[] splitChars, FontMetrics fm) {
        if (theLabel == null) {
            return null;
        }
        if (theLabel.length() < 2) {
            return new String[]{theLabel};
        }
        ArrayList<String> split = new ArrayList<String>();
        boolean delimiterPrev = false;
        String str = "";
        String lastWord = "";
        String lastDelimiter = "";
        for (int i = 0; i < theLabel.length(); ++i) {
            char c = theLabel.charAt(i);
            if (Overlay.isDelimiter(c, splitChars)) {
                if (!delimiterPrev) {
                    if (splitAlways) {
                        if (lastWord.length() > 0) {
                            split.add(lastWord);
                        }
                        str = "";
                    }
                    lastWord = "";
                    lastDelimiter = "";
                }
                str = str + c;
                lastDelimiter = lastDelimiter + c;
                delimiterPrev = true;
                continue;
            }
            if (!Double.isNaN(splitWidth)) {
                StringBuilder stringBuilder = new StringBuilder();
                if ((double)fm.stringWidth(stringBuilder.append(str).append(c).toString()) > splitWidth) {
                    if (delimiterPrev && splitAlways) {
                        if (!splitCharDrop && lastDelimiter.length() > 0) {
                            split.add(lastDelimiter);
                        }
                        str = Character.toString(c);
                        lastWord = Character.toString(c);
                        lastDelimiter = "";
                    } else {
                        int l = lastDelimiter.length() + lastWord.length();
                        String line = str.substring(0, str.length() - l);
                        if (line.length() > 0) {
                            split.add(line);
                        }
                        str = "";
                        if (!splitCharDrop) {
                            str = str + lastDelimiter;
                        }
                        str = str + lastWord;
                        str = str + c;
                        lastWord = lastWord + c;
                        if (splitCharDrop) {
                            lastDelimiter = "";
                        }
                    }
                    delimiterPrev = false;
                    continue;
                }
            }
            if (delimiterPrev && splitAlways) {
                if (!splitCharDrop && lastDelimiter.length() > 0) {
                    split.add(lastDelimiter);
                }
                str = Character.toString(c);
                lastWord = Character.toString(c);
                lastDelimiter = "";
            } else {
                str = str + c;
                lastWord = lastWord + c;
            }
            delimiterPrev = false;
        }
        if (str.length() > 0) {
            if (delimiterPrev && splitAlways) {
                if (!splitCharDrop && lastDelimiter.length() > 0) {
                    split.add(lastDelimiter);
                }
            } else {
                split.add(str);
            }
        }
        String[] labs = new String[split.size()];
        for (int i = 0; i < split.size(); ++i) {
            labs[i] = (String)split.get(i);
        }
        return labs;
    }

    public static String[] splitLabel(String theLabel, boolean splitAlways, double splitWidth, boolean splitCharDrop, char[] splitChars, FontMetrics fm) {
        return Overlay.splitLabel(theLabel, splitAlways, splitWidth, 0, splitCharDrop, splitChars, fm);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] splitLabel(String theLabel, boolean splitAlways, double splitWidth, int numSplitChars, boolean splitCharDrop, char[] splitChars, FontMetrics fm) {
        if (theLabel == null) {
            return null;
        }
        if (theLabel.length() < 2) {
            return new String[]{theLabel};
        }
        ArrayList<String> split = new ArrayList<String>();
        boolean delimiterPrev = false;
        String str = "";
        String currWord = "";
        String currDelimiter = "";
        String lastWord = "";
        for (int i = 0; i < theLabel.length(); ++i) {
            String line;
            int l;
            char c;
            block21: {
                block23: {
                    block22: {
                        c = theLabel.charAt(i);
                        if (!splitAlways && numSplitChars > 0) {
                            if (i > 0 && i % numSplitChars == 0) {
                                split.add(str);
                                str = "" + c;
                                continue;
                            }
                            str = str + c;
                            continue;
                        }
                        if (!Overlay.isDelimiter(c, splitChars)) break block21;
                        if (splitAlways || splitCharDrop || lastWord.length() <= 0 || Double.isNaN(splitWidth)) break block22;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (!((double)fm.stringWidth(stringBuilder.append(str).append(c).toString()) > splitWidth)) break block22;
                        l = delimiterPrev ? currDelimiter.length() + lastWord.length() : currWord.length();
                        line = str.substring(0, str.length() - l);
                        if (line.length() > 0) {
                            split.add(line);
                            str = str.substring(line.length());
                            if (!delimiterPrev) {
                                lastWord = currWord;
                                currWord = "";
                                currDelimiter = "";
                            }
                        }
                        break block23;
                    }
                    if (!delimiterPrev) {
                        lastWord = currWord;
                        currWord = "";
                        currDelimiter = "";
                    }
                }
                str = str + c;
                currDelimiter = currDelimiter + c;
                delimiterPrev = true;
                continue;
            }
            if (delimiterPrev && splitAlways) {
                String line2 = lastWord;
                if (!splitCharDrop && currDelimiter.length() > 0) {
                    line2 = line2 + currDelimiter;
                }
                if (line2.length() > 0) {
                    split.add(line2);
                }
                str = Character.toString(c);
                currWord = Character.toString(c);
                currDelimiter = "";
                delimiterPrev = false;
                continue;
            }
            if (!Double.isNaN(splitWidth)) {
                StringBuilder stringBuilder = new StringBuilder();
                if ((double)fm.stringWidth(stringBuilder.append(str).append(c).toString()) > splitWidth) {
                    l = splitCharDrop ? currDelimiter.length() + currWord.length() : currWord.length();
                    line = str.substring(0, str.length() - l);
                    if (line.length() > 0) {
                        split.add(line);
                    }
                    str = currWord + c;
                    currWord = currWord + c;
                    currDelimiter = "";
                    lastWord = "";
                    delimiterPrev = false;
                    continue;
                }
            }
            str = str + c;
            currWord = currWord + c;
            delimiterPrev = false;
        }
        if (str.length() > 0) {
            if (splitAlways && delimiterPrev && splitCharDrop) {
                if ((str = str.substring(0, str.length() - currDelimiter.length())).length() > 0) {
                    split.add(str);
                }
            } else {
                split.add(str);
            }
        }
        if (split.size() == 0) {
            return new String[]{""};
        }
        String[] labs = new String[split.size()];
        int i = 0;
        while (i < split.size()) {
            labs[i] = (String)split.get(i);
            ++i;
        }
        return labs;
    }

    public static boolean isDelimiter(char c, char[] splitChars) {
        if (splitChars == null) {
            return false;
        }
        for (int i = 0; i < splitChars.length; ++i) {
            if (c != splitChars[i]) continue;
            return true;
        }
        return false;
    }

    public static int getTextWidth(FontMetrics fm, String text) {
        if (fm == null) {
            return 0;
        }
        int newline = 10;
        if (text != null && text.length() > 0) {
            if (text.indexOf(newline) > 0) {
                int nlIndex = 0;
                int maxWidth = 0;
                int i = 0;
                while (nlIndex >= 0) {
                    nlIndex = text.indexOf(newline, i);
                    String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                    maxWidth = Math.max(maxWidth, fm.stringWidth(line));
                    i = 1 + nlIndex;
                }
                return maxWidth;
            }
            return fm.stringWidth(text);
        }
        return 0;
    }

    public static int getTextHeight(FontMetrics fm, String text) {
        return Overlay.getTextHeight(fm, text, false);
    }

    public static int getTextHeight(FontMetrics fm, String text, boolean preciseBBox) {
        if (fm == null) {
            return 0;
        }
        int h = fm.getHeight();
        int newline = 10;
        if (text != null && text.length() > 0) {
            if (text.indexOf(newline) > 0) {
                int nlIndex = 0;
                int maxHeight = 0;
                int i = 0;
                while (nlIndex >= 0) {
                    nlIndex = text.indexOf(newline, i);
                    String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                    if (line.length() > 0) {
                        if (preciseBBox) {
                            TextLayout tl = new TextLayout(line, fm.getFont(), fm.getFontRenderContext());
                            maxHeight += (int)Math.ceil(tl.getBounds().getHeight());
                        } else {
                            maxHeight += h;
                        }
                    }
                    i = 1 + nlIndex;
                }
                return maxHeight;
            }
            if (preciseBBox) {
                TextLayout tl = new TextLayout(text, fm.getFont(), fm.getFontRenderContext());
                return (int)Math.ceil(tl.getBounds().getHeight());
            }
            return h;
        }
        return 0;
    }

    public static int getTextAscent(FontMetrics fm, String text) {
        if (fm == null) {
            return 0;
        }
        int h = fm.getAscent();
        int newline = 10;
        if (text != null && text.length() > 0) {
            if (text.indexOf(newline) > 0) {
                int nlIndex = 0;
                int maxHeight = 0;
                int i = 0;
                while (nlIndex >= 0) {
                    nlIndex = text.indexOf(newline, i);
                    String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                    if (line.length() > 0) {
                        maxHeight += h;
                    }
                    i = 1 + nlIndex;
                }
                return maxHeight;
            }
            return h;
        }
        return 0;
    }

    public static int getTextDescent(FontMetrics fm, String text) {
        if (fm == null) {
            return 0;
        }
        int h = fm.getDescent();
        int newline = 10;
        if (text != null && text.length() > 0) {
            if (text.indexOf(newline) > 0) {
                int nlIndex = 0;
                int maxHeight = 0;
                int i = 0;
                while (nlIndex >= 0) {
                    nlIndex = text.indexOf(newline, i);
                    String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                    if (line.length() > 0) {
                        maxHeight += h;
                    }
                    i = 1 + nlIndex;
                }
                return maxHeight;
            }
            return h;
        }
        return 0;
    }

    public static int getInterlineSpacing(FontMetrics fm, String text) {
        if (fm == null) {
            return 0;
        }
        int newline = 10;
        if (text != null && text.length() > 0) {
            if (text.indexOf(newline) > 0) {
                int nlIndex = 0;
                int nLines = 0;
                int i = 0;
                while (nlIndex >= 0) {
                    nlIndex = text.indexOf(newline, i);
                    String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                    if (line.length() > 0) {
                        ++nLines;
                    }
                    i = 1 + nlIndex;
                }
                return fm.getLeading() * (nLines - 1);
            }
            return 0;
        }
        return 0;
    }

    public boolean isOneDimensional() {
        return false;
    }

    public boolean isDataOnHorizontalSide() {
        return false;
    }

    public int getPreferredSizeOnDataLessSide() {
        return -1;
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.tooltipEnabled = tooltipEnabled;
    }

    @Override
    public RasterLabel getRasterDataLabel() {
        return null;
    }

    public void setDisplayGridLabel(boolean b) {
        this.displayGridLabel = b;
    }

    public boolean isDisplayGridLabel() {
        return this.displayGridLabel;
    }

    public Insets getGridLabelMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void setLabelToGridLabel(boolean b) {
        this.labelToGridLabel = b;
    }

    public boolean isLabelToGridLabel() {
        return this.labelToGridLabel;
    }

    public void setUniformPlotSize(boolean b) {
        this.uniformPlotSize = b;
    }

    public boolean isUniformPlotSize() {
        return this.uniformPlotSize;
    }

    public void setLabelMaxWidth(double w) {
        this.labelMaxWidth = w;
    }

    public void setGridLabelOffsets(int top, int left, int bottom, int right) {
        this.gridLabelTopOffset = top;
        this.gridLabelLeftOffset = left;
        this.gridLabelBottomOffset = bottom;
        this.gridLabelRightOffset = right;
    }

    public void addGridLabelEntry(GridLabelEntry entry) {
        int position = entry.getPosition();
        switch (position) {
            case 0: {
                this.gridLabelEntryT = entry;
                break;
            }
            case 1: {
                this.gridLabelEntryL = entry;
                break;
            }
            case 2: {
                this.gridLabelEntryB = entry;
                break;
            }
            case 3: {
                this.gridLabelEntryR = entry;
            }
        }
    }

    public boolean isUseFillTransparency() {
        return this.useFillTransparency;
    }

    public void setUseFillTransparency(boolean useFillTransparency) {
        this.useFillTransparency = useFillTransparency;
    }

    public boolean isUseMarkerTransparency() {
        return this.useMarkerTransparency;
    }

    public void setUseMarkerTransparency(boolean useMarkerTransparency) {
        this.useMarkerTransparency = useMarkerTransparency;
    }

    public boolean isUseLineThickness() {
        return this.useLineThickness;
    }

    public void setUseLineThickness(boolean useLineThickness) {
        this.useLineThickness = useLineThickness;
    }

    public boolean isUseMarkerSize() {
        return this.useMarkerSize;
    }

    public void setUseMarkerSize(boolean useMarkerSize) {
        this.useMarkerSize = useMarkerSize;
    }

    public boolean isUseMarkerWeight() {
        return this.useMarkerWeight;
    }

    public void setUseMarkerWeight(boolean useMarkerWeight) {
        this.useMarkerWeight = useMarkerWeight;
    }

    public int[] getDAttrLineThickness(String attrVar, String[] values, int defaultThickness) {
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVar);
        int[] thickness = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            int t = attrMapper.getLineThickness(values[i]);
            thickness[i] = t < 0 ? defaultThickness : t;
        }
        return thickness;
    }

    public int[] getDAttrMarkerSize(String attrVar, String[] values, int defaultSize) {
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVar);
        int[] sizes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            int t = attrMapper.getMarkerSize(values[i]);
            sizes[i] = t < 0 ? defaultSize : t;
        }
        return sizes;
    }

    public void setDataSkinMax(int max) {
        this.maxDataSkinDrawingElements = max;
    }

    public int[] getDAttrMarkerWeight(String attrVar, String[] values, int defaultWeight) {
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVar);
        int[] weights = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            int w = attrMapper.getMarkerWeight(values[i]);
            weights[i] = w < 0 ? defaultWeight : w;
        }
        return weights;
    }

    protected int getNumberOfDrawingElements() {
        return 0;
    }

    protected void checkDataSkin() {
        if (this.skinType == 0) {
            return;
        }
        int num = this.getNumberOfDrawingElements();
        if (num > this.maxDataSkinDrawingElements) {
            this.skinType = 0;
            Message msg = new Message(RB.getStringResource(RB_KEY, "turnoffskin.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(num))), false);
        }
    }

    protected boolean isLegendEntryFromAttrMap(String attrVarName) {
        if (this.hasAttrVar(attrVarName)) {
            DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVarName);
            return attrMapper.getAttrMap().getLegendEntryPolicy() == 1;
        }
        return false;
    }

    protected LegendItem[] getLegendItemsFromAttrMap(String attrVarName, int attrType) {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper(attrVarName);
        LegendItem[] items = attrMapper.getAttrMap().getLegendItems(attrType, true);
        this.applyDataSkin(items);
        this.applyFillTransparency(items);
        this.applyMarkerTransparency(items);
        this.applyLineTransparency(items);
        this.applyTextTransparency(items);
        return items;
    }

    protected int fixDefaultAttrType(int attrType) {
        return attrType;
    }

    protected void applyDataSkin(LegendItem[] items) {
    }

    protected void applyFillTransparency(LegendItem[] items) {
    }

    protected void applyMarkerTransparency(LegendItem[] items) {
    }

    protected void applyLineTransparency(LegendItem[] items) {
    }

    protected void applyTextTransparency(LegendItem[] items) {
    }

    public boolean isDisableAA() {
        return this.disableAA;
    }

    public void setDisableAA(boolean disableAA) {
        this.disableAA = disableAA;
    }

    public void beginDisableAA(Channel ch) {
        if (!this.disableAA) {
            return;
        }
        Graphics2D g2d = (Graphics2D)ch.getBackbufferGC();
        this.savedAAHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.savedTextAntialiased = ch.glIsEnabled(14);
        ch.glDisable(14);
    }

    public void endDisableAA(Channel ch) {
        if (!this.disableAA) {
            return;
        }
        Graphics2D g2d = (Graphics2D)ch.getBackbufferGC();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.savedAAHint);
        if (this.savedTextAntialiased) {
            ch.glEnable(14);
        } else {
            ch.glDisable(14);
        }
    }

    public void setContribOffsets(boolean xMin, boolean xMax, boolean yMin, boolean yMax) {
        this.contribXMinOffset = xMin;
        this.contribXMaxOffset = xMax;
        this.contribYMinOffset = yMin;
        this.contribYMaxOffset = yMax;
    }

    public int getDataLabelNumSplitChars() {
        return this.dataLabelNumSplitChars;
    }

    public void setDataLabelNumSplitChars(int dataLabelNumSplitChars) {
        this.dataLabelNumSplitChars = dataLabelNumSplitChars;
    }

    public static int getMaxStringLength(Variable var, FontMetrics fm, boolean trim) {
        int n = var.getValueCount();
        boolean numeric = var instanceof NumericVariable;
        int maxLen = 0;
        for (int i = 0; i < n; ++i) {
            try {
                String s;
                String string = s = numeric ? ((NumericVariable)var).formattedValue.getValue(i) : ((StringVariable)var).formattedValue.getValue(i);
                if (trim) {
                    s = s.trim();
                }
                maxLen = Math.max(maxLen, fm.stringWidth(s));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return maxLen += StatGraph.getExtraPadding();
    }

    public int getRendererComplexity() {
        return this.model != null ? this.model.getRowCount() : 1;
    }

    public int getNumOfTooltips() {
        return this.model != null ? this.model.getRowCount() : 1;
    }

    public void resetToInitialValues() {
    }

    public boolean isDiscreteOffsetPadding() {
        return this.discreteOffsetPadding;
    }

    public void setDiscreteOffsetPadding(boolean discreteOffsetPadding) {
        this.discreteOffsetPadding = discreteOffsetPadding;
    }

    private boolean hasSameFormat(ColumnMetadata cmd1, ColumnMetadata cmd2) {
        if (cmd1.getFormat() == null && cmd2.getFormat() == null) {
            return true;
        }
        if (cmd1.getFormat() != null && cmd2.getFormat() == null || cmd1.getFormat() == null && cmd2.getFormat() != null) {
            return false;
        }
        return cmd1.getFormat().getName().equals(cmd2.getFormat().getName());
    }

    public void unsetDataSkin() {
        if (this.skinType != 0) {
            this.userSkinType = this.skinType;
            this.skinType = 0;
        }
    }

    public void resetDataSkin() {
        if (this.userSkinType != 0) {
            this.skinType = this.userSkinType;
            this.needConnect = true;
        }
    }

    double[] getSubsettedDoubleColumn(short role, short sortRole, boolean numericSortRole, int sortOrder) {
        if (sortRole == -1) {
            return this.getSubsettedDoubleColumn(role);
        }
        VariableProcessor vp = new VariableProcessor();
        if (numericSortRole) {
            Variable gVar = this.connectRaw(sortRole);
            vp.addVariable(gVar);
            vp.setSort(gVar, sortOrder);
        } else {
            StringVectorVariable gcVar = (StringVectorVariable)this.connectCategory(sortRole, true);
            vp.addVariable((Variable)gcVar);
            vp.setSort((Variable)gcVar, sortOrder);
        }
        double[] colData = null;
        NumericVectorVariable var = (NumericVectorVariable)this.connectRaw(role);
        this.addVarToVP(vp, (Variable)var);
        this.addCRDWhereClause(vp);
        colData = new double[var.getValueCount()];
        for (int i = 0; i < colData.length; ++i) {
            try {
                colData[i] = var.value.getValue(i);
                continue;
            }
            catch (MissingValueException mve) {
                colData[i] = Double.NaN;
            }
        }
        return colData;
    }

    String[] getSubsettedStringColumn(short role, short sortRole, boolean numericSortRole, int sortOrder) {
        if (sortRole == -1) {
            return this.getSubsettedStringColumn(role);
        }
        VariableProcessor vp = new VariableProcessor();
        if (numericSortRole) {
            Variable gVar = this.connectRaw(sortRole);
            vp.addVariable(gVar);
            vp.setSort(gVar, sortOrder);
        } else {
            StringVectorVariable gcVar = (StringVectorVariable)this.connectCategory(sortRole, true);
            vp.addVariable((Variable)gcVar);
            vp.setSort((Variable)gcVar, sortOrder);
        }
        String[] colData = null;
        StringVectorVariable var = (StringVectorVariable)this.connectRaw(role);
        this.addVarToVP(vp, (Variable)var);
        this.addCRDWhereClause(vp);
        colData = new String[var.getValueCount()];
        for (int i = 0; i < colData.length; ++i) {
            try {
                colData[i] = var.value.getValue(i);
                continue;
            }
            catch (MissingValueException mve) {
                colData[i] = null;
            }
        }
        return colData;
    }

    String[] getSubsettedColumnAsClassColumn(short role, boolean numeric, short sortRole, boolean numericSortRole, int sortOrder) {
        if (sortRole == -1) {
            return this.getSubsettedColumnAsClassColumn(role, numeric);
        }
        VariableProcessor vp = new VariableProcessor();
        if (numericSortRole) {
            Variable gVar = this.connectRaw(sortRole);
            vp.addVariable(gVar);
            vp.setSort(gVar, sortOrder);
        } else {
            StringVectorVariable gcVar = (StringVectorVariable)this.connectCategory(sortRole, true);
            vp.addVariable((Variable)gcVar);
            vp.setSort((Variable)gcVar, sortOrder);
        }
        String[] colData = null;
        Variable var = this.connectRaw(role);
        this.addVarToVP(vp, var);
        this.addCRDWhereClause(vp);
        colData = new String[var.getValueCount()];
        for (int i = 0; i < colData.length; ++i) {
            try {
                if (numeric) {
                    colData[i] = DataModel.formatNumber(((NumericVariable)var).value.getValue(i));
                    continue;
                }
                colData[i] = ((StringVariable)var).value.getValue(i);
                continue;
            }
            catch (MissingValueException mve) {
                colData[i] = null;
            }
        }
        return colData;
    }

    protected void addCRDWhereClause(VariableProcessor vp, Variable sortVar, int sortOrder) {
        if (sortVar == null || sortOrder == 0) {
            this.addCRDWhereClause(vp);
            return;
        }
        if (this.model.whereExpression != null) {
            VariableProcessor vp2 = new VariableProcessor();
            for (int i = 0; i < this.model.whereVars.length; ++i) {
                StringVectorVariable sv;
                if (this.model.whereVars[i] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[i].getName());
                    sv.setName(this.model.whereVars[i].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[i]);
                }
                vp2.addVariable((Variable)sv);
                StringVariable sv2 = new StringVariable();
                sv2.connectFrom((StringVariable)sv);
                sv2.setLabel(sv.getLabel());
                sv2.setName(sv.getName());
                vp.addVariable((Variable)sv2);
            }
            vp2.addVariable(sortVar);
            vp2.setSort(sortVar, sortOrder);
            sortVar.getValueCount();
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.whereExpression + ")");
            } else {
                vp.setWhereExpression(this.model.whereExpression);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            } else {
                this.whereVP = vp;
            }
        } else {
            this.whereVP = vp;
        }
    }

    protected void addTooltip(VariableProcessor vp, String role, Probe currProbe, Variable sortVar, int sortOrder) {
        boolean formatChanged;
        if (sortVar == null || sortOrder == 0) {
            this.addTooltip(vp, role, currProbe);
            return;
        }
        String roleName = role.toUpperCase();
        if (!this.tooltipEnabled || !this.roleMap.containsKey(roleName)) {
            return;
        }
        ColumnMetadata cmd = this.getRoleMetadata(roleName);
        if (this.isColumnAdded(cmd.getLabel(), currProbe)) {
            return;
        }
        int col = this.model.getSrcModel().getColumn(cmd.getName());
        StringVectorVariable svv = new StringVectorVariable();
        ColumnMetadata cmd2 = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(col);
        boolean bl = formatChanged = !this.hasSameFormat(cmd, cmd2);
        if (formatChanged) {
            this.model.getSrcModel().setColumnLabel(col, cmd);
            svv.connectFrom(this.model.getSrcModel().getUpdatedColumnAsClassColumn(col));
        } else {
            svv.connectFrom(this.model.getSrcModel().getColumnAsClassColumn(col, true));
        }
        VariableProcessor vp2 = new VariableProcessor();
        vp2.addVariable((Variable)svv);
        vp2.addVariable(sortVar);
        vp2.setSort(sortVar, sortOrder);
        svv.getValueCount();
        StringVariable svv2 = new StringVariable();
        svv2.connectFrom((StringVariable)svv);
        svv2.setName(svv.getName());
        svv2.setLabel(svv.getLabel());
        if (vp != null) {
            vp.addVariable((Variable)svv2);
        }
        currProbe.addPipe(cmd.getLabel(), (Pipe)svv2.value);
        if (formatChanged) {
            this.model.getSrcModel().setColumnLabel(col, cmd2);
            this.model.getSrcModel().getUpdatedColumnAsClassColumn(col);
        }
    }

    protected void addCustomTips(VariableProcessor vp, Variable sortVar, int sortOrder) {
        if (sortVar == null || sortOrder == 0) {
            this.addCustomTips(vp);
            return;
        }
        if (!this.tooltipEnabled) {
            return;
        }
        int cnt = 0;
        while (this.model.isAvailable(300 + cnt)) {
            int r = 300 + cnt;
            if (this.tipRoleMap != null && this.tipRoleMap.get(new Integer(r)) != null) {
                this.addTooltip(vp, (String)this.tipRoleMap.get(new Integer(r)), this.probe, sortVar, sortOrder);
            }
            ++cnt;
        }
    }

    protected Variable addVarToVP(VariableProcessor vp, Variable var, Variable sortVar, int sortOrder) {
        if (sortVar == null || sortOrder == 0) {
            this.addVarToVP(vp, var);
            return var;
        }
        if (var != null) {
            NumericVariable var2;
            VariableProcessor vp2 = new VariableProcessor();
            vp2.addVariable(var);
            vp2.addVariable(sortVar);
            vp2.setSort(sortVar, sortOrder);
            if (this.model.subsetObs != null) {
                vp2.setSubsetByObservation(this.model.subsetObs, this.model.subsetObsCount);
            }
            var.getValueCount();
            if (var instanceof NumericVariable) {
                var2 = new NumericVariable();
                var2.connectFrom((NumericVariable)var);
            } else {
                var2 = new StringVariable();
                ((StringVariable)var2).connectFrom((StringVariable)var);
            }
            var2.setFormat(var.getFormat());
            var2.setLabel(var.getLabel());
            var2.setFormat(var.getFormat());
            vp.addVariable((Variable)var2);
            var2.getValueCount();
            return var2;
        }
        return var;
    }

    public static ArrayList<Variable> sortVariables(ArrayList<Variable> varList, int[] sortVarIndex, int[] sortOrder) {
        if (varList == null || varList.size() == 0 || sortVarIndex == null || sortOrder == null) {
            return varList;
        }
        if (sortVarIndex.length != sortOrder.length) {
            return varList;
        }
        varList.get(0).getValueCount();
        ArrayList<Variable> unsortedList = new ArrayList<Variable>();
        for (int i = 0; i < varList.size(); ++i) {
            unsortedList.add(varList.get(i));
        }
        ArrayList<Variable> sortedList = new ArrayList<Variable>();
        int n = sortVarIndex.length;
        for (int si = 0; si < n; ++si) {
            sortedList.clear();
            VariableProcessor vp = new VariableProcessor();
            for (int i = 0; i < unsortedList.size(); ++i) {
                NumericVariable var2;
                Variable var = (Variable)unsortedList.get(i);
                if (var == null) {
                    sortedList.add(null);
                    continue;
                }
                if (var instanceof NumericVariable) {
                    var2 = new NumericVariable();
                    var2.connectFrom((NumericVariable)var);
                } else {
                    var2 = new StringVariable();
                    ((StringVariable)var2).connectFrom((StringVariable)var);
                }
                var2.setLabel(var.getLabel());
                var2.setFormat(var.getFormat());
                vp.addVariable((Variable)var2);
                sortedList.add((Variable)var2);
            }
            Variable currSortVar = sortedList.get(sortVarIndex[si]);
            vp.setSort(currSortVar, sortOrder[si]);
            currSortVar.setSortByFormattedValues(currSortVar instanceof StringVariable);
            currSortVar.getValueCount();
            for (int i = 0; i < sortedList.size(); ++i) {
                unsortedList.set(i, sortedList.get(i));
            }
        }
        return sortedList;
    }

    public double getCapScale() {
        return this.capScale;
    }

    public void setCapScale(double capScale) {
        this.capScale = capScale;
    }
}

