/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.MapIDCompositePipe;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.FrequencyVariable;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.render.map.MapObject;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class MapOverlay
extends Overlay {
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange responseRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    private NetworkRoot networkRoot;
    private MapObject mapObject = new MapObject();
    private Variable responseVar;
    private Variable colorGroupVar;
    private StringVectorVariable idVar;
    protected DataModel mapData;
    private String[] mapIDVars;
    private String mapXVar;
    private String mapYVar;
    private String mapSegmentVar;
    private int statistic = 12;

    public MapObject getMapObject() {
        return this.mapObject;
    }

    public DataModel getMapDataModel() {
        return this.mapData;
    }

    public void setMapDataModel(DataModel mapData) {
        this.mapData = mapData;
    }

    public String[] getMapIDVars() {
        return this.mapIDVars;
    }

    public void setMapIDVars(String[] mapIDVars) {
        this.mapIDVars = mapIDVars;
    }

    public String getMapXVar() {
        return this.mapXVar;
    }

    public void setMapXVar(String mapXVar) {
        this.mapXVar = mapXVar;
    }

    public String getMapYVar() {
        return this.mapYVar;
    }

    public void setMapYVar(String mapYVar) {
        this.mapYVar = mapYVar;
    }

    public String getMapSegmentVar() {
        return this.mapSegmentVar;
    }

    public void setMapSegmentVar(String mapSegmentVar) {
        this.mapSegmentVar = mapSegmentVar;
    }

    public double getMapXMin() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        return cmd.getMin();
    }

    public double getMapXMax() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        return cmd.getMax();
    }

    public double getMapYMin() {
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        return cmd.getMin();
    }

    public double getMapYMax() {
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        return cmd.getMax();
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                this.updateResponseRange();
                return this.responseRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.mapObject.setChannel(channel);
        this.networkRoot = new NetworkRoot(channel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateResponseRange();
    }

    private void setupIDVar(CRD crd) {
        if (crd.isAvailable(600)) {
            MapIDCompositePipe cat = new MapIDCompositePipe();
            int cnt = 0;
            while (crd.isAvailable(600 + cnt)) {
                int r = 600 + cnt;
                StringVectorVariable v = (StringVectorVariable)this.connectCategory((short)r, true);
                cat.addInput((Pipe)v.value);
                ++cnt;
            }
            this.idVar = new StringVectorVariable();
            this.idVar.connectFrom(cat.value);
        }
    }

    private ContinuousRange getResponseRange() {
        if (!this.model.isAvailable(2)) {
            return null;
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.idVar == null) {
            this.setupIDVar(this.model);
        }
        vp.addGroupVariable((Variable)this.idVar);
        Object colorVar = this.statistic == 2 || this.statistic == 3 ? new FrequencyVariable() : (NumericVariable)this.connectRaw((short)2);
        vp.addVariable((Variable)colorVar, this.statistic);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < colorVar.getValueCount(); ++i) {
            try {
                double d = colorVar.value.getValue(i);
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return new ContinuousRange(min, max);
    }

    private DiscreteRange getColorGroupRange() {
        if (!this.model.isAvailable(107)) {
            return null;
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.idVar == null) {
            this.setupIDVar(this.model);
        }
        vp.addGroupVariable((Variable)this.idVar);
        DiscreteRange newRange = null;
        Object colorVar = this.statistic == 2 || this.statistic == 3 ? new FrequencyVariable() : this.connectRaw((short)107);
        vp.addVariable((Variable)colorVar, this.statistic);
        vp.setSort((Variable)colorVar, 1);
        if (colorVar != null) {
            String obj2;
            int i;
            boolean numericVar = colorVar instanceof NumericVariable;
            int num = colorVar.getUniqueValueCount();
            Vector<String> tmpVals = new Vector<String>();
            if (numericVar) {
                for (i = 0; i < num; ++i) {
                    try {
                        obj2 = colorVar.formattedUniqueValue.getValue(i);
                        if (obj2.equals("")) continue;
                        tmpVals.add(obj2);
                        continue;
                    }
                    catch (Exception obj2) {
                        // empty catch block
                    }
                }
            } else {
                for (i = 0; i < num; ++i) {
                    try {
                        obj2 = ((StringVectorVariable)colorVar).uniqueValue.getValue(i);
                        if (obj2.equals("")) continue;
                        tmpVals.add(obj2);
                        continue;
                    }
                    catch (Exception obj3) {
                        // empty catch block
                    }
                }
            }
            num = tmpVals.size();
            Object[] vals = new Object[num];
            for (int i2 = 0; i2 < num; ++i2) {
                vals[i2] = tmpVals.elementAt(i2);
            }
            newRange = new DiscreteRange(vals);
            newRange.setLabel(colorVar.getLabel());
        }
        return newRange;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
            if (this.model.isAvailable(2)) {
                Color[] ramp = new Color[]{this.colorEncoder.startColor, this.colorEncoder.mediumColor, this.colorEncoder.endColor};
                this.mapObject.setRampColors(ramp);
                ContinuousRange rRange = this.getResponseRange();
                double min = rRange.getMin();
                double max = rRange.getMax();
                double neutral = (min + max) / 2.0;
                double[] rampval = new double[]{min, neutral, max};
                this.mapObject.setRampValues(rampval);
                this.mapObject.setDiscrete(false);
            } else if (this.model.isAvailable(107)) {
                if (!(encoder instanceof ColorEncoder)) {
                    return;
                }
                VariableProcessor vp = new VariableProcessor();
                vp.addGroupVariable(this.connectCategory((short)600, false));
                this.colorEncoder = (ColorEncoder)encoder;
                this.mapObject.setRampColors(this.colorEncoder.colorArray);
                Object colorVar = this.statistic == 2 || this.statistic == 3 ? new FrequencyVariable() : this.connectRaw((short)107);
                vp.addVariable((Variable)colorVar, this.statistic);
                vp.setSort((Variable)colorVar, 1);
                if (colorVar != null) {
                    String obj2;
                    int i;
                    boolean numericVar = colorVar instanceof NumericVariable;
                    int num = colorVar.getUniqueValueCount();
                    Vector<String> tmpVals = new Vector<String>();
                    if (numericVar) {
                        for (i = 0; i < num; ++i) {
                            try {
                                obj2 = colorVar.formattedUniqueValue.getValue(i);
                                if (obj2.equals("")) continue;
                                tmpVals.add(obj2);
                                continue;
                            }
                            catch (Exception obj2) {
                                // empty catch block
                            }
                        }
                    } else {
                        for (i = 0; i < num; ++i) {
                            try {
                                obj2 = ((StringVectorVariable)colorVar).uniqueValue.getValue(i);
                                if (obj2.equals("")) continue;
                                tmpVals.add(obj2);
                                continue;
                            }
                            catch (Exception obj3) {
                                // empty catch block
                            }
                        }
                    }
                    num = tmpVals.size();
                    Object[] vals = new Object[num];
                    for (int i2 = 0; i2 < num; ++i2) {
                        vals[i2] = tmpVals.elementAt(i2);
                    }
                    this.mapObject.setDiscrete(true);
                    this.mapObject.setDiscreteColors(this.colorEncoder.colorArray);
                    this.mapObject.setDiscreteValues(vals);
                }
            }
        }
        this.needConnect = true;
    }

    @Override
    public void draw(Graphics g) {
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double x1in = xmap.getInputMin();
        double x2in = xmap.getInputMax();
        double x1out = xmap.getOutputMin();
        double x2out = xmap.getOutputMax();
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double y1in = ymap.getInputMin();
        double y2in = ymap.getInputMax();
        double y1out = ymap.getOutputMin();
        double y2out = ymap.getOutputMax();
        double win = x2in - x1in;
        double hin = y2in - y1in;
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        Channel channel = this.networkRoot.getChannel();
        channel.glPushAttrib(0);
        channel.glEdgeFlag(true);
        channel.glPushMatrix();
        channel.glTranslate(x1out, y1out, 0.0);
        channel.glScale(wout / win, hout / hin, 0.0);
        channel.glTranslate(-x1in, -y1in, 0.0);
        channel.setClip(g.getClipBounds());
        this.mapObject.draw();
        channel.glPopMatrix();
        channel.glPopAttrib();
    }

    protected void connectVars() {
        int xcol = this.mapData.getColumn(this.mapXVar);
        NumericVectorVariable xVar = new NumericVectorVariable();
        xVar.connectFrom(this.mapData.getDoubleColumn(xcol));
        this.mapObject.setXVariable((NumericVariable)xVar);
        int ycol = this.mapData.getColumn(this.mapYVar);
        NumericVectorVariable yVar = new NumericVectorVariable();
        yVar.connectFrom(this.mapData.getDoubleColumn(ycol));
        this.mapObject.setYVariable((NumericVariable)yVar);
        if (this.mapSegmentVar != null) {
            int scol = this.mapData.getColumn(this.mapSegmentVar);
            NumericVectorVariable sVar = new NumericVectorVariable();
            sVar.connectFrom(this.mapData.getDoubleColumn(scol));
            this.mapObject.setSegmentVariable((NumericVariable)sVar);
        }
        MapIDCompositePipe cat = new MapIDCompositePipe();
        for (int i = 0; i < this.mapIDVars.length; ++i) {
            int idcol = this.mapData.getColumn(this.mapIDVars[i]);
            StringVectorVariable outVar = new StringVectorVariable();
            outVar.connectFrom(this.mapData.getColumnAsClassColumn(idcol, true));
            outVar.setBlankMissing(false);
            cat.addInput((Pipe)outVar.value);
        }
        StringVectorVariable sv = new StringVectorVariable();
        sv.connectFrom(cat.value);
        this.mapObject.setMapStringIDVariable((StringVariable)sv);
        CRD crd = this.model;
        if (crd == null) {
            return;
        }
        VariableProcessor vp = new VariableProcessor();
        this.setupIDVar(this.model);
        if (this.idVar != null) {
            this.mapObject.setResponseStringIDVariable((StringVariable)this.idVar);
            vp.addGroupVariable((Variable)this.idVar);
        }
        if (crd.isAvailable(2)) {
            this.responseVar = this.statistic == 2 || this.statistic == 3 ? new FrequencyVariable() : this.connectRaw((short)2);
            this.mapObject.setColorVariable((NumericVariable)this.responseVar);
            this.mapObject.setStatistic(this.statistic);
            vp.addVariable(this.responseVar, this.statistic);
        } else {
            this.responseVar = null;
        }
        if (crd.isAvailable(107)) {
            this.colorGroupVar = this.statistic == 2 || this.statistic == 3 ? new FrequencyVariable() : this.connectRaw((short)107);
            vp.addVariable(this.colorGroupVar, this.statistic);
            vp.setSort(this.colorGroupVar, 1);
            this.mapObject.setStatistic(this.statistic);
            if (this.colorGroupVar instanceof NumericVariable) {
                this.mapObject.setColorVariable((NumericVariable)this.colorGroupVar);
            } else {
                this.mapObject.setColorStringVariable((StringVariable)this.colorGroupVar);
            }
        } else {
            this.colorGroupVar = null;
        }
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        int xcol = this.mapData.getColumn(this.mapXVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(xcol);
        newRange = new ContinuousRange(this.getMapXMin(), this.getMapXMax());
        newRange.setFormat(cmd.getFormat());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        int ycol = this.mapData.getColumn(this.mapYVar);
        ColumnMetadata cmd = (ColumnMetadata)this.mapData.getColumnLabel(ycol);
        newRange = new ContinuousRange(cmd.getMin(), cmd.getMax());
        newRange.setFormat(cmd.getFormat());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    protected void updateResponseRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.responseRange;
        if (this.model == null) {
            return;
        }
        if (this.model.isAvailable(2)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(2);
            newRange = this.getResponseRange();
            if (this.statistic == 3 || this.statistic == 7) {
                newRange.setFormat(SASFormat.getInstance((String)"PERCENT8.2"));
            } else if (this.statistic != 2) {
                newRange.setFormat(cmd.getFormat());
            }
            ColorEncoder e = (ColorEncoder)this.getEncoder((byte)4);
            if (e != null) {
                this.setEncoder((byte)4, new ColorEncoder(newRange, e.startColor, e.mediumColor, e.endColor));
            }
        } else if (this.model.isAvailable(107)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(107);
            newRange = this.getColorGroupRange();
            if (this.statistic == 3 || this.statistic == 7) {
                newRange.setFormat(SASFormat.getInstance((String)"PERCENT8.2"));
            } else if (this.statistic != 2) {
                newRange.setFormat(cmd.getFormat());
            }
            ColorEncoder e = (ColorEncoder)this.getEncoder((byte)4);
            if (e != null) {
                ColorEncoder new_e = new ColorEncoder((DiscreteRange)newRange, e.colorList);
                new_e.colorArray = e.colorArray;
                this.setEncoder((byte)4, new_e);
            }
        } else {
            return;
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.responseRange = newRange;
    }

    public Color getEmptyFillColor() {
        return this.mapObject.getEmptyColor();
    }

    public Color getEmptyLineColor() {
        return this.mapObject.getEmptyEdgeColor();
    }

    public int getEmptyLinePattern() {
        return this.mapObject.getEmptyEdgePattern();
    }

    public int getEmptyLineWidth() {
        return this.mapObject.getEmptyEdgeThickness();
    }

    public boolean hasColorResponse() {
        return this.model.isAvailable(2);
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper mapper;
        String error;
        if (type == 1) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce == null || !(ce.getInput() instanceof ContinuousRange)) {
            return null;
        }
        ContinuousRange range = (ContinuousRange)ce.getInput();
        if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(range.getMin(), range.getMax())) == null) {
            return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        Color[] colors = new Color[]{ce.startColor, ce.mediumColor, ce.endColor};
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        DiscreteRange dr = this.getColorGroupRange();
        if (this.colorEncoder == null) {
            return null;
        }
        Vector drValues = null;
        String[] values = null;
        int n = 0;
        if (dr != null) {
            drValues = dr.getValues();
            n = drValues.size();
            values = new String[n];
            for (int i = 0; i < drValues.size(); ++i) {
                values[i] = drValues.elementAt(i).toString();
            }
        }
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        Color[] fcolor = this.colorEncoder.colorArray;
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        n = values.length;
        LegendItem[] entries = new LegendItem[n];
        if (fcolor == null) {
            fcolor = this.getFillColors();
        }
        if (fcolor.length == 0 && this.colorEncoder.getInput() instanceof ContinuousRange) {
            fcolor = new Color[]{this.colorEncoder.startColor};
        }
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            attr.setColor(fcolor[i % fcolor.length]);
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null);
        }
        return entries;
    }
}

