/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveGraph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.FitLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeMerger;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;

public class LineParmOverlay
extends Overlay {
    protected boolean xInterceptBased = false;
    private int nGroups = 1;
    private int numLines = 1;
    protected FitLineOverlay[] lines;
    protected int cCnt;
    protected Color[] lColors;
    protected int lCnt;
    protected LineAttrs[] lStyles;
    public double[] colorIndex = null;
    public double[] styleIndex = null;
    public double constantSlope = Double.NaN;
    public double constantX = Double.NaN;
    public double constantY = Double.NaN;
    private int curveLabelLocation = 0;
    private IntegerVector curveLabelClosestAxis = null;
    private CurveLabelLayout clLayout;
    private NetworkRoot networkRoot2;
    private boolean preserveInsideLabelSpace = false;
    protected Color[] groupLineColors;
    protected LineAttrs[] groupLineStyles;
    private boolean labelProtected = false;
    private boolean fixedLineColor = false;
    private boolean fixedLinePattern = false;
    private LineAttrs missingLineAttrs = new LineAttrs();
    private boolean colorPriority = false;
    private int styleColorCount = 1;
    private int defaultLineThickness = 1;
    private boolean rotateXCurveLabels = false;
    private boolean rotateX2CurveLabels = false;

    public boolean isFixedLineColor() {
        return this.fixedLineColor;
    }

    public void setFixedLineColor(boolean fixedLineColor) {
        this.fixedLineColor = fixedLineColor;
    }

    public boolean isFixedLinePattern() {
        return this.fixedLinePattern;
    }

    public void setFixedLinePattern(boolean fixedLinePattern) {
        this.fixedLinePattern = fixedLinePattern;
    }

    public boolean isProtectedLine() {
        return this.labelProtected;
    }

    public void setProtectedLine(boolean b) {
        this.labelProtected = b;
    }

    public CurveLabelLayout getCurveLabelLayout() {
        return this.clLayout;
    }

    public void setCurveLabelLayout(CurveLabelLayout l) {
        this.clLayout = l;
        this.clLayout.setExtended(this.lines[0].isExtreme());
    }

    public int getCurveLabelLocation() {
        return this.curveLabelLocation;
    }

    public void setCurveLabelLocation(int curveLabelLocation) {
        this.curveLabelLocation = curveLabelLocation;
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setCurveLabelLocation(curveLabelLocation);
            this.lines[i].needConnect = true;
        }
    }

    public int getCurveLabelPosition() {
        if (this.lines[0].getLabelPosition() == 1.0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setCurveLabelSplitJustify(int justify) {
        super.setCurveLabelSplitJustify(justify);
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setCurveLabelSplitJustify(justify);
        }
    }

    public boolean isCurveLabeled() {
        if (this.curveLabelLocation != 1) {
            return false;
        }
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lines[i].getCurveLabelString() == null) continue;
            return true;
        }
        return false;
    }

    private Color getIndexedColor(int i, int gi) {
        if (this.colorIndex != null) {
            gi = (int)this.colorIndex[i] - 1;
        }
        return this.lColors[(this.cCnt + gi) % this.lColors.length];
    }

    private LineAttrs getIndexedStyle(int i, int gi) {
        if (this.styleIndex != null) {
            gi = (int)this.styleIndex[i] - 1;
        }
        if (this.colorPriority) {
            return this.styleColorCount == 0 ? this.lStyles[(this.lCnt + gi) % this.lStyles.length] : this.lStyles[(this.lCnt + gi / this.styleColorCount) % this.lStyles.length];
        }
        return this.lStyles[(this.lCnt + gi) % this.lStyles.length];
    }

    public void setClipRect(Rectangle r) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setClipRect(r);
        }
    }

    public void setLabelInsideHAutomatic(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLabelInsideHAutomatic(b);
            this.lines[i].needConnect = true;
        }
    }

    public void setLabelInsideVAutomatic(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLabelInsideVAutomatic(b);
            this.lines[i].needConnect = true;
        }
    }

    public void setLineWidths(int width) {
        int i;
        this.defaultLineThickness = width;
        if (this.lines != null) {
            for (i = 0; i < this.numLines; ++i) {
                this.lines[i].getLineStyle().setWidth(width);
                this.lines[i].needConnect = true;
            }
        }
        if (this.groupLineStyles != null) {
            for (i = 0; i < this.nGroups; ++i) {
                this.groupLineStyles[i].setWidth(width);
            }
        }
    }

    @Override
    public int[] getLineWidths() {
        int[] lw = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            lw[i] = this.groupLineStyles[i].getWidth();
        }
        return lw;
    }

    public void setLineColors(int cnt, Color[] colors) {
        this.cCnt = cnt;
        this.lColors = colors;
        if (this.lines == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].needConnect = true;
        }
    }

    public void setLineStyles(int cnt, LineAttrs[] styles) {
        this.lCnt = cnt;
        this.lStyles = styles;
        if (this.lines == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public Color[] getLineColors() {
        if (this.groupLineColors != null && this.groupLineColors.length > 0) {
            Color[] cls = new Color[this.groupLineColors.length];
            for (int i = 0; i < cls.length; ++i) {
                if (this.groupLineColors[i] == null || this.groupLineStyles[i] == null) continue;
                cls[i] = this.applyDataTransparency(this.groupLineColors[i], this.groupLineStyles[i].getTransparency());
            }
            return cls;
        }
        return null;
    }

    @Override
    public int[] getLinePatterns() {
        int[] lp = new int[this.nGroups];
        for (int i = 0; i < this.nGroups; ++i) {
            lp[i] = this.groupLineStyles[i].getLinePattern();
        }
        return lp;
    }

    @Override
    public String[] getGroupValues() {
        if (this.model == null || this.model.getSrcMap().getColumn(3) < 0) {
            return new String[]{this.getLegendLabel()};
        }
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return this.getUniqueGroupValues((short)3);
    }

    @Override
    public String[] getLineColorValues() {
        return this.getGroupValues();
    }

    @Override
    public String[] getLinePatternValues() {
        return this.getGroupValues();
    }

    public void setExtreme(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setExtreme(b);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void setTopReservedSpace(int s) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setTopReservedSpace(s);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void setBottomReservedSpace(int s) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setBottomReservedSpace(s);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void setLeftReservedSpace(int s) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLeftReservedSpace(s);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void setRightReservedSpace(int s) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setRightReservedSpace(s);
            this.lines[i].needConnect = true;
        }
    }

    public void setClipping(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setClipping(b);
        }
    }

    public void setXInterceptBased(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setXInterceptBased(b);
        }
    }

    public void setLabelPosition(double position) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLabelPosition(position);
            this.lines[i].needConnect = true;
        }
    }

    public void setUseLabelColor(boolean b) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setUseLabelColor(b);
            this.lines[i].needConnect = true;
        }
    }

    public void setLineStyle(LineAttrs style) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLineStyle(style);
            this.lines[i].needConnect = true;
        }
    }

    public TextStyle getLabelStyle() {
        return this.lines[0].getLabelStyle();
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLabelStyle(aLabelStyle);
            this.lines[i].needConnect = true;
        }
    }

    public void setDefaultSlope(double aDefaultSlope) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setDefaultSlope(aDefaultSlope);
        }
    }

    public void setXValue(double x) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setXValue(x);
        }
    }

    public void setYValue(double y) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setYValue(y);
        }
    }

    public void setDefaultIntercept(double aDefaultIntercept) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setDefaultIntercept(aDefaultIntercept);
        }
    }

    public void setCurveLabelString(String aCurveLabel) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setCurveLabelString(aCurveLabel);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void setDataTransparency(double d) {
        super.setDataTransparency(d);
        if (this.lines == null) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setDataTransparency(d);
        }
    }

    public void setLabelFormat(SASFormat fmt) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setLabelFormat(fmt);
            this.lines[i].needConnect = true;
        }
    }

    @Override
    public void reconnect() {
        super.reconnect();
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].reconnect();
        }
    }

    @Override
    public void addRangeChangeListener(RangeChangeListener l) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].addRangeChangeListener(l);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.numLines == 1) {
            return this.lines[0].getDataRange(dimension);
        }
        RangeMerger rm = new RangeMerger();
        for (int i = 0; i < this.numLines; ++i) {
            rm.addInputRange(this.lines[i].getDataRange(dimension));
        }
        return rm.getOutputRange();
    }

    @Override
    public void setChannel(Channel channel) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setChannel(channel);
        }
    }

    @Override
    public void select() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].select();
        }
    }

    @Override
    public void draw(Graphics g) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].draw(g);
        }
        if (this.isCurveLabeled() && this.needConnect) {
            this.connectOutsideLabel();
            this.needConnect = false;
        }
    }

    @Override
    public void drawNoneClipped(Graphics g) {
        if (!this.isCurveLabeled()) {
            return;
        }
        if (this.needConnect) {
            this.connectOutsideLabel();
            this.needConnect = false;
        }
        Channel channel = this.networkRoot2.getChannel();
        this.networkRoot2.draw(channel, false);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].setEncoder(dimension, encoder);
        }
        if (this.isCurveLabeled()) {
            this.needConnect = true;
        }
        if (this.curveLabelSplit) {
            FontMetrics fm = StatGraph.getFontMetrics(this.lines[0].getLabelStyle().getFont());
            for (int i = 0; i < this.numLines; ++i) {
                String label = this.lines[i].getCurveLabelString();
                if (label != null) {
                    label = LineParmOverlay.makeMultiLineLabel(LineParmOverlay.splitLabel(label, true, -1.0, this.curveLabelSplitCharDrop, this.curveLabelSplitChar, fm), true);
                }
                this.lines[i].setSplitCurveLabelString(label);
            }
        }
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        if (aModel != null) {
            double[] ngs;
            CRD crd = aModel;
            DataModel srcModel = crd.getSrcModel();
            RoleColumnMap map = crd.getSrcMap();
            int scol = map.getColumn(30);
            int xcol = map.getColumn(10);
            int ycol = map.getColumn(11);
            int gcol = map.getColumn(3);
            int lcol = map.getColumn(48);
            String idLabel = null;
            Variable gVar = null;
            StringVectorVariable gcVar = null;
            int missingGroupIndex = -1;
            VariableProcessor vp = null;
            if (gcol >= 0) {
                boolean numeric = crd.getColumnClass(3) == Double.class;
                gVar = this.connectRaw((short)3);
                gcVar = (StringVectorVariable)this.connectCategory((short)3, true);
                if (this.groupOrder == 1 || this.groupOrder == 2) {
                    int sort;
                    vp = new VariableProcessor();
                    vp.addVariable(gVar);
                    vp.addVariable((Variable)gcVar);
                    int n = sort = this.groupOrder == 1 ? 1 : 2;
                    if (gVar instanceof NumericVariable) {
                        vp.setSort(gVar, sort);
                    } else {
                        vp.setSort((Variable)gcVar, sort);
                    }
                }
                gcVar.getUniqueValueCount();
                this.nGroups = gVar.getUniqueValueCount();
                ColumnMetadata gcmd = (ColumnMetadata)srcModel.getColumnLabel(gcol);
                idLabel = gcmd.getLabel();
                DiscreteAttrMapper groupAttrMapper = null;
                if (this.hasAttrVar("GROUP")) {
                    groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                }
                this.groupLineColors = new Color[this.nGroups];
                this.groupLineStyles = new LineAttrs[this.nGroups];
                int n = 0;
                int gIdx = 0;
                for (int i = 0; i < this.nGroups; ++i) {
                    LineAttrs la;
                    String gVal = null;
                    boolean missing = false;
                    try {
                        gVal = gcVar.uniqueValue.getValue(i);
                        if (gVar instanceof StringVariable) {
                            ((StringVariable)gVar).uniqueValue.getValue(i);
                        } else {
                            ((NumericVariable)gVar).uniqueValue.getValue(i);
                        }
                    }
                    catch (MissingValueException mve) {
                        if (!this.missingGroupOn) {
                            missingGroupIndex = i;
                            continue;
                        }
                        missing = true;
                    }
                    int idx = this.getFirstOccurringValueIndex(gVar, gIdx);
                    if (groupAttrMapper != null) {
                        int lt;
                        int p;
                        Color c;
                        this.groupLineColors[n] = this.fixedLineColor ? this.lColors[0] : ((c = groupAttrMapper.getLineColor(gVal)) != null ? c : (missing ? this.missingLineAttrs.getColor() : this.getIndexedColor(idx, gIdx)));
                        la = this.getIndexedStyle(idx, gIdx);
                        if (this.fixedLinePattern) {
                            p = this.lStyles[0].getLinePattern();
                        } else {
                            p = groupAttrMapper.getLinePattern(gVal);
                            if (p < 0) {
                                p = missing ? this.missingLineAttrs.getLinePattern() : la.getLinePattern();
                            }
                        }
                        int n2 = lt = this.useLineThickness ? this.defaultLineThickness : groupAttrMapper.getLineThickness(gVal);
                        if (lt < 0) {
                            lt = this.defaultLineThickness;
                        }
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        this.groupLineStyles[n].setLinePattern(p);
                        this.groupLineStyles[n].setWidth(lt);
                        if (!missing) {
                            ++gIdx;
                        }
                    } else if (LayoutOverlayParser.isMissing(gVal, gVar instanceof NumericVariable)) {
                        this.groupLineColors[n] = this.fixedLineColor ? this.lColors[0] : this.missingLineAttrs.getColor();
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        if (this.fixedLinePattern) {
                            this.groupLineStyles[n].setLinePattern(this.lStyles[0].getLinePattern());
                        } else {
                            this.groupLineStyles[n].setLinePattern(this.missingLineAttrs.getLinePattern());
                        }
                        if (this.useLineThickness) {
                            this.groupLineStyles[n].setWidth(this.defaultLineThickness);
                        } else {
                            this.groupLineStyles[n].setWidth(this.missingLineAttrs.getWidth());
                        }
                    } else {
                        this.groupLineColors[n] = this.fixedLineColor ? this.lColors[0] : this.getIndexedColor(idx, gIdx);
                        la = this.getIndexedStyle(idx, gIdx);
                        this.groupLineStyles[n] = new LineAttrs();
                        this.groupLineStyles[n].setColor(this.groupLineColors[n]);
                        this.groupLineStyles[n].setLinePattern(la.getLinePattern());
                        this.groupLineStyles[n].setWidth(la.getWidth());
                        if (this.fixedLinePattern) {
                            this.groupLineStyles[n].setLinePattern(this.lStyles[0].getLinePattern());
                        }
                        if (this.useLineThickness) {
                            this.groupLineStyles[n].setWidth(this.defaultLineThickness);
                        }
                        ++gIdx;
                    }
                    ++n;
                }
                if (missingGroupIndex >= 0) {
                    --this.nGroups;
                }
            } else {
                this.groupLineColors = new Color[]{this.getIndexedColor(0, 0)};
                this.groupLineStyles = new LineAttrs[]{this.getIndexedStyle(0, 0)};
            }
            boolean numericLabel = false;
            if (lcol >= 0) {
                numericLabel = crd.getColumnClass(48) == Double.class;
            }
            boolean numericGroup = false;
            int sortOrder = -1;
            short sortRole = -1;
            if (gVar != null && (this.groupOrder == 1 || this.groupOrder == 2)) {
                sortRole = 3;
                sortOrder = this.groupOrder == 1 ? 1 : 2;
                numericGroup = gVar instanceof NumericVariable;
            }
            double[] slopes = scol >= 0 ? this.getSubsettedDoubleColumn((short)30, sortRole, numericGroup, sortOrder) : null;
            double[] xints = xcol >= 0 ? this.getSubsettedDoubleColumn((short)10, sortRole, numericGroup, sortOrder) : null;
            double[] yints = ycol >= 0 ? this.getSubsettedDoubleColumn((short)11, sortRole, numericGroup, sortOrder) : null;
            String[] labels = lcol >= 0 ? this.getSubsettedColumnAsClassColumn((short)48, numericLabel, sortRole, numericGroup, sortOrder) : null;
            String[] sgs = gcol >= 0 && gVar instanceof StringVariable ? this.getSubsettedStringColumn((short)3, sortRole, numericGroup, sortOrder) : null;
            double[] dArray = ngs = gcol >= 0 && gVar instanceof NumericVariable ? this.getSubsettedDoubleColumn((short)3, sortRole, numericGroup, sortOrder) : null;
            int num = xints != null ? xints.length : (yints != null ? yints.length : slopes.length);
            ArrayList<FitLineOverlay> al = new ArrayList<FitLineOverlay>(num);
            this.lines = new FitLineOverlay[1];
            Object g = null;
            this.numLines = 0;
            for (int i = 0; i < num; ++i) {
                String cl;
                if (gVar != null && (g = gVar instanceof StringVariable ? sgs[i] : (Double.isNaN(ngs[i]) ? null : new Double(ngs[i]))) == null && !this.missingGroupOn) continue;
                double s = scol >= 0 ? slopes[i] : this.constantSlope;
                double x = xcol >= 0 ? xints[i] : this.constantX;
                double y = ycol >= 0 ? yints[i] : this.constantY;
                String string = cl = lcol >= 0 ? labels[i] : null;
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                ++this.numLines;
                FitLineOverlay fit = new FitLineOverlay();
                fit.setXInterceptBased(false);
                fit.setXValue(x);
                fit.setYValue(y);
                if (Double.isNaN(s)) {
                    s = Double.MAX_VALUE;
                    y = Double.NaN;
                }
                fit.setDefaultSlope(s);
                if (!Double.isNaN(x) && !Double.isNaN(y)) {
                    fit.setDefaultIntercept(y -= s * x);
                } else if (!Double.isNaN(y)) {
                    fit.setDefaultIntercept(y);
                } else if (!Double.isNaN(x)) {
                    fit.setXInterceptBased(true);
                    fit.setDefaultIntercept(x);
                }
                fit.setCurveLabelString(cl);
                fit.setExtreme(false);
                if (idLabel != null) {
                    fit.setProbeIDLabel(idLabel);
                    fit.setProbeID(this.getGroupLabel(g));
                    fit.setLegendLabel(this.getGroupLabel(g));
                }
                int gidx = this.getGroupIndex(gVar, g);
                if (missingGroupIndex >= 0 && missingGroupIndex < gidx) {
                    --gidx;
                }
                fit.getLineStyle().setColor(this.groupLineColors[gidx]);
                fit.getLineStyle().setLinePattern(this.groupLineStyles[gidx].getLinePattern());
                fit.getLineStyle().setWidth(this.groupLineStyles[gidx].getWidth());
                al.add(fit);
            }
            this.lines = al.toArray(this.lines);
        } else {
            this.groupLineColors = new Color[]{this.lColors[this.cCnt % this.lColors.length]};
            this.groupLineStyles = new LineAttrs[]{this.lStyles[this.lCnt % this.lStyles.length]};
            this.lines = new FitLineOverlay[1];
            FitLineOverlay fit = new FitLineOverlay();
            fit.setLegendLabel(this.legendLabel);
            fit.setXInterceptBased(false);
            fit.setExtreme(false);
            fit.getLineStyle().setColor(this.lColors[this.cCnt % this.lColors.length]);
            LineAttrs lstyle = this.lStyles[this.lCnt % this.lStyles.length];
            fit.getLineStyle().setLinePattern(lstyle.getLinePattern());
            this.lines[0] = fit;
        }
        if (this.getDataTransparency() != 0.0) {
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) continue;
                this.lines[i].setDataTransparency(this.getDataTransparency());
            }
        }
    }

    public void setConstantSlope(double s) {
        this.constantSlope = s;
    }

    public void setConstantX(double x) {
        this.constantX = x;
    }

    public void setConstantY(double y) {
        this.constantY = y;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double offset = 0.0;
        for (int i = 0; i < this.numLines; ++i) {
            offset = Math.max(offset, this.lines[i].getPreferredOffset(dimension));
        }
        return offset;
    }

    public void setRotateXCurveLabels(boolean b) {
        this.rotateXCurveLabels = b;
    }

    public void setRotateX2CurveLabels(boolean b) {
        this.rotateX2CurveLabels = b;
    }

    public void addXBBoxes(ArrayList xb, ArrayList x2b) {
        int yu;
        int yl;
        int xu;
        int xl;
        PositionEncoder xEncoder = (PositionEncoder)this.lines[0].getEncoder((byte)1);
        PositionEncoder yEncoder = (PositionEncoder)this.lines[0].getEncoder((byte)2);
        if (this.lines[0].isExtreme()) {
            xl = (int)xEncoder.getLowerLimit();
            xu = (int)xEncoder.getUpperLimit();
            yl = (int)yEncoder.getLowerLimit();
            yu = (int)yEncoder.getUpperLimit();
        } else {
            xl = (int)xEncoder.getOutputMin();
            xu = (int)xEncoder.getOutputMax();
            yl = (int)yEncoder.getOutputMin();
            yu = (int)yEncoder.getOutputMax();
        }
        Rectangle bounds = new Rectangle(xl, yl, xu - xl, yu - yl);
        Polygon px = new Polygon();
        Polygon px2 = new Polygon();
        Polygon py = new Polygon();
        Polygon py2 = new Polygon();
        CurveGraph.getPartitions(bounds, px, px2, py, py2);
        FontMetrics fm = StatGraph.getFontMetrics(this.lines[0].getLabelStyle().getFont());
        this.setClipRect(bounds);
        boolean required = true;
        if (this.curveLabelClosestAxis == null) {
            this.curveLabelClosestAxis = new IntegerVector();
        } else {
            required = false;
        }
        for (int i = 0; i < this.numLines; ++i) {
            int axis;
            double yend;
            double xend;
            String cLabel;
            if (this.needConnect) {
                this.lines[i].connectNetwork();
                this.lines[i].needConnect = true;
            }
            if ((cLabel = this.curveLabelSplit ? this.lines[i].getSplitCurveLabelString() : this.lines[i].getCurveLabelString()) == null) {
                cLabel = "";
            }
            if (this.lines[i].getLabelPosition() == 1.0) {
                xend = this.lines[i].line.endX.getValue();
                yend = this.lines[i].line.endY.getValue();
            } else {
                xend = this.lines[i].line.beginX.getValue();
                yend = this.lines[i].line.beginY.getValue();
            }
            if (required) {
                axis = CurveGraph.closestAxis((int)xend, (int)yend, px, px2, py, py2);
                this.curveLabelClosestAxis.addValue(axis);
            } else {
                int prev_axis = -1;
                try {
                    prev_axis = this.curveLabelClosestAxis.getValue(i);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (prev_axis >= 0) {
                    axis = prev_axis;
                } else {
                    axis = CurveGraph.closestAxis((int)xend, (int)yend, px, px2, py, py2);
                    this.curveLabelClosestAxis.setValueAt(axis, i);
                }
            }
            if (cLabel.length() <= 0) continue;
            if (axis == 0) {
                if (this.curveLabelSplit) {
                    xb.add(new Rectangle((int)xend, 0, LineParmOverlay.getTextWidth(fm, cLabel), 3));
                    continue;
                }
                xb.add(new Rectangle((int)xend, 0, fm.stringWidth(" " + cLabel + " "), 3));
                continue;
            }
            if (axis != 1) continue;
            if (this.curveLabelSplit) {
                x2b.add(new Rectangle((int)xend, 0, LineParmOverlay.getTextWidth(fm, cLabel), 3));
                continue;
            }
            x2b.add(new Rectangle((int)xend, 0, fm.stringWidth(" " + cLabel + " "), 3));
        }
    }

    private Insets getLabelMargin() {
        int yu;
        int yl;
        int xu;
        int xl;
        Insets labelMargin = new Insets(0, 0, 0, 0);
        PositionEncoder xEncoder = (PositionEncoder)this.lines[0].getEncoder((byte)1);
        PositionEncoder yEncoder = (PositionEncoder)this.lines[0].getEncoder((byte)2);
        if (this.lines[0].isExtreme()) {
            xl = (int)xEncoder.getLowerLimit();
            xu = (int)xEncoder.getUpperLimit();
            yl = (int)yEncoder.getLowerLimit();
            yu = (int)yEncoder.getUpperLimit();
        } else {
            xl = (int)xEncoder.getOutputMin();
            xu = (int)xEncoder.getOutputMax();
            yl = (int)yEncoder.getOutputMin();
            yu = (int)yEncoder.getOutputMax();
        }
        Rectangle bounds = new Rectangle(xl, yl, xu - xl, yu - yl);
        Polygon px = new Polygon();
        Polygon px2 = new Polygon();
        Polygon py = new Polygon();
        Polygon py2 = new Polygon();
        CurveGraph.getPartitions(bounds, px, px2, py, py2);
        FontMetrics fm = StatGraph.getFontMetrics(this.lines[0].getLabelStyle().getFont());
        this.setClipRect(bounds);
        double ra = Math.toRadians(CurveGraph.rotationAngle);
        boolean required = true;
        if (this.curveLabelClosestAxis == null) {
            this.curveLabelClosestAxis = new IntegerVector();
        } else {
            required = false;
        }
        block8: for (int i = 0; i < this.numLines; ++i) {
            int axis;
            double yend;
            double xend;
            String cLabel;
            if (this.needConnect) {
                this.lines[i].connectNetwork();
                this.lines[i].needConnect = true;
            }
            if ((cLabel = this.curveLabelSplit ? this.lines[i].getSplitCurveLabelString() : this.lines[i].getCurveLabelString()) == null) {
                cLabel = "";
            }
            if (this.lines[i].getLabelPosition() == 1.0) {
                if (xEncoder.isReversed()) {
                    xend = this.lines[i].line.beginX.getValue();
                    yend = this.lines[i].line.beginY.getValue();
                } else {
                    xend = this.lines[i].line.endX.getValue();
                    yend = this.lines[i].line.endY.getValue();
                }
            } else if (xEncoder.isReversed()) {
                xend = this.lines[i].line.endX.getValue();
                yend = this.lines[i].line.endY.getValue();
            } else {
                xend = this.lines[i].line.beginX.getValue();
                yend = this.lines[i].line.beginY.getValue();
            }
            if (required) {
                axis = CurveGraph.closestAxis((int)xend, (int)yend, px, px2, py, py2);
                this.curveLabelClosestAxis.addValue(axis);
            } else {
                int prev_axis = -1;
                try {
                    prev_axis = this.curveLabelClosestAxis.getValue(i);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (prev_axis >= 0) {
                    axis = prev_axis;
                } else {
                    axis = CurveGraph.closestAxis((int)xend, (int)yend, px, px2, py, py2);
                    this.curveLabelClosestAxis.setValueAt(axis, i);
                }
            }
            int tw = cLabel.length() == 0 ? 0 : LineParmOverlay.getTextWidth(fm, " " + cLabel + " ");
            int th = cLabel.length() == 0 ? 0 : LineParmOverlay.getTextHeight(fm, " " + cLabel + " ");
            switch (axis) {
                case 0: {
                    if (this.rotateXCurveLabels) {
                        labelMargin.bottom = Math.max(labelMargin.bottom, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3);
                        continue block8;
                    }
                    labelMargin.bottom = Math.max(labelMargin.bottom, th + 3);
                    continue block8;
                }
                case 1: {
                    if (this.rotateX2CurveLabels) {
                        labelMargin.top = Math.max(labelMargin.top, (int)((double)tw * Math.sin(ra) + 0.5 * (double)th * Math.cos(ra)) + 3);
                        continue block8;
                    }
                    labelMargin.top = Math.max(labelMargin.top, th + 3);
                    continue block8;
                }
                case 2: {
                    labelMargin.left = Math.max(labelMargin.left, tw + 3);
                    continue block8;
                }
                case 3: {
                    labelMargin.right = Math.max(labelMargin.right, tw + 3);
                }
            }
        }
        return labelMargin;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        Insets pim = super.getPreferredInnerMargin();
        if (!this.preserveInsideLabelSpace || this.curveLabelLocation == 1) {
            return pim;
        }
        boolean labeled = false;
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lines[i].getCurveLabelString() == null) continue;
            labeled = true;
            break;
        }
        if (!labeled) {
            return pim;
        }
        Insets lm = this.getLabelMargin();
        pim.left = Math.max(pim.left, lm.left);
        pim.right = Math.max(pim.right, lm.right);
        pim.top = Math.max(pim.top, lm.top);
        pim.bottom = Math.max(pim.bottom, lm.bottom);
        return pim;
    }

    @Override
    public Insets getPreferredOuterMargin() {
        if (!this.isCurveLabeled()) {
            return zeroInsets;
        }
        return this.getLabelMargin();
    }

    public int getNumberOfGroups() {
        return this.nGroups;
    }

    private int getGroupIndex(Variable gvar, Object value) {
        if (gvar == null) {
            return 0;
        }
        SASFormat format = this.getFormat(3);
        int num = gvar.getUniqueValueCount();
        int index = -1;
        for (int i = 0; i < num; ++i) {
            try {
                Object fmtValue;
                Object fmtObj;
                Object obj = gvar instanceof StringVariable ? ((StringVariable)gvar).uniqueValue.getValue(i) : new Double(((NumericVariable)gvar).uniqueValue.getValue(i));
                if (format != null) {
                    fmtObj = format.format(obj);
                    fmtValue = value == null ? null : format.format(value);
                } else {
                    fmtObj = obj;
                    fmtValue = value;
                }
                if (!fmtObj.equals(fmtValue)) continue;
                return i;
            }
            catch (MissingValueException e) {
                if (value != null && (!(value instanceof String) || !((String)value).trim().equals(""))) continue;
                return i;
            }
        }
        return index;
    }

    private int getFirstOccurringValueIndex(Variable var, int uniqueValueIndex) {
        if (var == null) {
            return 0;
        }
        int index = var instanceof StringVariable ? ((StringVariable)var).getFirstOccurringValueIndex(uniqueValueIndex) : ((NumericVariable)var).getFirstOccurringValueIndex(uniqueValueIndex);
        return index;
    }

    private String getGroupLabel(Object value) {
        if (value == null) {
            return this.model.getColumnClass(3) == Double.class ? StatGraph.missingOption : StatGraph.missingCharacter;
        }
        SASFormat format = this.getFormat(3);
        return format == null ? value.toString() : format.format(value);
    }

    @Override
    public void updateNetworkElements() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].updateNetworkElements();
        }
    }

    @Override
    public void updateCurveLabelElements() {
        if (this.isCurveLabeled()) {
            int n = this.curveLabelClosestAxis.getValueCount();
            for (int i = 0; i < n; ++i) {
                this.curveLabelClosestAxis.setValueAt(-1, i);
            }
            this.updateNetworkElements();
            this.connectOutsideLabel();
        }
    }

    @Override
    public boolean connectNetwork() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].connectNetwork();
        }
        if (this.isCurveLabeled()) {
            this.connectOutsideLabel();
            this.needConnect = false;
        }
        return true;
    }

    private void connectOutsideLabel() {
        Object[] cLabels = new String[this.numLines];
        double[] xEnds = new double[this.numLines];
        double[] yEnds = new double[this.numLines];
        ColorVector cv = new ColorVector();
        PositionEncoder xEncoder = (PositionEncoder)this.lines[0].getEncoder((byte)1);
        for (int i = 0; i < this.numLines; ++i) {
            cLabels[i] = this.lines[i].getCurveLabelString();
            if (this.lines[i].isUseLabelColor()) {
                cv.addValue(this.lines[i].getLabelStyle().getColor());
            } else {
                cv.addValue(this.lines[i].getLineStyle().getColor());
            }
            if (this.lines[i].getLabelPosition() == 1.0) {
                if (xEncoder.isReversed()) {
                    xEnds[i] = this.lines[i].line.beginX.getValue();
                    yEnds[i] = this.lines[i].line.beginY.getValue();
                    continue;
                }
                xEnds[i] = this.lines[i].line.endX.getValue();
                yEnds[i] = this.lines[i].line.endY.getValue();
                continue;
            }
            if (xEncoder.isReversed()) {
                xEnds[i] = this.lines[i].line.endX.getValue();
                yEnds[i] = this.lines[i].line.endY.getValue();
                continue;
            }
            xEnds[i] = this.lines[i].line.beginX.getValue();
            yEnds[i] = this.lines[i].line.beginY.getValue();
        }
        if (this.curveLabelSplit) {
            cLabels = this.splitCurveLabels(cLabels, StatGraph.getFontMetrics(this.lines[0].getLabelStyle().getFont()), true);
        }
        StringVectorVariable clVar = new StringVectorVariable();
        clVar.connectFrom((String[])cLabels);
        NumericVectorVariable xEndVar = new NumericVectorVariable();
        xEndVar.connectFrom(xEnds);
        NumericVectorVariable yEndVar = new NumericVectorVariable();
        yEndVar.connectFrom(yEnds);
        RasterLabel boundaryLabel = new RasterLabel();
        this.networkRoot2 = new NetworkRoot(this.lines[0].getNetworkRoot().getChannel());
        this.networkRoot2.addElement((Element)boundaryLabel);
        this.clLayout.x.connectFrom(xEndVar.value);
        this.clLayout.y.connectFrom(yEndVar.value);
        this.clLayout.label.connectFrom(clVar.value);
        this.clLayout.color.connectFrom((ColorPipe)cv);
        this.clLayout.closestAxis.connectFrom((IntegerPipe)this.curveLabelClosestAxis);
        boundaryLabel.transform.translateX.connectFrom(this.makeCurveLabelXOffset(this.clLayout.xout, this.clLayout.hAlign, cLabels.length));
        boundaryLabel.transform.translateY.connectFrom(this.clLayout.yout);
        boundaryLabel.horizontalJustification.connectFrom(this.makeCurveLabelHJustification(this.clLayout.hAlign));
        boundaryLabel.verticalJustification.connectFrom(this.clLayout.vAlign);
        boundaryLabel.string.connectFrom((StringPipe)this.clLayout.labelOut);
        boundaryLabel.color.connectFrom((ColorPipe)this.clLayout.labelColor);
        Font fnt = this.lines[0].getLabelStyle().getFont();
        boundaryLabel.fontName.setValue(fnt.getFamily());
        boundaryLabel.fontStyle.setValue(fnt.getStyle());
        boundaryLabel.fontSize.setValue(fnt.getSize());
        boundaryLabel.angle.connectFrom((NumericPipe)this.clLayout.angle);
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (!this.labelProtected) {
            return;
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.lines[i].addObstacles(lp, l, yOutputRange);
        }
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return 10;
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        return super.getLegendItems(attrType);
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 11: {
                return this.groupLineColors != null && this.groupLineColors.length > 0 && !this.isFixedLineColor();
            }
            case 3: {
                return !this.isFixedLinePattern();
            }
            case 4: {
                return !this.useLineThickness;
            }
        }
        return false;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        LineAttrs ls = new LineAttrs(this.lStyles[0]);
        ls.setColor(this.lColors[0]);
        return ls;
    }

    public LineAttrs getMissingLineAttrs() {
        return this.missingLineAttrs;
    }

    public void setMissingLineAttrs(LineAttrs missingLineAttrs) {
        this.missingLineAttrs = missingLineAttrs;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return this.model == null || this.model.getSrcMap().getColumn(3) < 0;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        int col = this.model.getSrcMap().getColumn(3);
        ColumnMetadata cmd = (ColumnMetadata)this.model.getSrcModel().getColumnLabel(col);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }

    public boolean isColorPriority() {
        return this.colorPriority;
    }

    public void setColorPriority(boolean colorPriority) {
        this.colorPriority = colorPriority;
    }

    public int getStyleColorCount() {
        return this.styleColorCount;
    }

    public void setStyleColorCount(int styleColorCount) {
        this.styleColorCount = styleColorCount;
    }
}

