/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.BrokenContinuousRangeToNumericMap;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.VisibilityVariable;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Graph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BidirectionalAccumulatorByCategory;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Categorizer;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StatisticByCategory;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.SplineConnector;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class LineChartOverlay
extends Overlay {
    public static final String RB_KEY = "LineChartOverlay.";
    protected DataRange xRange;
    protected DataRange yRange;
    protected DataRange colorRange;
    protected DataRange lineColorRange;
    protected DataRange lineRange;
    protected DataRange shapeRange;
    protected DataRange shapeColorRange;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected ShapeEncoder shapeEncoder;
    protected ColorEncoder shapeColorEncoder;
    protected ColorEncoder shapeFillColorEncoder;
    private NetworkRoot networkRoot;
    private Variable categoryVar;
    private NumericVariable responseVar;
    protected Variable groupVar;
    protected Variable gIndexVar;
    protected Variable colorVar;
    protected Variable lineColorVar;
    protected Variable lineVar;
    protected Variable shapeVar;
    protected Variable shapeColorVar;
    protected Variable shapeFillColorVar;
    private NumericVariable[] multiResponseVars = null;
    private NumericVariable numericCategoryVar;
    private StringVariable stringGroupVar;
    private String[] multiResponseLabels = null;
    private int responseCount = 0;
    private Variable categoryVar_sav;
    private boolean numericCategory = false;
    private boolean numericGroup = false;
    private boolean subset;
    private int[] subsetObs;
    private int subsetObsCount;
    private int statistic = 6;
    private int connectionOrder = 0;
    protected double discreteOffset = 0.0;
    private boolean vertical = true;
    private boolean fillOn = false;
    private boolean lineOn = true;
    private boolean markerOn = false;
    private boolean vertexLabelOn = false;
    private boolean baselineOn = false;
    private FillAttrs fillStyle = new FillAttrs();
    private LineAttrs lineStyle = new LineAttrs();
    private LineAttrs baselineStyle = new LineAttrs();
    private MarkerAttrs markerStyle = new MarkerAttrs();
    private TextAttrs labelStyle = new TextAttrs();
    private boolean useLabelColor = false;
    private SASFormat labelFormat = null;
    private boolean smooth = false;
    private boolean breakMissing = false;
    private double baseline = 0.0;
    public static final double DEFAULT_CLUSTER_WIDTH = 0.85;
    private double clusterWidth = 0.85;
    public static final byte CLUSTER = 0;
    public static final byte OVERLAY = 1;
    public static final byte STACKED = 2;
    private int groupDisplay = 1;
    private int[] groupsPerCategory;
    private String overlayID;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    public static final int BASELINE_AUTO = 0;
    public static final int BASELINE_NUMBER = 1;
    public static final int BASELINE_AXISMIN = 2;
    public static final int BASELINE_AXISMINEXTEND = 3;
    public static final int BASELINE_AXISMAX = 4;
    public static final int BASELINE_AXISMAXEXTEND = 5;
    private int baselineInterceptType = 0;
    private boolean filledOutlinedMarker = false;
    private FillAttrs markerFillStyle = new FillAttrs();
    private LineAttrs markerOutlineStyle = new LineAttrs();
    private boolean useMarkerAttrsColor = false;
    private boolean useMarkerFillAttrsColor = false;
    private boolean useMarkerOutlineAttrsColor = false;
    private boolean useMarkerOutlineAttrsThickness = false;
    private boolean gradientColor = false;

    public void setFilledOutlinedMarker(boolean b) {
        this.filledOutlinedMarker = b;
    }

    public boolean isFilledOutlinedMarker() {
        return this.filledOutlinedMarker;
    }

    public void setMarkerFillStyle(FillAttrs fa) {
        this.markerFillStyle = fa;
    }

    public FillAttrs getMarkerFillStyle() {
        return this.markerFillStyle;
    }

    public void setMarkerOutlineStyle(LineAttrs la) {
        this.markerOutlineStyle = la;
    }

    public LineAttrs getMarkerOutlineStyle() {
        return this.markerOutlineStyle;
    }

    public void setUseMarkerAttrsColor(boolean b) {
        this.useMarkerAttrsColor = b;
    }

    public boolean isUseMarkerAttrsColor() {
        return this.useMarkerAttrsColor;
    }

    public void setUseMarkerFillAttrsColor(boolean b) {
        this.useMarkerFillAttrsColor = b;
    }

    public boolean isUseMarkerFillAttrsColor() {
        return this.useMarkerFillAttrsColor;
    }

    public void setUseMarkerOutlineAttrsColor(boolean b) {
        this.useMarkerOutlineAttrsColor = b;
    }

    public boolean isUseMarkerOutlineAttrsColor() {
        return this.useMarkerOutlineAttrsColor;
    }

    public void setUseMarkerOutlineAttrsThickness(boolean b) {
        this.useMarkerOutlineAttrsThickness = b;
    }

    public boolean isUseMarkerOutlineAttrsThickness() {
        return this.useMarkerOutlineAttrsThickness;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    public double getBaseline() {
        return this.baseline;
    }

    public void setBaseline(double d) {
        this.baseline = d;
    }

    public int getBaselineInterceptType() {
        return this.baselineInterceptType;
    }

    public void setBaselineInterceptType(int t) {
        this.baselineInterceptType = t;
    }

    public boolean isVertexLabelOn() {
        return this.vertexLabelOn;
    }

    public void setVertexLabelOn(boolean b) {
        this.vertexLabelOn = b;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public void setSmooth(boolean b) {
        this.smooth = b;
    }

    public boolean isBreakMissing() {
        return this.breakMissing;
    }

    public void setBreakMissing(boolean b) {
        this.breakMissing = b;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean b) {
        this.vertical = b;
    }

    public boolean isMarkerOn() {
        return this.markerOn;
    }

    public void setMarkerOn(boolean b) {
        this.markerOn = b;
    }

    public boolean isLineOn() {
        return this.lineOn;
    }

    public void setLineOn(boolean b) {
        this.lineOn = b;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public boolean isBaselineOn() {
        return this.baselineOn;
    }

    public void setBaselineOn(boolean b) {
        this.baselineOn = b;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    public void setUseLabelColor(boolean b) {
        this.useLabelColor = b;
    }

    public void setLabelFormat(SASFormat fmt) {
        this.labelFormat = fmt;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(LineAttrs ls) {
        this.lineStyle = ls;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setMarkerStyle(MarkerAttrs ms) {
        this.markerStyle = ms;
    }

    public MarkerAttrs getMarkerStyle() {
        return this.markerStyle;
    }

    public void setLabelStyle(TextAttrs ls) {
        this.labelStyle = ls;
    }

    public TextAttrs getLabelStyle() {
        return this.labelStyle;
    }

    public LineAttrs getBaselineStyle() {
        return this.baselineStyle;
    }

    public void setBaselineStyle(LineAttrs style) {
        this.baselineStyle = style;
    }

    public void setClusterWidth(double width) {
        this.clusterWidth = width;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public void setGroupDisplay(int display) {
        this.groupDisplay = display;
    }

    public int getGroupDisplay() {
        return this.groupDisplay;
    }

    public void setDiscreteOffset(double offset) {
        this.discreteOffset = offset;
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int stat) {
        this.statistic = stat;
    }

    public boolean isMultiResponse() {
        return this.responseCount > 0;
    }

    public void setResponseCount(int n) {
        this.responseCount = n;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 6) {
            if (!(encoder instanceof ShapeEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeEncoder)) {
                return;
            }
            this.shapeEncoder = (ShapeEncoder)encoder;
        } else if (dimension == 16) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeColorEncoder)) {
                return;
            }
            this.shapeColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 24) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeFillColorEncoder)) {
                return;
            }
            this.shapeFillColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 15: {
                return this.lineRange;
            }
            case 17: {
                return this.lineColorRange;
            }
            case 4: {
                return this.colorRange;
            }
            case 6: {
                return this.shapeRange;
            }
            case 16: {
                return this.shapeColorRange;
            }
        }
        return null;
    }

    protected DataRange getIndRange() {
        Object range = null;
        if (this.categoryVar != null) {
            int num = this.categoryVar.getUniqueValueCount();
            if (num > 0) {
                boolean subset = this.vertical ? !this.xUnionAllPages : !this.yUnionAllPages;
                range = this.numericCategoryVar == null ? this.makeDiscreteRange((StringVariable)this.categoryVar, num, (short)1, subset) : this.makeOrdinalRange((StringVariable)this.categoryVar, num, this.numericCategoryVar, (short)1, subset);
                range.setLabel(this.categoryVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    private DataRange getDepRange() {
        if (this.groupDisplay == 2 && (this.groupVar != null || this.isMultiResponse())) {
            this.baselineOn = false;
            this.baseline = 0.0;
            this.baselineInterceptType = 1;
        }
        DataRange range = null;
        if (this.isMultiResponse()) {
            range = this.groupDisplay == 2 ? this.getStackedMultiResponseRange() : this.getMultiResponseRange();
            range = this.mergeRangeWithBaseline(range);
            String label = this.multiResponseLabels[0];
            for (int i = 1; i < this.multiResponseLabels.length; ++i) {
                label = label + " / " + this.multiResponseLabels[i];
            }
            range.setLabel(label);
        } else if (this.responseVar != null) {
            int num = this.responseVar.getValueCount();
            if (num > 0) {
                boolean unionAll = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
                range = unionAll ? this.getUnionAllDepRange(2, this.responseVar.getLabel()) : this.getSubsettedDepRange(this.responseVar);
                range = this.mergeRangeWithBaseline(range);
                range.setLabel(this.responseVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    private DataRange mergeRangeWithBaseline(DataRange range) {
        if (this.baselineInterceptType != 1) {
            return range;
        }
        if (range != null) {
            double min = ((ContinuousRange)range).getMin();
            double max = ((ContinuousRange)range).getMax();
            if (min == Double.MAX_VALUE || max == -1.7976931348623157E308) {
                return range;
            }
            range = new ContinuousRange(Math.min(min, this.baseline), Math.max(max, this.baseline));
        }
        return range;
    }

    private DataRange getMultiResponseRange() {
        ContinuousRange range;
        boolean unionAll = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.multiResponseVars.length; ++i) {
            NumericVariable rVar = this.multiResponseVars[i];
            int num = rVar.getValueCount();
            if (num <= 0) continue;
            range = unionAll ? (ContinuousRange)this.getUnionAllDepRange(610 + i, null) : (ContinuousRange)this.getSubsettedDepRange(rVar);
            min = Math.min(min, range.getMin());
            max = Math.max(max, range.getMax());
        }
        range = new ContinuousRange(min, max);
        return range;
    }

    private double[] getMinMaxValues(StatisticByCategory stat, int nobs) {
        stat.init(new AInitAction(null));
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < nobs; ++i) {
            try {
                double v = stat.getValue(i);
                min = Math.min(v, min);
                max = Math.max(v, max);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return new double[]{min, max};
    }

    private DataRange getSubsettedDepRange(NumericVariable respVar) {
        boolean multiResp = respVar == null;
        ContinuousRange range = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        vp.addGroupVariable(this.categoryVar);
        if (this.groupVar != null) {
            vp.addGroupVariable(this.groupVar);
        }
        if (multiResp) {
            for (int i = 0; i < this.multiResponseVars.length; ++i) {
                vp.addVariable((Variable)this.multiResponseVars[i], this.statistic);
            }
        } else {
            vp.addVariable((Variable)respVar, this.statistic);
        }
        this.addCRDWhereClause(vp);
        if (multiResp) {
            this.preProcessVars();
            respVar = this.responseVar;
        }
        if (this.groupVar == null) {
            min = respVar.getMin();
            max = respVar.getMax();
        } else if (this.groupDisplay == 2) {
            BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
            accumEnd.category.connectFrom(((StringVariable)this.categoryVar).category);
            accumEnd.input.connectFrom(respVar.value);
            accumEnd.setPostAccumulate(false);
            double[] minMax = accumEnd.getAccumulation();
            min = minMax[0];
            max = minMax[1];
        } else {
            StatisticByCategory stat = new StatisticByCategory();
            stat.setStatistic(6);
            Categorizer cat = new Categorizer();
            cat.addVariable(this.categoryVar);
            cat.addVariable(this.groupVar);
            stat.category.connectFrom(cat.category);
            stat.input.connectFrom(respVar.value);
            double[] minMax = this.getMinMaxValues(stat, this.categoryVar.getValueCount());
            min = minMax[0];
            max = minMax[1];
        }
        range = respVar.getValueCount() == 0 ? new ContinuousRange(Double.MAX_VALUE, -1.7976931348623157E308) : new ContinuousRange(min, max);
        range.setLabel(respVar.getLabel());
        if (multiResp) {
            this.postProcessVars();
        }
        return range;
    }

    private DataRange getUnionAllDepRange(int respRole, String respLabel) {
        int i;
        double[] count;
        int n;
        boolean Y2;
        ContinuousRange range = null;
        boolean X2 = !this.getXAxis().equalsIgnoreCase("X");
        boolean bl = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (this.vertical) {
            if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
                range.setLabel(respLabel);
                return range;
            }
            if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
                range.setLabel(respLabel);
                return range;
            }
        } else {
            if (!X2 && !Double.isNaN(this.model.getSrcModel().computedXMin) && !Double.isNaN(this.model.getSrcModel().computedXMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedXMin, this.model.getSrcModel().computedXMax);
                range.setLabel(respLabel);
                return range;
            }
            if (X2 && !Double.isNaN(this.model.getSrcModel().computedX2Min) && !Double.isNaN(this.model.getSrcModel().computedX2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedX2Min, this.model.getSrcModel().computedX2Max);
                range.setLabel(respLabel);
                return range;
            }
        }
        Variable tempCategoryVar = this.connectCategory((short)1, true);
        NumericVectorVariable tempResponseVar = new NumericVectorVariable();
        Variable tempGroupVar = null;
        if (StatGraph.isOLAP()) {
            tempCategoryVar = StatGraph.getOLAPLevelVar(this.model, (short)1);
            if (this.model.isAvailable(respRole)) {
                tempResponseVar = StatGraph.getOLAPMeasureVar(this.model, (short)respRole);
            } else {
                n = tempCategoryVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar = new NumericVectorVariable();
                tempResponseVar.connectFrom(count);
            }
            if (this.groupVar != null) {
                tempGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
            }
        } else {
            if (this.model.isAvailable(respRole)) {
                tempResponseVar.connectFrom(this.model.getDoubleColumn(respRole));
            } else {
                n = tempCategoryVar.getValueCount();
                count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar.connectFrom(count);
            }
            if (this.groupVar != null) {
                tempGroupVar = this.connectCategory((short)3, true);
            }
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (this.vertical) {
            if (Y2) {
                if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                    min = Math.min(min, this.model.getSrcModel().computedY2Min);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                    max = Math.max(max, this.model.getSrcModel().computedY2Max);
                }
            } else {
                if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                    min = Math.min(min, this.model.getSrcModel().computedYMin);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                    max = Math.max(max, this.model.getSrcModel().computedYMax);
                }
            }
        } else if (X2) {
            if (!Double.isNaN(this.model.getSrcModel().computedX2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedX2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedX2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedX2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedXMin)) {
                min = Math.min(min, this.model.getSrcModel().computedXMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedXMax)) {
                max = Math.max(max, this.model.getSrcModel().computedXMax);
            }
        }
        for (int i2 = 0; i2 < this.model.allWhereExpressions.length; ++i2) {
            if (this.model.allWhereExpressions[i2] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            vp.addGroupVariable(tempCategoryVar);
            if (tempGroupVar != null) {
                vp.addGroupVariable(tempGroupVar);
            }
            vp.addVariable((Variable)tempResponseVar, this.statistic);
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i2] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i2]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            if (tempResponseVar.getValueCount() == 0) continue;
            int respCount = tempResponseVar.getValueCount();
            boolean allMissing = true;
            for (int j = 0; j < respCount; ++j) {
                try {
                    tempResponseVar.value.getValue(j);
                    allMissing = false;
                    break;
                }
                catch (MissingValueException missingValueException) {
                    continue;
                }
            }
            if (allMissing) continue;
            if (tempGroupVar == null) {
                min = Math.min(min, tempResponseVar.getMin());
                max = Math.max(max, tempResponseVar.getMax());
                continue;
            }
            if (this.groupDisplay == 2) {
                BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
                accumEnd.category.connectFrom(((StringVariable)tempCategoryVar).category);
                accumEnd.input.connectFrom(tempResponseVar.value);
                accumEnd.setPostAccumulate(false);
                double[] minMax = accumEnd.getAccumulation();
                min = Math.min(min, minMax[0]);
                max = Math.max(max, minMax[1]);
                continue;
            }
            StatisticByCategory stat = new StatisticByCategory();
            stat.setStatistic(6);
            Categorizer cat = new Categorizer();
            cat.addVariable(tempCategoryVar);
            cat.addVariable(tempGroupVar);
            stat.category.connectFrom(cat.category);
            stat.input.connectFrom(tempResponseVar.value);
            double[] minMax = this.getMinMaxValues(stat, tempCategoryVar.getValueCount());
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (this.vertical) {
            if (Y2) {
                this.model.getSrcModel().computedY2Min = min;
                this.model.getSrcModel().computedY2Max = max;
            } else {
                this.model.getSrcModel().computedYMin = min;
                this.model.getSrcModel().computedYMax = max;
            }
        } else if (X2) {
            this.model.getSrcModel().computedX2Min = min;
            this.model.getSrcModel().computedX2Max = max;
        } else {
            this.model.getSrcModel().computedXMin = min;
            this.model.getSrcModel().computedXMax = max;
        }
        range = new ContinuousRange(min, max);
        range.setLabel(respLabel);
        return range;
    }

    private DataRange getStackedMultiResponseRange() {
        boolean Y2;
        boolean unionAll;
        boolean bl = unionAll = this.vertical ? this.yUnionAllPages : this.xUnionAllPages;
        if (!unionAll) {
            return this.getSubsettedDepRange(null);
        }
        ContinuousRange range = null;
        boolean X2 = !this.getXAxis().equalsIgnoreCase("X");
        boolean bl2 = Y2 = !this.getYAxis().equalsIgnoreCase("Y");
        if (this.vertical) {
            if (!Y2 && !Double.isNaN(this.model.getSrcModel().computedYMin) && !Double.isNaN(this.model.getSrcModel().computedYMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedYMin, this.model.getSrcModel().computedYMax);
                return range;
            }
            if (Y2 && !Double.isNaN(this.model.getSrcModel().computedY2Min) && !Double.isNaN(this.model.getSrcModel().computedY2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedY2Min, this.model.getSrcModel().computedY2Max);
                return range;
            }
        } else {
            if (!X2 && !Double.isNaN(this.model.getSrcModel().computedXMin) && !Double.isNaN(this.model.getSrcModel().computedXMax) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedXMin, this.model.getSrcModel().computedXMax);
                return range;
            }
            if (X2 && !Double.isNaN(this.model.getSrcModel().computedX2Min) && !Double.isNaN(this.model.getSrcModel().computedX2Max) && this.model.getSrcModel().minMaxComputed) {
                range = new ContinuousRange(this.model.getSrcModel().computedX2Min, this.model.getSrcModel().computedX2Max);
                return range;
            }
        }
        Variable tempCategoryVar_sav = this.connectCategory((short)1, true);
        NumericVariable[] tempMultiResponseVars = new NumericVariable[this.responseCount];
        for (int i = 0; i < this.responseCount; ++i) {
            tempMultiResponseVars[i] = new NumericVectorVariable();
            if (StatGraph.isOLAP()) {
                tempMultiResponseVars[i] = StatGraph.getOLAPMeasureVar(this.model, (short)(610 + i));
                continue;
            }
            ((NumericVectorVariable)tempMultiResponseVars[i]).connectFrom(this.model.getDoubleColumn(610 + i));
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (this.vertical) {
            if (Y2) {
                if (!Double.isNaN(this.model.getSrcModel().computedY2Min)) {
                    min = Math.min(min, this.model.getSrcModel().computedY2Min);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedY2Max)) {
                    max = Math.max(max, this.model.getSrcModel().computedY2Max);
                }
            } else {
                if (!Double.isNaN(this.model.getSrcModel().computedYMin)) {
                    min = Math.min(min, this.model.getSrcModel().computedYMin);
                }
                if (!Double.isNaN(this.model.getSrcModel().computedYMax)) {
                    max = Math.max(max, this.model.getSrcModel().computedYMax);
                }
            }
        } else if (X2) {
            if (!Double.isNaN(this.model.getSrcModel().computedX2Min)) {
                min = Math.min(min, this.model.getSrcModel().computedX2Min);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedX2Max)) {
                max = Math.max(max, this.model.getSrcModel().computedX2Max);
            }
        } else {
            if (!Double.isNaN(this.model.getSrcModel().computedXMin)) {
                min = Math.min(min, this.model.getSrcModel().computedXMin);
            }
            if (!Double.isNaN(this.model.getSrcModel().computedXMax)) {
                max = Math.max(max, this.model.getSrcModel().computedXMax);
            }
        }
        for (int i = 0; i < this.model.allWhereExpressions.length; ++i) {
            int n;
            if (this.model.allWhereExpressions[i] == null) continue;
            VariableProcessor vp = new VariableProcessor();
            if (this.subset) {
                vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
            }
            vp.addGroupVariable(tempCategoryVar_sav);
            for (int r = 0; r < this.responseCount; ++r) {
                vp.addVariable((Variable)tempMultiResponseVars[r], this.statistic);
            }
            for (int j = 0; j < this.model.whereVars.length; ++j) {
                StringVectorVariable sv;
                if (this.model.whereVars[j] == null) continue;
                Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                if (this.model.whereVarsOnSeparateModel) {
                    DataModel dm = this.model.getSrcModel();
                    int wcol = dm.getColumn(this.model.whereVars[j].getName());
                    sv.setName(this.model.whereVars[j].getName());
                    sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                } else {
                    sv.connectFrom(this.model.whereVars[j]);
                }
                vp.addVariable((Variable)sv);
            }
            String curWhere = vp.getWhereExpression();
            if (curWhere != null) {
                vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i] + ")");
            } else {
                vp.setWhereExpression(this.model.allWhereExpressions[i]);
            }
            if (!vp.isWhereExpressionValid()) {
                StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
            }
            if ((n = ((StringVariable)tempCategoryVar_sav).getValueCount()) == 0) continue;
            int nResp = this.multiResponseVars.length;
            int rows = n * nResp;
            String[] cats = new String[rows];
            double[] resps = new double[rows];
            String[] grps = new String[rows];
            for (int r = 0; r < nResp; ++r) {
                int offset = r * n;
                for (int j = 0; j < n; ++j) {
                    try {
                        cats[offset + j] = ((StringVariable)tempCategoryVar_sav).value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        cats[offset + j] = null;
                    }
                    try {
                        resps[offset + j] = tempMultiResponseVars[r].value.getValue(j);
                    }
                    catch (MissingValueException e) {
                        resps[offset + j] = Double.NaN;
                    }
                    grps[offset + j] = this.multiResponseVars[r].getLabel();
                }
            }
            StringVectorVariable tempCategoryVar = new StringVectorVariable();
            tempCategoryVar.connectFrom(cats);
            NumericVectorVariable tempResponseVar = new NumericVectorVariable();
            tempResponseVar.connectFrom(resps);
            StringVectorVariable tempGroupVar = new StringVectorVariable();
            tempGroupVar.connectFrom(grps);
            if (this.groupDisplay == 2) {
                BidirectionalAccumulatorByCategory accumEnd = new BidirectionalAccumulatorByCategory();
                accumEnd.category.connectFrom(tempCategoryVar.category);
                accumEnd.input.connectFrom(tempResponseVar.value);
                accumEnd.setPostAccumulate(false);
                double[] minMax = accumEnd.getAccumulation();
                min = Math.min(min, minMax[0]);
                max = Math.max(max, minMax[1]);
                continue;
            }
            StatisticByCategory stat = new StatisticByCategory();
            stat.setStatistic(6);
            Categorizer cat = new Categorizer();
            cat.addVariable((Variable)tempCategoryVar);
            cat.addVariable((Variable)tempGroupVar);
            stat.category.connectFrom(cat.category);
            stat.input.connectFrom(tempResponseVar.value);
            double[] minMax = this.getMinMaxValues(stat, tempCategoryVar.getValueCount());
            min = Math.min(min, minMax[0]);
            max = Math.max(max, minMax[1]);
        }
        if (this.vertical) {
            if (Y2) {
                this.model.getSrcModel().computedY2Min = min;
                this.model.getSrcModel().computedY2Max = max;
            } else {
                this.model.getSrcModel().computedYMin = min;
                this.model.getSrcModel().computedYMax = max;
            }
        } else if (X2) {
            this.model.getSrcModel().computedX2Min = min;
            this.model.getSrcModel().computedX2Max = max;
        } else {
            this.model.getSrcModel().computedXMin = min;
            this.model.getSrcModel().computedXMax = max;
        }
        range = new ContinuousRange(min, max);
        return range;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateColorRange();
        this.updateLineColorRange();
        this.updateLineRange();
        this.updateShapeRange();
        this.updateShapeColorRange();
        this.updateNumberOfGroupPerCategory();
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        if (this.groupVar == null || this.groupDisplay == 1) {
            return;
        }
        StringVariable catvar = new StringVariable();
        catvar.connectFrom((StringVariable)this.categoryVar);
        StringVariable gvar = new StringVariable();
        if (this.groupVar instanceof NumericVariable) {
            gvar.connectFrom((NumericVariable)this.groupVar);
        } else {
            gvar.connectFrom((StringVariable)this.groupVar);
        }
        VariableProcessor vp = new VariableProcessor();
        vp.addGroupVariable((Variable)catvar);
        vp.addVariable((Variable)gvar, 0);
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)1) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        if ((numCats = catvar.getUniqueValueCount()) == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        int gCount = 1;
        int gIdx = 0;
        String catV = null;
        boolean missingFirst = false;
        for (int i = 0; i < catvar.getValueCount(); ++i) {
            try {
                String xv = catvar.value.getValue(i);
                if (catV == null) {
                    catV = xv;
                    if (!missingFirst) continue;
                    ++gIdx;
                    continue;
                }
                if (xv.equals(catV)) {
                    ++gCount;
                    continue;
                }
                this.groupsPerCategory[gIdx] = gCount;
                if (gCount > maxGroups) {
                    maxGroups = gCount;
                }
                ++gIdx;
                gCount = 1;
                catV = xv;
                continue;
            }
            catch (MissingValueException e) {
                if (catV != null) {
                    this.groupsPerCategory[gIdx] = gCount;
                    if (gCount > maxGroups) {
                        maxGroups = gCount;
                    }
                    ++gIdx;
                    gCount = 1;
                    catV = null;
                    continue;
                }
                if (gIdx != 0) continue;
                missingFirst = true;
            }
        }
        this.groupsPerCategory[gIdx] = gCount;
        if (gCount > maxGroups) {
            maxGroups = gCount;
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        ArrayList[] list;
        block12: {
            int i4;
            int nCat;
            block11: {
                String[] gvalues = this.getGroupValues();
                nCat = ((StringVariable)this.categoryVar).getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i2 = 0; i2 < nCat; ++i2) {
                    list[i2] = new ArrayList();
                }
                int nGrp = this.groupVar.getUniqueValueCount();
                this.subToColumnGroupCategory = new int[nGrp];
                this.stringGroupVar.getUniqueValueCount();
                HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
                for (int i3 = 0; i3 < nGrp; ++i3) {
                    try {
                        if (this.groupOrder == 0) {
                            String v = this.stringGroupVar.uniqueValue.getValue(i3);
                            int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                            value2ColumnCategory.put(v, new Integer(groupCategory_column));
                            this.subToColumnGroupCategory[i3] = groupCategory_column;
                            continue;
                        }
                        this.subToColumnGroupCategory[i3] = i3;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
                IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
                IntegerPipe category = ((StringVariable)this.categoryVar).category;
                int n = ((StringVariable)this.categoryVar).getValueCount();
                try {
                    for (i4 = 0; i4 < n; ++i4) {
                        Integer IG;
                        int cat = category.getValue(i4);
                        if (list[cat].contains(IG = new Integer(groupCategory.getValue(i4)))) continue;
                        list[cat].add(IG);
                    }
                }
                catch (MissingValueException i4) {
                    // empty catch block
                }
                if (this.groupOrder != 1 && this.groupOrder != 2) break block11;
                for (i4 = 0; i4 < nCat; ++i4) {
                    Collections.sort(list[i4]);
                }
                break block12;
            }
            if (this.groupOrder != 3) break block12;
            for (i4 = 0; i4 < nCat; ++i4) {
                ArrayList ll = new ArrayList();
                for (int j = list[i4].size() - 1; j >= 0; --j) {
                    ll.add(list[i4].get(j));
                }
                list[i4] = ll;
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    protected void connectVars() {
        if (StatGraph.isOLAP()) {
            this.connectOLAPVars();
            return;
        }
        CRD crd = this.model;
        Variable catMissingControlVar = null;
        if (crd.isAvailable(1)) {
            this.numericCategory = crd.getColumnClass(1) == Double.class;
            this.categoryVar = this.connectCategory((short)1, this.missingCategoryOn);
            if (this.numericCategory) {
                this.numericCategoryVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.numericCategoryVar).connectFrom(crd.getDoubleColumn(1));
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(1)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericCategoryVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (!this.missingCategoryOn) {
                catMissingControlVar = this.connectRaw((short)1);
            }
            this.connectionOrder = this.vertical ? 1 : 2;
        } else {
            this.categoryVar = null;
        }
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i = 0; i < this.responseCount; ++i) {
                if (!crd.isAvailable(610 + i)) continue;
                this.multiResponseVars[i] = (NumericVectorVariable)this.connectRaw((short)(610 + i));
                this.multiResponseLabels[i] = this.multiResponseVars[i].getLabel();
            }
            if (this.groupOrder != 0) {
                this.sortMultiResponseLabels();
            }
        } else if (crd.isAvailable(2)) {
            this.responseVar = (NumericVectorVariable)this.connectRaw((short)2);
        } else {
            String name = this.statistic == 2 ? RB.getStringResource("Overlay.", "frequency.txt") : (this.statistic == 13 ? RB.getStringResource("Overlay.", "percent.txt") : RB.getStringResource("Overlay.", "proportion.txt"));
            int n = this.categoryVar.getValueCount();
            double[] count = new double[n];
            for (int i = 0; i < n; ++i) {
                count[i] = 1.0;
            }
            this.responseVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.responseVar).connectFrom(count);
            this.responseVar.setLabel(name);
        }
        if (this.gradientColor) {
            if (this.isFillOn()) {
                this.colorVar = this.connectRaw((short)6);
            } else {
                this.lineColorVar = this.connectRaw((short)46);
            }
        } else {
            this.colorVar = crd.isAvailable(6) ? this.connectCategory((short)6, true) : null;
            this.lineColorVar = crd.isAvailable(46) ? this.connectCategory((short)46, true) : null;
        }
        this.lineVar = crd.isAvailable(36) ? this.connectCategory((short)36, true) : null;
        this.shapeColorVar = crd.isAvailable(45) ? this.connectCategory((short)45, true) : null;
        this.shapeFillColorVar = crd.isAvailable(69) ? this.connectCategory((short)69, true) : null;
        this.shapeVar = crd.isAvailable(8) ? this.connectCategory((short)8, true) : null;
        if (crd.isAvailable(3)) {
            this.numericGroup = crd.getColumnClass(3) == Double.class;
            this.groupVar = this.connectRaw((short)3);
            this.groupVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.stringGroupVar = (StringVariable)this.connectCategory((short)3, true);
        } else {
            this.groupVar = null;
        }
        this.gIndexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        Variable urlVar = this.connectCategory((short)52, false);
        this.labelVisibleVar = new VisibilityVariable();
        this.subset = false;
        if (catMissingControlVar != null || this.groupVar != null && !this.missingGroupOn) {
            int count = catMissingControlVar != null ? catMissingControlVar.getValueCount() : this.groupVar.getValueCount();
            this.subsetObs = new int[count];
            this.subsetObsCount = 0;
            for (int i = 0; i < count; ++i) {
                if (catMissingControlVar != null && this.groupVar != null && !this.missingGroupOn) {
                    if (catMissingControlVar.isMissing(i) || this.groupVar.isMissing(i)) continue;
                    this.subsetObs[this.subsetObsCount++] = i;
                    continue;
                }
                if (catMissingControlVar != null) {
                    if (catMissingControlVar.isMissing(i)) continue;
                    this.subsetObs[this.subsetObsCount++] = i;
                    continue;
                }
                if (this.groupVar == null || this.missingGroupOn || this.groupVar.isMissing(i)) continue;
                this.subsetObs[this.subsetObsCount++] = i;
            }
            if (this.subsetObsCount < count) {
                this.subset = true;
            } else {
                this.subsetObs = null;
            }
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        vp.addGroupVariable(this.categoryVar);
        if (this.numericCategoryVar != null) {
            vp.addGroupVariable((Variable)this.numericCategoryVar);
        }
        if (this.groupVar != null) {
            vp.addVariable(this.groupVar, 0);
            vp.addGroupVariable(this.groupVar);
            if (this.getGroupOrder() == 1) {
                this.groupVar.setUniqueValueSort(1);
                if (this.isDrawByGroupOrder()) {
                    vp.setSort(this.groupVar, 1);
                }
            } else if (this.getGroupOrder() == 2) {
                this.groupVar.setUniqueValueSort(2);
                if (this.isDrawByGroupOrder()) {
                    vp.setSort(this.groupVar, 2);
                }
            }
            this.groupVar.setSortByFormattedValues(!this.numericGroup);
            vp.addVariable((Variable)this.stringGroupVar, 0);
        }
        if (this.isMultiResponse()) {
            for (int i = 0; i < this.multiResponseVars.length; ++i) {
                vp.addVariable((Variable)this.multiResponseVars[i], this.statistic);
            }
        } else {
            vp.addVariable((Variable)this.responseVar, this.statistic);
        }
        this.addVarToVP(vp, this.colorVar);
        this.addVarToVP(vp, this.lineColorVar);
        this.addVarToVP(vp, this.lineVar);
        this.addVarToVP(vp, this.shapeColorVar);
        this.addVarToVP(vp, this.shapeFillColorVar);
        this.addVarToVP(vp, this.shapeVar);
        this.addVarToVP(vp, urlVar);
        if (this.gIndexVar != null) {
            vp.addVariable(this.gIndexVar, 0);
        }
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.groupVar != null && this.missingGroupOn) {
            this.probe.setMissingReplacement(this.groupVar instanceof NumericVariable ? StatGraph.missingOption : StatGraph.missingCharacter);
        }
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else if (!this.isMultiResponse()) {
            if (this.categoryVar != null) {
                this.probe.addPipe(this.categoryVar.getLabel(), (Pipe)((StringVariable)this.categoryVar).value);
            }
            if (crd.isAvailable(2)) {
                this.addTooltip(vp, "RESPONSE", this.probe, this.statistic);
            } else if (this.statistic == 2) {
                this.probe.addPipe(RB.getStringResource("Overlay.", "frequency.txt"), (Pipe)this.responseVar.value);
            } else if (this.statistic == 13) {
                this.probe.addPipe(RB.getStringResource("Overlay.", "percent.txt"), (Pipe)this.responseVar.value);
            } else {
                this.probe.addPipe(RB.getStringResource("Overlay.", "proportion.txt"), (Pipe)this.responseVar.value);
            }
            if (this.groupVar != null) {
                this.addTooltip(vp, "GROUP", this.probe, 0);
            }
        }
    }

    private void sortMultiResponseLabels() {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < this.responseCount; ++i) {
            list.add(this.multiResponseLabels[i]);
        }
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            Collections.sort(list);
        }
        for (i = 0; i < this.responseCount; ++i) {
            if (this.groupOrder == 1) {
                this.multiResponseLabels[i] = (String)list.get(i);
                continue;
            }
            this.multiResponseLabels[this.responseCount - 1 - i] = (String)list.get(i);
        }
    }

    public boolean isDataValid() {
        if (this.groupDisplay != 2 || this.groupVar == null && !this.isMultiResponse()) {
            return true;
        }
        if (this.isMultiResponse()) {
            int i;
            NumericVariable[] tempMultiResponseVars = new NumericVariable[this.responseCount];
            for (i = 0; i < this.responseCount; ++i) {
                tempMultiResponseVars[i] = new NumericVectorVariable();
                if (StatGraph.isOLAP()) {
                    tempMultiResponseVars[i] = StatGraph.getOLAPMeasureVar(this.model, (short)(610 + i));
                    continue;
                }
                ((NumericVectorVariable)tempMultiResponseVars[i]).connectFrom(this.model.getDoubleColumn(610 + i));
            }
            for (i = 0; i < this.responseCount; ++i) {
                if (!(tempMultiResponseVars[i].getMin() < 0.0)) continue;
                return false;
            }
            Variable tempCategoryVar = this.connectCategory((short)1, this.missingCategoryOn);
            if (StatGraph.isOLAP()) {
                tempCategoryVar = StatGraph.getOLAPLevelVar(this.model, (short)1);
            }
            if (this.model.allWhereExpressions == null || this.model.allWhereExpressions.length == 0) {
                VariableProcessor vp = new VariableProcessor();
                if (this.subset) {
                    vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                }
                vp.addGroupVariable(tempCategoryVar);
                for (int r = 0; r < this.responseCount; ++r) {
                    vp.addVariable((Variable)tempMultiResponseVars[r], this.statistic);
                }
                for (int i2 = 0; i2 < this.responseCount; ++i2) {
                    int n = tempMultiResponseVars[i2].getValueCount();
                    try {
                        for (int j = 0; j < n; ++j) {
                            tempMultiResponseVars[i2].value.getValue(j);
                        }
                        continue;
                    }
                    catch (MissingValueException e) {
                        return false;
                    }
                }
            } else {
                for (int i3 = 0; i3 < this.model.allWhereExpressions.length; ++i3) {
                    if (this.model.allWhereExpressions[i3] == null) continue;
                    VariableProcessor vp = new VariableProcessor();
                    if (this.subset) {
                        vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                    }
                    vp.addGroupVariable(tempCategoryVar);
                    for (int r = 0; r < this.responseCount; ++r) {
                        vp.addVariable((Variable)tempMultiResponseVars[r], this.statistic);
                    }
                    for (int j = 0; j < this.model.whereVars.length; ++j) {
                        if (this.model.whereVars[j] == null) continue;
                        StringVariable sv = new StringVariable();
                        sv.connectFrom(this.model.whereVars[j]);
                        vp.addVariable((Variable)sv);
                    }
                    String curWhere = vp.getWhereExpression();
                    if (curWhere != null) {
                        vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i3] + ")");
                    } else {
                        vp.setWhereExpression(this.model.allWhereExpressions[i3]);
                    }
                    if (!vp.isWhereExpressionValid()) {
                        StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                    }
                    if (tempCategoryVar.getValueCount() == 0) continue;
                    for (int r = 0; r < this.responseCount; ++r) {
                        int n = tempMultiResponseVars[r].getValueCount();
                        try {
                            for (int j = 0; j < n; ++j) {
                                tempMultiResponseVars[r].value.getValue(j);
                            }
                            continue;
                        }
                        catch (MissingValueException e) {
                            return false;
                        }
                    }
                }
            }
        } else {
            int i;
            NumericVectorVariable tempResponseVar = null;
            if (StatGraph.isOLAP()) {
                if (this.model.isAvailable(2)) {
                    tempResponseVar = StatGraph.getOLAPMeasureVar(this.model, (short)2);
                }
            } else if (this.model.isAvailable(2)) {
                tempResponseVar = new NumericVectorVariable();
                tempResponseVar.connectFrom(this.model.getDoubleColumn(2));
            }
            if (tempResponseVar != null && tempResponseVar.getMin() < 0.0) {
                return false;
            }
            Variable tempCategoryVar = this.connectCategory((short)1, this.missingCategoryOn);
            Variable tempGroupVar = this.connectCategory((short)3, this.missingGroupOn);
            if (StatGraph.isOLAP()) {
                tempCategoryVar = StatGraph.getOLAPLevelVar(this.model, (short)1);
                tempGroupVar = StatGraph.getOLAPLevelVar(this.model, (short)3);
            }
            if (tempResponseVar == null) {
                int n = tempCategoryVar.getValueCount();
                double[] count = new double[n];
                for (i = 0; i < n; ++i) {
                    count[i] = 1.0;
                }
                tempResponseVar = new NumericVectorVariable();
                tempResponseVar.connectFrom(count);
            }
            if (this.model.allWhereExpressions == null || this.model.allWhereExpressions.length == 0) {
                VariableProcessor vp = new VariableProcessor();
                if (this.subset) {
                    vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                }
                vp.addGroupVariable(tempCategoryVar);
                vp.addGroupVariable(tempGroupVar);
                vp.addVariable((Variable)tempResponseVar, this.statistic);
                if (tempGroupVar.getUniqueValueCount() * tempCategoryVar.getUniqueValueCount() != tempCategoryVar.getValueCount()) {
                    return false;
                }
                int n = tempResponseVar.getValueCount();
                try {
                    for (i = 0; i < n; ++i) {
                        tempResponseVar.value.getValue(i);
                    }
                }
                catch (MissingValueException e) {
                    return false;
                }
            } else {
                for (int i4 = 0; i4 < this.model.allWhereExpressions.length; ++i4) {
                    if (this.model.allWhereExpressions[i4] == null) continue;
                    VariableProcessor vp = new VariableProcessor();
                    if (this.subset) {
                        vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
                    }
                    vp.addGroupVariable(tempCategoryVar);
                    vp.addGroupVariable(tempGroupVar);
                    vp.addVariable((Variable)tempResponseVar, this.statistic);
                    for (int j = 0; j < this.model.whereVars.length; ++j) {
                        StringVectorVariable sv;
                        if (this.model.whereVars[j] == null) continue;
                        Object object = sv = this.model.whereVarsOnSeparateModel ? new StringVectorVariable() : new StringVariable();
                        if (this.model.whereVarsOnSeparateModel) {
                            DataModel dm = this.model.getSrcModel();
                            int wcol = dm.getColumn(this.model.whereVars[j].getName());
                            sv.setName(this.model.whereVars[j].getName());
                            sv.connectFrom(dm.getColumnAsClassColumn(wcol, this.model.whereIncludeMissingClass));
                        } else {
                            sv.connectFrom(this.model.whereVars[j]);
                        }
                        vp.addVariable((Variable)sv);
                    }
                    String curWhere = vp.getWhereExpression();
                    if (curWhere != null) {
                        vp.setWhereExpression("(" + curWhere + ") & (" + this.model.allWhereExpressions[i4] + ")");
                    } else {
                        vp.setWhereExpression(this.model.allWhereExpressions[i4]);
                    }
                    if (!vp.isWhereExpressionValid()) {
                        StatGraph.printDebug("Invalid where cluase: " + vp.getWhereExpression());
                    }
                    if (tempCategoryVar.getValueCount() == 0) continue;
                    if (tempGroupVar.getUniqueValueCount() * tempCategoryVar.getUniqueValueCount() != tempCategoryVar.getValueCount()) {
                        return false;
                    }
                    int n = tempResponseVar.getValueCount();
                    try {
                        for (int j = 0; j < n; ++j) {
                            tempResponseVar.value.getValue(j);
                        }
                        continue;
                    }
                    catch (MissingValueException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.vertical) {
            newRange = this.getIndRange();
            this.setFormat(newRange, 1);
        } else {
            newRange = this.getDepRange();
            if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, newRange);
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.vertical) {
            newRange = this.getDepRange();
            if (this.isMultiResponse()) {
                this.setFormat(newRange, 610);
            } else {
                this.setFormat(newRange, 2);
            }
        } else {
            newRange = this.getIndRange();
            this.setFormat(newRange, 1);
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updateColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.colorVar != null) {
            if (this.gradientColor) {
                double min = this.model.getColumnMin((short)6);
                double max = this.model.getColumnMax((short)6);
                newRange = new ContinuousRange(min, max);
                newRange.setLabel(this.colorVar.getLabel());
                this.setFormat((DataRange)newRange, 6);
            } else {
                int num = this.colorVar.getUniqueValueCount();
                if (num > 0) {
                    newRange = Overlay.makeDiscreteRange((StringVariable)this.colorVar, num);
                    newRange.setLabel(this.colorVar.getLabel());
                } else {
                    newRange = null;
                }
            }
        }
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    protected void updateLineColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineColorRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.lineColorVar != null) {
            if (this.gradientColor) {
                double min = this.model.getColumnMin((short)46);
                double max = this.model.getColumnMax((short)46);
                newRange = new ContinuousRange(min, max);
                newRange.setLabel(this.lineColorVar.getLabel());
                this.setFormat((DataRange)newRange, 46);
            } else {
                int num = this.lineColorVar.getUniqueValueCount();
                if (num > 0) {
                    newRange = Overlay.makeDiscreteRange((StringVariable)this.lineColorVar, num);
                    newRange.setLabel(this.lineColorVar.getLabel());
                } else {
                    newRange = null;
                }
            }
        }
        this.lineColorRange = newRange;
        this.fireRangeEvent((byte)17, oldRange, (DataRange)newRange);
    }

    protected void updateLineRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.lineVar != null) {
            int num = this.lineVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineVar, num);
                newRange.setLabel(this.lineVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineRange = newRange;
        this.fireRangeEvent((byte)15, oldRange, (DataRange)newRange);
    }

    protected void updateShapeRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.shapeRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.shapeVar != null) {
            int num = this.shapeVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.shapeVar, num);
                newRange.setLabel(this.shapeVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.shapeRange = newRange;
        this.fireRangeEvent((byte)6, oldRange, (DataRange)newRange);
    }

    protected void updateShapeColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.shapeColorRange;
        if (this.isMultiResponse()) {
            newRange = new DiscreteRange((Object[])this.multiResponseLabels);
        } else if (this.shapeColorVar != null) {
            int num = this.shapeColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.shapeColorVar, num);
                newRange.setLabel(this.shapeColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.shapeColorRange = newRange;
        this.fireRangeEvent((byte)16, oldRange, (DataRange)newRange);
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (this.groupVar != null && this.groupVar.getValueCount() > 0 || this.isMultiResponse()) {
            return;
        }
        GeneralPath obstacle = new GeneralPath();
        lp.addObstacle(obstacle);
        for (int j = 0; j < l.getValueCount(); ++j) {
            try {
                double xpos = l.x.getValue(j);
                double ypos = (double)yOutputRange - l.y.getValue(j);
                Graph.addObstaclePoint(obstacle, (int)xpos, (int)ypos);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean connectNetwork() {
        DiscreteAttrMapper groupAttrMapper;
        String gval;
        int i;
        NumericPipe categoryPipe;
        GTKFormat gtkFMT;
        SASFormat format;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xRange == null && this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        VariableProcessor vp = new VariableProcessor();
        if (this.subset) {
            vp.setSubsetByObservation(this.subsetObs, this.subsetObsCount);
        }
        this.categoryVar.setUniqueValueSort(0);
        vp.addGroupVariable(this.categoryVar);
        if (this.groupVar != null) {
            vp.addVariable(this.groupVar, 0);
            vp.addGroupVariable(this.groupVar);
            if (this.getGroupOrder() == 1) {
                this.groupVar.setUniqueValueSort(1);
            } else if (this.getGroupOrder() == 2) {
                this.groupVar.setUniqueValueSort(2);
            }
            this.groupVar.setSortByFormattedValues(!this.numericGroup);
            vp.addVariable((Variable)this.stringGroupVar, 0);
        }
        if (this.isMultiResponse()) {
            for (int i2 = 0; i2 < this.multiResponseVars.length; ++i2) {
                vp.addVariable((Variable)this.multiResponseVars[i2], this.statistic);
            }
        } else {
            vp.addVariable((Variable)this.responseVar, this.statistic);
        }
        if (this.lineColorVar != null) {
            vp.addVariable(this.lineColorVar);
        }
        if (this.lineVar != null) {
            vp.addVariable(this.lineVar);
        }
        if (this.colorVar != null) {
            vp.addVariable(this.colorVar);
        }
        if (this.shapeVar != null) {
            vp.addVariable(this.shapeVar);
        }
        if (this.shapeColorVar != null) {
            vp.addVariable(this.shapeColorVar);
        }
        if (this.shapeFillColorVar != null) {
            vp.addVariable(this.shapeFillColorVar);
        }
        if (this.gIndexVar != null) {
            vp.addVariable(this.gIndexVar, 0);
        }
        if (this.gradientColor) {
            if (this.colorVar != null) {
                vp.addVariable(this.colorVar, 12);
            }
            if (this.lineColorVar != null) {
                vp.addVariable(this.lineColorVar, 12);
            }
        }
        this.addCRDWhereClause(vp);
        if (this.isMultiResponse()) {
            this.preProcessVars();
        }
        if ((format = this.xEncoder.getInput().getFormat()) != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.vertical) {
                this.categoryVar.setFormat(gtkFMT);
            } else {
                this.responseVar.setFormat(gtkFMT);
            }
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            gtkFMT = new GTKFormat((Format)format);
            if (this.vertical) {
                this.responseVar.setFormat(gtkFMT);
            } else {
                this.categoryVar.setFormat(gtkFMT);
            }
        }
        ValueMap map = null;
        PositionEncoder ve = this.vertical ? this.xEncoder : this.yEncoder;
        map = ve.getValueMap();
        if (!(map instanceof StringToNumericMap)) {
            return false;
        }
        StringVariable sortedCategoryVar = new StringVariable();
        sortedCategoryVar.connectFrom((StringVariable)this.categoryVar);
        StringToNumericMapper categoryMapper = new StringToNumericMapper();
        categoryMapper.setMap((StringToNumericMap)map);
        categoryMapper.input.connectFrom(sortedCategoryVar.value);
        double stride = ((StringToNumericMap)map).getStrideValue();
        double discreteOffsetValue = this.discreteOffset * stride;
        if (ve.isReversed()) {
            discreteOffsetValue = -discreteOffsetValue;
        }
        if (this.groupVar != null && this.groupDisplay == 0) {
            NumericVector groupPosition = new NumericVector();
            int maxGroups = this.isMultiResponse() ? this.responseCount : (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            StringVariable catVar = (StringVariable)this.categoryVar;
            double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            catVar.getUniqueValueCount();
            this.groupVar.getUniqueValueCount();
            for (int i3 = 0; i3 < catVar.getValueCount(); ++i3) {
                try {
                    int category = catVar.category.getValue(i3);
                    double offset = categoryMapper.getValue(i3);
                    int groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i3) : ((StringVariable)this.groupVar).category.getValue(i3);
                    if (this.isMultiResponse()) {
                        offset -= (double)((int)(((double)maxGroups / 2.0 - 0.5) * groupSize));
                        offset += groupSize * (double)groupCategory;
                    } else {
                        offset -= (double)((int)(((double)this.groupsPerCategory[category] / 2.0 - 0.5) * groupSize));
                        offset += groupSize * (double)this.groupCategoryLists[category].indexOf(groupCategory);
                    }
                    groupPosition.addValue(offset);
                    continue;
                }
                catch (MissingValueException e) {
                    groupPosition.addValue(Double.NaN);
                }
            }
            categoryPipe = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)groupPosition);
        } else {
            categoryPipe = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)categoryMapper);
        }
        ve = this.vertical ? this.yEncoder : this.xEncoder;
        map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper responseMapper = new ContinuousRangeToNumericMapper();
        responseMapper.setMap((ContinuousRangeToNumericMap)map);
        responseMapper.input.connectFrom(this.responseVar.value);
        ContinuousRangeToNumericMapper responseMapper2 = responseMapper;
        if (ve instanceof BrokenPositionEncoder) {
            BrokenContinuousRangeToNumericMap rmap2 = ((BrokenPositionEncoder)ve).getBrokenValueMap();
            responseMapper2 = new ContinuousRangeToNumericMapper();
            responseMapper2.setMap((ContinuousRangeToNumericMap)rmap2);
            responseMapper2.input.connectFrom(this.responseVar.value);
        }
        double baseVal = this.getBaselineValue();
        ContinuousRangeToNumericMapper baselineMapper = null;
        if (this.baselineOn) {
            baselineMapper = new ContinuousRangeToNumericMapper();
            baselineMapper.setMap((ContinuousRangeToNumericMap)map);
            baselineMapper.input.setValue(baseVal);
        }
        ContinuousRangeToNumericMapper responseMapperUnder = new ContinuousRangeToNumericMapper();
        responseMapperUnder.setMap((ContinuousRangeToNumericMap)map);
        responseMapperUnder.input.setValue(baseVal);
        StringVectorVariable stackedGroupVar = null;
        Probe probe = this.probe;
        if (this.groupVar != null && this.groupDisplay == 2) {
            int n2 = this.groupVar.getUniqueValueCount();
            int[] groupCategoryOrder = new int[n2];
            int[] subGroupCategory = new int[n2];
            for (i = 0; i < n2; ++i) {
                if (this.groupOrder == 3) {
                    groupCategoryOrder[i] = n2 - 1 - i;
                    subGroupCategory[i] = n2 - 1 - i;
                    continue;
                }
                groupCategoryOrder[i] = i;
                subGroupCategory[i] = i;
            }
            int n1 = this.categoryVar.getUniqueValueCount();
            double[] resp = new double[n1 * n2];
            double[] catNo = new double[n1 * n2];
            double[] catOffset = new double[n1];
            int n = this.categoryVar.getValueCount();
            int[] indexLookup = new int[n];
            for (int i4 = 0; i4 < n; ++i4) {
                int c = 0;
                int g = 0;
                int pos = 0;
                try {
                    c = ((StringVariable)this.categoryVar).category.getValue(i4);
                    g = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i4) : ((StringVariable)this.groupVar).category.getValue(i4);
                    pos = groupCategoryOrder[g] * n1 + c;
                    catNo[pos] = c;
                    indexLookup[pos] = i4;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                try {
                    catOffset[c] = categoryPipe.getValue(i4);
                }
                catch (MissingValueException e) {
                    catOffset[c] = Double.NaN;
                }
                try {
                    resp[pos] = this.responseVar.value.getValue(i4);
                    continue;
                }
                catch (MissingValueException e) {
                    resp[pos] = 0.0;
                }
            }
            NumericVectorVariable tempCatNoVar = new NumericVectorVariable();
            tempCatNoVar.connectFrom(catNo);
            NumericVectorVariable tempRespVar = new NumericVectorVariable();
            tempRespVar.connectFrom(resp);
            BidirectionalAccumulatorByCategory lineAccumulator = new BidirectionalAccumulatorByCategory();
            lineAccumulator.category.connectFrom(tempCatNoVar.value);
            lineAccumulator.input.connectFrom(tempRespVar.value);
            lineAccumulator.setPostAccumulate(false);
            BidirectionalAccumulatorByCategory lineAccumulatorUnder = new BidirectionalAccumulatorByCategory();
            lineAccumulatorUnder.category.connectFrom(tempCatNoVar.value);
            lineAccumulatorUnder.input.connectFrom(tempRespVar.value);
            lineAccumulatorUnder.setPostAccumulate(true);
            lineAccumulator.init(new AInitAction(null));
            lineAccumulatorUnder.init(new AInitAction(null));
            NumericVector catOffsetVector = new NumericVector();
            NumericVector respVector = new NumericVector();
            NumericVector respVectorUnder = new NumericVector();
            StringVector groupVector = new StringVector();
            for (int j = 0; j < n2; ++j) {
                try {
                    String grp = this.stringGroupVar.uniqueValue.getValue(subGroupCategory[j]);
                    int offset = j * n1;
                    for (int i5 = 0; i5 < n1; ++i5) {
                        catOffsetVector.addValue(catOffset[i5]);
                        respVector.addValue(lineAccumulator.getValue(offset + i5));
                        respVectorUnder.addValue(lineAccumulatorUnder.getValue(offset + i5));
                        groupVector.addValue(grp);
                    }
                    continue;
                }
                catch (MissingValueException grp) {
                    // empty catch block
                }
            }
            responseMapper.input.connectFrom((NumericPipe)respVector);
            responseMapperUnder.input.connectFrom((NumericPipe)respVectorUnder);
            categoryPipe = catOffsetVector;
            stackedGroupVar = new StringVectorVariable();
            stackedGroupVar.connectFrom((StringPipe)groupVector);
            stackedGroupVar.setBlankMissing(false);
            if (!this.isMultiResponse()) {
                probe = this.rearrangeProbePipes(indexLookup);
            }
        }
        StringToColorMapper colorMapper = null;
        if (this.colorVar != null && this.colorEncoder != null) {
            if (this.gradientColor) {
                ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                crtcm.setMap((ContinuousRangeToColorMap)this.colorEncoder.getValueMap());
                crtcm.input.connectFrom(((NumericVectorVariable)this.colorVar).value);
                colorMapper = crtcm;
            } else {
                map = this.colorEncoder.getValueMap();
                if (map instanceof StringToColorMap) {
                    StringToColorMapper stcm;
                    colorMapper = stcm = new StringToColorMapper();
                    if (stackedGroupVar != null) {
                        stcm.input.connectFrom(stackedGroupVar.value);
                    } else {
                        stcm.input.connectFrom(((StringVariable)this.colorVar).value);
                    }
                    stcm.setReplaceMissingValues(true);
                    if (this.gIndexVar == null) {
                        stcm.setMap((StringToColorMap)map);
                    } else {
                        for (i = 0; i < this.colorVar.getUniqueValueCount(); ++i) {
                            Color c = this.getIndexColor(this.colorEncoder, this.colorVar, i, (ColorAttr)this.fillStyle);
                            try {
                                String gval2 = ((StringVariable)this.colorVar).uniqueValue.getValue(i);
                                stcm.add(gval2, c);
                                continue;
                            }
                            catch (MissingValueException e) {
                                stcm.setMissingReplacement(c, e.getMissingValue());
                            }
                        }
                    }
                } else {
                    return false;
                }
            }
        }
        StringToColorMapper lineColorMapper = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            if (this.gradientColor) {
                ContinuousRangeToColorMapper crtcm = new ContinuousRangeToColorMapper();
                crtcm.setMap((ContinuousRangeToColorMap)this.lineColorEncoder.getValueMap());
                crtcm.input.connectFrom(((NumericVectorVariable)this.lineColorVar).value);
                lineColorMapper = crtcm;
            } else {
                StringToColorMapper stcm = new StringToColorMapper();
                HashMap lcht = this.lineColorEncoder.colorList;
                lineColorMapper = stcm;
                if (stackedGroupVar != null) {
                    stcm.input.connectFrom(stackedGroupVar.value);
                } else {
                    stcm.input.connectFrom(((StringVariable)this.lineColorVar).value);
                }
                stcm.setReplaceMissingValues(true);
                for (int i6 = 0; i6 < this.lineColorVar.getUniqueValueCount(); ++i6) {
                    Color c;
                    if (this.gIndexVar == null) {
                        try {
                            String lcval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i6);
                            c = (Color)lcht.get(lcval);
                        }
                        catch (MissingValueException e) {
                            c = this.applyDataTransparency(this.lineStyle.getColor());
                        }
                    } else {
                        c = this.getIndexColor(this.lineColorEncoder, this.lineColorVar, i6, (ColorAttr)this.lineStyle);
                    }
                    try {
                        String gval3 = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i6);
                        stcm.add(gval3, c);
                        continue;
                    }
                    catch (MissingValueException e) {
                        stcm.setMissingReplacement(c, e.getMissingValue());
                    }
                }
            }
        }
        StringToNumberMapper lineWidthMapper = null;
        StringToNumberMapper linePatternMapper = null;
        if (this.lineVar != null && this.lineEncoder != null) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            lineWidthMapper = new StringToNumberMapper();
            linePatternMapper = new StringToNumberMapper();
            if (stackedGroupVar != null) {
                lineWidthMapper.input.connectFrom(stackedGroupVar.value);
                linePatternMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                lineWidthMapper.input.connectFrom(((StringVariable)this.lineVar).value);
                linePatternMapper.input.connectFrom(((StringVariable)this.lineVar).value);
            }
            lineWidthMapper.setReplaceMissingValues(true);
            lineWidthMapper.setLabelMissingValues(true);
            linePatternMapper.setReplaceMissingValues(true);
            linePatternMapper.setLabelMissingValues(true);
            for (int i7 = 0; i7 < this.lineVar.getUniqueValueCount(); ++i7) {
                LineAttrs ls;
                if (this.gIndexVar == null) {
                    try {
                        String lval = ((StringVariable)this.lineVar).uniqueValue.getValue(i7);
                        ls = (LineAttrs)ht.get(lval);
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                } else {
                    int obs = ((StringVariable)this.lineVar).getFirstOccurringValueIndex(i7);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        ls = ll[idx % ll.length];
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                    }
                }
                try {
                    gval = ((StringVariable)this.lineVar).uniqueValue.getValue(i7);
                    lineWidthMapper.add(gval, (Number)new Double(this.lineStyle.getWidth()));
                    linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                    continue;
                }
                catch (MissingValueException e) {
                    lineWidthMapper.setMissingReplacement((double)this.lineStyle.getWidth(), e.getMissingValue());
                    linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                }
            }
        }
        StringToColorMapper shapeColorMapper = null;
        if (this.shapeColorVar != null && this.shapeColorEncoder != null) {
            HashMap scht = this.shapeColorEncoder.colorList;
            shapeColorMapper = new StringToColorMapper();
            if (stackedGroupVar != null) {
                shapeColorMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeColorMapper.input.connectFrom(((StringVariable)this.shapeColorVar).value);
            }
            shapeColorMapper.setReplaceMissingValues(true);
            for (int i8 = 0; i8 < this.shapeColorVar.getUniqueValueCount(); ++i8) {
                Color c;
                if (this.gIndexVar == null) {
                    try {
                        String scval = ((StringVariable)this.shapeColorVar).uniqueValue.getValue(i8);
                        c = (Color)scht.get(scval);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)this.markerStyle);
                    }
                } else {
                    c = this.getIndexColor(this.shapeColorEncoder, this.shapeColorVar, i8, (ColorAttr)this.markerStyle);
                }
                try {
                    gval = ((StringVariable)this.shapeColorVar).uniqueValue.getValue(i8);
                    shapeColorMapper.add(gval, c);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeColorMapper.setMissingReplacement(c, e.getMissingValue());
                }
            }
        }
        this.markerFillStyle.setTransparency(this.markerStyle.getTransparency());
        StringToColorMapper shapeFillColorMapper = null;
        if (this.shapeFillColorVar != null && this.shapeFillColorEncoder != null) {
            HashMap scht = this.shapeFillColorEncoder.colorList;
            shapeFillColorMapper = new StringToColorMapper();
            if (stackedGroupVar != null) {
                shapeFillColorMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeFillColorMapper.input.connectFrom(((StringVariable)this.shapeFillColorVar).value);
            }
            shapeFillColorMapper.setReplaceMissingValues(true);
            for (int i9 = 0; i9 < this.shapeFillColorVar.getUniqueValueCount(); ++i9) {
                Color c;
                if (this.gIndexVar == null) {
                    try {
                        String scval = ((StringVariable)this.shapeFillColorVar).uniqueValue.getValue(i9);
                        c = (Color)scht.get(scval);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)this.markerFillStyle);
                    }
                } else {
                    c = this.getIndexColor(this.shapeFillColorEncoder, this.shapeFillColorVar, i9, (ColorAttr)this.markerFillStyle);
                }
                try {
                    String gval4 = ((StringVariable)this.shapeFillColorVar).uniqueValue.getValue(i9);
                    shapeFillColorMapper.add(gval4, c);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeFillColorMapper.setMissingReplacement(c, e.getMissingValue());
                }
            }
        }
        StringToNumberMapper shapeMapper = null;
        if (this.shapeVar != null && this.shapeEncoder != null) {
            int[] sl = this.shapeEncoder.shapeArray;
            HashMap scht = this.shapeEncoder.shapeList;
            shapeMapper = new StringToNumberMapper();
            if (stackedGroupVar != null) {
                shapeMapper.input.connectFrom(stackedGroupVar.value);
            } else {
                shapeMapper.input.connectFrom(((StringVariable)this.shapeVar).value);
            }
            shapeMapper.setReplaceMissingValues(true);
            shapeMapper.setLabelMissingValues(true);
            for (int i10 = 0; i10 < this.shapeVar.getUniqueValueCount(); ++i10) {
                int sh;
                if (this.gIndexVar == null) {
                    try {
                        String sval = ((StringVariable)this.shapeVar).uniqueValue.getValue(i10);
                        sh = (Integer)scht.get(sval);
                    }
                    catch (MissingValueException e) {
                        sh = this.markerStyle.getShape();
                    }
                } else {
                    int obs = ((StringVariable)this.shapeVar).getFirstOccurringValueIndex(i10);
                    try {
                        int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
                        sh = sl[idx % sl.length];
                    }
                    catch (MissingValueException e) {
                        sh = this.markerStyle.getShape();
                    }
                }
                try {
                    String gval5 = ((StringVariable)this.shapeVar).uniqueValue.getValue(i10);
                    shapeMapper.add(gval5, (Number)sh);
                    continue;
                }
                catch (MissingValueException e) {
                    shapeMapper.setMissingReplacement((double)sh, e.getMissingValue());
                }
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.setMarkerTransparency(this.markerStyle.getTransparency() < 0.0 ? this.dataTransparency : this.markerStyle.getTransparency());
            groupAttrMapper.setUseMarkerTransparency(this.useMarkerTransparency);
            groupAttrMapper.variable = stackedGroupVar != null ? stackedGroupVar.value : (this.numericGroup ? ((NumericVariable)this.groupVar).formattedValue : ((StringVariable)this.groupVar).formattedValue);
            groupAttrMapper.fillColorMapper = colorMapper;
            groupAttrMapper.lineColorMapper = lineColorMapper;
            groupAttrMapper.linePatternMapper = linePatternMapper;
            groupAttrMapper.markerColorMapper = shapeColorMapper;
            groupAttrMapper.markerSymbolMapper = shapeMapper;
            if (this.filledOutlinedMarker) {
                groupAttrMapper.markerColorMapper = shapeColorMapper;
                groupAttrMapper.markerFillColorMapper = shapeFillColorMapper;
                groupAttrMapper.addLineThicknessPipe("markerOutline", this.markerOutlineStyle.getWidth());
            }
            groupAttrMapper.addLineThicknessPipe("line", this.lineStyle.getWidth());
            groupAttrMapper.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
            groupAttrMapper.addMarkerSizePipe("marker", this.getScaledMarkerSize(this.markerStyle.getSize()));
            if (this.useMarkerSize && !this.useMarkerWeight) {
                groupAttrMapper.addMarkerEdgeThicknessPipe("marker", this.getScaledMarkerSize(this.markerStyle.getSize()), this.markerStyle.getWeight(), true);
            } else {
                groupAttrMapper.addMarkerEdgeThicknessPipe("marker", this.getScaledMarkerSize(this.markerStyle.getSize()), this.markerStyle.getWeight());
            }
            if (this.scaleMarkers) {
                double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
                double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
                groupAttrMapper.setScaleMarkers(true);
                groupAttrMapper.setMinMarkerSize(5);
                groupAttrMapper.setRatioW(ratio_w);
                groupAttrMapper.setRatioH(ratio_h);
            }
        }
        ColorProperty color = new ColorProperty();
        if (this.colorVar != null && colorMapper != null) {
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                double min;
                RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = mapper.createColorMapper(min = ((ContinuousRangeToColorMapper)colorMapper).getInputMin(), max = ((ContinuousRangeToColorMapper)colorMapper).getInputMax(), false);
                if (error != null) {
                    color.connectFrom((ColorPipe)colorMapper);
                    StatGraph.printWarning(error);
                } else {
                    mapper.setTransparency(this.dataTransparency);
                    mapper.variable = ((ContinuousRangeToColorMapper)colorMapper).input;
                    color.connectFrom(mapper.color);
                }
            } else if (groupAttrMapper != null && !this.gradientColor) {
                color.connectFrom(groupAttrMapper.fillColor);
            } else {
                color.connectFrom((ColorPipe)colorMapper);
            }
        } else {
            color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        }
        ColorProperty lineColor = new ColorProperty();
        if (this.lineColorVar != null && lineColorMapper != null) {
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                double min;
                RangeAttrMapper mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = mapper.createColorMapper(min = ((ContinuousRangeToColorMapper)lineColorMapper).getInputMin(), max = ((ContinuousRangeToColorMapper)lineColorMapper).getInputMax(), true);
                if (error != null) {
                    lineColor.connectFrom((ColorPipe)lineColorMapper);
                    StatGraph.printWarning(error);
                } else {
                    mapper.setTransparency(this.dataTransparency);
                    mapper.variable = ((ContinuousRangeToColorMapper)lineColorMapper).input;
                    lineColor.connectFrom(mapper.color);
                }
            } else if (groupAttrMapper != null && !this.gradientColor) {
                lineColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
            } else {
                lineColor.connectFrom((ColorPipe)lineColorMapper);
            }
        } else {
            lineColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        }
        NumericProperty linePattern = new NumericProperty();
        if (this.lineVar != null && linePatternMapper != null) {
            if (groupAttrMapper != null) {
                linePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            } else {
                linePattern.connectFrom((NumericPipe)linePatternMapper);
            }
        } else {
            linePattern.setValue((double)this.lineStyle.getLinePattern());
        }
        NumericProperty lineWidth = new NumericProperty();
        if (!this.useLineThickness && this.hasAttrVar("GROUP")) {
            lineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("line"));
        } else if (this.lineVar != null && lineWidthMapper != null) {
            lineWidth.connectFrom((NumericPipe)lineWidthMapper);
        } else {
            lineWidth.setValue((double)this.lineStyle.getWidth());
        }
        ColorProperty shapeColor = new ColorProperty();
        if (this.gradientColor && !this.fillOn && !this.useMarkerAttrsColor) {
            if (lineColor.getConnection() != null) {
                shapeColor.connectFrom(lineColor.getConnection());
            } else {
                shapeColor.setValue(lineColor.getValue());
            }
        } else if (this.shapeColorVar != null && shapeColorMapper != null) {
            if (this.lineOn && this.lineColorEncoder == null) {
                shapeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency()));
            } else if (groupAttrMapper != null) {
                shapeColor.connectFrom((ColorPipe)groupAttrMapper.markerColor);
            } else {
                shapeColor.connectFrom((ColorPipe)shapeColorMapper);
            }
        } else {
            shapeColor.setValue(this.applyDataTransparency((ColorAttr)this.markerStyle));
        }
        NumericProperty shape = new NumericProperty();
        if (this.shapeVar != null && shapeMapper != null) {
            if (groupAttrMapper != null) {
                shape.connectFrom((IntegerPipe)groupAttrMapper.markerSymbol);
            } else {
                shape.connectFrom((NumericPipe)shapeMapper);
            }
        } else {
            shape.setValue((double)this.markerStyle.getShape());
        }
        ColorProperty labelColor = new ColorProperty();
        labelColor.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
        this.networkRoot.removeAllElements();
        if (this.baselineOn) {
            LineSegment baseline = new LineSegment();
            this.networkRoot.addElement((Element)baseline);
            if (this.vertical) {
                baseline.beginX.setValue(this.xEncoder.getLowerLimit());
                baseline.beginY.connectFrom((NumericPipe)baselineMapper);
                baseline.endX.setValue(this.xEncoder.getUpperLimit());
                baseline.endY.connectFrom((NumericPipe)baselineMapper);
            } else {
                baseline.beginY.setValue(this.yEncoder.getLowerLimit());
                baseline.beginX.connectFrom((NumericPipe)baselineMapper);
                baseline.endY.setValue(this.yEncoder.getUpperLimit());
                baseline.endX.connectFrom((NumericPipe)baselineMapper);
            }
            baseline.color.setValue(this.applyDataTransparency(this.baselineStyle.getColor()));
            baseline.lineWidth.setValue((double)this.baselineStyle.getWidth());
            baseline.setStipple(this.baselineStyle.getStipplePattern(), this.baselineStyle.getStippleFactor());
        }
        if (this.lineOn || this.fillOn) {
            Object lineConnector = null;
            lineConnector = this.smooth ? new SplineConnector() : new LineConnector();
            lineConnector.setSubpixelRendering(this.subpixelRendering);
            this.networkRoot.addElement((Element)lineConnector);
            if (this.vertical) {
                lineConnector.pointX.connectFrom(categoryPipe);
                lineConnector.pointY.connectFrom((NumericPipe)responseMapper);
            } else {
                lineConnector.pointY.connectFrom(categoryPipe);
                lineConnector.pointX.connectFrom((NumericPipe)responseMapper);
                lineConnector.setSkipMissingOnXAxis(true);
            }
            lineConnector.lineOn.setValue(this.lineOn);
            lineConnector.color.connectFrom((ColorPipe)lineColor);
            lineConnector.linePattern.connectFrom((NumericPipe)linePattern);
            lineConnector.lineWidth.connectFrom((NumericPipe)lineWidth);
            lineConnector.fillOn.setValue(this.fillOn);
            lineConnector.fillColor.connectFrom((ColorPipe)color);
            if (this.vertical) {
                lineConnector.pointX2.connectFrom(categoryPipe);
                lineConnector.pointY2.connectFrom((NumericPipe)responseMapperUnder);
            } else {
                lineConnector.pointY2.connectFrom(categoryPipe);
                lineConnector.pointX2.connectFrom((NumericPipe)responseMapperUnder);
            }
            lineConnector.setSkipMissingOn(this.breakMissing);
            lineConnector.setMultipleGroup(true);
            if (this.groupVar != null) {
                if (stackedGroupVar != null) {
                    lineConnector.stringGroup.connectFrom(stackedGroupVar.value);
                } else if (this.groupVar instanceof StringVariable) {
                    lineConnector.stringGroup.connectFrom(((StringVariable)this.groupVar).formattedValue);
                } else {
                    lineConnector.stringGroup.connectFrom(((NumericVariable)this.groupVar).formattedValue);
                }
            }
            lineConnector.setPresortRequired(true);
            lineConnector.setConnectionOrder(this.connectionOrder);
            lineConnector.setSkinType(this.skinType);
            lineConnector.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            lineConnector.setUserData((Object)probe);
        }
        int markerSize = this.markerStyle.getSize();
        if (this.markerOn) {
            markerSize = this.getScaledMarkerSize(markerSize);
            int edgeWidth = StatGraph.getMarkerEdgeWidth(markerSize, this.markerStyle.getWeight());
            Marker marker = new Marker();
            this.networkRoot.addElement((Element)marker);
            marker.setSVGRender(StatGraph.VGF);
            if (this.vertical) {
                marker.coordX.connectFrom(categoryPipe);
                marker.coordY.connectFrom((NumericPipe)responseMapper2);
            } else {
                marker.coordY.connectFrom(categoryPipe);
                marker.coordX.connectFrom((NumericPipe)responseMapper2);
            }
            marker.weightedEdgeEnabled.setValue(false);
            marker.edgeWeight.setValue(this.markerStyle.getWeight());
            marker.type.connectFrom((NumericPipe)shape);
            if (this.useMarkerSize || !this.hasAttrVar("GROUP")) {
                marker.size.setValue(markerSize);
                if (this.hasAttrVar("GROUP") && !this.useMarkerWeight) {
                    marker.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("marker"));
                } else {
                    marker.edgeWidth.setValue(edgeWidth);
                }
            } else {
                marker.size.connectFrom((IntegerPipe)groupAttrMapper.markerSize.get("marker"));
                marker.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("marker"));
            }
            marker.color.connectFrom((ColorPipe)shapeColor);
            marker.edgeColor.connectFrom((ColorPipe)shapeColor);
            marker.setSkinType(this.skinType);
            marker.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            marker.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4));
            marker.setUserData((Object)probe);
            if (this.filledOutlinedMarker) {
                ColorProperty shapeFillColor = new ColorProperty();
                if (this.gradientColor && !this.fillOn && !this.useMarkerFillAttrsColor) {
                    if (lineColor.getConnection() != null) {
                        shapeFillColor.connectFrom(lineColor.getConnection());
                    } else {
                        shapeFillColor.setValue(lineColor.getValue());
                    }
                } else if (this.shapeFillColorVar != null && shapeFillColorMapper != null) {
                    if (groupAttrMapper != null) {
                        shapeFillColor.connectFrom(groupAttrMapper.markerFillColor);
                    } else {
                        shapeFillColor.connectFrom((ColorPipe)shapeFillColorMapper);
                    }
                } else {
                    shapeFillColor.setValue(this.applyDataTransparency((ColorAttr)this.markerFillStyle));
                }
                ColorProperty shapeOutlineColor = new ColorProperty();
                boolean undoAlpha = false;
                if (!this.useMarkerOutlineAttrsColor && this.shapeColorVar != null && shapeColorMapper != null) {
                    if (groupAttrMapper != null && !this.gradientColor) {
                        if (this.lineOn && this.lineColorVar == null) {
                            shapeOutlineColor.connectFrom((ColorPipe)lineColor);
                        } else {
                            shapeOutlineColor.connectFrom((ColorPipe)groupAttrMapper.lineColor);
                        }
                    } else if (this.lineOn) {
                        shapeOutlineColor.connectFrom((ColorPipe)lineColor);
                    } else {
                        shapeOutlineColor.connectFrom((ColorPipe)shapeColorMapper);
                        undoAlpha = true;
                    }
                } else {
                    shapeOutlineColor.setValue(this.applyDataTransparency((ColorAttr)this.markerOutlineStyle));
                }
                marker.type.init(new AInitAction(null));
                marker.color.init(new AInitAction(null));
                marker.edgeColor.init(new AInitAction(null));
                marker.edgeWidth.init(new AInitAction(null));
                marker.size.init(new AInitAction(null));
                shapeFillColor.init(new AInitAction(null));
                shapeOutlineColor.init(new AInitAction(null));
                IntegerVector type = new IntegerVector();
                ColorVector mColor = new ColorVector();
                ColorVector eColor = new ColorVector();
                NumericVector eWidth = new NumericVector();
                NumericVector size = new NumericVector();
                int n = this.categoryVar.getValueCount();
                try {
                    for (int i11 = 0; i11 < n; ++i11) {
                        int s = marker.type.getValue(i11);
                        if (Markers.isFilled((int)s)) {
                            double ew = marker.edgeWidth.getValue(i11);
                            Color fc = shapeFillColor.getValue(i11);
                            Color oc = shapeOutlineColor.getValue(i11);
                            if (undoAlpha) {
                                oc = this.applyNewTransparency(oc, this.markerOutlineStyle.getTransparency());
                            }
                            if (this.useMarkerOutlineAttrsThickness) {
                                if (this.markerOutlineStyle.getWidth() < 1) {
                                    eWidth.addValue(ew);
                                    oc = fc;
                                } else {
                                    eWidth.addValue((double)this.markerOutlineStyle.getWidth());
                                }
                            } else if (groupAttrMapper != null && groupAttrMapper.lineThickness.containsKey("markerOutline")) {
                                eWidth.addValue((double)((DiscreteAttrMapper.LineThicknessPipe)groupAttrMapper.lineThickness.get("markerOutline")).getValue(i11));
                            } else {
                                eWidth.addValue(ew);
                            }
                            if (this.skinType != 0) {
                                oc = fc;
                            }
                            mColor.addValue(fc);
                            eColor.addValue(oc);
                            if (ew > 1.0 && !fc.equals(oc)) {
                                size.addValue((double)marker.size.getValue(i11) + ew);
                            } else {
                                size.addValue((double)marker.size.getValue(i11));
                            }
                        } else {
                            if (this.useMarkerAttrsColor) {
                                mColor.addValue(this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()));
                                eColor.addValue(this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()));
                            } else {
                                mColor.addValue(marker.color.getValue(i11));
                                eColor.addValue(marker.edgeColor.getValue(i11));
                            }
                            eWidth.addValue((double)marker.edgeWidth.getValue(i11));
                            size.addValue((double)marker.size.getValue(i11));
                        }
                        if (s == 0) {
                            type.addValue(187);
                            continue;
                        }
                        if (s == 16) {
                            type.addValue(188);
                            continue;
                        }
                        type.addValue(s);
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                marker.color.connectFrom((ColorPipe)mColor);
                marker.edgeColor.connectFrom((ColorPipe)eColor);
                marker.edgeWidth.connectFrom((NumericPipe)eWidth);
                marker.size.connectFrom((NumericPipe)size);
                marker.type.connectFrom((IntegerPipe)type);
            }
        }
        if (this.vertexLabelOn) {
            NumericVectorVariable labelVar = new NumericVectorVariable();
            labelVar.connectFrom((NumericPipe)responseMapper.input);
            if (this.labelFormat != null) {
                labelVar.setFormat(new GTKFormat((Format)this.labelFormat));
            } else {
                SASFormat fmt = this.isMultiResponse() ? this.getFormat(610) : this.getFormat(2);
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                } else if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                    int w = fmt.getFormatDescription().getMaxWidth();
                    int d = fmt.getDecimalWidth();
                    fmt = SASFormat.getInstance((String)(fmt.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                    fmt.setInsertBlanks(false);
                }
                labelVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.markerOn) {
                this.plLayout.setMarkerSize(markerSize + 2);
            } else {
                this.plLayout.setMarkerSize(2);
            }
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            this.plLayout.setFontMetrics(fm);
            this.plLayout.label.connectFrom(labelVar.formattedValue);
            if (this.vertical) {
                this.plLayout.x.connectFrom(categoryPipe);
                this.plLayout.y.connectFrom((NumericPipe)responseMapper);
            } else {
                this.plLayout.y.connectFrom(categoryPipe);
                this.plLayout.x.connectFrom((NumericPipe)responseMapper);
            }
            RasterLabel label = new RasterLabel();
            this.networkRoot.addElement((Element)label);
            label.trimOn.setValue(true);
            label.string.connectFrom((StringPipe)this.plLayout.adjustedLabel);
            label.transform.translateX.connectFrom(this.plLayout.xpos);
            label.transform.translateY.connectFrom(this.plLayout.ypos);
            label.horizontalJustification.connectFrom(this.plLayout.hAlign);
            label.verticalJustification.connectFrom(this.plLayout.vAlign);
            label.color.connectFrom((ColorPipe)labelColor);
            label.fontName.setValue(this.labelStyle.getFont().getName());
            label.fontSize.setValue(this.labelStyle.getFont().getSize());
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        }
        if (this.isConditionalHilited()) {
            for (int i12 = 0; i12 < this.getNumCHPipes(); ++i12) {
                BooleanVector bv = this.getCHPipe(i12);
                com.sas.graphics.util.gtk.gl.Image tag = RPFUtil.newTagElement(i12, true, this.networkRoot.getChannel().getComponent());
                this.networkRoot.addElement((Element)tag);
                tag.transform.translateX.connectFrom(categoryPipe);
                tag.transform.translateY.connectFrom((NumericPipe)responseMapper);
                tag.horizontalJustification.setValue(2);
                tag.verticalJustification.setValue(0);
                tag.visibility.connectFrom((BooleanPipe)bv);
            }
        }
        if (this.isMultiResponse()) {
            this.postProcessVars();
        }
        this.needConnect = false;
        return true;
    }

    private Color applyNewTransparency(Color c, double transparency) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        Color c2 = new Color(r, g, b);
        return this.applyDataTransparency(c2, transparency);
    }

    private void preProcessVars() {
        this.categoryVar_sav = this.categoryVar;
        int n = ((StringVariable)this.categoryVar).getValueCount();
        int nResp = this.multiResponseVars.length;
        int rows = n * nResp;
        String[] cat = new String[rows];
        double[] resp = new double[rows];
        String[] grp = new String[rows];
        StringVector probeInfoCat = new StringVector();
        StringVector probeInfoResp = new StringVector();
        probeInfoCat.setSize(rows);
        probeInfoResp.setSize(rows);
        for (int i = 0; i < nResp; ++i) {
            String g = this.multiResponseVars[i].getLabel();
            int offset = i * n;
            if (this.groupOrder != 0) {
                for (int l = 0; l < this.responseCount; ++l) {
                    if (!this.multiResponseLabels[l].equals(g)) continue;
                    offset = l * n;
                    break;
                }
            }
            String cLabel = this.categoryVar_sav.getLabel();
            String rLabel = g;
            for (int j = 0; j < n; ++j) {
                String formattedRespV;
                try {
                    cat[offset + j] = ((StringVariable)this.categoryVar).value.getValue(j);
                }
                catch (MissingValueException e) {
                    cat[offset + j] = null;
                }
                try {
                    resp[offset + j] = this.multiResponseVars[i].value.getValue(j);
                    formattedRespV = this.multiResponseVars[i].formattedValue.getValue(j);
                }
                catch (MissingValueException e) {
                    resp[offset + j] = Double.NaN;
                    formattedRespV = ".";
                }
                grp[offset + j] = g;
                probeInfoCat.setValueAt(cLabel + " = " + cat[offset + j], offset + j);
                probeInfoResp.setValueAt(rLabel + " = " + formattedRespV, offset + j);
            }
        }
        this.categoryVar = new StringVectorVariable();
        ((StringVectorVariable)this.categoryVar).connectFrom(cat);
        ((StringVectorVariable)this.categoryVar).setBlankMissing(false);
        this.responseVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.responseVar).connectFrom(resp);
        this.groupVar = new StringVectorVariable();
        ((StringVectorVariable)this.groupVar).connectFrom(grp);
        this.colorVar = this.groupVar;
        this.lineVar = this.groupVar;
        this.lineColorVar = this.groupVar;
        this.shapeVar = this.groupVar;
        this.shapeColorVar = this.groupVar;
        this.stringGroupVar = (StringVariable)this.groupVar;
        if (this.filledOutlinedMarker) {
            this.shapeFillColorVar = this.groupVar;
        }
        if (this.probe != null) {
            this.probe.removeAll();
            this.probe.addPipe(" ", (Pipe)probeInfoCat);
            this.probe.addPipe(" ", (Pipe)probeInfoResp);
            this.probe.setConnectionString("");
        }
    }

    private void postProcessVars() {
        this.categoryVar = this.categoryVar_sav;
        this.groupVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.shapeVar = null;
        this.shapeColorVar = null;
        this.stringGroupVar = null;
        this.shapeFillColorVar = null;
    }

    private Color getIndexColor(ColorEncoder encoder, Variable colorvar, int i, ColorAttr defaultAttr) {
        Color c;
        Color[] cl = encoder.colorArray;
        int obs = ((StringVariable)colorvar).getFirstOccurringValueIndex(i);
        try {
            int idx = (int)((NumericVariable)this.gIndexVar).value.getValue(obs) - 1;
            c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
        }
        catch (MissingValueException e) {
            c = this.applyDataTransparency(defaultAttr);
        }
        return c;
    }

    private int getScaledMarkerSize(int size) {
        if (this.scaleMarkers) {
            double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
            double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
            int newSize = (int)((double)size * Math.pow(Math.min(ratio_w, ratio_h), 0.25) + 0.5);
            size = Math.min(size, Math.max(5, newSize));
        }
        return size;
    }

    private double getBaselineValue() {
        double baseVal = 0.0;
        PositionEncoder encoder = this.vertical ? this.yEncoder : this.xEncoder;
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)encoder.getValueMap();
        double min = crnm.getInputMin();
        double max = crnm.getInputMax();
        double minExtend = crnm.getInverseValue(encoder.getLowerLimit());
        double maxExtend = crnm.getInverseValue(encoder.getUpperLimit());
        if (encoder.isReversed()) {
            double tmp = min;
            min = max;
            max = tmp;
            tmp = minExtend;
            minExtend = maxExtend;
            maxExtend = tmp;
        }
        switch (this.baselineInterceptType) {
            default: {
                if (max * min <= 0.0) {
                    baseVal = 0.0;
                    break;
                }
                if (min > 0.0) {
                    baseVal = minExtend;
                    break;
                }
                baseVal = maxExtend;
                break;
            }
            case 2: {
                baseVal = min;
                break;
            }
            case 3: {
                baseVal = minExtend;
                break;
            }
            case 4: {
                baseVal = max;
                break;
            }
            case 5: {
                baseVal = maxExtend;
                break;
            }
            case 1: {
                baseVal = this.baseline;
            }
        }
        return baseVal;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        int right = left = (int)Math.ceil(this.getPreferredOffset((byte)1) / 2.0);
        int bottom = top = (int)Math.ceil(this.getPreferredOffset((byte)2) / 2.0);
        if (this.isConditionalHilited()) {
            left = Math.max(left, RPFUtil.getCalloutTagWidth());
            bottom = Math.max(bottom, RPFUtil.getCalloutTagHeight());
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        ValueMap vm;
        double offset = 0.0;
        int maxMarkerSize = this.markerStyle.getSize();
        if (!this.useMarkerSize && this.hasAttrVar("GROUP")) {
            DiscreteAttrMapper dam = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
            maxMarkerSize = Math.max(maxMarkerSize, dam.getMaxMarkerSize());
        }
        if (this.vertical) {
            if (dimension == 1) {
                vm = this.xEncoder.getValueMap();
                if (vm instanceof StringToNumericMap) {
                    int n = ((StringToNumericMap)vm).getUniqueValueCount();
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        offset = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
                        double dist = 0.0;
                        if (this.groupVar != null && this.getGroupDisplay() == 0) {
                            double stride = offset;
                            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                            double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                            dist = ((double)maxGroups / 2.0 - 0.5) * groupSize;
                        }
                        offset = Math.max(offset, (double)this.lineStyle.getWidth() + dist * 2.0);
                        if (this.discreteOffset != 0.0) {
                            double d = Math.abs(this.discreteOffset);
                            double L = this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit();
                            double offsetValue = d * L / ((double)(n - 1) + 2.0 * d);
                            offset += offsetValue;
                        }
                        if (this.isMarkerOn()) {
                            int ms = this.getScaledMarkerSize(maxMarkerSize);
                            int edgeWidth = StatGraph.getMarkerEdgeWidth(ms, this.markerStyle.getWeight());
                            offset = Math.max(offset, (double)(ms + edgeWidth));
                        }
                        offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                    } else {
                        offset = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    }
                }
            } else if (dimension == 2) {
                offset = this.lineStyle.getWidth();
                if (this.isMarkerOn()) {
                    int ms = this.getScaledMarkerSize(maxMarkerSize);
                    int edgeWidth = StatGraph.getMarkerEdgeWidth(ms, this.markerStyle.getWeight());
                    offset = Math.max(offset, (double)(ms + edgeWidth));
                }
                offset += (double)(2 * StatGraph.getExtraPadding());
            }
        } else if (dimension == 1) {
            offset = this.lineStyle.getWidth();
            if (this.isMarkerOn()) {
                int ms = this.getScaledMarkerSize(maxMarkerSize);
                int edgeWidth = StatGraph.getMarkerEdgeWidth(ms, this.markerStyle.getWeight());
                offset = Math.max(offset, (double)(ms + edgeWidth));
            }
            offset += (double)(2 * StatGraph.getExtraPadding());
        } else if (dimension == 2 && (vm = this.yEncoder.getValueMap()) instanceof StringToNumericMap) {
            int n = ((StringToNumericMap)vm).getUniqueValueCount();
            if (n == 0) {
                return 0.0;
            }
            if (n > 1) {
                offset = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                double dist = 0.0;
                if (this.groupVar != null && this.getGroupDisplay() == 0) {
                    double stride = offset;
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                    dist = ((double)maxGroups / 2.0 - 0.5) * groupSize;
                }
                offset = Math.max(offset, (double)this.lineStyle.getWidth() + dist * 2.0);
                if (this.discreteOffset != 0.0) {
                    double d = Math.abs(this.discreteOffset);
                    double L = this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit();
                    double offsetValue = d * L / ((double)(n - 1) + 2.0 * d);
                    offset += offsetValue;
                }
                if (this.isMarkerOn()) {
                    int ms = this.getScaledMarkerSize(maxMarkerSize);
                    int edgeWidth = StatGraph.getMarkerEdgeWidth(ms, this.markerStyle.getWeight());
                    offset = Math.max(offset, (double)(ms + edgeWidth));
                }
                offset += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
            } else {
                offset = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
            }
        }
        return offset;
    }

    @Override
    public String[] getRawUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        return super.getRawUniqueValues(role);
    }

    @Override
    public String[] getUniqueValues(short role) {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        StringVariable group = (StringVariable)this.connectCategory(role, true);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        if (this.groupVar != null) {
            StringVariable rawGroup = StatGraph.isOLAP() ? group : this.connectRaw((short)3);
            vp.addVariable((Variable)rawGroup);
            if (this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
                int sort;
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort((Variable)rawGroup, sort);
                } else {
                    vp.setSort((Variable)group, sort);
                }
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                if (this.groupOrder == 3) {
                    gv[i] = group.uniqueValue.getValue(gv.length - 1 - i);
                    continue;
                }
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    @Override
    public int[] getLinePatterns() {
        if (!this.isLineOn()) {
            return new int[0];
        }
        if (this.lineEncoder == null) {
            return new int[]{this.lineStyle.getLinePattern()};
        }
        if (this.isMultiResponse()) {
            return this.getResponsePatterns();
        }
        return this.getGroupPatterns();
    }

    @Override
    public int[] getLineWidths() {
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            return new int[]{this.lineStyle.getWidth()};
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.lineStyle.getWidth());
    }

    public int[] getMarkerLineWidths() {
        if (this.useMarkerOutlineAttrsThickness || !this.hasAttrVar("GROUP")) {
            int[] lt = new int[]{this.markerOutlineStyle.getWidth()};
            return lt;
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.markerOutlineStyle.getWidth());
    }

    @Override
    public Color[] getLineColors() {
        if (!this.isLineOn()) {
            return new Color[0];
        }
        if (this.gradientColor) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor())};
        }
        if (this.lineColorEncoder == null) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor())};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(46);
        }
        return this.getGroupColors(46);
    }

    @Override
    public Color[] getFillColors() {
        if (!this.isFillOn()) {
            return new Color[0];
        }
        if (this.colorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(6);
        }
        return this.getGroupColors(6);
    }

    public Color[] getMarkerColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        if (this.shapeColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerStyle)};
        }
        if (this.isMultiResponse()) {
            if (this.lineOn && this.lineColorEncoder == null) {
                return new Color[]{this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency())};
            }
            return this.getResponseColors(45);
        }
        if (this.lineOn && this.lineColorEncoder == null) {
            return new Color[]{this.applyDataTransparency(this.lineStyle.getColor(), this.markerStyle.getTransparency())};
        }
        return this.getGroupColors(45);
    }

    public Color[] getMarkerFillColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        this.markerFillStyle.setTransparency(this.markerStyle.getTransparency());
        if (this.shapeFillColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerFillStyle)};
        }
        if (this.isMultiResponse()) {
            return this.getResponseColors(69);
        }
        return this.getGroupColors(69);
    }

    public Color[] getMarkerOutlineColors() {
        if (!this.isMarkerOn()) {
            return new Color[0];
        }
        if (this.useMarkerOutlineAttrsColor || this.shapeColorEncoder == null) {
            return new Color[]{this.applyDataTransparency((ColorAttr)this.markerOutlineStyle)};
        }
        if (this.isMultiResponse()) {
            if (!this.lineOn) {
                return this.getResponseColors(70);
            }
            return this.getLineColors();
        }
        if (!this.lineOn || this.hasAttrVar("GROUP") && this.lineColorVar != null) {
            return this.getGroupColors(70);
        }
        return this.getLineColors();
    }

    @Override
    public int[] getMarkerShapes() {
        if (!this.isMarkerOn()) {
            return new int[0];
        }
        if (this.shapeEncoder == null) {
            return new int[]{this.markerStyle.getShape()};
        }
        if (this.isMultiResponse()) {
            return this.getResponseShapes();
        }
        return this.getGroupShapes();
    }

    @Override
    public int[] getMarkerWidths() {
        if (this.useMarkerSize || !this.hasAttrVar("GROUP")) {
            return new int[]{this.markerStyle.getSize()};
        }
        return this.getDAttrMarkerSize("GROUP", this.getGroupValues(), this.markerStyle.getSize());
    }

    @Override
    public int[] getMarkerWeights() {
        if (this.useMarkerWeight || !this.hasAttrVar("GROUP")) {
            return new int[]{this.markerStyle.getWeight()};
        }
        return this.getDAttrMarkerWeight("GROUP", this.getGroupValues(), this.markerStyle.getWeight());
    }

    @Override
    public String[] getGroupValues() {
        if (this.isMultiResponse()) {
            return this.multiResponseLabels;
        }
        if (this.groupVar != null) {
            if (this.groupVar instanceof OLAPLevelVariable) {
                OLAPVariableFactory fac = this.model.getOLAPVarFactory();
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.groupVar.getColumnName());
                DataTreeGroupNode n = fac.createSubTree(list);
                String[] values = new String[n.getChildCount()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = n.getChildAt(i).toString();
                }
                return values;
            }
            if (this.groupOrder == 0 || this.groupOrder == 3) {
                return this.getUniqueGroupValues((short)3);
            }
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return new String[0];
    }

    private int[] getGroupShapes() {
        NumericVectorVariable indexV;
        DiscreteAttrMapper groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        StringVariable shapeV = (StringVariable)this.connectCategory((short)8, true);
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)shapeV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        int[] shapes = new int[]{};
        HashMap ht = this.shapeEncoder.shapeList;
        int[] sl = this.shapeEncoder.shapeArray;
        String[] values = this.getUniqueValues((short)8);
        shapes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            shapes[i] = -1;
            String gval = values[i];
            if (groupAttrMapper != null) {
                shapes[i] = groupAttrMapper.getMarkerSymbol(gval);
            }
            if (shapes[i] >= 0) continue;
            if (indexV == null) {
                shapes[i] = (Integer)ht.get(gval);
                continue;
            }
            int obs = this.groupOrder == 3 ? shapeV.getFirstOccurringValueIndex(values.length - 1 - i) : shapeV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                shapes[i] = sl[idx % sl.length];
                continue;
            }
            catch (MissingValueException e) {
                shapes[i] = this.markerStyle.getShape();
            }
        }
        return shapes;
    }

    private Color[] getGroupColors(int role) {
        NumericVectorVariable indexV;
        if (this.gradientColor) {
            return new Color[]{this.applyDataTransparency(this.fillStyle.getColor())};
        }
        DiscreteAttrMapper groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        StringVariable colorV = null;
        HashMap ht = null;
        Color[] cl = null;
        String[] values = null;
        if (StatGraph.isOLAP()) {
            values = this.getUniqueValues((short)46);
            ht = this.colorEncoder.colorList;
            cl = new Color[this.getGroupValues().length];
            ArrayList<String> gValues = new ArrayList<String>();
            int cnt = 0;
            for (int i = 0; i < values.length; ++i) {
                String str = Overlay.getTopLevelValue(values[i]);
                if (gValues.contains(str)) continue;
                cl[cnt++] = (Color)ht.get(values[i]);
                gValues.add(str);
            }
            return cl;
        }
        FillAttrs defaultAttr = null;
        switch (role) {
            case 6: {
                colorV = (StringVariable)this.connectCategory((short)6, true);
                ht = this.colorEncoder.colorList;
                cl = this.colorEncoder.colorArray;
                values = this.getUniqueValues((short)6);
                defaultAttr = this.fillStyle;
                break;
            }
            case 46: {
                colorV = (StringVariable)this.connectCategory((short)46, true);
                ht = this.lineColorEncoder.colorList;
                cl = this.lineColorEncoder.colorArray;
                values = this.getUniqueValues((short)46);
                defaultAttr = this.lineStyle;
                break;
            }
            case 45: {
                colorV = (StringVariable)this.connectCategory((short)45, true);
                ht = this.shapeColorEncoder.colorList;
                cl = this.shapeColorEncoder.colorArray;
                values = this.getUniqueValues((short)45);
                defaultAttr = this.markerStyle;
                break;
            }
            case 69: {
                colorV = (StringVariable)this.connectCategory((short)69, true);
                ht = this.shapeFillColorEncoder.colorList;
                cl = this.shapeFillColorEncoder.colorArray;
                values = this.getUniqueValues((short)69);
                defaultAttr = this.markerFillStyle;
                break;
            }
            case 70: {
                colorV = (StringVariable)this.connectCategory((short)45, true);
                ht = this.shapeColorEncoder.colorList;
                cl = this.shapeColorEncoder.colorArray;
                values = this.getUniqueValues((short)45);
                defaultAttr = this.markerOutlineStyle;
            }
        }
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)colorV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            String gval = values[i];
            if (groupAttrMapper != null) {
                Color c = null;
                double tr = defaultAttr.getTransparency();
                switch (role) {
                    case 6: {
                        c = groupAttrMapper.getFillColor(gval);
                        if (this.useFillTransparency) break;
                        tr = groupAttrMapper.getFillTransparency(gval);
                        break;
                    }
                    case 69: {
                        c = groupAttrMapper.getFillColor(gval);
                        if (this.useMarkerTransparency) break;
                        tr = groupAttrMapper.getMarkerTransparency(gval);
                        break;
                    }
                    case 46: 
                    case 70: {
                        c = groupAttrMapper.getLineColor(gval);
                        break;
                    }
                    case 45: {
                        c = groupAttrMapper.getMarkerColor(gval);
                        if (this.useMarkerTransparency) break;
                        tr = groupAttrMapper.getMarkerTransparency(gval);
                    }
                }
                if (c != null) {
                    colors[i] = this.applyDataTransparency(c, tr);
                }
            }
            if (colors[i] != null) continue;
            if (indexV == null) {
                colors[i] = (Color)ht.get(gval);
                if (role != 70) continue;
                colors[i] = this.applyNewTransparency(colors[i], defaultAttr.getTransparency());
                continue;
            }
            int obs = this.groupOrder == 3 ? colorV.getFirstOccurringValueIndex(values.length - 1 - i) : colorV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                colors[i] = this.applyDataTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
                continue;
            }
            catch (MissingValueException e) {
                colors[i] = this.applyDataTransparency((ColorAttr)defaultAttr);
            }
        }
        return colors;
    }

    private int[] getGroupPatterns() {
        NumericVectorVariable indexV;
        if (StatGraph.isOLAP()) {
            LineAttrs[] ll = this.lineEncoder.styleArray;
            HashMap ht = this.lineEncoder.styleList;
            String[] values = this.getUniqueValues((short)36);
            int[] pattern = new int[this.getGroupValues().length];
            ArrayList<String> gValues = new ArrayList<String>();
            int cnt = 0;
            for (int i = 0; i < values.length; ++i) {
                String str = Overlay.getTopLevelValue(values[i]);
                if (gValues.contains(str)) continue;
                pattern[cnt++] = ((LineAttrs)ht.get(values[i])).getLinePattern();
                gValues.add(str);
            }
            return pattern;
        }
        StringVariable lineV = (StringVariable)this.connectCategory((short)36, true);
        NumericVectorVariable numericVectorVariable = indexV = this.gIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)44);
        if (indexV != null && this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
            int sort;
            Variable rawGroup = this.connectRaw((short)3);
            Variable fmtGroup = this.connectCategory((short)3, true);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)lineV);
            vp.addVariable((Variable)indexV);
            vp.addVariable(rawGroup);
            vp.addVariable(fmtGroup);
            int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
            if (this.groupVar instanceof NumericVariable) {
                vp.setSort(rawGroup, sort);
            } else {
                vp.setSort(fmtGroup, sort);
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        LineAttrs[] ll = this.lineEncoder.styleArray;
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getUniqueValues((short)36);
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = -1;
            String gval = values[i];
            if (this.hasAttrVar("GROUP")) {
                DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                pattern[i] = groupAttrMapper.getLinePattern(gval);
            }
            if (pattern[i] != -1) continue;
            if (indexV == null) {
                pattern[i] = ((LineAttrs)ht.get(gval)).getLinePattern();
                continue;
            }
            int obs = this.groupOrder == 3 ? lineV.getFirstOccurringValueIndex(values.length - 1 - i) : lineV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                pattern[i] = ll[idx % ll.length].getLinePattern();
                continue;
            }
            catch (MissingValueException e) {
                pattern[i] = this.lineStyle.getLinePattern();
            }
        }
        return pattern;
    }

    private Color[] getResponseColors(int role) {
        HashMap ht = null;
        String[] values = null;
        switch (role) {
            case 6: {
                ht = this.colorEncoder.colorList;
                values = this.getUniqueValues((short)6);
                break;
            }
            case 46: {
                ht = this.lineColorEncoder.colorList;
                values = this.getUniqueValues((short)46);
                break;
            }
            case 45: 
            case 70: {
                ht = this.shapeColorEncoder.colorList;
                values = this.getUniqueValues((short)45);
                break;
            }
            case 69: {
                ht = this.shapeFillColorEncoder.colorList;
                values = this.getUniqueValues((short)69);
            }
        }
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            colors[i] = (Color)ht.get(values[i]);
            if (role != 70) continue;
            colors[i] = this.applyNewTransparency(colors[i], this.markerOutlineStyle.getTransparency());
        }
        return colors;
    }

    private int[] getResponsePatterns() {
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getUniqueValues((short)36);
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = ((LineAttrs)ht.get(values[i])).getLinePattern();
        }
        return pattern;
    }

    private int[] getResponseShapes() {
        int[] shapes = new int[]{};
        HashMap ht = this.shapeEncoder.shapeList;
        String[] values = this.getUniqueValues((short)8);
        shapes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            shapes[i] = (Integer)ht.get(values[i]);
        }
        return shapes;
    }

    private Color[] getCombinedMarkerColor(String[] values, int[] shape, Color[] color, Color[] fColor) {
        int n = values.length;
        Color[] combinedColor = new Color[n];
        for (int i = 0; i < n; ++i) {
            int s = shape[i % shape.length];
            combinedColor[i] = Markers.isFilled((int)s) ? fColor[i % fColor.length] : (this.useMarkerAttrsColor ? this.applyDataTransparency(this.markerStyle.getColor(), this.markerStyle.getTransparency()) : color[i % color.length]);
        }
        return combinedColor;
    }

    private int[] getModifiedMarkerShapes(int[] shapes) {
        if (shapes == null || shapes.length < 1) {
            return shapes;
        }
        int[] s = new int[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            s[i] = shapes[i] == 0 ? 187 : (shapes[i] == 16 ? 188 : shapes[i]);
        }
        return s;
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                return this.markerOn;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (this.fillOn) {
            return this.lineOn ? 11 : 7;
        }
        if (!this.markerOn) {
            return 10;
        }
        if (this.filledOutlinedMarker) {
            return this.lineOn ? 15 : 14;
        }
        return this.lineOn ? 13 : 9;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.markerOn && !this.lineOn || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.lineOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = this.markerOn ? (LineAttrs)items[i].getSecondarySymbolAttrs() : (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            if (this.markerOn) {
                items[i].setSecondarySymbolAttrs((ColorAttr)la);
                continue;
            }
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    protected void applyMarkerTransparency(LegendItem[] items) {
        if (!this.markerOn || this.fillOn || !this.useMarkerTransparency && !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            MarkerAttrs old = (MarkerAttrs)items[i].getSymbolAttrs();
            MarkerAttrs ma = new MarkerAttrs();
            ma.setColor(this.applyDataTransparency(old.getColor(), this.markerStyle.getTransparency()));
            ma.setShape(old.getShape());
            ma.setSize(old.getSize());
            ma.setWeight(old.getWeight());
            LineAttrs la = items[i].getMarkerOutlineAttrs();
            if (la != null && this.useDataTransparency) {
                LineAttrs newLa = new LineAttrs();
                newLa.setColor(this.applyDataTransparency(la.getColor()));
                newLa.setWidth(la.getWidth());
                items[i].setMarkerOutlineAttrs(newLa);
            }
            items[i].setSymbolAttrs((ColorAttr)ma);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        boolean lineOnly;
        String[] values;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        switch (attrType) {
            default: {
                values = this.getGroupValues();
                break;
            }
            case 4: {
                if (this.lineColorVar != null) {
                    values = this.getUniqueValues((short)46);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 5: {
                if (this.lineVar != null) {
                    values = this.getUniqueValues((short)36);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 1: {
                if (this.shapeVar != null) {
                    values = this.getUniqueValues((short)8);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 3: {
                values = this.shapeColorVar != null ? this.getUniqueValues((short)45) : this.getGroupValues();
            }
        }
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        int[] shape = this.getMarkerShapes();
        if (this.filledOutlinedMarker) {
            shape = this.getModifiedMarkerShapes(shape);
        }
        boolean bl = lineOnly = attrType == 10 || attrType == 4 || attrType == 5;
        if (shape.length == 0 || lineOnly || this.fillOn) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            Color[] fcolor = this.getFillColors();
            int n = values.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = null;
                if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                    attr = new LineAttrs();
                    attr.setColor(lcolor[i % lcolor.length]);
                    attr.setLinePattern(pattern[i % pattern.length]);
                    attr.setWidth(width[i % width.length]);
                }
                if (fcolor.length > 0) {
                    FillAttrs fillattr = new FillAttrs();
                    fillattr.setColor(fcolor[i % fcolor.length]);
                    entries[i] = new LegendItem((ColorAttr)fillattr, (ColorAttr)attr, values[i], null);
                    continue;
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType, false);
            }
            return entries;
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        int[] size = this.getMarkerWidths();
        int[] weight = this.getMarkerWeights();
        Color[] color = this.getMarkerColors();
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        int[] mWidth = this.getMarkerLineWidths();
        Color[] olcolor = null;
        if (this.filledOutlinedMarker) {
            olcolor = this.getMarkerOutlineColors();
            Color[] fcolor = this.getMarkerFillColors();
            color = this.getCombinedMarkerColor(values, shape, color, fcolor);
        }
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                LineAttrs attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
                entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, null, this.skinType, false);
                entries[i].setPixelBenderImages(legendPixelBender);
            } else {
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType, legendPixelBender);
            }
            if (!this.filledOutlinedMarker) continue;
            LineAttrs outlineAttrs = null;
            int s = shape[i % shape.length];
            if (!Markers.isFilled((int)s)) continue;
            outlineAttrs = new LineAttrs();
            outlineAttrs.setColor(olcolor[i % olcolor.length]);
            if (this.useMarkerOutlineAttrsThickness) {
                outlineAttrs.setWidth(this.markerOutlineStyle.getWidth());
            } else {
                outlineAttrs.setWidth(mWidth[i % mWidth.length]);
            }
            entries[i].setMarkerOutlineAttrs(outlineAttrs);
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        boolean lineOnly;
        String[] values;
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        switch (attrType) {
            default: {
                values = this.getGroupValues();
                break;
            }
            case 4: {
                if (this.lineColorVar != null) {
                    values = this.getUniqueValues((short)46);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 5: {
                if (this.lineVar != null) {
                    values = this.getUniqueValues((short)36);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 1: {
                if (this.shapeVar != null) {
                    values = this.getUniqueValues((short)8);
                    break;
                }
                values = this.getGroupValues();
                break;
            }
            case 3: {
                values = this.shapeColorVar != null ? this.getUniqueValues((short)45) : this.getGroupValues();
            }
        }
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = LineChartOverlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        int[] shape = this.getMarkerShapes();
        if (this.isMarkerOn() && this.shapeEncoder != null) {
            shape = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, shape, 0, this.markerStyle.getShape());
        }
        if (this.filledOutlinedMarker) {
            shape = this.getModifiedMarkerShapes(shape);
        }
        boolean bl = lineOnly = attrType == 10 || attrType == 4 || attrType == 5;
        if (shape.length == 0 || lineOnly || this.fillOn) {
            Color[] lcolor = this.getLineColors();
            if (this.isLineOn() && this.lineColorEncoder != null && !this.gradientColor) {
                lcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, lcolor, 11, this.lineStyle.getColor(), this.dataTransparency, this.useDataTransparency);
            }
            int[] pattern = this.getLinePatterns();
            if (this.isLineOn() && this.lineEncoder != null) {
                pattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, pattern, 3, this.lineStyle.getLinePattern());
            }
            int[] width = this.getLineWidths();
            if (!this.useLineThickness) {
                width = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, width, 4, this.lineStyle.getWidth());
            }
            Color[] fcolor = this.getFillColors();
            if (this.isFillOn() && this.colorEncoder != null) {
                fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 12, this.fillStyle.getColor(), this.fillStyle.getTransparency(), this.useFillTransparency);
            }
            int n = attrMapValues.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = null;
                if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                    attr = new LineAttrs();
                    attr.setColor(lcolor[i % lcolor.length]);
                    attr.setLinePattern(pattern[i % pattern.length]);
                    attr.setWidth(width[i % width.length]);
                }
                if (fcolor.length > 0) {
                    FillAttrs fillattr = new FillAttrs();
                    fillattr.setColor(fcolor[i % fcolor.length]);
                    entries[i] = new LegendItem((ColorAttr)fillattr, (ColorAttr)attr, attrMapValues[i], null);
                    continue;
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null, null, this.skinType, false);
            }
            return entries;
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        int[] size = this.getMarkerWidths();
        if (!this.useMarkerSize) {
            size = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, size, 1, this.markerStyle.getSize());
        }
        int[] weight = this.getMarkerWeights();
        if (!this.useMarkerWeight) {
            weight = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, weight, 2, this.markerStyle.getWeight());
        }
        Color[] color = this.getMarkerColors();
        if (this.isMarkerOn() && this.shapeColorEncoder != null) {
            color = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, color, 10, this.markerStyle.getColor(), this.markerStyle.getTransparency(), this.useMarkerTransparency);
        }
        Color[] lcolor = this.getLineColors();
        if (this.isLineOn() && this.lineColorEncoder != null && !this.gradientColor) {
            lcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, lcolor, 11, this.lineStyle.getColor(), this.dataTransparency, this.useDataTransparency);
        }
        int[] pattern = this.getLinePatterns();
        if (this.isLineOn() && this.lineEncoder != null) {
            pattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, pattern, 3, this.lineStyle.getLinePattern());
        }
        int[] width = this.getLineWidths();
        if (!this.useLineThickness) {
            width = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, width, 4, this.lineStyle.getWidth());
        }
        int[] mWidth = this.getMarkerLineWidths();
        if (!this.useMarkerOutlineAttrsThickness) {
            mWidth = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, mWidth, 4, this.markerOutlineStyle.getWidth());
        }
        Color[] olcolor = null;
        if (this.filledOutlinedMarker) {
            olcolor = this.getMarkerOutlineColors();
            if (this.isMarkerOn() && !this.useMarkerOutlineAttrsColor && this.shapeColorEncoder != null) {
                olcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, olcolor, 16, this.markerOutlineStyle.getColor(), this.markerStyle.getTransparency(), this.useMarkerTransparency);
            }
            Color[] fcolor = this.getMarkerFillColors();
            if (this.isMarkerOn() && this.shapeFillColorEncoder != null) {
                fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 15, this.markerFillStyle.getColor(), this.markerStyle.getTransparency(), this.useMarkerTransparency);
            }
            color = this.getCombinedMarkerColor(attrMapValues, shape, color, fcolor);
        }
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                LineAttrs attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
                entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, null, this.skinType, false);
                entries[i].setPixelBenderImages(legendPixelBender);
            } else {
                entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null, null, this.skinType, legendPixelBender);
            }
            if (!this.filledOutlinedMarker) continue;
            LineAttrs outlineAttrs = null;
            int s = shape[i % shape.length];
            if (!Markers.isFilled((int)s)) continue;
            outlineAttrs = new LineAttrs();
            outlineAttrs.setColor(olcolor[i % olcolor.length]);
            if (this.useMarkerOutlineAttrsThickness) {
                outlineAttrs.setWidth(this.markerOutlineStyle.getWidth());
            } else {
                outlineAttrs.setWidth(mWidth[i % mWidth.length]);
            }
            entries[i].setMarkerOutlineAttrs(outlineAttrs);
        }
        return entries;
    }

    protected void connectOLAPVars() {
        CRD crd = this.model;
        if (crd.isAvailable(1)) {
            this.categoryVar = StatGraph.getOLAPLevelVar(crd, (short)1);
            if (!this.isVertical()) {
                crd.getSrcModel().yCategoryVar = this.categoryVar.getColumnName();
            } else {
                crd.getSrcModel().xCategoryVar = this.categoryVar.getColumnName();
            }
        }
        this.groupVar = crd.isAvailable(3) ? StatGraph.getOLAPLevelVar(crd, (short)3) : null;
        if (this.isMultiResponse()) {
            this.multiResponseVars = new NumericVariable[this.responseCount];
            this.multiResponseLabels = new String[this.responseCount];
            for (int i = 0; i < this.responseCount; ++i) {
                if (!crd.isAvailable(610 + i)) continue;
                this.multiResponseVars[i] = StatGraph.getOLAPMeasureVar(crd, (short)(610 + i));
                this.multiResponseLabels[i] = this.multiResponseVars[i].getLabel();
            }
            if (this.groupOrder != 0) {
                this.sortMultiResponseLabels();
            }
        } else if (crd.isAvailable(2)) {
            this.responseVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
        }
        this.lineColorVar = crd.isAvailable(46) ? StatGraph.getOLAPLevelVar(crd, (short)46) : null;
        this.labelVisibleVar = new VisibilityVariable();
        VariableProcessor vp = new VariableProcessor();
        this.categoryVar.setUniqueValueSort(0);
        if (this.statistic != -1) {
            vp.addGroupVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addGroupVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
            }
        } else {
            vp.addVariable(this.categoryVar);
            if (this.numericCategoryVar != null) {
                vp.addVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar, 0);
                vp.addGroupVariable(this.categoryVar);
                if (this.numericCategoryVar != null) {
                    vp.addGroupVariable((Variable)this.numericCategoryVar);
                }
            }
        }
        this.addCRDWhereClause(vp);
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), vp, this.statistic));
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.isMultiResponse() && !this.model.isAvailable(3);
    }

    @Override
    public String getDefaultLegendTitle() {
        String title = null;
        if (this.model.isAvailable(3)) {
            if (StatGraph.isOLAP()) {
                OLAPLevelVariable olv = (OLAPLevelVariable)this.groupVar;
                OLAPVariableFactory fac = olv.getFactory();
                List list = fac.getLevelNamesForHeirarchy(olv.getHierachyName());
                String levelName = (String)list.get(0);
                title = fac.getLabel(levelName).trim();
            } else {
                ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
                title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
            }
        }
        return title;
    }

    @Override
    public String[] getLabels(byte dim) {
        if (dim == 2 && this.isMultiResponse() && this.vertical) {
            return this.multiResponseLabels;
        }
        return super.getLabels(dim);
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        if (StatGraph.isOLAP()) {
            String label = null;
            if (this.responseVar != null) {
                label = this.responseVar.getLabel();
                if (label == null) {
                    label = this.responseVar.getColumnName();
                }
            } else {
                label = this.categoryVar.getLabel();
                if (label == null) {
                    label = this.categoryVar.getColumnName();
                }
            }
            return label;
        }
        ColumnMetadata cmd = null;
        cmd = this.model.isAvailable(2) ? (ColumnMetadata)this.model.getColumnLabel(2) : (ColumnMetadata)this.model.getColumnLabel(1);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.groupVar == null ? 1 : this.groupVar.getUniqueValueCount();
    }

    public boolean isGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(boolean gradientColor) {
        this.gradientColor = gradientColor;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        if (type == 1 || !this.gradientColor) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            double max;
            double min;
            RangeAttrMapper mapper;
            String error;
            ContinuousRange range = (ContinuousRange)ce.getInput();
            if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(min = ((NumericVariable)this.colorVar).getMin(), max = ((NumericVariable)this.colorVar).getMax())) == null) {
                return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            Color[] colors = ce.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        ColorEncoder le = (ColorEncoder)this.getEncoder((byte)17);
        if (le != null && le.getInput() instanceof ContinuousRange) {
            double max;
            double min;
            RangeAttrMapper mapper;
            String error;
            ContinuousRange range = (ContinuousRange)le.getInput();
            if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(min = ((NumericVariable)this.lineColorVar).getMin(), max = ((NumericVariable)this.lineColorVar).getMax(), true)) == null) {
                return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
            }
            Color[] colors = le.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        return null;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = null;
        if (this.model.isAvailable(6)) {
            ce = (ColorEncoder)this.getEncoder((byte)4);
        } else if (this.model.isAvailable(46)) {
            ce = (ColorEncoder)this.getEncoder((byte)17);
        }
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        String title = null;
        if (!this.gradientColor) {
            return null;
        }
        if (this.model.isAvailable(6)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(45);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        } else if (this.model.isAvailable(46)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(46);
            title = cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
        }
        return title;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
            case 15: {
                return this.lineEncoder;
            }
            case 6: {
                return this.shapeEncoder;
            }
            case 16: {
                return this.shapeColorEncoder;
            }
            case 24: {
                return this.shapeFillColorEncoder;
            }
        }
        return null;
    }

    @Override
    public int getRendererComplexity() {
        int n = this.categoryVar.getUniqueValueCount();
        if (this.groupVar != null) {
            n *= this.groupVar.getUniqueValueCount();
        }
        return n;
    }

    @Override
    public int getNumOfTooltips() {
        int n = this.categoryVar.getUniqueValueCount();
        if (this.groupVar != null) {
            n *= this.groupVar.getUniqueValueCount();
        }
        return n;
    }

    @Override
    public void resetToInitialValues() {
        this.useFillTransparency = false;
        this.useLineThickness = false;
        this.useMarkerAttrsColor = false;
        this.useMarkerFillAttrsColor = false;
        this.useMarkerOutlineAttrsColor = false;
        this.useMarkerOutlineAttrsThickness = false;
        this.useMarkerSize = false;
        this.useMarkerTransparency = false;
        this.useMarkerWeight = false;
        this.fillOn = false;
        this.markerOn = false;
        this.lineOn = true;
        this.colorRange = null;
        this.lineColorRange = null;
        this.lineRange = null;
        this.shapeRange = null;
        this.shapeColorRange = null;
        this.attrVarMap.clear();
        this.colorEncoder = null;
        this.lineColorEncoder = null;
        this.lineEncoder = null;
        this.shapeEncoder = null;
        this.shapeColorEncoder = null;
        this.shapeFillColorEncoder = null;
        this.groupVar = null;
        this.gIndexVar = null;
        this.colorVar = null;
        this.lineColorVar = null;
        this.lineVar = null;
        this.shapeVar = null;
        this.shapeColorVar = null;
        this.shapeFillColorVar = null;
        this.fillStyle = new FillAttrs();
        this.lineStyle = new LineAttrs();
        this.markerStyle = new MarkerAttrs();
        this.labelStyle = new TextAttrs();
    }
}

