/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SpecLimitsOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ContinuousRangeToLogarithmicMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.text.Format;
import java.util.HashMap;

public class HistogramOverlay
extends SpecLimitsOverlay {
    public static final String RB_KEY = "HistogramOverlay.";
    public static final byte VERTICAL = 0;
    public static final byte HORIZONTAL = 1;
    public static final byte MIDPOINTS = 0;
    public static final byte LEFTPOINTS = 1;
    public static final byte RIGHTPOINTS = 2;
    protected double defaultBinSize = 0.0;
    protected byte orientation = 0;
    protected double baseline = 0.0;
    protected boolean endLabels = false;
    protected boolean fillOn = true;
    protected FillAttrs fillStyle = new FillAttrs();
    protected boolean edgeOn = true;
    protected LineAttrs edgeStyle = new LineAttrs();
    protected boolean fillPatternOn = false;
    protected FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    protected byte xValues = 0;
    protected boolean binAxis = true;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange colorRange;
    protected DataRange lineRange;
    protected DataRange lineColorRange;
    protected PositionEncoder xEncoder = null;
    protected PositionEncoder yEncoder = null;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected LineEncoder lineEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    protected ColorEncoder dataLabelColorEncoder;
    protected double constBinSize = 2.0;
    protected NumericVectorVariable responseVar;
    protected NumericVariable xvalueVar;
    protected Variable labelVar;
    protected Variable groupVar;
    protected Variable rawGroupVar;
    protected Variable colorVar;
    protected Variable lineVar;
    protected Variable lineColorVar;
    protected boolean numericGroup = false;
    private NetworkRoot networkRoot;
    private Bar bar = new Bar();
    private ContinuousRangeToNumericMapper responseMapper;
    private boolean numericLabel = false;
    private boolean showLabel = false;
    private TextStyle labelStyle = new TextStyle();
    private int extraPadding;
    private boolean compact = true;
    private Image skinImage = null;
    private boolean labelRotated = false;
    private boolean dataLabelSplit = false;
    private boolean labelDropped = false;
    private StringVector splitDataLabelPipe;
    private static double ZERO_VALUE = 1.0E-6;
    private boolean sortXValues = false;

    public void setBinAxis(boolean b) {
        this.binAxis = b;
        if (this.orientation == 0) {
            this.updateXRange();
        } else {
            this.updateYRange();
        }
    }

    public boolean isBinAxis() {
        return this.binAxis;
    }

    public byte getXValues() {
        return this.xValues;
    }

    public void setXValues(byte aByte) {
        this.xValues = aByte;
    }

    public boolean isEndLabels() {
        return this.endLabels;
    }

    public void setEndLabels(boolean b) {
        this.endLabels = b;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        if (this.orientation == 0) {
            newRange = this.getIndRange();
            this.setFormat(newRange, 13);
        } else {
            newRange = this.getDepRange();
            this.setFormat(newRange, 2);
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, newRange);
    }

    public void setBaseline(double aBaseline) {
        double oldB = this.baseline;
        this.baseline = aBaseline;
        if (this.baseline != oldB) {
            this.updateXRange();
            this.updateYRange();
        }
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.orientation == 0) {
            newRange = this.getDepRange();
            this.setFormat(newRange, 2);
        } else {
            newRange = this.getIndRange();
            this.setFormat(newRange, 13);
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    protected void updateColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.colorRange;
        if (this.colorVar != null) {
            int num = this.colorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.colorVar, num);
                newRange.setLabel(this.colorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.colorRange = newRange;
        this.fireRangeEvent((byte)4, oldRange, (DataRange)newRange);
    }

    protected void updateLineColorRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineColorRange;
        if (this.lineColorVar != null) {
            int num = this.lineColorVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineColorVar, num);
                newRange.setLabel(this.lineColorVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineColorRange = newRange;
        this.fireRangeEvent((byte)17, oldRange, (DataRange)newRange);
    }

    protected void updateLineRange() {
        DiscreteRange newRange = null;
        DataRange oldRange = this.lineRange;
        if (this.lineVar != null) {
            int num = this.lineVar.getUniqueValueCount();
            if (num > 0) {
                newRange = Overlay.makeDiscreteRange((StringVariable)this.lineVar, num);
                newRange.setLabel(this.lineVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.lineRange = newRange;
        this.fireRangeEvent((byte)15, oldRange, (DataRange)newRange);
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
            case 15: {
                return this.lineEncoder;
            }
        }
        return null;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (encoder == null) {
            return;
        }
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 25) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.dataLabelColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    public void setDefaultBinSize(double size) {
        double oldDBS = this.defaultBinSize;
        this.defaultBinSize = size;
        if (size != oldDBS) {
            this.connectVars();
            this.updateXRange();
            this.updateYRange();
        }
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateColorRange();
        this.updateLineColorRange();
        this.updateLineRange();
    }

    public void setShowLabel(boolean show) {
        this.showLabel = show;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setLabelStyle(TextStyle style) {
        if (style == null) {
            return;
        }
        this.labelStyle = style;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    protected boolean connectGroupedNetwork() {
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xvalueVar == null) {
            return false;
        }
        if (this.responseVar == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.yEncoder == null) {
            return false;
        }
        PositionEncoder ve = null;
        ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        ValueMap xmap = ve.getValueMap();
        if (!(xmap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        boolean logMap = xmap instanceof ContinuousRangeToLogarithmicMap;
        ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
        ValueMap rmap = ve.getValueMap();
        if (!(rmap instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            this.responseVar.setFormat(new GTKFormat((Format)format));
        }
        int nGroups = this.groupVar.getUniqueValueCount();
        NumericVector[] internalXValues = new NumericVector[nGroups];
        NumericVector[] internalResponseValues = new NumericVector[nGroups];
        StringVector[] internalLabelValues = this.labelVar == null ? null : new StringVector[nGroups];
        int grpIdx = 0;
        for (int i = 0; i < this.groupVar.getValueCount(); ++i) {
            double xVal = Double.NaN;
            double yVal = Double.NaN;
            String label = null;
            try {
                grpIdx = ((StringVariable)this.groupVar).category.getValue(i);
                xVal = this.xvalueVar.value.getValue(i);
                yVal = this.responseVar.value.getValue(i);
                if (internalXValues[grpIdx] == null) {
                    internalXValues[grpIdx] = new NumericVector();
                }
                if (internalResponseValues[grpIdx] == null) {
                    internalResponseValues[grpIdx] = new NumericVector();
                }
                if (this.labelVar != null && internalLabelValues[grpIdx] == null) {
                    internalLabelValues[grpIdx] = new StringVector();
                }
                internalXValues[grpIdx].addValue(xVal);
                internalResponseValues[grpIdx].addValue(yVal);
                if (this.labelVar == null) continue;
                label = ((NumericVariable)this.labelVar).formattedValue.getValue(i);
                internalLabelValues[grpIdx].addValue(label);
                continue;
            }
            catch (MissingValueException mve) {
                if (xVal != xVal || yVal != yVal || internalLabelValues == null) continue;
                internalLabelValues[grpIdx].addValue("");
            }
        }
        this.networkRoot.removeAllElements();
        this.loadSkinImage();
        double mappedBaseline = ((ContinuousRangeToNumericMap)rmap).getValue(this.baseline);
        ContinuousRangeToNumericMapper baselineMapper = new ContinuousRangeToNumericMapper();
        baselineMapper.input.setValue(this.baseline);
        baselineMapper.setMap((ContinuousRangeToNumericMap)rmap);
        DiscreteAttrMapper groupAttrMapper = null;
        if (this.hasAttrVar("GROUP")) {
            groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
        }
        StringToColorMap colorMap = null;
        if (this.colorVar != null && this.colorEncoder != null) {
            colorMap = (StringToColorMap)this.colorEncoder.getValueMap();
            colorMap.init(new AInitAction(null));
        }
        StringToColorMap lineColorMap = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            lineColorMap = (StringToColorMap)this.lineColorEncoder.getValueMap();
            lineColorMap.init(new AInitAction(null));
        }
        HashMap lineAttrsMap = null;
        if (this.lineVar != null && this.lineEncoder != null) {
            lineAttrsMap = this.lineEncoder.getLineAttrsMap();
        }
        StringToNumberMap fillPatternMap = null;
        if (this.fillPatternEncoder != null) {
            fillPatternMap = (StringToNumberMap)this.fillPatternEncoder.getValueMap();
            fillPatternMap.init(new AInitAction(null));
        }
        StringToColorMap fillPatternColorMap = null;
        if (this.fillPatternColorEncoder != null) {
            fillPatternColorMap = (StringToColorMap)this.fillPatternColorEncoder.getValueMap();
            fillPatternColorMap.init(new AInitAction(null));
        }
        StringToColorMap labelColorMap = null;
        if (this.dataLabelColorEncoder != null) {
            labelColorMap = (StringToColorMap)this.dataLabelColorEncoder.getValueMap();
            labelColorMap.init(new AInitAction(null));
        }
        for (int gIdx = 0; gIdx < this.groupVar.getUniqueValueCount(); ++gIdx) {
            ContinuousRangeToNumericMapper positionPipe;
            String groupValue;
            try {
                groupValue = this.groupVar.formattedUniqueValue.getValue(gIdx);
            }
            catch (MissingValueException mve) {
                groupValue = null;
            }
            if (internalXValues[gIdx] == null || internalResponseValues[gIdx] == null) continue;
            ContinuousRangeToNumericMapper midpointMapper = new ContinuousRangeToNumericMapper();
            midpointMapper.setMap((ContinuousRangeToNumericMap)xmap);
            ContinuousRangeToNumericMapper leftMapper = new ContinuousRangeToNumericMapper();
            leftMapper.setMap((ContinuousRangeToNumericMap)xmap);
            ContinuousRangeToNumericMapper rightMapper = new ContinuousRangeToNumericMapper();
            rightMapper.setMap((ContinuousRangeToNumericMap)xmap);
            this.responseMapper = new ContinuousRangeToNumericMapper();
            this.responseMapper.setMap((ContinuousRangeToNumericMap)rmap);
            switch (this.xValues) {
                default: {
                    midpointMapper.input.connectFrom((NumericPipe)internalXValues[gIdx]);
                    Calculator left = new Calculator("inA-inB/2");
                    left.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    left.inB.setValue(this.constBinSize);
                    leftMapper.input.connectFrom((NumericPipe)left);
                    Calculator right = new Calculator("inA+inB/2");
                    right.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    right.inB.setValue(this.constBinSize);
                    rightMapper.input.connectFrom((NumericPipe)right);
                    break;
                }
                case 1: {
                    Calculator midpoint = new Calculator("inA+inB/2");
                    midpoint.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    midpoint.inB.setValue(this.constBinSize);
                    midpointMapper.input.connectFrom((NumericPipe)midpoint);
                    leftMapper.input.connectFrom((NumericPipe)internalXValues[gIdx]);
                    Calculator right = new Calculator("inA+inB");
                    right.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    right.inB.setValue(this.constBinSize);
                    rightMapper.input.connectFrom((NumericPipe)right);
                    break;
                }
                case 2: {
                    Calculator midpoint = new Calculator("inA-inB/2");
                    midpoint.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    midpoint.inB.setValue(this.constBinSize);
                    midpointMapper.input.connectFrom((NumericPipe)midpoint);
                    Calculator left = new Calculator("inA-inB");
                    left.inA.connectFrom((NumericPipe)internalXValues[gIdx]);
                    left.inB.setValue(this.constBinSize);
                    leftMapper.input.connectFrom((NumericPipe)left);
                    rightMapper.input.connectFrom((NumericPipe)internalXValues[gIdx]);
                }
            }
            Calculator width = new Calculator("inB-inA");
            width.inA.connectFrom((NumericPipe)leftMapper);
            width.inB.connectFrom((NumericPipe)rightMapper);
            this.responseMapper.input.connectFrom((NumericPipe)internalResponseValues[gIdx]);
            Calculator height = new Calculator("inA-inB");
            height.inA.connectFrom((NumericPipe)this.responseMapper);
            height.inB.connectFrom((NumericPipe)baselineMapper);
            Calculator middle = new Calculator("(inA+inB)/2");
            middle.inA.setValue(mappedBaseline);
            middle.inB.connectFrom((NumericPipe)this.responseMapper);
            this.probe = new Probe();
            this.probe.setTrimOn(true);
            this.probe.addPipe(this.xvalueVar.getLabel(), (Pipe)internalXValues[gIdx]);
            this.probe.addPipe(this.responseVar.getLabel(), (Pipe)internalResponseValues[gIdx]);
            this.probe.addString(this.groupVar.getLabel(), groupValue);
            this.bar = new Bar();
            this.bar.setUserData((Object)this.probe);
            this.bar.setTwoD(true);
            this.bar.VGFRenderModeOn.setValue(StatGraph.VGF);
            this.bar.setSubpixelRendering(this.subpixelRendering);
            this.networkRoot.addElement((Element)this.bar);
            if (logMap) {
                Calculator pos = new Calculator("inA+inB/2");
                pos.inA.connectFrom((NumericPipe)leftMapper);
                pos.inB.connectFrom((NumericPipe)width);
                positionPipe = pos;
            } else {
                positionPipe = midpointMapper;
            }
            if (this.orientation == 0) {
                this.bar.verticalOn.setValue(true);
                this.bar.position.connectFrom((NumericPipe)positionPipe);
                this.bar.thickness.connectFrom((NumericPipe)width);
                this.bar.startValue.connectFrom((NumericPipe)baselineMapper);
                this.bar.endValue.connectFrom((NumericPipe)this.responseMapper);
            } else {
                this.bar.verticalOn.setValue(false);
                this.bar.position.connectFrom((NumericPipe)positionPipe);
                this.bar.thickness.connectFrom((NumericPipe)width);
                this.bar.startValue.connectFrom((NumericPipe)baselineMapper);
                this.bar.endValue.connectFrom((NumericPipe)this.responseMapper);
            }
            this.bar.edgeOn.setValue(this.edgeOn);
            if (this.edgeOn) {
                if (groupAttrMapper != null && groupAttrMapper.getLineColor(groupValue) != null) {
                    this.bar.edgeColor.setValue(this.applyDataTransparency(groupAttrMapper.getLineColor(groupValue)));
                } else if (lineColorMap != null) {
                    this.bar.edgeColor.setValue(lineColorMap.getValue(groupValue));
                } else {
                    this.bar.edgeColor.setValue(this.applyDataTransparency(this.edgeStyle.getColor()));
                }
                if (!this.useLineThickness && groupAttrMapper != null && groupAttrMapper.getLineThickness(groupValue) >= 0) {
                    this.bar.edgeWidth.setValue((double)groupAttrMapper.getLineThickness(groupValue));
                } else {
                    this.bar.edgeWidth.setValue((double)this.edgeStyle.getWidth());
                }
                if (!this.fillOn && lineAttrsMap != null) {
                    LineAttrs la = (LineAttrs)lineAttrsMap.get(groupValue);
                    this.bar.edgePattern.setValue(la.getLinePattern());
                } else {
                    this.bar.edgePattern.setValue(this.edgeStyle.getLinePattern());
                }
            }
            this.bar.fillOn.setValue(this.fillOn);
            if (this.fillOn) {
                if (groupAttrMapper != null && groupAttrMapper.getFillColor(groupValue) != null) {
                    Color c = groupAttrMapper.getFillColor(groupValue);
                    if (this.useFillTransparency) {
                        this.bar.color1.setValue(this.applyDataTransparency(c, this.fillStyle.getTransparency()));
                    } else {
                        this.bar.color1.setValue(HistogramOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(groupValue)));
                    }
                } else if (colorMap != null) {
                    this.bar.color1.setValue(colorMap.getValue(groupValue));
                } else {
                    this.bar.color1.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
                }
                if (this.fillType == FILL_GRADIENT || this.fillType == FILL_ALPHAGRADIENT) {
                    if (this.fillType == FILL_GRADIENT) {
                        this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                    } else {
                        this.bar.color2.setValue(HistogramOverlay.alphaColor(this.bar.color1.getValue(), this.endAlpha));
                    }
                    this.bar.gradientOn.setValue(true);
                    this.bar.gradientDirection.setValue(1);
                }
            } else {
                this.bar.color1.setValue(this.edgeStyle.getColor());
            }
            this.bar.fillPatternOn.setValue(this.fillPatternOn);
            if (this.fillPatternOn) {
                if (fillPatternMap != null) {
                    try {
                        this.bar.fillPatternType.setValue(BarOverlay.getGLFillPattern((int)fillPatternMap.getValue((Object)groupValue)));
                        this.bar.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)((int)fillPatternMap.getValue((Object)groupValue))));
                    }
                    catch (MissingValueException mve) {
                        this.bar.fillPatternType.setValue(BarOverlay.getGLFillPattern(this.fillPatternStyle.getPattern()));
                        this.bar.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)this.fillPatternStyle.getPattern()));
                    }
                } else {
                    this.bar.fillPatternType.setValue(BarOverlay.getGLFillPattern(this.fillPatternStyle.getPattern()));
                    this.bar.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)this.fillPatternStyle.getPattern()));
                }
                if (groupAttrMapper != null && groupAttrMapper.getLineColor(groupValue) != null) {
                    this.bar.fillPatternColor.setValue(this.applyDataTransparency(groupAttrMapper.getLineColor(groupValue)));
                } else if (fillPatternColorMap != null) {
                    this.bar.fillPatternColor.setValue(fillPatternColorMap.getValue(groupValue));
                } else {
                    this.bar.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
                }
                this.bar.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
            }
            this.bar.setSkin(this.skinImage);
            this.bar.setSkinType(this.skinType);
            this.bar.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            this.bar.setPixelBenderImages(this.pixelBenderImages);
            if (!this.showLabel || this.labelDropped) continue;
            RasterLabel label = new RasterLabel();
            this.networkRoot.addElement((Element)label);
            label.string.connectFrom((StringPipe)internalLabelValues[gIdx]);
            label.trimOn.setValue(true);
            if (labelColorMap != null) {
                label.color.setValue(labelColorMap.getValue(groupValue));
            } else {
                label.color.setValue(this.labelStyle.getColor());
            }
            label.fontName.setValue(this.labelStyle.getFont().getName());
            label.fontSize.setValue(this.labelStyle.getFont().getSize());
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
            label.angle.setValue(this.labelRotated ? 90.0 : 0.0);
            Calculator trans = new Calculator("inA + inB");
            NumericVector offset = new NumericVector();
            trans.inA.connectFrom((NumericPipe)this.responseMapper);
            trans.inB.connectFrom((NumericPipe)offset);
            IntegerVector just = new IntegerVector();
            boolean reverse = this.orientation == 0 ? this.yEncoder.isReversed() : this.xEncoder.isReversed();
            for (int i = 0; i < internalLabelValues[gIdx].size(); ++i) {
                if (reverse) {
                    offset.addValue((double)(-this.extraPadding));
                    if (this.orientation == 0) {
                        just.addValue(0);
                        continue;
                    }
                    just.addValue(2);
                    continue;
                }
                offset.addValue((double)this.extraPadding);
                if (this.orientation == 0) {
                    just.addValue(3);
                    continue;
                }
                just.addValue(0);
            }
            if (this.orientation == 0) {
                label.transform.translateX.connectFrom((NumericPipe)positionPipe);
                label.transform.translateY.connectFrom((NumericPipe)trans);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.connectFrom((IntegerPipe)just);
                continue;
            }
            label.transform.translateY.connectFrom((NumericPipe)positionPipe);
            label.transform.translateX.connectFrom((NumericPipe)trans);
            label.horizontalJustification.connectFrom((IntegerPipe)just);
            label.verticalJustification.setValue(1);
        }
        this.needConnect = false;
        return true;
    }

    @Override
    protected boolean connectNetwork() {
        ContinuousRangeToNumericMapper positionPipe;
        if (this.groupVar != null) {
            return this.connectGroupedNetwork();
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xvalueVar == null) {
            return false;
        }
        if (this.responseVar == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.yEncoder == null) {
            return false;
        }
        PositionEncoder ve = null;
        ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        ValueMap map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper midpointMapper = new ContinuousRangeToNumericMapper();
        midpointMapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper leftMapper = new ContinuousRangeToNumericMapper();
        leftMapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper rightMapper = new ContinuousRangeToNumericMapper();
        rightMapper.setMap((ContinuousRangeToNumericMap)map);
        boolean logMap = map instanceof ContinuousRangeToLogarithmicMap;
        ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
        map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.responseMapper = new ContinuousRangeToNumericMapper();
        this.responseMapper.setMap((ContinuousRangeToNumericMap)map);
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            this.responseVar.setFormat(new GTKFormat((Format)format));
        }
        switch (this.xValues) {
            default: {
                midpointMapper.input.connectFrom(this.xvalueVar.value);
                Calculator left = new Calculator("inA-inB/2");
                left.inA.connectFrom(this.xvalueVar.value);
                left.inB.setValue(this.constBinSize);
                leftMapper.input.connectFrom((NumericPipe)left);
                Calculator right = new Calculator("inA+inB/2");
                right.inA.connectFrom(this.xvalueVar.value);
                right.inB.setValue(this.constBinSize);
                rightMapper.input.connectFrom((NumericPipe)right);
                break;
            }
            case 1: {
                Calculator midpoint = new Calculator("inA+inB/2");
                midpoint.inA.connectFrom(this.xvalueVar.value);
                midpoint.inB.setValue(this.constBinSize);
                midpointMapper.input.connectFrom((NumericPipe)midpoint);
                leftMapper.input.connectFrom(this.xvalueVar.value);
                Calculator right = new Calculator("inA+inB");
                right.inA.connectFrom(this.xvalueVar.value);
                right.inB.setValue(this.constBinSize);
                rightMapper.input.connectFrom((NumericPipe)right);
                break;
            }
            case 2: {
                Calculator midpoint = new Calculator("inA-inB/2");
                midpoint.inA.connectFrom(this.xvalueVar.value);
                midpoint.inB.setValue(this.constBinSize);
                midpointMapper.input.connectFrom((NumericPipe)midpoint);
                Calculator left = new Calculator("inA-inB");
                left.inA.connectFrom(this.xvalueVar.value);
                left.inB.setValue(this.constBinSize);
                leftMapper.input.connectFrom((NumericPipe)left);
                rightMapper.input.connectFrom(this.xvalueVar.value);
            }
        }
        Calculator width = new Calculator("inB-inA");
        width.inA.connectFrom((NumericPipe)leftMapper);
        width.inB.connectFrom((NumericPipe)rightMapper);
        double mappedBaseline = this.responseMapper.getValue(this.baseline);
        ContinuousRangeToNumericMapper baselineMapper = new ContinuousRangeToNumericMapper();
        baselineMapper.input.setValue(this.baseline);
        baselineMapper.setMap((ContinuousRangeToNumericMap)map);
        this.responseMapper.input.connectFrom(this.responseVar.value);
        Calculator height = new Calculator("inA-inB");
        height.inA.connectFrom((NumericPipe)this.responseMapper);
        height.inB.connectFrom((NumericPipe)baselineMapper);
        Calculator middle = new Calculator("(inA+inB)/2");
        middle.inA.setValue(mappedBaseline);
        middle.inB.connectFrom((NumericPipe)this.responseMapper);
        this.networkRoot.removeAllElements();
        this.loadSkinImage();
        this.bar.setUserData((Object)this.probe);
        this.bar.setTwoD(true);
        this.bar.VGFRenderModeOn.setValue(StatGraph.VGF);
        this.bar.setSubpixelRendering(this.subpixelRendering);
        this.networkRoot.addElement((Element)this.bar);
        if (logMap) {
            Calculator pos = new Calculator("inA+inB/2");
            pos.inA.connectFrom((NumericPipe)leftMapper);
            pos.inB.connectFrom((NumericPipe)width);
            positionPipe = pos;
        } else {
            positionPipe = midpointMapper;
        }
        if (this.orientation == 0) {
            this.bar.verticalOn.setValue(true);
            this.bar.position.connectFrom((NumericPipe)positionPipe);
            this.bar.thickness.connectFrom((NumericPipe)width);
            this.bar.startValue.connectFrom((NumericPipe)baselineMapper);
            this.bar.endValue.connectFrom((NumericPipe)this.responseMapper);
        } else {
            this.bar.verticalOn.setValue(false);
            this.bar.position.connectFrom((NumericPipe)positionPipe);
            this.bar.thickness.connectFrom((NumericPipe)width);
            this.bar.startValue.connectFrom((NumericPipe)baselineMapper);
            this.bar.endValue.connectFrom((NumericPipe)this.responseMapper);
        }
        this.bar.edgeOn.setValue(this.edgeOn);
        if (this.edgeOn) {
            this.bar.edgeColor.setValue(this.applyDataTransparency(this.edgeStyle.getColor()));
            this.bar.edgeWidth.setValue((double)this.edgeStyle.getWidth());
            this.bar.edgePattern.setValue(this.edgeStyle.getLinePattern());
        }
        this.bar.fillOn.setValue(this.fillOn);
        if (this.fillOn) {
            this.bar.color1.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
            if (this.fillType == FILL_GRADIENT || this.fillType == FILL_ALPHAGRADIENT) {
                if (this.fillType == FILL_GRADIENT) {
                    this.bar.color2.setValue(this.applyDataTransparency(this.gradientEndColor));
                } else {
                    this.bar.color2.setValue(HistogramOverlay.alphaColor(this.applyDataTransparency((ColorAttr)this.fillStyle), this.endAlpha));
                }
                this.bar.gradientOn.setValue(true);
                this.bar.gradientDirection.setValue(1);
            }
        } else {
            this.bar.color1.setValue(this.edgeStyle.getColor());
        }
        this.bar.fillPatternOn.setValue(this.fillPatternOn);
        if (this.fillPatternOn) {
            this.bar.fillPatternType.setValue(BarOverlay.getGLFillPattern(this.fillPatternStyle.getPattern()));
            this.bar.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)this.fillPatternStyle.getPattern()));
            this.bar.fillPatternColor.setValue(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
            this.bar.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        this.bar.setSkin(this.skinImage);
        this.bar.setSkinType(this.skinType);
        this.bar.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        this.bar.setPixelBenderImages(this.pixelBenderImages);
        if (this.hasSpecLimits()) {
            double usl;
            double lsl;
            this.bar.specificationLimitsOn.setValue(true);
            this.bar.specificationLimitBelowLowColor.setValue(this.applyDataTransparency((ColorAttr)this.lowerFillStyle));
            this.bar.specificationLimitAboveHighColor.setValue(this.applyDataTransparency((ColorAttr)this.upperFillStyle));
            if (this.hasLowerSpecLimit() && !Double.isNaN(lsl = this.findLowerSpecLimit())) {
                this.bar.specificationLimitLow.setValue(midpointMapper.getValue(lsl));
            }
            if (this.hasUpperSpecLimit() && !Double.isNaN(usl = this.findUpperSpecLimit())) {
                this.bar.specificationLimitHigh.setValue(midpointMapper.getValue(usl));
            }
        }
        if (this.showLabel && !this.labelDropped) {
            RasterLabel label = new RasterLabel();
            this.networkRoot.addElement((Element)label);
            if (this.dataLabelSplit) {
                label.string.connectFrom((StringPipe)this.splitDataLabelPipe);
            } else if (this.numericLabel) {
                label.string.connectFrom(((NumericVariable)this.labelVar).formattedValue);
            } else {
                label.string.connectFrom(((StringVariable)this.labelVar).formattedValue);
            }
            label.trimOn.setValue(true);
            label.color.setValue(this.labelStyle.getColor());
            label.fontName.setValue(this.labelStyle.getFont().getName());
            label.fontSize.setValue(this.labelStyle.getFont().getSize());
            label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
            label.angle.setValue(this.labelRotated ? 90.0 : 0.0);
            Calculator trans = new Calculator("inA + inB");
            NumericVector offset = new NumericVector();
            trans.inA.connectFrom((NumericPipe)this.responseMapper);
            trans.inB.connectFrom((NumericPipe)offset);
            IntegerVector just = new IntegerVector();
            boolean reverse = this.orientation == 0 ? this.yEncoder.isReversed() : this.xEncoder.isReversed();
            for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                if (reverse) {
                    offset.addValue((double)(-this.extraPadding));
                    if (this.orientation == 0) {
                        just.addValue(0);
                        continue;
                    }
                    just.addValue(2);
                    continue;
                }
                offset.addValue((double)this.extraPadding);
                if (this.orientation == 0) {
                    just.addValue(3);
                    continue;
                }
                just.addValue(0);
            }
            if (this.orientation == 0) {
                label.transform.translateX.connectFrom((NumericPipe)positionPipe);
                label.transform.translateY.connectFrom((NumericPipe)trans);
                label.horizontalJustification.setValue(1);
                label.verticalJustification.connectFrom((IntegerPipe)just);
            } else {
                label.transform.translateY.connectFrom((NumericPipe)positionPipe);
                label.transform.translateX.connectFrom((NumericPipe)trans);
                label.horizontalJustification.connectFrom((IntegerPipe)just);
                label.verticalJustification.setValue(1);
            }
        }
        this.needConnect = false;
        return true;
    }

    protected void connectVars() {
        if (this.model == null) {
            return;
        }
        CRD crd = this.model;
        this.xvalueVar = null;
        if (crd.isAvailable(13)) {
            if (crd.getColumnClass(13) != Double.class) {
                StatGraph.printDebug("VBar : MIDPOINT must be numeric");
            } else {
                this.xvalueVar = (NumericVectorVariable)this.connectRaw((short)13);
            }
        }
        this.responseVar = null;
        if (crd.isAvailable(2)) {
            if (crd.getColumnClass(2) != Double.class) {
                StatGraph.printDebug("VBar : RESPONSE must be numeric");
            } else {
                this.responseVar = (NumericVectorVariable)this.connectRaw((short)2);
            }
        }
        if (crd.isAvailable(53)) {
            this.lowerSpecLimitVar = (NumericVectorVariable)this.connectRaw((short)53);
        }
        if (crd.isAvailable(54)) {
            this.upperSpecLimitVar = (NumericVectorVariable)this.connectRaw((short)54);
        }
        if (crd.isAvailable(5)) {
            this.numericLabel = crd.getColumnClass(5) == Double.class;
            this.labelVar = this.connectRaw((short)5);
            this.showLabel = true;
        } else {
            this.labelVar = null;
            this.showLabel = false;
        }
        if (crd.isAvailable(3)) {
            this.numericGroup = crd.getColumnClass(3) == Double.class;
            this.groupVar = this.connectCategory((short)3, this.missingGroupOn);
            this.rawGroupVar = this.connectRaw((short)3);
        } else {
            this.groupVar = null;
        }
        this.colorVar = crd.isAvailable(6) ? this.connectCategory((short)6, true) : null;
        this.lineColorVar = crd.isAvailable(46) ? this.connectCategory((short)46, true) : null;
        this.lineVar = crd.isAvailable(36) ? this.connectCategory((short)36, true) : null;
        VariableProcessor vp = null;
        if (this.model.whereExpression != null || this.groupVar != null && (this.groupOrder == 1 || this.groupOrder == 2)) {
            vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)this.xvalueVar);
            this.addVarToVP(vp, (Variable)this.responseVar);
            this.addVarToVP(vp, (Variable)this.lowerSpecLimitVar);
            this.addVarToVP(vp, (Variable)this.upperSpecLimitVar);
            this.addVarToVP(vp, this.labelVar);
            this.addVarToVP(vp, this.groupVar);
            this.addVarToVP(vp, this.rawGroupVar);
            this.addVarToVP(vp, this.colorVar);
            this.addVarToVP(vp, this.lineColorVar);
            this.addVarToVP(vp, this.lineVar);
            if (this.rawGroupVar != null) {
                if (this.getGroupOrder() == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.rawGroupVar, 1);
                    }
                } else if (this.getGroupOrder() == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.rawGroupVar, 2);
                    }
                }
                this.rawGroupVar.setSortByFormattedValues(this.rawGroupVar instanceof StringVariable);
            }
            this.addCRDWhereClause(vp);
        }
        if (this.groupVar == null) {
            this.probe = new Probe();
            this.probe.setTrimOn(true);
            if (crd.isAvailable(300)) {
                this.addCustomTips(vp);
            } else {
                this.addTooltip(vp, "X");
                this.addTooltip(vp, "Y");
                this.addTooltip(vp, "GROUP");
            }
        }
        if (this.defaultBinSize > 0.0) {
            this.constBinSize = this.defaultBinSize;
        } else if (this.xvalueVar != null) {
            double minDiff = 2.0;
            GTKFormat fmt = this.xvalueVar.getFormat();
            this.xvalueVar.setFormat(null);
            int num = this.xvalueVar.getUniqueValueCount();
            if (num < 2) {
                this.xvalueVar.setFormat(fmt);
                return;
            }
            if (this.groupVar == null) {
                double prev = 0.0;
                NumericVariable newXValueVar = this.xvalueVar;
                if (this.sortXValues) {
                    newXValueVar = new NumericVariable();
                    newXValueVar.connectFrom(this.xvalueVar);
                    newXValueVar.setUniqueValueSort(1);
                    newXValueVar.setSortByFormattedValues(false);
                    newXValueVar.getUniqueValueCount();
                    newXValueVar.getValueCount();
                }
                int iOffset = 0;
                try {
                    prev = newXValueVar.uniqueValue.getValue(0);
                }
                catch (MissingValueException mve) {
                    try {
                        prev = newXValueVar.uniqueValue.getValue(1);
                        iOffset = 1;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                double mid = 0.0;
                boolean badBin = false;
                for (int i = 1 + iOffset; i < num; ++i) {
                    try {
                        mid = newXValueVar.uniqueValue.getValue(i);
                        if (i == 1 + iOffset) {
                            minDiff = mid - prev;
                        } else {
                            if (Math.abs(mid - prev - minDiff) > 1.0E-6 * minDiff) {
                                badBin = true;
                            }
                            minDiff = Math.min(minDiff, mid - prev);
                        }
                        prev = mid;
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                if (badBin) {
                    StatGraph.printWarning(RB.getStringResource(RB_KEY, "bin.txt"));
                }
                if (minDiff < 0.0) {
                    StatGraph.printWarning(RB.getStringResource(RB_KEY, "bin2.txt"));
                }
            } else {
                try {
                    minDiff = this.xvalueVar.uniqueValue.getValue(1) - this.xvalueVar.uniqueValue.getValue(0);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.constBinSize = Math.abs(minDiff);
            this.xvalueVar.setFormat(fmt);
        }
    }

    protected DataRange getIndRange() {
        ContinuousRange range = null;
        if (this.xvalueVar != null) {
            int num = this.xvalueVar.getValueCount();
            if (num > 0) {
                boolean subset = this.orientation == 0 ? !this.xUnionAllPages : !this.yUnionAllPages;
                range = this.makeContinuousRange(this.xvalueVar, (short)13, subset);
                double min = range.getMin();
                double max = range.getMax();
                double halfbin1 = 0.0;
                double halfbin2 = 0.0;
                if (this.binAxis) {
                    SimpleBinnedRange sbr = new SimpleBinnedRange();
                    sbr.setEndLabels(this.endLabels);
                    range = sbr;
                    sbr.setBinSize(this.constBinSize);
                    switch (this.xValues) {
                        default: {
                            sbr.setFirstMidpoint(min);
                            sbr.setLastMidpoint(max);
                            break;
                        }
                        case 1: {
                            sbr.setFirstMidpoint(min + this.constBinSize / 2.0);
                            sbr.setLastMidpoint(max + this.constBinSize / 2.0);
                            break;
                        }
                        case 2: {
                            sbr.setFirstMidpoint(min - this.constBinSize / 2.0);
                            sbr.setLastMidpoint(max - this.constBinSize / 2.0);
                            break;
                        }
                    }
                } else {
                    switch (this.xValues) {
                        default: {
                            min -= this.constBinSize / 2.0;
                            max += this.constBinSize / 2.0;
                            break;
                        }
                        case 1: {
                            max += this.constBinSize;
                            break;
                        }
                        case 2: {
                            min -= this.constBinSize;
                        }
                    }
                    range = new ContinuousRange(min, max);
                }
                if (this.binAxis) {
                    ContinuousRange cr = new ContinuousRange((DataRange)range);
                    range.setDual((DataRange)cr);
                }
                if (this.xvalueVar instanceof NumericVectorVariable) {
                    range.setLabel(this.xvalueVar.getLabel());
                }
            } else {
                range = null;
            }
        }
        return range;
    }

    protected DataRange getDepRange() {
        ContinuousRange range = null;
        if (this.responseVar != null) {
            int num = this.responseVar.getValueCount();
            if (num > 0) {
                boolean subset = this.orientation == 0 ? !this.yUnionAllPages : !this.xUnionAllPages;
                range = this.makeContinuousRange((NumericVariable)this.responseVar, (short)2, subset);
                double min = range.getMin();
                double max = range.getMax();
                range = new ContinuousRange(Math.min(this.baseline, min), Math.max(this.baseline, max));
                range.setLabel(this.responseVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    public double getDefaultBinSize() {
        return this.defaultBinSize;
    }

    public double getBaseline() {
        return this.baseline;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte aOrientation) {
        this.orientation = aOrientation;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
    }

    public LineAttrs getEdgeStyle() {
        return this.edgeStyle;
    }

    public void setEdgeStyle(LineAttrs s) {
        this.edgeStyle = s;
    }

    public Color getEdgeColor() {
        return this.edgeStyle.getColor();
    }

    public void setEdgeColor(Color c) {
        this.edgeStyle.setColor(c);
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternStyle(FillPatternAttrs s) {
        this.fillPatternStyle = s;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        if (dimension == 4) {
            return this.colorRange;
        }
        if (dimension == 17) {
            return this.lineColorRange;
        }
        if (dimension == 15) {
            return this.lineRange;
        }
        return null;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        Insets im = super.getPreferredInnerMargin();
        if (!this.showLabel) {
            return im;
        }
        int left = im.left;
        int right = im.right;
        int top = im.top;
        int bottom = im.bottom;
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        this.extraPadding = (int)Math.ceil((double)fm.getHeight() * (0.15 * StatGraph.gapScaleFactor));
        if (this.getOrientation() == 1) {
            this.extraPadding *= 2;
        }
        int fmHeight = fm.getHeight() + this.extraPadding * 2;
        int longestWidth = 0;
        for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
            try {
                String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                int w = fm.stringWidth(s);
                if (w <= longestWidth) continue;
                longestWidth = w;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        longestWidth += this.extraPadding * 2;
        double min = this.responseVar.getMin();
        double max = this.responseVar.getMax();
        if (this.getOrientation() == 0) {
            double space;
            this.labelRotated = false;
            this.labelDropped = false;
            this.dataLabelSplit = false;
            if (this.dataLabelFitPolicy == DATALABEL_FIT_AUTO && this.areLabelsColliding(longestWidth - this.extraPadding * 2, this.xEncoder, false)) {
                if (this.numericLabel) {
                    this.labelRotated = true;
                } else {
                    this.dataLabelSplit = true;
                }
            } else if (this.dataLabelFitPolicy == DATALABEL_FIT_ROTATE && this.areLabelsColliding(longestWidth - this.extraPadding * 2, this.xEncoder, false)) {
                this.labelRotated = true;
            } else if (this.dataLabelFitPolicy == DATALABEL_FIT_SPLIT || this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS) {
                this.dataLabelSplit = true;
            }
            if (this.labelRotated) {
                boolean bl = this.labelDropped = this.dataLabelFitPolicy == DATALABEL_FIT_AUTO && this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.xEncoder, true);
                if (this.labelDropped) {
                    return im;
                }
                longestWidth += this.extraPadding * 2;
                fmHeight += this.extraPadding * 2;
                this.extraPadding *= 2;
                if (this.initialFitting) {
                    Insets im1 = this.getInnerMarginWithRotatedLabels(longestWidth, fmHeight, im, false);
                    Insets im2 = this.getInnerMarginWithRotatedLabels(longestWidth, fmHeight, im, true);
                    double wt1 = 0.3;
                    double wt2 = 0.7;
                    return new Insets((int)((double)im1.top * wt1 + (double)im2.top * wt2), (int)((double)im1.left * wt1 + (double)im2.left * wt2), (int)((double)im1.bottom * wt1 + (double)im2.bottom * wt2), (int)((double)im1.right * wt1 + (double)im2.right * wt2));
                }
                Insets im2 = this.getInnerMarginWithRotatedLabels(longestWidth, fmHeight, im, true);
                return im2;
            }
            if (this.dataLabelSplit) {
                return this.getInnerMarginWithSplittedLabels(im, !this.initialFitting);
            }
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
            if (this.yEncoder.isReversed()) {
                space = (map.getInputMin() - max) * ratio;
                if (space < (double)fmHeight) {
                    bottom = (int)((double)bottom + ((double)fmHeight - space));
                }
            } else {
                space = (map.getInputMax() - max) * ratio;
                if (space < (double)fmHeight) {
                    top = (int)((double)top + ((double)fmHeight - space));
                }
            }
            if (this.compact && !this.initialFitting) {
                map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
                double leftmost = this.xEncoder.getOutputMin();
                double rightmost = this.xEncoder.getOutputMax();
                double startOffset = 0.0;
                double endOffset = 0.0;
                for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                    try {
                        String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                        double w2 = Math.ceil((double)fm.stringWidth(s) * 0.5);
                        w2 += (double)this.extraPadding;
                        double xv = this.xvalueVar.value.getValue(i);
                        switch (this.xValues) {
                            default: {
                                break;
                            }
                            case 1: {
                                xv += this.constBinSize / 2.0;
                                break;
                            }
                            case 2: {
                                xv -= this.constBinSize / 2.0;
                            }
                        }
                        double x = map.getValue(xv);
                        startOffset = Math.max(startOffset, leftmost - (x - w2));
                        endOffset = Math.max(endOffset, x + w2 - rightmost);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                left = Math.max(left, (int)Math.ceil(startOffset));
                right = Math.max(right, (int)Math.ceil(endOffset));
            } else {
                int halfWidth = (int)Math.ceil((double)longestWidth * 0.5);
                double space2 = this.getFirstLabelOffset();
                if (space2 < (double)halfWidth) {
                    left = Math.max(left, halfWidth - (int)space2);
                }
                if ((space2 = this.getLastLabelOffset()) < (double)halfWidth) {
                    right = Math.max(right, halfWidth - (int)space2);
                }
            }
        } else {
            this.labelDropped = this.areLabelsColliding(fmHeight - this.extraPadding * 2, this.yEncoder, true);
            if (this.labelDropped) {
                return im;
            }
            ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            if (this.compact && !this.initialFitting) {
                double leftmost = this.xEncoder.getOutputMin();
                double rightmost = this.xEncoder.getOutputMax();
                double startOffset = 0.0;
                double endOffset = 0.0;
                for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                    try {
                        String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                        double w = fm.stringWidth(s) + this.extraPadding * 2;
                        double xv = this.responseVar.value.getValue(i);
                        double x = map.getValue(xv);
                        if (this.xEncoder.isReversed()) {
                            startOffset = Math.max(startOffset, leftmost - (x - w));
                            continue;
                        }
                        endOffset = Math.max(endOffset, x + w - rightmost);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                left += (int)Math.ceil(startOffset);
                right += (int)Math.ceil(endOffset);
            } else {
                double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                if (this.xEncoder.isReversed()) {
                    double space = (map.getInputMin() - max) * ratio;
                    if (space < (double)longestWidth) {
                        left = (int)((double)left + ((double)longestWidth - space));
                    }
                } else {
                    double space = (map.getInputMax() - max) * ratio;
                    if (space < (double)longestWidth) {
                        right = (int)((double)right + ((double)longestWidth - space));
                    }
                }
            }
            int halfHeight = (int)Math.ceil((double)fmHeight * 0.5);
            double space = this.getLastLabelOffset();
            if (space < (double)halfHeight) {
                top = Math.max(top, halfHeight - (int)space);
            }
            if ((space = this.getFirstLabelOffset()) < (double)halfHeight) {
                bottom = Math.max(bottom, halfHeight - (int)space);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    private double getFirstLabelOffset() {
        PositionEncoder encoder;
        if (this.getOrientation() == 0) {
            if (this.xRange == null) {
                return 0.0;
            }
            encoder = this.xEncoder;
        } else {
            if (this.yRange == null) {
                return 0.0;
            }
            encoder = this.yEncoder;
        }
        double min = encoder.isReversed() ? this.xvalueVar.getMax() : this.xvalueVar.getMin();
        switch (this.xValues) {
            default: {
                break;
            }
            case 1: {
                min += this.constBinSize / 2.0;
                break;
            }
            case 2: {
                min -= this.constBinSize / 2.0;
            }
        }
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)encoder.getValueMap();
        double inputMin = map.getInputMin();
        if (min < inputMin) {
            while (min < inputMin) {
                min += this.constBinSize;
            }
        }
        return map.getValue(min) - map.getOutputMin();
    }

    private double getLastLabelOffset() {
        PositionEncoder encoder;
        if (this.getOrientation() == 0) {
            if (this.xRange == null) {
                return 0.0;
            }
            encoder = this.xEncoder;
        } else {
            if (this.yRange == null) {
                return 0.0;
            }
            encoder = this.yEncoder;
        }
        double max = encoder.isReversed() ? this.xvalueVar.getMin() : this.xvalueVar.getMax();
        switch (this.xValues) {
            default: {
                break;
            }
            case 1: {
                max += this.constBinSize / 2.0;
                break;
            }
            case 2: {
                max -= this.constBinSize / 2.0;
            }
        }
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)encoder.getValueMap();
        double inputMax = map.getInputMax();
        if (max > inputMax) {
            while (max > inputMax) {
                max -= this.constBinSize;
            }
        }
        return map.getOutputMax() - map.getValue(max);
    }

    private boolean areLabelsColliding(double labelWidth, PositionEncoder encoder, boolean fixedLabelWidth) {
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)encoder.getValueMap();
        if (crnm instanceof ContinuousRangeToLogarithmicMap) {
            ContinuousRangeToNumericMapper leftMapper = new ContinuousRangeToNumericMapper();
            leftMapper.setMap(crnm);
            ContinuousRangeToNumericMapper rightMapper = new ContinuousRangeToNumericMapper();
            rightMapper.setMap(crnm);
            Calculator left = new Calculator("inA-inB/2");
            left.inA.connectFrom(this.xvalueVar.value);
            left.inB.setValue(this.constBinSize);
            leftMapper.input.connectFrom((NumericPipe)left);
            Calculator right = new Calculator("inA+inB/2");
            right.inA.connectFrom(this.xvalueVar.value);
            right.inB.setValue(this.constBinSize);
            rightMapper.input.connectFrom((NumericPipe)right);
            Calculator width = new Calculator("inB-inA");
            width.inA.connectFrom((NumericPipe)leftMapper);
            width.inB.connectFrom((NumericPipe)rightMapper);
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            int n = this.xvalueVar.getValueCount();
            for (int i = 0; i < n; ++i) {
                try {
                    double w;
                    if (fixedLabelWidth) {
                        w = labelWidth;
                    } else {
                        String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                        w = fm.stringWidth(s);
                    }
                    if (!(width.getValue(i) <= w)) continue;
                    return true;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            return false;
        }
        double x1 = crnm.getValue(0.0);
        double x2 = crnm.getValue(this.constBinSize);
        double barSize = Math.abs(x2 - x1);
        return barSize <= labelWidth;
    }

    private Insets getInnerMarginWithRotatedLabels(int longestWidth, int fmHeight, Insets initialIM, boolean compact) {
        int top = initialIM.top;
        int left = initialIM.left;
        int bottom = initialIM.bottom;
        int right = initialIM.right;
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        if (compact) {
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            double bottommost = this.yEncoder.getOutputMin();
            double topmost = this.yEncoder.getOutputMax();
            double startOffset = 0.0;
            double endOffset = 0.0;
            for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                try {
                    String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                    double w = fm.stringWidth(s) + this.extraPadding * 2;
                    double yv = this.responseVar.value.getValue(i);
                    double y = map.getValue(yv);
                    if (y < bottommost - ZERO_VALUE || y > topmost + ZERO_VALUE) continue;
                    if (this.yEncoder.isReversed()) {
                        startOffset = Math.max(startOffset, bottommost - (y - w));
                        continue;
                    }
                    endOffset = Math.max(endOffset, y + w - topmost);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            bottom += (int)Math.ceil(startOffset);
            top += (int)Math.ceil(endOffset);
        } else {
            double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
            double max = this.responseVar.getMax();
            if (this.yEncoder.isReversed()) {
                double space = (map.getInputMin() - max) * ratio;
                if (space < (double)longestWidth) {
                    bottom = (int)((double)bottom + ((double)longestWidth - space));
                }
            } else {
                double space = (map.getInputMax() - max) * ratio;
                if (space < (double)longestWidth) {
                    top = (int)((double)top + ((double)longestWidth - space));
                }
            }
        }
        int halfHeight = (int)Math.ceil((double)fmHeight * 0.5) + StatGraph.getExtraPadding();
        double space = this.getLastLabelOffset();
        if (space < (double)halfHeight) {
            right = Math.max(right, halfHeight - (int)space);
        }
        if ((space = this.getFirstLabelOffset()) < (double)halfHeight) {
            left = Math.max(left, halfHeight - (int)space);
        }
        return new Insets(top, left, bottom, right);
    }

    private Insets getInnerMarginWithSplittedLabels(Insets initialIM, boolean compact) {
        int top = initialIM.top;
        int left = initialIM.left;
        int bottom = initialIM.bottom;
        int right = initialIM.right;
        this.splitDataLabelPipe = new StringVector();
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double splitWidth = Math.abs(crnm.getValue(this.constBinSize) - crnm.getValue(0.0));
        boolean splitAlways = this.dataLabelFitPolicy == DATALABEL_FIT_SPLITALWAYS;
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        ContinuousRangeToNumericMap map = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double bottommost = this.yEncoder.getOutputMin();
        double topmost = this.yEncoder.getOutputMax();
        double startOffset = 0.0;
        double endOffset = 0.0;
        double[] labelW = new double[this.labelVar.getValueCount()];
        double longestWidth = 0.0;
        for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
            double h;
            try {
                String[] labs;
                String s = this.numericLabel ? ((NumericVariable)this.labelVar).formattedValue.getValue(i).trim() : ((StringVariable)this.labelVar).formattedValue.getValue(i).trim();
                double w = fm.stringWidth(s);
                h = fm.getHeight();
                if (!(s.length() < 2 || !splitAlways && !(w > splitWidth) || (labs = HistogramOverlay.splitLabel(s, splitAlways, splitWidth, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, fm)).length < 2 && labs[0].equals(s))) {
                    s = labs[0];
                    w = fm.stringWidth(s);
                    for (int j = 1; j < labs.length; ++j) {
                        w = Math.max(w, (double)fm.stringWidth(labs[j]));
                        s = s + '\n';
                        s = s + labs[j];
                    }
                    h *= (double)labs.length;
                }
                this.splitDataLabelPipe.addValue(s);
                labelW[i] = w;
                h += (double)(this.extraPadding * 2);
                longestWidth = Math.max(longestWidth, w);
            }
            catch (MissingValueException e) {
                this.splitDataLabelPipe.addValue("");
                labelW[i] = 0.0;
                h = 0.0;
            }
            try {
                double yv = this.responseVar.value.getValue(i);
                double y = map.getValue(yv);
                if (y < bottommost - ZERO_VALUE || y > topmost + ZERO_VALUE) continue;
                if (this.yEncoder.isReversed()) {
                    startOffset = Math.max(startOffset, bottommost - (y - h));
                    continue;
                }
                endOffset = Math.max(endOffset, y + h - topmost);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        bottom += (int)Math.ceil(startOffset);
        top += (int)Math.ceil(endOffset);
        if (compact) {
            map = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            double leftmost = this.xEncoder.getOutputMin();
            double rightmost = this.xEncoder.getOutputMax();
            startOffset = 0.0;
            endOffset = 0.0;
            for (int i = 0; i < this.labelVar.getValueCount(); ++i) {
                try {
                    double w2 = Math.ceil(labelW[i] * 0.5);
                    w2 += (double)this.extraPadding;
                    double xv = this.xvalueVar.value.getValue(i);
                    switch (this.xValues) {
                        default: {
                            break;
                        }
                        case 1: {
                            xv += this.constBinSize / 2.0;
                            break;
                        }
                        case 2: {
                            xv -= this.constBinSize / 2.0;
                        }
                    }
                    double x = map.getValue(xv);
                    startOffset = Math.max(startOffset, leftmost - (x - w2));
                    endOffset = Math.max(endOffset, x + w2 - rightmost);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            left = Math.max(left, (int)Math.ceil(startOffset));
            right = Math.max(right, (int)Math.ceil(endOffset));
        } else {
            int halfWidth = (int)Math.ceil(longestWidth * 0.5);
            double space = this.getFirstLabelOffset();
            if (space < (double)halfWidth) {
                left = Math.max(left, halfWidth - (int)space);
            }
            if ((space = this.getLastLabelOffset()) < (double)halfWidth) {
                right = Math.max(right, halfWidth - (int)space);
            }
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double scale = 0.0;
        if (!this.binAxis) {
            if (dimension == 1) {
                if (this.orientation == 0 && this.xRange != null && this.xEncoder.getValueMap() instanceof ContinuousRangeToNumericMap) {
                    ContinuousRangeToNumericMap vm = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
                    double min = ((ContinuousRange)this.xRange).getMin();
                    double binWidth = vm.getValue(min + this.constBinSize) - vm.getValue(min);
                    return 0.25 * binWidth;
                }
            } else if (this.orientation == 1 && this.yRange != null && this.yEncoder.getValueMap() instanceof ContinuousRangeToNumericMap) {
                ContinuousRangeToNumericMap vm = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
                double min = ((ContinuousRange)this.yRange).getMin();
                double binWidth = vm.getValue(min + this.constBinSize) - vm.getValue(min);
                return 0.25 * binWidth;
            }
            return scale;
        }
        SimpleBinnedRange mr = null;
        PositionEncoder ec = null;
        if (dimension == 1 && this.orientation == 0 && this.xEncoder != null) {
            ec = this.xEncoder;
            mr = (SimpleBinnedRange)this.xRange;
            if (this.xEncoder.getInput() instanceof SimpleBinnedRange) {
                mr = (SimpleBinnedRange)this.xEncoder.getInput();
            }
        } else if (dimension == 2 && this.orientation == 1 && this.yEncoder != null) {
            ec = this.yEncoder;
            mr = (SimpleBinnedRange)this.yRange;
            if (this.yEncoder.getInput() instanceof SimpleBinnedRange) {
                mr = (SimpleBinnedRange)this.yEncoder.getInput();
            }
        } else {
            return scale;
        }
        if (mr != null) {
            int bcnt = mr.getNumBins();
            double interval = (ec.getUpperLimit() - ec.getLowerLimit()) / (double)bcnt;
            if (bcnt > 1 && ec.getInput() instanceof ContinuousRange) {
                ContinuousRangeToNumericMap vm = (ContinuousRangeToNumericMap)ec.getValueMap();
                double first = mr.getFirstMidpoint() - mr.getBinSize() / 2.0;
                double last = mr.getLastMidpoint() + mr.getBinSize() / 2.0;
                if (first > vm.getInputMin() || last < vm.getInputMax()) {
                    if (vm.getInputMin() < first && vm.getInputMax() > last) {
                        return scale;
                    }
                    interval = (vm.getValue(mr.getLastMidpoint()) - vm.getValue(mr.getFirstMidpoint())) / (double)(bcnt - 1);
                }
            }
            scale = 0.25 * interval;
        }
        return scale;
    }

    @Override
    public Insets getInitialInnerMargin() {
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (this.getOrientation() == 0) {
            if (this.yEncoder.isReversed()) {
                top = 0;
                bottom = 5;
            } else {
                top = 5;
                bottom = 0;
            }
            left = 0;
            right = 5;
        } else {
            if (this.xEncoder.isReversed()) {
                right = 0;
                left = 5;
            } else {
                right = 5;
                left = 0;
            }
            top = 5;
            bottom = 0;
        }
        return new Insets(top, left, bottom, right);
    }

    @Override
    public int[] getLinePatterns() {
        if (!this.model.isAvailable(36)) {
            return new int[]{this.edgeStyle.getLinePattern()};
        }
        LineAttrs[] ll = this.lineEncoder.styleArray;
        HashMap ht = this.lineEncoder.styleList;
        int sort = 0;
        if (this.groupOrder == 1) {
            sort = 1;
        } else if (this.groupOrder == 2) {
            sort = 2;
        }
        String[] values = this.getUniqueValues((short)36, sort);
        int[] pattern = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            pattern[i] = -1;
            String gval = values[i];
            if (this.hasAttrVar("GROUP")) {
                DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                pattern[i] = groupAttrMapper.getLinePattern(gval);
            }
            if (pattern[i] != -1) continue;
            pattern[i] = ((LineAttrs)ht.get(gval)).getLinePattern();
        }
        return pattern;
    }

    @Override
    public int[] getLineWidths() {
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            return new int[]{this.isEdgeOn() ? this.getEdgeStyle().getWidth() : 1};
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.getEdgeStyle().getWidth());
    }

    @Override
    public Color[] getLineColors() {
        if (!this.isEdgeOn()) {
            return new Color[0];
        }
        if (!this.model.isAvailable(46)) {
            return new Color[]{this.getEdgeColor()};
        }
        HashMap ht = this.lineColorEncoder.colorList;
        String[] values = this.getLineColorValues();
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (this.hasAttrVar("GROUP")) {
                DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                Color c = groupAttrMapper.getLineColor(values[i]);
                if (c != null) {
                    colors[i] = this.applyDataTransparency(c);
                    continue;
                }
                colors[i] = (Color)ht.get(values[i]);
                continue;
            }
            colors[i] = (Color)ht.get(values[i]);
        }
        return colors;
    }

    @Override
    public String[] getGroupValues() {
        if (this.groupVar == null) {
            return null;
        }
        if (this.groupOrder == 1 || this.groupOrder == 2) {
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return this.getUniqueValues((short)3);
    }

    @Override
    public Color[] getFillColors() {
        if (this.isFillOn()) {
            if (this.colorVar != null && this.colorEncoder != null) {
                HashMap ht = this.colorEncoder.colorList;
                int sort = 0;
                if (this.groupOrder == 1) {
                    sort = 1;
                } else if (this.groupOrder == 2) {
                    sort = 2;
                }
                String[] values = this.getUniqueValues((short)6, sort);
                Color[] colors = new Color[values.length];
                for (int i = 0; i < values.length; ++i) {
                    if (this.hasAttrVar("GROUP")) {
                        DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                        Color c = groupAttrMapper.getFillColor(values[i]);
                        if (c != null) {
                            if (this.useFillTransparency) {
                                colors[i] = this.applyDataTransparency(c, this.fillStyle.getTransparency());
                                continue;
                            }
                            colors[i] = HistogramOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(values[i]));
                            continue;
                        }
                        colors[i] = (Color)ht.get(values[i]);
                        continue;
                    }
                    colors[i] = (Color)ht.get(values[i]);
                }
                return colors;
            }
            return this.getFillColors(this.fillStyle);
        }
        return this.getFillColors(null);
    }

    @Override
    public int[] getFillPatterns() {
        int[] pat;
        if (!this.isFillPatternOn()) {
            return new int[0];
        }
        if (this.fillPatternEncoder != null) {
            HashMap ht = this.fillPatternEncoder.patternList;
            int sort = 0;
            if (this.groupOrder == 1) {
                sort = 1;
            } else if (this.groupOrder == 2) {
                sort = 2;
            }
            String[] values = this.getUniqueValues((short)111, sort);
            pat = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                pat[i] = (Integer)ht.get(values[i]);
            }
        } else {
            pat = new int[]{this.fillPatternStyle.getPattern()};
        }
        return pat;
    }

    @Override
    public Color[] getFillPatternColors() {
        if (!this.isFillPatternOn()) {
            return new Color[]{null};
        }
        if (this.model.isAvailable(112)) {
            HashMap ht = this.fillPatternColorEncoder.colorList;
            String[] values = this.getLineColorValues();
            Color[] colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (this.hasAttrVar("GROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                    Color c = groupAttrMapper.getLineColor(values[i]);
                    if (c != null) {
                        colors[i] = this.applyDataTransparency(c);
                        continue;
                    }
                    colors[i] = (Color)ht.get(values[i]);
                    continue;
                }
                colors[i] = (Color)ht.get(values[i]);
            }
            return colors;
        }
        return new Color[]{this.applyDataTransparency((ColorAttr)this.fillPatternStyle)};
    }

    private void loadSkinImage() {
        if (this.dataTransparency == 1.0) {
            this.skinImage = null;
            return;
        }
        if (!this.isFillOn() || this.isExtrudedOverlay()) {
            this.skinType = 0;
        }
        this.skinImage = this.getRectangularSkinImage(this.networkRoot, this.skinType, this.orientation == 0);
        this.pixelBenderImages = this.loadPixelBenderImages(this.networkRoot, this.skinType, this.orientation == 0 ? 1 : 2);
    }

    @Override
    protected Image loadLegendSkinImage() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.getLegendSkinImage(this.networkRoot, this.skinType);
    }

    @Override
    protected Image[] loadLegendPixelBenderImages() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 1);
    }

    private LegendItem[] getGroupedLegendItems(int attrType) {
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            return this.getLegendItemsWithAttrMap(this.fixDefaultAttrType(attrType));
        }
        String[] values = this.getGroupValues();
        Color[] fcolor = this.getFillColors();
        int[] fpattern = this.getFillPatterns();
        LegendItem[] entries = null;
        if (fcolor.length == 0 && fpattern.length == 0) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            int n = values.length;
            entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null);
            }
        } else {
            if (this.skinType != 0 && this.skinImage == null) {
                this.loadSkinImage();
            }
            Image legendSkin = this.loadLegendSkinImage();
            Image[] legendPixelBender = this.loadLegendPixelBenderImages();
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            Color[] fpColor = this.getFillPatternColors();
            int n = values.length;
            entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                FillAttrs attr = new FillAttrs();
                if (fcolor.length > 0) {
                    attr.setColor(fcolor[i % fcolor.length]);
                } else {
                    attr.setColor(null);
                }
                LineAttrs attr2 = null;
                if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                    attr2 = new LineAttrs();
                    attr2.setColor(lcolor[i % lcolor.length]);
                    attr2.setLinePattern(pattern[i % pattern.length]);
                    attr2.setWidth(width[i % width.length]);
                }
                entries[i] = this.skinType != 1 && this.skinType != 2 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, legendSkin, this.skinType, legendPixelBender) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null, this.skinImage);
                if (fpattern.length <= 0) continue;
                FillPatternAttrs attr3 = new FillPatternAttrs();
                attr3.setPattern(fpattern[i % fpattern.length]);
                attr3.setColor(fpColor[i % fpColor.length]);
                entries[i].setFillPatternAttrs(attr3);
            }
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = HistogramOverlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        Color[] fcolor = this.getFillColors();
        if (this.fillOn && this.colorVar != null && this.colorEncoder != null) {
            fcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fcolor, 12, this.fillStyle.getColor(), this.fillStyle.getTransparency(), this.useFillTransparency);
        }
        int[] fpattern = this.getFillPatterns();
        if (this.fillPatternOn && this.fillPatternEncoder != null) {
            fpattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpattern, 5, this.fillPatternStyle.getPattern());
        }
        Color[] lcolor = this.getLineColors();
        if (this.edgeOn && this.lineColorVar != null && this.lineColorEncoder != null) {
            lcolor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, lcolor, 11, this.edgeStyle.getColor(), this.dataTransparency, this.useDataTransparency);
        }
        int[] pattern = this.getLinePatterns();
        if (this.edgeOn && this.lineVar != null && this.lineEncoder != null) {
            pattern = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, pattern, 3, this.edgeStyle.getLinePattern());
        }
        int[] width = this.getLineWidths();
        if (!this.useLineThickness) {
            width = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, width, 4, this.edgeStyle.getWidth());
        }
        LegendItem[] entries = null;
        if (fcolor.length == 0 && fpattern.length == 0) {
            int n = attrMapValues.length;
            entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null);
            }
        } else {
            if (this.skinType != 0 && this.skinImage == null) {
                this.loadSkinImage();
            }
            Image legendSkin = this.loadLegendSkinImage();
            Image[] legendPixelBender = this.loadLegendPixelBenderImages();
            Color[] fpColor = this.getFillPatternColors();
            if (this.fillPatternOn && this.fillPatternColorEncoder != null) {
                fpColor = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, fpColor, 14, this.fillPatternStyle.getColor(), this.dataTransparency, this.useDataTransparency);
            }
            int n = attrMapValues.length;
            entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                FillAttrs attr = new FillAttrs();
                if (fcolor.length > 0) {
                    attr.setColor(fcolor[i % fcolor.length]);
                } else {
                    attr.setColor(null);
                }
                LineAttrs attr2 = null;
                if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                    attr2 = new LineAttrs();
                    attr2.setColor(lcolor[i % lcolor.length]);
                    attr2.setLinePattern(pattern[i % pattern.length]);
                    attr2.setWidth(width[i % width.length]);
                }
                entries[i] = this.skinType != 1 && this.skinType != 2 ? new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, legendSkin, this.skinType, legendPixelBender) : new LegendItem((ColorAttr)attr, (ColorAttr)attr2, attrMapValues[i], null, this.skinImage);
                if (fpattern.length <= 0) continue;
                FillPatternAttrs attr3 = new FillPatternAttrs();
                attr3.setPattern(fpattern[i % fpattern.length]);
                attr3.setColor(fpColor[i % fpColor.length]);
                entries[i].setFillPatternAttrs(attr3);
            }
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.groupVar != null) {
            return this.getGroupedLegendItems(attrType);
        }
        LegendItem[] entries = super.getLegendItems(attrType);
        if (this.fillPatternOn) {
            FillPatternAttrs attr = new FillPatternAttrs();
            attr.setPattern(this.fillPatternStyle.getPattern());
            attr.setColor(this.applyDataTransparency((ColorAttr)this.fillPatternStyle));
            FillAttrs sAttr = null;
            if (!this.fillOn) {
                sAttr = new FillAttrs();
                sAttr.setColor(null);
            }
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].getType() == 2) {
                    entries[i].setType(3);
                    entries[i].setSecondarySymbolAttrs(entries[i].getSymbolAttrs());
                    entries[i].setSymbolAttrs((ColorAttr)sAttr);
                    entries[i].setSkinType(0);
                }
                entries[i].setFillPatternAttrs(attr);
            }
        }
        return entries;
    }

    @Override
    protected int getNumberOfDrawingElements() {
        return this.xvalueVar.getValueCount();
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 8: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.edgeOn;
            }
        }
        return false;
    }

    public boolean isSortXValues() {
        return this.sortXValues;
    }

    public void setSortXValues(boolean sortXValues) {
        this.sortXValues = sortXValues;
    }
}

