/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.common.heatmap.HeatmapParmObject;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;

public class HeatMapParmOverlay
extends Overlay {
    private HeatmapParmObject heatMapParm = new HeatmapParmObject();
    private Variable xVar;
    private Variable yVar;
    private Variable colorVar;
    private NetworkRoot networkRoot = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange colorRange = null;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericColor = true;
    private Color missingColor;
    private boolean includeMissingColor = true;

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
    }

    protected void connectVars() {
        CRD crd = this.model;
        VariableProcessor vp = new VariableProcessor();
        boolean bl = this.numericX = crd.getColumnClass(10) == Double.class;
        if (crd.isAvailable(10)) {
            this.xVar = this.discreteX ? this.connectCategory((short)10, StatGraph.includeMissingDiscrete) : this.connectRaw((short)10);
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xVar = null;
        }
        vp.addVariable(this.xVar);
        boolean bl2 = this.numericY = crd.getColumnClass(11) == Double.class;
        if (crd.isAvailable(11)) {
            this.yVar = this.discreteY ? this.connectCategory((short)11, StatGraph.includeMissingDiscrete) : this.connectRaw((short)11);
            if (this.discreteY) {
                this.numericDiscreteY = this.numericY;
                this.numericY = false;
            }
        } else {
            this.yVar = null;
        }
        vp.addVariable(this.yVar);
        this.numericColor = false;
        short colorRole = 107;
        if (crd.isAvailable(108)) {
            this.colorVar = this.connectRaw((short)108);
            this.numericColor = true;
            colorRole = 108;
        } else {
            this.colorVar = crd.isAvailable(107) ? this.connectCategory((short)107, this.includeMissingColor) : null;
        }
        vp.addVariable(this.colorVar);
        Variable urlVar = this.connectCategory((short)52, false);
        if (urlVar != null) {
            vp.addVariable(urlVar);
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)((StringVariable)urlVar).value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addTooltip(vp, "X");
            this.addTooltip(vp, "Y");
            this.addTooltip(vp, "COLORGROUP");
            this.addTooltip(vp, "COLORRESPONSE");
        }
        this.addCRDWhereClause(vp);
        this.heatMapParm.setXVariable(this.xVar);
        this.xRange = this.computeRange(this.xVar, this.numericX, (short)10, !this.xUnionAllPages, this.xRange, (byte)1);
        this.fireRangeEvent((byte)1, null, this.xRange);
        this.heatMapParm.setYVariable(this.yVar);
        this.yRange = this.computeRange(this.yVar, this.numericY, (short)11, !this.yUnionAllPages, this.yRange, (byte)2);
        this.fireRangeEvent((byte)2, null, this.yRange);
        this.heatMapParm.setColorVariable(this.colorVar);
        this.colorRange = this.computeRange(this.colorVar, this.numericColor, colorRole, false, this.colorRange, (byte)4);
    }

    public int getNBinsExceedingMax(int nBinsMax) {
        double yBins;
        if (this.xRange == null || this.yRange == null) {
            return -1;
        }
        double xBins = this.xRange instanceof ContinuousRange ? (((ContinuousRange)this.xRange).getMax() - ((ContinuousRange)this.xRange).getMin()) / this.heatMapParm.getXStep() : (this.xRange instanceof SimpleBinnedRange ? (double)((SimpleBinnedRange)this.xRange).getNumBins() : (this.xRange instanceof CustomBinnedRange ? (double)((CustomBinnedRange)this.xRange).getMidpoints().length : (double)((DiscreteRange)this.xRange).getValuesSize()));
        if (Double.isInfinite(xBins)) {
            xBins = 1.0;
        }
        if (Double.isInfinite(yBins = this.yRange instanceof ContinuousRange ? (((ContinuousRange)this.yRange).getMax() - ((ContinuousRange)this.yRange).getMin()) / this.heatMapParm.getYStep() : (this.yRange instanceof SimpleBinnedRange ? (double)((SimpleBinnedRange)this.yRange).getNumBins() : (this.yRange instanceof CustomBinnedRange ? (double)((CustomBinnedRange)this.yRange).getMidpoints().length : (double)((DiscreteRange)this.yRange).getValuesSize())))) {
            yBins = 1.0;
        }
        if (xBins * yBins > (double)nBinsMax) {
            return (int)(xBins * yBins);
        }
        return -1;
    }

    @Override
    public void select() {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.heatMapParm.select();
    }

    @Override
    public void draw(Graphics g) {
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.heatMapParm.draw();
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xEncoder == null || this.yEncoder == null || this.colorEncoder == null) {
            return false;
        }
        RangeAttrMapper rangeAttrMapper = null;
        DiscreteAttrMapper discreteAttrMapper = null;
        ColorMap colorMap = null;
        if (this.numericColor) {
            colorMap = (ColorMap)this.colorEncoder.getValueMap();
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                ContinuousRangeToColorMap crtcmap;
                double min;
                rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = rangeAttrMapper.createColorMapper(min = (crtcmap = (ContinuousRangeToColorMap)colorMap).getInputMin(), max = crtcmap.getInputMax());
                if (error != null) {
                    rangeAttrMapper = null;
                } else {
                    double tr = this.useFillTransparency ? this.getFillAttrs().getTransparency() : this.dataTransparency;
                    rangeAttrMapper.setTransparency(tr);
                }
            }
        } else {
            colorMap = this.getIndexedColorMap((short)107, this.colorEncoder.colorArray);
            if (this.hasAttrVar("COLORGROUP")) {
                discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                discreteAttrMapper.setFillTransparency(this.dataTransparency);
                discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
                discreteAttrMapper.setLineTransparency(this.dataTransparency);
            }
        }
        this.heatMapParm.setMissingColor(this.includeMissingColor ? this.missingColor : null);
        boolean rc = this.heatMapParm.connectNetwork((NumericMap)this.xEncoder.getValueMap(), (NumericMap)this.yEncoder.getValueMap(), (ColorMap)this.colorEncoder.getValueMap(), rangeAttrMapper, discreteAttrMapper, this.probe);
        this.needConnect = false;
        return rc;
    }

    protected StringToColorMap getIndexedColorMap(short role, Color[] cl) {
        short indexRole = 41;
        StringVectorVariable colors = (StringVectorVariable)this.connectCategory(role, true);
        NumericVectorVariable indices = null;
        if (this.model.isAvailable(indexRole)) {
            indices = (NumericVectorVariable)this.connectRaw(indexRole);
        }
        Variable[] vars = null;
        vars = indices != null ? new Variable[]{colors, indices} : new Variable[]{colors};
        this.applyWhereClause(vars);
        StringToColorMap colorMap = new StringToColorMap();
        Color[] lc = new Color[colors.getUniqueValueCount()];
        for (int i = 0; i < colors.getUniqueValueCount(); ++i) {
            try {
                DiscreteAttrMapper attrMapper = null;
                if (this.hasAttrVar("COLORGROUP")) {
                    attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                }
                if (attrMapper != null) {
                    String g = colors.formattedUniqueValue.getValue(i);
                    Color c = null;
                    c = attrMapper.getLineColor(g);
                    if (c != null) {
                        lc[i] = this.applyDataTransparency(c);
                    }
                } else if (indices != null) {
                    int obs = colors.getFirstOccurringValueIndex(i);
                    int idx = (int)indices.value.getValue(obs) - 1;
                    lc[i] = this.applyDataTransparency(cl[idx % cl.length]);
                } else {
                    lc[i] = this.applyDataTransparency(cl[i % cl.length]);
                }
                colorMap.add(colors.formattedUniqueValue.getValue(i), lc[i]);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return colorMap;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.heatMapParm == null) {
            return null;
        }
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                return this.colorRange;
            }
        }
        return null;
    }

    private DataRange computeRange(Variable var, boolean numericVar, short role, boolean union, DataRange oldRange, byte dim) {
        DataRange newRange = null;
        if (var != null) {
            int num;
            int n = num = numericVar ? var.getValueCount() : var.getUniqueValueCount();
            if (num > 0) {
                if (numericVar) {
                    newRange = this.makeContinuousRange((NumericVariable)var, role, union);
                    newRange = this.heatMapParm.adjustRange(newRange, dim);
                } else {
                    newRange = Overlay.makeDiscreteRange((StringVariable)var, num);
                }
                newRange.setLabel(var.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, role);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        return newRange;
    }

    @Override
    public void setChannel(Channel channel) {
        this.heatMapParm.setChannel(channel);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
            this.setReconnectRequired(true);
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
            this.setReconnectRequired(true);
        }
        if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
            this.setReconnectRequired(true);
        }
        this.needConnect = true;
    }

    private int getNumberValues(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xVar.getUniqueValueCount();
            }
            case 2: {
                return this.yVar.getUniqueValueCount();
            }
        }
        return 0;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        ValueMap vm;
        double offset = 0.0;
        int n = this.getNumberValues(dimension);
        if (dimension == 1) {
            vm = this.xEncoder.getValueMap();
            if (vm instanceof ContinuousRangeToNumericMap) {
                offset += (double)StatGraph.getExtraPadding();
            } else if (vm instanceof StringToNumericMap) {
                n = Math.max(StatGraph.MPC, ((StringToNumericMap)vm).getUniqueValueCount());
                offset = n > 1 ? (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n / 2.0 : 0.0;
                offset += this.discreteOffsetPadding ? (double)StatGraph.getExtraPadding() : 0.0;
            }
        }
        if (dimension == 2) {
            vm = this.yEncoder.getValueMap();
            if (vm instanceof ContinuousRangeToNumericMap) {
                offset += (double)StatGraph.getExtraPadding();
            } else if (vm instanceof StringToNumericMap) {
                n = Math.max(StatGraph.MPC, ((StringToNumericMap)vm).getUniqueValueCount());
                offset = n > 1 ? (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n / 2.0 : 0.0;
                offset += this.discreteOffsetPadding ? (double)StatGraph.getExtraPadding() : 0.0;
            }
        }
        return offset;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        int top;
        int left;
        double cw = this.getPreferredOffset((byte)1);
        int right = left = (int)cw;
        double ch = this.getPreferredOffset((byte)2);
        int bottom = top = (int)ch;
        Insets margin = new Insets(top, left, bottom, right);
        return margin;
    }

    @Override
    public String[] getUniqueValues(short role) {
        Object[] vals;
        if (role == 6 && this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
            String[] str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                str[i] = vals[i].toString();
            }
            return str;
        }
        return super.getUniqueValues(role);
    }

    public String[] getUniqueValues(byte dim) {
        Object[] vals;
        if (dim == 4 && this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
            String[] str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                str[i] = vals[i].toString();
            }
            return str;
        }
        return null;
    }

    public FillAttrs getFillAttrs() {
        return this.heatMapParm.getFillAttrs();
    }

    public LineAttrs getOutlineAttrs() {
        return this.heatMapParm.getOutlineAttrs();
    }

    public void setOutlineAttrs(LineAttrs outlineAttrs) {
        outlineAttrs.setColor(this.applyDataTransparency(outlineAttrs.getColor()));
        this.heatMapParm.setOutlineAttrs(outlineAttrs);
    }

    public boolean isXBinAxis() {
        return this.heatMapParm.isXBinAxis();
    }

    public void setXBinAxis(boolean binAxis) {
        this.heatMapParm.setXBinAxis(binAxis);
    }

    public boolean isXEndLabels() {
        return this.heatMapParm.isXEndLabels();
    }

    public void setXEndLabels(boolean endLabels) {
        this.heatMapParm.setXEndLabels(endLabels);
    }

    public int getXValues() {
        return this.heatMapParm.getXValues();
    }

    public void setXValues(int values) {
        this.heatMapParm.setXValues(values);
    }

    public boolean isYBinAxis() {
        return this.heatMapParm.isYBinAxis();
    }

    public void setYBinAxis(boolean binAxis) {
        this.heatMapParm.setYBinAxis(binAxis);
    }

    public boolean isYEndLabels() {
        return this.heatMapParm.isYEndLabels();
    }

    public void setYEndLabels(boolean endLabels) {
        this.heatMapParm.setYEndLabels(endLabels);
    }

    public int getYValues() {
        return this.heatMapParm.getYValues();
    }

    public void setYValues(int values) {
        this.heatMapParm.setYValues(values);
    }

    public double getXGap() {
        return this.heatMapParm.getXGap();
    }

    public void setXGap(double gap) {
        this.heatMapParm.setXGap(gap);
    }

    public double getYGap() {
        return this.heatMapParm.getYGap();
    }

    public void setYGap(double gap) {
        this.heatMapParm.setYGap(gap);
    }

    public void setDisplayMode(String display) {
        this.heatMapParm.setDisplayMode(display);
    }

    public double[] getXBoundaries() {
        return this.heatMapParm.getXBoundaries();
    }

    public void setXBoundaries(double[] boundaries) {
        this.heatMapParm.setXBoundaries(boundaries);
    }

    public double[] getYBoundaries() {
        return this.heatMapParm.getYBoundaries();
    }

    public void setYBoundaries(double[] boundaries) {
        this.heatMapParm.setYBoundaries(boundaries);
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper rangeAttrMapper = null;
        if (this.numericColor && this.colorEncoder != null) {
            ColorMap colorMap = (ColorMap)this.colorEncoder.getValueMap();
            if (this.hasAttrVar("COLORRESPONSE")) {
                double max;
                ContinuousRangeToColorMap crtcmap;
                double min;
                rangeAttrMapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE");
                String error = rangeAttrMapper.createColorMapper(min = (crtcmap = (ContinuousRangeToColorMap)colorMap).getInputMin(), max = crtcmap.getInputMax());
                if (error != null) {
                    StatGraph.printWarning(error);
                    rangeAttrMapper = null;
                    return this.getDefaultColorModelRanges();
                }
                double tr = this.useFillTransparency ? this.getFillAttrs().getTransparency() : this.dataTransparency;
                return rangeAttrMapper.getRangeColorMapper().getFullRanges(tr);
            }
            return this.getDefaultColorModelRanges();
        }
        return null;
    }

    private Range[] getDefaultColorModelRanges() {
        Color[] colors = this.colorEncoder.rampColors;
        ContinuousRange range = (ContinuousRange)this.colorEncoder.getInput();
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        if (this.numericColor && this.colorEncoder != null) {
            return this.colorEncoder.getInput().getFormat();
        }
        return null;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return 7;
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.getFillAttrs().getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.colorVar != null && this.colorVar instanceof StringVariable) {
            DiscreteAttrMapper discreteAttrMapper = null;
            if (this.hasAttrVar("COLORGROUP")) {
                discreteAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("COLORGROUP");
                discreteAttrMapper.setFillTransparency(this.dataTransparency);
                discreteAttrMapper.setUseFillTransparency(this.useFillTransparency);
                discreteAttrMapper.setLineTransparency(this.dataTransparency);
            }
            StringVectorVariable colors = (StringVectorVariable)this.connectCategory((short)107, this.includeMissingColor);
            if (this.groupOrder == 1 || this.groupOrder == 2) {
                boolean numericGroup;
                VariableProcessor vp = new VariableProcessor();
                vp.addVariable((Variable)colors);
                boolean bl = numericGroup = this.model.getColumnClass(107) == Double.class;
                if (numericGroup) {
                    Variable rawColors = this.connectRaw((short)107);
                    vp.addVariable(rawColors);
                    vp.setSort(rawColors, this.groupOrder == 1 ? 1 : 2);
                } else {
                    vp.setSort((Variable)colors, this.groupOrder == 1 ? 1 : 2);
                }
            }
            LegendItem[] items = this.heatMapParm.getLegendItems((StringVariable)colors, attrType, discreteAttrMapper, this.colorEncoder.colorList);
            if (this.isLegendEntryFromAttrMap("COLORGROUP")) {
                items = HeatMapParmOverlay.margeAttrMapWithPlotLegendItems(discreteAttrMapper, items, this.getFillAttrs(), this.getOutlineAttrs(), false, this.useFillTransparency, true, true, true, this.dataTransparency, this.useDataTransparency);
            }
            return items;
        }
        return null;
    }

    @Override
    public boolean hasLegend(int attrType) {
        boolean hasLegend = false;
        switch (attrType) {
            case 0: 
            case 7: 
            case 11: {
                if (this.colorVar == null || !(this.colorVar instanceof StringVectorVariable)) break;
                hasLegend = true;
            }
        }
        return hasLegend;
    }

    public boolean isLineOn() {
        return this.heatMapParm.showOutline();
    }

    public void setReconnectRequired(boolean flag) {
        this.heatMapParm.setReconnectRequired(flag);
    }

    @Override
    public boolean hasMissingValue() {
        if (this.model.isAvailable(108)) {
            ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(108);
            return cmd.getMissings() > 0;
        }
        return false;
    }

    @Override
    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color color) {
        this.missingColor = color;
    }

    public double getXBinSize() {
        return this.heatMapParm.getXBinSize();
    }

    public void setXBinSize(double xBinSize) {
        this.heatMapParm.setXBinSize(xBinSize);
    }

    public double getYBinSize() {
        return this.heatMapParm.getYBinSize();
    }

    public void setYBinSize(double yBinSize) {
        this.heatMapParm.setYBinSize(yBinSize);
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.model.isAvailable(107);
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(107);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }

    public boolean isIncludeMissingColor() {
        return this.includeMissingColor;
    }

    public void setIncludeMissingColor(boolean includeMissingColor) {
        this.includeMissingColor = includeMissingColor;
    }
}

