/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipedFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipedFormat;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.TukeyBox;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class HeatBoxOverlay
extends Overlay {
    public static final String RB_KEY = "HeatBoxOverlay.";
    public static final int VERTICAL = 0;
    public static final int CONNECT_NONE = 0;
    public static final int CONNECT_MIN = 1;
    public static final int CONNECT_Q1 = 2;
    public static final int CONNECT_MEDIAN = 3;
    public static final int CONNECT_Q3 = 4;
    public static final int CONNECT_MAX = 5;
    public static final int CONNECT_MEAN = 6;
    private NetworkRoot networkRoot;
    protected NumericMapper xvalueMapper;
    protected NumericMapper yvalueMapper;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange heatmapColorRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected ColorEncoder meanColorEncoder;
    protected ColorEncoder outlierColorEncoder;
    protected LineEncoder lineEncoder;
    protected ShapeEncoder shapeEncoder;
    protected ColorEncoder heatmapColorEncoder;
    private NumericVariable q1Var;
    private NumericVariable q3Var;
    private NumericVariable meanVar;
    private NumericVariable medianVar;
    private NumericVariable minVar;
    private NumericVariable maxVar;
    private NumericVariable dataMinVar;
    private NumericVariable dataMaxVar;
    private NumericVariable stdVar;
    private NumericVariable nVar;
    private NumericVariable binMinVar;
    private NumericVariable binMaxVar;
    private NumericVariable binStartMinVar;
    private NumericVariable binStartMaxVar;
    private NumericVariable binWidthMinVar;
    private NumericVariable binWidthMaxVar;
    private Variable categoryVar;
    private NumericVariable numericCategoryVar;
    private Variable groupVar;
    private StringVariable stringGroupVar;
    private StringVariable analysisLabelVar;
    private NumericVariable[] outlierMinVars = null;
    private NumericVariable[] outlierMaxVars = null;
    private StringVariable urlVar;
    private int outlierMinVarCount = 0;
    private int outlierMaxVarCount = 0;
    private String analysisLabel;
    private GTKFormat analysisFormat;
    private boolean customTips = false;
    private String[] customTipList;
    private ArrayList statTips = new ArrayList();
    private HashMap customTipLabel;
    private HashMap customTipFormat;
    public boolean selectable = true;
    private boolean numericCategory = false;
    private double discreteOffset = 0.0;
    private int[] groupsPerCategory;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    private String overlayID;
    private boolean hasStatistic = false;
    private Overlay[] innerMarginOverlays = null;
    private boolean extreme = false;
    private boolean notchOn = false;
    private int capShape = 1;
    private LineAttrs capStyle = new LineAttrs(1);
    private boolean capOn = true;
    private int medianSymbol = -1;
    private boolean medianOn = true;
    private boolean meanOn = true;
    private boolean outlierOn = true;
    private boolean fillOn = true;
    private boolean connectOn = false;
    private boolean connectSkipMiss = false;
    private boolean whiskersOn = true;
    private int connectBy = 6;
    private int connectionOrder = 0;
    private boolean userSetBoxWidth = false;
    private double boxWidth = 0.4;
    private double clusterWidth = 0.7;
    private double intervalBoxWidth = -1.0;
    private static final double INTERVAL_BOX_SCALE = 0.85;
    private FillAttrs fillStyle = new FillAttrs();
    private LineAttrs outlineStyle = new LineAttrs();
    private LineAttrs whiskerStyle = new LineAttrs();
    private LineAttrs medianStyle = new LineAttrs();
    private MarkerAttrs meanStyle = new MarkerAttrs();
    private MarkerAttrs outlierStyle = new MarkerAttrs();
    private LineAttrs connectStyle = new LineAttrs();
    private LineAttrs heatmapOutlineStyle = new LineAttrs();
    private int orientation = 0;
    private boolean heatmapOutlineOn = false;
    private double heatmapWidth = 0.2;
    private boolean includeZeroBins = false;
    private Color missingHeatmapColor = Color.black;
    private boolean useFillColor = false;
    private boolean useOutlineColor = false;
    private boolean useOutlinePattern = false;
    private boolean useOutlineSize = false;
    private boolean useMedianColor = false;
    private boolean useMedianPattern = false;
    private boolean useMedianSize = false;
    private boolean useMeanColor = false;
    private boolean useMeanSymbol = false;
    private boolean useMeanSize = false;
    private boolean useMeanWeight = false;
    private boolean useMeanTransparency = false;
    private boolean useWhiskerColor = false;
    private boolean useWhiskerPattern = false;
    private boolean useWhiskerSize = false;
    private boolean useOutlierColor = false;
    private boolean useOutlierSymbol = false;
    private boolean useOutlierSize = false;
    private boolean useOutlierWeight = false;
    private boolean useOutlierTransparency = false;
    private boolean useConnectLineColor = false;
    private boolean useConnectLinePattern = false;
    private boolean useConnectLineSize = false;
    private Image skinImage = null;
    private boolean hasInvalidBox = false;
    private boolean warningIssued = false;
    private static final int MIN_BOX_SIZE = 5;

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public void setDiscreteOffset(double offset) {
        this.discreteOffset = offset;
    }

    public boolean isCustomTips() {
        return this.customTips;
    }

    public void setCustomTips(boolean b) {
        this.customTips = b;
    }

    public void clearStatTips() {
        this.statTips.clear();
    }

    public void addStatTip(String stat) {
        this.statTips.add(stat);
    }

    public void setCustomTipLabel(HashMap labelMap) {
        this.customTipLabel = labelMap;
    }

    public void setCustomTipFormat(HashMap formatMap) {
        this.customTipFormat = formatMap;
    }

    public void setCustomTipList(String[] tips) {
        this.customTipList = tips;
    }

    public boolean isExtreme() {
        return this.extreme;
    }

    public void setExtreme(boolean b) {
        this.extreme = b;
    }

    public boolean isMeanOn() {
        return this.meanOn;
    }

    public void setMeanOn(boolean on) {
        this.meanOn = on;
    }

    public boolean isMedianOn() {
        return this.medianOn;
    }

    public void setMedianOn(boolean on) {
        this.medianOn = on;
    }

    public boolean isOutlierOn() {
        return this.outlierOn;
    }

    public void setOutlierOn(boolean on) {
        this.outlierOn = on;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean on) {
        this.fillOn = on;
    }

    public boolean isCapOn() {
        return this.capOn;
    }

    public void setCapOn(boolean on) {
        this.capOn = on;
    }

    public boolean isConnectOn() {
        return this.connectOn;
    }

    public void setConnectOn(boolean on) {
        this.connectOn = on;
    }

    public boolean isNotchOn() {
        return this.notchOn;
    }

    public void setNotchOn(boolean on) {
        this.notchOn = on;
    }

    public int getCapShape() {
        return this.capShape;
    }

    public void setCapShape(int shape) {
        this.capShape = shape;
    }

    public int getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(int by) {
        this.connectBy = by;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double w) {
        this.boxWidth = w;
    }

    public void setUserSetBoxWidth(boolean b) {
        this.userSetBoxWidth = b;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public void setClusterWidth(double w) {
        this.clusterWidth = w;
    }

    public double getIntervalBoxWidth() {
        return this.intervalBoxWidth;
    }

    public void setIntervalBoxWidth(double w) {
        this.intervalBoxWidth = w * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
    }

    public double getHeatMapWidth() {
        return this.heatmapWidth;
    }

    public void setHeatMapWidth(double w) {
        this.heatmapWidth = w;
    }

    public boolean isHeatMapOutlineOn() {
        return this.heatmapOutlineOn;
    }

    public void setHeatMapOutlineOn(boolean on) {
        this.heatmapOutlineOn = on;
    }

    public boolean isIncludeZeroBins() {
        return this.includeZeroBins;
    }

    public void setIncludeZeroBins(boolean b) {
        this.includeZeroBins = b;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillAttrs attrs) {
        this.fillStyle = attrs;
    }

    public LineAttrs getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(LineAttrs attrs) {
        this.outlineStyle = attrs;
    }

    public LineAttrs getWhiskerStyle() {
        return this.whiskerStyle;
    }

    public void setWhiskerStyle(LineAttrs attrs) {
        this.whiskerStyle = attrs;
    }

    public LineAttrs getCapStyle() {
        return this.capStyle;
    }

    public void setCapStyle(LineAttrs ls) {
        this.capStyle = ls;
    }

    public LineAttrs getMedianStyle() {
        return this.medianStyle;
    }

    public void setMedianStyle(LineAttrs attrs) {
        this.medianStyle = attrs;
    }

    public LineAttrs getConnectStyle() {
        return this.connectStyle;
    }

    public void setConnectStyle(LineAttrs attrs) {
        this.connectStyle = attrs;
    }

    public MarkerAttrs getMeanStyle() {
        return this.meanStyle;
    }

    public void setMeanStyle(MarkerAttrs attrs) {
        this.meanStyle = attrs;
    }

    public MarkerAttrs getOutlierStyle() {
        return this.outlierStyle;
    }

    public void setOutlierStyle(MarkerAttrs attrs) {
        this.outlierStyle = attrs;
    }

    public LineAttrs getHeatMapOutlineStyle() {
        return this.heatmapOutlineStyle;
    }

    public void setHeatMapOutlineStyle(LineAttrs attrs) {
        this.heatmapOutlineStyle = attrs;
    }

    public void setUseFillColor(boolean b) {
        this.useFillColor = b;
    }

    public void setUseOutlineColor(boolean b) {
        this.useOutlineColor = b;
    }

    public void setUseOutlineSize(boolean b) {
        this.useOutlineSize = b;
    }

    public void setUseOutlinePattern(boolean b) {
        this.useOutlinePattern = b;
    }

    public void setUseMedianColor(boolean b) {
        this.useMedianColor = b;
    }

    public void setUseMedianPattern(boolean b) {
        this.useMedianPattern = b;
    }

    public void setUseMedianSize(boolean b) {
        this.useMedianSize = b;
    }

    public void setUseMeanColor(boolean b) {
        this.useMeanColor = b;
    }

    public void setUseMeanSymbol(boolean b) {
        this.useMeanSymbol = b;
    }

    public void setUseMeanSize(boolean b) {
        this.useMeanSize = b;
    }

    public void setUseWhiskerColor(boolean b) {
        this.useWhiskerColor = b;
    }

    public void setUseWhiskerPattern(boolean b) {
        this.useWhiskerPattern = b;
    }

    public void setUseWhiskerSize(boolean b) {
        this.useWhiskerSize = b;
    }

    public void setUseOutlierColor(boolean b) {
        this.useOutlierColor = b;
    }

    public void setUseOutlierSymbol(boolean b) {
        this.useOutlierSymbol = b;
    }

    public void setUseOutlierSize(boolean b) {
        this.useOutlierSize = b;
    }

    public void setUseConnectLineColor(boolean b) {
        this.useConnectLineColor = b;
    }

    public void setUseConnectLinePattern(boolean b) {
        this.useConnectLinePattern = b;
    }

    public void setUseConnectLineSize(boolean b) {
        this.useConnectLineSize = b;
    }

    public void setUseMeanTransparency(boolean b) {
        this.useMeanTransparency = b;
    }

    public void setUseOutlierTransparency(boolean b) {
        this.useOutlierTransparency = b;
    }

    public boolean isUseMeanWeight() {
        return this.useMeanWeight;
    }

    public void setUseMeanWeight(boolean useMeanWeight) {
        this.useMeanWeight = useMeanWeight;
    }

    public boolean isUseOutlierWeight() {
        return this.useOutlierWeight;
    }

    public void setUseOutlierWeight(boolean useOutlierWeight) {
        this.useOutlierWeight = useOutlierWeight;
    }

    public void setMissingHeatMapColor(Color missingColor) {
        this.missingHeatmapColor = missingColor;
    }

    public void setOutlierMinVarCount(int n) {
        this.outlierMinVarCount = n;
    }

    public void setOutlierMaxVarCount(int n) {
        this.outlierMaxVarCount = n;
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
            if (this.xEncoder.isReversed() && this.getInnerMarginOverlays() != null) {
                this.setInnerMarginOverlayLabelPosition();
            }
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder.getInput() instanceof ContinuousRange) {
                this.heatmapColorEncoder = (ColorEncoder)encoder;
            } else {
                this.colorEncoder = (ColorEncoder)encoder;
            }
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 16) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.meanColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 23) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.outlierColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 6) {
            if (!(encoder instanceof ShapeEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeEncoder)) {
                return;
            }
            this.shapeEncoder = (ShapeEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.heatmapColorEncoder;
            }
            case 17: {
                return this.lineColorEncoder;
            }
        }
        return null;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                return this.heatmapColorRange;
            }
        }
        return null;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateNumberOfGroupPerCategory();
        this.updateXRange();
        this.updateYRange();
        this.updateHeatMapColorRange();
    }

    protected void connectVars() {
        int i;
        CRD crd = this.model;
        Variable catMissingControlVar = null;
        if (crd.isAvailable(87)) {
            this.numericCategory = crd.getColumnClass(87) == Double.class;
            this.categoryVar = !this.numericCategory || this.discreteX && this.orientation == 0 || this.discreteY && this.orientation != 0 ? this.connectCategory((short)87, this.missingCategoryOn) : this.connectRaw((short)87);
            if (this.numericCategory) {
                this.numericCategoryVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.numericCategoryVar).connectFrom(crd.getDoubleColumn(87));
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(87)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericCategoryVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (!this.missingCategoryOn) {
                catMissingControlVar = this.connectRaw((short)87);
            }
            this.connectionOrder = this.orientation == 0 ? 1 : 2;
        } else {
            this.categoryVar = null;
            this.clusterWidth = 1.0;
        }
        this.q1Var = crd.isAvailable(71) ? (NumericVariable)this.connectRaw((short)71) : null;
        this.q3Var = crd.isAvailable(72) ? (NumericVariable)this.connectRaw((short)72) : null;
        this.meanVar = crd.isAvailable(73) ? (NumericVariable)this.connectRaw((short)73) : null;
        this.medianVar = crd.isAvailable(74) ? (NumericVariable)this.connectRaw((short)74) : null;
        this.minVar = crd.isAvailable(75) ? (NumericVariable)this.connectRaw((short)75) : null;
        this.maxVar = crd.isAvailable(76) ? (NumericVariable)this.connectRaw((short)76) : null;
        this.dataMinVar = crd.isAvailable(77) ? (NumericVariable)this.connectRaw((short)77) : null;
        this.dataMaxVar = crd.isAvailable(78) ? (NumericVariable)this.connectRaw((short)78) : null;
        this.stdVar = crd.isAvailable(79) ? (NumericVariable)this.connectRaw((short)79) : null;
        this.nVar = crd.isAvailable(80) ? (NumericVariable)this.connectRaw((short)80) : null;
        this.binMinVar = crd.isAvailable(81) ? (NumericVariable)this.connectRaw((short)81) : null;
        this.binMaxVar = crd.isAvailable(82) ? (NumericVariable)this.connectRaw((short)82) : null;
        this.binStartMinVar = crd.isAvailable(83) ? (NumericVariable)this.connectRaw((short)83) : null;
        this.binStartMaxVar = crd.isAvailable(84) ? (NumericVariable)this.connectRaw((short)84) : null;
        this.binWidthMinVar = crd.isAvailable(85) ? (NumericVariable)this.connectRaw((short)85) : null;
        this.binWidthMaxVar = crd.isAvailable(86) ? (NumericVariable)this.connectRaw((short)86) : null;
        if (crd.isAvailable(88)) {
            this.groupVar = this.connectRaw((short)88);
            this.groupVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.stringGroupVar = (StringVariable)this.connectCategory((short)88, true);
        } else {
            this.groupVar = null;
            this.stringGroupVar = null;
        }
        this.analysisLabelVar = crd.isAvailable(89) ? (StringVariable)this.connectCategory((short)89, true) : null;
        if (this.outlierMinVarCount > 0) {
            this.outlierMinVars = new NumericVariable[this.outlierMinVarCount];
            for (int i2 = 0; i2 < this.outlierMinVarCount; ++i2) {
                if (!crd.isAvailable(650 + i2)) continue;
                this.outlierMinVars[i2] = (NumericVectorVariable)this.connectRaw((short)(650 + i2));
            }
        }
        if (this.outlierMaxVarCount > 0) {
            this.outlierMaxVars = new NumericVariable[this.outlierMaxVarCount];
            for (int i3 = 0; i3 < this.outlierMaxVarCount; ++i3) {
                if (!crd.isAvailable(800 + i3)) continue;
                this.outlierMaxVars[i3] = (NumericVectorVariable)this.connectRaw((short)(800 + i3));
            }
        }
        this.urlVar = (StringVariable)this.connectCategory((short)52, false);
        int[] obs = null;
        int obsCount = 0;
        boolean subset = false;
        if (!this.missingCategoryOn && catMissingControlVar != null || !this.missingGroupOn && this.groupVar != null) {
            int count = catMissingControlVar != null ? catMissingControlVar.getValueCount() : this.groupVar.getValueCount();
            obs = new int[count];
            for (i = 0; i < count; ++i) {
                if (!this.missingCategoryOn && catMissingControlVar != null && !this.missingGroupOn && this.groupVar != null) {
                    if (catMissingControlVar.isMissing(i) || this.groupVar.isMissing(i)) continue;
                    obs[obsCount++] = i;
                    continue;
                }
                if (catMissingControlVar != null && !this.missingCategoryOn && !catMissingControlVar.isMissing(i)) {
                    obs[obsCount++] = i;
                    continue;
                }
                if (this.groupVar == null || this.missingGroupOn || this.groupVar.isMissing(i)) continue;
                obs[obsCount++] = i;
            }
            if (obsCount < count) {
                subset = true;
            }
        }
        VariableProcessor vp = null;
        if (this.groupVar != null && this.groupOrder != 0 && this.groupOrder != 3 || subset || crd.whereExpression != null) {
            vp = new VariableProcessor();
            if (this.categoryVar != null) {
                this.categoryVar.setUniqueValueSort(0);
                vp.addVariable(this.categoryVar);
            }
            if (this.numericCategoryVar != null) {
                vp.addVariable((Variable)this.numericCategoryVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar);
                if (this.getGroupOrder() == 1) {
                    this.groupVar.setUniqueValueSort(1);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.groupVar, 1);
                    }
                } else if (this.getGroupOrder() == 2) {
                    this.groupVar.setUniqueValueSort(2);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.groupVar, 2);
                    }
                }
                this.groupVar.setSortByFormattedValues(this.groupVar instanceof StringVariable);
                if (!this.missingGroupOn) {
                    this.whereRoles = new int[]{88};
                }
                vp.addVariable((Variable)this.stringGroupVar);
            }
            this.addVarToVP(vp, (Variable)this.q1Var);
            this.addVarToVP(vp, (Variable)this.q3Var);
            this.addVarToVP(vp, (Variable)this.meanVar);
            this.addVarToVP(vp, (Variable)this.medianVar);
            this.addVarToVP(vp, (Variable)this.minVar);
            this.addVarToVP(vp, (Variable)this.maxVar);
            this.addVarToVP(vp, (Variable)this.dataMinVar);
            this.addVarToVP(vp, (Variable)this.dataMaxVar);
            this.addVarToVP(vp, (Variable)this.stdVar);
            this.addVarToVP(vp, (Variable)this.nVar);
            this.addVarToVP(vp, (Variable)this.binMinVar);
            this.addVarToVP(vp, (Variable)this.binMaxVar);
            this.addVarToVP(vp, (Variable)this.binStartMinVar);
            this.addVarToVP(vp, (Variable)this.binStartMaxVar);
            this.addVarToVP(vp, (Variable)this.binWidthMinVar);
            this.addVarToVP(vp, (Variable)this.binWidthMaxVar);
            this.addVarToVP(vp, (Variable)this.analysisLabelVar);
            if (this.outlierMinVarCount > 0) {
                for (i = 0; i < this.outlierMinVars.length; ++i) {
                    vp.addVariable((Variable)this.outlierMinVars[i]);
                }
            }
            if (this.outlierMaxVarCount > 0) {
                for (i = 0; i < this.outlierMaxVars.length; ++i) {
                    vp.addVariable((Variable)this.outlierMaxVars[i]);
                }
            }
            this.addVarToVP(vp, (Variable)this.urlVar);
            if (subset) {
                vp.setSubsetByObservation(obs, obsCount);
                this.model.subsetObs = obs;
                this.model.subsetObsCount = obsCount;
            }
            this.addCRDWhereClause(vp);
        }
        this.analysisFormat = this.q1Var.getFormat();
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        if (this.urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)this.urlVar.value);
        }
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addToolTipPipe(this.probe, this.categoryVar, null, null);
            this.addToolTipPipe(this.probe, (Variable)this.stringGroupVar, null, null);
            this.addToolTipPipe(this.probe, (Variable)this.dataMinVar, RB.getStringResource("BoxOverlay.", "datamin.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.minVar, RB.getStringResource("BoxOverlay.", "min.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.q1Var, RB.getStringResource("BoxOverlay.", "q1.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.medianVar, RB.getStringResource("BoxOverlay.", "median.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.q3Var, RB.getStringResource("BoxOverlay.", "q3.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.maxVar, RB.getStringResource("BoxOverlay.", "max.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.dataMaxVar, RB.getStringResource("BoxOverlay.", "datamax.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.meanVar, RB.getStringResource("BoxOverlay.", "mean.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.stdVar, RB.getStringResource("BoxOverlay.", "std.txt"), this.analysisFormat);
            this.addToolTipPipe(this.probe, (Variable)this.nVar, RB.getStringResource("BoxOverlay.", "n.txt"), new GTKFormat((Format)DataModel.defaultFormat));
        }
    }

    @Override
    protected void addCustomTips(VariableProcessor vp) {
        if (!this.tooltipEnabled) {
            return;
        }
        for (int i = 0; i < this.customTipList.length; ++i) {
            SASFormat sasFmt;
            String fName;
            if (this.customTipList[i] == null) continue;
            String tipRole = this.customTipList[i].toUpperCase();
            String tipLabel = null;
            if (this.customTipLabel != null) {
                tipLabel = (String)this.customTipLabel.get(tipRole);
            }
            GTKFormat tipFmt = null;
            if (this.statTips.contains(tipRole)) {
                tipFmt = this.analysisFormat;
            }
            if (this.customTipFormat != null && (fName = (String)this.customTipFormat.get(tipRole)) != null && fName.trim().length() > 0 && (sasFmt = SASFormat.getInstance((String)fName)) != null && !sasFmt.isCharacterFormat()) {
                tipFmt = new GTKFormat((Format)sasFmt);
            }
            if (!this.statTips.contains(tipRole)) {
                this.addTooltip(vp, tipRole, this.probe);
                continue;
            }
            if (tipRole.equalsIgnoreCase("DATAMIN")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "datamin.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.dataMinVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("MIN")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "min.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.minVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("Q1")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "q1.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.q1Var, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("MEDIAN")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "median.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.medianVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("Q3")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "q3.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.q3Var, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("MAX")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "max.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.maxVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("DATAMAX")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "datamax.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.dataMaxVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("MEAN")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "mean.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.meanVar, tipLabel, tipFmt);
                continue;
            }
            if (tipRole.equalsIgnoreCase("STD")) {
                if (tipLabel == null) {
                    tipLabel = RB.getStringResource("BoxOverlay.", "std.txt");
                }
                this.addToolTipPipe(this.probe, (Variable)this.stdVar, tipLabel, tipFmt);
                continue;
            }
            if (!tipRole.equalsIgnoreCase("N")) continue;
            if (tipLabel == null) {
                tipLabel = RB.getStringResource("BoxOverlay.", "n.txt");
            }
            this.addToolTipPipe(this.probe, (Variable)this.nVar, tipLabel, tipFmt);
        }
    }

    private void addToolTipPipe(Probe probe, Variable var, String label, GTKFormat fmt) {
        StringPipedFormat pipe;
        if (var == null) {
            return;
        }
        if (fmt == null) {
            fmt = var.getFormat();
        }
        if (label == null) {
            label = var.getLabel();
        }
        if (var instanceof StringVariable) {
            pipe = new StringPipedFormat();
            pipe.input.connectFrom(((StringVariable)var).value);
        } else {
            pipe = new NumericPipedFormat();
            ((NumericPipedFormat)pipe).input.connectFrom(((NumericVariable)var).value);
        }
        pipe.setFormat(fmt);
        probe.addPipe(label, (Pipe)pipe);
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        NumericVariable xvar;
        if (this.groupVar == null) {
            return;
        }
        if (this.categoryVar instanceof NumericVariable) {
            xvar = new NumericVariable();
            xvar.connectFrom((NumericVariable)this.categoryVar);
            xvar.setFormat(((NumericVariable)this.categoryVar).getFormat());
        } else if (this.categoryVar instanceof StringVariable) {
            xvar = new StringVariable();
            ((StringVariable)xvar).connectFrom((StringVariable)this.categoryVar);
            ((StringVariable)xvar).setFormat(((StringVariable)this.categoryVar).getFormat());
        } else {
            xvar = null;
        }
        StringVariable gvar = new StringVariable();
        if (this.groupVar instanceof NumericVariable) {
            gvar.connectFrom((NumericVariable)this.groupVar);
        } else {
            gvar.connectFrom((StringVariable)this.groupVar);
        }
        VariableProcessor vp = new VariableProcessor();
        if (xvar != null) {
            vp.addVariable((Variable)xvar);
        }
        vp.addVariable((Variable)gvar, 0);
        if (xvar != null) {
            vp.addGroupVariable((Variable)xvar);
        }
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)71) + "." + this.model.getColumnName((short)88);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        int n = numCats = xvar == null ? 1 : xvar.getUniqueValueCount();
        if (numCats == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        if (xvar == null) {
            int gCount;
            this.groupsPerCategory[0] = gCount = gvar.getUniqueValueCount();
            if (gCount > maxGroups) {
                maxGroups = gCount;
            }
        } else {
            int gCount = 1;
            int gIdx = -1;
            for (int i = 0; i < xvar.getValueCount(); ++i) {
                try {
                    int xCat;
                    if (xvar instanceof NumericVariable) {
                        xvar.value.getValue(i);
                    }
                    int n2 = xCat = xvar instanceof StringVariable ? ((StringVariable)xvar).category.getValue(i) : xvar.category.getValue(i);
                    if (gIdx < 0) {
                        gIdx = xCat;
                        continue;
                    }
                    if (xCat == gIdx) {
                        ++gCount;
                        continue;
                    }
                    this.groupsPerCategory[gIdx] = gCount;
                    if (gCount > maxGroups) {
                        maxGroups = gCount;
                    }
                    gCount = 1;
                    gIdx = xCat;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.groupsPerCategory[gIdx] = gCount;
            if (gCount > maxGroups) {
                maxGroups = gCount;
            }
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        ArrayList[] list;
        block19: {
            int i;
            int nCat;
            block18: {
                String[] gvalues = this.getGroupValues();
                int nGrp = this.groupVar.getUniqueValueCount();
                this.subToColumnGroupCategory = new int[nGrp];
                this.stringGroupVar.getUniqueValueCount();
                HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < nGrp; ++i2) {
                    try {
                        if (this.groupOrder == 0) {
                            String v = this.stringGroupVar.uniqueValue.getValue(i2);
                            int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                            value2ColumnCategory.put(v, new Integer(groupCategory_column));
                            this.subToColumnGroupCategory[i2] = groupCategory_column;
                            continue;
                        }
                        this.subToColumnGroupCategory[i2] = i2;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
                if (this.categoryVar == null) {
                    ArrayList<Integer> list2 = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < this.groupVar.getUniqueValueCount(); ++i3) {
                        list2.add(new Integer(i3));
                    }
                    if (this.groupOrder == 1 || this.groupOrder == 2) {
                        Collections.sort(list2);
                    } else if (this.groupOrder == 3) {
                        ArrayList ll = new ArrayList();
                        for (int j = list2.size() - 1; j >= 0; --j) {
                            ll.add(list2.get(j));
                        }
                        list2 = ll;
                    }
                    return new ArrayList[]{list2};
                }
                nCat = this.categoryVar instanceof StringVariable ? ((StringVariable)this.categoryVar).getUniqueValueCount() : ((NumericVariable)this.categoryVar).getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i4 = 0; i4 < nCat; ++i4) {
                    list[i4] = new ArrayList();
                }
                IntegerPipe xvalueCategory = this.categoryVar instanceof NumericVariable ? ((NumericVariable)this.categoryVar).category : ((StringVariable)this.categoryVar).category;
                IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
                int n = this.categoryVar.getValueCount();
                for (i = 0; i < n; ++i) {
                    try {
                        Integer IG;
                        int cat;
                        if (this.categoryVar instanceof NumericVariable) {
                            ((NumericVariable)this.categoryVar).value.getValue(i);
                        }
                        if (list[cat = xvalueCategory.getValue(i)].contains(IG = new Integer(groupCategory.getValue(i)))) continue;
                        list[cat].add(IG);
                        continue;
                    }
                    catch (MissingValueException cat) {
                        // empty catch block
                    }
                }
                if (this.groupOrder != 1 && this.groupOrder != 2) break block18;
                for (i = 0; i < nCat; ++i) {
                    Collections.sort(list[i]);
                }
                break block19;
            }
            if (this.groupOrder != 3) break block19;
            for (i = 0; i < nCat; ++i) {
                ArrayList ll = new ArrayList();
                for (int j = list[i].size() - 1; j >= 0; --j) {
                    ll.add(list[i].get(j));
                }
                list[i] = ll;
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    public boolean isIntervalBox() {
        return this.categoryVar != null && this.categoryVar instanceof NumericVariable;
    }

    public void setInnerMarginOverlays(Overlay[] blocks) {
        this.innerMarginOverlays = blocks;
        this.hasStatistic = true;
    }

    public Overlay[] getInnerMarginOverlays() {
        return this.innerMarginOverlays;
    }

    public void setInnerMarginOverlayLabelPosition() {
        if (this.innerMarginOverlays == null) {
            return;
        }
        int position = this.getYAxis().equalsIgnoreCase("Y") ? 2 : 1;
        for (int i = 0; i < this.innerMarginOverlays.length; ++i) {
            ((AxisTable)this.innerMarginOverlays[i]).setLabelPosition(position);
        }
    }

    public String[] getCategoryValues() {
        if (this.categoryVar == null) {
            return new String[]{"a"};
        }
        int num = this.categoryVar.getValueCount();
        String[] values = new String[num];
        StringPipe valuePipe = this.categoryVar instanceof NumericVariable ? ((NumericVariable)this.categoryVar).formattedValue : ((StringVariable)this.categoryVar).value;
        try {
            for (int i = 0; i < num; ++i) {
                values[i] = valuePipe.getValue(i);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return values;
    }

    public double[] getDoubleCategoryValues() {
        if (this.categoryVar instanceof StringVariable) {
            return null;
        }
        return this.getVariableValues((NumericVariable)this.categoryVar);
    }

    public ContinuousRange getDoubleCategoryRange() {
        if (this.categoryVar instanceof StringVariable) {
            return null;
        }
        return (ContinuousRange)this.getIndRange();
    }

    public double[] getVariableValues(NumericVariable var) {
        if (var == null) {
            return null;
        }
        int num = var.getValueCount();
        double[] values = new double[num];
        for (int i = 0; i < num; ++i) {
            try {
                values[i] = var.value.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                values[i] = Double.NaN;
            }
        }
        return values;
    }

    public double[] getStatistics(String statName) {
        if (statName.equalsIgnoreCase("MIN")) {
            return this.getVariableValues(this.minVar);
        }
        if (statName.equalsIgnoreCase("Q1")) {
            return this.getVariableValues(this.q1Var);
        }
        if (statName.equalsIgnoreCase("MEDIAN")) {
            return this.getVariableValues(this.medianVar);
        }
        if (statName.equalsIgnoreCase("Q3")) {
            return this.getVariableValues(this.q3Var);
        }
        if (statName.equalsIgnoreCase("MAX")) {
            return this.getVariableValues(this.maxVar);
        }
        if (statName.equalsIgnoreCase("MEAN")) {
            return this.getVariableValues(this.meanVar);
        }
        if (statName.equalsIgnoreCase("STD")) {
            return this.getVariableValues(this.stdVar);
        }
        if (statName.equalsIgnoreCase("N")) {
            return this.getVariableValues(this.nVar);
        }
        if (statName.equalsIgnoreCase("DATAMIN")) {
            return this.getVariableValues(this.dataMinVar);
        }
        if (statName.equalsIgnoreCase("DATAMAX")) {
            return this.getVariableValues(this.dataMaxVar);
        }
        if (statName.equalsIgnoreCase("RANGE")) {
            double[] max = this.getVariableValues(this.maxVar);
            double[] min = this.getVariableValues(this.minVar);
            if (min == null || max == null) {
                return null;
            }
            double[] range = new double[max.length];
            for (int i = 0; i < max.length; ++i) {
                range[i] = max[i] - min[i];
            }
            return range;
        }
        if (statName.equalsIgnoreCase("IQR")) {
            double[] q3 = this.getVariableValues(this.q3Var);
            double[] q1 = this.getVariableValues(this.q1Var);
            if (q1 == null || q3 == null) {
                return null;
            }
            double[] iqr = new double[q1.length];
            for (int i = 0; i < q1.length; ++i) {
                iqr[i] = q3[i] - q1[i];
            }
            return iqr;
        }
        return null;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        newRange = this.orientation == 0 ? this.getIndRange() : this.getDepRange();
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        if (this.orientation == 0) {
            this.fireRangeEvent((byte)1, oldRange, newRange);
        } else {
            this.fireRangeEvent((byte)2, oldRange, newRange);
        }
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        newRange = this.orientation == 0 ? this.getDepRange() : this.getIndRange();
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        if (this.orientation == 0) {
            this.fireRangeEvent((byte)2, oldRange, newRange);
        } else {
            this.fireRangeEvent((byte)1, oldRange, newRange);
        }
    }

    protected void updateHeatMapColorRange() {
        this.heatmapColorRange = null;
        if (!this.outlierOn || this.extreme) {
            return;
        }
        if (this.q1Var == null || this.q3Var == null) {
            return;
        }
        int n = this.q1Var.getValueCount();
        double binFreqMin = Double.MAX_VALUE;
        double binFreqMax = Double.MIN_VALUE;
        int b = 0;
        for (int idx = 0; idx < n; ++idx) {
            int j;
            if (this.outlierMinVarCount > 0 && this.binMinVar != null && !this.binMinVar.isMissing(idx) && (Double)Variable.getValue((Variable)this.binMinVar, (int)idx, (boolean)false) > 0.0 && this.binStartMinVar != null && this.binWidthMinVar != null && !this.binStartMinVar.isMissing(idx) && !this.binWidthMinVar.isMissing(idx)) {
                for (j = 0; j < this.outlierMinVarCount; ++j) {
                    try {
                        double v = this.outlierMinVars[j].value.getValue(idx);
                        if (this.isIncludeZeroBins() || v > 0.0) {
                            binFreqMin = Math.min(binFreqMin, v);
                            binFreqMax = Math.max(binFreqMax, v);
                        }
                        ++b;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
            }
            if (this.outlierMaxVarCount <= 0 || this.binMaxVar == null || this.binMaxVar.isMissing(idx) || !((Double)Variable.getValue((Variable)this.binMaxVar, (int)idx, (boolean)false) > 0.0) || this.binStartMaxVar == null || this.binWidthMaxVar == null || this.binStartMaxVar.isMissing(idx) || this.binWidthMaxVar.isMissing(idx)) continue;
            for (j = 0; j < this.outlierMaxVarCount; ++j) {
                try {
                    double v = this.outlierMaxVars[j].value.getValue(idx);
                    if (this.isIncludeZeroBins() || v > 0.0) {
                        binFreqMin = Math.min(binFreqMin, v);
                        binFreqMax = Math.max(binFreqMax, v);
                    }
                    ++b;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        if (b > 0) {
            this.heatmapColorRange = new ContinuousRange(binFreqMin, binFreqMax);
        }
    }

    private DataRange getIndRange() {
        Object range = null;
        if (this.categoryVar != null) {
            int num = this.categoryVar.getUniqueValueCount();
            if (num > 0) {
                boolean subset;
                boolean bl = this.orientation == 0 ? !this.xUnionAllPages : (subset = !this.yUnionAllPages);
                range = this.categoryVar instanceof NumericVariable ? this.makeContinuousRange((NumericVariable)this.categoryVar, (short)87, subset) : (this.numericCategoryVar == null ? this.makeDiscreteRange((StringVariable)this.categoryVar, num, (short)87, subset) : this.makeOrdinalRange((StringVariable)this.categoryVar, num, this.numericCategoryVar, (short)87, subset));
                range.setLabel(this.categoryVar.getLabel());
            } else {
                range = null;
            }
        } else {
            range = new StubRange();
        }
        if (range != null) {
            this.setFormat((DataRange)range, 87);
        }
        return range;
    }

    private DataRange getDepRange() {
        ContinuousRange range = null;
        boolean subset = this.orientation == 0 ? !this.yUnionAllPages : !this.xUnionAllPages;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int num = this.dataMinVar.getValueCount();
        if (num > 0) {
            range = this.makeContinuousRange(this.dataMinVar, (short)77, subset);
            min = Math.min(min, range.getMin());
            max = Math.max(max, range.getMax());
        }
        if ((num = this.dataMaxVar.getValueCount()) > 0) {
            range = this.makeContinuousRange(this.dataMaxVar, (short)78, subset);
            min = Math.min(min, range.getMin());
            max = Math.max(max, range.getMax());
        }
        if (this.notchOn && this.medianVar != null && this.nVar != null) {
            int n = this.q1Var.getValueCount();
            for (int i = 0; i < n; ++i) {
                try {
                    double median = this.medianVar.value.getValue(i);
                    double q1 = this.q1Var.value.getValue(i);
                    double q3 = this.q3Var.value.getValue(i);
                    double nobs = this.nVar.value.getValue(i);
                    if (nobs <= 0.0 || !(q1 <= median) || !(median <= q3)) continue;
                    double notch = 1.58 * (q3 - q1) / Math.sqrt(nobs);
                    min = Math.min(min, median - notch);
                    max = Math.max(max, median + notch);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
        }
        range = new ContinuousRange(min, max);
        this.analysisLabel = this.analysisLabelVar.getLabel();
        if (this.analysisLabel == null || this.analysisLabel.length() == 0) {
            this.analysisLabel = (String)Variable.getValue((Variable)this.analysisLabelVar, (int)0, (boolean)true);
        }
        if (this.analysisLabel == null) {
            this.analysisLabel = "";
        }
        if (range != null) {
            range.setLabel(this.analysisLabel);
            this.setFormat((DataRange)range, 71);
        }
        return range;
    }

    private boolean isValidBox(int obsIndex) {
        double max;
        double min;
        double median;
        double q3;
        if (this.q1Var.isMissing(obsIndex) || this.q3Var.isMissing(obsIndex)) {
            return false;
        }
        double q1 = (Double)Variable.getValue((Variable)this.q1Var, (int)obsIndex, (boolean)false);
        if (q1 > (q3 = ((Double)Variable.getValue((Variable)this.q3Var, (int)obsIndex, (boolean)false)).doubleValue())) {
            return false;
        }
        if (this.medianVar != null && !this.medianVar.isMissing(obsIndex) && ((median = ((Double)Variable.getValue((Variable)this.medianVar, (int)obsIndex, (boolean)false)).doubleValue()) < q1 || median > q3)) {
            return false;
        }
        if (this.minVar != null && !this.minVar.isMissing(obsIndex) && this.maxVar != null && !this.maxVar.isMissing(obsIndex) && (min = ((Double)Variable.getValue((Variable)this.minVar, (int)obsIndex, (boolean)false)).doubleValue()) > (max = ((Double)Variable.getValue((Variable)this.maxVar, (int)obsIndex, (boolean)false)).doubleValue())) {
            return false;
        }
        if (this.dataMinVar != null && !this.dataMinVar.isMissing(obsIndex) && this.dataMaxVar != null && !this.dataMaxVar.isMissing(obsIndex) && (min = ((Double)Variable.getValue((Variable)this.dataMinVar, (int)obsIndex, (boolean)false)).doubleValue()) > (max = ((Double)Variable.getValue((Variable)this.dataMaxVar, (int)obsIndex, (boolean)false)).doubleValue())) {
            return false;
        }
        if (this.nVar != null && !this.nVar.isMissing(obsIndex) && (Double)Variable.getValue((Variable)this.nVar, (int)obsIndex, (boolean)false) <= 0.0) {
            return false;
        }
        return this.stdVar == null || this.stdVar.isMissing(obsIndex) || !((Double)Variable.getValue((Variable)this.stdVar, (int)obsIndex, (boolean)false) < 0.0);
    }

    @Override
    public boolean connectNetwork() {
        DiscreteAttrMapper groupAttrMapper;
        int i;
        StringToNumericMapper translate;
        SASFormat format;
        double intvl;
        this.hasInvalidBox = false;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xRange == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        double stride = 0.0;
        double discreteOffsetValue = 0.0;
        double boxSize = 0.0;
        ContinuousRangeToNumericMapper xvalueMapper2 = null;
        ContinuousRangeToNumericMapper yvalueMapper2 = null;
        boolean numericCategory = this.categoryVar instanceof NumericVariable;
        ValueMap map = this.xEncoder.getValueMap();
        if (this.orientation != 0 || this.orientation == 0 && numericCategory) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            if (this.xEncoder instanceof BrokenPositionEncoder) {
                xvalueMapper2 = new ContinuousRangeToNumericMapper();
                xvalueMapper2.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)this.xEncoder).getBrokenValueMap());
            }
            if (this.orientation == 0) {
                intvl = this.getMinimumInterval((short)87);
                boxSize = intvl == 0.0 ? 0.75 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) : this.getDefaultIntervalBoxSize(intvl, this.xEncoder, false);
                stride = boxSize;
            }
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
            stride = ((StringToNumericMap)map).getStrideValue();
            discreteOffsetValue = this.discreteOffset * stride;
            if (this.xEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
            boxSize = stride;
        }
        map = this.yEncoder.getValueMap();
        if (this.orientation == 0 || this.orientation != 0 && numericCategory) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.yvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            if (this.yEncoder instanceof BrokenPositionEncoder) {
                yvalueMapper2 = new ContinuousRangeToNumericMapper();
                yvalueMapper2.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)this.yEncoder).getBrokenValueMap());
            }
            if (this.orientation != 0) {
                intvl = this.getMinimumInterval((short)87);
                boxSize = intvl == 0.0 ? 0.75 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) : this.getDefaultIntervalBoxSize(intvl, this.yEncoder, false);
                stride = boxSize;
            }
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof StringToNumericMapper)) {
                this.yvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.yvalueMapper).setMap((StringToNumericMap)map);
            stride = ((StringToNumericMap)map).getStrideValue();
            discreteOffsetValue = this.discreteOffset * stride;
            if (this.yEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
            boxSize = stride;
        }
        this.loadSkinImage();
        int n = this.q1Var.getValueCount();
        NumericVectorVariable tukeyYVar = new NumericVectorVariable();
        double[] tukeyY = new double[n * 7];
        boolean xIdx = false;
        int yIdx = 0;
        BooleanVector graphedVector = new BooleanVector();
        BooleanVector notchVector = new BooleanVector();
        for (int i2 = 0; i2 < n; ++i2) {
            boolean valid;
            double nv = 0.0;
            double max = 0.0;
            double min = 0.0;
            double median = 0.0;
            double mean = 0.0;
            double q3 = 0.0;
            double q1 = 0.0;
            try {
                q1 = this.q1Var.value.getValue(i2);
            }
            catch (MissingValueException e) {
                q1 = Double.NaN;
            }
            try {
                q3 = this.q3Var.value.getValue(i2);
            }
            catch (MissingValueException e) {
                q3 = Double.NaN;
            }
            boolean hasMean = false;
            if (this.meanVar != null) {
                try {
                    mean = this.meanVar.value.getValue(i2);
                    hasMean = true;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            boolean hasMedian = false;
            if (this.medianVar != null) {
                try {
                    median = this.medianVar.value.getValue(i2);
                    hasMedian = true;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            boolean hasWhiskerMin = false;
            boolean hasWhiskerMax = false;
            if (this.extreme) {
                if (this.dataMinVar != null) {
                    try {
                        min = this.dataMinVar.value.getValue(i2);
                        hasWhiskerMin = true;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                if (this.dataMaxVar != null) {
                    try {
                        max = this.dataMaxVar.value.getValue(i2);
                        hasWhiskerMax = true;
                    }
                    catch (MissingValueException missingValueException) {}
                }
            } else {
                if (this.minVar != null) {
                    try {
                        min = this.minVar.value.getValue(i2);
                        hasWhiskerMin = true;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                if (this.maxVar != null) {
                    try {
                        max = this.maxVar.value.getValue(i2);
                        hasWhiskerMax = true;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
            if (this.nVar != null) {
                try {
                    nv = this.nVar.value.getValue(i2);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (!(valid = this.isValidBox(i2))) {
                q3 = Double.NaN;
                q1 = Double.NaN;
                this.hasInvalidBox = true;
            }
            tukeyY[yIdx++] = min;
            tukeyY[yIdx++] = q1;
            tukeyY[yIdx++] = median;
            tukeyY[yIdx++] = q3;
            tukeyY[yIdx++] = max;
            tukeyY[yIdx++] = mean;
            tukeyY[yIdx++] = nv;
            graphedVector.addValue(hasWhiskerMin);
            graphedVector.addValue(true);
            graphedVector.addValue(hasMedian && this.isMedianOn());
            graphedVector.addValue(true);
            graphedVector.addValue(hasWhiskerMax);
            graphedVector.addValue(hasMean && this.isMeanOn());
            graphedVector.addValue(nv > 0.0);
            notchVector.addValue(hasMedian && this.isNotchOn());
        }
        tukeyYVar.connectFrom(tukeyY);
        SASFormat sASFormat = format = this.orientation == 0 ? this.xEncoder.getInput().getFormat() : this.yEncoder.getInput().getFormat();
        if (format != null && this.categoryVar != null) {
            GTKFormat gtkFMT = new GTKFormat((Format)format);
            this.categoryVar.setFormat(gtkFMT);
        }
        SASFormat sASFormat2 = format = this.orientation == 0 ? this.yEncoder.getInput().getFormat() : this.xEncoder.getInput().getFormat();
        if (format != null) {
            GTKFormat gtkFMT = new GTKFormat((Format)format);
            tukeyYVar.setFormat(gtkFMT);
        } else {
            tukeyYVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        NumericMapper nm = this.orientation == 0 ? this.yvalueMapper : this.xvalueMapper;
        ((ContinuousRangeToNumericMapper)nm).input.connectFrom(tukeyYVar.value);
        this.networkRoot.removeAllElements();
        TukeyBox tBox = new TukeyBox();
        PositionEncoder pe = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        Object object = map = pe instanceof BrokenPositionEncoder ? ((BrokenPositionEncoder)pe).getBrokenValueMap() : pe.getValueMap();
        if (this.categoryVar == null) {
            if (this.groupVar == null) {
                translate = new StringToNumericMapper();
                translate.input.setValue("a");
                translate.setMap((StringToNumericMap)map);
            } else {
                int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                boxSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                translate = new NumericVector();
                for (i = 0; i < this.q1Var.getValueCount(); ++i) {
                    try {
                        double x = ((StringToNumericMap)map).uniqueValue.getValue(0);
                        int gcat = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).category.getValue(i) : ((NumericVariable)this.groupVar).category.getValue(i);
                        x -= (double)((int)(((double)this.groupsPerCategory[0] / 2.0 - 0.5) * boxSize));
                        ((NumericVector)translate).addValue(x += boxSize * (double)this.groupCategoryLists[0].indexOf(gcat));
                        continue;
                    }
                    catch (MissingValueException e) {
                        ((NumericVector)translate).addValue(Double.NaN);
                    }
                }
            }
        } else if (this.groupVar == null) {
            if (this.categoryVar instanceof NumericVariable) {
                translate = new ContinuousRangeToNumericMapper();
                if (this.groupVar == null) {
                    NumericPipe uv = ((NumericVariable)this.categoryVar).value;
                    ((ContinuousRangeToNumericMapper)translate).input.connectFrom(uv);
                    ((ContinuousRangeToNumericMapper)translate).setMap((ContinuousRangeToNumericMap)map);
                }
            } else {
                translate = new StringToNumericMapper();
                StringPipe uv = ((StringVariable)this.categoryVar).value;
                translate.input.connectFrom(uv);
                translate.setMap((StringToNumericMap)map);
            }
        } else {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            boxSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            translate = new NumericVector();
            for (i = 0; i < this.categoryVar.getValueCount(); ++i) {
                try {
                    int xcat;
                    double x;
                    if (this.categoryVar instanceof NumericVariable) {
                        double xval = ((NumericVariable)this.categoryVar).value.getValue(i);
                        x = ((ContinuousRangeToNumericMap)map).getValue(xval);
                        xcat = ((NumericVariable)this.categoryVar).category.getValue(i);
                    } else {
                        String xval = ((StringVariable)this.categoryVar).value.getValue(i);
                        x = ((StringToNumericMap)map).getValue((Object)xval);
                        xcat = ((StringVariable)this.categoryVar).category.getValue(i);
                    }
                    int gcat = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).category.getValue(i) : ((NumericVariable)this.groupVar).category.getValue(i);
                    x -= (double)((int)(((double)this.groupsPerCategory[xcat] / 2.0 - 0.5) * boxSize));
                    ((NumericVector)translate).addValue(x += boxSize * (double)this.groupCategoryLists[xcat].indexOf(gcat));
                    continue;
                }
                catch (MissingValueException e) {
                    ((NumericVector)translate).addValue(Double.NaN);
                }
            }
        }
        int nBox = this.q1Var.getValueCount();
        double heatmapSize = boxSize;
        boxSize = numericCategory ? (this.intervalBoxWidth >= 0.0 ? this.intervalBoxWidth : (!this.userSetBoxWidth ? (boxSize *= 0.85) : (boxSize *= this.boxWidth))) : (boxSize *= this.boxWidth);
        if (this.isAutoBoxSize() && boxSize < 5.0) {
            boxSize = 5.0;
        }
        ColorVector colorPipe = null;
        if (this.groupVar != null && this.colorEncoder != null) {
            colorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.colorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (int i3 = 0; i3 < nBox; ++i3) {
                Color c;
                try {
                    String gval = this.stringGroupVar.value.getValue(i3);
                    c = cmap.getValue(gval);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.fillStyle);
                }
                colorPipe.addValue(c);
            }
        }
        ColorVector lineColorPipe = null;
        if (this.groupVar != null && this.lineColorEncoder != null) {
            lineColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.lineColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (int i4 = 0; i4 < nBox; ++i4) {
                Color c;
                try {
                    String gval = this.stringGroupVar.value.getValue(i4);
                    c = cmap.getValue(gval);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.outlineStyle);
                }
                lineColorPipe.addValue(c);
            }
        }
        ColorVector meanColorPipe = null;
        if (this.groupVar != null && this.meanColorEncoder != null) {
            meanColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.meanColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            MarkerAttrs ma = new MarkerAttrs();
            ma.setColor(this.meanStyle.getColor());
            ma.setTransparency(this.meanStyle.getTransparency());
            for (int i5 = 0; i5 < nBox; ++i5) {
                Color c;
                try {
                    String gval = this.stringGroupVar.value.getValue(i5);
                    c = cmap.getValue(gval);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)ma);
                }
                meanColorPipe.addValue(c);
            }
        }
        IntegerVector stipplePatternPipe = null;
        IntegerVector stippleFactorPipe = null;
        IntegerVector linePatternPipe = null;
        if (this.groupVar != null && this.lineEncoder != null) {
            stipplePatternPipe = new IntegerVector();
            stippleFactorPipe = new IntegerVector();
            linePatternPipe = new IntegerVector();
            HashMap ht = this.lineEncoder.styleList;
            for (int i6 = 0; i6 < nBox; ++i6) {
                LineAttrs ls;
                try {
                    String gval = this.stringGroupVar.value.getValue(i6);
                    ls = (LineAttrs)ht.get(gval);
                }
                catch (MissingValueException e) {
                    ls = this.outlineStyle;
                }
                stipplePatternPipe.addValue(ls.getStipplePattern());
                stippleFactorPipe.addValue(ls.getStippleFactor());
                linePatternPipe.addValue(ls.getLinePattern());
            }
        }
        IntegerVector shapePipe = null;
        if (this.groupVar != null && this.shapeEncoder != null) {
            shapePipe = new IntegerVector();
            HashMap ht = this.shapeEncoder.shapeList;
            int ms = -1;
            for (int i7 = 0; i7 < nBox; ++i7) {
                try {
                    String gval = this.stringGroupVar.value.getValue(i7);
                    ms = (Integer)ht.get(gval);
                }
                catch (MissingValueException e) {
                    ms = this.meanStyle.getShape();
                }
                shapePipe.addValue(ms);
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.groupVar != null && this.hasAttrVar("TUKEYGROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.setMarkerTransparency(this.meanStyle.getTransparency() < 0.0 ? this.dataTransparency : this.meanStyle.getTransparency());
            groupAttrMapper.setUseMarkerTransparency(this.useMeanTransparency);
            groupAttrMapper.variable = ((StringVectorVariable)this.stringGroupVar).value;
            groupAttrMapper.fillColorPipe = colorPipe;
            groupAttrMapper.lineColorPipe = lineColorPipe;
            groupAttrMapper.linePatternPipe = linePatternPipe;
            groupAttrMapper.markerColorPipe = lineColorPipe;
            groupAttrMapper.markerSymbolPipe = shapePipe;
            groupAttrMapper.addLineThicknessPipe("median", this.medianStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("outline", this.outlineStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("whisker", this.whiskerStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("connect", this.connectStyle.getWidth());
            groupAttrMapper.addMarkerSizePipe("mean", this.meanStyle.getSize());
            groupAttrMapper.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
            if (this.useMeanSize && !this.useMeanWeight) {
                groupAttrMapper.addMarkerEdgeThicknessPipe("mean", this.meanStyle.getSize(), this.meanStyle.getWeight(), true);
            } else {
                groupAttrMapper.addMarkerEdgeThicknessPipe("mean", this.meanStyle.getSize(), this.meanStyle.getWeight());
            }
            if (this.scaleMarkers) {
                double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
                double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
                groupAttrMapper.setScaleMarkers(true);
                groupAttrMapper.setMinMarkerSize(5);
                groupAttrMapper.setRatioW(ratio_w);
                groupAttrMapper.setRatioH(ratio_h);
            }
        }
        ColorProperty fillColorProperty = new ColorProperty();
        if (this.colorEncoder == null || this.useFillColor) {
            fillColorProperty.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        } else {
            fillColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? colorPipe : groupAttrMapper.fillColor));
        }
        ColorProperty outlineColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useOutlineColor) {
            outlineColorProperty.setValue(this.applyDataTransparency(this.outlineStyle.getColor()));
        } else {
            outlineColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty outlineStipplePatternProperty = new IntegerProperty();
        IntegerProperty outlineStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useOutlinePattern) {
            outlineStipplePatternProperty.setValue(this.outlineStyle.getStipplePattern());
            outlineStippleFactorProperty.setValue(this.outlineStyle.getStippleFactor());
        } else {
            outlineStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            outlineStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        ColorProperty medianColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useMedianColor) {
            medianColorProperty.setValue(this.applyDataTransparency(this.medianStyle.getColor()));
        } else {
            medianColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty medianStipplePatternProperty = new IntegerProperty();
        IntegerProperty medianStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useMedianPattern) {
            medianStipplePatternProperty.setValue(this.medianStyle.getStipplePattern());
            medianStippleFactorProperty.setValue(this.medianStyle.getStippleFactor());
        } else {
            medianStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            medianStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        ColorProperty meanColorProperty = new ColorProperty();
        if (this.meanColorEncoder == null || this.useMeanColor) {
            meanColorProperty.setValue(this.applyDataTransparency(this.meanStyle.getColor(), this.meanStyle.getTransparency()));
        } else {
            meanColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? meanColorPipe : groupAttrMapper.markerColor));
        }
        IntegerProperty meanSymbolProperty = new IntegerProperty();
        if (this.shapeEncoder == null || this.useMeanSymbol) {
            meanSymbolProperty.setValue(this.meanStyle.getShape());
        } else {
            meanSymbolProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? shapePipe : groupAttrMapper.markerSymbol));
        }
        ColorProperty whiskerColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useWhiskerColor) {
            whiskerColorProperty.setValue(this.applyDataTransparency(this.whiskerStyle.getColor()));
        } else {
            whiskerColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty whiskerStipplePatternProperty = new IntegerProperty();
        IntegerProperty whiskerStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useWhiskerPattern) {
            whiskerStipplePatternProperty.setValue(this.whiskerStyle.getStipplePattern());
            whiskerStippleFactorProperty.setValue(this.whiskerStyle.getStippleFactor());
        } else {
            whiskerStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            whiskerStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        NumericPipe translatePipe = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)translate);
        if (this.orientation == 0) {
            tBox.transform.translateX.connectFrom(translatePipe);
            tBox.y.connectFrom(this.yvalueMapper.value);
        } else {
            tBox.transform.translateY.connectFrom(translatePipe);
            tBox.y.connectFrom(this.xvalueMapper.value);
        }
        tBox.rawY.connectFrom(tukeyYVar.value);
        tBox.outlierCount.setValue(0);
        tBox.graphed.connectFrom((BooleanPipe)graphedVector);
        tBox.orientation.setValue(this.orientation);
        tBox.extreme.setValue(false);
        tBox.boxWidth.setValue(boxSize);
        tBox.notched.connectFrom((BooleanPipe)notchVector);
        if (this.isCapOn()) {
            tBox.capShape.setValue(this.capShape);
        } else {
            tBox.capShape.setValue(0);
        }
        tBox.setCapScale(this.capScale);
        tBox.medianColor.connectFrom((ColorPipe)medianColorProperty);
        tBox.medianShape.setValue(this.medianSymbol);
        if (this.useMedianSize || groupAttrMapper == null) {
            tBox.medianWidth.setValue((double)this.medianStyle.getWidth());
        } else {
            tBox.medianWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("median"));
        }
        tBox.medianStippleFactor.connectFrom((IntegerPipe)medianStippleFactorProperty);
        tBox.medianStipplePattern.connectFrom((IntegerPipe)medianStipplePatternProperty);
        tBox.meanColor.connectFrom((ColorPipe)meanColorProperty);
        tBox.meanShape.connectFrom((IntegerPipe)meanSymbolProperty);
        if (!this.useMeanSize && groupAttrMapper == null && this.isAutoBoxSize()) {
            tBox.meanWidth.setValue(Math.min(boxSize, (double)this.meanStyle.getSize()));
            tBox.meanEdgeWidth.setValue((double)StatGraph.getMarkerEdgeWidth(this.meanStyle.getSize(), this.meanStyle.getWeight()));
        } else if (this.useMeanSize || groupAttrMapper == null) {
            tBox.meanWidth.setValue((double)this.meanStyle.getSize());
            if (groupAttrMapper != null && !this.useMeanWeight) {
                tBox.meanEdgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("mean"));
            } else {
                tBox.meanEdgeWidth.setValue((double)StatGraph.getMarkerEdgeWidth(this.meanStyle.getSize(), this.meanStyle.getWeight()));
            }
        } else {
            tBox.meanWidth.connectFrom((IntegerPipe)groupAttrMapper.markerSize.get("mean"));
            tBox.meanEdgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("mean"));
        }
        tBox.markerOn.setValue(false);
        tBox.markerColor.setValue(this.applyDataTransparency(this.outlierStyle.getColor()));
        tBox.markerShape.setValue(this.outlierStyle.getShape());
        tBox.fillOn.setValue(this.fillOn);
        tBox.fillColor.connectFrom((ColorPipe)fillColorProperty);
        tBox.outlineColor.connectFrom((ColorPipe)outlineColorProperty);
        if (this.useOutlineSize || groupAttrMapper == null) {
            tBox.outlineWidth.setValue((double)this.outlineStyle.getWidth());
        } else {
            tBox.outlineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("outline"));
        }
        tBox.outlineStippleFactor.connectFrom((IntegerPipe)outlineStippleFactorProperty);
        tBox.outlineStipplePattern.connectFrom((IntegerPipe)outlineStipplePatternProperty);
        tBox.whiskerColor.connectFrom((ColorPipe)whiskerColorProperty);
        if (this.useWhiskerSize || groupAttrMapper == null) {
            tBox.whiskerWidth.setValue((double)this.whiskerStyle.getWidth());
        } else {
            tBox.whiskerWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("whisker"));
        }
        tBox.whiskerStippleFactor.connectFrom((IntegerPipe)whiskerStippleFactorProperty);
        tBox.whiskerStipplePattern.connectFrom((IntegerPipe)whiskerStipplePatternProperty);
        tBox.capColor.connectFrom((ColorPipe)whiskerColorProperty);
        if (this.useWhiskerSize || groupAttrMapper == null) {
            tBox.capWidth.setValue((double)this.whiskerStyle.getWidth());
        } else {
            tBox.capWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("whisker"));
        }
        tBox.capStippleFactor.setValue(this.capStyle.getStippleFactor());
        tBox.capStipplePattern.setValue(this.capStyle.getStipplePattern());
        tBox.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        tBox.setSkin(this.skinImage);
        tBox.setSkinType(this.skinType);
        tBox.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        tBox.setPixelBenderImages(this.pixelBenderImages, 1);
        tBox.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4), 4);
        tBox.selectEnabled.setValue(this.selectable);
        tBox.setUserData((Object)this.probe);
        this.networkRoot.addElement((Element)tBox);
        if (this.outlierOn && !this.extreme) {
            this.connectOutliers(translatePipe, xvalueMapper2, yvalueMapper2, heatmapSize * this.heatmapWidth, boxSize);
        }
        if (this.isConnectOn() && this.categoryVar != null) {
            ContinuousRangeToNumericMapper crnm = new ContinuousRangeToNumericMapper();
            if (this.orientation == 0) {
                crnm.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
            } else {
                crnm.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
            }
            switch (this.connectBy) {
                case 1: {
                    if (this.extreme) {
                        crnm.input.connectFrom(this.dataMinVar.value);
                        break;
                    }
                    crnm.input.connectFrom(this.minVar.value);
                    break;
                }
                case 2: {
                    crnm.input.connectFrom(this.q1Var.value);
                    break;
                }
                case 3: {
                    crnm.input.connectFrom(this.medianVar.value);
                    break;
                }
                case 4: {
                    crnm.input.connectFrom(this.q3Var.value);
                    break;
                }
                case 5: {
                    if (this.extreme) {
                        crnm.input.connectFrom(this.dataMaxVar.value);
                        break;
                    }
                    crnm.input.connectFrom(this.maxVar.value);
                    break;
                }
                case 6: {
                    crnm.input.connectFrom(this.meanVar.value);
                }
            }
            NumericVector linePosition = new NumericVector();
            crnm.init(new AInitAction(null));
            for (int i8 = 0; i8 < nBox; ++i8) {
                if (this.isValidBox(i8)) {
                    try {
                        linePosition.addValue(crnm.getValue(i8));
                    }
                    catch (MissingValueException e) {
                        linePosition.addValue(Double.NaN);
                    }
                    continue;
                }
                linePosition.addValue(Double.NaN);
            }
            StringToColorMapper lineColorMapper = null;
            if (this.groupVar != null && this.lineColorEncoder != null) {
                lineColorMapper = new StringToColorMapper();
                lineColorMapper.input.connectFrom(this.stringGroupVar.value);
                lineColorMapper.setReplaceMissingValues(true);
                HashMap lcht = this.lineColorEncoder.colorList;
                for (int i9 = 0; i9 < nBox; ++i9) {
                    Color c;
                    try {
                        String gval = this.stringGroupVar.value.getValue(i9);
                        c = (Color)lcht.get(gval);
                        lineColorMapper.add(gval, c);
                        continue;
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency(this.connectStyle.getColor());
                        lineColorMapper.setMissingReplacement(c, e.getMissingValue());
                    }
                }
            }
            StringToNumberMapper linePatternMapper = null;
            if (this.groupVar != null && this.lineEncoder != null) {
                linePatternMapper = new StringToNumberMapper();
                linePatternMapper.input.connectFrom(this.stringGroupVar.value);
                linePatternMapper.setReplaceMissingValues(true);
                HashMap ht = this.lineEncoder.styleList;
                for (int i10 = 0; i10 < nBox; ++i10) {
                    LineAttrs ls;
                    try {
                        String gval = this.stringGroupVar.value.getValue(i10);
                        ls = (LineAttrs)ht.get(gval);
                        linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                        continue;
                    }
                    catch (MissingValueException e) {
                        ls = this.connectStyle;
                        linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                    }
                }
            }
            if (groupAttrMapper != null) {
                groupAttrMapper.lineColorMapper = lineColorMapper;
                groupAttrMapper.linePatternMapper = linePatternMapper;
            }
            LineConnector line = new LineConnector();
            line.setMultipleGroup(true);
            line.setPresortRequired(true);
            if (lineColorMapper == null || this.useConnectLineColor) {
                line.color.setValue(this.applyDataTransparency(this.connectStyle.getColor()));
            } else {
                line.color.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorMapper : groupAttrMapper.lineColor));
            }
            if (this.useConnectLineSize || groupAttrMapper == null) {
                line.lineWidth.setValue((double)this.connectStyle.getWidth());
            } else {
                line.lineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("connect"));
            }
            if (linePatternMapper == null) {
                line.setStipple(this.connectStyle.getStipplePattern(), this.connectStyle.getStippleFactor());
                line.linePattern.setValue(this.connectStyle.getLinePattern());
            } else if (this.useConnectLinePattern) {
                line.linePattern.setValue(this.connectStyle.getLinePattern());
            } else if (groupAttrMapper == null) {
                line.linePattern.connectFrom((NumericPipe)linePatternMapper);
            } else {
                line.linePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            }
            line.pointZ.setValue(0.0);
            if (this.orientation == 0) {
                line.pointX.connectFrom(translatePipe);
                line.pointY.connectFrom((NumericPipe)linePosition);
            } else {
                line.pointX.connectFrom((NumericPipe)linePosition);
                line.pointY.connectFrom(translatePipe);
                line.setSkipMissingOnXAxis(true);
            }
            if (this.groupVar != null) {
                line.stringGroup.connectFrom(this.stringGroupVar.value);
            }
            line.setConnectionOrder(this.connectionOrder);
            line.setSkipMissingOn(this.connectSkipMiss);
            this.networkRoot.addElement((Element)line);
        }
        this.needConnect = false;
        if (this.hasInvalidBox && !this.warningIssued) {
            if (nBox == 1) {
                StatGraph.printWarning(RB.getStringResource("BoxOverlay.", "missingbox.txt"));
            } else {
                StatGraph.printWarning(RB.getStringResource("BoxOverlay.", "missingboxes.txt"));
            }
            this.warningIssued = true;
        }
        return true;
    }

    private void connectOutliers(NumericPipe translatePipe, ContinuousRangeToNumericMapper xvalueMapper2, ContinuousRangeToNumericMapper yvalueMapper2, double heatmapSize, double boxSize) {
        DiscreteAttrMapper groupAttrMapper2;
        String gval;
        int i;
        int scaledMarkerSize = this.outlierStyle.getSize();
        if (this.scaleMarkers) {
            double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
            double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
            scaledMarkerSize = (int)((double)this.outlierStyle.getSize() * Math.pow(Math.min(ratio_w, ratio_h), 0.25) + 0.5);
            scaledMarkerSize = Math.min(this.outlierStyle.getSize(), Math.max(5, scaledMarkerSize));
        }
        ContinuousRangeToNumericMapper yMapper = yvalueMapper2 == null ? this.yvalueMapper : yvalueMapper2;
        ContinuousRangeToNumericMapper xMapper = xvalueMapper2 == null ? this.xvalueMapper : xvalueMapper2;
        ContinuousRangeToNumericMapper nmY = new ContinuousRangeToNumericMapper();
        if (this.orientation == 0) {
            nmY.shareMap(yMapper);
        } else {
            nmY.shareMap(xMapper);
        }
        ColorVector outlierColorPipe = null;
        if (this.groupVar != null && this.outlierColorEncoder != null) {
            outlierColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.outlierColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            MarkerAttrs ma = new MarkerAttrs();
            ma.setTransparency(this.outlierStyle.getTransparency());
            ma.setColor(this.outlierStyle.getColor());
            for (i = 0; i < this.stringGroupVar.getValueCount(); ++i) {
                Color c;
                try {
                    gval = this.stringGroupVar.value.getValue(i);
                    c = cmap.getValue(gval);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)ma);
                }
                outlierColorPipe.addValue(c);
            }
        }
        IntegerVector outlierShapePipe = null;
        if (this.groupVar != null && this.shapeEncoder != null) {
            outlierShapePipe = new IntegerVector();
            HashMap ht = this.shapeEncoder.shapeList;
            int ms = -1;
            for (i = 0; i < this.stringGroupVar.getValueCount(); ++i) {
                try {
                    gval = this.stringGroupVar.value.getValue(i);
                    ms = (Integer)ht.get(gval);
                }
                catch (MissingValueException e) {
                    ms = this.outlierStyle.getShape();
                }
                outlierShapePipe.addValue(ms);
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper2 = this.groupVar != null && this.hasAttrVar("OUTLIERGROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("OUTLIERGROUP") : null;
        if (groupAttrMapper2 != null) {
            groupAttrMapper2.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper2.setLineTransparency(this.dataTransparency);
            groupAttrMapper2.setMarkerTransparency(this.outlierStyle.getTransparency() < 0.0 ? this.dataTransparency : this.outlierStyle.getTransparency());
            groupAttrMapper2.setUseMarkerTransparency(this.useOutlierTransparency);
            groupAttrMapper2.variable = ((StringVectorVariable)this.stringGroupVar).value;
            groupAttrMapper2.markerColorPipe = outlierColorPipe;
            groupAttrMapper2.markerSymbolPipe = outlierShapePipe;
            groupAttrMapper2.addMarkerSizePipe("outlier", scaledMarkerSize);
            if (this.useOutlierSize && !this.useOutlierWeight) {
                groupAttrMapper2.addMarkerEdgeThicknessPipe("outlier", scaledMarkerSize, this.outlierStyle.getWeight(), true);
            } else {
                groupAttrMapper2.addMarkerEdgeThicknessPipe("outlier", scaledMarkerSize, this.outlierStyle.getWeight());
            }
            if (this.scaleMarkers) {
                double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
                double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
                groupAttrMapper2.setScaleMarkers(true);
                groupAttrMapper2.setMinMarkerSize(5);
                groupAttrMapper2.setRatioW(ratio_w);
                groupAttrMapper2.setRatioH(ratio_h);
            }
        }
        ColorProperty outlierColorProperty = new ColorProperty();
        if (this.outlierColorEncoder == null || this.useOutlierColor) {
            outlierColorProperty.setValue(this.applyDataTransparency(this.outlierStyle.getColor(), this.outlierStyle.getTransparency()));
        } else {
            outlierColorProperty.connectFrom((ColorPipe)(groupAttrMapper2 == null ? outlierColorPipe : groupAttrMapper2.markerColor));
        }
        IntegerProperty outlierSymbolProperty = new IntegerProperty();
        if (this.shapeEncoder == null || this.useOutlierSymbol) {
            outlierSymbolProperty.setValue(this.outlierStyle.getShape());
        } else {
            outlierSymbolProperty.connectFrom((IntegerPipe)(groupAttrMapper2 == null ? outlierShapePipe : groupAttrMapper2.markerSymbol));
        }
        IntegerProperty outlierSizeProperty = new IntegerProperty();
        IntegerProperty outlierEdgeWidthProperty = new IntegerProperty();
        if (!this.useOutlierSize && groupAttrMapper2 == null && this.isAutoBoxSize()) {
            outlierSizeProperty.setValue((int)Math.min(boxSize, (double)scaledMarkerSize));
            outlierEdgeWidthProperty.setValue(StatGraph.getMarkerEdgeWidth(scaledMarkerSize, this.outlierStyle.getWeight()));
        } else if (this.useOutlierSize || groupAttrMapper2 == null) {
            outlierSizeProperty.setValue(scaledMarkerSize);
            if (groupAttrMapper2 != null && !this.useOutlierWeight) {
                outlierEdgeWidthProperty.connectFrom((IntegerPipe)groupAttrMapper2.markerEdgeThickness.get("outlier"));
            } else {
                outlierEdgeWidthProperty.setValue(StatGraph.getMarkerEdgeWidth(scaledMarkerSize, this.outlierStyle.getWeight()));
            }
        } else {
            outlierSizeProperty.connectFrom((IntegerPipe)groupAttrMapper2.markerSize.get("outlier"));
            outlierEdgeWidthProperty.connectFrom((IntegerPipe)groupAttrMapper2.markerEdgeThickness.get("outlier"));
        }
        ContinuousRangeToColorMapper heatmapColorMapper = null;
        if (this.heatmapColorEncoder != null) {
            heatmapColorMapper = new ContinuousRangeToColorMapper();
            heatmapColorMapper.setMap((ContinuousRangeToColorMap)this.heatmapColorEncoder.getValueMap());
            heatmapColorMapper.setReplaceMissingValues(true);
            heatmapColorMapper.setMissingReplacement(this.missingHeatmapColor);
        }
        GTKFormat binFreqFormat = new GTKFormat((Format)DataModel.defaultFormat);
        int nBox = this.q1Var.getValueCount();
        for (int idx = 0; idx < nBox; ++idx) {
            int j;
            double bWidth;
            int j2;
            double categoryPosition = Double.NaN;
            if (this.isValidBox(idx)) {
                try {
                    categoryPosition = translatePipe.getValue(idx);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            NumericVector outlierPosition = new NumericVector();
            int outlierCount = 0;
            NumericVector binStartPosition = new NumericVector();
            NumericVector binEndPosition = new NumericVector();
            ColorVector binColor = new ColorVector();
            int binCount = 0;
            String formattedCategory = "";
            if (this.categoryVar != null && !this.categoryVar.isMissing(idx)) {
                formattedCategory = (String)Variable.getValue((Variable)this.categoryVar, (int)idx, (boolean)true);
            }
            StringVector formattedOutlier = new StringVector();
            StringVector formattedBinMidPoint = new StringVector();
            StringVector formattedBinFreq = new StringVector();
            boolean drawMarker = true;
            if (this.binMinVar != null && !this.binMinVar.isMissing(idx)) {
                boolean bl = drawMarker = (Double)Variable.getValue((Variable)this.binMinVar, (int)idx, (boolean)false) == 0.0;
            }
            if (drawMarker) {
                for (j2 = 0; j2 < this.outlierMinVarCount; ++j2) {
                    try {
                        double v = this.outlierMinVars[j2].value.getValue(idx);
                        outlierPosition.addValue(nmY.getValue(v));
                        ++outlierCount;
                        formattedOutlier.addValue(this.analysisFormat.format((Object)v));
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
            } else if (this.binStartMinVar != null && this.binWidthMinVar != null && !this.binStartMinVar.isMissing(idx) && !this.binWidthMinVar.isMissing(idx)) {
                double bStart = (Double)Variable.getValue((Variable)this.binStartMinVar, (int)idx, (boolean)false);
                bWidth = -((Double)Variable.getValue((Variable)this.binWidthMinVar, (int)idx, (boolean)false)).doubleValue();
                for (j = 0; j < this.outlierMinVarCount; ++j) {
                    try {
                        double f = this.outlierMinVars[this.outlierMinVarCount - 1 - j].value.getValue(idx);
                        if (this.includeZeroBins || f > 0.0) {
                            binColor.addValue(heatmapColorMapper.getValue(f));
                            binStartPosition.addValue(nmY.getValue(bStart));
                            binEndPosition.addValue(nmY.getValue(bStart + bWidth));
                            ++binCount;
                            formattedBinFreq.addValue(binFreqFormat.format((Object)f));
                            formattedBinMidPoint.addValue(this.analysisFormat.format((Object)(bStart + 0.5 * bWidth)));
                        }
                    }
                    catch (MissingValueException f) {
                        // empty catch block
                    }
                    bStart += bWidth;
                }
            }
            drawMarker = true;
            if (this.binMaxVar != null && !this.binMaxVar.isMissing(idx)) {
                boolean bl = drawMarker = (Double)Variable.getValue((Variable)this.binMaxVar, (int)idx, (boolean)false) == 0.0;
            }
            if (drawMarker) {
                for (j2 = 0; j2 < this.outlierMaxVarCount; ++j2) {
                    try {
                        double v = this.outlierMaxVars[j2].value.getValue(idx);
                        outlierPosition.addValue(nmY.getValue(v));
                        ++outlierCount;
                        formattedOutlier.addValue(this.analysisFormat.format((Object)v));
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
            } else if (this.binStartMaxVar != null && this.binWidthMaxVar != null && !this.binStartMaxVar.isMissing(idx) && !this.binWidthMaxVar.isMissing(idx)) {
                double bStart = (Double)Variable.getValue((Variable)this.binStartMaxVar, (int)idx, (boolean)false);
                bWidth = (Double)Variable.getValue((Variable)this.binWidthMaxVar, (int)idx, (boolean)false);
                for (j = 0; j < this.outlierMaxVarCount; ++j) {
                    try {
                        double f = this.outlierMaxVars[j].value.getValue(idx);
                        if (this.includeZeroBins || f > 0.0) {
                            binColor.addValue(heatmapColorMapper.getValue(f));
                            binStartPosition.addValue(nmY.getValue(bStart));
                            binEndPosition.addValue(nmY.getValue(bStart + bWidth));
                            ++binCount;
                            formattedBinFreq.addValue(binFreqFormat.format((Object)f));
                            formattedBinMidPoint.addValue(this.analysisFormat.format((Object)(bStart + 0.5 * bWidth)));
                        }
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    bStart += bWidth;
                }
            }
            if (outlierCount > 0) {
                Marker outliers = new Marker();
                outliers.setSVGRender(StatGraph.VGF);
                outliers.weightedEdgeEnabled.setValue(false);
                outliers.edgeWeight.setValue(this.outlierStyle.getWeight());
                if (this.orientation == 0) {
                    outliers.coordX.setValue(categoryPosition);
                    outliers.coordY.connectFrom((NumericPipe)outlierPosition);
                } else {
                    outliers.coordX.connectFrom((NumericPipe)outlierPosition);
                    outliers.coordY.setValue(categoryPosition);
                }
                try {
                    outliers.color.setValue(outlierColorProperty.getValue(idx));
                    outliers.edgeColor.setValue(outlierColorProperty.getValue(idx));
                    outliers.type.setValue(outlierSymbolProperty.getValue(idx));
                    outliers.size.setValue(outlierSizeProperty.getValue(idx));
                    outliers.edgeWidth.setValue(outlierEdgeWidthProperty.getValue(idx));
                }
                catch (MissingValueException v) {
                    // empty catch block
                }
                outliers.setSkinType(this.skinType);
                outliers.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
                outliers.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4));
                outliers.selectEnabled.setValue(this.selectable);
                this.networkRoot.addElement((Element)outliers);
                Probe outlierProbe = new Probe();
                outlierProbe.setTrimOn(true);
                if (this.categoryVar != null) {
                    outlierProbe.addString(this.categoryVar.getLabel(), formattedCategory);
                }
                outlierProbe.addPipe(this.analysisLabel, (Pipe)formattedOutlier);
                outliers.setUserData((Object)outlierProbe);
            }
            if (binCount <= 0) continue;
            Bar bins = new Bar();
            bins.setTwoD(true);
            bins.VGFRenderModeOn.setValue(StatGraph.VGF);
            bins.verticalOn.setValue(this.orientation == 0);
            bins.position.setValue(categoryPosition);
            bins.thickness.setValue(heatmapSize);
            bins.startValue.connectFrom((NumericPipe)binStartPosition);
            bins.endValue.connectFrom((NumericPipe)binEndPosition);
            bins.fillOn.setValue(true);
            bins.edgeOn.setValue(this.heatmapOutlineOn);
            bins.color1.connectFrom((ColorPipe)binColor);
            bins.color2.connectFrom((ColorPipe)binColor);
            bins.edgeColor.setValue(this.applyDataTransparency(this.heatmapOutlineStyle.getColor()));
            bins.edgeWidth.setValue((double)this.heatmapOutlineStyle.getWidth());
            bins.edgePattern.setValue(this.heatmapOutlineStyle.getLinePattern());
            bins.setSkin(this.skinImage);
            bins.setSkinType(this.skinType);
            bins.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            bins.setPixelBenderImages(this.pixelBenderImages);
            bins.selectEnabled.setValue(this.selectable);
            this.networkRoot.addElement((Element)bins);
            Probe outlierProbe = new Probe();
            outlierProbe.setTrimOn(true);
            if (this.categoryVar != null) {
                outlierProbe.addString(this.categoryVar.getLabel(), formattedCategory);
            }
            outlierProbe.addPipe(this.analysisLabel, (Pipe)formattedBinMidPoint);
            outlierProbe.addPipe(RB.getStringResource("Overlay.", "frequency.txt"), (Pipe)formattedBinFreq);
            bins.setUserData((Object)outlierProbe);
        }
    }

    private void loadSkinImage() {
        if (this.dataTransparency == 1.0) {
            this.skinImage = null;
            return;
        }
        if (!this.isFillOn() || this.isExtrudedOverlay()) {
            this.skinType = 0;
        }
        this.skinImage = this.getRectangularSkinImage(this.networkRoot, this.skinType, this.orientation == 0);
        this.pixelBenderImages = this.loadPixelBenderImages(this.networkRoot, this.skinType, this.orientation == 0 ? 1 : 2);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        ValueMap vm;
        double scale = 0.0;
        double outlierMarkerSize = this.outlierStyle.getSize();
        if (this.groupVar != null && this.hasAttrVar("OUTLIERGROUP")) {
            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("OUTLIERGROUP");
            outlierMarkerSize = Math.max(outlierMarkerSize, (double)groupAttrMapper.getMaxMarkerSize());
        }
        double meanMarkerSize = this.meanStyle.getSize();
        if (this.groupVar != null && this.hasAttrVar("TUKEYGROUP")) {
            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP");
            meanMarkerSize = Math.max(meanMarkerSize, (double)groupAttrMapper.getMaxMarkerSize());
        }
        if (dimension == 1) {
            if (this.orientation == 0) {
                vm = this.xEncoder.getValueMap();
                boolean addPadding = true;
                if (vm instanceof StringToNumericMap) {
                    int n = ((StringToNumericMap)vm).getUniqueValueCount();
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        scale = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
                    } else {
                        scale = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                        addPadding = false;
                    }
                } else if (this.intervalBoxWidth >= 0.0 && this.groupVar == null) {
                    scale = this.intervalBoxWidth;
                } else {
                    double intvl = this.getMinimumInterval((short)87);
                    if (intvl == 0.0) {
                        scale = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                        addPadding = false;
                    } else {
                        scale = this.getDefaultIntervalBoxSize(intvl, this.xEncoder, true);
                    }
                }
                double boxSize = scale;
                if (this.groupVar != null) {
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    boxSize = scale / (double)maxGroups;
                }
                double actualBoxSize = boxSize;
                if (this.isAutoBoxSize() && boxSize < 5.0) {
                    actualBoxSize = 5.0;
                } else if (vm instanceof ContinuousRangeToNumericMap && this.intervalBoxWidth > boxSize) {
                    actualBoxSize = this.intervalBoxWidth;
                }
                double markerSize = 0.0;
                if (!this.extreme && this.outlierOn) {
                    markerSize = outlierMarkerSize;
                }
                if (this.meanOn) {
                    markerSize = Math.max(markerSize, meanMarkerSize);
                }
                markerSize *= 1.25;
                markerSize = Math.max(markerSize, actualBoxSize);
                scale += Math.max(0.0, markerSize - boxSize);
                if (addPadding) {
                    scale += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                }
            } else {
                scale = this.extreme || !this.outlierOn ? (!this.isCapOn() ? 0.0 : 2.5 * (double)this.whiskerStyle.getWidth()) : 2.5 * outlierMarkerSize;
            }
        } else if (dimension == 2) {
            if (this.orientation == 0) {
                scale = this.extreme || !this.outlierOn ? (!this.isCapOn() ? 0.0 : 2.5 * (double)this.whiskerStyle.getWidth()) : 2.5 * outlierMarkerSize;
            } else {
                vm = this.yEncoder.getValueMap();
                boolean addPadding = true;
                if (vm instanceof StringToNumericMap) {
                    int n = ((StringToNumericMap)vm).getUniqueValueCount();
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        scale = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                    } else {
                        scale = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                        addPadding = false;
                    }
                } else if (this.intervalBoxWidth >= 0.0 && this.groupVar == null) {
                    scale = this.intervalBoxWidth;
                } else {
                    double intvl = this.getMinimumInterval((short)87);
                    if (intvl == 0.0) {
                        scale = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                        addPadding = false;
                    } else {
                        scale = this.getDefaultIntervalBoxSize(intvl, this.yEncoder, true);
                    }
                }
                double boxSize = scale;
                if (this.groupVar != null) {
                    int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    boxSize = scale / (double)maxGroups;
                }
                double actualBoxSize = boxSize;
                if (this.isAutoBoxSize() && boxSize < 5.0) {
                    actualBoxSize = 5.0;
                } else if (vm instanceof ContinuousRangeToNumericMap && this.intervalBoxWidth > boxSize) {
                    actualBoxSize = this.intervalBoxWidth;
                }
                double markerSize = 0.0;
                if (!this.extreme && this.outlierOn) {
                    markerSize = outlierMarkerSize;
                }
                if (this.meanOn) {
                    markerSize = Math.max(markerSize, meanMarkerSize);
                }
                markerSize *= 1.25;
                markerSize = Math.max(markerSize, actualBoxSize);
                scale += Math.max(0.0, markerSize - boxSize);
                if (addPadding) {
                    scale += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                }
            }
        }
        return scale;
    }

    private boolean isAutoBoxSize() {
        return this.categoryVar != null && this.categoryVar instanceof NumericVariable && this.groupVar != null && this.intervalBoxWidth < 0.0 && !this.userSetBoxWidth;
    }

    private double getDefaultIntervalBoxSize(double minInterval, PositionEncoder encoder, boolean estimate) {
        return this.getMaximumIntervalSize(minInterval, encoder, estimate);
    }

    @Override
    public String[] getGroupValues() {
        if (this.groupVar != null) {
            if (this.groupOrder == 0 || this.groupOrder == 3) {
                return this.getUniqueGroupValues((short)88);
            }
            return this.getUniqueGroupValues((short)88, this.groupOrder == 1 ? 1 : 2);
        }
        return new String[0];
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        if (type == 1 || this.heatmapColorRange == null) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            ContinuousRange range = (ContinuousRange)ce.getInput();
            Color[] colors = ce.rampColors;
            Range[] colorModelRanges = new Range[1];
            RangeBound low = new RangeBound(range.getMin(), true);
            RangeBound high = new RangeBound(range.getMax(), true);
            ColorModel colorModel = new ColorModel(colors);
            colorModelRanges[0] = new Range(low, high, colorModel);
            return colorModelRanges;
        }
        return null;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        return this.heatmapColorRange == null ? null : DataModel.defaultFormat;
    }

    @Override
    public String getDefaultContinuousLegendTitle() {
        return this.heatmapColorRange == null ? null : RB.getStringResource("Overlay.", "frequency.txt");
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        return this.analysisLabel;
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 9: {
                return this.meanOn;
            }
        }
        return false;
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        int[] shape;
        if (this.isLegendEntryFromAttrMap("TUKEYGROUP")) {
            return this.getLegendItemsWithAttrMap("TUKEYGROUP", this.fixDefaultAttrType(attrType));
        }
        if (attrType != 9) {
            return super.getLegendItems(attrType);
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        String[] values = this.getGroupValues();
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.analysisLabel};
        }
        if ((shape = this.getMarkerShapes(values)).length == 0) {
            return null;
        }
        Color[] color = this.getMarkerColors(values);
        int[] size = this.getMarkerWidths(values);
        int[] weight = this.getMarkerWeights(values);
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, this.skinImage, this.skinType, legendPixelBender);
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        if (attrType != 9) {
            return super.getLegendItemsWithAttrMap(attrMapper, attrType);
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = HeatBoxOverlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        int[] shape = this.getMarkerShapes(values);
        if (shape.length == 0) {
            return null;
        }
        if (this.meanOn && this.groupVar != null && !this.useMeanSymbol) {
            shape = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, shape, 0, this.meanStyle.getShape());
        }
        Color[] color = this.getMarkerColors(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanColor) {
            color = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, color, 10, this.meanStyle.getColor(), this.meanStyle.getTransparency(), this.useMeanTransparency);
        }
        int[] size = this.getMarkerWidths(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanSize) {
            size = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, size, 1, this.meanStyle.getSize());
        }
        int[] weight = this.getMarkerWeights(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanWeight) {
            weight = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, weight, 2, this.meanStyle.getWeight());
        }
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null, this.skinImage, this.skinType, legendPixelBender);
        }
        return entries;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return this.fillOn ? 11 : 10;
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return this.fillOn && this.groupVar != null && !this.useFillColor;
            }
            case 11: {
                return this.groupVar != null && !this.useOutlineColor;
            }
            case 3: {
                return this.groupVar != null && this.lineEncoder != null && !this.useOutlinePattern;
            }
            case 4: {
                return !this.useOutlineSize;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return this.fillStyle;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return this.outlineStyle;
    }

    @Override
    public Color[] getFillColors() {
        if (this.fillOn) {
            if (this.groupVar == null || this.useFillColor) {
                return new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
            }
            return this.getGroupColors(true);
        }
        return new Color[0];
    }

    @Override
    public Color[] getLineColors() {
        if (this.groupVar == null || this.useOutlineColor) {
            return new Color[]{this.applyDataTransparency(this.outlineStyle.getColor())};
        }
        return this.getGroupColors(false);
    }

    public Color[] getGroupColors(boolean fill) {
        Color[] colors = new Color[]{};
        if (fill) {
            HashMap ht = this.colorEncoder.colorList;
            String[] values = this.getGroupValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getFillColor(gval)) != null) {
                    colors[i] = this.useFillTransparency ? this.applyDataTransparency(c, this.fillStyle.getTransparency()) : HeatBoxOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(gval));
                }
                if (colors[i] != null) continue;
                colors[i] = (Color)ht.get(gval);
            }
        } else {
            HashMap ht = this.lineColorEncoder.colorList;
            String[] values = this.getGroupValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLineColor(gval)) != null) {
                    colors[i] = this.applyDataTransparency(c);
                }
                if (colors[i] != null) continue;
                colors[i] = (Color)ht.get(gval);
            }
        }
        return colors;
    }

    @Override
    public int[] getLinePatterns() {
        if (this.groupVar == null || this.lineEncoder == null || this.useOutlinePattern) {
            return new int[]{this.outlineStyle.getLinePattern()};
        }
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getGroupValues();
        int[] patterns = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            DiscreteAttrMapper groupAttrMapper;
            int p;
            String gval = values[i];
            patterns[i] = -1;
            if (this.hasAttrVar("TUKEYGROUP") && (p = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLinePattern(gval)) >= 0) {
                patterns[i] = p;
            }
            if (patterns[i] >= 0) continue;
            LineAttrs la = (LineAttrs)ht.get(gval);
            patterns[i] = la.getLinePattern();
        }
        return patterns;
    }

    @Override
    public int[] getLineWidths() {
        if (this.useOutlineSize || !this.hasAttrVar("TUKEYGROUP")) {
            return new int[]{this.outlineStyle.getWidth()};
        }
        return this.getDAttrLineThickness("TUKEYGROUP", this.getGroupValues(), this.outlineStyle.getWidth());
    }

    public Color[] getMarkerColors(String[] values) {
        if (this.meanOn) {
            if (this.groupVar == null || this.useMeanColor) {
                return new Color[]{this.applyDataTransparency(this.meanStyle.getColor(), this.meanStyle.getTransparency())};
            }
            MarkerAttrs ma = new MarkerAttrs();
            ma.setColor(this.meanStyle.getColor());
            ma.setTransparency(this.meanStyle.getTransparency());
            HashMap ht = this.meanColorEncoder.colorList;
            Color[] colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getMarkerColor(gval)) != null) {
                    colors[i] = this.useMeanTransparency ? this.applyDataTransparency(c, this.meanStyle.getTransparency()) : HeatBoxOverlay.applyTransparency(c, groupAttrMapper.getMarkerTransparency(gval));
                }
                if (colors[i] != null) continue;
                colors[i] = (Color)ht.get(gval);
            }
            return colors;
        }
        return new Color[0];
    }

    public int[] getMarkerShapes(String[] values) {
        if (this.meanOn) {
            if (this.groupVar == null || this.useMeanSymbol) {
                return new int[]{this.meanStyle.getShape()};
            }
            HashMap ht = this.shapeEncoder.shapeList;
            int[] shapes = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                String gval = values[i];
                int s = -1;
                if (this.hasAttrVar("TUKEYGROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP");
                    s = groupAttrMapper.getMarkerSymbol(gval);
                }
                if (s < 0) {
                    s = (Integer)ht.get(gval);
                }
                shapes[i] = s;
            }
            return shapes;
        }
        return new int[0];
    }

    public int[] getMarkerWidths(String[] values) {
        if (this.groupVar == null || this.useMeanSize || !this.hasAttrVar("TUKEYGROUP")) {
            int[] ms = new int[]{this.meanStyle.getSize()};
            return ms;
        }
        return this.getDAttrMarkerSize("TUKEYGROUP", values, this.meanStyle.getSize());
    }

    public int[] getMarkerWeights(String[] values) {
        if (this.groupVar == null || this.useMeanWeight || !this.hasAttrVar("TUKEYGROUP")) {
            int[] wt = new int[]{this.meanStyle.getWeight()};
            return wt;
        }
        return this.getDAttrMarkerWeight("TUKEYGROUP", values, this.meanStyle.getWeight());
    }

    @Override
    public boolean isOneDimensional() {
        return this.categoryVar == null;
    }

    @Override
    public boolean isDataOnHorizontalSide() {
        return this.orientation != 0;
    }

    @Override
    public int getPreferredSizeOnDataLessSide() {
        int outlierMarkerSize = this.outlierStyle.getSize();
        if (this.groupVar != null && this.hasAttrVar("OUTLIERGROUP")) {
            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("OUTLIERGROUP");
            outlierMarkerSize = Math.max(outlierMarkerSize, groupAttrMapper.getMaxMarkerSize());
        }
        int meanMarkerSize = this.meanStyle.getSize();
        if (this.groupVar != null && this.hasAttrVar("TUKEYGROUP")) {
            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP");
            meanMarkerSize = Math.max(meanMarkerSize, groupAttrMapper.getMaxMarkerSize());
        }
        int dls = 5 * Math.max(meanMarkerSize, outlierMarkerSize);
        if (this.isOneDimensional()) {
            this.boxWidth = 0.75;
        }
        if (this.groupVar != null) {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            dls *= maxGroups;
        }
        return dls;
    }

    public boolean isConnectSkipMiss() {
        return this.connectSkipMiss;
    }

    public void setConnectSkipMiss(boolean connectSkipMiss) {
        this.connectSkipMiss = connectSkipMiss;
    }
}

