/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public final class FitLineOverlay
extends Overlay {
    public static final String RB_KEY = "FitLineOverlay.";
    protected boolean xInterceptBased = false;
    protected double defaultSlope;
    protected double defaultIntercept;
    protected String curveLabelString = null;
    protected boolean labelInsideHAutomatic = true;
    protected boolean labelInsideVAutomatic = true;
    protected Rectangle clipRect = null;
    protected FontMetrics fm;
    private NetworkRoot networkRoot;
    private DataRange indRange;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private Encoder xEncoder;
    private Encoder yEncoder;
    private LineAttrs lineStyle = new LineAttrs();
    private TextStyle labelStyle = new TextStyle();
    private SASFormat labelFormat = null;
    private boolean useLabelColor = false;
    private double labelPosition = 1.0;
    protected boolean extreme = false;
    protected boolean clipping = false;
    private double xmin = Double.MAX_VALUE;
    private double xmax = -1.7976931348623157E308;
    private double ymin = Double.MAX_VALUE;
    private double ymax = -1.7976931348623157E308;
    public LineSegment line;
    private RasterLabel label;
    private boolean makeLine = true;
    private double trans_x;
    private double trans_y;
    private int curveLabelLocation = 0;
    private String splitCurveLabelString = null;
    public double xValue;
    public double yValue;

    public NetworkRoot getNetworkRoot() {
        return this.networkRoot;
    }

    public int getCurveLabelLocation() {
        return this.curveLabelLocation;
    }

    public void setCurveLabelLocation(int curveLabelLocation) {
        this.curveLabelLocation = curveLabelLocation;
    }

    public FitLineOverlay() {
        this.labelStyle.setHorizontalJustification(0);
        this.labelStyle.setVerticalJustification(0);
    }

    public boolean isLabelInsideHAutomatic() {
        return this.labelInsideHAutomatic;
    }

    public void setLabelInsideHAutomatic(boolean b) {
        this.labelInsideHAutomatic = b;
    }

    public boolean isLabelInsideVAutomatic() {
        return this.labelInsideVAutomatic;
    }

    public void setLabelInsideVAutomatic(boolean b) {
        this.labelInsideVAutomatic = b;
    }

    public void setClipRect(Rectangle r) {
        this.clipRect = r;
    }

    public SASFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(SASFormat lf) {
        this.labelFormat = lf;
    }

    public boolean isExtreme() {
        return this.extreme;
    }

    public void setExtreme(boolean b) {
        this.extreme = b;
    }

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean b) {
        this.clipping = b;
    }

    public boolean isXInterceptBased() {
        return this.xInterceptBased;
    }

    public void setXInterceptBased(boolean b) {
        this.xInterceptBased = b;
    }

    public double getLabelPosition() {
        return this.labelPosition;
    }

    public void setXValue(double x) {
        this.xValue = x;
    }

    public void setYValue(double y) {
        this.yValue = y;
    }

    public void setLabelPosition(double position) {
        this.labelPosition = position;
    }

    public void setUseLabelColor(boolean b) {
        this.useLabelColor = b;
    }

    public boolean isUseLabelColor() {
        return this.useLabelColor;
    }

    protected void updateXRange() {
        if (this.clipping || !this.xInterceptBased && this.defaultSlope == 0.0) {
            return;
        }
        DataRange oldRange = this.xRange;
        this.xRange = this.xInterceptBased ? new ContinuousRange(this.xmin, this.xmax) : this.indRange;
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && this.xRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, this.xRange, dim);
        } else if (oldRange != null && this.xRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != this.xRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, this.xRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        if (this.clipping || this.xInterceptBased && this.defaultSlope == Double.MAX_VALUE) {
            return;
        }
        Object newRange = null;
        DataRange oldRange = this.yRange;
        newRange = this.xInterceptBased ? this.indRange : new ContinuousRange(this.ymin, this.ymax);
        this.yRange = newRange;
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.clipping) {
            return null;
        }
        if (dimension == 1) {
            if (this.xInterceptBased && this.defaultSlope == Double.MAX_VALUE) {
                return new ContinuousRange(this.defaultIntercept, this.defaultIntercept);
            }
            return this.xRange;
        }
        if (dimension == 2) {
            if (!this.xInterceptBased && this.defaultSlope == 0.0) {
                return new ContinuousRange(this.defaultIntercept, this.defaultIntercept);
            }
            return this.yRange;
        }
        return null;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    private void makeLine() {
        if (!this.makeLine) {
            return;
        }
        this.connectVars();
        this.computeCurve();
        this.updateXRange();
        this.updateYRange();
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            this.xEncoder = encoder;
            if (!this.isXInterceptBased()) {
                this.indRange = encoder.getInput();
            }
        }
        if (dimension == 2) {
            this.yEncoder = encoder;
            if (this.isXInterceptBased()) {
                this.indRange = encoder.getInput();
            }
        }
        this.makeLine();
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            if (map instanceof StringToNumericMap) {
                StringToNumericMap stnm = (StringToNumericMap)map;
                ContinuousRangeToNumericMap crnm = new ContinuousRangeToNumericMap();
                crnm.setInputMin(0.0);
                crnm.setInputMax((double)(stnm.getUniqueValueCount() - 1));
                crnm.setOutputMin(0.0);
                crnm.setOutputMax((double)(stnm.getUniqueValueCount() - 1));
                map = crnm;
            } else {
                return false;
            }
        }
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)map;
        if (this.yEncoder == null) {
            return false;
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)map;
        double xMin = xmap.getValue(this.xmin);
        double yMin = ymap.getValue(this.ymin);
        double xMax = xmap.getValue(this.xmax);
        double yMax = ymap.getValue(this.ymax);
        double xCMin = -1.7976931348623157E308;
        double xCMax = Double.MAX_VALUE;
        double yCMin = -1.7976931348623157E308;
        double yCMax = Double.MAX_VALUE;
        if (this.extreme) {
            double xll = ((PositionEncoder)this.xEncoder).getLowerLimit() + (double)this.leftReservedSpace;
            double xul = ((PositionEncoder)this.xEncoder).getUpperLimit() - (double)this.rightReservedSpace;
            double yll = ((PositionEncoder)this.yEncoder).getLowerLimit() + (double)this.bottomReservedSpace;
            double yul = ((PositionEncoder)this.yEncoder).getUpperLimit() - (double)this.topReservedSpace;
            if (xMin == xMax && (this.defaultSlope == 0.0 || this.defaultSlope == Double.MAX_VALUE)) {
                if (this.defaultSlope == 0.0) {
                    xMin = xll;
                    xMax = xul;
                } else if (this.defaultSlope == Double.MAX_VALUE) {
                    if (((PositionEncoder)this.xEncoder).isReversed() && !((PositionEncoder)this.yEncoder).isReversed() || !((PositionEncoder)this.xEncoder).isReversed() && ((PositionEncoder)this.yEncoder).isReversed()) {
                        yMin = yul;
                        yMax = yll;
                    } else {
                        yMin = yll;
                        yMax = yul;
                    }
                }
            } else {
                double k;
                if (xMin == xMax) {
                    if (this.defaultSlope > 0.0) {
                        xMin = xll;
                        xMax = xul;
                        yMin = yll;
                        yMax = yul;
                    } else {
                        xMin = xll;
                        xMax = xul;
                        yMin = yul;
                        yMax = yll;
                    }
                }
                if ((k = (yMax - yMin) / (xMax - xMin)) == 0.0) {
                    xMin = xll;
                    xMax = xul;
                } else {
                    double xMin2 = xll;
                    double yMin2 = yMin + k * (xMin2 - xMin);
                    if (yMin2 < yll) {
                        yMin2 = yll;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    } else if (yMin2 > yul) {
                        yMin2 = yul;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    }
                    double xMax2 = xul;
                    double yMax2 = yMin + k * (xMax2 - xMin);
                    if (yMax2 < yll) {
                        yMax2 = yll;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    } else if (yMax2 > yul) {
                        yMax2 = yul;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    }
                    xMin = xMin2;
                    yMin = yMin2;
                    xMax = xMax2;
                    yMax = yMax2;
                }
            }
        } else {
            double xl = ((PositionEncoder)this.xEncoder).getOutputMin();
            double xu = ((PositionEncoder)this.xEncoder).getOutputMax();
            double yl = ((PositionEncoder)this.yEncoder).getOutputMin();
            double yu = ((PositionEncoder)this.yEncoder).getOutputMax();
            if (xl < xu) {
                xl = Math.max(xl, xCMin);
                xu = Math.min(xu, xCMax);
            } else {
                xl = Math.min(xl, xCMax);
                xu = Math.max(xu, xCMin);
            }
            if (yl < yu) {
                yl = Math.max(yl, yCMin);
                yu = Math.min(yu, yCMax);
            } else {
                yl = Math.min(yl, yCMax);
                yu = Math.max(yu, yCMin);
            }
            if (xMin == xMax && (this.defaultSlope == 0.0 || this.defaultSlope == Double.MAX_VALUE)) {
                if (this.defaultSlope == 0.0) {
                    xMin = xl;
                    xMax = xu;
                } else if (this.defaultSlope == Double.MAX_VALUE) {
                    if (((PositionEncoder)this.xEncoder).isReversed() && !((PositionEncoder)this.yEncoder).isReversed() || !((PositionEncoder)this.xEncoder).isReversed() && ((PositionEncoder)this.yEncoder).isReversed()) {
                        yMin = yu;
                        yMax = yl;
                    } else {
                        yMin = yl;
                        yMax = yu;
                    }
                }
            } else {
                double k;
                if (xMin == xMax) {
                    if (this.defaultSlope > 0.0) {
                        xMin = xl;
                        xMax = xu;
                        yMin = yl;
                        yMax = yu;
                    } else {
                        xMin = xl;
                        xMax = xu;
                        yMin = yu;
                        yMax = yl;
                    }
                }
                if ((k = (yMax - yMin) / (xMax - xMin)) == 0.0) {
                    xMin = xl;
                    xMax = xu;
                } else {
                    double xMin2 = xl;
                    double yMin2 = yMin + k * (xMin2 - xMin);
                    if (yMin2 < yl) {
                        yMin2 = yl;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    } else if (yMin2 > yu) {
                        yMin2 = yu;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    }
                    double xMax2 = xu;
                    double yMax2 = yMin + k * (xMax2 - xMin);
                    if (yMax2 < yl) {
                        yMax2 = yl;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    } else if (yMax2 > yu) {
                        yMax2 = yu;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    }
                    xMin = xMin2;
                    yMin = yMin2;
                    xMax = xMax2;
                    yMax = yMax2;
                }
            }
        }
        this.networkRoot.removeAllElements();
        this.fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        this.line = new LineSegment();
        this.networkRoot.addElement((Element)this.line);
        this.line.setUserData((Object)this.probe);
        this.line.beginX.setValue(xMin);
        this.line.beginY.setValue(yMin);
        this.line.endX.setValue(xMax);
        this.line.endY.setValue(yMax);
        this.line.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        this.line.lineWidth.setValue((double)this.lineStyle.getWidth());
        this.line.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
        if (this.curveLabelString == null || this.curveLabelString.trim().equals("") || this.curveLabelLocation == 1) {
            this.needConnect = false;
            return true;
        }
        this.label = new RasterLabel();
        this.networkRoot.addElement((Element)this.label);
        if (this.splitCurveLabelString != null) {
            this.label.string.setValue(this.splitCurveLabelString);
        } else if (this.labelFormat != null) {
            if (this.labelFormat.isCharacterFormat()) {
                this.label.string.setValue(" " + this.labelFormat.format((Object)this.curveLabelString) + " ");
            } else {
                this.label.string.setValue(" " + this.labelFormat.format((Object)new Double(this.curveLabelString)) + " ");
            }
        } else {
            this.label.string.setValue(" " + this.curveLabelString + " ");
        }
        if (this.useLabelColor) {
            this.label.color.setValue(this.labelStyle.getColor());
        } else {
            this.label.color.setValue(this.lineStyle.getColor());
        }
        this.label.fontName.setValue(this.labelStyle.getFont().getName());
        this.label.fontSize.setValue(this.labelStyle.getFont().getSize());
        this.label.fontStyle.setValue(this.labelStyle.getFont().getStyle());
        if (this.labelInsideHAutomatic || this.labelInsideVAutomatic) {
            double[] m = new double[16];
            this.networkRoot.getChannel().glGetMatrix(m);
            this.trans_x = m[3];
            this.trans_y = m[7];
            double[] d = new double[3];
            if (((PositionEncoder)this.xEncoder).isReversed()) {
                d[0] = xMin + (1.0 - this.labelPosition) * (xMax - xMin);
                d[1] = yMin + (1.0 - this.labelPosition) * (yMax - yMin);
            } else {
                d[0] = xMin + this.labelPosition * (xMax - xMin);
                d[1] = yMin + this.labelPosition * (yMax - yMin);
            }
            d[2] = 0.0;
            double[] d1 = new double[3];
            this.networkRoot.getChannel().gluProject(d, d1);
            FitLineOverlay.computeBestAlignment(this.label.string.getValue(), (int)d1[0], (int)d1[1], this.clipRect, this.fm, this.labelInsideHAutomatic, this.labelInsideVAutomatic, this.labelStyle);
        }
        this.label.horizontalJustification.setValue(this.labelStyle.getHorizontalJustification());
        this.label.verticalJustification.setValue(this.labelStyle.getVerticalJustification());
        if (((PositionEncoder)this.xEncoder).isReversed()) {
            this.label.transform.translateX.setValue(xMin + (1.0 - this.labelPosition) * (xMax - xMin));
            this.label.transform.translateY.setValue(yMin + (1.0 - this.labelPosition) * (yMax - yMin));
        } else {
            this.label.transform.translateX.setValue(xMin + this.labelPosition * (xMax - xMin));
            this.label.transform.translateY.setValue(yMin + this.labelPosition * (yMax - yMin));
        }
        if (this.splitCurveLabelString != null) {
            this.label.transform.translateX.setValue(this.makeSplitLabelXOffset(this.label.transform.translateX.getValue(), this.splitCurveLabelString, this.labelStyle.getHorizontalJustification(), this.curveLabelSplitJustify, this.fm));
            this.label.horizontalJustification.setValue(this.makeSplitLabelHJustification(this.label.horizontalJustification.getValue(), this.curveLabelSplitJustify));
        }
        this.needConnect = false;
        return true;
    }

    static int[] candidates(boolean hAutomatic, boolean vAutomatic, TextStyle style) {
        int[] positions = null;
        if (hAutomatic && vAutomatic) {
            positions = new int[9];
            for (int i = 0; i < 9; ++i) {
                positions[i] = i;
            }
        } else if (hAutomatic) {
            positions = new int[3];
            if (style.getVerticalJustification() == 3) {
                positions[0] = 0;
                positions[1] = 1;
                positions[2] = 5;
            } else if (style.getVerticalJustification() == 0) {
                positions[0] = 2;
                positions[1] = 3;
                positions[2] = 7;
            } else {
                positions[0] = 4;
                positions[1] = 6;
                positions[2] = 8;
            }
        } else if (vAutomatic) {
            positions = new int[3];
            if (style.getHorizontalJustification() == 0) {
                positions[0] = 0;
                positions[1] = 3;
                positions[2] = 4;
            } else if (style.getHorizontalJustification() == 2) {
                positions[0] = 1;
                positions[1] = 2;
                positions[2] = 6;
            } else {
                positions[0] = 5;
                positions[1] = 7;
                positions[2] = 8;
            }
        }
        return positions;
    }

    public static void computeBestAlignment(String label, int x, int y, Rectangle cr, FontMetrics metrics, boolean hAutomatic, boolean vAutomatic, TextStyle style) {
        if (label == null) {
            return;
        }
        int textWidth = FitLineOverlay.getTextWidth(metrics, label);
        int textHeight = FitLineOverlay.getTextDescent(metrics, label) + FitLineOverlay.getTextAscent(metrics, label) + FitLineOverlay.getInterlineSpacing(metrics, label);
        int area = -2147483647;
        int[] pos = FitLineOverlay.candidates(hAutomatic, vAutomatic, style);
        for (int i = 0; i < pos.length; ++i) {
            Rectangle r = FitLineOverlay.calcBBox(x, y, textWidth, textHeight, pos[i]);
            if (cr.contains(r)) {
                FitLineOverlay.updateLabelAlignment(style, pos[i]);
                break;
            }
            if (!cr.intersects(r)) continue;
            Rectangle r1 = cr.intersection(r);
            if (r1.width * r1.height <= area) continue;
            FitLineOverlay.updateLabelAlignment(style, pos[i]);
            area = r1.width * r1.height;
        }
    }

    public static Rectangle calcBBox(int x, int y, int tw, int th, int position) {
        Rectangle bbox = null;
        switch (position) {
            case 0: {
                bbox = new Rectangle(x, y - th, tw, th);
                break;
            }
            case 1: {
                bbox = new Rectangle(x - tw, y - th, tw, th);
                break;
            }
            case 2: {
                bbox = new Rectangle(x - tw, y, tw, th);
                break;
            }
            case 3: {
                bbox = new Rectangle(x, y, tw, th);
                break;
            }
            case 4: {
                bbox = new Rectangle(x, y - th / 2, tw, th);
                break;
            }
            case 5: {
                bbox = new Rectangle(x - tw / 2, y - th, tw, th);
                break;
            }
            case 6: {
                bbox = new Rectangle(x - tw, y - th / 2, tw, th);
                break;
            }
            case 7: {
                bbox = new Rectangle(x - tw / 2, y, tw, th);
                break;
            }
            case 8: {
                bbox = new Rectangle(x - tw / 2, y - th / 2, tw, th);
            }
        }
        return bbox;
    }

    public static void updateLabelAlignment(TextStyle style, int position) {
        switch (position) {
            case 0: {
                style.setHorizontalJustification(0);
                style.setVerticalJustification(3);
                break;
            }
            case 1: {
                style.setHorizontalJustification(2);
                style.setVerticalJustification(3);
                break;
            }
            case 2: {
                style.setHorizontalJustification(2);
                style.setVerticalJustification(0);
                break;
            }
            case 3: {
                style.setHorizontalJustification(0);
                style.setVerticalJustification(0);
                break;
            }
            case 4: {
                style.setHorizontalJustification(0);
                style.setVerticalJustification(1);
                break;
            }
            case 5: {
                style.setHorizontalJustification(1);
                style.setVerticalJustification(3);
                break;
            }
            case 6: {
                style.setHorizontalJustification(2);
                style.setVerticalJustification(1);
                break;
            }
            case 7: {
                style.setHorizontalJustification(1);
                style.setVerticalJustification(0);
                break;
            }
            case 8: {
                style.setHorizontalJustification(1);
                style.setVerticalJustification(1);
            }
        }
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double scale = this.lineStyle.getWidth();
        return 2.0 * scale;
    }

    protected void connectVars() {
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        if (this.defaultSlope != Double.MAX_VALUE) {
            this.probe.addString(RB.getStringResource(RB_KEY, "slope.txt"), DataModel.formatNumber(this.defaultSlope));
        }
        if (this.xInterceptBased) {
            this.probe.addString(RB.getStringResource(RB_KEY, "xint.txt"), DataModel.formatNumber(this.defaultIntercept));
        } else {
            this.probe.addString(RB.getStringResource(RB_KEY, "yint.txt"), DataModel.formatNumber(this.defaultIntercept));
        }
    }

    protected void makeElements() {
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public int getLinePattern() {
        return this.lineStyle.getLinePattern();
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    public void computeCurve() {
        if (this.indRange == null) {
            return;
        }
        if (!this.clipping && this.indRange instanceof ContinuousRange) {
            double min = ((ContinuousRange)this.indRange).getMin();
            double max = ((ContinuousRange)this.indRange).getMax();
            if (this.xInterceptBased && this.defaultSlope != Double.MAX_VALUE) {
                ((ContinuousRange)this.indRange).setMin(Math.min(min, this.yValue));
                ((ContinuousRange)this.indRange).setMax(Math.max(max, this.yValue));
            } else if (!this.xInterceptBased && this.defaultSlope != 0.0) {
                ((ContinuousRange)this.indRange).setMin(Math.min(min, this.xValue));
                ((ContinuousRange)this.indRange).setMax(Math.max(max, this.xValue));
            }
        }
        ContinuousRange cr = new ContinuousRange(this.indRange);
        if (this.xInterceptBased) {
            this.ymin = cr.getMin();
            this.ymax = cr.getMax();
            if (this.defaultSlope == Double.MAX_VALUE) {
                this.xmin = this.defaultIntercept;
                this.xmax = this.defaultIntercept;
            } else if (this.defaultSlope != 0.0) {
                this.xmin = this.defaultIntercept + this.ymin / this.defaultSlope;
                this.xmax = this.defaultIntercept + this.ymax / this.defaultSlope;
            } else {
                this.xmin = this.defaultIntercept;
                this.xmax = this.defaultIntercept;
            }
        } else {
            if (this.indRange instanceof DiscreteRange) {
                DiscreteRange dr = (DiscreteRange)this.indRange;
                this.xmin = 0.0;
                this.xmax = dr.getValuesSize() - 1;
            } else {
                this.xmin = cr.getMin();
                this.xmax = cr.getMax();
            }
            this.ymin = this.defaultIntercept + this.xmin * this.defaultSlope;
            this.ymax = this.defaultIntercept + this.xmax * this.defaultSlope;
        }
        this.makeLine = false;
    }

    public double getDefaultIntercept() {
        return this.defaultIntercept;
    }

    public void setDefaultIntercept(double aDefaultIntercept) {
        this.defaultIntercept = aDefaultIntercept;
        this.makeLine = true;
        this.makeLine();
    }

    public double getDefaultSlope() {
        return this.defaultSlope;
    }

    public void setDefaultSlope(double aDefaultSlope) {
        this.defaultSlope = aDefaultSlope;
        this.makeLine = true;
        this.makeLine();
    }

    protected String getSplitCurveLabelString() {
        return this.splitCurveLabelString;
    }

    protected void setSplitCurveLabelString(String aSplitCurveLabelString) {
        this.splitCurveLabelString = aSplitCurveLabelString;
    }

    public String getCurveLabelString() {
        return this.curveLabelString;
    }

    public void setCurveLabelString(String aCurveLabelString) {
        this.curveLabelString = aCurveLabelString;
        this.splitCurveLabelString = null;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    @Override
    public boolean isComputedOverlay() {
        return true;
    }

    @Override
    public void updateNetworkElements() {
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double xMin = xmap.getValue(this.xmin);
        double yMin = ymap.getValue(this.ymin);
        double xMax = xmap.getValue(this.xmax);
        double yMax = ymap.getValue(this.ymax);
        double xCMin = -1.7976931348623157E308;
        double xCMax = Double.MAX_VALUE;
        double yCMin = -1.7976931348623157E308;
        double yCMax = Double.MAX_VALUE;
        if (this.extreme) {
            double xll = ((PositionEncoder)this.xEncoder).getLowerLimit();
            double xul = ((PositionEncoder)this.xEncoder).getUpperLimit();
            double yll = ((PositionEncoder)this.yEncoder).getLowerLimit();
            double yul = ((PositionEncoder)this.yEncoder).getUpperLimit();
            if (xMin == xMax && (this.defaultSlope == 0.0 || this.defaultSlope == Double.MAX_VALUE)) {
                if (this.defaultSlope == 0.0) {
                    xMin = xll;
                    xMax = xul;
                } else if (this.defaultSlope == Double.MAX_VALUE) {
                    yMin = yll;
                    yMax = yul;
                }
            } else {
                double k;
                if (xMin == xMax) {
                    if (this.defaultSlope > 0.0) {
                        xMin = xll;
                        xMax = xul;
                        yMin = yll;
                        yMax = yul;
                    } else {
                        xMin = xll;
                        xMax = xul;
                        yMin = yul;
                        yMax = yll;
                    }
                }
                if ((k = (yMax - yMin) / (xMax - xMin)) == 0.0) {
                    xMin = xll;
                    xMax = xul;
                } else {
                    double xMin2 = xll;
                    double yMin2 = yMin + k * (xMin2 - xMin);
                    if (yMin2 < yll) {
                        yMin2 = yll;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    } else if (yMin2 > yul) {
                        yMin2 = yul;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    }
                    double xMax2 = xul;
                    double yMax2 = yMin + k * (xMax2 - xMin);
                    if (yMax2 < yll) {
                        yMax2 = yll;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    } else if (yMax2 > yul) {
                        yMax2 = yul;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    }
                    xMin = xMin2;
                    yMin = yMin2;
                    xMax = xMax2;
                    yMax = yMax2;
                }
            }
        } else {
            double xl = ((PositionEncoder)this.xEncoder).getOutputMin();
            double xu = ((PositionEncoder)this.xEncoder).getOutputMax();
            double yl = ((PositionEncoder)this.yEncoder).getOutputMin();
            double yu = ((PositionEncoder)this.yEncoder).getOutputMax();
            if (xl < xu) {
                xl = Math.max(xl, xCMin);
                xu = Math.min(xu, xCMax);
            } else {
                xl = Math.min(xl, xCMax);
                xu = Math.max(xu, xCMin);
            }
            if (yl < yu) {
                yl = Math.max(yl, yCMin);
                yu = Math.min(yu, yCMax);
            } else {
                yl = Math.min(yl, yCMax);
                yu = Math.max(yu, yCMin);
            }
            if (xMin == xMax && (this.defaultSlope == 0.0 || this.defaultSlope == Double.MAX_VALUE)) {
                if (this.defaultSlope == 0.0) {
                    xMin = xl;
                    xMax = xu;
                } else if (this.defaultSlope == Double.MAX_VALUE) {
                    yMin = yl;
                    yMax = yu;
                }
            } else {
                double k;
                if (xMin == xMax) {
                    if (this.defaultSlope > 0.0) {
                        xMin = xl;
                        xMax = xu;
                        yMin = yl;
                        yMax = yu;
                    } else {
                        xMin = xl;
                        xMax = xu;
                        yMin = yu;
                        yMax = yl;
                    }
                }
                if ((k = (yMax - yMin) / (xMax - xMin)) == 0.0) {
                    xMin = xl;
                    xMax = xu;
                } else {
                    double xMin2 = xl;
                    double yMin2 = yMin + k * (xMin2 - xMin);
                    if (yMin2 < yl) {
                        yMin2 = yl;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    } else if (yMin2 > yu) {
                        yMin2 = yu;
                        xMin2 = (yMin2 - yMin) / k + xMin;
                    }
                    double xMax2 = xu;
                    double yMax2 = yMin + k * (xMax2 - xMin);
                    if (yMax2 < yl) {
                        yMax2 = yl;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    } else if (yMax2 > yu) {
                        yMax2 = yu;
                        xMax2 = (yMax2 - yMin) / k + xMin;
                    }
                    xMin = xMin2;
                    yMin = yMin2;
                    xMax = xMax2;
                    yMax = yMax2;
                }
            }
        }
        this.line.beginX.setValue(xMin);
        this.line.beginY.setValue(yMin);
        this.line.endX.setValue(xMax);
        this.line.endY.setValue(yMax);
        if (this.label != null) {
            if (this.labelInsideHAutomatic || this.labelInsideVAutomatic) {
                double[] d = new double[]{xMin + this.labelPosition * (xMax - xMin), yMin + this.labelPosition * (yMax - yMin), 0.0};
                double[] d1 = new double[3];
                this.networkRoot.getChannel().glPushMatrix();
                this.networkRoot.getChannel().glTranslate(this.trans_x, this.trans_y, 0.0);
                this.networkRoot.getChannel().gluProject(d, d1);
                this.networkRoot.getChannel().glPopMatrix();
                FitLineOverlay.computeBestAlignment(this.label.string.getValue(), (int)d1[0], (int)d1[1], this.clipRect, this.fm, this.labelInsideHAutomatic, this.labelInsideVAutomatic, this.labelStyle);
                this.label.horizontalJustification.setValue(this.labelStyle.getHorizontalJustification());
                this.label.verticalJustification.setValue(this.labelStyle.getVerticalJustification());
            }
            this.label.transform.translateX.setValue(xMin + this.labelPosition * (xMax - xMin));
            this.label.transform.translateY.setValue(yMin + this.labelPosition * (yMax - yMin));
        }
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (this.line == null) {
            return;
        }
        double xMin = this.line.beginX.getValue();
        double yMin = (double)yOutputRange - this.line.beginY.getValue();
        double xMax = this.line.endX.getValue();
        double yMax = (double)yOutputRange - this.line.endY.getValue();
        Line2D.Double obstacle = new Line2D.Double(xMin, yMin, xMax, yMax);
        lp.addObstacle(obstacle);
    }
}

