/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.Ellipse;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public final class EllipseOverlay
extends Overlay {
    public static final String RB_KEY = "EllipseOverlay.";
    private NetworkRoot networkRoot;
    private Ellipse ellipse = new Ellipse();
    protected boolean edgeOn = true;
    protected boolean fillOn = false;
    protected boolean fillPatternOn = false;
    protected FillAttrs fillStyle = new FillAttrs();
    protected LineAttrs lineStyle = new LineAttrs();
    protected FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    protected String xLabel = "x";
    protected String yLabel = "y";
    protected double xOrigin = 0.0;
    protected double yOrigin = 0.0;
    protected double xRadius = 1.0;
    protected double yRadius = 1.0;
    protected double slope = Double.NaN;
    protected int maxPoints = 200;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected Encoder xEncoder;
    protected Encoder yEncoder;
    protected boolean clipping = false;
    protected Shape rotatedEllipse = null;

    public boolean isClipping() {
        return this.clipping;
    }

    public void setClipping(boolean b) {
        this.clipping = b;
    }

    protected void updateXRange() {
        if (this.clipping) {
            return;
        }
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        Rectangle2D r = this.rotatedEllipse.getBounds2D();
        double min = r.getMinX();
        double max = r.getMaxX();
        newRange = new ContinuousRange(min, max);
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        if (this.clipping) {
            return;
        }
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        Rectangle2D r = this.rotatedEllipse.getBounds2D();
        double min = r.getMinY();
        double max = r.getMaxY();
        newRange = new ContinuousRange(min, max);
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (this.clipping) {
            return null;
        }
        if (this.xRange == null || this.yRange == null) {
            this.makeEllipse();
        }
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    private void makeRotatedEllipse() {
        if (this.rotatedEllipse == null) {
            double angle = Double.isNaN(this.slope) ? 1.5707963267948966 : Math.atan(this.slope);
            AffineTransform xfm = AffineTransform.getRotateInstance(angle, this.xOrigin, this.yOrigin);
            Ellipse2D.Double e = new Ellipse2D.Double(this.xOrigin - this.xRadius, this.yOrigin - this.yRadius, 2.0 * this.xRadius, 2.0 * this.yRadius);
            this.rotatedEllipse = xfm.createTransformedShape(e);
        }
    }

    boolean isOutOfView() {
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        double xmin = 0.0;
        double xmax = 0.0;
        if (this.xEncoder.getInput() instanceof ContinuousRange) {
            ContinuousRange xr = (ContinuousRange)this.xEncoder.getInput();
            xmin = xr.getMin();
            xmax = xr.getMax();
        } else if (this.xEncoder.getInput() instanceof SimpleBinnedRange) {
            SimpleBinnedRange xsbr = (SimpleBinnedRange)this.xEncoder.getInput();
            xmin = xsbr.getFirstMidpoint() - xsbr.getBinSize() / 2.0;
            xmax = xsbr.getLastMidpoint() + xsbr.getBinSize() / 2.0;
        }
        double ymin = 0.0;
        double ymax = 0.0;
        if (this.yEncoder.getInput() instanceof ContinuousRange) {
            ContinuousRange yr = (ContinuousRange)this.yEncoder.getInput();
            ymin = yr.getMin();
            ymax = yr.getMax();
        } else if (this.yEncoder.getInput() instanceof SimpleBinnedRange) {
            SimpleBinnedRange ysbr = (SimpleBinnedRange)this.yEncoder.getInput();
            ymin = ysbr.getFirstMidpoint() - ysbr.getBinSize() / 2.0;
            ymax = ysbr.getLastMidpoint() + ysbr.getBinSize() / 2.0;
        }
        Rectangle2D.Double view = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        return this.rotatedEllipse.contains(view);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.isOutOfView()) {
            if (this.fillOn && this.xEncoder != null && this.yEncoder != null) {
                PositionEncoder xpe = (PositionEncoder)this.xEncoder;
                PositionEncoder ype = (PositionEncoder)this.yEncoder;
                channel.glColor(this.applyDataTransparency((ColorAttr)this.fillStyle));
                channel.glRect(xpe.getOutputMin(), ype.getOutputMin(), xpe.getOutputMax(), ype.getOutputMax());
            }
            return;
        }
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (!(encoder.getValueMap() instanceof ContinuousRangeToNumericMap)) {
            this.networkRoot = null;
            return;
        }
        if (dimension == 1) {
            this.xEncoder = encoder;
        }
        if (dimension == 2) {
            this.yEncoder = encoder;
        }
        this.makeEllipse();
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
    }

    @Override
    protected boolean connectNetwork() {
        ValueMap xmap = this.xEncoder.getValueMap();
        ValueMap ymap = this.yEncoder.getValueMap();
        this.networkRoot.removeAllElements();
        this.networkRoot.addElement((Element)this.ellipse);
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        this.probe.addString(RB.getStringResource(RB_KEY, "x.txt"), DataModel.formatNumber(this.xOrigin));
        this.probe.addString(RB.getStringResource(RB_KEY, "y.txt"), DataModel.formatNumber(this.yOrigin));
        this.probe.addString(RB.getStringResource(RB_KEY, "width.txt"), DataModel.formatNumber(this.xRadius));
        this.probe.addString(RB.getStringResource(RB_KEY, "height.txt"), DataModel.formatNumber(this.yRadius));
        if (!Double.isNaN(this.slope)) {
            this.probe.addString(RB.getStringResource(RB_KEY, "slope.txt"), DataModel.formatNumber(this.slope));
        } else {
            this.probe.addString(RB.getStringResource(RB_KEY, "slope.txt"), ".");
        }
        this.ellipse.setUserData((Object)this.probe);
        ContinuousRangeToNumericMap crnm = (ContinuousRangeToNumericMap)xmap;
        double xo = crnm.getValue(this.xOrigin);
        double dx = crnm.getValue(this.xOrigin + 1.0) - xo;
        crnm = (ContinuousRangeToNumericMap)ymap;
        double yo = crnm.getValue(this.yOrigin);
        double dy = crnm.getValue(this.yOrigin + 1.0) - yo;
        double angle = Double.isNaN(this.slope) ? 1.5707963267948966 : Math.atan(this.slope);
        ContinuousRangeToNumericMapper xoMapper = new ContinuousRangeToNumericMapper();
        xoMapper.input.setValue(this.xOrigin);
        xoMapper.setMap((ContinuousRangeToNumericMap)xmap);
        ContinuousRangeToNumericMapper dxMapper1 = new ContinuousRangeToNumericMapper();
        dxMapper1.input.setValue(this.xOrigin + 1.0);
        dxMapper1.setMap((ContinuousRangeToNumericMap)xmap);
        Calculator dxMapper = new Calculator("inA-inB");
        dxMapper.inA.connectFrom((NumericPipe)dxMapper1);
        dxMapper.inB.connectFrom((NumericPipe)xoMapper);
        ContinuousRangeToNumericMapper yoMapper = new ContinuousRangeToNumericMapper();
        yoMapper.input.setValue(this.yOrigin);
        yoMapper.setMap((ContinuousRangeToNumericMap)ymap);
        ContinuousRangeToNumericMapper dyMapper1 = new ContinuousRangeToNumericMapper();
        dyMapper1.input.setValue(this.yOrigin + 1.0);
        dyMapper1.setMap((ContinuousRangeToNumericMap)ymap);
        Calculator dyMapper = new Calculator("inA-inB");
        dyMapper.inA.connectFrom((NumericPipe)dyMapper1);
        dyMapper.inB.connectFrom((NumericPipe)yoMapper);
        this.ellipse.transform.translateX.connectFrom((NumericPipe)xoMapper);
        this.ellipse.transform.translateY.connectFrom((NumericPipe)yoMapper);
        this.ellipse.transform.scaleX.connectFrom((NumericPipe)dxMapper);
        this.ellipse.transform.scaleY.connectFrom((NumericPipe)dyMapper);
        this.ellipse.transform.scaleOrientationAngle.setValue(angle);
        this.ellipse.xRadius.setValue(this.xRadius);
        this.ellipse.yRadius.setValue(this.yRadius);
        this.ellipse.angle.setValue(angle);
        this.ellipse.fillOn.setValue(this.fillOn);
        this.ellipse.color.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        this.ellipse.edgeOn.setValue(this.edgeOn);
        this.ellipse.edgeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        this.ellipse.lineWidth.setValue((double)this.lineStyle.getWidth());
        this.ellipse.stipplePattern.setValue((double)this.lineStyle.getStipplePattern());
        this.ellipse.stippleFactor.setValue((double)this.lineStyle.getStippleFactor());
        this.ellipse.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.ellipse.fillPatternOn.setValue(this.fillPatternOn);
        if (this.fillPatternOn) {
            int p = this.fillPatternStyle.getPattern();
            this.ellipse.fillPatternType.setValue(BarOverlay.getGLFillPattern(p));
            this.ellipse.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)p));
            this.ellipse.fillPatternColor.setValue(this.applyDataTransparency(this.fillPatternStyle.getColor()));
            this.ellipse.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        this.needConnect = false;
        return true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double scale = this.lineStyle.getWidth();
        if (dimension == 1) {
            return scale;
        }
        if (dimension == 2) {
            return scale;
        }
        return 0.0;
    }

    protected void connectVars() {
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public int getLinePattern() {
        return this.lineStyle.getLinePattern();
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    public void setXLabel(String label) {
        this.xLabel = label;
    }

    public void setYLabel(String label) {
        this.yLabel = label;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public void setMaxPoints(int aInt) {
        this.maxPoints = aInt;
    }

    private void makeEllipse() {
        this.makeRotatedEllipse();
        this.updateXRange();
        this.updateYRange();
    }

    public void setXOrigin(double origin) {
        this.xOrigin = origin;
    }

    public void setYOrigin(double origin) {
        this.yOrigin = origin;
    }

    public void setXRadius(double radius) {
        this.xRadius = radius;
    }

    public void setYRadius(double radius) {
        this.yRadius = radius;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public double getXOrigin() {
        return this.xOrigin;
    }

    public double getYOrigin() {
        return this.yOrigin;
    }

    public double getXRadius() {
        return this.xRadius;
    }

    public double getYRadius() {
        return this.yRadius;
    }

    public double getSlope() {
        return this.slope;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean b) {
        this.edgeOn = b;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public void setFillPatternStyle(FillPatternAttrs fps) {
        this.fillPatternStyle = fps;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        if (dimension == 1) {
            return this.xEncoder;
        }
        if (dimension == 2) {
            return this.yEncoder;
        }
        return null;
    }

    @Override
    public boolean isComputedOverlay() {
        return true;
    }

    @Override
    public void addObstacles(LabelPlacementInterface lp, PointLabelLayout l, int yOutputRange) {
        if (this.ellipse == null) {
            return;
        }
        double xo = this.ellipse.transform.translateX.getValue();
        double yo = (double)yOutputRange - this.ellipse.transform.translateY.getValue();
        double sx = this.ellipse.transform.scaleX.getValue();
        double sy = this.ellipse.transform.scaleY.getValue();
        double alpha = this.ellipse.angle.getValue();
        Ellipse2D.Double e2d = new Ellipse2D.Double(-this.xRadius / 2.0, -this.yRadius / 2.0, this.xRadius, this.yRadius);
        AffineTransform at = AffineTransform.getTranslateInstance(xo, yo);
        at.concatenate(AffineTransform.getScaleInstance(sx, sy));
        at.concatenate(AffineTransform.getRotateInstance(alpha));
        lp.addObstacle(at.createTransformedShape(e2d));
    }
}

