/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.RPFUtil;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.MapIDCompositePipe;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.ESRIGeometryService;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.OLAPMapGeometryProvider;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapRegionLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.ui.CHTagLoader;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.CategorizationAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.attrmap.CategorizationAttributeMap;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.graphics.util.categorization.Categorizor;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.render.map.MapObject;
import com.sas.graphics.util.gtk.render.map.RESTEsriMapRegionLayer;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetInterface;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ESRIMapRegionLayerOverlay
extends MapRegionLayerOverlay {
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange responseRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    private Variable responseVar;
    private Variable colorGroupVar;
    private MapObject mapObject = new MapObject();
    private NetworkRoot networkRoot;
    private ArrayList<WKBMultiPolygon> polygonList;
    private Vector<String> idVector;
    private HashMap<Object, Double> colorGroupValues;
    private ArrayList<Double> colorValues;
    private ArrayList<String> legendValues;
    private Color[] legendColors;
    private Rectangle2D.Double bounds;
    private Proxy proxy = null;
    private String spatialReference = null;

    public double getMapXMin() {
        return this.bounds.getMinX();
    }

    public double getMapXMax() {
        return this.bounds.getMaxX();
    }

    public double getMapYMin() {
        return this.bounds.getMinY();
    }

    public double getMapYMax() {
        return this.bounds.getMaxY();
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
            case 4: {
                this.updateResponseRange();
                return this.responseRange;
            }
        }
        return null;
    }

    private ContinuousRange getResponseRange() {
        double max;
        double min;
        if (!this.model.isAvailable(2)) {
            return null;
        }
        if (this.model.getOLAPData() == null) {
            min = this.model.getColumnMin((short)2);
            max = this.model.getColumnMax((short)2);
        } else {
            if (this.colorValues == null || this.colorValues.size() == 0) {
                return new ContinuousRange(-1.7976931348623157E308, Double.MAX_VALUE);
            }
            min = this.colorValues.get(0);
            max = this.colorValues.get(this.colorValues.size() - 1);
        }
        return new ContinuousRange(min, max);
    }

    private DiscreteRange getColorGroupRange() {
        if (!this.model.isAvailable(107)) {
            return null;
        }
        DiscreteRange newRange = null;
        if (this.model.getOLAPData() == null) {
            Variable colorVar = this.connectRaw((short)107);
            if (colorVar != null) {
                boolean numericVar = this.model.getColumnClass(107) == Double.class;
                int num = colorVar.getUniqueValueCount();
                Object[] vals = new Object[num];
                if (numericVar) {
                    for (int i = 0; i < num; ++i) {
                        try {
                            vals[i] = ((NumericVariable)colorVar).uniqueValue.getValue(i);
                            continue;
                        }
                        catch (Exception mve) {
                            vals[i] = "";
                        }
                    }
                } else {
                    for (int i = 0; i < num; ++i) {
                        try {
                            vals[i] = ((StringVariable)colorVar).uniqueValue.getValue(i);
                            continue;
                        }
                        catch (Exception mve) {
                            vals[i] = "";
                        }
                    }
                }
                newRange = new DiscreteRange(vals);
                newRange.setLabel(colorVar.getLabel());
            }
        } else {
            CRD crd = this.model;
            OLAPDataSetInterface olapData = crd.getOLAPData();
            OLAPVariableFactory fac = null;
            try {
                fac = new OLAPVariableFactory((ResultSetInterface)olapData);
            }
            catch (OLAPException ex) {
                return null;
            }
            NumericVariable colorVar = StatGraph.getOLAPMeasureVar(crd, (short)107);
            Object[] myRange = this.colorGroupValues.values().toArray(new Double[0]);
            Arrays.sort(myRange);
            newRange = new DiscreteRange(myRange);
            newRange.setLabel(colorVar.getLabel());
        }
        return newRange;
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.colorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
            if (this.model.isAvailable(2)) {
                Color[] ramp = new Color[]{this.colorEncoder.startColor, this.colorEncoder.mediumColor, this.colorEncoder.endColor};
                this.mapObject.setRampColors(ramp);
                ContinuousRange rRange = this.getResponseRange();
                double min = rRange.getMin();
                double max = rRange.getMax();
                double neutral = (min + max) / 2.0;
                double[] rampval = new double[]{min, neutral, max};
                this.mapObject.setRampValues(rampval);
                this.mapObject.setDiscrete(false);
            } else if (this.model.isAvailable(107)) {
                int i;
                Variable colorVar;
                if (!(encoder instanceof ColorEncoder)) {
                    return;
                }
                this.colorEncoder = (ColorEncoder)encoder;
                this.mapObject.setRampColors(this.colorEncoder.colorArray);
                this.mapObject.setCategorized(false);
                Object[] objectVals = null;
                Object[] formattedVals = null;
                this.legendValues = new ArrayList();
                this.legendColors = this.colorEncoder.colorArray;
                boolean numericVar = false;
                if (this.model.getOLAPData() == null) {
                    colorVar = this.connectRaw((short)107);
                    numericVar = this.model.getColumnClass(107) == Double.class;
                    int num = colorVar.getUniqueValueCount();
                    if (numericVar) {
                        objectVals = new Double[num];
                        formattedVals = new String[num];
                        for (i = 0; i < num; ++i) {
                            try {
                                objectVals[i] = ((NumericVariable)colorVar).uniqueValue.getValue(i);
                                formattedVals[i] = ((NumericVariable)colorVar).formattedUniqueValue.getValue(i);
                                continue;
                            }
                            catch (Exception mve) {
                                objectVals[i] = Double.NaN;
                                formattedVals[i] = "";
                            }
                        }
                    } else {
                        objectVals = new String[num];
                        formattedVals = new String[num];
                        for (i = 0; i < num; ++i) {
                            try {
                                objectVals[i] = ((StringVariable)colorVar).uniqueValue.getValue(i);
                                formattedVals[i] = ((StringVariable)colorVar).uniqueValue.getValue(i);
                                continue;
                            }
                            catch (Exception mve) {
                                objectVals[i] = "";
                                formattedVals[i] = "";
                            }
                        }
                    }
                } else {
                    CRD crd = this.model;
                    OLAPDataSetInterface olapData = crd.getOLAPData();
                    OLAPVariableFactory fac = null;
                    try {
                        fac = new OLAPVariableFactory((ResultSetInterface)olapData);
                    }
                    catch (OLAPException ex) {
                        return;
                    }
                    colorVar = StatGraph.getOLAPMeasureVar(crd, (short)107);
                    objectVals = this.colorGroupValues.values().toArray(new Double[0]);
                    formattedVals = this.colorGroupValues.keySet().toArray(new String[0]);
                    numericVar = true;
                }
                if (numericVar) {
                    AttrMapper am = this.getAttrVarMapper("COLORGROUP");
                    if (am != null && am instanceof CategorizationAttrMapper) {
                        int i2;
                        CategorizationAttributeMap cam = ((CategorizationAttrMapper)am).getAttrMap();
                        Object[] newVals = null;
                        if (cam.getType().equals("NATURAL_BREAKS")) {
                            newVals = Categorizor.getNaturalBreaksRanges((Double[])((Double[])objectVals), (int)cam.getNumLevels());
                        } else if (cam.getType().equals("EQUAL_INTERVAL")) {
                            newVals = Categorizor.getNaturalBreaksRanges((Double[])((Double[])objectVals), (int)cam.getNumLevels());
                        } else if (cam.getType().equals("QUANTILE")) {
                            newVals = Categorizor.getQuantileRanges((Double[])((Double[])objectVals), (int)cam.getNumLevels());
                        } else {
                            newVals = (Double[])objectVals;
                            Arrays.sort(newVals);
                        }
                        this.mapObject.setCategorized(true);
                        this.mapObject.setDiscrete(false);
                        if (cam.getPalette().equalsIgnoreCase("RAMP")) {
                            Color color1 = this.colorEncoder.startColor;
                            Color color2 = this.colorEncoder.endColor;
                            Color[] myNewColorArray = new Color[newVals.length];
                            for (i2 = 0; i2 < myNewColorArray.length; ++i2) {
                                float red = (float)color1.getRed() + (float)i2 / ((float)myNewColorArray.length - 1.0f) * (float)(color2.getRed() - color1.getRed());
                                float green = (float)color1.getGreen() + (float)i2 / ((float)myNewColorArray.length - 1.0f) * (float)(color2.getGreen() - color1.getGreen());
                                float blue = (float)color1.getBlue() + (float)i2 / ((float)myNewColorArray.length - 1.0f) * (float)(color2.getBlue() - color1.getBlue());
                                float alpha = (float)color1.getAlpha() + (float)i2 / ((float)myNewColorArray.length - 1.0f) * (float)(color2.getAlpha() - color1.getAlpha());
                                myNewColorArray[i2] = new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f);
                            }
                            this.legendColors = myNewColorArray;
                            this.mapObject.setRampColors(myNewColorArray);
                        } else {
                            this.mapObject.setRampColors(this.colorEncoder.colorArray);
                        }
                        GTKFormat format = colorVar.getFormat();
                        double[] tempVals = new double[newVals.length];
                        boolean discrete = cam.getType().equals("UNIQUE");
                        for (i2 = 0; i2 < tempVals.length; ++i2) {
                            tempVals[i2] = (Double)newVals[i2];
                            if (discrete) {
                                this.legendValues.add(format.format(newVals[i2]).trim());
                                continue;
                            }
                            if (i2 == 0) continue;
                            this.legendValues.add(format.format(newVals[i2 - 1]).trim() + " - " + format.format(newVals[i2]).trim());
                        }
                        this.mapObject.setRampValues(tempVals);
                    } else {
                        for (i = 0; i < formattedVals.length; ++i) {
                            this.legendValues.add(formattedVals[i]);
                        }
                        this.mapObject.setCategorized(false);
                        this.mapObject.setDiscrete(true);
                        this.mapObject.setDiscreteColors(this.colorEncoder.colorArray);
                        this.mapObject.setDiscreteValues(formattedVals);
                    }
                } else {
                    this.mapObject.setDiscrete(true);
                    this.mapObject.setDiscreteColors(this.colorEncoder.colorArray);
                    this.mapObject.setDiscreteValues(objectVals);
                    for (int i3 = 0; i3 < objectVals.length; ++i3) {
                        this.legendValues.add(objectVals[i3].toString());
                    }
                }
            }
        }
        this.needConnect = true;
    }

    protected void connectVars() {
        StringVariable v;
        if (this.model.getOLAPData() != null) {
            this.connectOLAPVars();
            return;
        }
        MapIDCompositePipe cat = new MapIDCompositePipe();
        CRD crd = this.model;
        if (crd.isAvailable(600)) {
            cat = new MapIDCompositePipe();
            int cnt = 0;
            while (crd.isAvailable(600 + cnt)) {
                int r = 600 + cnt;
                v = (StringVariable)this.connectCategory((short)r, true);
                cat.addInput((Pipe)v.value);
                ++cnt;
            }
            StringVectorVariable sv = new StringVectorVariable();
            sv.connectFrom(cat.value);
            this.mapObject.setResponseStringIDVariable((StringVariable)sv);
        }
        this.regenerateMapContents();
        StringVectorVariable svv = new StringVectorVariable();
        svv.connectFrom(this.idVector);
        this.mapObject.setMapStringIDVariable((StringVariable)svv);
        this.mapObject.setMultiPolygons(this.polygonList);
        this.mapObject.reCache();
        if (crd.isAvailable(2)) {
            this.responseVar = this.connectRaw((short)2);
            this.mapObject.setColorVariable((NumericVariable)this.responseVar);
        } else {
            this.responseVar = null;
        }
        if (crd.isAvailable(107)) {
            boolean numericVar;
            this.colorGroupVar = this.connectRaw((short)107);
            boolean bl = numericVar = this.model.getColumnClass(107) == Double.class;
            if (numericVar) {
                this.mapObject.setColorVariable((NumericVariable)this.colorGroupVar);
            } else {
                this.mapObject.setColorStringVariable((StringVariable)this.colorGroupVar);
            }
            v = (CategorizationAttrMapper)this.getAttrVarMapper("COLORGROUP");
        } else {
            this.colorGroupVar = null;
        }
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), this.mapObject.getVariableProcessor(), -1));
        if (this.isConditionalHilited()) {
            for (int i = 0; i < this.getNumCHPipes(); ++i) {
                BooleanVector bv = this.getCHPipe(i);
                Image tag = CHTagLoader.get(i + 1, true, this.mapObject.getChannel().getComponent());
                this.mapObject.addConditionalHighlighting(bv.value, tag);
            }
        }
    }

    protected void connectOLAPVars() {
        CRD crd = this.model;
        OLAPDataSetInterface olapData = crd.getOLAPData();
        OLAPVariableFactory fac = null;
        try {
            fac = new OLAPVariableFactory((ResultSetInterface)olapData);
        }
        catch (OLAPException ex) {
            return;
        }
        if (crd.isAvailable(600)) {
            StringVariable sv = StatGraph.getOLAPLevelVar(fac, crd.getColumnName((short)600));
            this.mapObject.setResponseStringIDVariable(sv);
        }
        this.regenerateMapContents();
        StringVectorVariable svv = new StringVectorVariable();
        svv.connectFrom(this.idVector);
        this.mapObject.setMapStringIDVariable((StringVariable)svv);
        this.mapObject.setMultiPolygons(this.polygonList);
        this.mapObject.reCache();
        if (crd.isAvailable(2)) {
            this.responseVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
            this.mapObject.setColorVariable((NumericVariable)this.responseVar);
        } else {
            this.responseVar = null;
        }
        if (crd.isAvailable(107)) {
            boolean numericVar;
            this.colorGroupVar = StatGraph.getOLAPMeasureVar(crd, (short)107);
            boolean bl = numericVar = this.model.getColumnClass(107) == Double.class;
            if (numericVar) {
                this.mapObject.setColorVariable((NumericVariable)this.colorGroupVar);
            } else {
                this.mapObject.setColorStringVariable((StringVariable)this.colorGroupVar);
            }
        } else {
            this.colorGroupVar = null;
        }
        this.addCHPipe(RPFUtil.applyConditionalHiliting(this.model.getSrcModel(), this.mapObject.getVariableProcessor(), -1));
        if (this.isConditionalHilited()) {
            for (int i = 0; i < this.getNumCHPipes(); ++i) {
                BooleanVector bv = this.getCHPipe(i);
                Image tag = CHTagLoader.get(i + 1, true, this.mapObject.getChannel().getComponent());
                this.mapObject.addConditionalHighlighting(bv.value, tag);
            }
        }
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        newRange = new ContinuousRange(this.getMapXMin(), this.getMapXMax());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        newRange = new ContinuousRange(this.getMapYMin(), this.getMapYMax());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    protected void updateResponseRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.responseRange;
        if (this.model.isAvailable(2)) {
            newRange = this.getResponseRange();
        } else if (this.model.isAvailable(107)) {
            newRange = this.getColorGroupRange();
        } else {
            return;
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.responseRange = newRange;
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        RangeAttrMapper mapper;
        String error;
        if (type == 1) {
            return null;
        }
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce == null || !(ce.getInput() instanceof ContinuousRange)) {
            return null;
        }
        ContinuousRange range = (ContinuousRange)ce.getInput();
        if (this.hasAttrVar("COLORRESPONSE") && (error = (mapper = (RangeAttrMapper)this.getAttrVarMapper("COLORRESPONSE")).createColorMapper(range.getMin(), range.getMax())) == null) {
            return mapper.getRangeColorMapper().getFullRanges(this.dataTransparency);
        }
        Color[] colors = new Color[]{ce.startColor, ce.mediumColor, ce.endColor};
        Range[] colorModelRanges = new Range[1];
        RangeBound low = new RangeBound(range.getMin(), true);
        RangeBound high = new RangeBound(range.getMax(), true);
        ColorModel colorModel = new ColorModel(colors);
        colorModelRanges[0] = new Range(low, high, colorModel);
        return colorModelRanges;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        ColorEncoder ce = (ColorEncoder)this.getEncoder((byte)4);
        if (ce != null && ce.getInput() instanceof ContinuousRange) {
            return ce.getInput().getFormat();
        }
        return null;
    }

    @Override
    public void draw(Graphics g) {
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double x1in = xmap.getInputMin();
        double x2in = xmap.getInputMax();
        double x1out = xmap.getOutputMin();
        double x2out = xmap.getOutputMax();
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double y1in = ymap.getInputMin();
        double y2in = ymap.getInputMax();
        double y1out = ymap.getOutputMin();
        double y2out = ymap.getOutputMax();
        double win = x2in - x1in;
        double hin = y2in - y1in;
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        Channel channel = this.networkRoot.getChannel();
        channel.glPushAttrib(0);
        channel.glEdgeFlag(true);
        channel.glPushMatrix();
        channel.glTranslate(x1out, y1out, 0.0);
        channel.glScale(wout / win, hout / hin, 0.0);
        channel.glTranslate(-x1in, -y1in, 0.0);
        channel.setClip(g.getClipBounds());
        this.mapObject.draw();
        channel.glPopMatrix();
        channel.glPopAttrib();
    }

    @Override
    public void setChannel(Channel channel) {
        this.mapObject.setChannel(channel);
        this.networkRoot = new NetworkRoot(channel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateResponseRange();
    }

    public void regenerateMapContents() {
        try {
            this.regenerateMapPolygons();
            this.bounds = RESTEsriMapRegionLayer.getBoundsFromWKBPolygons(this.polygonList);
            this.generateLeafBoolean();
            this.updateXRange();
            this.updateYRange();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void regenerateMapPolygons() throws IOException {
        this.polygonList = new ArrayList();
        this.idVector = new Vector();
        HashMap<String, String> hash = this.getFullResponseHash();
        if (this.mapProvider instanceof ESRIGeometryService) {
            RESTEsriMapRegionLayer.getMapPolygons((String)((ESRIGeometryService)this.mapProvider).getUrl(), (String)((ESRIGeometryService)this.mapProvider).getFieldName(), (String)((ESRIGeometryService)this.mapProvider).getLayerName(), null, (StringVariable)this.mapObject.getResponseStringIDVariable(), this.polygonList, this.idVector, hash, (String)this.spatialReference, (Proxy)this.proxy);
        } else if (this.mapProvider instanceof OLAPMapGeometryProvider && this.mapObject.getResponseStringIDVariable() instanceof OLAPLevelVariable) {
            List levelNames = ((OLAPLevelVariable)this.mapObject.getResponseStringIDVariable()).getLevelNames();
            for (int i = 0; i < levelNames.size(); ++i) {
                ESRIGeometryService egs = (ESRIGeometryService)((OLAPMapGeometryProvider)this.mapProvider).getMapGeometryProvider((String)levelNames.get(i));
                RESTEsriMapRegionLayer.getMapPolygons((String)egs.getUrl(), (String)egs.getFieldName(), (String)egs.getLayerName(), (String)((String)levelNames.get(i)), (StringVariable)this.mapObject.getResponseStringIDVariable(), this.polygonList, this.idVector, hash, (String)this.spatialReference, (Proxy)this.proxy);
            }
        }
    }

    private HashMap<String, String> getFullResponseHash() {
        HashMap<String, String> hash = new HashMap<String, String>();
        StringVariable sv = this.mapObject.getResponseStringIDVariable();
        int numValues = sv.getValueCount();
        for (int i = 0; i < numValues; ++i) {
            String s2 = (String)Variable.getValue((Variable)sv, (int)i, (boolean)true);
            String s1 = sv instanceof OLAPLevelVariable ? ((OLAPLevelVariable)sv).getLowestLevelLabel(i) : s2;
            hash.put(s1, s2);
        }
        return hash;
    }

    public MapObject getMapObject() {
        return this.mapObject;
    }

    private void generateLeafBoolean() {
        CRD crd = this.model;
        OLAPDataSetInterface olapData = crd.getOLAPData();
        if (olapData == null) {
            return;
        }
        OLAPVariableFactory fac = null;
        try {
            fac = new OLAPVariableFactory((ResultSetInterface)olapData);
        }
        catch (OLAPException ex) {
            return;
        }
        StringVariable idVar = StatGraph.getOLAPLevelVar(fac, crd.getColumnName((short)600));
        NumericVariable colorVar = StatGraph.getOLAPMeasureVar(crd, (short)2);
        NumericVariable colorGroupVar = StatGraph.getOLAPMeasureVar(crd, (short)107);
        if (!(idVar instanceof OLAPLevelVariable)) {
            return;
        }
        List levelNames = ((OLAPLevelVariable)idVar).getLevelNames();
        String lastLevelName = (String)levelNames.get(levelNames.size() - 1);
        int numValues = idVar.getValueCount();
        this.colorValues = new ArrayList();
        this.colorGroupValues = new HashMap();
        double[] bv = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            String l = ((OLAPLevelVariable)idVar).getLevelName(i);
            if (lastLevelName == l) {
                bv[i] = 1.0;
                if (colorVar != null) {
                    this.colorValues.add((Double)Variable.getValue((Variable)((OLAPMeasureVariable)colorVar), (int)i, (boolean)false));
                }
                if (colorGroupVar == null) continue;
                this.colorGroupValues.put(Variable.getValue((Variable)((OLAPMeasureVariable)colorGroupVar), (int)i, (boolean)true), (Double)Variable.getValue((Variable)((OLAPMeasureVariable)colorGroupVar), (int)i, (boolean)false));
                continue;
            }
            bv[i] = 0.0;
        }
        Collections.sort(this.colorValues);
        NumericVectorVariable nnv = new NumericVectorVariable();
        nnv.connectFrom(bv);
        this.mapObject.setUseChoroColorVariable((NumericVariable)nnv);
        this.mapObject.setDefaultColor(Color.lightGray);
    }

    @Override
    public void setModel(CRD model) {
        super.setModel(model);
        CRD crd = model;
        OLAPDataSetInterface olapData = crd.getOLAPData();
        if (olapData == null) {
            return;
        }
        OLAPVariableFactory fac = null;
        try {
            fac = new OLAPVariableFactory((ResultSetInterface)olapData);
        }
        catch (OLAPException ex) {
            return;
        }
        this.generateLeafBoolean();
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        if (this.colorEncoder == null) {
            return null;
        }
        String[] values = null;
        int n = 0;
        values = this.legendValues.toArray(new String[0]);
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        Color[] fcolor = this.legendColors;
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        n = values.length;
        LegendItem[] entries = new LegendItem[n];
        if (fcolor == null) {
            fcolor = this.getFillColors();
        }
        if (fcolor.length == 0 && this.colorEncoder.getInput() instanceof ContinuousRange) {
            fcolor = new Color[]{this.colorEncoder.startColor};
        }
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            attr.setColor(fcolor[i % fcolor.length]);
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null);
        }
        return entries;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getSpatialReference() {
        return this.spatialReference;
    }

    public void setSpatialReference(String spatialReference) {
        this.spatialReference = spatialReference;
    }
}

