/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.ESRIMapService;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.render.map.RESTEsriMapLayer;
import com.sas.graphics.util.gtk.render.map.RESTEsriUtil;
import com.sas.text.SASFormat;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.Proxy;

public class ESRIMapLayerOverlay
extends MapLayerOverlay {
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected DataRange responseRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    private NetworkRoot networkRoot;
    private Image image;
    private double xMin = -1.7976931348623157E308;
    private double xMax = Double.MAX_VALUE;
    private double yMin = -1.7976931348623157E308;
    private double yMax = Double.MAX_VALUE;
    private Proxy proxy = null;

    public double getMapXMin() {
        return this.xMin;
    }

    public double getMapXMax() {
        return this.xMax;
    }

    public double getMapYMin() {
        return this.yMin;
    }

    public double getMapYMax() {
        return this.yMax;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        return null;
    }

    public String getSpatialReference() {
        String urlString = ((ESRIMapService)this.mapProvider).getUrl();
        return RESTEsriUtil.getSpatialReference((String)urlString, (Proxy)this.proxy);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        }
        if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        }
        this.needConnect = true;
    }

    protected void connectVars() {
    }

    protected void updateXRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.xRange;
        newRange = new ContinuousRange(this.getMapXMin(), this.getMapXMax());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        ContinuousRange newRange = null;
        DataRange oldRange = this.yRange;
        newRange = new ContinuousRange(this.getMapYMin(), this.getMapYMax());
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
            case 4: {
                return this.colorEncoder;
            }
        }
        return null;
    }

    @Override
    public Range[] getColorModelRanges(int type) {
        return null;
    }

    @Override
    public SASFormat getContinuousLegendFormat() {
        return null;
    }

    @Override
    public void draw(Graphics g) {
        try {
            this.getImage();
            ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
            double x1in = xmap.getInputMin();
            double x2in = xmap.getInputMax();
            double x1out = xmap.getOutputMin();
            double x2out = xmap.getOutputMax();
            ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
            double y1in = ymap.getInputMin();
            double y2in = ymap.getInputMax();
            double y1out = ymap.getOutputMin();
            double y2out = ymap.getOutputMax();
            double win = x2in - x1in;
            double hin = y2in - y1in;
            double wout = x2out - x1out - 1.0;
            double hout = y2out - y1out - 1.0;
            Channel channel = this.networkRoot.getChannel();
            channel.glPushAttrib(0);
            channel.glEdgeFlag(true);
            channel.glPushMatrix();
            channel.glTranslate(x1out, y1out, 0.0);
            channel.glScale(wout / win, hout / hin, 0.0);
            channel.glTranslate(-x1in, -y1in, 0.0);
            channel.setClip(g.getClipBounds());
            channel.Image2D(this.image, x1in, y2in, 0.0, this.image.getWidth(null), this.image.getHeight(null));
            channel.glPopMatrix();
            channel.glPopAttrib();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    public Rectangle2D.Double getMapBounds(Rectangle2D.Double bounds, int xSize, int ySize) {
        if (xSize == 0 || ySize == 0) {
            return null;
        }
        String urlString = ((ESRIMapService)this.mapProvider).getUrl();
        return RESTEsriMapLayer.getMapBounds((String)urlString, (Rectangle2D.Double)bounds, (int)xSize, (int)ySize, (Proxy)this.proxy);
    }

    private void getImage() throws IOException {
        String urlString = ((ESRIMapService)this.mapProvider).getUrl();
        ContinuousRangeToNumericMap xmap = (ContinuousRangeToNumericMap)this.xEncoder.getValueMap();
        double x1in = xmap.getInputMin();
        double x2in = xmap.getInputMax();
        double x1out = xmap.getOutputMin();
        double x2out = xmap.getOutputMax();
        ContinuousRangeToNumericMap ymap = (ContinuousRangeToNumericMap)this.yEncoder.getValueMap();
        double y1in = ymap.getInputMin();
        double y2in = ymap.getInputMax();
        double y1out = ymap.getOutputMin();
        double y2out = ymap.getOutputMax();
        double wout = x2out - x1out - 1.0;
        double hout = y2out - y1out - 1.0;
        this.image = RESTEsriMapLayer.getImage((String)urlString, (Rectangle2D.Double)new Rectangle2D.Double(x1in, y1in, x2in - x1in, y2in - y1in), (int)((int)wout), (int)((int)hout), (Proxy)this.proxy);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

