/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import java.awt.Color;
import java.awt.Graphics;
import java.text.DecimalFormat;

public class DistCurveOverlay
extends Overlay {
    public static final byte FIRST_DIST = 1;
    public static final byte BETA = 1;
    public static final byte EXPONENTIAL = 2;
    public static final byte GAMMA = 3;
    public static final byte KERNEL = 4;
    public static final byte LOGNORMAL = 5;
    public static final byte NORMAL = 6;
    public static final byte WEIBULL = 7;
    public static final byte LAST_DIST = 7;
    protected byte type = (byte)6;
    protected int orientation = 0;
    public static final byte VERTICAL = 0;
    public static final byte HORIZONTAL = 1;
    protected double[] indValues;
    protected double[] depValues;
    protected DataRange indRange;
    protected String depLabel;
    protected double binSize;
    protected double defaultAlpha;
    protected double defaultBeta;
    protected double defaultC;
    protected double defaultMu;
    protected double defaultSigma;
    protected double defaultTheta;
    protected double defaultZeta;
    protected double alphaValue;
    protected double betaValue;
    protected double cValue;
    protected double muValue;
    protected double sigmaValue;
    protected double thetaValue;
    protected double zetaValue;
    private NetworkRoot networkRoot;
    private LineConnector connector = new LineConnector();
    private NumericMapper xvalueMapper;
    private NumericMapper yvalueMapper;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private Encoder xEncoder;
    private Encoder yEncoder;
    private LineAttrs lineStyle = new LineAttrs();
    protected NumericVectorVariable alphaVar;
    protected NumericVectorVariable betaVar;
    protected NumericVectorVariable cVar;
    protected NumericVectorVariable muVar;
    protected NumericVectorVariable sigmaVar;
    protected NumericVectorVariable thetaVar;
    protected NumericVectorVariable zetaVar;
    protected NumericVectorVariable indVar;
    protected NumericVectorVariable depVar;
    protected DecimalFormat defaultFormat;

    public byte getType() {
        return this.type;
    }

    public void setType(byte aType) {
        this.type = aType;
    }

    public void setOrientation(byte o) {
        this.orientation = o;
    }

    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        newRange = this.orientation == 0 ? this.updateIndRange() : this.updateDepRange();
        this.xRange = newRange;
        byte dim = 1;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        newRange = this.orientation == 0 ? this.updateDepRange() : this.updateIndRange();
        this.yRange = newRange;
        byte dim = 2;
        RangeChangedEvent rce = null;
        if (oldRange == null && newRange != null) {
            rce = new RangeChangedEvent((Object)this, 1, newRange, dim);
        } else if (oldRange != null && newRange == null) {
            rce = new RangeChangedEvent((Object)this, 2, oldRange, dim);
        } else if (oldRange != newRange) {
            rce = new RangeChangedEvent((Object)this, 3, oldRange, dim, newRange);
        }
        if (rce != null) {
            this.rcList.rangeChanged(rce);
        }
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            this.xEncoder = encoder;
        }
        if (dimension == 2) {
            this.yEncoder = encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.computeCurve();
        this.updateXRange();
        this.updateYRange();
    }

    @Override
    protected boolean connectNetwork() {
        if (this.indVar == null || this.depVar == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        ValueMap map = this.xEncoder.getValueMap();
        double strideX = 0.0;
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.xvalueMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        if (this.yEncoder == null) {
            return false;
        }
        map = this.yEncoder.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        this.yvalueMapper = new ContinuousRangeToNumericMapper();
        ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        if (this.orientation == 0) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(this.indVar.value);
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(this.depVar.value);
        } else {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(this.depVar.value);
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(this.indVar.value);
        }
        this.networkRoot.removeAllElements();
        this.networkRoot.addElement((Element)this.connector);
        this.connector.setUserData((Object)this.probe);
        this.connector.pointX.connectFrom((NumericPipe)this.xvalueMapper);
        this.connector.pointY.connectFrom((NumericPipe)this.yvalueMapper);
        this.connector.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
        this.connector.lineWidth.setValue((double)this.lineStyle.getWidth());
        this.connector.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
        this.needConnect = false;
        return true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double scale = this.lineStyle.getWidth();
        if (dimension == 1) {
            return scale;
        }
        if (dimension == 2) {
            return scale;
        }
        return 0.0;
    }

    protected void connectVars() {
        CRD crd = this.model;
        this.alphaVar = null;
        this.betaVar = null;
        this.cVar = null;
        this.muVar = null;
        if (crd != null && crd.isAvailable(103)) {
            if (crd.getColumnClass(103) != Double.class) {
                StatGraph.printDebug("VBar : MU must be numeric");
            } else {
                this.muVar = (NumericVectorVariable)this.connectRaw((short)103);
            }
        }
        this.sigmaVar = null;
        if (crd != null && crd.isAvailable(104)) {
            if (crd.getColumnClass(104) != Double.class) {
                StatGraph.printDebug("VBar : SIGMA must be numeric");
            } else {
                this.sigmaVar = (NumericVectorVariable)this.connectRaw((short)104);
            }
        }
        this.thetaVar = null;
        if (crd != null && crd.isAvailable(105)) {
            if (crd.getColumnClass(105) != Double.class) {
                StatGraph.printDebug("VBar : THETA must be numeric");
            } else {
                this.thetaVar = (NumericVectorVariable)this.connectRaw((short)105);
            }
        }
        this.zetaVar = null;
        this.alphaValue = this.defaultAlpha;
        if (this.alphaVar != null) {
            try {
                this.alphaValue = this.alphaVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.betaValue = this.defaultBeta;
        if (this.betaVar != null) {
            try {
                this.betaValue = this.betaVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.cValue = this.defaultC;
        if (this.cVar != null) {
            try {
                this.cValue = this.cVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.muValue = this.defaultMu;
        if (this.muVar != null) {
            try {
                this.muValue = this.muVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.sigmaValue = this.defaultSigma;
        if (this.sigmaVar != null) {
            try {
                this.sigmaValue = this.sigmaVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.thetaValue = this.defaultTheta;
        if (this.thetaVar != null) {
            try {
                this.thetaValue = this.thetaVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.zetaValue = this.defaultZeta;
        if (this.zetaVar != null) {
            try {
                this.zetaValue = this.zetaVar.value.getValue(0);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        String tString = "?";
        switch (this.type) {
            case 6: {
                tString = "Normal";
            }
        }
        this.probe.addString("Type", tString);
        if (this.defaultFormat == null) {
            this.defaultFormat = new DecimalFormat();
        }
        switch (this.type) {
            case 6: {
                this.probe.addString("Mean", "" + this.defaultFormat.format(this.muValue));
                this.probe.addString("Standard Deviation", "" + this.defaultFormat.format(this.sigmaValue));
            }
        }
    }

    protected void makeElements() {
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public Color getLineColor() {
        return this.lineStyle.getColor();
    }

    public int getLinePattern() {
        return this.lineStyle.getLinePattern();
    }

    public void setLineStyle(LineAttrs style) {
        this.lineStyle = style;
    }

    protected DataRange updateIndRange() {
        if (this.indVar != null) {
            double min = this.indVar.getMin();
            double max = this.indVar.getMax();
            ContinuousRange cr = new ContinuousRange(min, max);
            cr.setLabel(this.indRange.getLabel());
            return cr;
        }
        return null;
    }

    protected DataRange updateDepRange() {
        if (this.depVar != null) {
            double min = this.depVar.getMin();
            double max = this.depVar.getMax();
            ContinuousRange cr = new ContinuousRange(min, max);
            cr.setLabel(this.depLabel);
            return cr;
        }
        return null;
    }

    public void computeCurve() {
        this.depVar = null;
        this.indVar = null;
        if (this.indRange == null) {
            return;
        }
        int numPoints = 100;
        ContinuousRange cr = new ContinuousRange(this.indRange);
        this.indValues = new double[numPoints];
        double min = cr.getMin();
        double max = cr.getMax();
        for (int i = 0; i < numPoints; ++i) {
            this.indValues[i] = min + (max - min) * (double)i / (double)(numPoints - 1);
        }
        this.indVar = new NumericVectorVariable();
        this.indVar.connectFrom(this.indValues);
        double h = this.binSize;
        this.depValues = new double[numPoints];
        this.depVar = new NumericVectorVariable();
        this.depVar.connectFrom(this.depValues);
        switch (this.type) {
            case 6: {
                double fac = 100.0 * h / (this.sigmaValue * Math.sqrt(Math.PI * 2));
                for (int i = 0; i < numPoints; ++i) {
                    double norm;
                    double exp = -Math.pow(this.indValues[i] - this.muValue, 2.0) / (2.0 * this.sigmaValue * this.sigmaValue);
                    this.depValues[i] = norm = fac * Math.exp(exp);
                }
                break;
            }
        }
    }

    public DataRange getIndRange() {
        return this.indRange;
    }

    public void setIndRange(DataRange aIndRange) {
        DataRange oldIR = this.indRange;
        this.indRange = aIndRange;
        if (this.indRange == null && oldIR != null || this.indRange != null && oldIR == null || !this.indRange.equals((Object)oldIR)) {
            this.computeCurve();
            this.updateXRange();
            this.updateYRange();
        }
    }

    public String getDepLabel() {
        return this.depLabel;
    }

    public void setDepLabel(String aDepLabel) {
        this.depLabel = aDepLabel;
    }

    public double getBinSize() {
        return this.binSize;
    }

    public void setBinSize(double aBinSize) {
        this.binSize = aBinSize;
    }

    public double getDefaultAlpha() {
        return this.defaultAlpha;
    }

    public void setDefaultAlpha(double aDefaultAlpha) {
        this.defaultAlpha = aDefaultAlpha;
    }

    public double getDefaultBeta() {
        return this.defaultBeta;
    }

    public void setDefaultBeta(double aDefaultBeta) {
        this.defaultBeta = aDefaultBeta;
    }

    public double getDefaultC() {
        return this.defaultC;
    }

    public void setDefaultC(double aDefaultC) {
        this.defaultC = aDefaultC;
    }

    public double getDefaultMu() {
        return this.defaultMu;
    }

    public void setDefaultMu(double aDefaultMu) {
        this.defaultMu = aDefaultMu;
        this.connectVars();
        this.computeCurve();
        this.updateXRange();
        this.updateYRange();
    }

    public double getDefaultSigma() {
        return this.defaultSigma;
    }

    public void setDefaultSigma(double aDefaultSigma) {
        this.defaultSigma = aDefaultSigma;
        this.connectVars();
        this.computeCurve();
        this.updateXRange();
        this.updateYRange();
    }

    public double getDefaultTheta() {
        return this.defaultTheta;
    }

    public void setDefaultTheta(double aDefaultTheta) {
        this.defaultTheta = aDefaultTheta;
    }

    public double getDefaultZeta() {
        return this.defaultZeta;
    }

    public void setDefaultZeta(double aDefaultZeta) {
        this.defaultZeta = aDefaultZeta;
    }
}

