/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericToColorMapper;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Graphics;
import java.text.Format;
import java.util.HashMap;

public class CarpetOverlay
extends Overlay {
    protected LineAttrs xLineStyle = new LineAttrs();
    protected LineAttrs yLineStyle = new LineAttrs();
    protected int lineLength = 10;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder lineColorEncoder;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericLineColor = false;
    private Variable xvalueVar;
    private Variable yvalueVar;
    private Variable lineColorVar;
    private Variable cIndexVar;
    private Variable rawGroupVar;
    private NetworkRoot networkRoot;
    private NumericMapper xvalueMapper;
    private NumericMapper yvalueMapper;
    private LineSegment xLines = new LineSegment();
    private LineSegment yLines = new LineSegment();
    private ColorProperty lineColor = new ColorProperty();

    public LineAttrs getXLineStyle() {
        return this.xLineStyle;
    }

    public LineAttrs getYLineStyle() {
        return this.yLineStyle;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public Color getXLineColor() {
        return this.xLineStyle.getColor();
    }

    public int getXLinePattern() {
        return this.xLineStyle.getLinePattern();
    }

    public Color getYLineColor() {
        return this.yLineStyle.getColor();
    }

    public int getYLinePattern() {
        return this.yLineStyle.getLinePattern();
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.xvalueVar.getValueCount() : this.xvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : Overlay.makeDiscreteRange((StringVariable)this.xvalueVar, num);
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    protected void updateYRange() {
        Object newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num;
            int n = num = this.numericY ? this.yvalueVar.getValueCount() : this.yvalueVar.getUniqueValueCount();
            if (num > 0) {
                newRange = this.numericY ? this.makeContinuousRange((NumericVariable)this.yvalueVar, (short)11, !this.yUnionAllPages) : Overlay.makeDiscreteRange((StringVariable)this.yvalueVar, num);
                newRange.setLabel(this.yvalueVar.getLabel());
            } else {
                newRange = null;
            }
        }
        this.setFormat((DataRange)newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
            case 2: {
                return this.yRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xvalueVar == null || this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.yEncoder == null) {
            return false;
        }
        ValueMap map = null;
        if (this.xvalueVar != null && this.xEncoder != null) {
            map = this.xEncoder.getValueMap();
            if (this.numericX) {
                if (!(map instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                    this.xvalueMapper = new ContinuousRangeToNumericMapper();
                }
                if (this.xEncoder instanceof BrokenPositionEncoder) {
                    ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)this.xEncoder).getBrokenValueMap());
                } else {
                    ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
                }
            } else {
                if (!(map instanceof StringToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                    this.xvalueMapper = new StringToNumericMapper();
                }
                ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
            }
        } else {
            this.xvalueMapper = null;
        }
        if (this.yvalueVar != null && this.yEncoder != null) {
            map = this.yEncoder.getValueMap();
            double strideY = 0.0;
            if (this.numericY) {
                if (!(map instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                    this.yvalueMapper = new ContinuousRangeToNumericMapper();
                }
                ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            } else {
                if (!(map instanceof StringToNumericMap)) {
                    return false;
                }
                if (!(this.yvalueMapper instanceof StringToNumericMapper)) {
                    this.yvalueMapper = new StringToNumericMapper();
                }
                ((StringToNumericMapper)this.yvalueMapper).setMap((StringToNumericMap)map);
            }
        } else {
            this.yvalueMapper = null;
        }
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.yEncoder != null && (format = this.yEncoder.getInput().getFormat()) != null && this.yvalueVar != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        if (this.yvalueMapper != null) {
            if (this.numericY) {
                ((ContinuousRangeToNumericMapper)this.yvalueMapper).input.connectFrom(((NumericVariable)this.yvalueVar).value);
            } else {
                ((StringToNumericMapper)this.yvalueMapper).input.connectFrom(((StringVariable)this.yvalueVar).value);
            }
        }
        NumericToColorMapper lineColorMapper = null;
        DiscreteAttrMapper lcAttrMapper = null;
        if (this.lineColorVar != null && this.lineColorEncoder != null) {
            HashMap lcht = this.lineColorEncoder.colorList;
            Color[] lcl = this.lineColorEncoder.colorArray;
            if (this.numericLineColor) {
                lineColorMapper = new NumericToColorMapper();
                lineColorMapper.input.connectFrom(((NumericVariable)this.lineColorVar).value);
                lineColorMapper.setReplaceMissingValues(true);
            } else {
                lineColorMapper = new StringToColorMapper();
                ((StringToColorMapper)lineColorMapper).input.connectFrom(((StringVariable)this.lineColorVar).value);
                ((StringToColorMapper)lineColorMapper).setReplaceMissingValues(true);
            }
            for (int i = 0; i < this.lineColorVar.getUniqueValueCount(); ++i) {
                Color c;
                block57: {
                    if (this.cIndexVar == null) {
                        try {
                            String lcval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i);
                            c = (Color)lcht.get(lcval);
                        }
                        catch (MissingValueException e) {
                            if (this.xvalueMapper != null) {
                                c = this.applyDataTransparency(this.xLineStyle.getColor());
                                break block57;
                            }
                            c = this.applyDataTransparency(this.yLineStyle.getColor());
                        }
                    } else {
                        int obs = ((StringVariable)this.lineColorVar).getFirstOccurringValueIndex(i);
                        try {
                            int idx = (int)((NumericVariable)this.cIndexVar).value.getValue(obs) - 1;
                            c = this.applyDataTransparency(lcl[idx % lcl.length]);
                        }
                        catch (MissingValueException e) {
                            c = this.xvalueMapper != null ? this.applyDataTransparency(this.xLineStyle.getColor()) : this.applyDataTransparency(this.yLineStyle.getColor());
                        }
                    }
                }
                if (this.numericLineColor) {
                    try {
                        double gval = ((NumericVariable)this.lineColorVar).uniqueValue.getValue(i);
                        lineColorMapper.add(gval, c);
                    }
                    catch (MissingValueException e) {
                        lineColorMapper.setMissingReplacement(c, e.getMissingValue());
                    }
                    continue;
                }
                try {
                    String gval = ((StringVariable)this.lineColorVar).uniqueValue.getValue(i);
                    ((StringToColorMapper)lineColorMapper).add(gval, c);
                    continue;
                }
                catch (MissingValueException e) {
                    ((StringToColorMapper)lineColorMapper).setMissingReplacement(c, e.getMissingValue());
                }
            }
            if (this.hasAttrVar("GROUP")) {
                lcAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
                lcAttrMapper.setLineTransparency(this.dataTransparency);
                lcAttrMapper.variable = this.numericLineColor ? ((NumericVectorVariable)this.lineColorVar).formattedValue : ((StringVectorVariable)this.lineColorVar).formattedValue;
                lcAttrMapper.lineColorMapper = lineColorMapper;
                int lt = this.xvalueMapper != null ? this.xLineStyle.getWidth() : this.yLineStyle.getWidth();
                lcAttrMapper.addLineThicknessPipe("line", lt);
            }
        }
        if (this.lineColorVar != null && lineColorMapper != null) {
            if (lcAttrMapper != null) {
                this.lineColor.connectFrom((ColorPipe)lcAttrMapper.lineColor);
            } else {
                this.lineColor.connectFrom(lineColorMapper);
            }
        } else {
            this.lineColor.setValue(this.applyDataTransparency(this.xLineStyle.getColor()));
        }
        this.networkRoot.removeAllElements();
        int ll = (int)Math.round((double)this.lineLength * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor);
        if (this.xvalueMapper != null) {
            double base = this.yEncoder.getLowerLimit();
            this.xLines.beginX.connectFrom((NumericPipe)this.xvalueMapper);
            this.xLines.endX.connectFrom((NumericPipe)this.xvalueMapper);
            this.xLines.beginY.setValue(base);
            this.xLines.endY.setValue(base + (double)ll);
            this.xLines.color.connectFrom((ColorPipe)this.lineColor);
            if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
                this.xLines.lineWidth.setValue((double)this.xLineStyle.getWidth());
            } else {
                this.xLines.lineWidth.connectFrom((IntegerPipe)lcAttrMapper.lineThickness.get("line"));
            }
            this.xLines.setStipple(this.xLineStyle.getStipplePattern(), this.xLineStyle.getStippleFactor());
            if (this.xLineStyle.getWidth() > 0) {
                this.networkRoot.addElement((Element)this.xLines);
                this.xLines.setUserData((Object)this.probe);
            }
        }
        if (this.yvalueMapper != null) {
            double base = this.xEncoder.getLowerLimit();
            this.yLines.beginX.setValue(base);
            this.yLines.endX.setValue(base + (double)ll);
            this.yLines.beginY.connectFrom((NumericPipe)this.yvalueMapper);
            this.yLines.endY.connectFrom((NumericPipe)this.yvalueMapper);
            this.yLines.color.setValue(this.applyDataTransparency(this.yLineStyle.getColor()));
            if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
                this.yLines.lineWidth.setValue((double)this.yLineStyle.getWidth());
            } else {
                this.yLines.lineWidth.connectFrom((IntegerPipe)lcAttrMapper.lineThickness.get("line"));
            }
            this.yLines.setStipple(this.yLineStyle.getStipplePattern(), this.yLineStyle.getStippleFactor());
            if (this.yLineStyle.getWidth() > 0) {
                this.networkRoot.addElement((Element)this.yLines);
                this.yLines.setUserData((Object)this.probe);
            }
        }
        this.needConnect = false;
        return true;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        double xlw = this.xLineStyle.getWidth();
        xlw = (int)xlw * 2 - 1;
        if (!this.useLineThickness && this.hasAttrVar("GROUP")) {
            DiscreteAttrMapper attrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("GROUP");
            xlw = Math.max(xlw, (double)attrMapper.getMaxLineThickness());
        }
        double ylw = this.yLineStyle.getWidth();
        ylw = (int)ylw * 2 - 1;
        if (dimension == 1) {
            return xlw;
        }
        if (dimension == 2) {
            return 0.0;
        }
        return 0.0;
    }

    protected void connectVars() {
        CRD crd = this.model;
        if (crd.isAvailable(10)) {
            this.numericX = crd.getColumnClass(10) == Double.class;
            this.xvalueVar = this.connectRaw((short)10);
        } else {
            this.xvalueVar = null;
        }
        if (crd.isAvailable(11)) {
            this.numericY = crd.getColumnClass(11) == Double.class;
            this.yvalueVar = this.connectRaw((short)11);
        } else {
            this.yvalueVar = null;
        }
        if (crd.isAvailable(46)) {
            this.rawGroupVar = this.connectRaw((short)46);
            this.lineColorVar = this.connectCategory((short)46, true);
            this.numericLineColor = false;
        } else {
            this.rawGroupVar = null;
            this.lineColorVar = null;
        }
        this.cIndexVar = crd.isAvailable(41) ? this.connectRaw((short)41) : null;
        VariableProcessor vp = null;
        if (crd.whereExpression != null || this.rawGroupVar != null && (!this.missingGroupOn || this.groupOrder == 1 || this.groupOrder == 2)) {
            vp = new VariableProcessor();
            this.addVarToVP(vp, this.xvalueVar);
            this.addVarToVP(vp, this.yvalueVar);
            this.addVarToVP(vp, this.lineColorVar);
            this.addVarToVP(vp, this.cIndexVar);
            this.addVarToVP(vp, this.rawGroupVar);
            if (this.rawGroupVar != null && !this.missingGroupOn) {
                vp.setWhereExpression("^(" + this.rawGroupVar.getName() + " IS MISSING)");
                this.whereRoles = new int[]{46};
            }
            if (this.rawGroupVar != null) {
                if (this.groupOrder == 1) {
                    this.rawGroupVar.setUniqueValueSort(1);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.rawGroupVar, 1);
                    }
                } else if (this.groupOrder == 2) {
                    this.rawGroupVar.setUniqueValueSort(2);
                    if (this.isDrawByGroupOrder()) {
                        vp.setSort(this.rawGroupVar, 2);
                    }
                }
                this.rawGroupVar.setSortByFormattedValues(this.rawGroupVar instanceof StringVariable);
            }
            this.addCRDWhereClause(vp);
        }
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (crd.isAvailable(300)) {
            this.addCustomTips(vp);
        } else {
            this.addTooltip(vp, "X");
            this.addTooltip(vp, "Y");
            this.addTooltip(vp, "GROUP");
        }
    }

    protected void makeElements() {
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    public void setLineLength(int length) {
        this.lineLength = length;
    }

    public void setXLineStyle(LineAttrs style) {
        this.xLineStyle = style;
    }

    public void setYLineStyle(LineAttrs style) {
        this.yLineStyle = style;
    }

    @Override
    public int[] getLinePatterns() {
        return new int[]{this.xLineStyle.getLinePattern()};
    }

    @Override
    public int[] getLineWidths() {
        if (this.useLineThickness || !this.hasAttrVar("GROUP")) {
            return new int[]{this.xLineStyle.getWidth()};
        }
        return this.getDAttrLineThickness("GROUP", this.getGroupValues(), this.xLineStyle.getWidth());
    }

    private Color[] getGroupColors() {
        DiscreteAttrMapper groupAttrMapper = this.hasAttrVar("GROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("GROUP") : null;
        StringVariable colorV = null;
        HashMap ht = null;
        Color[] cl = null;
        String[] values = null;
        LineAttrs defaultAttr = null;
        colorV = (StringVariable)this.connectCategory((short)46, true);
        ht = this.lineColorEncoder.colorList;
        cl = this.lineColorEncoder.colorArray;
        values = this.groupOrder == 1 || this.groupOrder == 2 ? this.getUniqueValues((short)46, this.groupOrder == 1 ? 1 : 2) : this.getUniqueValues((short)46);
        defaultAttr = this.xvalueMapper != null ? this.xLineStyle : this.yLineStyle;
        NumericVectorVariable indexV = this.cIndexVar == null ? null : (NumericVectorVariable)this.connectRaw((short)41);
        Color[] colors = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            Color c;
            String gval = values[i];
            if (groupAttrMapper != null && (c = groupAttrMapper.getLineColor(gval)) != null) {
                colors[i] = this.applyDataTransparency(c, defaultAttr.getTransparency());
            }
            if (colors[i] != null) continue;
            if (indexV == null) {
                colors[i] = (Color)ht.get(gval);
                continue;
            }
            int obs = colorV.getFirstOccurringValueIndex(i);
            try {
                int idx = (int)indexV.value.getValue(obs) - 1;
                colors[i] = this.applyDataTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
                continue;
            }
            catch (MissingValueException e) {
                colors[i] = this.applyDataTransparency((ColorAttr)defaultAttr);
            }
        }
        return colors;
    }

    @Override
    public Color[] getLineColors() {
        if (this.lineColorEncoder == null) {
            if (this.xvalueVar != null) {
                return new Color[]{this.applyDataTransparency(this.xLineStyle.getColor())};
            }
            return new Color[]{this.applyDataTransparency(this.yLineStyle.getColor())};
        }
        return this.getGroupColors();
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(10);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    public boolean isOneDimensional() {
        return true;
    }

    @Override
    public boolean isDataOnHorizontalSide() {
        return true;
    }

    @Override
    public int getPreferredSizeOnDataLessSide() {
        return this.getLineLength();
    }

    @Override
    public String[] getGroupValues() {
        if (this.model.isAvailable(3)) {
            if (this.groupOrder == 1 || this.groupOrder == 2) {
                return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
            }
            return this.getUniqueGroupValues((short)3);
        }
        return new String[0];
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return 10;
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        String[] values = this.getGroupValues();
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            LineAttrs attr = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr = new LineAttrs();
                attr.setColor(lcolor[i % lcolor.length]);
                attr.setLinePattern(pattern[i % pattern.length]);
                attr.setWidth(width[i % width.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, null, this.skinType, false);
        }
        if (this.isLegendEntryFromAttrMap("GROUP")) {
            entries = CarpetOverlay.margeAttrMapWithPlotLegendItems((DiscreteAttrMapper)this.getAttrVarMapper("GROUP"), entries, null, this.xvalueVar != null ? this.xLineStyle : this.yLineStyle, true, this.useFillTransparency, false, true, this.useLineThickness, this.dataTransparency, this.useDataTransparency);
        }
        return entries;
    }
}

