/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.JitteredContinuousRangeToNumericMapper;
import com.sas.graphics.applets.statgraph.sgchart.gtk.JitteredStringToNumericMapper;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.OutlierLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericPipedFormat;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringPipedFormat;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumberMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.TukeyBox;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class BoxOverlay
extends Overlay {
    public static final String RB_KEY = "BoxOverlay.";
    public static final int VERTICAL = 0;
    public static final int CONNECT_NONE = 0;
    public static final int CONNECT_MIN = 1;
    public static final int CONNECT_Q1 = 2;
    public static final int CONNECT_MEDIAN = 3;
    public static final int CONNECT_Q3 = 4;
    public static final int CONNECT_MAX = 5;
    public static final int CONNECT_MEAN = 6;
    protected DataRange xRange = null;
    protected DataRange yRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    protected ColorEncoder colorEncoder;
    protected ColorEncoder lineColorEncoder;
    protected ColorEncoder meanColorEncoder;
    protected ColorEncoder outlierColorEncoder;
    protected LineEncoder lineEncoder;
    protected ShapeEncoder shapeEncoder;
    protected FillPatternEncoder fillPatternEncoder;
    protected ColorEncoder fillPatternColorEncoder;
    private boolean numericX = true;
    private boolean numericY = true;
    private boolean numericL = true;
    private Variable xvalueVar;
    private Variable yvalueVar;
    private Variable labelVar;
    private Variable groupVar;
    private Variable indexVar;
    private Variable urlVar;
    private Variable tukeyYVar;
    private Variable tukeyXVar;
    private Variable outlierYVar;
    private Variable outlierXVar;
    private Variable outlierGVar;
    private Variable missingValueControlVar;
    private NumericVectorVariable numericXVar;
    private StringVariable stringGroupVar;
    private double[] tukeyY;
    private boolean[] graphed;
    private double[] extremeMin;
    private double[] extremeMax;
    private double[] boxWidthScale;
    private double[] dataMin;
    private double[] dataMax;
    private double[] sumWgt;
    private StringVector labels;
    private StringVector allLabels;
    private NumericVector refValues;
    private Probe outlierProbe;
    private NetworkRoot networkRoot;
    protected NumericMapper xvalueMapper;
    protected NumericMapper yvalueMapper;
    public boolean selectable = true;
    private double boxScale = 0.4;
    private double intervalBoxWidth = -1.0;
    private static final double INTERVAL_BOX_SCALE = 0.85;
    private boolean userSetBoxScale = false;
    private boolean boxWidthFromData = false;
    NumericVector minWhisker = new NumericVector();
    NumericVector quartile1 = new NumericVector();
    NumericVector median = new NumericVector();
    NumericVector quartile3 = new NumericVector();
    NumericVector maxWhisker = new NumericVector();
    NumericVector mean = new NumericVector();
    StringVector nob = new StringVector();
    NumericVector std = new NumericVector();
    NumericVector sumWgtPipe = new NumericVector();
    NumericVector dataMinPipe = new NumericVector();
    NumericVector dataMaxPipe = new NumericVector();
    StringVector tukeyURL = null;
    StringVector outlierURL = null;
    StringVector xPipe = new StringVector();
    StringVectorVariable tukeyGroupVar = new StringVectorVariable();
    private boolean extreme = false;
    private boolean notched = false;
    private int capShape = 1;
    private LineAttrs capStyle = new LineAttrs(1);
    private boolean capOn = true;
    private Color medianColor = Color.black;
    private int medianSymbol = -1;
    private int medianSize = 1;
    private LineAttrs medianStyle = new LineAttrs();
    private boolean medianOn = true;
    private Color meanColor = Color.red;
    private double meanTransparency = -1.0;
    private int meanSymbol = 6;
    private int meanSize = 9;
    private int meanWeight = 0;
    private boolean meanOn = true;
    private Color markerColor = Color.black;
    private double markerTransparency = -1.0;
    private int markerSymbol = 0;
    private int markerSize = 7;
    private int markerWeight = 0;
    private boolean markersOn = true;
    private boolean fillOn = true;
    private FillAttrs fillStyle = new FillAttrs();
    private LineAttrs outlineStyle = new LineAttrs();
    private LineAttrs whiskerStyle = new LineAttrs();
    private boolean whiskersOn = true;
    private int orientation = 0;
    private int connectBy = 6;
    private LineAttrs lineStyle = new LineAttrs();
    private boolean connectOn = false;
    private boolean connectSkipMiss = false;
    private boolean discreteX = true;
    private boolean labelFar = false;
    private TextStyle labelStyle = new TextStyle();
    private SASFormat labelFormat = null;
    private boolean fillPatternOn = false;
    private FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
    private boolean[] hide;
    private TukeyBox tBox;
    private boolean spread = false;
    private HashMap[] outliersMap;
    private NumericVector jitter;
    private OutlierLabelLayout layout;
    private boolean hasStatistic = false;
    private Overlay[] blockOverlays = null;
    private boolean customTips = false;
    private String[] customTipList;
    private ArrayList statTips = new ArrayList();
    private HashMap statTipLabel;
    private HashMap statTipFormat;
    private boolean customOutlierTips = false;
    private double discreteOffset = 0.0;
    public static final byte CLUSTER = 0;
    public static final byte OVERLAY = 1;
    private int groupDisplay = 1;
    private double clusterWidth = 0.7;
    private int[] groupsPerCategory;
    private ArrayList[] groupCategoryLists;
    private int[] subToColumnGroupCategory;
    private HashMap groupValue2Category;
    private String overlayID;
    private boolean useFillColor = false;
    private boolean useOutlineColor = false;
    private boolean useOutlinePattern = false;
    private boolean useOutlineSize = false;
    private boolean useMedianColor = false;
    private boolean useMedianPattern = false;
    private boolean useMedianSize = false;
    private boolean useMeanColor = false;
    private boolean useMeanSymbol = false;
    private boolean useMeanSize = false;
    private boolean useMeanWeight = false;
    private boolean useMeanTransparency = false;
    private boolean useWhiskerColor = false;
    private boolean useWhiskerPattern = false;
    private boolean useWhiskerSize = false;
    private boolean useOutlierColor = false;
    private boolean useOutlierSymbol = false;
    private boolean useOutlierSize = false;
    private boolean useOutlierWeight = false;
    private boolean useOutlierTransparency = false;
    private boolean useConnectLineColor = false;
    private boolean useConnectLinePattern = false;
    private boolean useConnectLineSize = false;
    private boolean useDataLabelColor = false;
    private boolean useFillPattern = false;
    private boolean useFillPatternColor = false;
    private int connectionOrder = 0;
    private Image skinImage = null;
    private static final int MINSIZE = 5;
    private boolean dataLabelHasBeenSplit = false;
    private NumericVector splitDataLabelHeight;
    private NumericVector splitDataLabelWidth;
    private double maxSplitDataLabelHeight;
    private double maxSplitDataLabelWidth;
    public static int ORDER_AUTO = 0;
    public static int ORDER_MEAN = 1;
    public static int ORDER_MEDIAN = 2;
    private int categoryOrderRole = ORDER_AUTO;
    private int categoryOrderType = 0;
    private NumericVariable orderVar;
    HashMap outlierTipRoleMap;

    public void setCategoryOrderRole(int role) {
        this.categoryOrderRole = role;
    }

    public int getCategoryOrderRole() {
        return this.categoryOrderRole;
    }

    public void setCategoryOrderType(int type) {
        if (this.categoryOrderType != type) {
            this.categoryOrderType = type;
            if (this.orderVar != null) {
                this.updateXRange();
            }
        }
    }

    public int getCategoryOrderType() {
        return this.categoryOrderType;
    }

    private boolean isAutoBoxSize() {
        return this.xvalueVar != null && this.xvalueVar instanceof NumericVariable && this.getGroupDisplayInUse() == 0 && this.intervalBoxWidth < 0.0 && !this.userSetBoxScale;
    }

    public void setUseFillPattern(boolean b) {
        this.useFillPattern = b;
    }

    public void setUseFillPatternColor(boolean b) {
        this.useFillPatternColor = b;
    }

    public void setUseFillColor(boolean b) {
        this.useFillColor = b;
    }

    public void setUseOutlineColor(boolean b) {
        this.useOutlineColor = b;
    }

    public void setUseOutlineSize(boolean b) {
        this.useOutlineSize = b;
    }

    public void setUseOutlinePattern(boolean b) {
        this.useOutlinePattern = b;
    }

    public void setUseMedianColor(boolean b) {
        this.useMedianColor = b;
    }

    public void setUseMedianPattern(boolean b) {
        this.useMedianPattern = b;
    }

    public void setUseMedianSize(boolean b) {
        this.useMedianSize = b;
    }

    public void setUseMeanColor(boolean b) {
        this.useMeanColor = b;
    }

    public void setUseMeanSymbol(boolean b) {
        this.useMeanSymbol = b;
    }

    public void setUseMeanSize(boolean b) {
        this.useMeanSize = b;
    }

    public void setUseWhiskerColor(boolean b) {
        this.useWhiskerColor = b;
    }

    public void setUseWhiskerPattern(boolean b) {
        this.useWhiskerPattern = b;
    }

    public void setUseWhiskerSize(boolean b) {
        this.useWhiskerSize = b;
    }

    public void setUseOutlierColor(boolean b) {
        this.useOutlierColor = b;
    }

    public void setUseOutlierSymbol(boolean b) {
        this.useOutlierSymbol = b;
    }

    public void setUseOutlierSize(boolean b) {
        this.useOutlierSize = b;
    }

    public void setUseConnectLineColor(boolean b) {
        this.useConnectLineColor = b;
    }

    public void setUseConnectLinePattern(boolean b) {
        this.useConnectLinePattern = b;
    }

    public void setUseConnectLineSize(boolean b) {
        this.useConnectLineSize = b;
    }

    public void setUseDataLabelColor(boolean b) {
        this.useDataLabelColor = b;
    }

    public void setUseMeanTransparency(boolean b) {
        this.useMeanTransparency = b;
    }

    public void setUseOutlierTransparency(boolean b) {
        this.useOutlierTransparency = b;
    }

    public boolean isUseMeanWeight() {
        return this.useMeanWeight;
    }

    public void setUseMeanWeight(boolean useMeanWeight) {
        this.useMeanWeight = useMeanWeight;
    }

    public boolean isUseOutlierWeight() {
        return this.useOutlierWeight;
    }

    public void setUseOutlierWeight(boolean useOutlierWeight) {
        this.useOutlierWeight = useOutlierWeight;
    }

    public void setGroupDisplay(int display) {
        this.groupDisplay = display;
    }

    public int getGroupDisplay() {
        return this.groupDisplay;
    }

    public void setClusterWidth(double width) {
        this.clusterWidth = width;
    }

    public double getClusterWidth() {
        return this.clusterWidth;
    }

    public boolean isCustomTips() {
        return this.customTips;
    }

    public void setCustomTips(boolean b) {
        this.customTips = b;
    }

    public boolean isCustomOutlierTips() {
        return this.customOutlierTips;
    }

    public void setCustomOutlierTips(boolean b) {
        this.customOutlierTips = b;
    }

    public void clearStatTips() {
        this.statTips.clear();
    }

    public void addStatTip(String stat) {
        this.statTips.add(stat);
    }

    public void setStatTipLabel(HashMap labelMap) {
        this.statTipLabel = labelMap;
    }

    public void setStatTipFormat(HashMap formatMap) {
        this.statTipFormat = formatMap;
    }

    public void setCustomTipList(String[] tips) {
        this.customTipList = tips;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null && this.categoryOrderRole != ORDER_AUTO && this.categoryOrderType != 0) {
            StringVariable xvar = new StringVariable();
            xvar.connectFrom((StringVariable)this.tukeyXVar);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)xvar);
            vp.addVariable((Variable)this.orderVar);
            vp.setSort((Variable)this.orderVar, this.categoryOrderType);
            newRange = BoxOverlay.makeDiscreteRange(xvar, xvar.getUniqueValueCount());
        } else if (this.xvalueVar != null) {
            int num;
            int n = num = this.numericX ? this.getSubsettedValueCount(this.xvalueVar, (short)10, true) : this.getSubsettedUniqueValueCount(this.xvalueVar, (short)10, this.numericDiscreteX);
            if (num == 1 && this.numericX && this.xvalueVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                boolean subset;
                boolean bl = this.orientation == 0 ? !this.xUnionAllPages : (subset = !this.yUnionAllPages);
                newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, subset) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, num, (NumericVariable)this.numericXVar, (short)10, subset) : this.makeDiscreteRange((StringVariable)this.xvalueVar, num, (short)10, subset));
                newRange.setLabel(this.xvalueVar.getLabel());
            } else {
                newRange = null;
            }
        } else {
            newRange = new StubRange();
        }
        this.setFormat((DataRange)newRange, 10);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.xRange = newRange;
        if (this.orientation == 0) {
            this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
        } else {
            this.fireRangeEvent((byte)2, oldRange, (DataRange)newRange);
        }
    }

    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        if (this.yvalueVar != null) {
            int num;
            int n = num = this.numericY ? this.getSubsettedValueCount(this.yvalueVar, (short)11, true) : this.getSubsettedUniqueValueCount(this.yvalueVar, (short)11, false);
            if (num == 1 && this.numericY && this.yvalueVar.isMissing(0)) {
                num = 0;
            }
            if (num > 0) {
                if (this.numericY) {
                    String[] stats;
                    double[] vals;
                    CRD crd = this.model;
                    if (StatGraph.MPC > 0) {
                        vals = crd.getDoubleColumn(11);
                        stats = crd.getStringColumn(47);
                        num = vals.length;
                    } else {
                        vals = this.getSubsettedDoubleColumn((short)11);
                        stats = this.getSubsettedStringColumn((short)47);
                    }
                    HashMap<String, Double> q1map = null;
                    HashMap<String, Double> q3map = null;
                    HashMap<String, Double> medmap = null;
                    HashMap<String, Double> nmap = null;
                    String[] xvals = null;
                    if (this.notched) {
                        q1map = new HashMap<String, Double>();
                        q3map = new HashMap<String, Double>();
                        nmap = new HashMap<String, Double>();
                        medmap = new HashMap<String, Double>();
                        if (this.xvalueVar != null) {
                            xvals = StatGraph.MPC > 0 ? (this.numericX || this.numericDiscreteX ? crd.getDoubleAsClassColumn(10) : crd.getStringAsClassColumn(10)) : (this.numericX || this.numericDiscreteX ? this.getSubsettedDoubleAsClassColumn((short)10) : this.getSubsettedStringAsClassColumn((short)10));
                        }
                    }
                    double min = Double.MAX_VALUE;
                    double max = -1.7976931348623157E308;
                    for (int i = 0; i < num; ++i) {
                        String X;
                        if (stats[i] == null || StatGraph.MPC > 0 && !this.missingCategoryOn && this.missingValueControlVar.isMissing(i)) continue;
                        if (stats[i].equalsIgnoreCase("MIN") || stats[i].equalsIgnoreCase("Q1") || stats[i].equalsIgnoreCase("MEDIAN") || stats[i].equalsIgnoreCase("Q3") || stats[i].equalsIgnoreCase("MAX") || stats[i].equalsIgnoreCase("MEAN") || stats[i].equalsIgnoreCase("OUTLIER") || stats[i].equalsIgnoreCase("FAROUTLIER") || stats[i].equalsIgnoreCase("DATAMIN") || stats[i].equalsIgnoreCase("DATAMAX")) {
                            if (vals[i] > max) {
                                max = vals[i];
                            }
                            if (vals[i] < min) {
                                min = vals[i];
                            }
                        }
                        if (!this.notched) continue;
                        String string = X = this.xvalueVar != null ? xvals[i] : "a";
                        if (stats[i].equalsIgnoreCase("Q1")) {
                            q1map.put(X, vals[i]);
                        }
                        if (stats[i].equalsIgnoreCase("Q3")) {
                            q3map.put(X, vals[i]);
                        }
                        if (stats[i].equalsIgnoreCase("MEDIAN")) {
                            medmap.put(X, vals[i]);
                        }
                        if (!stats[i].equalsIgnoreCase("N")) continue;
                        nmap.put(X, vals[i]);
                    }
                    if (this.notched) {
                        for (Object key : q1map.keySet()) {
                            double n2;
                            double q1 = (Double)q1map.get(key);
                            double q3 = q3map.get(key) != null ? (Double)q3map.get(key) : Double.NaN;
                            double med = medmap.get(key) != null ? (Double)medmap.get(key) : Double.NaN;
                            double d = n2 = nmap.get(key) != null ? (Double)nmap.get(key) : Double.NaN;
                            if (Double.isNaN(q3) || Double.isNaN(med) || Double.isNaN(n2) || !(n2 > 0.0)) continue;
                            double not = 1.58 * (q3 - q1) / Math.sqrt(n2);
                            min = Math.min(min, med - not);
                            max = Math.max(max, med + not);
                        }
                    }
                    newRange = new ContinuousRange(min, max);
                    newRange.setLabel(this.yvalueVar.getLabel());
                } else {
                    newRange = null;
                }
            } else {
                newRange = null;
            }
        }
        this.setFormat(newRange, 11);
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        Object cr = null;
        switch (dimension) {
            case 1: {
                if (this.orientation == 0) {
                    return this.xRange;
                }
                return this.yRange;
            }
            case 2: {
                if (this.orientation == 0) {
                    return this.yRange;
                }
                return this.xRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
            if (this.xEncoder.isReversed() && this.blockOverlays != null) {
                for (int i = 0; i < this.blockOverlays.length; ++i) {
                    AxisTable at = (AxisTable)this.blockOverlays[i];
                    if (at.getLabelPosition() == 2) {
                        at.setLabelPosition(1);
                        continue;
                    }
                    at.setLabelPosition(2);
                }
            }
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 4) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.colorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 15) {
            if (!(encoder instanceof LineEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.lineEncoder)) {
                return;
            }
            this.lineEncoder = (LineEncoder)encoder;
        } else if (dimension == 17) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.lineColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 16) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.meanColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 23) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.outlierColorEncoder = (ColorEncoder)encoder;
        } else if (dimension == 6) {
            if (!(encoder instanceof ShapeEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.shapeEncoder)) {
                return;
            }
            this.shapeEncoder = (ShapeEncoder)encoder;
        } else if (dimension == 21) {
            if (!(encoder instanceof FillPatternEncoder)) {
                return;
            }
            this.fillPatternEncoder = (FillPatternEncoder)encoder;
        } else if (dimension == 22) {
            if (!(encoder instanceof ColorEncoder)) {
                return;
            }
            this.fillPatternColorEncoder = (ColorEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
    }

    private int getGroupDisplayInUse() {
        if (this.groupVar == null) {
            return 1;
        }
        return this.groupDisplay;
    }

    @Override
    public boolean connectNetwork() {
        DiscreteAttrMapper groupAttrMapper;
        int nBox;
        int tukey;
        int maxGroups;
        int i;
        ContinuousRangeToNumericMapper translate;
        SASFormat format;
        double intvl;
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        if (this.xRange == null || this.yRange == null) {
            return false;
        }
        if (this.xEncoder == null || this.yEncoder == null) {
            return false;
        }
        double stride = 0.0;
        double discreteOffsetValue = 0.0;
        double boxSize = 0.0;
        ContinuousRangeToNumericMapper xvalueMapper2 = null;
        ContinuousRangeToNumericMapper yvalueMapper2 = null;
        ValueMap map = this.xEncoder.getValueMap();
        if (this.orientation != 0 || this.orientation == 0 && this.numericX) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            if (this.orientation == 0) {
                intvl = this.getMinimumInterval((short)10);
                boxSize = intvl == 0.0 ? 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) : this.getDefaultIntervalBoxSize(intvl, this.xEncoder, false);
                stride = boxSize;
            }
            if (this.xEncoder instanceof BrokenPositionEncoder) {
                xvalueMapper2 = new ContinuousRangeToNumericMapper();
                xvalueMapper2.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)this.xEncoder).getBrokenValueMap());
            }
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
            stride = ((StringToNumericMap)map).getStrideValue();
            discreteOffsetValue = this.discreteOffset * stride;
            if (this.xEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
            boxSize = stride;
        }
        map = this.yEncoder.getValueMap();
        if (this.orientation == 0 || this.orientation != 0 && this.numericX) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.yvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.yvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            if (this.orientation != 0) {
                intvl = this.getMinimumInterval((short)10);
                boxSize = intvl == 0.0 ? 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) : this.getDefaultIntervalBoxSize(intvl, this.yEncoder, false);
                stride = boxSize;
            }
            if (this.yEncoder instanceof BrokenPositionEncoder) {
                yvalueMapper2 = new ContinuousRangeToNumericMapper();
                yvalueMapper2.setMap((ContinuousRangeToNumericMap)((BrokenPositionEncoder)this.yEncoder).getBrokenValueMap());
            }
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return false;
            }
            if (!(this.yvalueMapper instanceof StringToNumericMapper)) {
                this.yvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.yvalueMapper).setMap((StringToNumericMap)map);
            stride = ((StringToNumericMap)map).getStrideValue();
            discreteOffsetValue = this.discreteOffset * stride;
            if (this.yEncoder.isReversed()) {
                discreteOffsetValue = -discreteOffsetValue;
            }
            boxSize = stride;
        }
        SASFormat sASFormat = format = this.orientation == 0 ? this.xEncoder.getInput().getFormat() : this.yEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            if (!this.discreteX) {
                this.xvalueVar.setFormat(new GTKFormat((Format)format));
                this.tukeyXVar.setFormat(new GTKFormat((Format)format));
                this.outlierXVar.setFormat(new GTKFormat((Format)format));
            }
        } else if (this.numericX && this.xvalueVar != null) {
            this.tukeyXVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            this.outlierXVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        SASFormat sASFormat2 = format = this.orientation == 0 ? this.yEncoder.getInput().getFormat() : this.xEncoder.getInput().getFormat();
        if (format != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)format));
            this.tukeyYVar.setFormat(new GTKFormat((Format)format));
            this.outlierYVar.setFormat(new GTKFormat((Format)format));
        } else if (this.numericY) {
            this.yvalueVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            this.tukeyYVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            this.outlierYVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
        }
        this.networkRoot.removeAllElements();
        this.loadSkinImage();
        int scaledMarkerSize = this.markerSize;
        if (this.scaleMarkers) {
            double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
            double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
            scaledMarkerSize = (int)((double)this.markerSize * Math.pow(Math.min(ratio_w, ratio_h), 0.25) + 0.5);
            scaledMarkerSize = Math.min(this.markerSize, Math.max(5, scaledMarkerSize));
        }
        this.tBox = new TukeyBox();
        if (this.extreme) {
            int n = this.extremeMin.length;
            for (int i2 = 0; i2 < n; ++i2) {
                int idx0 = i2 * 7 + 0;
                int idx1 = i2 * 7 + 1;
                int idx3 = i2 * 7 + 3;
                int idx4 = i2 * 7 + 4;
                if (this.graphed[idx0] && !Double.isNaN(this.extremeMin[i2])) {
                    this.tukeyY[idx0] = Math.min(this.tukeyY[idx0], this.extremeMin[i2]);
                } else if (!Double.isNaN(this.extremeMin[i2])) {
                    this.tukeyY[idx0] = Math.min(this.tukeyY[idx1], this.extremeMin[i2]);
                    this.graphed[idx0] = true;
                }
                if (this.graphed[idx4] && !Double.isNaN(this.extremeMax[i2])) {
                    this.tukeyY[idx4] = Math.max(this.tukeyY[idx4], this.extremeMax[i2]);
                    continue;
                }
                if (Double.isNaN(this.extremeMax[i2])) continue;
                this.tukeyY[idx4] = Math.max(this.tukeyY[idx3], this.extremeMax[i2]);
                this.graphed[idx4] = true;
            }
        }
        NumericMapper nm = this.orientation == 0 ? this.yvalueMapper : this.xvalueMapper;
        ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.tukeyYVar).value);
        NumericMapper numericMapper = nm = this.orientation == 0 ? this.xvalueMapper : this.yvalueMapper;
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)nm).input.connectFrom(((NumericVariable)this.tukeyXVar).value);
        } else {
            ((StringToNumericMapper)nm).input.connectFrom(((StringVariable)this.tukeyXVar).value);
        }
        PositionEncoder pe = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        Object object = map = pe instanceof BrokenPositionEncoder ? ((BrokenPositionEncoder)pe).getBrokenValueMap() : pe.getValueMap();
        if (this.numericX) {
            translate = new ContinuousRangeToNumericMapper();
            if (this.groupVar == null) {
                NumericPipe uv = ((NumericVariable)this.xvalueVar).uniqueValue;
                translate.input.connectFrom(uv);
                translate.setMap((ContinuousRangeToNumericMap)map);
            } else if (this.getGroupDisplayInUse() == 1) {
                NumericVector uv = new NumericVector();
                try {
                    for (int i3 = 0; i3 < this.xvalueVar.getUniqueValueCount(); ++i3) {
                        double x = ((NumericVariable)this.xvalueVar).uniqueValue.getValue(i3);
                        for (int j = 0; j < this.groupsPerCategory[i3]; ++j) {
                            uv.addValue(x);
                        }
                    }
                }
                catch (MissingValueException i3) {
                    // empty catch block
                }
                translate.input.connectFrom((NumericPipe)uv);
                translate.setMap((ContinuousRangeToNumericMap)map);
            } else {
                int maxGroups2 = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                boxSize = Math.round(stride * this.clusterWidth / (double)maxGroups2);
                translate = new NumericVector();
                int tukey2 = 0;
                for (i = 0; i < this.xvalueVar.getUniqueValueCount(); ++i) {
                    try {
                        double xval = ((NumericVariable)this.xvalueVar).uniqueValue.getValue(i);
                        for (int j = 0; j < this.groupsPerCategory[i]; ++j) {
                            try {
                                double x = ((ContinuousRangeToNumericMap)map).getValue(xval);
                                String gval = this.tukeyGroupVar.value.getValue(tukey2++);
                                int gcat = (Integer)this.groupValue2Category.get(gval);
                                x -= (double)((int)(((double)this.groupsPerCategory[i] / 2.0 - 0.5) * boxSize));
                                ((NumericVector)translate).addValue(x += boxSize * (double)this.groupCategoryLists[i].indexOf(gcat));
                                continue;
                            }
                            catch (MissingValueException e) {
                                ((NumericVector)translate).addValue(Double.NaN);
                                ++tukey2;
                            }
                        }
                        continue;
                    }
                    catch (MissingValueException xval) {
                        // empty catch block
                    }
                }
            }
        } else if (this.xvalueVar == null) {
            if (this.groupVar == null) {
                translate = new StringToNumericMapper();
                ((StringToNumericMapper)translate).input.setValue("a");
                ((StringToNumericMapper)translate).setMap((StringToNumericMap)map);
            } else {
                maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                if (this.getGroupDisplayInUse() == 0) {
                    boxSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
                }
                translate = new NumericVector();
                tukey = 0;
                for (int j = 0; j < this.groupsPerCategory[0]; ++j) {
                    try {
                        double x = ((StringToNumericMap)map).uniqueValue.getValue(0);
                        if (this.getGroupDisplayInUse() == 0) {
                            String gval = this.tukeyGroupVar.value.getValue(tukey++);
                            int gcat = (Integer)this.groupValue2Category.get(gval);
                            x -= (double)((int)(((double)this.groupsPerCategory[0] / 2.0 - 0.5) * boxSize));
                            x += boxSize * (double)this.groupCategoryLists[0].indexOf(gcat);
                        }
                        ((NumericVector)translate).addValue(x);
                        continue;
                    }
                    catch (MissingValueException e) {
                        ((NumericVector)translate).addValue(Double.NaN);
                        ++tukey;
                    }
                }
            }
        } else if (this.groupVar == null) {
            translate = new StringToNumericMapper();
            StringPipe uv = ((StringVariable)this.xvalueVar).uniqueValue;
            ((StringToNumericMapper)translate).input.connectFrom(uv);
            ((StringToNumericMapper)translate).setMap((StringToNumericMap)map);
        } else {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            if (this.getGroupDisplayInUse() == 0) {
                boxSize = Math.round(stride * this.clusterWidth / (double)maxGroups);
            }
            translate = new NumericVector();
            tukey = 0;
            for (int i4 = 0; i4 < this.xvalueVar.getUniqueValueCount(); ++i4) {
                try {
                    String xval = ((StringVariable)this.xvalueVar).uniqueValue.getValue(i4);
                    for (int j = 0; j < this.groupsPerCategory[i4]; ++j) {
                        try {
                            double x = ((StringToNumericMap)map).getValue((Object)xval);
                            if (this.getGroupDisplayInUse() == 0) {
                                String gval = this.tukeyGroupVar.value.getValue(tukey++);
                                int gcat = (Integer)this.groupValue2Category.get(gval);
                                x -= (double)((int)(((double)this.groupsPerCategory[i4] / 2.0 - 0.5) * boxSize));
                                x += boxSize * (double)this.groupCategoryLists[i4].indexOf(gcat);
                            }
                            ((NumericVector)translate).addValue(x);
                            continue;
                        }
                        catch (MissingValueException e) {
                            ((NumericVector)translate).addValue(Double.NaN);
                            ++tukey;
                        }
                    }
                    continue;
                }
                catch (MissingValueException xval) {
                    // empty catch block
                }
            }
        }
        BooleanVector graphedVector = new BooleanVector();
        for (int i5 = 0; i5 < this.graphed.length; ++i5) {
            int idx = i5 % 7;
            if (idx == 0) {
                graphedVector.addValue(this.graphed[i5] && this.isWhiskersOn());
                continue;
            }
            if (idx == 2) {
                graphedVector.addValue(this.graphed[i5] && this.isMedianOn());
                continue;
            }
            if (idx == 4) {
                graphedVector.addValue(this.graphed[i5] && this.isWhiskersOn());
                continue;
            }
            if (idx == 5) {
                graphedVector.addValue(this.graphed[i5] && this.isMeanOn());
                continue;
            }
            graphedVector.addValue(this.graphed[i5]);
        }
        BooleanVector notchVector = new BooleanVector();
        int n = nBox = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        if (this.groupVar != null) {
            int totalTukey = 0;
            for (int i6 = 0; i6 < nBox; ++i6) {
                totalTukey += this.groupsPerCategory[i6];
            }
            nBox = totalTukey;
        }
        for (i = 0; i < nBox; ++i) {
            int idx = i * 7 + 2;
            notchVector.addValue(this.graphed[idx] && this.notched);
        }
        double minBoxWidth = Double.MAX_VALUE;
        NumericVector boxWidthVector = new NumericVector();
        for (int i7 = 0; i7 < nBox; ++i7) {
            double width;
            if (this.boxWidthScale[i7] >= 0.0) {
                width = boxSize * this.boxWidthScale[i7];
                if (width % 2.0 == 0.0) {
                    width -= 1.0;
                }
            } else if (this.intervalBoxWidth >= 0.0) {
                width = this.intervalBoxWidth;
            } else {
                width = boxSize * this.boxScale;
                if (this.isAutoBoxSize() && width < 5.0) {
                    width = 5.0;
                }
                if (width % 2.0 == 0.0) {
                    width -= 1.0;
                }
                minBoxWidth = Math.min(minBoxWidth, width);
            }
            boxWidthVector.addValue(width);
        }
        ColorVector colorPipe = null;
        if (this.groupVar != null && this.colorEncoder != null) {
            colorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.colorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (int i8 = 0; i8 < nBox; ++i8) {
                Color c;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i8);
                    c = this.indexVar == null ? cmap.getValue(gval) : this.getIndexColor(this.colorEncoder, gval, (ColorAttr)this.fillStyle);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.fillStyle);
                }
                colorPipe.addValue(c);
            }
        }
        ColorVector lineColorPipe = null;
        if (this.groupVar != null && this.lineColorEncoder != null) {
            lineColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.lineColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (int i9 = 0; i9 < nBox; ++i9) {
                Color c;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i9);
                    c = this.indexVar == null ? cmap.getValue(gval) : this.getIndexColor(this.lineColorEncoder, gval, (ColorAttr)this.outlineStyle);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.outlineStyle);
                }
                lineColorPipe.addValue(c);
            }
        }
        ColorVector meanColorPipe = null;
        if (this.groupVar != null && this.meanColorEncoder != null) {
            meanColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.meanColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            MarkerAttrs ma = new MarkerAttrs();
            ma.setColor(this.meanColor);
            ma.setTransparency(this.meanTransparency);
            for (int i10 = 0; i10 < nBox; ++i10) {
                Color c;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i10);
                    c = this.indexVar == null ? cmap.getValue(gval) : this.getIndexColor(this.meanColorEncoder, gval, (ColorAttr)ma);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)ma);
                }
                meanColorPipe.addValue(c);
            }
        }
        IntegerVector stipplePatternPipe = null;
        IntegerVector stippleFactorPipe = null;
        IntegerVector linePatternPipe = null;
        if (this.groupVar != null && this.lineEncoder != null) {
            stipplePatternPipe = new IntegerVector();
            stippleFactorPipe = new IntegerVector();
            linePatternPipe = new IntegerVector();
            HashMap ht = this.lineEncoder.styleList;
            for (int i11 = 0; i11 < nBox; ++i11) {
                LineAttrs ls;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i11);
                    ls = this.indexVar == null ? (LineAttrs)ht.get(gval) : this.getIndexLineAttrs(this.lineEncoder, gval, this.outlineStyle);
                }
                catch (MissingValueException e) {
                    ls = this.outlineStyle;
                }
                stipplePatternPipe.addValue(ls.getStipplePattern());
                stippleFactorPipe.addValue(ls.getStippleFactor());
                linePatternPipe.addValue(ls.getLinePattern());
            }
        }
        IntegerVector shapePipe = null;
        if (this.groupVar != null && this.shapeEncoder != null) {
            shapePipe = new IntegerVector();
            HashMap ht = this.shapeEncoder.shapeList;
            int ms = -1;
            for (int i12 = 0; i12 < nBox; ++i12) {
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i12);
                    ms = this.indexVar == null ? ((Integer)ht.get(gval)).intValue() : this.getIndexMarkerSymbol(this.shapeEncoder, gval, this.meanSymbol);
                }
                catch (MissingValueException e) {
                    ms = this.meanSymbol;
                }
                shapePipe.addValue(ms);
            }
        }
        NumericVector fillPatternWidthPipe = null;
        IntegerVector fillPatternPipe = null;
        if (this.groupVar != null && this.fillPatternEncoder != null) {
            fillPatternWidthPipe = new NumericVector();
            fillPatternPipe = new IntegerVector();
            HashMap ht = this.fillPatternEncoder.patternList;
            for (int i13 = 0; i13 < nBox; ++i13) {
                int p;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i13);
                    p = this.indexVar == null ? ((Integer)ht.get(gval)).intValue() : this.getIndexFillPattern(this.fillPatternEncoder, gval, this.fillPatternStyle);
                }
                catch (MissingValueException e) {
                    p = this.fillPatternStyle.getPattern();
                }
                fillPatternPipe.addValue(BarOverlay.getGLFillPattern(p));
                fillPatternWidthPipe.addValue((double)FillPatternAttrs.getPatternWidth((int)p));
            }
        }
        ColorVector fillPatternColorPipe = null;
        if (this.groupVar != null && this.fillPatternColorEncoder != null) {
            fillPatternColorPipe = new ColorVector();
            StringToColorMap cmap = (StringToColorMap)this.fillPatternColorEncoder.getValueMap();
            cmap.init(new AInitAction());
            for (int i14 = 0; i14 < nBox; ++i14) {
                Color c;
                try {
                    String gval = this.tukeyGroupVar.value.getValue(i14);
                    c = this.indexVar == null ? cmap.getValue(gval) : this.getIndexColor(this.fillPatternColorEncoder, gval, (ColorAttr)this.fillPatternStyle);
                }
                catch (MissingValueException e) {
                    c = this.applyDataTransparency((ColorAttr)this.fillPatternStyle);
                }
                fillPatternColorPipe.addValue(c);
            }
        }
        DiscreteAttrMapper discreteAttrMapper = groupAttrMapper = this.groupVar != null && this.hasAttrVar("TUKEYGROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP") : null;
        if (groupAttrMapper != null) {
            groupAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            groupAttrMapper.setUseFillTransparency(this.useFillTransparency);
            groupAttrMapper.setLineTransparency(this.dataTransparency);
            groupAttrMapper.setMarkerTransparency(this.meanTransparency < 0.0 ? this.dataTransparency : this.meanTransparency);
            groupAttrMapper.setUseMarkerTransparency(this.useMeanTransparency);
            groupAttrMapper.variable = this.tukeyGroupVar.value;
            groupAttrMapper.fillColorPipe = colorPipe;
            groupAttrMapper.lineColorPipe = lineColorPipe != null ? lineColorPipe : fillPatternColorPipe;
            groupAttrMapper.linePatternPipe = linePatternPipe;
            groupAttrMapper.markerColorPipe = lineColorPipe;
            groupAttrMapper.markerSymbolPipe = shapePipe;
            groupAttrMapper.addLineThicknessPipe("median", this.medianStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("outline", this.outlineStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("whisker", this.whiskerStyle.getWidth());
            groupAttrMapper.addLineThicknessPipe("connect", this.lineStyle.getWidth());
            groupAttrMapper.addMarkerSizePipe("mean", this.meanSize);
            groupAttrMapper.setDataDPIScaleFactor(StatGraph.dataDPIScaleFactor);
            if (this.useMeanSize && !this.useMeanWeight) {
                groupAttrMapper.addMarkerEdgeThicknessPipe("mean", this.meanSize, this.meanWeight, true);
            } else {
                groupAttrMapper.addMarkerEdgeThicknessPipe("mean", this.meanSize, this.meanWeight);
            }
            if (this.scaleMarkers) {
                double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
                double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
                groupAttrMapper.setScaleMarkers(true);
                groupAttrMapper.setMinMarkerSize(5);
                groupAttrMapper.setRatioW(ratio_w);
                groupAttrMapper.setRatioH(ratio_h);
            }
        }
        ColorProperty fillColorProperty = new ColorProperty();
        if (this.colorEncoder == null || this.useFillColor) {
            fillColorProperty.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
        } else {
            fillColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? colorPipe : groupAttrMapper.fillColor));
        }
        ColorProperty outlineColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useOutlineColor) {
            outlineColorProperty.setValue(this.applyDataTransparency(this.outlineStyle.getColor()));
        } else {
            outlineColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty outlineStipplePatternProperty = new IntegerProperty();
        IntegerProperty outlineStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useOutlinePattern) {
            outlineStipplePatternProperty.setValue(this.outlineStyle.getStipplePattern());
            outlineStippleFactorProperty.setValue(this.outlineStyle.getStippleFactor());
        } else {
            outlineStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            outlineStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        ColorProperty medianColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useMedianColor) {
            medianColorProperty.setValue(this.applyDataTransparency(this.medianStyle.getColor()));
        } else {
            medianColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty medianStipplePatternProperty = new IntegerProperty();
        IntegerProperty medianStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useMedianPattern) {
            medianStipplePatternProperty.setValue(this.medianStyle.getStipplePattern());
            medianStippleFactorProperty.setValue(this.medianStyle.getStippleFactor());
        } else {
            medianStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            medianStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        ColorProperty meanColorProperty = new ColorProperty();
        if (this.meanColorEncoder == null || this.useMeanColor) {
            meanColorProperty.setValue(this.applyDataTransparency(this.meanColor, this.meanTransparency));
        } else {
            meanColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? meanColorPipe : groupAttrMapper.markerColor));
        }
        IntegerProperty meanSymbolProperty = new IntegerProperty();
        if (this.shapeEncoder == null || this.useMeanSymbol) {
            meanSymbolProperty.setValue(this.meanSymbol);
        } else {
            meanSymbolProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? shapePipe : groupAttrMapper.markerSymbol));
        }
        ColorProperty whiskerColorProperty = new ColorProperty();
        if (this.lineColorEncoder == null || this.useWhiskerColor) {
            whiskerColorProperty.setValue(this.applyDataTransparency(this.whiskerStyle.getColor()));
        } else {
            whiskerColorProperty.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorPipe : groupAttrMapper.lineColor));
        }
        IntegerProperty whiskerStipplePatternProperty = new IntegerProperty();
        IntegerProperty whiskerStippleFactorProperty = new IntegerProperty();
        if (this.lineEncoder == null || this.useWhiskerPattern) {
            whiskerStipplePatternProperty.setValue(this.whiskerStyle.getStipplePattern());
            whiskerStippleFactorProperty.setValue(this.whiskerStyle.getStippleFactor());
        } else {
            whiskerStipplePatternProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stipplePatternPipe : groupAttrMapper.lineStipplePattern));
            whiskerStippleFactorProperty.connectFrom((IntegerPipe)(groupAttrMapper == null ? stippleFactorPipe : groupAttrMapper.lineStippleFactor));
        }
        NumericPipe translatePipe = this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)translate);
        if (this.orientation == 0) {
            this.tBox.transform.translateX.connectFrom(translatePipe);
            this.tBox.y.connectFrom(this.yvalueMapper.value);
            this.tBox.x.connectFrom(this.xvalueMapper.value);
        } else {
            this.tBox.transform.translateY.connectFrom(translatePipe);
            this.tBox.y.connectFrom(this.xvalueMapper.value);
            this.tBox.x.connectFrom(this.yvalueMapper.value);
        }
        this.tBox.rawY.connectFrom(((NumericVariable)this.tukeyYVar).value);
        this.tBox.outlierCount.setValue(0);
        this.tBox.graphed.connectFrom((BooleanPipe)graphedVector);
        this.tBox.orientation.setValue(this.orientation);
        this.tBox.extreme.setValue(false);
        this.tBox.boxWidth.connectFrom((NumericPipe)boxWidthVector);
        this.tBox.notched.connectFrom((BooleanPipe)notchVector);
        if (this.isCapOn()) {
            this.tBox.capShape.setValue(this.capShape);
        } else {
            this.tBox.capShape.setValue(0);
        }
        this.tBox.setCapScale(this.capScale);
        this.tBox.medianColor.connectFrom((ColorPipe)medianColorProperty);
        this.tBox.medianShape.setValue(this.medianSymbol);
        if (this.useMedianSize || groupAttrMapper == null) {
            this.tBox.medianWidth.setValue((double)this.medianStyle.getWidth());
        } else {
            this.tBox.medianWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("median"));
        }
        this.tBox.medianStippleFactor.connectFrom((IntegerPipe)medianStippleFactorProperty);
        this.tBox.medianStipplePattern.connectFrom((IntegerPipe)medianStipplePatternProperty);
        this.tBox.meanColor.connectFrom((ColorPipe)meanColorProperty);
        this.tBox.meanShape.connectFrom((IntegerPipe)meanSymbolProperty);
        if (this.isAutoBoxSize() && !this.useMeanSize && minBoxWidth != Double.MAX_VALUE && groupAttrMapper == null) {
            this.tBox.meanWidth.setValue(Math.min(minBoxWidth, (double)this.meanSize));
            this.tBox.meanEdgeWidth.setValue((double)StatGraph.getMarkerEdgeWidth(this.meanSize, this.meanWeight));
        } else if (this.useMeanSize || groupAttrMapper == null) {
            this.tBox.meanWidth.setValue((double)this.meanSize);
            if (groupAttrMapper != null && !this.useMeanWeight) {
                this.tBox.meanEdgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("mean"));
            } else {
                this.tBox.meanEdgeWidth.setValue((double)StatGraph.getMarkerEdgeWidth(this.meanSize, this.meanWeight));
            }
        } else {
            this.tBox.meanWidth.connectFrom((IntegerPipe)groupAttrMapper.markerSize.get("mean"));
            this.tBox.meanEdgeWidth.connectFrom((IntegerPipe)groupAttrMapper.markerEdgeThickness.get("mean"));
        }
        this.tBox.markerOn.setValue(false);
        this.tBox.markerColor.setValue(this.applyDataTransparency(this.markerColor));
        this.tBox.markerShape.setValue(this.markerSymbol);
        this.tBox.markerWidth.setValue((double)scaledMarkerSize);
        this.tBox.fillOn.setValue(this.fillOn);
        this.tBox.fillColor.connectFrom((ColorPipe)fillColorProperty);
        this.tBox.outlineColor.connectFrom((ColorPipe)outlineColorProperty);
        if (this.useOutlineSize || groupAttrMapper == null) {
            this.tBox.outlineWidth.setValue((double)this.outlineStyle.getWidth());
        } else {
            this.tBox.outlineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("outline"));
        }
        this.tBox.outlineStippleFactor.connectFrom((IntegerPipe)outlineStippleFactorProperty);
        this.tBox.outlineStipplePattern.connectFrom((IntegerPipe)outlineStipplePatternProperty);
        this.tBox.whiskerColor.connectFrom((ColorPipe)whiskerColorProperty);
        if (this.useWhiskerSize || groupAttrMapper == null) {
            this.tBox.whiskerWidth.setValue((double)this.whiskerStyle.getWidth());
        } else {
            this.tBox.whiskerWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("whisker"));
        }
        this.tBox.whiskerStippleFactor.connectFrom((IntegerPipe)whiskerStippleFactorProperty);
        this.tBox.whiskerStipplePattern.connectFrom((IntegerPipe)whiskerStipplePatternProperty);
        this.tBox.capColor.connectFrom((ColorPipe)whiskerColorProperty);
        if (this.useWhiskerSize || groupAttrMapper == null) {
            this.tBox.capWidth.setValue((double)this.whiskerStyle.getWidth());
        } else {
            this.tBox.capWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("whisker"));
        }
        this.tBox.capStippleFactor.setValue(this.capStyle.getStippleFactor());
        this.tBox.capStipplePattern.setValue(this.capStyle.getStipplePattern());
        this.tBox.setStippleScaleFactor(StatGraph.getStippleScaleFactor());
        this.tBox.fillPatternOn.setValue(this.fillPatternOn);
        if (this.fillPatternOn) {
            if (this.fillPatternEncoder == null || this.useFillPattern) {
                this.tBox.fillPatternType.setValue(BarOverlay.getGLFillPattern(this.fillPatternStyle.getPattern()));
                this.tBox.fillPatternWidth.setValue((double)FillPatternAttrs.getPatternWidth((int)this.fillPatternStyle.getPattern()));
            } else {
                this.tBox.fillPatternType.connectFrom((IntegerPipe)fillPatternPipe);
                this.tBox.fillPatternWidth.connectFrom((NumericPipe)fillPatternWidthPipe);
            }
            if (this.fillPatternColorEncoder == null || this.useFillPatternColor) {
                this.tBox.fillPatternColor.setValue(this.applyDataTransparency(this.fillPatternStyle.getColor()));
            } else {
                this.tBox.fillPatternColor.connectFrom((ColorPipe)(groupAttrMapper == null ? fillPatternColorPipe : groupAttrMapper.lineColor));
            }
            this.tBox.fillPatternScaleFactor.setValue(StatGraph.dataDPIScaleFactor);
        }
        this.tBox.setSkin(this.skinImage);
        this.tBox.setSkinType(this.skinType);
        this.tBox.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
        this.tBox.setPixelBenderImages(this.pixelBenderImages, 1);
        this.tBox.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4), 4);
        this.tBox.selectEnabled.setValue(this.selectable);
        this.tBox.setUserData((Object)this.probe);
        this.networkRoot.addElement((Element)this.tBox);
        if (this.markersOn && !this.extreme) {
            DiscreteAttrMapper groupAttrMapper2;
            int maxGroups3;
            Object nmX;
            Marker outliers = new Marker();
            outliers.setSVGRender(StatGraph.VGF);
            outliers.weightedEdgeEnabled.setValue(false);
            outliers.edgeWeight.setValue(this.markerWeight);
            if (this.spread) {
                int i15;
                this.jitter = new NumericVector();
                double maxFac = 1.25 * (double)scaledMarkerSize / boxSize;
                int numX = 1;
                if (this.xvalueVar != null) {
                    numX = this.xvalueVar.getUniqueValueCount();
                }
                HashMap[] jitterMap = new HashMap[nBox];
                for (i15 = 0; i15 < nBox; ++i15) {
                    jitterMap[i15] = new HashMap();
                }
                for (i15 = 0; i15 < this.outlierYVar.getValueCount(); ++i15) {
                    int xIdx2;
                    int xIdx;
                    if (this.numericX) {
                        try {
                            double x = ((NumericVariable)this.outlierXVar).value.getValue(i15);
                            xIdx = this.xvalueVar == null ? 0 : this.getValueIndex(x);
                        }
                        catch (MissingValueException mve) {
                            continue;
                        }
                        if (this.groupVar != null) {
                            int gIdx = 0;
                            try {
                                String gval = ((StringVariable)this.outlierGVar).value.getValue(i15);
                                int gcat = (Integer)this.groupValue2Category.get(gval);
                                gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                            }
                            catch (MissingValueException gval) {
                                // empty catch block
                            }
                            xIdx2 = 0;
                            for (int ii = 0; ii < xIdx; ++ii) {
                                xIdx2 += this.groupsPerCategory[ii];
                            }
                            xIdx = xIdx2 + gIdx;
                        }
                    } else {
                        try {
                            String X = ((StringVariable)this.outlierXVar).value.getValue(i15);
                            xIdx = this.xvalueVar == null ? 0 : this.getValueIndex(X);
                        }
                        catch (MissingValueException mve) {
                            continue;
                        }
                        if (this.groupVar != null) {
                            int gIdx = 0;
                            try {
                                String gval = ((StringVariable)this.outlierGVar).value.getValue(i15);
                                int gcat = (Integer)this.groupValue2Category.get(gval);
                                gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                            }
                            catch (MissingValueException gval) {
                                // empty catch block
                            }
                            xIdx2 = 0;
                            for (int ii = 0; ii < xIdx; ++ii) {
                                xIdx2 += this.groupsPerCategory[ii];
                            }
                            xIdx = xIdx2 + gIdx;
                        }
                    }
                    Double Y = null;
                    try {
                        Y = new Double(((NumericVariable)this.outlierYVar).value.getValue(i15));
                    }
                    catch (MissingValueException mve) {
                        Y = Double.NaN;
                    }
                    int num_outliers = (Integer)this.outliersMap[xIdx].get(Y);
                    double adjustment = this.numericX ? 1.0 / (double)num_outliers : Math.min(this.boxWidthScale[xIdx], this.boxWidthScale[xIdx] / (double)num_outliers);
                    adjustment = Math.min(maxFac, adjustment);
                    double j_value = 0.0;
                    if (jitterMap[xIdx].containsKey(Y)) {
                        j_value = (Double)jitterMap[xIdx].get(Y);
                        j_value = j_value == 0.0 ? adjustment : (j_value > 0.0 ? -j_value : -j_value + adjustment);
                    }
                    this.jitter.addValue(j_value);
                    jitterMap[xIdx].put(Y, new Double(j_value));
                }
            }
            ContinuousRangeToNumericMapper yMapper = yvalueMapper2 == null ? this.yvalueMapper : yvalueMapper2;
            ContinuousRangeToNumericMapper xMapper = xvalueMapper2 == null ? this.xvalueMapper : xvalueMapper2;
            ContinuousRangeToNumericMapper nmY = new ContinuousRangeToNumericMapper();
            nmY.input.connectFrom(((NumericVariable)this.outlierYVar).value);
            if (this.orientation == 0) {
                nmY.shareMap(yMapper);
            } else {
                nmY.shareMap(xMapper);
            }
            if (this.numericX) {
                if (this.groupVar == null || this.getGroupDisplayInUse() == 1) {
                    if (!this.spread) {
                        nmX = new ContinuousRangeToNumericMapper();
                    } else {
                        nmX = new JitteredContinuousRangeToNumericMapper(0.1);
                        ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).jitter.connectFrom((NumericPipe)this.jitter);
                        ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).setJitterDistance(boxSize);
                    }
                    nmX.input.connectFrom(((NumericVariable)this.outlierXVar).value);
                    if (this.orientation == 0) {
                        nmX.shareMap(xMapper);
                    } else {
                        nmX.shareMap(yMapper);
                    }
                } else {
                    NumericVector position = new NumericVector();
                    maxGroups3 = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                    double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups3);
                    this.outlierXVar.getUniqueValueCount();
                    this.outlierGVar.getUniqueValueCount();
                    for (int i16 = 0; i16 < this.outlierXVar.getValueCount(); ++i16) {
                        try {
                            double X = ((NumericVariable)this.outlierXVar).value.getValue(i16);
                            int xvalueCategory = this.getValueIndex(X);
                            double x = this.orientation == 0 ? xMapper.getValue(X) : yMapper.getValue(X);
                            String gval = ((StringVariable)this.outlierGVar).value.getValue(i16);
                            int groupCategory = (Integer)this.groupValue2Category.get(gval);
                            x -= (double)((int)(((double)this.groupsPerCategory[xvalueCategory] / 2.0 - 0.5) * groupSize));
                            position.addValue(x += groupSize * (double)this.groupCategoryLists[xvalueCategory].indexOf(groupCategory));
                            continue;
                        }
                        catch (MissingValueException e) {
                            position.addValue(Double.NaN);
                        }
                    }
                    nmX = new JitteredContinuousRangeToNumericMapper(0.0);
                    nmX.input.connectFrom(((NumericVariable)this.outlierXVar).value);
                    ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).position.connectFrom((NumericPipe)position);
                    ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).setJitterDistance(boxSize);
                    if (this.spread) {
                        ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).jitter.connectFrom((NumericPipe)this.jitter);
                    } else {
                        ((JitteredContinuousRangeToNumericMapper)((Object)nmX)).jitter.setValue(0.0);
                    }
                }
            } else if (this.groupVar == null || this.getGroupDisplayInUse() == 1) {
                if (!this.spread) {
                    nmX = new StringToNumericMapper();
                } else {
                    nmX = new JitteredStringToNumericMapper();
                    ((JitteredStringToNumericMapper)((Object)nmX)).jitter.connectFrom((NumericPipe)this.jitter);
                }
                ((StringToNumericMapper)nmX).input.connectFrom(((StringVariable)this.outlierXVar).value);
                if (this.orientation == 0) {
                    ((StringToNumericMapper)nmX).shareMap((StringToNumericMapper)this.xvalueMapper);
                } else {
                    ((StringToNumericMapper)nmX).shareMap((StringToNumericMapper)this.yvalueMapper);
                }
            } else {
                NumericVector position = new NumericVector();
                maxGroups3 = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                double groupSize = Math.round(stride * this.clusterWidth / (double)maxGroups3);
                this.outlierXVar.getUniqueValueCount();
                this.outlierGVar.getUniqueValueCount();
                for (int i17 = 0; i17 < this.outlierXVar.getValueCount(); ++i17) {
                    try {
                        String X = ((StringVariable)this.outlierXVar).value.getValue(i17);
                        int xvalueCategory = this.xvalueVar == null ? 0 : this.getValueIndex(X);
                        double x = this.orientation == 0 ? ((StringToNumericMapper)this.xvalueMapper).getValue((Object)X) : ((StringToNumericMapper)this.yvalueMapper).getValue((Object)X);
                        String gval = ((StringVariable)this.outlierGVar).value.getValue(i17);
                        int groupCategory = (Integer)this.groupValue2Category.get(gval);
                        x -= (double)((int)(((double)this.groupsPerCategory[xvalueCategory] / 2.0 - 0.5) * groupSize));
                        position.addValue(x += groupSize * (double)this.groupCategoryLists[xvalueCategory].indexOf(groupCategory));
                        continue;
                    }
                    catch (MissingValueException e) {
                        position.addValue(Double.NaN);
                    }
                }
                nmX = new JitteredStringToNumericMapper();
                ((StringToNumericMapper)nmX).input.connectFrom(((StringVariable)this.outlierXVar).value);
                ((JitteredStringToNumericMapper)((Object)nmX)).position.connectFrom((NumericPipe)position);
                ((JitteredStringToNumericMapper)((Object)nmX)).setStrideValue(boxSize);
                if (this.spread) {
                    ((JitteredStringToNumericMapper)((Object)nmX)).jitter.connectFrom((NumericPipe)this.jitter);
                } else {
                    ((JitteredStringToNumericMapper)((Object)nmX)).jitter.setValue(0.0);
                }
            }
            ColorVector outlierColorPipe = null;
            if (this.groupVar != null && this.outlierColorEncoder != null) {
                outlierColorPipe = new ColorVector();
                StringToColorMap cmap = (StringToColorMap)this.outlierColorEncoder.getValueMap();
                cmap.init(new AInitAction());
                MarkerAttrs ma = new MarkerAttrs();
                ma.setTransparency(this.markerTransparency);
                ma.setColor(this.markerColor);
                for (int i18 = 0; i18 < this.outlierGVar.getValueCount(); ++i18) {
                    Color c;
                    try {
                        String gval = ((StringVariable)this.outlierGVar).value.getValue(i18);
                        c = this.indexVar == null ? cmap.getValue(gval) : this.getIndexColor(this.outlierColorEncoder, gval, (ColorAttr)ma);
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency((ColorAttr)ma);
                    }
                    outlierColorPipe.addValue(c);
                }
            }
            IntegerVector outlierShapePipe = null;
            if (this.groupVar != null && this.shapeEncoder != null) {
                outlierShapePipe = new IntegerVector();
                HashMap ht = this.shapeEncoder.shapeList;
                int ms = -1;
                for (int i19 = 0; i19 < this.outlierGVar.getValueCount(); ++i19) {
                    try {
                        String gval = ((StringVariable)this.outlierGVar).value.getValue(i19);
                        ms = this.indexVar == null ? ((Integer)ht.get(gval)).intValue() : this.getIndexMarkerSymbol(this.shapeEncoder, gval, this.markerSymbol);
                    }
                    catch (MissingValueException e) {
                        ms = this.markerSymbol;
                    }
                    outlierShapePipe.addValue(ms);
                }
            }
            DiscreteAttrMapper discreteAttrMapper2 = groupAttrMapper2 = this.groupVar != null && this.hasAttrVar("OUTLIERGROUP") ? (DiscreteAttrMapper)this.getAttrVarMapper("OUTLIERGROUP") : null;
            if (groupAttrMapper2 != null) {
                groupAttrMapper2.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
                groupAttrMapper2.setLineTransparency(this.dataTransparency);
                groupAttrMapper2.setMarkerTransparency(this.markerTransparency < 0.0 ? this.dataTransparency : this.markerTransparency);
                groupAttrMapper2.setUseMarkerTransparency(this.useOutlierTransparency);
                groupAttrMapper2.variable = ((StringVectorVariable)this.outlierGVar).value;
                groupAttrMapper2.markerColorPipe = outlierColorPipe;
                groupAttrMapper2.markerSymbolPipe = outlierShapePipe;
                groupAttrMapper2.addMarkerSizePipe("outlier", scaledMarkerSize);
                if (this.useOutlierSize && !this.useOutlierWeight) {
                    groupAttrMapper2.addMarkerEdgeThicknessPipe("outlier", scaledMarkerSize, this.markerWeight, true);
                } else {
                    groupAttrMapper2.addMarkerEdgeThicknessPipe("outlier", scaledMarkerSize, this.markerWeight);
                }
                if (this.scaleMarkers) {
                    double ratio_h = (double)this.networkRoot.getChannel().getHeight() / (double)this.compHeight;
                    double ratio_w = (double)this.networkRoot.getChannel().getWidth() / (double)this.compWidth;
                    groupAttrMapper2.setScaleMarkers(true);
                    groupAttrMapper2.setMinMarkerSize(5);
                    groupAttrMapper2.setRatioW(ratio_w);
                    groupAttrMapper2.setRatioH(ratio_h);
                }
            }
            ColorProperty outlierColorProperty = new ColorProperty();
            if (this.outlierColorEncoder == null || this.useOutlierColor) {
                outlierColorProperty.setValue(this.applyDataTransparency(this.markerColor, this.markerTransparency));
            } else {
                outlierColorProperty.connectFrom((ColorPipe)(groupAttrMapper2 == null ? outlierColorPipe : groupAttrMapper2.markerColor));
            }
            IntegerProperty outlierSymbolProperty = new IntegerProperty();
            if (this.shapeEncoder == null || this.useOutlierSymbol) {
                outlierSymbolProperty.setValue(this.markerSymbol);
            } else {
                outlierSymbolProperty.connectFrom((IntegerPipe)(groupAttrMapper2 == null ? outlierShapePipe : groupAttrMapper2.markerSymbol));
            }
            if (this.orientation == 0) {
                outliers.coordX.connectFrom(this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)nmX));
                outliers.coordY.connectFrom((NumericPipe)nmY);
            } else {
                outliers.coordX.connectFrom((NumericPipe)nmY);
                outliers.coordY.connectFrom(this.makeOffsetCalculator(discreteOffsetValue, (NumericPipe)nmX));
            }
            if (this.isAutoBoxSize() && !this.useOutlierSize && minBoxWidth != Double.MAX_VALUE && groupAttrMapper2 == null) {
                outliers.size.setValue((int)Math.min(minBoxWidth, (double)scaledMarkerSize));
                outliers.edgeWidth.setValue(StatGraph.getMarkerEdgeWidth(scaledMarkerSize, this.markerWeight));
            } else if (this.useOutlierSize || groupAttrMapper2 == null) {
                outliers.size.setValue(scaledMarkerSize);
                if (groupAttrMapper2 != null && !this.useOutlierWeight) {
                    outliers.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper2.markerEdgeThickness.get("outlier"));
                } else {
                    outliers.edgeWidth.setValue(StatGraph.getMarkerEdgeWidth(scaledMarkerSize, this.markerWeight));
                }
            } else {
                outliers.size.connectFrom((IntegerPipe)groupAttrMapper2.markerSize.get("outlier"));
                outliers.edgeWidth.connectFrom((IntegerPipe)groupAttrMapper2.markerEdgeThickness.get("outlier"));
            }
            outliers.color.connectFrom((ColorPipe)outlierColorProperty);
            outliers.edgeColor.connectFrom((ColorPipe)outlierColorProperty);
            outliers.type.connectFrom((IntegerPipe)outlierSymbolProperty);
            outliers.setSkinType(this.skinType);
            outliers.setDPIScaleFactor((float)StatGraph.dataDPIScaleFactor);
            outliers.setPixelBenderImages(this.loadPixelBenderImages(this.networkRoot, this.skinType, 4));
            outliers.selectEnabled.setValue(this.selectable);
            outliers.setUserData((Object)this.outlierProbe);
            this.networkRoot.addElement((Element)outliers);
            if (this.labelVar != null) {
                boolean hasOutlierLabels;
                boolean bl = hasOutlierLabels = this.labels.getValueCount() > 0;
                if (hasOutlierLabels) {
                    double yUpperLimit;
                    double yLowerLimit;
                    double xUpperLimit;
                    double xLowerLimit;
                    FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
                    if (this.orientation == 0) {
                        xLowerLimit = this.xEncoder.getLowerLimit();
                        xUpperLimit = this.xEncoder.getUpperLimit();
                        yLowerLimit = this.hasStatistic ? this.yEncoder.getLowerLimit() + (double)this.bottomReservedSpace : this.yEncoder.getLowerLimit();
                        yUpperLimit = this.hasStatistic ? this.yEncoder.getUpperLimit() - (double)this.topReservedSpace : this.yEncoder.getUpperLimit();
                    } else {
                        xLowerLimit = this.yEncoder.getLowerLimit();
                        xUpperLimit = this.yEncoder.getUpperLimit();
                        yLowerLimit = this.xEncoder.getLowerLimit();
                        yUpperLimit = this.xEncoder.getUpperLimit();
                    }
                    this.layout = new OutlierLabelLayout(xLowerLimit, xUpperLimit, yLowerLimit, yUpperLimit);
                    this.layout.labelIn.connectFrom((StringPipe)this.labels);
                    this.layout.referenceValue.connectFrom((NumericPipe)this.refValues);
                    this.layout.setXMapper((NumericMapper)nmX);
                    this.layout.setYMapper(nmY);
                    this.layout.setFontMetrics(fm);
                    this.layout.setJitter(this.spread);
                    this.layout.setVertical(this.orientation == 0);
                    if (this.isAutoBoxSize() && !this.useOutlierSize && minBoxWidth != Double.MAX_VALUE) {
                        this.layout.setOutlierSize((int)Math.min(minBoxWidth, (double)scaledMarkerSize));
                    } else {
                        this.layout.setOutlierSize(scaledMarkerSize);
                    }
                    this.layout.init(new AInitAction());
                    ColorProperty dataLabelColorProperty = new ColorProperty();
                    if (this.outlierColorEncoder == null || this.useDataLabelColor) {
                        dataLabelColorProperty.setValue(this.applyDataTransparency(this.labelStyle.getColor()));
                    } else {
                        ColorVector cp = groupAttrMapper2 == null ? outlierColorPipe : groupAttrMapper2.markerColor;
                        cp.init(new AInitAction(null));
                        ColorVector lcv = new ColorVector();
                        int n2 = this.labels.getValueCount();
                        for (int i20 = 0; i20 < n2; ++i20) {
                            try {
                                if (this.labels.getValue(i20).trim().length() <= 0) continue;
                                lcv.addValue(cp.getValue(i20));
                                continue;
                            }
                            catch (MissingValueException missingValueException) {
                                // empty catch block
                            }
                        }
                        dataLabelColorProperty.connectFrom((ColorPipe)lcv);
                    }
                    RasterLabel outlierLabel = new RasterLabel();
                    if (this.orientation == 0) {
                        if (this.dataLabelSplit && this.dataLabelSplitJustify != SPLIT_JUSTIFY_AUTO) {
                            outlierLabel.transform.translateX.connectFrom(this.makeSplitLabelXOffset(this.makeOffsetCalculator(discreteOffsetValue, this.layout.x), this.layout.justification, (NumericPipe)this.splitDataLabelWidth, this.layout.getLabelCount(), this.dataLabelSplitJustify));
                            outlierLabel.horizontalJustification.setValue(this.splitJustifyToGTKJustify(this.dataLabelSplitJustify));
                        } else {
                            outlierLabel.transform.translateX.connectFrom(this.makeOffsetCalculator(discreteOffsetValue, this.layout.x));
                            outlierLabel.horizontalJustification.connectFrom(this.layout.justification);
                        }
                        outlierLabel.transform.translateY.connectFrom(this.layout.y);
                        outlierLabel.verticalJustification.setValue(1);
                    } else {
                        if (this.dataLabelSplit && this.dataLabelSplitJustify != SPLIT_JUSTIFY_AUTO) {
                            IntegerProperty just = new IntegerProperty();
                            just.setValue(1);
                            outlierLabel.transform.translateX.connectFrom(this.makeSplitLabelXOffset(this.layout.y, (IntegerPipe)just, (NumericPipe)this.splitDataLabelWidth, this.layout.getLabelCount(), this.dataLabelSplitJustify));
                            outlierLabel.horizontalJustification.setValue(this.splitJustifyToGTKJustify(this.dataLabelSplitJustify));
                        } else {
                            outlierLabel.transform.translateX.connectFrom(this.layout.y);
                            outlierLabel.horizontalJustification.setValue(1);
                        }
                        outlierLabel.transform.translateY.connectFrom(this.makeOffsetCalculator(discreteOffsetValue, this.layout.x));
                        outlierLabel.verticalJustification.connectFrom(this.layout.justification);
                    }
                    outlierLabel.color.connectFrom((ColorPipe)dataLabelColorProperty);
                    outlierLabel.fontName.setValue(this.labelStyle.getFont().getName());
                    outlierLabel.fontSize.setValue(this.labelStyle.getFont().getSize());
                    outlierLabel.fontStyle.setValue(this.labelStyle.getFont().getStyle());
                    GTKFormat fmt = this.labelFormat != null ? new GTKFormat((Format)this.labelFormat) : this.labelVar.getFormat();
                    if (fmt != null && !this.numericL && !this.dataLabelSplit) {
                        StringPipedFormat npf = new StringPipedFormat();
                        npf.setFormat(fmt);
                        npf.input.connectFrom(this.layout.label);
                        outlierLabel.string.connectFrom(npf.value);
                    } else {
                        outlierLabel.string.connectFrom(this.layout.label);
                    }
                    this.networkRoot.addElement((Element)outlierLabel);
                }
            }
        }
        if (this.isConnectOn() && this.xvalueVar != null) {
            ContinuousRangeToNumericMapper crnm = new ContinuousRangeToNumericMapper();
            if (this.orientation == 0) {
                crnm.shareMap((ContinuousRangeToNumericMapper)this.yvalueMapper);
            } else {
                crnm.shareMap((ContinuousRangeToNumericMapper)this.xvalueMapper);
            }
            switch (this.connectBy) {
                case 1: {
                    NumericVector minVector = new NumericVector();
                    for (int i21 = 0; i21 < this.extremeMin.length; ++i21) {
                        int idx0 = i21 * 7 + 0;
                        int idx1 = i21 * 7 + 1;
                        double min = this.hide[i21] ? Double.NaN : (this.graphed[idx0] ? Math.min(this.tukeyY[idx0], this.extremeMin[i21]) : Math.min(this.tukeyY[idx1], this.extremeMin[i21]));
                        minVector.addValue(min);
                    }
                    crnm.input.connectFrom((NumericPipe)minVector);
                    break;
                }
                case 2: {
                    crnm.input.connectFrom((NumericPipe)this.quartile1);
                    break;
                }
                case 3: {
                    crnm.input.connectFrom((NumericPipe)this.median);
                    break;
                }
                case 4: {
                    crnm.input.connectFrom((NumericPipe)this.quartile3);
                    break;
                }
                case 5: {
                    NumericVector maxVector = new NumericVector();
                    for (int i22 = 0; i22 < this.extremeMax.length; ++i22) {
                        int idx3 = i22 * 7 + 3;
                        int idx4 = i22 * 7 + 4;
                        double max = this.hide[i22] ? Double.NaN : (this.graphed[idx4] ? Math.max(this.tukeyY[idx4], this.extremeMax[i22]) : Math.max(this.tukeyY[idx3], this.extremeMax[i22]));
                        maxVector.addValue(max);
                    }
                    crnm.input.connectFrom((NumericPipe)maxVector);
                    break;
                }
                case 6: {
                    crnm.input.connectFrom((NumericPipe)this.mean);
                }
            }
            StringToColorMapper lineColorMapper = null;
            if (this.groupVar != null && this.lineColorEncoder != null) {
                lineColorMapper = new StringToColorMapper();
                lineColorMapper.input.connectFrom(this.tukeyGroupVar.value);
                lineColorMapper.setReplaceMissingValues(true);
                HashMap lcht = this.lineColorEncoder.colorList;
                for (int i23 = 0; i23 < nBox; ++i23) {
                    Color c;
                    try {
                        String gval = this.tukeyGroupVar.value.getValue(i23);
                        c = this.indexVar == null ? (Color)lcht.get(gval) : this.getIndexColor(this.lineColorEncoder, gval, (ColorAttr)this.lineStyle);
                        lineColorMapper.add(gval, c);
                        continue;
                    }
                    catch (MissingValueException e) {
                        c = this.applyDataTransparency(this.lineStyle.getColor());
                        lineColorMapper.setMissingReplacement(c, e.getMissingValue());
                    }
                }
            }
            StringToNumberMapper linePatternMapper = null;
            if (this.groupVar != null && this.lineEncoder != null) {
                linePatternMapper = new StringToNumberMapper();
                linePatternMapper.input.connectFrom(this.tukeyGroupVar.value);
                linePatternMapper.setReplaceMissingValues(true);
                HashMap ht = this.lineEncoder.styleList;
                for (int i24 = 0; i24 < nBox; ++i24) {
                    LineAttrs ls;
                    try {
                        String gval = this.tukeyGroupVar.value.getValue(i24);
                        ls = this.indexVar == null ? (LineAttrs)ht.get(gval) : this.getIndexLineAttrs(this.lineEncoder, gval, this.lineStyle);
                        linePatternMapper.add(gval, (Number)new Double(ls.getLinePattern()));
                        continue;
                    }
                    catch (MissingValueException e) {
                        ls = this.lineStyle;
                        linePatternMapper.setMissingReplacement((double)ls.getLinePattern(), e.getMissingValue());
                    }
                }
            }
            if (groupAttrMapper != null) {
                groupAttrMapper.lineColorMapper = lineColorMapper;
                groupAttrMapper.linePatternMapper = linePatternMapper;
            }
            LineConnector line = new LineConnector();
            line.setMultipleGroup(true);
            line.setPresortRequired(true);
            if (lineColorMapper == null || this.useConnectLineColor) {
                line.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
            } else {
                line.color.connectFrom((ColorPipe)(groupAttrMapper == null ? lineColorMapper : groupAttrMapper.lineColor));
            }
            if (this.useConnectLineSize || groupAttrMapper == null) {
                line.lineWidth.setValue((double)this.lineStyle.getWidth());
            } else {
                line.lineWidth.connectFrom((IntegerPipe)groupAttrMapper.lineThickness.get("connect"));
            }
            if (linePatternMapper == null) {
                line.setStipple(this.lineStyle.getStipplePattern(), this.lineStyle.getStippleFactor());
                line.linePattern.setValue(this.lineStyle.getLinePattern());
            } else if (this.useConnectLinePattern) {
                line.linePattern.setValue(this.lineStyle.getLinePattern());
            } else if (groupAttrMapper == null) {
                line.linePattern.connectFrom((NumericPipe)linePatternMapper);
            } else {
                line.linePattern.connectFrom((IntegerPipe)groupAttrMapper.linePattern);
            }
            line.pointZ.setValue(0.0);
            if (this.orientation == 0) {
                line.pointX.connectFrom(translatePipe);
                line.pointY.connectFrom(crnm.value);
            } else {
                line.pointX.connectFrom(crnm.value);
                line.pointY.connectFrom(translatePipe);
                line.setSkipMissingOnXAxis(true);
            }
            if (this.groupVar != null) {
                line.stringGroup.connectFrom(this.tukeyGroupVar.value);
            }
            line.setSkipMissingOn(this.connectSkipMiss);
            line.setConnectionOrder(this.connectionOrder);
            this.networkRoot.addElement((Element)line);
        }
        this.needConnect = false;
        return true;
    }

    private Color getIndexColor(ColorEncoder encoder, String groupValue, ColorAttr defaultAttr) {
        Color[] cl = encoder.colorArray;
        int gcat = (Integer)this.groupValue2Category.get(groupValue);
        int obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(gcat);
        Color c = null;
        try {
            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
            c = defaultAttr.getTransparency() < 0.0 ? this.applyDataTransparency(cl[idx % cl.length]) : Overlay.applyTransparency(cl[idx % cl.length], defaultAttr.getTransparency());
        }
        catch (MissingValueException e) {
            c = this.applyDataTransparency(defaultAttr);
        }
        return c;
    }

    private LineAttrs getIndexLineAttrs(LineEncoder encoder, String groupValue, LineAttrs defaultAttr) {
        LineAttrs[] ll = encoder.styleArray;
        int gcat = (Integer)this.groupValue2Category.get(groupValue);
        int obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(gcat);
        LineAttrs ls = null;
        try {
            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
            ls = ll[idx % ll.length];
        }
        catch (MissingValueException e) {
            ls = defaultAttr;
        }
        return ls;
    }

    private int getIndexMarkerSymbol(ShapeEncoder encoder, String groupValue, int defaultSymbol) {
        int[] sl = this.shapeEncoder.shapeArray;
        int gcat = (Integer)this.groupValue2Category.get(groupValue);
        int obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(gcat);
        int s = -1;
        try {
            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
            s = sl[idx % sl.length];
        }
        catch (MissingValueException e) {
            s = defaultSymbol;
        }
        return s;
    }

    private int getIndexFillPattern(FillPatternEncoder encoder, String groupValue, FillPatternAttrs defaultAttr) {
        int[] pat = encoder.patternArray;
        int gcat = (Integer)this.groupValue2Category.get(groupValue);
        int obs = this.groupVar instanceof StringVariable ? ((StringVariable)this.groupVar).getFirstOccurringValueIndex(gcat) : ((NumericVariable)this.groupVar).getFirstOccurringValueIndex(gcat);
        int p = -1;
        try {
            int idx = (int)((NumericVariable)this.indexVar).value.getValue(obs) - 1;
            p = pat[idx % pat.length];
        }
        catch (MissingValueException e) {
            p = defaultAttr.getPattern();
        }
        return p;
    }

    private double getDefaultIntervalBoxSize(double minInterval, PositionEncoder encoder, boolean estimate) {
        return this.getMaximumIntervalSize(minInterval, encoder, estimate);
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        ValueMap vm;
        double scale = 0.0;
        double outlierMarkerSize = this.markerSize;
        if (this.groupVar != null && this.hasAttrVar("OUTLIERGROUP")) {
            DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("OUTLIERGROUP");
            outlierMarkerSize = Math.max(outlierMarkerSize, (double)groupAttrMapper.getMaxMarkerSize());
        }
        int labelHt = 0;
        double firstBoxShift = 0.0;
        if (this.labelVar != null && this.networkRoot != null) {
            Font f = this.labelStyle.getFont();
            FontMetrics fm = StatGraph.getFontMetrics(f);
            int n = labelHt = this.dataLabelSplit ? (int)(this.maxSplitDataLabelHeight + 0.5) : fm.getHeight();
            if (this.dataLabelSplit && !this.dataLabelHasBeenSplit) {
                this.labels = this.splitDataLabels(this.labels);
            }
        }
        if (dimension == 1) {
            if (this.orientation == 0) {
                vm = this.xEncoder.getValueMap();
                if (vm instanceof StringToNumericMap) {
                    int n = Math.max(StatGraph.MPC, ((StringToNumericMap)vm).getUniqueValueCount());
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        scale = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit()) / (double)n;
                        scale += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                    } else {
                        scale = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                    }
                    if (!this.extreme && this.markersOn) {
                        scale = Math.max(scale, 1.25 * outlierMarkerSize);
                    }
                } else {
                    double boxSize;
                    if (this.intervalBoxWidth >= 0.0 && !this.boxWidthFromData && this.getGroupDisplayInUse() == 1) {
                        boxSize = this.intervalBoxWidth;
                        boxSize += (double)(2 * StatGraph.getExtraPadding());
                    } else {
                        double intvl = this.getMinimumInterval((short)10);
                        if (intvl == 0.0) {
                            boxSize = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit());
                        } else {
                            boxSize = this.getDefaultIntervalBoxSize(intvl, this.xEncoder, true);
                            if (this.getGroupDisplayInUse() == 0) {
                                int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                                double groupSize = boxSize / (double)maxGroups;
                                if (this.isAutoBoxSize() && groupSize < 5.0) {
                                    boxSize += 5.0 - groupSize;
                                } else if (this.intervalBoxWidth > groupSize) {
                                    boxSize += this.intervalBoxWidth - groupSize;
                                }
                                firstBoxShift = groupSize * (double)(maxGroups - 1);
                            }
                            boxSize += (double)(2 * StatGraph.getExtraPadding());
                        }
                        if (this.intervalBoxWidth >= 0.0) {
                            boxSize = Math.max(this.intervalBoxWidth + (double)(2 * StatGraph.getExtraPadding()), boxSize);
                        }
                    }
                    scale = !this.extreme && this.markersOn ? Math.max(boxSize, 1.25 * outlierMarkerSize + firstBoxShift) : boxSize;
                }
                scale = Math.max(scale, (double)Math.max(this.meanSize, this.medianStyle.getWidth()) * 1.25 + firstBoxShift);
                if (this.labelVar != null) {
                    double len;
                    if (this.dataLabelSplit) {
                        len = this.maxSplitDataLabelWidth;
                    } else {
                        Font f = this.labelStyle.getFont();
                        FontMetrics fm = StatGraph.getFontMetrics(f);
                        int nchars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
                        StringBuffer sb = new StringBuffer(nchars);
                        for (int i = 0; i < nchars; ++i) {
                            sb = sb.append("W");
                        }
                        len = fm.stringWidth(sb.toString());
                    }
                    scale = this.spread ? (scale += len) : Math.max(scale, len + firstBoxShift);
                }
            } else if (this.extreme || !this.markersOn) {
                scale = !this.isCapOn() ? 0.0 : 2.5 * (double)this.whiskerStyle.getWidth();
            } else {
                scale = 2.5 * outlierMarkerSize;
                if (this.labelVar != null && this.outlierXVar != null && this.outlierXVar.getValueCount() > 0) {
                    double len;
                    if (this.dataLabelSplit) {
                        len = this.maxSplitDataLabelWidth;
                    } else {
                        Font f = this.labelStyle.getFont();
                        FontMetrics fm = StatGraph.getFontMetrics(f);
                        int nchars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
                        StringBuffer sb = new StringBuffer(nchars);
                        for (int i = 0; i < nchars; ++i) {
                            sb = sb.append("W");
                        }
                        len = fm.stringWidth(sb.toString());
                    }
                    scale = Math.max(scale, len);
                }
            }
        } else if (dimension == 2) {
            if (this.orientation == 0) {
                scale = this.extreme || !this.markersOn ? (!this.isCapOn() ? 0.0 : 2.5 * (double)this.whiskerStyle.getWidth()) : 2.5 * outlierMarkerSize;
                scale = Math.max(scale, 2.0 * (double)labelHt);
            } else {
                vm = this.yEncoder.getValueMap();
                if (vm instanceof StringToNumericMap) {
                    int n = Math.max(StatGraph.MPC, ((StringToNumericMap)vm).getUniqueValueCount());
                    if (n == 0) {
                        return 0.0;
                    }
                    if (n > 1) {
                        scale = (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit()) / (double)n;
                        scale += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
                    } else {
                        scale = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                    }
                    if (!this.extreme && this.markersOn) {
                        scale = Math.max(scale, 1.25 * outlierMarkerSize);
                    }
                } else {
                    double boxSize;
                    if (this.intervalBoxWidth >= 0.0 && !this.boxWidthFromData && this.getGroupDisplayInUse() == 1) {
                        boxSize = this.intervalBoxWidth;
                        boxSize += (double)(2 * StatGraph.getExtraPadding());
                    } else {
                        double intvl = this.getMinimumInterval((short)10);
                        if (intvl == 0.0) {
                            boxSize = 0.25 * (this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit());
                        } else {
                            boxSize = this.getDefaultIntervalBoxSize(intvl, this.yEncoder, true);
                            if (this.getGroupDisplayInUse() == 0) {
                                int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
                                double groupSize = boxSize / (double)maxGroups;
                                if (this.isAutoBoxSize() && groupSize < 5.0) {
                                    boxSize += 5.0 - groupSize;
                                } else if (this.intervalBoxWidth > groupSize) {
                                    boxSize += this.intervalBoxWidth - groupSize;
                                }
                                firstBoxShift = groupSize * (double)(maxGroups - 1);
                            }
                            boxSize += (double)(2 * StatGraph.getExtraPadding());
                        }
                        if (this.intervalBoxWidth >= 0.0) {
                            boxSize = Math.max(this.intervalBoxWidth + (double)(2 * StatGraph.getExtraPadding()), boxSize);
                        }
                    }
                    scale = !this.extreme && this.markersOn ? Math.max(boxSize, 1.25 * outlierMarkerSize + firstBoxShift) : boxSize;
                }
                scale = Math.max(scale, (double)Math.max(this.meanSize, this.medianStyle.getWidth()) * 1.25 + firstBoxShift);
                if (this.labelVar != null) {
                    double len;
                    Font f = this.labelStyle.getFont();
                    FontMetrics fm = StatGraph.getFontMetrics(f);
                    double d = len = this.dataLabelSplit ? this.maxSplitDataLabelHeight : (double)fm.getHeight();
                    scale = this.spread ? (scale += len) : Math.max(scale, len + firstBoxShift);
                }
            }
        }
        return scale;
    }

    protected void connectVars() {
        ColumnMetadata cmd;
        CRD crd = this.model;
        if (crd.isAvailable(10)) {
            this.numericX = crd.getColumnClass(10) == Double.class;
            this.xvalueVar = this.discreteX || !this.numericX ? this.connectCategory((short)10, this.missingCategoryOn) : this.connectRaw((short)10, false);
            this.connectionOrder = this.orientation == 0 ? 1 : 2;
            if (!this.missingCategoryOn) {
                this.missingValueControlVar = this.connectRaw((short)10);
            }
            if (this.numericX) {
                this.missingCategoryOn = false;
                this.missingValueControlVar = this.xvalueVar;
            }
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                this.numericXVar.connectFrom(crd.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
            if (this.numericX && !this.userSetBoxScale) {
                this.boxScale = 0.85;
            }
        } else {
            this.xvalueVar = null;
            this.numericX = false;
            this.clusterWidth = 1.0;
        }
        if (crd.isAvailable(11)) {
            this.numericY = crd.getColumnClass(11) == Double.class;
            this.yvalueVar = this.connectRaw((short)11);
        } else {
            this.yvalueVar = null;
        }
        if (crd.isAvailable(5)) {
            this.numericL = crd.getColumnClass(5) == Double.class;
            this.labelVar = this.connectCategory((short)5, false);
        } else {
            this.labelVar = null;
        }
        if (crd.isAvailable(3)) {
            this.groupVar = this.connectRaw((short)3);
            this.groupVar.setFormattedValueMissingValueExceptionsEnabled(false);
            this.stringGroupVar = (StringVariable)this.connectCategory((short)3, true);
        } else {
            this.groupVar = null;
        }
        this.indexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        this.urlVar = this.connectCategory((short)52, false);
        int[] obs = null;
        int obsCount = 0;
        boolean subset = false;
        if (!this.missingCategoryOn && this.missingValueControlVar != null || !this.missingGroupOn && this.groupVar != null) {
            int count = this.missingValueControlVar != null ? this.missingValueControlVar.getValueCount() : this.groupVar.getValueCount();
            obs = new int[count];
            for (int i = 0; i < count; ++i) {
                if (!this.missingCategoryOn && this.missingValueControlVar != null && !this.missingGroupOn && this.groupVar != null) {
                    if (this.missingValueControlVar.isMissing(i) || this.groupVar.isMissing(i)) continue;
                    obs[obsCount++] = i;
                    continue;
                }
                if (this.missingValueControlVar != null && !this.missingCategoryOn && !this.missingValueControlVar.isMissing(i)) {
                    obs[obsCount++] = i;
                    continue;
                }
                if (this.groupVar == null || this.missingGroupOn || this.groupVar.isMissing(i)) continue;
                obs[obsCount++] = i;
            }
            if (obsCount < count) {
                subset = true;
            }
        }
        VariableProcessor vp = null;
        if (crd.getSortRole() == 10 && this.xvalueVar != null || this.groupVar != null && this.groupOrder != 0 && this.groupOrder != 3 || subset || crd.whereExpression != null) {
            vp = new VariableProcessor();
            if (this.xvalueVar != null) {
                vp.addVariable(this.xvalueVar);
                if (crd.getSortRole() == 10) {
                    vp.setSort(this.xvalueVar, 1);
                }
            }
            if (this.numericXVar != null) {
                vp.addVariable((Variable)this.numericXVar);
            }
            if (this.groupVar != null) {
                vp.addVariable(this.groupVar);
                if (this.getGroupOrder() == 1) {
                    this.groupVar.setUniqueValueSort(1);
                } else if (this.getGroupOrder() == 2) {
                    this.groupVar.setUniqueValueSort(2);
                }
                this.groupVar.setSortByFormattedValues(this.groupVar instanceof StringVariable);
                if (!this.missingGroupOn) {
                    this.whereRoles = new int[]{3};
                }
                vp.addVariable((Variable)this.stringGroupVar);
            }
            if (this.indexVar != null) {
                vp.addVariable(this.indexVar);
            }
            if (this.urlVar != null) {
                vp.addVariable(this.urlVar);
            }
            if (subset) {
                vp.addVariable(this.yvalueVar);
                this.addVarToVP(vp, this.labelVar);
                vp.setSubsetByObservation(obs, obsCount);
                this.model.subsetObs = obs;
                this.model.subsetObsCount = obsCount;
            }
            this.addCRDWhereClause(vp);
        }
        this.createInternalVariable();
        this.probe = new Probe();
        this.probe.setTrimOn(true);
        if (this.probeID != null) {
            this.probe.addString(this.probeIDLabel, "" + this.probeID);
        }
        if (this.urlVar != null) {
            this.probe.addPipe("_URL_", (Pipe)this.tukeyURL);
        }
        GTKFormat fmt = null;
        SASFormat sfmt = this.getFormat(11);
        fmt = sfmt == null ? new GTKFormat((Format)DataModel.defaultFormat) : new GTKFormat((Format)sfmt);
        if (this.customTips) {
            int xCount = this.xvalueVar != null ? this.xvalueVar.getUniqueValueCount() : -1;
            for (int i = 0; i < this.customTipList.length; ++i) {
                if (this.customTipList[i] == null) continue;
                if (this.statTips.contains(this.customTipList[i].toUpperCase())) {
                    SASFormat sasFmt;
                    String fName;
                    String tipRole = this.customTipList[i].toUpperCase();
                    String label = null;
                    GTKFormat tipFmt = fmt;
                    if (this.statTipLabel != null) {
                        label = (String)this.statTipLabel.get(tipRole);
                    }
                    if (this.statTipFormat != null && (fName = (String)this.statTipFormat.get(tipRole)) != null && fName.trim().length() > 0 && (sasFmt = SASFormat.getInstance((String)fName)) != null && !sasFmt.isCharacterFormat()) {
                        tipFmt = new GTKFormat((Format)sasFmt);
                    }
                    this.addStatTipPipe(tipFmt, tipRole, label);
                    continue;
                }
                int cnt = 0;
                while (this.model.isAvailable(300 + cnt)) {
                    String roleName;
                    int r = 300 + cnt;
                    String string = roleName = this.tipRoleMap != null ? (String)this.tipRoleMap.get(new Integer(r)) : null;
                    if (roleName != null && roleName.equals(this.customTipList[i].toUpperCase())) {
                        int ii;
                        cmd = this.getRoleMetadata(roleName);
                        int col = this.model.getSrcModel().getColumn(cmd.getName());
                        StringVector uniqueValue = new StringVector();
                        if (cmd.getType() == 1) {
                            NumericVectorVariable nvv = new NumericVectorVariable();
                            nvv.connectFrom(this.model.getSrcModel().getDoubleColumn(col));
                            if (vp != null) {
                                vp.addVariable((Variable)nvv);
                            }
                            if (cmd.getFormat() != null) {
                                nvv.setFormat(new GTKFormat((Format)cmd.getFormat()));
                            } else {
                                nvv.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
                            }
                            for (ii = 0; ii < nvv.getUniqueValueCount(); ++ii) {
                                try {
                                    uniqueValue.addValue(nvv.formattedUniqueValue.getValue(ii));
                                    continue;
                                }
                                catch (MissingValueException e) {
                                    uniqueValue.addValue(StatGraph.missingOption);
                                }
                            }
                        } else {
                            StringVectorVariable svv = new StringVectorVariable();
                            svv.connectFrom(this.model.getSrcModel().getStringColumn(col));
                            if (vp != null) {
                                vp.addVariable((Variable)svv);
                            }
                            if (cmd.getFormat() != null) {
                                svv.setFormat(new GTKFormat((Format)cmd.getFormat()));
                            }
                            for (ii = 0; ii < svv.getUniqueValueCount(); ++ii) {
                                try {
                                    uniqueValue.addValue(svv.formattedUniqueValue.getValue(ii));
                                    continue;
                                }
                                catch (MissingValueException e) {
                                    uniqueValue.addValue(StatGraph.missingCharacter);
                                }
                            }
                        }
                        if (xCount < 0) {
                            try {
                                this.probe.addString(cmd.getLabel(), uniqueValue.getValue(0));
                            }
                            catch (MissingValueException svv) {}
                        } else {
                            if (uniqueValue.getValueCount() != xCount) {
                                ++cnt;
                                continue;
                            }
                            if (this.groupVar == null) {
                                this.probe.addPipe(cmd.getLabel(), (Pipe)uniqueValue);
                            } else {
                                StringVector sv = new StringVector();
                                for (ii = 0; ii < uniqueValue.getValueCount(); ++ii) {
                                    try {
                                        String v = uniqueValue.getValue(ii);
                                        for (int g = 0; g < this.groupsPerCategory[ii]; ++g) {
                                            sv.addValue(v);
                                        }
                                        continue;
                                    }
                                    catch (MissingValueException missingValueException) {
                                        // empty catch block
                                    }
                                }
                                this.probe.addPipe(cmd.getLabel(), (Pipe)sv);
                            }
                        }
                    }
                    ++cnt;
                }
            }
        } else {
            String xName = "";
            if (this.xvalueVar != null) {
                xName = this.xvalueVar.getLabel();
                if (this.groupVar == null) {
                    if (this.numericX) {
                        if (((NumericVariable)this.xvalueVar).getFormat() == null) {
                            StringVector xvalPipe = new StringVector();
                            int n = this.xvalueVar.getUniqueValueCount();
                            for (int i = 0; i < n; ++i) {
                                try {
                                    xvalPipe.addValue(DataModel.defaultFormat.format((Object)((NumericVariable)this.xvalueVar).uniqueValue.getValue(i)));
                                    continue;
                                }
                                catch (MissingValueException e) {
                                    xvalPipe.addValue(StatGraph.missingOption);
                                }
                            }
                            this.probe.addPipe(xName, (Pipe)xvalPipe);
                        } else {
                            this.probe.addPipe(xName, (Pipe)((NumericVariable)this.xvalueVar).formattedUniqueValue);
                        }
                    } else {
                        this.probe.addPipe(xName, (Pipe)((StringVariable)this.xvalueVar).uniqueValue);
                    }
                } else {
                    this.probe.addPipe(xName, (Pipe)this.xPipe);
                    this.probe.addPipe(this.groupVar.getLabel(), (Pipe)this.tukeyGroupVar.value);
                }
            } else if (this.groupVar != null) {
                this.probe.addPipe(this.groupVar.getLabel(), (Pipe)this.tukeyGroupVar.value);
            }
            this.addStatTipPipe(fmt, "DATAMIN");
            this.addStatTipPipe(fmt, "MIN");
            this.addStatTipPipe(fmt, "Q1");
            this.addStatTipPipe(fmt, "MEDIAN");
            this.addStatTipPipe(fmt, "Q3");
            this.addStatTipPipe(fmt, "MAX");
            this.addStatTipPipe(fmt, "DATAMAX");
            this.addStatTipPipe(fmt, "MEAN");
            this.addStatTipPipe(fmt, "STD");
            this.addStatTipPipe(fmt, "N");
            this.addStatTipPipe(fmt, "SUMWGT");
        }
        this.outlierProbe = new Probe();
        this.outlierProbe.setTrimOn(true);
        if (this.urlVar != null) {
            this.outlierProbe.addPipe("_URL_", (Pipe)this.outlierURL);
        }
        if (this.customOutlierTips) {
            int cnt = 0;
            String[] stats = this.getSubsettedStringColumn((short)47);
            while (this.model.isAvailable(350 + cnt)) {
                int r = 350 + cnt;
                if (this.outlierTipRoleMap != null && this.outlierTipRoleMap.get(new Integer(r)) != null) {
                    int i;
                    SASFormat tipFmt;
                    String formattedMiss;
                    Object[] v;
                    String roleName = (String)this.outlierTipRoleMap.get(new Integer(r));
                    if (roleName.equals("Y")) {
                        this.outlierProbe.addPipe(this.yvalueVar.getLabel(), (Pipe)((NumericVariable)this.outlierYVar).formattedValue);
                        ++cnt;
                        continue;
                    }
                    StringVector sv = new StringVector();
                    cmd = this.getRoleMetadata(roleName);
                    if (cmd.getType() == 1) {
                        v = this.getSubsettedDoubleColumn((short)r);
                        formattedMiss = StatGraph.missingOption;
                        tipFmt = cmd.getFormat();
                        if (tipFmt != null && !tipFmt.isCharacterFormat()) {
                            formattedMiss = tipFmt.format((Object)new Double(Double.NaN)).trim();
                            if (formattedMiss == null || formattedMiss.equals(".")) {
                                formattedMiss = StatGraph.missingOption;
                            }
                        } else {
                            tipFmt = DataModel.defaultFormat;
                        }
                        for (i = 0; i < stats.length; ++i) {
                            if (!stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                            if (Double.isNaN(v[i])) {
                                sv.addValue(formattedMiss);
                                continue;
                            }
                            sv.addValue(tipFmt.format((Object)v[i]));
                        }
                    } else {
                        v = this.getSubsettedStringColumn((short)r);
                        formattedMiss = StatGraph.missingCharacter;
                        tipFmt = cmd.getFormat();
                        if (tipFmt != null && tipFmt.isCharacterFormat() && ((formattedMiss = tipFmt.format((Object)" ").trim()) == null || formattedMiss.length() == 0)) {
                            formattedMiss = StatGraph.missingCharacter;
                        }
                        for (i = 0; i < stats.length; ++i) {
                            if (!stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                            if (v[i] == null || v[i].length() == 0) {
                                sv.addValue(formattedMiss);
                                continue;
                            }
                            if (tipFmt != null) {
                                sv.addValue(tipFmt.format((Object)v[i]));
                                continue;
                            }
                            sv.addValue((String)v[i]);
                        }
                    }
                    this.outlierProbe.addPipe(cmd.getLabel(), (Pipe)sv);
                }
                ++cnt;
            }
        } else {
            if (this.xvalueVar != null) {
                String xName = this.xvalueVar.getLabel();
                if (this.numericX) {
                    this.outlierProbe.addPipe(xName, (Pipe)((NumericVariable)this.outlierXVar).formattedValue);
                } else {
                    this.outlierProbe.addPipe(xName, (Pipe)((StringVariable)this.outlierXVar).value);
                }
            }
            String yName = this.yvalueVar.getLabel();
            this.outlierProbe.addPipe(yName, (Pipe)((NumericVariable)this.outlierYVar).formattedValue);
            if (this.labelVar != null) {
                this.outlierProbe.addPipe(this.labelVar.getLabel(), (Pipe)this.allLabels);
            }
            if (this.groupVar != null) {
                this.outlierProbe.addPipe(this.groupVar.getLabel(), (Pipe)((StringVariable)this.outlierGVar).value);
            }
        }
    }

    private void addStatTipPipe(GTKFormat fmt, String stat) {
        this.addStatTipPipe(fmt, stat, null);
    }

    private void addStatTipPipe(GTKFormat fmt, String stat, String label) {
        NumericPipedFormat pipe = new NumericPipedFormat();
        pipe.setFormat(fmt);
        if (stat.equalsIgnoreCase("MIN")) {
            pipe.input.connectFrom((NumericPipe)this.minWhisker);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "min.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("Q1")) {
            pipe.input.connectFrom((NumericPipe)this.quartile1);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "q1.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("MEDIAN")) {
            pipe.input.connectFrom((NumericPipe)this.median);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "median.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("Q3")) {
            pipe.input.connectFrom((NumericPipe)this.quartile3);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "q3.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("MAX")) {
            pipe.input.connectFrom((NumericPipe)this.maxWhisker);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "max.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("MEAN")) {
            pipe.input.connectFrom((NumericPipe)this.mean);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "mean.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("STD")) {
            pipe.input.connectFrom((NumericPipe)this.std);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "std.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("N")) {
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "n.txt");
            }
            this.probe.addPipe(label, (Pipe)this.nob);
        } else if (stat.equalsIgnoreCase("SUMWGT")) {
            pipe.input.connectFrom((NumericPipe)this.sumWgtPipe);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "wgt.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("DATAMIN")) {
            pipe.input.connectFrom((NumericPipe)this.dataMinPipe);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "datamin.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        } else if (stat.equalsIgnoreCase("DATAMAX")) {
            pipe.input.connectFrom((NumericPipe)this.dataMaxPipe);
            if (label == null) {
                label = RB.getStringResource(RB_KEY, "datamax.txt");
            }
            this.probe.addPipe(label, (Pipe)pipe);
        }
    }

    public void setOutlierTipRoleMap(HashMap map) {
        this.outlierTipRoleMap = map;
    }

    private void updateNumberOfGroupPerCategory() {
        int numCats;
        NumericVariable xvar;
        if (this.groupVar == null) {
            return;
        }
        if (this.xvalueVar instanceof NumericVariable) {
            xvar = new NumericVariable();
            xvar.connectFrom((NumericVariable)this.xvalueVar);
            xvar.setFormat(((NumericVariable)this.xvalueVar).getFormat());
        } else if (this.xvalueVar instanceof StringVariable) {
            xvar = new StringVariable();
            ((StringVariable)xvar).connectFrom((StringVariable)this.xvalueVar);
            ((StringVariable)xvar).setFormat(((StringVariable)this.xvalueVar).getFormat());
        } else {
            xvar = null;
        }
        StringVariable gvar = new StringVariable();
        if (this.groupVar instanceof NumericVariable) {
            gvar.connectFrom((NumericVariable)this.groupVar);
        } else {
            gvar.connectFrom((StringVariable)this.groupVar);
        }
        VariableProcessor vp = new VariableProcessor();
        if (xvar != null) {
            vp.addVariable((Variable)xvar);
        }
        vp.addVariable((Variable)gvar);
        vp.addVariable((Variable)gvar, 0);
        if (xvar != null) {
            vp.addGroupVariable((Variable)xvar);
        }
        vp.addGroupVariable((Variable)gvar);
        if (this.model.getSrcModel().maxGroupsPerCategory == null) {
            this.model.getSrcModel().maxGroupsPerCategory = new HashMap();
        }
        this.overlayID = this.model.getColumnName((short)11) + "." + this.model.getColumnName((short)3);
        if (this.isMissingGroupOn()) {
            this.overlayID = this.overlayID + ".MissingGroup";
        }
        int maxGroups = -1;
        if (this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID) != null) {
            maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
        }
        int n = numCats = xvar == null ? 1 : xvar.getUniqueValueCount();
        if (numCats == 0) {
            return;
        }
        this.groupsPerCategory = new int[numCats];
        if (xvar == null) {
            int gCount;
            this.groupsPerCategory[0] = gCount = gvar.getUniqueValueCount();
            if (gCount > maxGroups) {
                maxGroups = gCount;
            }
        } else {
            int gCount = 1;
            int gIdx = 0;
            String catV = null;
            for (int i = 0; i < xvar.getValueCount(); ++i) {
                try {
                    String xv;
                    String string = xv = xvar instanceof StringVariable ? ((StringVariable)xvar).value.getValue(i) : xvar.formattedValue.getValue(i);
                    if (catV == null) {
                        catV = xv;
                        continue;
                    }
                    if (xv.equals(catV)) {
                        ++gCount;
                        continue;
                    }
                    this.groupsPerCategory[gIdx] = gCount;
                    if (gCount > maxGroups) {
                        maxGroups = gCount;
                    }
                    ++gIdx;
                    gCount = 1;
                    catV = xv;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            this.groupsPerCategory[gIdx] = gCount;
            if (gCount > maxGroups) {
                maxGroups = gCount;
            }
        }
        this.model.getSrcModel().maxGroupsPerCategory.put(this.overlayID, new Integer(maxGroups));
        this.groupCategoryLists = this.getGroupCategoryLists();
    }

    private ArrayList[] getGroupCategoryLists() {
        ArrayList[] list;
        block18: {
            int i5;
            int nCat;
            block17: {
                String[] gvalues = this.getGroupValues();
                int nGrp = this.groupVar.getUniqueValueCount();
                this.subToColumnGroupCategory = new int[nGrp];
                this.stringGroupVar.getUniqueValueCount();
                HashMap<String, Integer> value2ColumnCategory = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < nGrp; ++i2) {
                    try {
                        if (this.groupOrder == 0) {
                            String v = this.stringGroupVar.uniqueValue.getValue(i2);
                            int groupCategory_column = this.getGroupCategoryInDataColumn(v, gvalues);
                            value2ColumnCategory.put(v, new Integer(groupCategory_column));
                            this.subToColumnGroupCategory[i2] = groupCategory_column;
                            continue;
                        }
                        this.subToColumnGroupCategory[i2] = i2;
                        continue;
                    }
                    catch (MissingValueException v) {
                        // empty catch block
                    }
                }
                if (this.xvalueVar == null) {
                    ArrayList<Integer> list2 = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < this.groupVar.getUniqueValueCount(); ++i3) {
                        list2.add(new Integer(i3));
                    }
                    if (this.groupOrder == 1 || this.groupOrder == 2) {
                        Collections.sort(list2);
                    } else if (this.groupOrder == 3) {
                        ArrayList ll = new ArrayList();
                        for (int j = list2.size() - 1; j >= 0; --j) {
                            ll.add(list2.get(j));
                        }
                        list2 = ll;
                    }
                    return new ArrayList[]{list2};
                }
                nCat = this.xvalueVar instanceof StringVariable ? ((StringVariable)this.xvalueVar).getUniqueValueCount() : ((NumericVariable)this.xvalueVar).getUniqueValueCount();
                list = new ArrayList[nCat];
                for (int i4 = 0; i4 < nCat; ++i4) {
                    list[i4] = new ArrayList();
                }
                IntegerPipe xvalueCategory = this.xvalueVar instanceof NumericVariable ? ((NumericVariable)this.xvalueVar).category : ((StringVariable)this.xvalueVar).category;
                IntegerPipe groupCategory = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category : ((StringVariable)this.groupVar).category;
                int n = this.xvalueVar.getValueCount();
                try {
                    for (i5 = 0; i5 < n; ++i5) {
                        Integer IG;
                        int cat = xvalueCategory.getValue(i5);
                        if (list[cat].contains(IG = new Integer(groupCategory.getValue(i5)))) continue;
                        list[cat].add(IG);
                    }
                }
                catch (MissingValueException i5) {
                    // empty catch block
                }
                if (this.groupOrder != 1 && this.groupOrder != 2) break block17;
                for (i5 = 0; i5 < nCat; ++i5) {
                    Collections.sort(list[i5]);
                }
                break block18;
            }
            if (this.groupOrder != 3) break block18;
            for (i5 = 0; i5 < nCat; ++i5) {
                ArrayList ll = new ArrayList();
                for (int j = list[i5].size() - 1; j >= 0; --j) {
                    ll.add(list[i5].get(j));
                }
                list[i5] = ll;
            }
        }
        return list;
    }

    private int getGroupCategoryInDataColumn(String gv, String[] gvalues) {
        for (int g = 0; g < gvalues.length; ++g) {
            if (!gvalues[g].equals(gv)) continue;
            return g;
        }
        return -1;
    }

    private void createInternalVariable() {
        int xIdx;
        int i;
        String[] tukeyX;
        Object[] xvals;
        this.tukeyYVar = null;
        this.tukeyXVar = null;
        this.outlierYVar = null;
        this.outlierXVar = null;
        CRD crd = this.model;
        int numX = 1;
        if (this.xvalueVar != null) {
            numX = this.getSubsettedUniqueValueCount(this.xvalueVar, (short)10, this.numericX || this.numericDiscreteX);
        }
        int num = this.getSubsettedValueCount(this.yvalueVar, (short)11, true);
        double[] vals = this.getSubsettedDoubleColumn((short)11);
        String[] stats = this.getSubsettedStringColumn((short)47);
        String[] labs = null;
        if (this.labelVar != null) {
            this.allLabels = new StringVector();
            this.labels = new StringVector();
            this.refValues = new NumericVector();
            labs = this.numericL ? this.getSubsettedDoubleAsClassColumn((short)5) : this.getSubsettedStringAsClassColumn((short)5);
        }
        String[] groups = null;
        if (this.groupVar != null) {
            this.updateNumberOfGroupPerCategory();
            groups = this.groupVar instanceof NumericVariable ? this.getSubsettedDoubleAsClassColumn((short)3) : this.getSubsettedStringAsClassColumn((short)3);
        }
        String[] urls = null;
        if (this.urlVar != null) {
            urls = this.getSubsettedStringColumn((short)52);
        }
        int totalTukey = numX;
        if (this.groupVar != null) {
            totalTukey = 0;
            for (int i2 = 0; i2 < numX; ++i2) {
                totalTukey += this.groupsPerCategory[i2];
            }
        }
        Vector<Double> outliersY = new Vector<Double>();
        Vector<Object> outliersX = new Vector<Object>();
        Vector<String> outliersG = new Vector<String>();
        if (this.urlVar != null) {
            this.outlierURL = new StringVector();
        }
        this.tukeyY = new double[totalTukey * 7];
        this.graphed = new boolean[totalTukey * 7];
        for (int i3 = 0; i3 < totalTukey; ++i3) {
            for (int j = 0; j < 7; ++j) {
                this.tukeyY[i3 * 7 + j] = Double.NaN;
                this.graphed[i3 * 7 + j] = true;
            }
        }
        this.extremeMin = new double[totalTukey];
        this.extremeMax = new double[totalTukey];
        this.boxWidthScale = new double[totalTukey];
        double[] stdValues = new double[totalTukey];
        this.dataMin = new double[totalTukey];
        this.dataMax = new double[totalTukey];
        this.sumWgt = new double[totalTukey];
        String[] q1URL = new String[totalTukey];
        for (int i4 = 0; i4 < totalTukey; ++i4) {
            this.boxWidthScale[i4] = this.xvalueVar != null && this.numericX ? -1.0 : this.boxScale;
            stdValues[i4] = Double.NaN;
            this.extremeMin[i4] = Double.MAX_VALUE;
            this.extremeMax[i4] = -1.7976931348623157E308;
            this.dataMin[i4] = Double.NaN;
            this.dataMax[i4] = Double.NaN;
            this.sumWgt[i4] = Double.NaN;
            q1URL[i4] = ".";
        }
        String[] gStr = null;
        String[] xStr = null;
        if (this.groupVar != null) {
            gStr = new String[totalTukey];
            xStr = new String[totalTukey];
            this.groupValue2Category = new HashMap();
        }
        if (this.xvalueVar != null && this.numericX) {
            int xIdx2;
            xvals = this.getSubsettedDoubleColumn((short)10);
            tukeyX = (String[])new double[totalTukey * 7];
            for (i = 0; i < num; ++i) {
                int tIdx;
                if (!this.missingCategoryOn && Double.isNaN(xvals[i]) || (xIdx = this.getValueIndex(xvals[i])) < 0) continue;
                if (this.groupVar != null) {
                    int gIdx = 0;
                    int gcat = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                    gStr[xIdx] = groups[i];
                    try {
                        xStr[xIdx] = ((NumericVariable)this.xvalueVar).getFormat() == null ? DataModel.defaultFormat.format((Object)((NumericVariable)this.xvalueVar).value.getValue(i)) : ((NumericVariable)this.xvalueVar).formattedValue.getValue(i);
                    }
                    catch (MissingValueException ii) {
                        // empty catch block
                    }
                    if (!this.groupValue2Category.containsKey(groups[i])) {
                        this.groupValue2Category.put(groups[i], new Integer(gcat));
                    }
                }
                boolean blank = false;
                for (int j = 0; j < 7; ++j) {
                    tukeyX[xIdx * 7 + j] = (String)xvals[i];
                }
                if (stats[i] == null) continue;
                stats[i] = stats[i].trim();
                if (stats[i].equalsIgnoreCase("MIN")) {
                    tIdx = xIdx * 7 + 0;
                } else if (stats[i].equalsIgnoreCase("Q1")) {
                    tIdx = xIdx * 7 + 1;
                } else if (stats[i].equalsIgnoreCase("MEDIAN")) {
                    tIdx = xIdx * 7 + 2;
                } else if (stats[i].equalsIgnoreCase("Q3")) {
                    tIdx = xIdx * 7 + 3;
                } else if (stats[i].equalsIgnoreCase("MAX")) {
                    tIdx = xIdx * 7 + 4;
                } else if (stats[i].equalsIgnoreCase("MEAN")) {
                    tIdx = xIdx * 7 + 5;
                } else if (stats[i].equalsIgnoreCase("N")) {
                    tIdx = xIdx * 7 + 6;
                    blank = true;
                } else {
                    if (stats[i].equalsIgnoreCase("STD")) {
                        stdValues[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("BOXWIDTH")) {
                        if (Double.isNaN(vals[i]) || !(vals[i] > 0.0) || !(vals[i] <= 1.0)) continue;
                        this.boxWidthScale[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("SUMWGT")) {
                        this.sumWgt[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("DATAMIN")) {
                        this.dataMin[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("DATAMAX")) {
                        this.dataMax[xIdx] = vals[i];
                        continue;
                    }
                    if (!stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                    this.extremeMin[xIdx] = Math.min(vals[i], this.extremeMin[xIdx]);
                    this.extremeMax[xIdx] = Math.max(vals[i], this.extremeMax[xIdx]);
                    continue;
                }
                this.tukeyY[tIdx] = vals[i];
                if (this.urlVar == null || !stats[i].equalsIgnoreCase("Q1") || urls[i] == null) continue;
                q1URL[xIdx] = urls[i];
            }
            this.hide = this.validateTukeyBoxData(totalTukey, stdValues);
            this.outliersMap = new HashMap[totalTukey];
            for (i = 0; i < num; ++i) {
                if (!this.missingCategoryOn && Double.isNaN(xvals[i]) || (xIdx = this.getValueIndex(xvals[i])) < 0 || stats[i] == null) continue;
                int gcat = 0;
                if (this.groupVar != null) {
                    int gIdx = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException j) {
                        // empty catch block
                    }
                    xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                }
                if (this.hide[xIdx] || !stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                outliersY.add(new Double(vals[i]));
                outliersX.add(new Double(xvals[i]));
                if (this.groupVar != null) {
                    outliersG.add(groups[i]);
                }
                if (this.urlVar != null) {
                    this.outlierURL.addValue(urls[i]);
                }
                if (this.labelVar != null) {
                    if (stats[i].equalsIgnoreCase("OUTLIER")) {
                        if (this.labelFar || labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.labels.addValue("");
                        } else {
                            this.labels.addValue(labs[i]);
                        }
                    }
                    if (stats[i].equalsIgnoreCase("FAROUTLIER")) {
                        if (labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.labels.addValue("");
                        } else {
                            this.labels.addValue(labs[i]);
                        }
                    }
                    this.refValues.addValue(this.tukeyY[xIdx * 7 + 1]);
                    if (stats[i].equalsIgnoreCase("OUTLIER") || stats[i].equalsIgnoreCase("FAROUTLIER")) {
                        if (labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.allLabels.addValue("");
                        } else {
                            this.allLabels.addValue(labs[i]);
                        }
                    }
                }
                if (!this.spread) continue;
                if (this.outliersMap[xIdx] == null) {
                    this.outliersMap[xIdx] = new HashMap();
                }
                Double obj = new Double(vals[i]);
                int n2 = 1;
                if (this.outliersMap[xIdx].containsKey(obj)) {
                    n2 = (Integer)this.outliersMap[xIdx].get(obj);
                    ++n2;
                }
                this.outliersMap[xIdx].put(obj, new Integer(n2));
            }
            this.outlierXVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.outlierXVar).connectFrom(outliersX);
            this.tukeyXVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.tukeyXVar).connectFrom((double[])tukeyX);
            this.boxWidthFromData = false;
            for (i = 0; i < this.boxWidthScale.length; ++i) {
                if (!(this.boxWidthScale[i] >= 0.0)) continue;
                this.boxWidthFromData = true;
                break;
            }
        } else {
            int gcat;
            xvals = null;
            if (this.xvalueVar != null) {
                xvals = this.numericDiscreteX ? (Object[])this.getSubsettedDoubleAsClassColumn((short)10) : (Object[])this.getSubsettedStringAsClassColumn((short)10);
            }
            tukeyX = new String[totalTukey * 7];
            for (i = 0; i < num; ++i) {
                int tIdx;
                if (xvals != null && xvals[i] == null) continue;
                int n = xIdx = this.xvalueVar == null ? 0 : this.getValueIndex((String)xvals[i]);
                if (this.groupVar != null) {
                    int gIdx = 0;
                    gcat = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException n2) {
                        // empty catch block
                    }
                    int xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                    gStr[xIdx] = groups[i];
                    if (this.xvalueVar != null) {
                        xStr[xIdx] = (String)xvals[i];
                    }
                    if (!this.groupValue2Category.containsKey(groups[i])) {
                        this.groupValue2Category.put(groups[i], new Integer(gcat));
                    }
                }
                boolean blank = false;
                String X = this.xvalueVar == null ? "a" : (String)xvals[i];
                for (int j = 0; j < 7; ++j) {
                    tukeyX[xIdx * 7 + j] = X;
                }
                if (stats[i] == null) continue;
                stats[i] = stats[i].trim();
                if (stats[i].equalsIgnoreCase("MIN")) {
                    tIdx = xIdx * 7 + 0;
                } else if (stats[i].equalsIgnoreCase("Q1")) {
                    tIdx = xIdx * 7 + 1;
                } else if (stats[i].equalsIgnoreCase("MEDIAN")) {
                    tIdx = xIdx * 7 + 2;
                } else if (stats[i].equalsIgnoreCase("Q3")) {
                    tIdx = xIdx * 7 + 3;
                } else if (stats[i].equalsIgnoreCase("MAX")) {
                    tIdx = xIdx * 7 + 4;
                } else if (stats[i].equalsIgnoreCase("MEAN")) {
                    tIdx = xIdx * 7 + 5;
                } else if (stats[i].equalsIgnoreCase("N")) {
                    tIdx = xIdx * 7 + 6;
                    blank = true;
                } else {
                    if (stats[i].equalsIgnoreCase("STD")) {
                        stdValues[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("BOXWIDTH")) {
                        if (Double.isNaN(vals[i]) || !(vals[i] > 0.0) || !(vals[i] <= 1.0)) continue;
                        this.boxWidthScale[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("SUMWGT")) {
                        this.sumWgt[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("DATAMIN")) {
                        this.dataMin[xIdx] = vals[i];
                        continue;
                    }
                    if (stats[i].equalsIgnoreCase("DATAMAX")) {
                        this.dataMax[xIdx] = vals[i];
                        continue;
                    }
                    if (!stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                    this.extremeMin[xIdx] = Math.min(vals[i], this.extremeMin[xIdx]);
                    this.extremeMax[xIdx] = Math.max(vals[i], this.extremeMax[xIdx]);
                    continue;
                }
                this.tukeyY[tIdx] = vals[i];
                if (this.urlVar == null || !stats[i].equalsIgnoreCase("Q1") || urls[i] == null) continue;
                q1URL[xIdx] = urls[i];
            }
            this.hide = this.validateTukeyBoxData(totalTukey, stdValues);
            this.outliersMap = new HashMap[totalTukey];
            for (i = 0; i < num; ++i) {
                if (xvals != null && xvals[i] == null) continue;
                int n = xIdx = this.xvalueVar == null ? 0 : this.getValueIndex((String)xvals[i]);
                if (stats[i] == null) continue;
                String X = this.xvalueVar == null ? "a" : (String)xvals[i];
                gcat = 0;
                if (this.groupVar != null) {
                    int gIdx = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i) : ((StringVariable)this.groupVar).category.getValue(i);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException j) {
                        // empty catch block
                    }
                    int xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                }
                if (this.hide[xIdx] || !stats[i].equalsIgnoreCase("OUTLIER") && !stats[i].equalsIgnoreCase("FAROUTLIER")) continue;
                outliersY.add(new Double(vals[i]));
                outliersX.add(X);
                if (this.groupVar != null) {
                    outliersG.add(groups[i]);
                }
                if (this.urlVar != null) {
                    this.outlierURL.addValue(urls[i]);
                }
                if (this.labelVar != null) {
                    if (stats[i].equalsIgnoreCase("OUTLIER")) {
                        if (this.labelFar || labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.labels.addValue("");
                        } else {
                            this.labels.addValue(labs[i]);
                        }
                    }
                    if (stats[i].equalsIgnoreCase("FAROUTLIER")) {
                        if (labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.labels.addValue("");
                        } else {
                            this.labels.addValue(labs[i]);
                        }
                    }
                    this.refValues.addValue(this.tukeyY[xIdx * 7 + 1]);
                    if (stats[i].equalsIgnoreCase("OUTLIER") || stats[i].equalsIgnoreCase("FAROUTLIER")) {
                        if (labs[i] == null || this.numericL && labs[i].equals(".")) {
                            this.allLabels.addValue("");
                        } else {
                            this.allLabels.addValue(labs[i]);
                        }
                    }
                }
                if (!this.spread) continue;
                if (this.outliersMap[xIdx] == null) {
                    this.outliersMap[xIdx] = new HashMap();
                }
                Double obj = new Double(vals[i]);
                int n3 = 1;
                if (this.outliersMap[xIdx].containsKey(obj)) {
                    n3 = (Integer)this.outliersMap[xIdx].get(obj);
                    ++n3;
                }
                this.outliersMap[xIdx].put(obj, new Integer(n3));
            }
            this.outlierXVar = new StringVectorVariable();
            ((StringVectorVariable)this.outlierXVar).connectFrom(outliersX);
            ((StringVectorVariable)this.outlierXVar).setBlankMissing(false);
            this.tukeyXVar = new StringVectorVariable();
            ((StringVectorVariable)this.tukeyXVar).connectFrom(tukeyX);
            ((StringVectorVariable)this.tukeyXVar).setBlankMissing(false);
        }
        if (this.categoryOrderRole != ORDER_AUTO) {
            double[] value4sort = new double[totalTukey * 7];
            for (int i5 = 0; i5 < totalTukey; ++i5) {
                for (int j = 0; j < 7; ++j) {
                    if (this.categoryOrderRole == ORDER_MEDIAN) {
                        if (this.graphed[i5 * 7 + 2]) {
                            value4sort[i5 * 7 + j] = this.tukeyY[i5 * 7 + 2];
                            continue;
                        }
                        value4sort[i5 * 7 + j] = -1.7976931348623157E308;
                        continue;
                    }
                    if (this.categoryOrderRole != ORDER_MEAN) continue;
                    value4sort[i5 * 7 + j] = this.graphed[i5 * 7 + 5] ? this.tukeyY[i5 * 7 + 5] : -1.7976931348623157E308;
                }
            }
            this.orderVar = new NumericVectorVariable();
            ((NumericVectorVariable)this.orderVar).connectFrom(value4sort);
        }
        this.outlierYVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.outlierYVar).connectFrom(outliersY);
        this.tukeyYVar = new NumericVectorVariable();
        ((NumericVectorVariable)this.tukeyYVar).connectFrom(this.tukeyY);
        if (this.groupVar != null) {
            this.outlierGVar = new StringVectorVariable();
            ((StringVectorVariable)this.outlierGVar).connectFrom(outliersG);
            ((StringVectorVariable)this.outlierGVar).setBlankMissing(false);
            this.tukeyGroupVar.connectFrom(gStr);
            this.tukeyGroupVar.setBlankMissing(false);
        }
        this.minWhisker.removeAllValues();
        this.quartile1.removeAllValues();
        this.median.removeAllValues();
        this.quartile3.removeAllValues();
        this.maxWhisker.removeAllValues();
        this.mean.removeAllValues();
        this.nob.removeAllValues();
        this.std.removeAllValues();
        this.sumWgtPipe.removeAllValues();
        this.dataMinPipe.removeAllValues();
        this.dataMaxPipe.removeAllValues();
        this.xPipe.removeAllValues();
        if (this.urlVar != null) {
            this.tukeyURL = new StringVector();
        }
        for (int i6 = 0; i6 < this.tukeyY.length; i6 += 7) {
            int no = (int)((double)i6 / 7.0);
            if (this.graphed[i6] && !this.hide[no]) {
                this.minWhisker.addValue(this.tukeyY[i6]);
            } else {
                this.minWhisker.addValue(Double.NaN);
            }
            if (this.graphed[i6 + 1] && !this.hide[no]) {
                this.quartile1.addValue(this.tukeyY[i6 + 1]);
            } else {
                this.quartile1.addValue(Double.NaN);
            }
            if (this.graphed[i6 + 2] && !this.hide[no]) {
                this.median.addValue(this.tukeyY[i6 + 2]);
            } else {
                this.median.addValue(Double.NaN);
            }
            if (this.graphed[i6 + 3] && !this.hide[no]) {
                this.quartile3.addValue(this.tukeyY[i6 + 3]);
            } else {
                this.quartile3.addValue(Double.NaN);
            }
            if (this.graphed[i6 + 4] && !this.hide[no]) {
                this.maxWhisker.addValue(this.tukeyY[i6 + 4]);
            } else {
                this.maxWhisker.addValue(Double.NaN);
            }
            if (this.graphed[i6 + 5] && !this.hide[no]) {
                this.mean.addValue(this.tukeyY[i6 + 5]);
            } else {
                this.mean.addValue(Double.NaN);
            }
            this.std.addValue(stdValues[no]);
            this.sumWgtPipe.addValue(this.sumWgt[no]);
            this.dataMinPipe.addValue(this.dataMin[no]);
            this.dataMaxPipe.addValue(this.dataMax[no]);
            if (this.graphed[i6 + 6] && !this.hide[no]) {
                this.nob.addValue(Integer.toString(new Double(this.tukeyY[i6 + 6]).intValue()));
            } else {
                this.nob.addValue(".");
            }
            if (this.groupVar != null && this.xvalueVar != null) {
                this.xPipe.addValue(xStr[no]);
            }
            if (this.urlVar == null) continue;
            this.tukeyURL.addValue(q1URL[no]);
        }
        this.dataLabelHasBeenSplit = false;
    }

    private boolean[] validateTukeyBoxData(int numBox, double[] stdVal) {
        boolean[] hide = new boolean[numBox];
        double boxMin = Double.MAX_VALUE;
        double boxMax = -1.7976931348623157E308;
        boolean logOn = false;
        for (int i = 0; i < numBox; ++i) {
            double min = this.tukeyY[i * 7];
            double q1 = this.tukeyY[i * 7 + 1];
            double median = this.tukeyY[i * 7 + 2];
            double q3 = this.tukeyY[i * 7 + 3];
            double max = this.tukeyY[i * 7 + 4];
            double mean = this.tukeyY[i * 7 + 5];
            double n = this.tukeyY[i * 7 + 6];
            int idx = i * 7 + 1;
            if (Double.isNaN(q1) || Double.isNaN(q3) || !Double.isNaN(q1) && !Double.isNaN(q1) && q1 > q3) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            boxMin = q1;
            boxMax = q3;
            idx = i * 7;
            if (Double.isNaN(min)) {
                this.tukeyY[idx] = 0.0;
                this.graphed[idx] = false;
            } else {
                boxMin = Math.min(boxMin, min);
                boxMax = Math.max(boxMax, min);
            }
            idx = i * 7 + 2;
            if (Double.isNaN(median)) {
                this.tukeyY[idx] = 0.0;
                this.graphed[idx] = false;
            } else if (median > q3 || median < q1) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            idx = i * 7 + 4;
            if (Double.isNaN(max)) {
                this.tukeyY[idx] = 0.0;
                this.graphed[idx] = false;
            } else {
                if (max < min) {
                    hide[i] = true;
                    this.tukeyY[idx] = Double.NaN;
                    logOn = true;
                    continue;
                }
                boxMin = Math.min(boxMin, max);
                boxMax = Math.max(boxMax, max);
            }
            idx = i * 7 + 5;
            if (Double.isNaN(mean)) {
                this.tukeyY[idx] = 0.0;
                this.graphed[idx] = false;
            } else {
                boxMin = Math.min(boxMin, mean);
                boxMax = Math.max(boxMax, mean);
            }
            boxMin = Math.min(boxMin, this.extremeMin[i]);
            boxMax = Math.max(boxMax, this.extremeMax[i]);
            idx = i * 7 + 6;
            if (Double.isNaN(n)) {
                this.tukeyY[idx] = 0.0;
                this.graphed[idx] = false;
            } else if (n <= 0.0) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            if (!Double.isNaN(stdVal[i]) && stdVal[i] < 0.0) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            if (!Double.isNaN(this.sumWgt[i]) && this.sumWgt[i] <= 0.0) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            if (!Double.isNaN(this.dataMin[i]) && this.dataMin[i] > boxMin) {
                hide[i] = true;
                this.tukeyY[idx] = Double.NaN;
                logOn = true;
                continue;
            }
            if (Double.isNaN(this.dataMax[i]) || !(this.dataMax[i] < boxMax)) continue;
            hide[i] = true;
            this.tukeyY[idx] = Double.NaN;
            logOn = true;
        }
        if (logOn) {
            if (numBox == 1) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "missingbox.txt"));
            } else {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "missingboxes.txt"));
            }
        }
        return hide;
    }

    private int getValueIndex(double value) {
        int num = this.xvalueVar.getUniqueValueCount();
        int index = -1;
        if (((NumericVariable)this.xvalueVar).getFormat() == null) {
            NumericPipe np = ((NumericVariable)this.xvalueVar).uniqueValue;
            try {
                for (int i = 0; i < num; ++i) {
                    if (value != np.getValue(i)) continue;
                    return i;
                }
            }
            catch (MissingValueException i) {}
        } else {
            String formattedValue = ((NumericVariable)this.xvalueVar).getFormat().format((Object)new Double(value));
            StringPipe sp = ((NumericVariable)this.xvalueVar).formattedUniqueValue;
            try {
                for (int i = 0; i < num; ++i) {
                    if (!formattedValue.equals(sp.getValue(i))) continue;
                    return i;
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return index;
    }

    private int getValueIndex(String value) {
        StringPipe sp = ((StringVariable)this.xvalueVar).uniqueValue;
        int num = this.xvalueVar.getUniqueValueCount();
        int index = -1;
        try {
            for (int i = 0; i < num; ++i) {
                if (!value.trim().equals(sp.getValue(i).trim())) continue;
                return i;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return index;
    }

    protected void makeElements() {
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    public boolean isExtreme() {
        return this.extreme;
    }

    public void setExtreme(boolean b) {
        this.extreme = b;
    }

    public boolean isNotched() {
        return this.notched;
    }

    public void setNotched(boolean b) {
        this.notched = b;
    }

    public boolean isMarkersOn() {
        return this.markersOn;
    }

    public void setMarkersOn(boolean b) {
        this.markersOn = b;
    }

    public boolean isSpread() {
        return this.spread;
    }

    public void setSpread(boolean b) {
        this.spread = b;
    }

    public double getBoxWidth() {
        return this.boxScale;
    }

    public void setBoxWidth(double w) {
        this.boxScale = w;
    }

    public void setUserBoxScale(boolean b) {
        this.userSetBoxScale = true;
    }

    public double getIntervalBoxWidth() {
        return this.intervalBoxWidth;
    }

    public void setIntervalBoxWidth(double w) {
        this.intervalBoxWidth = w * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
    }

    public int getCapShape() {
        return this.capShape;
    }

    public void setCapShape(int shape) {
        this.capShape = shape;
    }

    public boolean isCapOn() {
        return this.capOn;
    }

    public void setCapOn(boolean on) {
        this.capOn = on;
    }

    public Color getMedianColor() {
        return this.medianColor;
    }

    public void setMedianColor(Color c) {
        this.medianColor = c;
    }

    public int getMedianSymbol() {
        return this.medianSymbol;
    }

    public void setMedianSymbol(int s) {
        this.medianSymbol = s;
    }

    public int getMedianSize() {
        return this.medianSize;
    }

    public void setMedianSize(int s) {
        this.medianSize = s;
    }

    public LineAttrs getMedianStyle() {
        return this.medianStyle;
    }

    public void setMedianStyle(LineAttrs ls) {
        this.medianStyle = ls;
    }

    public boolean isMedianOn() {
        return this.medianOn;
    }

    public void setMedianOn(boolean on) {
        this.medianOn = on;
    }

    public Color getMeanColor() {
        return this.meanColor;
    }

    public void setMeanColor(Color c) {
        this.meanColor = c;
    }

    public int getMeanSymbol() {
        return this.meanSymbol;
    }

    public void setMeanSymbol(int s) {
        this.meanSymbol = s;
    }

    public int getMeanSize() {
        return this.meanSize;
    }

    public void setMeanSize(int s) {
        this.meanSize = s;
    }

    public int getMeanWeight() {
        return this.meanWeight;
    }

    public void setMeanWeight(int w) {
        this.meanWeight = w;
    }

    public boolean isMeanOn() {
        return this.meanOn;
    }

    public void setMeanOn(boolean on) {
        this.meanOn = on;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setMarkerColor(Color c) {
        this.markerColor = c;
    }

    public int getMarkerSymbol() {
        return this.markerSymbol;
    }

    public void setMarkerSymbol(int s) {
        this.markerSymbol = s;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int s) {
        this.markerSize = s;
    }

    public int getMarkerWeight() {
        return this.markerWeight;
    }

    public void setMarkerWeight(int w) {
        this.markerWeight = w;
    }

    public boolean isFillPatternOn() {
        return this.fillPatternOn;
    }

    public void setFillPatternOn(boolean b) {
        this.fillPatternOn = b;
    }

    public void setFillPatternStyle(FillPatternAttrs fps) {
        this.fillPatternStyle = fps;
    }

    public FillPatternAttrs getFillPatternStyle() {
        return this.fillPatternStyle;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean b) {
        this.fillOn = b;
    }

    public void setFillStyle(FillAttrs fs) {
        this.fillStyle = fs;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public LineAttrs getOutlineStyle() {
        return this.outlineStyle;
    }

    public void setOutlineStyle(LineAttrs ls) {
        this.outlineStyle = ls;
    }

    public LineAttrs getWhiskerStyle() {
        return this.whiskerStyle;
    }

    public void setWhiskerStyle(LineAttrs ls) {
        this.whiskerStyle = ls;
    }

    public boolean isWhiskersOn() {
        return this.whiskersOn;
    }

    public void setWhiskersOn(boolean b) {
        this.whiskersOn = b;
    }

    public LineAttrs getCapStyle() {
        return this.capStyle;
    }

    public void setCapStyle(LineAttrs ls) {
        this.capStyle = ls;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        this.orientation = orient;
    }

    public int getConnectBy() {
        return this.connectBy;
    }

    public void setConnectBy(int by) {
        this.connectBy = by;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineAttrs ls) {
        this.lineStyle = ls;
    }

    public boolean isConnectOn() {
        return this.connectOn;
    }

    public void setConnectOn(boolean on) {
        this.connectOn = on;
    }

    @Override
    public boolean isDiscreteX() {
        return this.discreteX;
    }

    @Override
    public void setDiscreteX(boolean b) {
        this.discreteX = b;
    }

    public boolean isLabelFar() {
        return this.labelFar;
    }

    public void setLabelFar(boolean far) {
        this.labelFar = far;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle ts) {
        this.labelStyle = ts;
    }

    public SASFormat getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(SASFormat format) {
        this.labelFormat = format;
    }

    public String[] getXValues() {
        if (this.xvalueVar == null) {
            return new String[]{"a"};
        }
        int num = this.numericX ? ((NumericVariable)this.xvalueVar).getUniqueValueCount() : ((StringVariable)this.xvalueVar).getUniqueValueCount();
        String[] values = new String[num];
        StringPipe uniqueValues = this.numericX ? ((NumericVariable)this.xvalueVar).formattedValue : ((StringVariable)this.xvalueVar).uniqueValue;
        try {
            for (int i = 0; i < num; ++i) {
                values[i] = uniqueValues.getValue(i);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return values;
    }

    public double[] getDoubleXValues() {
        int num = ((NumericVariable)this.xvalueVar).getUniqueValueCount();
        ArrayList<Double> al = new ArrayList<Double>();
        try {
            for (int i = 0; i < num; ++i) {
                al.add(((NumericVariable)this.xvalueVar).uniqueValue.getValue(i));
            }
        }
        catch (MissingValueException i) {
            // empty catch block
        }
        num = al.size();
        double[] values = new double[num];
        for (int i = 0; i < num; ++i) {
            values[i] = (Double)al.get(i);
        }
        return values;
    }

    public ContinuousRange getDoubleXValueRange() {
        return (ContinuousRange)this.xRange;
    }

    public boolean isContinuousBox() {
        return this.xvalueVar != null && this.xvalueVar instanceof NumericVariable;
    }

    public String[] getNumberOfObservations() {
        int num = this.xvalueVar == null ? 1 : (this.numericX ? ((NumericVariable)this.xvalueVar).getUniqueValueCount() : ((StringVariable)this.xvalueVar).getUniqueValueCount());
        StringVector sp = this.nob;
        String[] values = new String[num];
        for (int i = 0; i < num; ++i) {
            try {
                values[i] = sp.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                values[i] = ".";
            }
        }
        return values;
    }

    public double[] getStatistics(String statName) {
        double r;
        int i;
        NumericVector np = null;
        if (statName.equalsIgnoreCase("MIN")) {
            np = this.minWhisker;
        } else if (statName.equalsIgnoreCase("Q1")) {
            np = this.quartile1;
        } else if (statName.equalsIgnoreCase("MEDIAN")) {
            np = this.median;
        } else if (statName.equalsIgnoreCase("Q3")) {
            np = this.quartile3;
        } else if (statName.equalsIgnoreCase("MAX")) {
            np = this.maxWhisker;
        } else if (statName.equalsIgnoreCase("MEAN")) {
            np = this.mean;
        } else if (statName.equalsIgnoreCase("STD")) {
            np = this.std;
        } else if (statName.equalsIgnoreCase("SUMWGT")) {
            np = this.sumWgtPipe;
        } else if (statName.equalsIgnoreCase("DATAMIN")) {
            np = this.dataMinPipe;
        } else if (statName.equalsIgnoreCase("DATAMAX")) {
            np = this.dataMaxPipe;
        } else if (statName.equalsIgnoreCase("RANGE")) {
            np = new NumericVector();
            for (i = 0; i < this.minWhisker.size(); ++i) {
                try {
                    r = this.maxWhisker.getValue(i) - this.minWhisker.getValue(i);
                }
                catch (MissingValueException mve) {
                    r = Double.NaN;
                }
                np.addValue(r);
            }
        } else if (statName.equalsIgnoreCase("IQR")) {
            np = new NumericVector();
            for (i = 0; i < this.quartile1.size(); ++i) {
                try {
                    r = this.quartile3.getValue(i) - this.quartile1.getValue(i);
                }
                catch (MissingValueException mve) {
                    r = Double.NaN;
                }
                np.addValue(r);
            }
        } else {
            return null;
        }
        int num = this.xvalueVar == null ? 1 : (this.numericX ? ((NumericVariable)this.xvalueVar).getUniqueValueCount() : ((StringVariable)this.xvalueVar).getUniqueValueCount());
        double[] values = new double[num];
        for (i = 0; i < num; ++i) {
            try {
                values[i] = np.getValue(i);
                continue;
            }
            catch (MissingValueException e) {
                values[i] = Double.NaN;
            }
        }
        return values;
    }

    public void setBlockOverlays(Overlay[] blocks) {
        this.blockOverlays = blocks;
        this.hasStatistic = true;
    }

    public Overlay[] getBlockOverlays() {
        return this.blockOverlays;
    }

    @Override
    public int[] getLinePatterns() {
        if (this.groupVar == null || this.lineEncoder == null || this.useOutlinePattern) {
            return new int[]{this.outlineStyle.getLinePattern()};
        }
        HashMap ht = this.lineEncoder.styleList;
        String[] values = this.getGroupValues();
        int[] patterns = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            DiscreteAttrMapper groupAttrMapper;
            int p;
            String gval = values[i];
            patterns[i] = -1;
            if (this.hasAttrVar("TUKEYGROUP") && (p = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLinePattern(gval)) >= 0) {
                patterns[i] = p;
            }
            if (patterns[i] >= 0) continue;
            LineAttrs la = this.indexVar == null ? (LineAttrs)ht.get(gval) : this.getIndexLineAttrs(this.lineEncoder, gval, this.outlineStyle);
            patterns[i] = la.getLinePattern();
        }
        return patterns;
    }

    @Override
    public int[] getLineWidths() {
        if (this.useOutlineSize || !this.hasAttrVar("TUKEYGROUP")) {
            return new int[]{this.outlineStyle.getWidth()};
        }
        return this.getDAttrLineThickness("TUKEYGROUP", this.getGroupValues(), this.outlineStyle.getWidth());
    }

    @Override
    public Color[] getLineColors() {
        if (this.groupVar == null || this.useOutlineColor) {
            return new Color[]{this.applyDataTransparency(this.outlineStyle.getColor())};
        }
        return this.getGroupColors(false);
    }

    @Override
    public Color[] getFillColors() {
        if (this.fillOn) {
            if (this.groupVar == null || this.useFillColor) {
                return new Color[]{this.applyDataTransparency((ColorAttr)this.fillStyle)};
            }
            return this.getGroupColors(true);
        }
        return new Color[0];
    }

    @Override
    public int[] getFillPatterns() {
        if (!this.isFillPatternOn()) {
            return new int[0];
        }
        if (this.groupVar == null || this.fillPatternEncoder == null || this.useFillPattern) {
            return new int[]{this.fillPatternStyle.getPattern()};
        }
        HashMap ht = this.fillPatternEncoder.patternList;
        String[] values = this.getGroupValues();
        int[] patterns = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            String gval = values[i];
            patterns[i] = this.indexVar == null ? ((Integer)ht.get(gval)).intValue() : this.getIndexFillPattern(this.fillPatternEncoder, gval, this.fillPatternStyle);
        }
        return patterns;
    }

    @Override
    public Color[] getFillPatternColors() {
        if (this.fillPatternOn) {
            if (this.groupVar == null || this.useFillPatternColor) {
                return new Color[]{this.applyDataTransparency((ColorAttr)this.fillPatternStyle)};
            }
            HashMap ht = this.fillPatternColorEncoder.colorList;
            String[] values = this.getGroupValues();
            Color[] colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLineColor(gval)) != null) {
                    colors[i] = this.applyDataTransparency(c);
                }
                if (colors[i] != null) continue;
                colors[i] = this.indexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.fillPatternColorEncoder, gval, (ColorAttr)this.fillPatternStyle);
            }
            return colors;
        }
        return new Color[0];
    }

    @Override
    public String[] getUniqueValues(short role) {
        StringVectorVariable group = (StringVectorVariable)this.connectCategory(role, true);
        VariableProcessor vp = new VariableProcessor();
        vp.addVariable((Variable)group);
        if (this.groupVar != null) {
            Variable rawGroup = this.connectRaw((short)3);
            vp.addVariable(rawGroup);
            if (this.getGroupOrder() != 0 && this.getGroupOrder() != 3) {
                int sort;
                int n = sort = this.getGroupOrder() == 1 ? 1 : 2;
                if (this.groupVar instanceof NumericVariable) {
                    vp.setSort(rawGroup, sort);
                } else {
                    vp.setSort((Variable)group, sort);
                }
            }
            if (!this.missingGroupOn) {
                vp.setWhereExpression("^(" + rawGroup.getName() + " IS MISSING)");
            }
        }
        String[] gv = new String[group.getUniqueValueCount()];
        for (int i = 0; i < gv.length; ++i) {
            try {
                if (this.groupOrder == 3) {
                    gv[i] = group.uniqueValue.getValue(gv.length - 1 - i);
                    continue;
                }
                gv[i] = group.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    @Override
    public String[] getGroupValues() {
        if (this.groupVar != null) {
            if (this.groupOrder == 0 || this.groupOrder == 3) {
                return this.getUniqueGroupValues((short)3);
            }
            return this.getUniqueGroupValues((short)3, this.groupOrder == 1 ? 1 : 2);
        }
        return new String[0];
    }

    public Color[] getGroupColors(boolean fill) {
        Color[] colors = new Color[]{};
        if (fill) {
            HashMap ht = this.colorEncoder.colorList;
            String[] values = this.getGroupValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getFillColor(gval)) != null) {
                    colors[i] = this.useFillTransparency ? this.applyDataTransparency(c, this.fillStyle.getTransparency()) : BoxOverlay.applyTransparency(c, groupAttrMapper.getFillTransparency(gval));
                }
                if (colors[i] != null) continue;
                colors[i] = this.indexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.colorEncoder, gval, (ColorAttr)this.fillStyle);
            }
        } else {
            HashMap ht = this.lineColorEncoder.colorList;
            String[] values = this.getGroupValues();
            colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getLineColor(gval)) != null) {
                    colors[i] = this.applyDataTransparency(c);
                }
                if (colors[i] != null) continue;
                colors[i] = this.indexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.lineColorEncoder, gval, (ColorAttr)this.outlineStyle);
            }
        }
        return colors;
    }

    public Color[] getMarkerColors(String[] values) {
        if (this.meanOn) {
            if (this.groupVar == null || this.useMeanColor) {
                return new Color[]{this.applyDataTransparency(this.meanColor, this.meanTransparency)};
            }
            MarkerAttrs ma = new MarkerAttrs();
            ma.setColor(this.meanColor);
            ma.setTransparency(this.meanTransparency);
            HashMap ht = this.meanColorEncoder.colorList;
            Color[] colors = new Color[values.length];
            for (int i = 0; i < values.length; ++i) {
                DiscreteAttrMapper groupAttrMapper;
                Color c;
                String gval = values[i];
                if (this.hasAttrVar("TUKEYGROUP") && (c = (groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP")).getMarkerColor(gval)) != null) {
                    colors[i] = this.useMeanTransparency ? this.applyDataTransparency(c, this.meanTransparency) : BoxOverlay.applyTransparency(c, groupAttrMapper.getMarkerTransparency(gval));
                }
                if (colors[i] != null) continue;
                colors[i] = this.indexVar == null ? (Color)ht.get(gval) : this.getIndexColor(this.meanColorEncoder, gval, (ColorAttr)ma);
            }
            return colors;
        }
        return new Color[0];
    }

    public int[] getMarkerShapes(String[] values) {
        if (this.meanOn) {
            if (this.groupVar == null || this.useMeanSymbol) {
                return new int[]{this.meanSymbol};
            }
            HashMap ht = this.shapeEncoder.shapeList;
            int[] shapes = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                String gval = values[i];
                int s = -1;
                if (this.hasAttrVar("TUKEYGROUP")) {
                    DiscreteAttrMapper groupAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("TUKEYGROUP");
                    s = groupAttrMapper.getMarkerSymbol(gval);
                }
                if (s < 0) {
                    s = this.indexVar == null ? ((Integer)ht.get(gval)).intValue() : this.getIndexMarkerSymbol(this.shapeEncoder, gval, this.meanSymbol);
                }
                shapes[i] = s;
            }
            return shapes;
        }
        return new int[0];
    }

    public int[] getMarkerWidths(String[] values) {
        if (this.groupVar == null || this.useMeanSize || !this.hasAttrVar("TUKEYGROUP")) {
            int[] ms = new int[]{this.meanSize};
            return ms;
        }
        return this.getDAttrMarkerSize("TUKEYGROUP", values, this.meanSize);
    }

    public int[] getMarkerWeights(String[] values) {
        if (this.groupVar == null || this.useMeanWeight || !this.hasAttrVar("TUKEYGROUP")) {
            int[] wt = new int[]{this.meanWeight};
            return wt;
        }
        return this.getDAttrMarkerWeight("TUKEYGROUP", values, this.meanWeight);
    }

    @Override
    public boolean hasLegend(int attrType) {
        switch (attrType) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 9: {
                return this.meanOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        return this.fillOn ? 11 : 10;
    }

    @Override
    protected void applyDataSkin(LegendItem[] items) {
        if (!this.fillOn || this.skinType == 0) {
            return;
        }
        Image legendSkin = this.loadLegendSkinImage();
        Image[] legendPixelBender = this.loadLegendPixelBenderImages();
        for (int i = 0; i < items.length; ++i) {
            items[i].setPixelBenderImages(legendPixelBender);
            items[i].setSkinType(this.skinType);
            items[i].setSkinImage(legendSkin);
        }
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        int[] shape;
        if (this.isLegendEntryFromAttrMap("TUKEYGROUP")) {
            return this.getLegendItemsWithAttrMap("TUKEYGROUP", this.fixDefaultAttrType(attrType));
        }
        if (attrType != 9) {
            return super.getLegendItems(attrType);
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        String[] values = this.getGroupValues();
        if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            values = new String[]{this.getLegendLabel()};
        }
        if ((shape = this.getMarkerShapes(values)).length == 0) {
            return null;
        }
        Color[] color = this.getMarkerColors(values);
        int[] size = this.getMarkerWidths(values);
        int[] weight = this.getMarkerWeights(values);
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null, this.skinImage, this.skinType, legendPixelBender);
        }
        return entries;
    }

    @Override
    public LegendItem[] getLegendItemsWithAttrMap(DiscreteAttrMapper attrMapper, int attrType) {
        if (attrMapper == null || attrMapper.getAttrMap().getAllSize() <= 0) {
            return null;
        }
        if (attrType != 9) {
            return super.getLegendItemsWithAttrMap(attrMapper, attrType);
        }
        if (this.skinType != 0) {
            this.checkDataSkin();
        }
        Image[] legendPixelBender = this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 4);
        String[] values = this.getGroupValues();
        String[] attrMapValues = attrMapper.getAttrMap().getAllValues();
        int[] attrMapValueIndices = BoxOverlay.getAttrMapValueIndexInGroup(attrMapValues, values);
        int[] shape = this.getMarkerShapes(values);
        if (shape.length == 0) {
            return null;
        }
        if (this.meanOn && this.groupVar != null && !this.useMeanSymbol) {
            shape = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, shape, 0, this.meanSymbol);
        }
        Color[] color = this.getMarkerColors(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanColor) {
            color = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, color, 10, this.meanColor, this.meanTransparency, this.useMeanTransparency);
        }
        int[] size = this.getMarkerWidths(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanSize) {
            size = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, size, 1, this.meanSize);
        }
        int[] weight = this.getMarkerWeights(values);
        if (this.meanOn && this.groupVar != null && !this.useMeanWeight) {
            weight = this.margeAttrMapWithGroupAttrs(attrMapper, attrMapValues, attrMapValueIndices, weight, 2, this.meanWeight);
        }
        int n = attrMapValues.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            MarkerAttrs attr = new MarkerAttrs();
            attr.setShape(shape[i % shape.length]);
            if (color.length > 0) {
                attr.setColor(color[i % color.length]);
            }
            if (size.length > 0) {
                attr.setSize(size[i % size.length]);
            }
            if (weight.length > 0) {
                attr.setWeight(weight[i % weight.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, null, attrMapValues[i], null, this.skinImage, this.skinType, legendPixelBender);
        }
        return entries;
    }

    @Override
    protected boolean isMargeAttrMapRequired(int type) {
        switch (type) {
            case 12: {
                return this.fillOn && this.groupVar != null && !this.useFillColor;
            }
            case 11: {
                return this.groupVar != null && !this.useOutlineColor;
            }
            case 3: {
                return this.groupVar != null && this.lineEncoder != null && !this.useOutlinePattern;
            }
            case 5: {
                return this.fillPatternOn && this.groupVar != null && !this.useFillPattern;
            }
            case 14: {
                return this.fillPatternOn && this.groupVar != null && !this.useFillPatternColor;
            }
            case 4: {
                return !this.useOutlineSize;
            }
        }
        return false;
    }

    @Override
    protected FillAttrs getAttrMapDefaultFillAttrs() {
        return this.fillStyle;
    }

    @Override
    protected LineAttrs getAttrMapDefaultLineAttrs() {
        return this.outlineStyle;
    }

    @Override
    protected FillPatternAttrs getAttrMapDefaultFillPatternAttrs() {
        return this.fillPatternStyle;
    }

    @Override
    public void updateNetworkElements() {
        if (!this.numericX) {
            if (this.orientation == 0) {
                ValueMap map = this.xEncoder.getValueMap();
                double stride = ((StringToNumericMap)map).getStrideValue();
                double boxWidth = stride * this.boxScale;
                if (boxWidth % 2.0 == 0.0) {
                    boxWidth -= 1.0;
                }
                this.tBox.boxWidth.setValue(boxWidth);
            } else {
                ValueMap map = this.yEncoder.getValueMap();
                double stride = ((StringToNumericMap)map).getStrideValue();
                double boxWidth = stride * this.boxScale;
                if (boxWidth % 2.0 == 0.0) {
                    boxWidth -= 1.0;
                }
                this.tBox.boxWidth.setValue(boxWidth);
            }
        }
        if (this.layout != null) {
            this.layout.doLayout();
        }
    }

    public double getDiscreteOffset() {
        return this.discreteOffset;
    }

    public void setDiscreteOffset(double offset) {
        this.discreteOffset = offset;
    }

    public void updateBoxScale(double w) {
        int i;
        this.boxScale = w;
        int numX = 1;
        if (this.xvalueVar != null) {
            numX = this.getSubsettedUniqueValueCount(this.xvalueVar, (short)10, this.numericX || this.numericDiscreteX);
        }
        int num = this.getSubsettedValueCount(this.yvalueVar, (short)11, true);
        double[] vals = this.getSubsettedDoubleColumn((short)11);
        String[] stats = this.getSubsettedStringColumn((short)47);
        int totalTukey = numX;
        if (this.groupVar != null) {
            totalTukey = 0;
            for (i = 0; i < numX; ++i) {
                totalTukey += this.groupsPerCategory[i];
            }
        }
        this.boxWidthScale = new double[totalTukey];
        for (i = 0; i < totalTukey; ++i) {
            this.boxWidthScale[i] = this.boxScale;
        }
        if (this.xvalueVar != null && this.numericX) {
            double[] xvals = this.getSubsettedDoubleColumn((short)10);
            for (int i2 = 0; i2 < num; ++i2) {
                if (!this.missingCategoryOn && Double.isNaN(xvals[i2])) continue;
                int xIdx = this.getValueIndex(xvals[i2]);
                if (this.groupVar != null) {
                    int gIdx = 0;
                    int gcat = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i2) : ((StringVariable)this.groupVar).category.getValue(i2);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                    int xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                }
                if (stats[i2] == null) continue;
                stats[i2] = stats[i2].trim();
                if (!stats[i2].equalsIgnoreCase("BOXWIDTH") || Double.isNaN(vals[i2]) || !(vals[i2] > 0.0) || !(vals[i2] <= 1.0)) continue;
                this.boxWidthScale[xIdx] = vals[i2];
            }
        } else {
            String[] xvals = null;
            if (this.xvalueVar != null) {
                xvals = this.numericDiscreteX ? this.getSubsettedDoubleAsClassColumn((short)10) : this.getSubsettedStringAsClassColumn((short)10);
            }
            for (int i3 = 0; i3 < num; ++i3) {
                int xIdx;
                if (xvals != null && xvals[i3] == null) continue;
                int n = xIdx = this.xvalueVar == null ? 0 : this.getValueIndex(xvals[i3]);
                if (this.groupVar != null) {
                    int gIdx = 0;
                    int gcat = 0;
                    try {
                        gcat = this.groupVar instanceof NumericVariable ? ((NumericVariable)this.groupVar).category.getValue(i3) : ((StringVariable)this.groupVar).category.getValue(i3);
                        gIdx = this.groupCategoryLists[xIdx].indexOf(gcat);
                    }
                    catch (MissingValueException xIdx2) {
                        // empty catch block
                    }
                    int xIdx2 = 0;
                    for (int ii = 0; ii < xIdx; ++ii) {
                        xIdx2 += this.groupsPerCategory[ii];
                    }
                    xIdx = xIdx2 + gIdx;
                }
                if (stats[i3] == null) continue;
                stats[i3] = stats[i3].trim();
                if (!stats[i3].equalsIgnoreCase("BOXWIDTH") || Double.isNaN(vals[i3]) || !(vals[i3] > 0.0) || !(vals[i3] <= 1.0)) continue;
                this.boxWidthScale[xIdx] = vals[i3];
            }
        }
    }

    private void loadSkinImage() {
        if (this.dataTransparency == 1.0) {
            this.skinImage = null;
            return;
        }
        if (!this.isFillOn() || this.isExtrudedOverlay()) {
            this.skinType = 0;
        }
        this.skinImage = this.getRectangularSkinImage(this.networkRoot, this.skinType, this.orientation == 0);
        this.pixelBenderImages = this.loadPixelBenderImages(this.networkRoot, this.skinType, this.orientation == 0 ? 1 : 2);
    }

    @Override
    protected Image loadLegendSkinImage() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.getLegendSkinImage(this.networkRoot, this.skinType);
    }

    @Override
    protected Image[] loadLegendPixelBenderImages() {
        if (!this.isFillOn() || this.isExtrudedOverlay() || this.dataTransparency == 1.0) {
            return null;
        }
        return this.loadLegendPixelBenderImages(this.networkRoot, this.skinType, 1);
    }

    private StringVector splitDataLabels(StringVector label) {
        StringVector sp = label;
        if (this.labelVar.getFormat() != null && !this.numericL) {
            StringPipedFormat npf = new StringPipedFormat();
            npf.setFormat(this.labelVar.getFormat());
            npf.input.connectFrom(this.layout.label);
            sp = npf;
        }
        sp.init(new AInitAction(null));
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        StringVector sLabel = new StringVector();
        this.splitDataLabelHeight = new NumericVector();
        this.splitDataLabelWidth = new NumericVector();
        int num = label.getValueCount();
        this.maxSplitDataLabelWidth = 0.0;
        this.maxSplitDataLabelHeight = 0.0;
        for (int i = 0; i < num; ++i) {
            try {
                String s = sp.getValue(i);
                s = BoxOverlay.makeMultiLineLabel(BoxOverlay.splitLabel(s, true, -1.0, this.dataLabelSplitCharDrop, this.dataLabelSplitChar, fm), false);
                sLabel.addValue(s);
                double h = BoxOverlay.getTextHeight(fm, s);
                double w = BoxOverlay.getTextWidth(fm, s);
                this.splitDataLabelWidth.addValue(w);
                this.splitDataLabelHeight.addValue(h);
                this.maxSplitDataLabelWidth = Math.max(this.maxSplitDataLabelWidth, w);
                this.maxSplitDataLabelHeight = Math.max(this.maxSplitDataLabelHeight, h);
                continue;
            }
            catch (MissingValueException e) {
                sLabel.addValue("");
                this.splitDataLabelHeight.addValue(0.0);
                this.splitDataLabelWidth.addValue(0.0);
            }
        }
        this.dataLabelHasBeenSplit = true;
        return sLabel;
    }

    @Override
    public boolean isOneDimensional() {
        return this.xvalueVar == null;
    }

    @Override
    public boolean isDataOnHorizontalSide() {
        return this.orientation != 0;
    }

    @Override
    public int getPreferredSizeOnDataLessSide() {
        int dls = 5 * Math.max(this.meanSize, this.markerSize);
        if (this.isOneDimensional()) {
            for (int i = 0; i < this.boxWidthScale.length; ++i) {
                this.boxWidthScale[i] = 0.75;
            }
        }
        if (this.getGroupDisplay() == 0) {
            int maxGroups = (Integer)this.model.getSrcModel().maxGroupsPerCategory.get(this.overlayID);
            dls *= maxGroups;
        }
        if (this.labelVar != null) {
            int len;
            Font f = this.labelStyle.getFont();
            FontMetrics fm = StatGraph.getFontMetrics(f);
            if (this.orientation == 0) {
                if (this.dataLabelSplit) {
                    len = (int)(this.maxSplitDataLabelWidth + 0.5);
                } else {
                    int nchars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
                    StringBuffer sb = new StringBuffer(nchars);
                    for (int i = 0; i < nchars; ++i) {
                        sb = sb.append("W");
                    }
                    len = fm.stringWidth(sb.toString());
                }
            } else {
                len = this.dataLabelSplit ? (int)(this.maxSplitDataLabelHeight + 0.5) : fm.getHeight();
            }
            dls = Math.max(dls, len);
        }
        return dls;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return !this.model.isAvailable(3);
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(3);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }

    public double getMeanTransparency() {
        return this.meanTransparency;
    }

    public void setMeanTransparency(double meanTransparency) {
        this.meanTransparency = meanTransparency;
    }

    public double getMarkerTransparency() {
        return this.markerTransparency;
    }

    public void setMarkerTransparency(double markerTransparency) {
        this.markerTransparency = markerTransparency;
    }

    public ColorEncoder getLineColorEncoder() {
        return this.lineColorEncoder;
    }

    @Override
    int getSubsettedUniqueValueCount(Variable variable, short role, boolean numeric) {
        if (this.model.whereExpression != null) {
            Variable var = this.connectRaw(role);
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, var);
            this.addCRDWhereClause(vp);
            if (variable instanceof NumericVariable) {
                var.setFormat(variable.getFormat());
            }
            return var.getUniqueValueCount();
        }
        return variable.getUniqueValueCount();
    }

    protected Variable connectRaw(short role, boolean setDefaultFormat) {
        NumericVectorVariable outVar;
        boolean numeric;
        if (!this.model.isAvailable(role)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(role);
        boolean bl = numeric = this.model.getColumnClass(role) == Double.class;
        if (numeric) {
            outVar = new NumericVectorVariable();
            outVar.connectFrom(this.model.getDoubleColumn(role));
        } else {
            outVar = new StringVectorVariable();
            ((StringVectorVariable)outVar).connectFrom(this.model.getStringColumn(role));
        }
        if (cmd.getFormat() != null) {
            outVar.setFormat(new GTKFormat((Format)cmd.getFormat()));
        } else if (outVar instanceof NumericVariable) {
            if (setDefaultFormat) {
                outVar.setFormat(new GTKFormat((Format)DataModel.defaultFormat));
            } else {
                outVar.setFormat(null);
            }
        }
        outVar.setLabel(this.getLabel(role));
        return outVar;
    }

    @Override
    public String getLegendLabel() {
        if (this.legendLabel != null) {
            return this.legendLabel;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(11);
        if (cmd.getLabel() != null) {
            return cmd.getLabel();
        }
        return cmd.getName();
    }

    @Override
    protected int getNumberOfDrawingElements() {
        int num;
        int n = num = this.xvalueVar == null ? 1 : this.xvalueVar.getUniqueValueCount();
        if (this.groupVar != null) {
            int count = 0;
            for (int i = 0; i < num; ++i) {
                count += this.groupsPerCategory[i];
            }
            num = count;
        }
        return num;
    }

    @Override
    public int getRendererComplexity() {
        int n = this.getNumberOfDrawingElements();
        if (this.outlierXVar != null) {
            n += this.outlierXVar.getValueCount();
        }
        return n;
    }

    @Override
    public int getNumOfTooltips() {
        int n = this.getNumberOfDrawingElements();
        if (this.outlierXVar != null) {
            n += this.outlierXVar.getValueCount();
        }
        return n;
    }

    public boolean isConnectSkipMiss() {
        return this.connectSkipMiss;
    }

    public void setConnectSkipMiss(boolean connectSkipMiss) {
        this.connectSkipMiss = connectSkipMiss;
    }
}

