/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class BlockOverlay
extends Overlay {
    public static final String RB_KEY = "BlockOverlay.";
    protected DataRange xRange = null;
    protected PositionEncoder xEncoder;
    protected PositionEncoder yEncoder;
    private Variable xvalueVar;
    private Variable blockVar;
    private Variable blockRawVar;
    private Variable indexVar;
    private Variable groupVar;
    private StringVariable blockLabelVar;
    private NumericVariable numericXVar;
    private NetworkRoot networkRoot;
    private NetworkRoot networkRoot2;
    private NumericMapper xvalueMapper;
    private Rectangle blocks;
    private RasterLabel values;
    private RasterLabel outsideLabel;
    private NumericVector blockStart;
    private NumericVector valuePosition;
    private NumericVector blockLength;
    private NumericVector colorIndex;
    private StringVector displayValue;
    private StringVector blockValue;
    private StringVector blockProbePipe;
    private StringVector blockLabelProbePipe;
    private String blockLabel;
    private HashMap colorMap = new HashMap();
    private int colorCnt;
    private boolean fillOn = true;
    private boolean edgeOn = true;
    private boolean valueOn = true;
    private boolean labelOn = true;
    public static final int LABEL_TOP = 0;
    public static final int LABEL_BOTTOM = 1;
    public static final int LABEL_LEFT = 2;
    public static final int LABEL_RIGHT = 3;
    private int labelPosition = 2;
    private TextStyle valueStyle = new TextStyle();
    private TextStyle labelStyle = new TextStyle();
    public static final int JUSTIFICATION_START = 10;
    private int valueHAlign = 0;
    private int valueVAlign = 1;
    private LineAttrs lineStyle = new LineAttrs();
    public Color[] colorList;
    public Color missingColor = null;
    public static final int COLOR_BY_BLOCK = 0;
    public static final int COLOR_BY_ALT = 1;
    private int fillType = 0;
    private FillAttrs fillStyle = new FillAttrs();
    private FillAttrs altFillStyle = new FillAttrs();
    private boolean repeatValue = false;
    public static final int TRUNCATE = 0;
    public static final int SHRINK = 1;
    public static final int SPLIT = 2;
    public static final int SPLITALWAYS = 3;
    public static final int NONE = 4;
    private int valueFitStrategy = 1;
    private int scaledValueFontSize = -1;
    private double maxDensity = 0.0;
    private String theValue = null;
    private double theLength = 0.0;
    private String label = null;
    private boolean numericX;
    private boolean numericLabel;
    private boolean numericGroup;
    private boolean numericBlockLabel;
    private boolean dynamic = false;
    private HashMap blockPlotGroups = new LinkedHashMap();
    private boolean missingBreak = true;
    private boolean dataWarning = false;
    private boolean valueTruncationWarning = false;
    private char[] valueSplitChar = new char[]{' '};
    private boolean valueSplitCharDrop = true;
    private int maxValueHeight;
    private int totalValueHeight;
    private int totalBlockHeight;
    private int blockHeightADJ = 0;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int REVERSEDATA = 3;
    private int classOrder = 0;
    private int blockOrder = 0;
    private boolean sortXValues = false;

    public void setClassOrder(int order) {
        this.classOrder = order;
    }

    public int getClassOrder() {
        return this.classOrder;
    }

    public void setBlockOrder(int order) {
        this.blockOrder = order;
    }

    public int getBlockOrder(int order) {
        return this.blockOrder;
    }

    public void setSortXValues(boolean b) {
        this.sortXValues = b;
    }

    public boolean isSortXValues() {
        return this.sortXValues;
    }

    public void setValueSplitChar(char[] schars) {
        this.valueSplitChar = schars;
    }

    public char[] getValueSplitChar() {
        return this.valueSplitChar;
    }

    public void setValueSplitCharDrop(boolean b) {
        this.valueSplitCharDrop = b;
    }

    public boolean isValueSplitCharDrop() {
        return this.valueSplitCharDrop;
    }

    public boolean isMissingBreak() {
        return this.missingBreak;
    }

    public void setMissingBreak(boolean b) {
        this.missingBreak = b;
    }

    protected void updateXRange() {
        Object newRange = null;
        DataRange oldRange = this.xRange;
        if (this.xvalueVar != null) {
            newRange = this.numericX ? this.makeContinuousRange((NumericVariable)this.xvalueVar, (short)10, !this.xUnionAllPages) : (this.numericDiscreteX ? this.makeOrdinalRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), this.numericXVar, (short)10, !this.xUnionAllPages) : this.makeDiscreteRange((StringVariable)this.xvalueVar, this.xvalueVar.getUniqueValueCount(), (short)10, !this.xUnionAllPages));
            newRange.setLabel(this.xvalueVar.getLabel());
        }
        if (newRange != null && newRange.equals((Object)oldRange)) {
            newRange = oldRange;
        }
        this.setFormat((DataRange)newRange, 10);
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, (DataRange)newRange);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xRange;
            }
        }
        return null;
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void drawNoneClipped(Graphics g) {
        if (this.networkRoot2 == null) {
            return;
        }
        Channel channel = this.networkRoot2.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot2.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.xEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            if (encoder != null && encoder.equals(this.yEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        super.setModel(aModel);
        this.connectVars();
        this.updateXRange();
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xvalueVar == null || this.xRange == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.repeatValue && this.numericX && this.valueHAlign != 10) {
            this.valueHAlign = 0;
        }
        if (this.repeatValue && !this.numericX && this.valueHAlign != 10) {
            this.valueHAlign = 1;
        }
        ValueMap map = null;
        if (this.xvalueVar != null && this.xEncoder != null) {
            map = this.xEncoder.getValueMap();
            if (this.numericX) {
                if (!(map instanceof ContinuousRangeToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                    this.xvalueMapper = new ContinuousRangeToNumericMapper();
                }
                ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
            } else {
                if (!(map instanceof StringToNumericMap)) {
                    return false;
                }
                if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                    this.xvalueMapper = new StringToNumericMapper();
                }
                ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
            }
        } else {
            this.xvalueMapper = null;
        }
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        if (this.makeBlocks() != 0) {
            return false;
        }
        this.networkRoot.removeAllElements();
        if (this.networkRoot2 != null) {
            this.networkRoot2.removeAllElements();
        }
        this.colorMap.clear();
        this.colorCnt = 0;
        StringVariable colVar = (StringVariable)this.connectCategory((short)5, true);
        Variable xVar = this.connectRaw((short)10);
        Variable rawBVar = this.connectRaw((short)5);
        if (this.blockOrder == 1 || this.blockOrder == 2) {
            int sort = this.blockOrder == 1 ? 1 : 2;
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)colVar);
            vp.addVariable(xVar);
            vp.addVariable(rawBVar);
            if (this.numericLabel) {
                vp.setSort(rawBVar, sort);
            } else {
                vp.setSort((Variable)colVar, sort);
            }
        }
        for (int i = 0; i < colVar.getValueCount(); ++i) {
            if (xVar.isMissing(i) && (this.numericX || !this.missingCategoryOn) || rawBVar.isMissing(i) && this.continueMissingBlock(i, rawBVar)) continue;
            try {
                Color c;
                String val = this.getPaddedValue(colVar.value.getValue(i));
                if (this.colorMap.containsKey(val)) continue;
                if (LayoutOverlayParser.isMissing(val.trim(), this.numericLabel)) {
                    c = this.applyDataTransparency(this.missingColor, this.fillStyle.getTransparency());
                    this.colorMap.put(val, c);
                    continue;
                }
                c = this.applyDataTransparency(this.colorList[this.colorCnt % this.colorList.length], this.fillStyle.getTransparency());
                this.colorMap.put(val, c);
                ++this.colorCnt;
                continue;
            }
            catch (MissingValueException val) {
                // empty catch block
            }
        }
        RasterLabel[] blockLabels = new RasterLabel[this.blockPlotGroups.size()];
        if (this.xvalueMapper != null) {
            Iterator iter = this.blockPlotGroups.values().iterator();
            int overlayBase_sav = this.overlayBase;
            if (this.overlayJustification != 1) {
                this.overlayBase += this.getTheOverlayHeight();
            }
            if (this.overlayJustification == 0) {
                this.overlayBase += this.bottomReservedSpace;
            }
            int rn = 0;
            while (iter.hasNext()) {
                BlockPlotPerGroup currentGroup = (BlockPlotPerGroup)iter.next();
                this.blockStart = currentGroup.blockStart;
                this.blockLength = currentGroup.blockLength;
                this.valuePosition = currentGroup.valuePosition;
                this.displayValue = currentGroup.displayValue;
                this.blockValue = currentGroup.blockValue;
                this.blockProbePipe = currentGroup.blockProbePipe;
                this.blockLabelProbePipe = currentGroup.blockLabelProbePipe;
                this.colorIndex = currentGroup.colorIndex;
                this.blockLabel = currentGroup.groupID;
                this.probe = currentGroup.probe;
                this.maxValueHeight = currentGroup.maxValueHeight;
                if (this.overlayJustification == 1) {
                    this.connectNetworkPerGroup();
                }
                this.overlayBase = this.overlayJustification == 1 ? (this.overlayBase += this.getBlockHeight()) : (this.overlayBase -= this.getBlockHeight());
                if (this.overlayJustification != 1) {
                    this.connectNetworkPerGroup();
                }
                this.blockHeightADJ = 0;
                blockLabels[rn++] = this.outsideLabel;
            }
            this.overlayBase = overlayBase_sav;
        }
        if (this.displayGridLabel) {
            if (this.labelPosition == 2 && this.gridLabelEntryL != null) {
                this.gridLabelEntryL.addLabel(blockLabels, this.getID());
            } else if (this.labelPosition == 3 && this.gridLabelEntryR != null) {
                this.gridLabelEntryR.addLabel(blockLabels, this.getID());
            }
        }
        this.needConnect = false;
        return true;
    }

    private void connectNetworkPerGroup() {
        DiscreteAttrMapper blockAttrMapper;
        StringVector altValue = new StringVector();
        StringToColorMapper colorMapper = new StringToColorMapper();
        if (this.fillType == 1) {
            colorMapper.input.connectFrom((StringPipe)altValue);
        } else {
            colorMapper.input.connectFrom((StringPipe)this.blockValue);
        }
        StringToColorMap cmap = new StringToColorMap();
        ArrayList<String> mappedValue = new ArrayList<String>();
        int blockNo = -1;
        for (int j = 0; j < this.blockValue.getValueCount(); ++j) {
            boolean validBlock;
            try {
                this.blockStart.getValue(j);
                validBlock = true;
                ++blockNo;
            }
            catch (MissingValueException e) {
                validBlock = false;
            }
            int i = this.xEncoder.isReversed() ? this.blockValue.getValueCount() - 1 - j : j;
            try {
                Color c;
                String val;
                if (this.fillType == 1) {
                    val = Integer.toString(j);
                    if (this.xEncoder.isReversed()) {
                        altValue.insertValueAt(val, 0);
                    } else {
                        altValue.addValue(val);
                    }
                } else {
                    val = this.blockValue.getValue(i);
                }
                if (mappedValue.contains(val)) continue;
                if (this.fillType == 1) {
                    c = blockNo % 2 == 0 ? this.applyDataTransparency((ColorAttr)this.fillStyle) : this.applyDataTransparency((ColorAttr)this.altFillStyle);
                } else if (this.colorIndex == null) {
                    if (this.colorMap.containsKey(val)) {
                        c = (Color)this.colorMap.get(val);
                    } else {
                        c = this.applyDataTransparency(this.colorList[this.colorCnt % this.colorList.length], this.fillStyle.getTransparency());
                        this.colorMap.put(val, c);
                        ++this.colorCnt;
                    }
                } else {
                    c = this.applyDataTransparency(this.colorList[(int)(this.colorIndex.getValue(i) - 1.0) % this.colorList.length], this.fillStyle.getTransparency());
                }
                cmap.add(val, c);
                mappedValue.add(val);
                continue;
            }
            catch (MissingValueException val) {
                // empty catch block
            }
        }
        colorMapper.setMap(cmap);
        if (this.fillType == 1) {
            this.removeAttrVar("BLOCK");
        }
        DiscreteAttrMapper discreteAttrMapper = blockAttrMapper = this.hasAttrVar("BLOCK") ? (DiscreteAttrMapper)this.getAttrVarMapper("BLOCK") : null;
        if (blockAttrMapper != null) {
            blockAttrMapper.setTrimOn(true);
            blockAttrMapper.setFillTransparency(this.getAttrTransparency((ColorAttr)this.fillStyle));
            blockAttrMapper.setUseFillTransparency(this.useFillTransparency);
            blockAttrMapper.variable = this.blockValue;
            blockAttrMapper.fillColorMapper = colorMapper;
        }
        if (this.xvalueMapper != null) {
            if (this.fillOn || this.edgeOn) {
                this.blocks = new Rectangle();
                this.blocks.set2D(true);
                this.blocks.origin.setValue(5);
                this.blocks.coordX.connectFrom((NumericPipe)this.blockStart);
                this.blocks.sizeX.connectFrom((NumericPipe)this.blockLength);
                if (this.overlayJustification == 2) {
                    if (this.labelPosition == 1) {
                        this.blocks.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight());
                    } else {
                        this.blocks.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase);
                    }
                } else if (this.overlayJustification == 1) {
                    if (this.labelPosition == 1) {
                        this.blocks.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getValueHeight());
                    } else {
                        this.blocks.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getBlockHeight());
                    }
                } else if (this.labelPosition == 1) {
                    this.blocks.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight());
                } else {
                    this.blocks.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase);
                }
                if (this.labelPosition == 0 || this.labelPosition == 1) {
                    this.blocks.sizeY.setValue((double)this.getValueHeight());
                } else {
                    this.blocks.sizeY.setValue((double)this.getBlockHeight());
                }
                if (this.fillOn) {
                    if (blockAttrMapper != null) {
                        ColorVector cv = new ColorVector();
                        for (int i = 0; i < this.blockValue.size(); ++i) {
                            try {
                                cv.addValue(blockAttrMapper.fillColor.getValue(i));
                                continue;
                            }
                            catch (MissingValueException c) {
                                // empty catch block
                            }
                        }
                        this.blocks.color.connectFrom((ColorPipe)cv);
                    } else {
                        this.blocks.color.connectFrom((ColorPipe)colorMapper);
                    }
                    this.blocks.edgeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                } else {
                    this.blocks.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    this.blocks.edgeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                }
                this.blocks.fillOn.setValue(this.fillOn);
                this.blocks.edgeOn.setValue(this.edgeOn);
                this.blocks.edgeWidth.setValue(this.lineStyle.getWidth());
                this.blocks.edgePattern.setValue(this.lineStyle.getLinePattern());
                this.blocks.setUserData((Object)this.probe);
                this.networkRoot.addElement((Element)this.blocks);
            }
            if (this.valueOn) {
                this.values = new RasterLabel();
                this.values.transform.translateX.connectFrom((NumericPipe)this.valuePosition);
                if (this.valueHAlign == 10) {
                    this.values.horizontalJustification.setValue(1);
                } else {
                    this.values.horizontalJustification.setValue(this.valueHAlign);
                }
                switch (this.valueVAlign) {
                    case 1: {
                        if (this.overlayJustification == 2) {
                            if (this.labelPosition == 0) {
                                this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight() * 0.5);
                                break;
                            }
                            if (this.labelPosition == 1) {
                                this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight() + (double)this.getValueHeight() * 0.5);
                                break;
                            }
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            break;
                        }
                        if (this.overlayJustification == 1) {
                            if (this.labelPosition == 0) {
                                this.values.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getLabelHeight() - (double)this.getValueHeight() * 0.5);
                                break;
                            }
                            if (this.labelPosition == 1) {
                                this.values.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getValueHeight() * 0.5);
                                break;
                            }
                            this.values.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getBlockHeight() * 0.5);
                            break;
                        }
                        if (this.labelPosition == 0) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight() * 0.5);
                            break;
                        }
                        if (this.labelPosition == 1) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight() + (double)this.getValueHeight() * 0.5);
                            break;
                        }
                        this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                        break;
                    }
                    case 0: {
                        if (this.overlayJustification != 0) break;
                        if (this.labelPosition == 0) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight());
                            break;
                        }
                        if (this.labelPosition == 1) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight());
                            break;
                        }
                        this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight());
                        break;
                    }
                    case 3: {
                        if (this.overlayJustification != 0) break;
                        if (this.labelPosition == 0) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase);
                            break;
                        }
                        if (this.labelPosition == 1) {
                            this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight());
                            break;
                        }
                        this.values.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase);
                    }
                }
                this.values.verticalJustification.setValue(this.valueVAlign);
                this.values.string.connectFrom((StringPipe)this.displayValue);
                this.values.color.setValue(this.valueStyle.getColor());
                Font fnt = this.valueStyle.getFont();
                this.values.fontName.setValue(fnt.getFamily());
                this.values.fontStyle.setValue(fnt.getStyle());
                if (this.scaledValueFontSize > 0) {
                    this.values.fontSize.setValue(this.scaledValueFontSize);
                } else {
                    this.values.fontSize.setValue(fnt.getSize());
                }
                this.networkRoot.addElement((Element)this.values);
            }
            if (this.labelOn) {
                this.outsideLabel = new RasterLabel();
                if (this.networkRoot2 == null) {
                    this.networkRoot2 = new NetworkRoot(this.networkRoot.getChannel());
                }
                if (!this.displayGridLabel) {
                    this.networkRoot2.addElement((Element)this.outsideLabel);
                }
                switch (this.labelPosition) {
                    case 2: {
                        if (this.displayGridLabel && this.gridLabelEntryL != null) {
                            this.outsideLabel.transform.translateX.setValue((double)this.gridLabelEntryL.getWidth());
                            if (this.overlayJustification == 2) {
                                this.outsideLabel.transform.translateY.setValue((double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            } else if (this.overlayJustification == 1) {
                                this.outsideLabel.transform.translateY.setValue((double)(this.gridLabelEntryL.getHeight() - this.overlayBase) - (double)this.getBlockHeight() * 0.5);
                            } else {
                                this.outsideLabel.transform.translateY.setValue((double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            }
                        } else {
                            this.outsideLabel.transform.translateX.setValue(this.xEncoder.getLowerLimit());
                            if (this.overlayJustification == 2) {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            } else if (this.overlayJustification == 1) {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getBlockHeight() * 0.5);
                            } else {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            }
                        }
                        this.outsideLabel.horizontalJustification.setValue(2);
                        this.outsideLabel.verticalJustification.setValue(1);
                        break;
                    }
                    case 3: {
                        if (this.displayGridLabel && this.gridLabelEntryR != null) {
                            this.outsideLabel.transform.translateX.setValue(0.0);
                            if (this.overlayJustification == 2) {
                                this.outsideLabel.transform.translateY.setValue((double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            } else if (this.overlayJustification == 1) {
                                this.outsideLabel.transform.translateY.setValue((double)(this.gridLabelEntryR.getHeight() - this.overlayBase) - (double)this.getBlockHeight() * 0.5);
                            } else {
                                this.outsideLabel.transform.translateY.setValue((double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            }
                        } else {
                            this.outsideLabel.transform.translateX.setValue(this.xEncoder.getUpperLimit());
                            if (this.overlayJustification == 2) {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            } else if (this.overlayJustification == 1) {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getBlockHeight() * 0.5);
                            } else {
                                this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getBlockHeight() * 0.5);
                            }
                        }
                        this.outsideLabel.horizontalJustification.setValue(0);
                        this.outsideLabel.verticalJustification.setValue(1);
                        break;
                    }
                    case 0: {
                        this.outsideLabel.transform.translateX.setValue(this.xEncoder.getLowerLimit() + (double)this.leftReservedSpace);
                        if (this.overlayJustification == 2) {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight());
                        } else if (this.overlayJustification == 1) {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getLabelHeight());
                        } else {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight());
                        }
                        this.outsideLabel.horizontalJustification.setValue(0);
                        this.outsideLabel.verticalJustification.setValue(3);
                        break;
                    }
                    case 1: {
                        this.outsideLabel.transform.translateX.setValue(this.xEncoder.getLowerLimit() + (double)this.leftReservedSpace);
                        if (this.overlayJustification == 2) {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight());
                        } else if (this.overlayJustification == 1) {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getValueHeight());
                        } else {
                            this.outsideLabel.transform.translateY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getLabelHeight());
                        }
                        this.outsideLabel.horizontalJustification.setValue(0);
                        this.outsideLabel.verticalJustification.setValue(0);
                    }
                }
                this.outsideLabel.string.setValue(" " + this.blockLabel.trim() + " ");
                this.outsideLabel.color.setValue(this.labelStyle.getColor());
                Font fnt = this.labelStyle.getFont();
                this.outsideLabel.fontName.setValue(fnt.getFamily());
                this.outsideLabel.fontStyle.setValue(fnt.getStyle());
                this.outsideLabel.fontSize.setValue(fnt.getSize());
                if (this.labelPosition == 0 || this.labelPosition == 1) {
                    Rectangle labelBorder = new Rectangle();
                    labelBorder.set2D(true);
                    this.networkRoot2.addElement((Element)labelBorder);
                    FontMetrics fm = StatGraph.getFontMetrics(fnt);
                    int borderheight = this.groupVar == null ? fm.getHeight() : this.getLabelHeight();
                    int offset = this.groupVar == null ? fm.getHeight() : 0;
                    labelBorder.origin.setValue(5);
                    labelBorder.coordX.setValue(this.xEncoder.getLowerLimit() + (double)this.leftReservedSpace);
                    if (this.labelPosition == 0) {
                        if (this.overlayJustification == 2) {
                            labelBorder.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight());
                        } else if (this.overlayJustification == 1) {
                            labelBorder.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getLabelHeight());
                        } else {
                            labelBorder.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase + (double)this.getValueHeight());
                        }
                    } else if (this.overlayJustification == 2) {
                        labelBorder.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase);
                    } else if (this.overlayJustification == 1) {
                        labelBorder.coordY.setValue(this.yEncoder.getUpperLimit() - (double)this.overlayBase - (double)this.getBlockHeight());
                    } else {
                        labelBorder.coordY.setValue(this.yEncoder.getLowerLimit() + (double)this.overlayBase - (double)offset);
                    }
                    labelBorder.sizeX.setValue(this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit() - (double)this.leftReservedSpace - (double)this.rightReservedSpace);
                    labelBorder.sizeY.setValue((double)borderheight);
                    labelBorder.color.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    labelBorder.edgeColor.setValue(this.applyDataTransparency(this.lineStyle.getColor()));
                    labelBorder.fillOn.setValue(false);
                    labelBorder.edgeOn.setValue(true);
                    labelBorder.edgeWidth.setValue(this.lineStyle.getWidth());
                    labelBorder.edgePattern.setValue(this.lineStyle.getLinePattern());
                }
            }
        }
    }

    private String getPaddedValue(String value) {
        if (this.valueHAlign == 10) {
            return value.trim();
        }
        if (this.valueHAlign == 0) {
            return " " + value.trim();
        }
        if (this.valueHAlign == 2) {
            return value.trim() + " ";
        }
        return " " + value.trim() + " ";
    }

    private String getTruncatedValue(String value, FontMetrics fm, double len) {
        if (this.valueHAlign == 10) {
            return value;
        }
        String str = value;
        if ((double)fm.stringWidth(value) > len) {
            if (this.numericLabel) {
                this.valueTruncationWarning = true;
                return "*";
            }
            if (len < (double)fm.stringWidth("X...")) {
                if (str.length() > 1 && (double)fm.stringWidth(str.substring(0, 2)) < len) {
                    return str.substring(0, 2);
                }
                if (str.length() > 0 && (double)fm.stringWidth(str.substring(0, 1)) < len) {
                    return str.substring(0, 1);
                }
                return str.substring(0, 0);
            }
            for (int lastIndex = str.length() - 1; (double)fm.stringWidth(str) > len && lastIndex >= 0; --lastIndex) {
                str = value.substring(0, lastIndex - 2) + "...";
            }
        }
        return str;
    }

    private String getSplitValue(String value, FontMetrics fm, double splitWidth) {
        boolean splitAlways;
        String str = value;
        boolean bl = splitAlways = this.valueFitStrategy == 3;
        if (splitAlways || (double)fm.stringWidth(value.trim()) > splitWidth) {
            str = BlockOverlay.makeMultiLineLabel(BlockOverlay.splitLabel(value.trim(), splitAlways, splitWidth, this.valueSplitCharDrop, this.valueSplitChar, fm), true);
        }
        return str;
    }

    private int makeBlocks() {
        this.maxDensity = 0.0;
        this.theValue = null;
        this.theLength = 0.0;
        this.totalValueHeight = 0;
        this.totalBlockHeight = 0;
        this.valueTruncationWarning = false;
        for (BlockPlotPerGroup currentGroup : this.blockPlotGroups.values()) {
            this.blockStart = currentGroup.blockStart;
            this.blockLength = currentGroup.blockLength;
            this.valuePosition = currentGroup.valuePosition;
            this.displayValue = currentGroup.displayValue;
            this.blockValue = currentGroup.blockValue;
            this.blockProbePipe = currentGroup.blockProbePipe;
            this.blockLabelProbePipe = currentGroup.blockLabelProbePipe;
            this.colorIndex = currentGroup.colorIndex;
            int n = currentGroup.valueIndices.size();
            int[] indices = new int[n];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)currentGroup.valueIndices.get(i);
            }
            if (this.makeBlocksPerGroup(indices) != 0) {
                return -1;
            }
            currentGroup.maxValueHeight = this.maxValueHeight;
            this.totalValueHeight += this.maxValueHeight;
            this.totalBlockHeight += this.getBlockHeight();
        }
        this.blockHeightADJ = this.overlayJustification == 0 ? (int)(this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit() - (double)this.topReservedSpace - (double)this.bottomReservedSpace) - this.totalBlockHeight : 0;
        if (this.valueFitStrategy == 1) {
            int size;
            Font fn = this.valueStyle.getFont();
            FontMetrics fm = StatGraph.getFontMetrics(fn);
            String family = fn.getFamily();
            int style = fn.getStyle();
            if (this.maxDensity > 1.0) {
                for (size = fn.getSize() - 1; size > 5 && !((double)(fm = StatGraph.getFontMetrics(family, style, size)).stringWidth(this.theValue) / this.theLength < 0.95); --size) {
                }
                this.scaledValueFontSize = size;
            } else {
                this.scaledValueFontSize = -1;
            }
            if (!this.isInnerMarginOverlay() && (fm = StatGraph.getFontMetrics(family, style, size = this.scaledValueFontSize > 0 ? this.scaledValueFontSize : fn.getSize())).getHeight() > this.getValueHeight()) {
                --size;
                while (size > 5 && !((double)(fm = StatGraph.getFontMetrics(family, style, size)).getHeight() / (double)this.getValueHeight() < 0.95)) {
                    --size;
                }
                this.scaledValueFontSize = size;
            }
        } else {
            this.scaledValueFontSize = -1;
        }
        for (BlockPlotPerGroup currentGroup : this.blockPlotGroups.values()) {
            currentGroup.probe = new Probe();
            currentGroup.probe.setTrimOn(true);
            if (this.groupVar != null) {
                StringProperty sp = new StringProperty();
                sp.setValue(currentGroup.groupID);
                currentGroup.probe.addPipe(this.groupVar.getLabel(), (Pipe)sp);
            }
            currentGroup.probe.addPipe(this.blockVar.getLabel(), (Pipe)currentGroup.blockProbePipe);
            if (this.blockLabelVar == null) continue;
            currentGroup.probe.addPipe(this.blockLabelVar.getLabel(), (Pipe)currentGroup.blockLabelProbePipe);
        }
        if (this.valueOn && this.valueTruncationWarning) {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "valuenotfit.txt"));
        }
        return 0;
    }

    private boolean continueMissingBlock(int idx) {
        if (idx < 0 || this.missingBreak) {
            return false;
        }
        return this.blockRawVar.isMissing(idx);
    }

    private boolean continueMissingBlock(int idx, Variable var) {
        if (idx < 0 || this.missingBreak) {
            return false;
        }
        return var.isMissing(idx);
    }

    private int makeBlocksPerGroup(int[] indices) {
        int i;
        this.blockStart.removeAllValues();
        this.blockLength.removeAllValues();
        this.valuePosition.removeAllValues();
        this.displayValue.removeAllValues();
        this.blockValue.removeAllValues();
        this.blockProbePipe.removeAllValues();
        this.blockLabelProbePipe.removeAllValues();
        if (this.colorIndex != null) {
            this.colorIndex.removeAllValues();
        }
        this.maxValueHeight = 0;
        if (!this.numericX) {
            return this.makeDiscreteBlocks(indices);
        }
        StringVariable lvar = (StringVariable)this.blockVar;
        ContinuousRangeToNumericMapper ctnm = (ContinuousRangeToNumericMapper)this.xvalueMapper;
        String lastValue = "";
        String lastLabelValue = "";
        String lastDisplayValue = "";
        double lastStart = 0.0;
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        int bkno = 0;
        double firstNonMissingXValue = 0.0;
        double lastxv = 0.0;
        ((NumericVariable)this.xvalueVar).getValueCount();
        for (int j = 0; j < indices.length; ++j) {
            int i2 = this.xEncoder.isReversed() ? indices.length - 1 - j : j;
            try {
                ContinuousRange cr;
                double xv = ((NumericVariable)this.xvalueVar).value.getValue(indices[i2]);
                ContinuousRange continuousRange = cr = this.xEncoder.getInput() instanceof SimpleBinnedRange ? (ContinuousRange)this.xEncoder.getInput().getDual() : (ContinuousRange)this.xEncoder.getInput();
                if (xv < cr.getMin() || xv > cr.getMax()) continue;
                if (++bkno == 1) {
                    lastValue = this.getPaddedValue(lvar.value.getValue(indices[i2]));
                    lastDisplayValue = lastLabelValue = this.blockLabelVar != null ? this.getPaddedValue(this.blockLabelVar.value.getValue(indices[i2])) : lastValue;
                    lastStart = this.xEncoder.getLowerLimit() + (double)this.leftReservedSpace;
                    this.blockStart.addValue(lastStart);
                    if (this.colorIndex != null) {
                        double idx = ((NumericVariable)this.indexVar).value.getValue(indices[i2]);
                        this.colorIndex.addValue(idx);
                    }
                    firstNonMissingXValue = xv;
                } else {
                    String blv;
                    if (this.continueMissingBlock(indices[i2])) continue;
                    String lv = this.getPaddedValue(lvar.value.getValue(indices[i2]));
                    String string = blv = this.blockLabelVar == null ? "" : this.getPaddedValue(this.blockLabelVar.value.getValue(indices[i2]));
                    if (this.repeatValue || !lv.equals(lastValue)) {
                        double start = this.xEncoder.isReversed() ? ctnm.getValue(lastxv) : ctnm.getValue(xv);
                        this.blockStart.addValue(start);
                        double len = start - lastStart;
                        if (!this.dynamic && len < 0.0 && start >= ctnm.getOutputMin() && start <= ctnm.getOutputMax()) {
                            StatGraph.printWarning(RB.getStringResource(RB_KEY, "sort.txt"));
                            return -1;
                        }
                        this.blockLength.addValue(len);
                        this.blockValue.addValue(lastValue);
                        if (this.valueFitStrategy == 1) {
                            double strLen = fm.stringWidth(lastLabelValue);
                            if (strLen / len > this.maxDensity) {
                                this.maxDensity = strLen / len;
                                this.theValue = lastLabelValue;
                                this.theLength = start - lastStart;
                            }
                            lastDisplayValue = lastLabelValue;
                        } else if (this.valueFitStrategy == 0) {
                            lastDisplayValue = this.getTruncatedValue(lastLabelValue, fm, len);
                        } else if (this.isSplitValue()) {
                            lastDisplayValue = this.getSplitValue(lastLabelValue, fm, len);
                        }
                        this.maxValueHeight = Math.max(this.maxValueHeight, BlockOverlay.getTextHeight(fm, lastDisplayValue));
                        lastStart = start;
                        if (this.colorIndex != null) {
                            double idx = ((NumericVariable)this.indexVar).value.getValue(indices[i2]);
                            this.colorIndex.addValue(idx);
                        }
                        this.displayValue.addValue(lastDisplayValue);
                        lastValue = lv;
                        lastDisplayValue = lastLabelValue = this.blockLabelVar != null ? blv : lv;
                    }
                }
                lastxv = xv;
                continue;
            }
            catch (MissingValueException xv) {
                // empty catch block
            }
        }
        if (bkno == 0) {
            return 0;
        }
        double len = this.xEncoder.getUpperLimit() - (double)this.rightReservedSpace - lastStart;
        this.blockLength.addValue(len);
        this.blockValue.addValue(lastValue);
        if (this.valueFitStrategy == 1) {
            double strLen = fm.stringWidth(lastLabelValue);
            if (strLen / len > this.maxDensity) {
                this.maxDensity = strLen / len;
                this.theValue = lastLabelValue;
                this.theLength = this.xEncoder.getUpperLimit() - (double)this.rightReservedSpace - lastStart;
            }
            lastDisplayValue = lastLabelValue;
        } else if (this.valueFitStrategy == 0) {
            lastDisplayValue = this.getTruncatedValue(lastLabelValue, fm, len);
        } else if (this.isSplitValue()) {
            lastDisplayValue = this.getSplitValue(lastLabelValue, fm, len);
        }
        this.maxValueHeight = Math.max(this.maxValueHeight, BlockOverlay.getTextHeight(fm, lastDisplayValue));
        this.displayValue.addValue(lastDisplayValue);
        for (i = 0; i < bkno; ++i) {
            try {
                if (this.repeatValue) {
                    if (i == 0) {
                        this.valuePosition.addValue(ctnm.getValue(firstNonMissingXValue));
                        continue;
                    }
                    this.valuePosition.addValue(this.blockStart.getValue(i));
                    continue;
                }
                switch (this.valueHAlign) {
                    case 0: {
                        this.valuePosition.addValue(this.blockStart.getValue(i));
                        break;
                    }
                    case 2: {
                        this.valuePosition.addValue(this.blockStart.getValue(i) + this.blockLength.getValue(i));
                        break;
                    }
                    case 1: {
                        this.valuePosition.addValue(this.blockStart.getValue(i) + this.blockLength.getValue(i) / 2.0);
                        break;
                    }
                    case 10: {
                        if (i == 0) {
                            this.valuePosition.addValue(ctnm.getValue(firstNonMissingXValue));
                            break;
                        }
                        this.valuePosition.addValue(this.blockStart.getValue(i));
                    }
                }
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        try {
            for (i = 0; i < this.blockValue.getValueCount(); ++i) {
                this.blockProbePipe.addValue(this.blockValue.getValue(i));
                this.blockLabelProbePipe.addValue(this.displayValue.getValue(i));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return 0;
    }

    private int makeDiscreteBlocks(int[] indices) {
        StringVariable lvar = (StringVariable)this.blockVar;
        StringToNumericMapper stnm = (StringToNumericMapper)this.xvalueMapper;
        String lastValue = "";
        String lastLabelValue = "";
        String lastDisplayValue = "";
        double lastStart = 0.0;
        double lastPosition = 0.0;
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        double stride = stnm.getStrideValue();
        try {
            for (int i = 0; i < stnm.getUniqueValueCount(); ++i) {
                double usableLen;
                int obs;
                if (!this.dataWarning) {
                    this.isBlockValueUnique(stnm.label.getValue(i), indices);
                }
                String lv = (obs = this.getFirstIndexInXVarible(stnm.label.getValue(i), indices)) < 0 ? "" : this.getPaddedValue(lvar.value.getValue(obs));
                String blv = "";
                if (obs >= 0 && this.blockLabelVar != null) {
                    blv = this.getPaddedValue(this.blockLabelVar.value.getValue(obs));
                }
                double lp = stnm.uniqueValue.getValue(i);
                if (i == 0) {
                    lastValue = lv;
                    lastDisplayValue = lastLabelValue = this.blockLabelVar != null ? blv : lv;
                    lastPosition = lp;
                    lastStart = this.xEncoder.getLowerLimit() + (double)this.leftReservedSpace;
                    if (obs < 0) {
                        this.blockStart.addValue(Double.NaN);
                    } else {
                        this.blockStart.addValue(lastStart);
                    }
                    if (this.colorIndex == null) continue;
                    double idx = obs < 0 ? 1.0 : ((NumericVariable)this.indexVar).value.getValue(obs);
                    this.colorIndex.addValue(idx);
                    continue;
                }
                if (this.continueMissingBlock(obs) || !this.repeatValue && lv.equals(lastValue)) continue;
                double start = stnm.uniqueValue.getValue(i) - stride * 0.5;
                if (obs < 0) {
                    this.blockStart.addValue(Double.NaN);
                } else {
                    this.blockStart.addValue(start);
                }
                if (this.colorIndex != null) {
                    double idx = obs < 0 ? 1.0 : ((NumericVariable)this.indexVar).value.getValue(obs);
                    this.colorIndex.addValue(idx);
                }
                double len = start - lastStart;
                double d = usableLen = this.repeatValue ? Math.min(stride * 0.5, len - stride * 0.5) * 2.0 : len;
                if (len < 0.0) {
                    StatGraph.printWarning(RB.getStringResource(RB_KEY, "sort.txt"));
                    return -1;
                }
                this.blockLength.addValue(len);
                if (this.valueFitStrategy == 1) {
                    double strLen = fm.stringWidth(lastLabelValue);
                    if (strLen / usableLen > this.maxDensity) {
                        this.maxDensity = strLen / usableLen;
                        this.theValue = lastLabelValue;
                        this.theLength = usableLen;
                    }
                    lastDisplayValue = lastLabelValue;
                } else if (this.valueFitStrategy == 0) {
                    lastDisplayValue = this.getTruncatedValue(lastLabelValue, fm, usableLen);
                } else if (this.isSplitValue()) {
                    lastDisplayValue = this.getSplitValue(lastLabelValue, fm, usableLen);
                }
                this.maxValueHeight = Math.max(this.maxValueHeight, BlockOverlay.getTextHeight(fm, lastDisplayValue));
                this.blockValue.addValue(lastValue);
                this.displayValue.addValue(lastDisplayValue);
                if (this.repeatValue) {
                    this.valuePosition.addValue(lastPosition);
                } else {
                    switch (this.valueHAlign) {
                        case 0: {
                            this.valuePosition.addValue(lastStart);
                            break;
                        }
                        case 2: {
                            this.valuePosition.addValue(lastStart + len);
                            break;
                        }
                        case 1: {
                            this.valuePosition.addValue(lastStart + len / 2.0);
                            break;
                        }
                        case 10: {
                            this.valuePosition.addValue(lastPosition);
                        }
                    }
                }
                lastStart = start;
                lastValue = lv;
                lastLabelValue = this.blockLabelVar != null ? blv : lv;
                lastDisplayValue = lv;
                lastPosition = lp;
            }
            double len = this.xEncoder.getUpperLimit() - (double)this.rightReservedSpace - lastStart;
            double usableLen = this.repeatValue ? Math.min(stride * 0.5, len - stride * 0.5) * 2.0 : len;
            this.blockLength.addValue(len);
            if (this.valueFitStrategy == 1) {
                double strLen = fm.stringWidth(lastLabelValue);
                if (strLen / usableLen > this.maxDensity) {
                    this.maxDensity = strLen / usableLen;
                    this.theValue = lastLabelValue;
                    this.theLength = usableLen;
                }
                lastDisplayValue = lastLabelValue;
            } else if (this.valueFitStrategy == 0) {
                lastDisplayValue = this.getTruncatedValue(lastLabelValue, fm, usableLen);
            } else if (this.isSplitValue()) {
                lastDisplayValue = this.getSplitValue(lastLabelValue, fm, usableLen);
            }
            this.maxValueHeight = Math.max(this.maxValueHeight, BlockOverlay.getTextHeight(fm, lastDisplayValue));
            this.blockValue.addValue(lastValue);
            this.displayValue.addValue(lastDisplayValue);
            if (this.repeatValue) {
                this.valuePosition.addValue(lastPosition);
            } else {
                switch (this.valueHAlign) {
                    case 0: {
                        this.valuePosition.addValue(lastStart);
                        break;
                    }
                    case 2: {
                        this.valuePosition.addValue(lastStart + len);
                        break;
                    }
                    case 1: {
                        this.valuePosition.addValue(lastStart + len / 2.0);
                        break;
                    }
                    case 10: {
                        this.valuePosition.addValue(lastPosition);
                    }
                }
            }
        }
        catch (MissingValueException len) {
            // empty catch block
        }
        for (int i = 0; i < this.blockValue.getValueCount(); ++i) {
            try {
                this.blockProbePipe.addValue(this.blockValue.getValue(i));
                this.blockLabelProbePipe.addValue(this.displayValue.getValue(i));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int getFirstIndexInXVarible(String uv, int[] indices) {
        StringVariable xvar = (StringVariable)this.xvalueVar;
        for (int i = 0; i < indices.length; ++i) {
            try {
                String str = StringToNumericMap.trimTrailing((String)xvar.formattedValue.getValue(indices[i]));
                if (!str.equals(uv)) continue;
                return indices[i];
            }
            catch (MissingValueException e) {
                if (uv != null) continue;
                return indices[i];
            }
        }
        return -1;
    }

    private boolean isBlockValueUnique(String uv, int[] indices) {
        StringVariable xvar = (StringVariable)this.xvalueVar;
        StringVariable bvar = (StringVariable)this.blockVar;
        int num = 0;
        String lastBStr = "";
        for (int i = 0; i < indices.length; ++i) {
            try {
                String str = xvar.formattedValue.getValue(indices[i]);
                String bStr = bvar.value.getValue(indices[i]);
                if (!str.equals(uv)) continue;
                if (num == 0) {
                    ++num;
                    lastBStr = bStr;
                    continue;
                }
                if (bStr.equals(lastBStr)) continue;
                this.dataWarning = true;
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "nonuniqueblock.txt"));
                return false;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return true;
    }

    private int getMaxSplitValueWidth() {
        StringVariable lvar = (StringVariable)this.blockVar;
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        int width = 0;
        for (int i = 0; i < lvar.getUniqueValueCount(); ++i) {
            try {
                String v = lvar.uniqueValue.getValue(i);
                String sv = this.getSplitValue(v, fm, -1.0);
                width = Math.max(width, BlockOverlay.getTextWidth(fm, sv));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return width;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        if (dimension == 1) {
            double scale;
            if (this.numericX) {
                if (this.valueHAlign == 10) {
                    if (this.isSplitValue()) {
                        return this.getMaxSplitValueWidth();
                    }
                    int nchars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
                    FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
                    StringBuffer sb = new StringBuffer(nchars);
                    for (int i = 0; i < nchars; ++i) {
                        sb = sb.append("W");
                    }
                    return fm.stringWidth(sb.toString());
                }
                return 0.0;
            }
            ValueMap vm = this.xEncoder.getValueMap();
            if (!(vm instanceof StringToNumericMap)) {
                return 0.0;
            }
            int n = Math.max(StatGraph.MPC, ((StringToNumericMap)vm).getUniqueValueCount());
            if (n > 1) {
                scale = (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit() - (double)this.leftReservedSpace - (double)this.rightReservedSpace) / (double)n;
                scale += this.discreteOffsetPadding ? (double)(2 * StatGraph.getExtraPadding()) : 0.0;
            } else {
                scale = 0.25 * (this.xEncoder.getUpperLimit() - this.xEncoder.getLowerLimit() - (double)this.leftReservedSpace - (double)this.rightReservedSpace);
            }
            if (this.valueHAlign == 10) {
                if (this.isSplitValue()) {
                    return this.getMaxSplitValueWidth();
                }
                int nchars = ScatterOverlay.getMaxStringLength(this.model, 5, null);
                FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
                StringBuffer sb = new StringBuffer(nchars);
                for (int i = 0; i < nchars; ++i) {
                    sb = sb.append("W");
                }
                return Math.max(scale, (double)fm.stringWidth(sb.toString()));
            }
            return scale;
        }
        return 0.0;
    }

    @Override
    public Insets getGridLabelMargin() {
        if (this.displayGridLabel) {
            return this.getLabelMargin();
        }
        return super.getGridLabelMargin();
    }

    @Override
    public Insets getPreferredOuterMargin() {
        if (this.displayGridLabel) {
            return new Insets(0, 0, 0, 0);
        }
        return this.getLabelMargin();
    }

    public Insets getLabelMargin() {
        if (!this.labelOn || this.blockVar == null) {
            return zeroInsets;
        }
        FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
        int h = fm.getHeight();
        Iterator iter = this.blockPlotGroups.values().iterator();
        int w = 0;
        while (iter.hasNext()) {
            BlockPlotPerGroup currentGroup = (BlockPlotPerGroup)iter.next();
            this.blockLabel = currentGroup.groupID;
            w = Math.max(fm.stringWidth(" " + this.blockLabel.trim() + " "), w);
        }
        Insets in = null;
        switch (this.labelPosition) {
            case 0: {
                if (this.isInnerMarginOverlay() || this.groupVar != null) {
                    in = new Insets(0, 0, 0, 0);
                    break;
                }
                in = new Insets(h, 0, 0, 0);
                break;
            }
            case 1: {
                if (this.isInnerMarginOverlay() || this.groupVar != null) {
                    in = new Insets(0, 0, 0, 0);
                    break;
                }
                in = new Insets(0, 0, h, 0);
                break;
            }
            case 2: {
                in = new Insets(0, w, 0, 0);
                break;
            }
            case 3: {
                in = new Insets(0, 0, 0, w);
            }
        }
        return in;
    }

    @Override
    public int getOverlayMargin() {
        if (this.isSplitValue()) {
            return this.getOverlayMarginWithSplitValues();
        }
        return this.getBlockHeight() * this.blockPlotGroups.size();
    }

    public int getBlockHeight() {
        if (this.overlayJustification == 0) {
            if (this.isSplitValue() && this.totalValueHeight != 0) {
                return (int)((this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit() - (double)this.topReservedSpace - (double)this.bottomReservedSpace) / (double)this.totalValueHeight * (double)this.maxValueHeight + 0.5) + this.blockHeightADJ;
            }
            return (int)((this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit() - (double)this.topReservedSpace - (double)this.bottomReservedSpace) / (double)this.blockPlotGroups.size() + 0.5) + this.blockHeightADJ;
        }
        int height = 0;
        if (this.valueOn || this.blockVar != null) {
            height = this.getValueHeight();
        }
        if (this.labelOn || this.labelToGridLabel) {
            int h = this.getLabelHeight();
            switch (this.labelPosition) {
                case 0: 
                case 1: {
                    height += h;
                    break;
                }
                case 2: 
                case 3: {
                    height = Math.max(h, height);
                }
            }
        }
        return height;
    }

    private int getTheOverlayHeight() {
        if (this.overlayJustification == 0) {
            return (int)(this.yEncoder.getUpperLimit() - this.yEncoder.getLowerLimit() - (double)this.topReservedSpace - (double)this.bottomReservedSpace);
        }
        return this.totalBlockHeight;
    }

    private int getLabelHeight() {
        if (this.isInnerMarginOverlay()) {
            FontMetrics fm = StatGraph.getFontMetrics(this.labelStyle.getFont());
            return fm.getHeight();
        }
        return this.getBlockHeight() - this.getValueHeight();
    }

    private int getValueHeight() {
        if (this.isInnerMarginOverlay()) {
            if (this.isSplitValue()) {
                return this.maxValueHeight;
            }
            FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
            return fm.getHeight();
        }
        if (this.groupVar == null || this.labelPosition == 2 || this.labelPosition == 3) {
            return this.getBlockHeight();
        }
        return (int)((double)this.getBlockHeight() * 0.5);
    }

    private boolean isSplitValue() {
        return !this.numericLabel && (this.valueFitStrategy == 2 && this.valueHAlign != 10 || this.valueFitStrategy == 3);
    }

    private int getOverlayMarginWithSplitValues() {
        if (this.xvalueVar == null || this.xEncoder == null) {
            return 0;
        }
        ValueMap map = this.xEncoder.getValueMap();
        if (this.numericX) {
            if (!(map instanceof ContinuousRangeToNumericMap)) {
                return 0;
            }
            if (!(this.xvalueMapper instanceof ContinuousRangeToNumericMapper)) {
                this.xvalueMapper = new ContinuousRangeToNumericMapper();
            }
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).setMap((ContinuousRangeToNumericMap)map);
        } else {
            if (!(map instanceof StringToNumericMap)) {
                return 0;
            }
            if (!(this.xvalueMapper instanceof StringToNumericMapper)) {
                this.xvalueMapper = new StringToNumericMapper();
            }
            ((StringToNumericMapper)this.xvalueMapper).setMap((StringToNumericMap)map);
        }
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null && this.xvalueVar != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if (this.numericX) {
            ((ContinuousRangeToNumericMapper)this.xvalueMapper).input.connectFrom(((NumericVariable)this.xvalueVar).value);
        } else {
            ((StringToNumericMapper)this.xvalueMapper).input.connectFrom(((StringVariable)this.xvalueVar).value);
        }
        this.totalBlockHeight = 0;
        for (BlockPlotPerGroup currentGroup : this.blockPlotGroups.values()) {
            this.blockStart = currentGroup.blockStart;
            this.blockLength = currentGroup.blockLength;
            this.valuePosition = currentGroup.valuePosition;
            this.displayValue = currentGroup.displayValue;
            this.blockValue = currentGroup.blockValue;
            this.blockProbePipe = currentGroup.blockProbePipe;
            this.blockLabelProbePipe = currentGroup.blockLabelProbePipe;
            this.colorIndex = currentGroup.colorIndex;
            int n = currentGroup.valueIndices.size();
            int[] indices = new int[n];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)currentGroup.valueIndices.get(i);
            }
            if (currentGroup.splitValueMap == null) {
                currentGroup.splitValueMap = new HashMap();
            }
            if (this.makeBlocksPerGroup(indices) != 0) {
                return 0;
            }
            this.totalBlockHeight += this.getBlockHeight();
        }
        return this.totalBlockHeight;
    }

    protected void connectVars() {
        CRD crd = this.model;
        if (crd.isAvailable(10)) {
            this.numericX = crd.getColumnClass(10) == Double.class;
            this.xvalueVar = !this.discreteX ? this.connectRaw((short)10) : this.connectCategory((short)10, this.missingCategoryOn);
            if (this.numericX && this.discreteX) {
                this.numericXVar = new NumericVectorVariable();
                ((NumericVectorVariable)this.numericXVar).connectFrom(crd.getDoubleColumn(10));
                SASFormat fmt = ((ColumnMetadata)crd.getColumnLabel(10)).getFormat();
                if (fmt == null) {
                    fmt = DataModel.defaultFormat;
                }
                this.numericXVar.setFormat(new GTKFormat((Format)fmt));
            }
            if (this.discreteX) {
                this.numericDiscreteX = this.numericX;
                this.numericX = false;
            }
        } else {
            this.xvalueVar = null;
        }
        if (crd.isAvailable(5)) {
            this.numericLabel = crd.getColumnClass(5) == Double.class;
            this.blockVar = this.connectCategory((short)5, true);
            this.blockRawVar = this.connectRaw((short)5);
        } else {
            this.blockVar = null;
        }
        this.indexVar = crd.isAvailable(44) ? this.connectRaw((short)44) : null;
        if (crd.isAvailable(3)) {
            this.groupVar = this.connectRaw((short)3);
            this.numericGroup = crd.getColumnClass(3) == Double.class;
        } else {
            this.groupVar = null;
        }
        if (crd.isAvailable(23)) {
            this.numericBlockLabel = crd.getColumnClass(23) == Double.class;
            this.blockLabelVar = (StringVariable)this.connectCategory((short)23, true);
        } else {
            this.blockLabelVar = null;
        }
        Variable urlVar = this.connectCategory((short)52, false);
        VariableProcessor vp = null;
        if (crd.whereExpression != null || this.numericX && this.sortXValues || this.groupVar != null && (this.classOrder == 1 || this.classOrder == 2)) {
            boolean chainedSort;
            vp = new VariableProcessor();
            boolean bl = chainedSort = this.numericX && this.sortXValues && this.groupVar != null && (this.classOrder == 1 || this.classOrder == 2);
            if (chainedSort) {
                Variable sortVar = this.numericXVar != null || this.xvalueVar instanceof NumericVariable ? this.connectRaw((short)10) : this.connectCategory((short)10, this.missingCategoryOn);
                this.xvalueVar = this.addVarToVP(vp, this.xvalueVar, sortVar, 1);
                if (this.numericXVar != null) {
                    this.numericXVar = (NumericVariable)this.addVarToVP(vp, (Variable)this.numericXVar, sortVar, 1);
                }
                this.blockVar = this.addVarToVP(vp, this.blockVar, sortVar, 1);
                this.blockRawVar = this.addVarToVP(vp, this.blockRawVar, sortVar, 1);
                if (this.indexVar != null) {
                    this.indexVar = this.addVarToVP(vp, this.indexVar, sortVar, 1);
                }
                if (this.groupVar != null) {
                    this.groupVar = this.addVarToVP(vp, this.groupVar, sortVar, 1);
                    if (this.classOrder == 1 || this.classOrder == 2) {
                        int sort = this.classOrder == 1 ? 1 : 2;
                        vp.setSort(this.groupVar, sort);
                        this.groupVar.setSortByFormattedValues(!this.numericGroup);
                    }
                }
                if (this.blockLabelVar != null) {
                    this.blockLabelVar = (StringVariable)this.addVarToVP(vp, (Variable)this.blockLabelVar, sortVar, 1);
                }
                if (urlVar != null) {
                    urlVar = this.addVarToVP(vp, urlVar, sortVar, 1);
                }
                this.addCRDWhereClause(vp, sortVar, 1);
            } else {
                vp.addVariable(this.xvalueVar);
                if (this.numericXVar != null) {
                    vp.addVariable((Variable)this.numericXVar);
                }
                vp.addVariable(this.blockVar);
                vp.addVariable(this.blockRawVar);
                if (this.indexVar != null) {
                    vp.addVariable(this.indexVar);
                }
                if (this.groupVar != null) {
                    vp.addVariable(this.groupVar);
                    if (this.classOrder == 1 || this.classOrder == 2) {
                        int sort = this.classOrder == 1 ? 1 : 2;
                        vp.setSort(this.groupVar, sort);
                        this.groupVar.setSortByFormattedValues(!this.numericGroup);
                    }
                }
                if (this.blockLabelVar != null) {
                    vp.addVariable((Variable)this.blockLabelVar);
                }
                if (urlVar != null) {
                    vp.addVariable(urlVar);
                }
                if (this.numericX && this.sortXValues) {
                    vp.setSort(this.xvalueVar, 1);
                    this.xvalueVar.setSortByFormattedValues(false);
                }
                this.addCRDWhereClause(vp);
            }
        }
        this.loadBlockPlotGroups();
    }

    @Override
    public Encoder getEncoder(byte dimension) {
        switch (dimension) {
            case 1: {
                return this.xEncoder;
            }
            case 2: {
                return this.yEncoder;
            }
        }
        return null;
    }

    private HashMap getGlobalColorMap() {
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        int colorCnt = 0;
        StringVariable colVar = (StringVariable)this.connectCategory((short)5, true);
        Variable xVar = this.connectRaw((short)10);
        Variable rawBVar = this.connectRaw((short)5);
        if (this.blockOrder == 1 || this.blockOrder == 2) {
            int sort = this.blockOrder == 1 ? 1 : 2;
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)colVar);
            vp.addVariable(xVar);
            vp.addVariable(rawBVar);
            if (this.numericLabel) {
                vp.setSort(rawBVar, sort);
            } else {
                vp.setSort((Variable)colVar, sort);
            }
        }
        for (int i = 0; i < colVar.getValueCount(); ++i) {
            if (xVar.isMissing(i) && (this.numericX || !this.missingCategoryOn) || rawBVar.isMissing(i) && this.continueMissingBlock(i, rawBVar)) continue;
            try {
                Color c;
                String val = colVar.value.getValue(i);
                if (colorMap.containsKey(val)) continue;
                if (LayoutOverlayParser.isMissing(val, this.numericLabel)) {
                    c = this.applyDataTransparency(this.missingColor, this.fillStyle.getTransparency());
                    colorMap.put(val, c);
                    continue;
                }
                c = this.applyDataTransparency(this.colorList[colorCnt % this.colorList.length], this.fillStyle.getTransparency());
                colorMap.put(val, c);
                ++colorCnt;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return colorMap;
    }

    @Override
    public String[] getGroupValues() {
        if (this.fillType == 1 || !this.fillOn) {
            return new String[0];
        }
        return this.getUniqueGroupValues((short)5);
    }

    public String[] getGroupValues(HashMap colorMap) {
        if (this.fillType == 1 || !this.fillOn) {
            return new String[0];
        }
        String[] gv = new String[colorMap.size()];
        StringVariable blockVar = (StringVariable)this.connectCategory((short)5, true);
        if (this.blockOrder == 1 || this.blockOrder == 2) {
            int sort = this.blockOrder == 1 ? 1 : 2;
            Variable rawBlockVar = this.connectRaw((short)5);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)blockVar);
            vp.addVariable(rawBlockVar);
            if (this.numericLabel) {
                vp.setSort(rawBlockVar, sort);
            } else {
                vp.setSort((Variable)blockVar, sort);
            }
        }
        int ii = 0;
        for (int i = 0; i < blockVar.getUniqueValueCount(); ++i) {
            try {
                if (!colorMap.containsKey(blockVar.uniqueValue.getValue(i))) continue;
                gv[ii] = blockVar.uniqueValue.getValue(i);
                ++ii;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return gv;
    }

    @Override
    public Color[] getFillColors() {
        if (this.fillType == 1 || !this.fillOn) {
            return new Color[0];
        }
        StringVariable blockVar = (StringVariable)this.connectCategory((short)5, true);
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        for (int i = 0; i < blockVar.getUniqueValueCount(); ++i) {
            try {
                String val = blockVar.uniqueValue.getValue(i);
                Color c = this.applyDataTransparency(this.colorList[i % this.colorList.length], this.getAttrTransparency((ColorAttr)this.fillStyle));
                colorMap.put(val, c);
                continue;
            }
            catch (MissingValueException val) {
                // empty catch block
            }
        }
        NumericVariable indexVar = this.model.isAvailable(44) ? (NumericVariable)this.connectRaw((short)44) : null;
        Color[] fc = new Color[blockVar.getUniqueValueCount()];
        for (int i = 0; i < fc.length; ++i) {
            try {
                if (indexVar == null) {
                    if (this.hasAttrVar("BLOCK")) {
                        DiscreteAttrMapper blockAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("BLOCK");
                        Color c = blockAttrMapper.getFillColor(blockVar.uniqueValue.getValue(i));
                        if (c != null) {
                            if (this.useFillTransparency) {
                                fc[i] = this.applyDataTransparency(c, this.getAttrTransparency((ColorAttr)this.fillStyle));
                                continue;
                            }
                            fc[i] = BlockOverlay.applyTransparency(c, blockAttrMapper.getFillTransparency(blockVar.uniqueValue.getValue(i)));
                            continue;
                        }
                        fc[i] = (Color)colorMap.get(blockVar.uniqueValue.getValue(i));
                        continue;
                    }
                    fc[i] = (Color)colorMap.get(blockVar.uniqueValue.getValue(i));
                    continue;
                }
                int obs = blockVar.getFirstOccurringValueIndex(i);
                int idx = (int)indexVar.value.getValue(obs) - 1;
                fc[i] = this.applyDataTransparency(this.colorList[idx % this.colorList.length], this.getAttrTransparency((ColorAttr)this.fillStyle));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return fc;
    }

    public Color[] getFillColors(HashMap colorMap) {
        if (this.fillType == 1 || !this.fillOn) {
            return new Color[0];
        }
        Color[] fc = new Color[colorMap.size()];
        StringVariable blockVar = (StringVariable)this.connectCategory((short)5, true);
        NumericVariable indexVar = this.model.isAvailable(44) ? (NumericVariable)this.connectRaw((short)44) : null;
        if (this.blockOrder == 1 || this.blockOrder == 2) {
            int sort = this.blockOrder == 1 ? 1 : 2;
            Variable rawBlockVar = this.connectRaw((short)5);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)blockVar);
            vp.addVariable(rawBlockVar);
            if (indexVar != null) {
                vp.addVariable((Variable)indexVar);
            }
            if (this.numericLabel) {
                vp.setSort(rawBlockVar, sort);
            } else {
                vp.setSort((Variable)blockVar, sort);
            }
        }
        int ii = 0;
        for (int i = 0; i < blockVar.getUniqueValueCount(); ++i) {
            try {
                if (!colorMap.containsKey(blockVar.uniqueValue.getValue(i))) continue;
                if (indexVar == null) {
                    DiscreteAttrMapper blockAttrMapper;
                    Color c;
                    fc[ii] = this.hasAttrVar("BLOCK") ? ((c = (blockAttrMapper = (DiscreteAttrMapper)this.getAttrVarMapper("BLOCK")).getFillColor(blockVar.uniqueValue.getValue(i))) != null ? (this.useFillTransparency ? this.applyDataTransparency(c, this.getAttrTransparency((ColorAttr)this.fillStyle)) : BlockOverlay.applyTransparency(c, blockAttrMapper.getFillTransparency(blockVar.uniqueValue.getValue(i)))) : (Color)colorMap.get(blockVar.uniqueValue.getValue(i))) : (Color)colorMap.get(blockVar.uniqueValue.getValue(i));
                } else {
                    int obs = blockVar.getFirstOccurringValueIndex(i);
                    int idx = (int)indexVar.value.getValue(obs) - 1;
                    fc[ii] = this.applyDataTransparency(this.colorList[idx % this.colorList.length], this.getAttrTransparency((ColorAttr)this.fillStyle));
                }
                ++ii;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return fc;
    }

    @Override
    public int[] getLinePatterns() {
        return new int[]{this.lineStyle.getLinePattern()};
    }

    @Override
    public int[] getLineWidths() {
        return new int[]{this.lineStyle.getWidth()};
    }

    @Override
    public Color[] getLineColors() {
        Color[] colorArray;
        if (this.isEdgeOn()) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = this.applyDataTransparency(this.lineStyle.getColor());
        } else {
            colorArray = new Color[]{};
        }
        return colorArray;
    }

    public boolean isEdgeOn() {
        return this.edgeOn;
    }

    public void setEdgeOn(boolean edgeOn) {
        this.edgeOn = edgeOn;
    }

    public boolean isFillOn() {
        return this.fillOn;
    }

    public void setFillOn(boolean fillOn) {
        this.fillOn = fillOn;
    }

    public boolean isLabelOn() {
        return this.labelOn;
    }

    public void setLabelOn(boolean labelOn) {
        this.labelOn = labelOn;
    }

    public boolean isValueOn() {
        return this.valueOn;
    }

    public void setValueOn(boolean valueOn) {
        this.valueOn = valueOn;
    }

    public int getValueHAlign() {
        return this.valueHAlign;
    }

    public void setValueHAlign(int valueHAlign) {
        this.valueHAlign = valueHAlign;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(TextStyle labelStyle) {
        this.labelStyle = labelStyle;
    }

    public TextStyle getValueStyle() {
        return this.valueStyle;
    }

    public void setValueStyle(TextStyle valueStyle) {
        this.valueStyle = valueStyle;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public LineAttrs getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineAttrs lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public int getFillType() {
        return this.fillType;
    }

    @Override
    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public int getValueVAlign() {
        return this.valueVAlign;
    }

    public void setValueVAlign(int valueVAlign) {
        this.valueVAlign = valueVAlign;
    }

    public FillAttrs getAltFillStyle() {
        return this.altFillStyle;
    }

    public void setAltFillStyle(FillAttrs altFillStyle) {
        this.altFillStyle = altFillStyle;
    }

    public FillAttrs getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillAttrs fillStyle) {
        this.fillStyle = fillStyle;
    }

    public boolean isRepeatValue() {
        return this.repeatValue;
    }

    public void setRepeatValue(boolean repeatValue) {
        this.repeatValue = repeatValue;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        Iterator iter = this.blockPlotGroups.values().iterator();
        while (iter.hasNext()) {
            ((BlockPlotPerGroup)iter.next()).setGroupID(label);
        }
    }

    public int getValueFitStrategy() {
        return this.valueFitStrategy;
    }

    public void setValueFitStrategy(int valueFitStrategy) {
        this.valueFitStrategy = valueFitStrategy;
    }

    @Override
    public void updateNetworkElements() {
        this.dynamic = true;
        this.makeBlocks();
    }

    @Override
    public boolean hasLegend(int attrType) {
        if (this.fillType == 1 || !this.fillOn) {
            return false;
        }
        switch (attrType) {
            case 0: {
                return true;
            }
            case 7: 
            case 11: {
                return this.fillOn;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                return this.edgeOn;
            }
        }
        return false;
    }

    @Override
    protected int fixDefaultAttrType(int attrType) {
        if (attrType != 0) {
            return attrType;
        }
        if (!this.fillOn) {
            return 10;
        }
        return 7;
    }

    @Override
    protected void applyFillTransparency(LegendItem[] items) {
        if (!this.fillOn || !this.useFillTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            FillAttrs fa = new FillAttrs();
            fa.setColor(this.applyDataTransparency(items[i].getSymbolAttrs().getColor(), this.fillStyle.getTransparency()));
            items[i].setSymbolAttrs((ColorAttr)fa);
        }
    }

    @Override
    protected void applyLineTransparency(LegendItem[] items) {
        if (!this.edgeOn || this.fillOn || !this.useDataTransparency) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            LineAttrs old = (LineAttrs)items[i].getSymbolAttrs();
            LineAttrs la = new LineAttrs();
            la.setColor(this.applyDataTransparency(old.getColor()));
            la.setLinePattern(old.getLinePattern());
            la.setWidth(old.getWidth());
            items[i].setSymbolAttrs((ColorAttr)la);
        }
    }

    @Override
    public LegendItem[] getLegendItems(int attrType) {
        HashMap colorMap = this.getGlobalColorMap();
        String[] values = this.getGroupValues(colorMap);
        Color[] fcolor = this.getFillColors(colorMap);
        if (fcolor.length == 0) {
            Color[] lcolor = this.getLineColors();
            int[] pattern = this.getLinePatterns();
            int[] width = this.getLineWidths();
            int n = values.length;
            LegendItem[] entries = new LegendItem[n];
            for (int i = 0; i < n; ++i) {
                LineAttrs attr = new LineAttrs();
                if (lcolor.length > 0) {
                    attr.setColor(lcolor[i % lcolor.length]);
                }
                if (pattern.length > 0) {
                    attr.setLinePattern(pattern[i % pattern.length]);
                }
                if (width.length > 0) {
                    attr.setWidth(width[i % width.length]);
                }
                entries[i] = new LegendItem((ColorAttr)attr, null, values[i], null);
            }
            if (this.fillType == 0 && this.isLegendEntryFromAttrMap("BLOCK")) {
                entries = BlockOverlay.margeAttrMapWithPlotLegendItems((DiscreteAttrMapper)this.getAttrVarMapper("BLOCK"), entries, this.fillStyle, this.lineStyle, this.fillOn, this.useFillTransparency, true, true, true, this.dataTransparency, this.useDataTransparency);
            }
            return entries;
        }
        Color[] lcolor = this.getLineColors();
        int[] pattern = this.getLinePatterns();
        int[] width = this.getLineWidths();
        int n = values.length;
        LegendItem[] entries = new LegendItem[n];
        for (int i = 0; i < n; ++i) {
            FillAttrs attr = new FillAttrs();
            if (fcolor.length > 0) {
                attr.setColor(fcolor[i % fcolor.length]);
            } else {
                attr.setColor(null);
            }
            LineAttrs attr2 = null;
            if (lcolor.length > 0 && pattern.length > 0 && width.length > 0) {
                attr2 = new LineAttrs();
                attr2.setColor(lcolor[i % lcolor.length]);
                attr2.setLinePattern(pattern[i % pattern.length]);
                attr2.setWidth(width[i % width.length]);
            }
            entries[i] = new LegendItem((ColorAttr)attr, (ColorAttr)attr2, values[i], null);
        }
        if (this.fillType == 0 && this.isLegendEntryFromAttrMap("BLOCK")) {
            entries = BlockOverlay.margeAttrMapWithPlotLegendItems((DiscreteAttrMapper)this.getAttrVarMapper("BLOCK"), entries, this.fillStyle, this.lineStyle, !this.fillOn, this.useFillTransparency, true, true, true, this.dataTransparency, this.useDataTransparency);
        }
        return entries;
    }

    private String getMissingKey() {
        String key;
        if (this.groupVar.getFormat() != null) {
            if (this.numericGroup) {
                key = this.groupVar.getFormat().format((Object)new Double(Double.NaN)).trim();
                if (key == null || key.equals(".")) {
                    key = StatGraph.missingOption;
                }
            } else {
                key = this.groupVar.getFormat().format((Object)" ").trim();
                if (key == null || key.length() == 0) {
                    key = StatGraph.missingCharacter;
                }
            }
        } else {
            key = this.numericGroup ? StatGraph.missingOption : StatGraph.missingCharacter;
        }
        return key;
    }

    private void loadBlockPlotGroups() {
        this.blockPlotGroups.clear();
        if (this.groupVar == null) {
            String useLabel = this.blockVar.getLabel();
            BlockPlotPerGroup group = new BlockPlotPerGroup(useLabel);
            this.blockPlotGroups.put(useLabel, group);
            for (int i = 0; i < this.blockVar.getValueCount(); ++i) {
                group.addValueIndex(i);
            }
        } else {
            if (this.uniformPlotSize) {
                Variable groupVar_global = this.connectRaw((short)3);
                if (this.classOrder == 1 || this.classOrder == 2) {
                    int sort = this.classOrder == 1 ? 1 : 2;
                    groupVar_global.setUniqueValueSort(sort);
                    groupVar_global.setSortByFormattedValues(!this.numericGroup);
                }
                StringPipe uv = this.numericGroup ? ((NumericVariable)groupVar_global).formattedUniqueValue : ((StringVariable)groupVar_global).formattedUniqueValue;
                int num = groupVar_global.getUniqueValueCount();
                for (int i = 0; i < num; ++i) {
                    String key;
                    try {
                        key = uv.getValue(i);
                        this.blockPlotGroups.put(key, new BlockPlotPerGroup(key));
                        continue;
                    }
                    catch (MissingValueException e) {
                        if (!this.missingGroupOn) continue;
                        key = this.getMissingKey();
                        this.blockPlotGroups.put(key, new BlockPlotPerGroup(key));
                    }
                }
            }
            StringPipe uselabel = this.numericGroup ? ((NumericVariable)this.groupVar).formattedValue : ((StringVariable)this.groupVar).formattedValue;
            for (int i = 0; i < this.groupVar.getValueCount(); ++i) {
                try {
                    String key = uselabel.getValue(i);
                    BlockPlotPerGroup group = (BlockPlotPerGroup)this.blockPlotGroups.get(key);
                    if (group == null) {
                        group = new BlockPlotPerGroup(key);
                        this.blockPlotGroups.put(key, group);
                    }
                    group.addValueIndex(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    if (!this.missingGroupOn) continue;
                    String key = this.getMissingKey();
                    BlockPlotPerGroup group = (BlockPlotPerGroup)this.blockPlotGroups.get(key);
                    if (group == null) {
                        group = new BlockPlotPerGroup(key);
                        this.blockPlotGroups.put(key, group);
                    }
                    group.addValueIndex(i);
                }
            }
        }
        for (BlockPlotPerGroup currentGroup : this.blockPlotGroups.values()) {
            if (this.probe != null) {
                currentGroup.setProbe(this.probe);
                continue;
            }
            currentGroup.probe = new Probe();
            currentGroup.probe.setTrimOn(true);
            if (this.groupVar != null) {
                StringProperty sp = new StringProperty();
                sp.setValue(currentGroup.groupID);
                currentGroup.probe.addPipe(this.groupVar.getLabel(), (Pipe)sp);
            }
            currentGroup.probe.addPipe(this.blockVar.getLabel(), (Pipe)currentGroup.blockProbePipe);
            if (this.blockLabelVar == null) continue;
            currentGroup.probe.addPipe(this.blockLabelVar.getLabel(), (Pipe)currentGroup.blockLabelProbePipe);
        }
    }

    @Override
    public boolean isOneDimensional() {
        return true;
    }

    @Override
    public boolean isDataOnHorizontalSide() {
        return true;
    }

    @Override
    public int getPreferredSizeOnDataLessSide() {
        int savedJustification = this.overlayJustification;
        this.overlayJustification = 2;
        int bh = this.getOverlayMargin();
        this.overlayJustification = savedJustification;
        return bh;
    }

    @Override
    public boolean isDegeneratedLegendContributor() {
        return this.fillType == 1;
    }

    @Override
    public String getDefaultLegendTitle() {
        if (this.isDegeneratedLegendContributor()) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)this.model.getColumnLabel(5);
        return cmd.getLabel() != null ? cmd.getLabel().trim() : cmd.getName();
    }

    class BlockPlotPerGroup {
        NumericVector blockStart = new NumericVector();
        NumericVector valuePosition = new NumericVector();
        NumericVector blockLength = new NumericVector();
        NumericVector colorIndex = null;
        StringVector displayValue = new StringVector();
        StringVector blockValue = new StringVector();
        StringVector blockProbePipe = new StringVector();
        StringVector blockLabelProbePipe = new StringVector();
        ArrayList valueIndices = new ArrayList();
        String groupID;
        Probe probe;
        int maxValueHeight;
        HashMap splitValueMap;

        BlockPlotPerGroup(String groupID) {
            this.groupID = groupID;
            if (BlockOverlay.this.indexVar != null) {
                this.colorIndex = new NumericVector();
            }
        }

        void addValueIndex(int i) {
            this.valueIndices.add(new Integer(i));
        }

        void setGroupID(String ID) {
            this.groupID = ID;
        }

        void setProbe(Probe probe) {
            this.probe = probe;
        }
    }
}

