/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.overlays;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RB;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.text.SASFormat;
import java.awt.Graphics;
import java.text.Format;

public class BiVarHistogramOverlay
extends HistogramOverlay {
    public static final String RB_KEY = "BiVarHistogramOverlay.";
    protected double constBinSize2 = 0.0;
    protected byte yValues = 0;
    protected NumericVariable yvalueVar;
    private NetworkRoot networkRoot;
    public Bar bar = new Bar();
    private ContinuousRangeToNumericMapper responseMapper;
    private ColorMapper colorMapper;
    double defaultBinSize2 = 0.0;
    protected DataRange zRange = null;
    protected PositionEncoder zEncoder = null;

    public byte getYValues() {
        return this.yValues;
    }

    public void setYValues(byte aByte) {
        this.yValues = aByte;
    }

    public void setDefaultBinSize2(double size) {
        this.defaultBinSize2 = size;
    }

    @Override
    protected void updateXRange() {
        DataRange newRange = null;
        DataRange oldRange = this.xRange;
        newRange = this.orientation == 0 ? this.getIndRange(this.xvalueVar, this.constBinSize) : this.getDepRange();
        this.setFormat(newRange, 13);
        this.xRange = newRange;
        this.fireRangeEvent((byte)1, oldRange, newRange);
    }

    protected void updateZRange() {
        DataRange newRange = null;
        DataRange oldRange = this.zRange;
        newRange = this.getIndRange(this.yvalueVar, this.constBinSize2);
        this.setFormat(newRange, 24);
        this.zRange = newRange;
        this.fireRangeEvent((byte)3, oldRange, newRange);
    }

    @Override
    protected void updateYRange() {
        DataRange newRange = null;
        DataRange oldRange = this.yRange;
        newRange = this.orientation == 0 ? this.getDepRange() : this.getIndRange(this.xvalueVar, this.constBinSize);
        this.setFormat(newRange, 2);
        this.yRange = newRange;
        this.fireRangeEvent((byte)2, oldRange, newRange);
    }

    @Override
    public void setChannel(Channel channel) {
        this.networkRoot = new NetworkRoot(channel);
    }

    @Override
    public void draw(Graphics g) {
        if (this.networkRoot == null) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        if (this.needConnect && !this.connectNetwork()) {
            return;
        }
        this.networkRoot.draw(channel, false);
    }

    @Override
    public void select() {
        if (this.networkRoot == null || this.needConnect) {
            return;
        }
        Channel channel = this.networkRoot.getChannel();
        this.networkRoot.draw(channel, true);
    }

    @Override
    public void setEncoder(byte dimension, Encoder encoder) {
        if (dimension == 1) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.xEncoder = (PositionEncoder)encoder;
        } else if (dimension == 2) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.yEncoder = (PositionEncoder)encoder;
        } else if (dimension == 3) {
            if (!(encoder instanceof PositionEncoder)) {
                return;
            }
            this.zEncoder = (PositionEncoder)encoder;
        }
        this.needConnect = true;
    }

    @Override
    public void setModel(CRD aModel) {
        this.model = aModel;
        this.connectVars();
        this.updateXRange();
        this.updateYRange();
        this.updateZRange();
    }

    @Override
    public void setEdgeOn(boolean edgeOn) {
        super.setEdgeOn(edgeOn);
        this.bar.edgeOn.setValue(edgeOn);
    }

    @Override
    public void setFillOn(boolean fillOn) {
        super.setFillOn(fillOn);
        this.bar.fillOn.setValue(fillOn);
    }

    @Override
    protected boolean connectNetwork() {
        if (this.xvalueVar == null) {
            return false;
        }
        if (this.yvalueVar == null) {
            return false;
        }
        if (this.responseVar == null) {
            return false;
        }
        if (this.xEncoder == null) {
            return false;
        }
        if (this.yEncoder == null) {
            return false;
        }
        if (this.zEncoder == null) {
            return false;
        }
        PositionEncoder ve = null;
        ve = this.orientation == 0 ? this.xEncoder : this.yEncoder;
        ValueMap map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper midpointMapper = new ContinuousRangeToNumericMapper();
        midpointMapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper leftMapper = new ContinuousRangeToNumericMapper();
        leftMapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper rightMapper = new ContinuousRangeToNumericMapper();
        rightMapper.setMap((ContinuousRangeToNumericMap)map);
        ve = this.zEncoder;
        map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper midpoint2Mapper = new ContinuousRangeToNumericMapper();
        midpoint2Mapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper left2Mapper = new ContinuousRangeToNumericMapper();
        left2Mapper.setMap((ContinuousRangeToNumericMap)map);
        ContinuousRangeToNumericMapper right2Mapper = new ContinuousRangeToNumericMapper();
        right2Mapper.setMap((ContinuousRangeToNumericMap)map);
        ve = this.orientation == 0 ? this.yEncoder : this.xEncoder;
        map = ve.getValueMap();
        if (!(map instanceof ContinuousRangeToNumericMap)) {
            return false;
        }
        ContinuousRangeToNumericMapper responseMapper = new ContinuousRangeToNumericMapper();
        responseMapper.setMap((ContinuousRangeToNumericMap)map);
        SASFormat format = this.xEncoder.getInput().getFormat();
        if (format != null) {
            this.xvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if ((format = this.zEncoder.getInput().getFormat()) != null) {
            this.yvalueVar.setFormat(new GTKFormat((Format)format));
        }
        if ((format = this.yEncoder.getInput().getFormat()) != null) {
            this.responseVar.setFormat(new GTKFormat((Format)format));
        }
        switch (this.xValues) {
            default: {
                midpointMapper.input.connectFrom(this.xvalueVar.value);
                Calculator left = new Calculator("inA-inB/2");
                left.inA.connectFrom(this.xvalueVar.value);
                left.inB.setValue(this.constBinSize);
                leftMapper.input.connectFrom((NumericPipe)left);
                Calculator right = new Calculator("inA+inB/2");
                right.inA.connectFrom(this.xvalueVar.value);
                right.inB.setValue(this.constBinSize);
                rightMapper.input.connectFrom((NumericPipe)right);
                break;
            }
            case 1: {
                Calculator midpoint = new Calculator("inA+inB/2");
                midpoint.inA.connectFrom(this.xvalueVar.value);
                midpoint.inB.setValue(this.constBinSize);
                midpointMapper.input.connectFrom((NumericPipe)midpoint);
                leftMapper.input.connectFrom(this.xvalueVar.value);
                Calculator right = new Calculator("inA+inB");
                right.inA.connectFrom(this.xvalueVar.value);
                right.inB.setValue(this.constBinSize);
                rightMapper.input.connectFrom((NumericPipe)right);
                break;
            }
            case 2: {
                Calculator midpoint = new Calculator("inA-inB/2");
                midpoint.inA.connectFrom(this.xvalueVar.value);
                midpoint.inB.setValue(this.constBinSize);
                midpointMapper.input.connectFrom((NumericPipe)midpoint);
                Calculator left = new Calculator("inA-inB");
                left.inA.connectFrom(this.xvalueVar.value);
                left.inB.setValue(this.constBinSize);
                leftMapper.input.connectFrom((NumericPipe)left);
                rightMapper.input.connectFrom(this.xvalueVar.value);
            }
        }
        Calculator width = new Calculator("inB-inA");
        width.inA.connectFrom((NumericPipe)leftMapper);
        width.inB.connectFrom((NumericPipe)rightMapper);
        switch (this.yValues) {
            default: {
                midpoint2Mapper.input.connectFrom(this.yvalueVar.value);
                Calculator left2 = new Calculator("inA-inB/2");
                left2.inA.connectFrom(this.yvalueVar.value);
                left2.inB.setValue(this.constBinSize2);
                left2Mapper.input.connectFrom((NumericPipe)left2);
                Calculator right2 = new Calculator("inA+inB/2");
                right2.inA.connectFrom(this.yvalueVar.value);
                right2.inB.setValue(this.constBinSize2);
                right2Mapper.input.connectFrom((NumericPipe)right2);
                break;
            }
            case 1: {
                Calculator midpoint2 = new Calculator("inA+inB/2");
                midpoint2.inA.connectFrom(this.yvalueVar.value);
                midpoint2.inB.setValue(this.constBinSize2);
                midpoint2Mapper.input.connectFrom((NumericPipe)midpoint2);
                left2Mapper.input.connectFrom(this.yvalueVar.value);
                Calculator right2 = new Calculator("inA+inB");
                right2.inA.connectFrom(this.yvalueVar.value);
                right2.inB.setValue(this.constBinSize2);
                right2Mapper.input.connectFrom((NumericPipe)right2);
                break;
            }
            case 2: {
                Calculator midpoint2 = new Calculator("inA-inB/2");
                midpoint2.inA.connectFrom(this.yvalueVar.value);
                midpoint2.inB.setValue(this.constBinSize2);
                midpoint2Mapper.input.connectFrom((NumericPipe)midpoint2);
                Calculator left2 = new Calculator("inA-inB");
                left2.inA.connectFrom(this.yvalueVar.value);
                left2.inB.setValue(this.constBinSize2);
                left2Mapper.input.connectFrom((NumericPipe)left2);
                right2Mapper.input.connectFrom(this.yvalueVar.value);
            }
        }
        Calculator width2 = new Calculator("inB-inA");
        width2.inA.connectFrom((NumericPipe)left2Mapper);
        width2.inB.connectFrom((NumericPipe)right2Mapper);
        double mappedBaseline = responseMapper.getValue(this.baseline);
        responseMapper.input.connectFrom(this.responseVar.value);
        Calculator height = new Calculator("inA-inB");
        height.inA.connectFrom((NumericPipe)responseMapper);
        height.inB.setValue(mappedBaseline);
        Calculator middle = new Calculator("(inA+inB)/2");
        middle.inA.setValue(mappedBaseline);
        middle.inB.connectFrom((NumericPipe)responseMapper);
        this.networkRoot.removeAllElements();
        this.networkRoot.addElement((Element)this.bar);
        this.bar.setUserData((Object)this.probe);
        this.bar.setTwoD(false);
        this.bar.startValue.setValue(mappedBaseline);
        this.bar.endValue.connectFrom((NumericPipe)responseMapper);
        this.bar.thickness.connectFrom((NumericPipe)width);
        this.bar.depth.connectFrom((NumericPipe)width2);
        this.bar.transform.translateZ.connectFrom((NumericPipe)midpoint2Mapper);
        this.bar.position.connectFrom((NumericPipe)midpointMapper);
        this.bar.verticalOn.setValue(this.orientation == 0);
        this.bar.edgeOn.setValue(this.edgeOn);
        if (this.edgeOn) {
            this.bar.edgeColor.setValue(this.edgeStyle.getColor());
            this.bar.edgePattern.setValue(this.edgeStyle.getLinePattern());
            this.bar.edgeWidth.setValue((double)this.edgeStyle.getWidth());
        }
        this.bar.fillOn.setValue(this.fillOn);
        if (this.fillOn) {
            if (this.colorMapper != null) {
                this.bar.color1.connectFrom((ColorPipe)this.colorMapper);
            } else {
                this.bar.color1.setValue(this.applyDataTransparency((ColorAttr)this.fillStyle));
            }
        } else {
            this.bar.color1.setValue(this.edgeStyle.getColor());
        }
        this.needConnect = false;
        return true;
    }

    @Override
    protected void connectVars() {
        if (this.model == null) {
            return;
        }
        CRD crd = this.model;
        this.xvalueVar = null;
        if (crd.isAvailable(13)) {
            if (crd.getColumnClass(13) != Double.class) {
                StatGraph.printDebug("VBar : MIDPOINT must be numeric");
            } else {
                this.xvalueVar = (NumericVectorVariable)this.connectRaw((short)13);
            }
        }
        this.yvalueVar = null;
        if (crd.isAvailable(24)) {
            if (crd.getColumnClass(24) != Double.class) {
                StatGraph.printDebug("MIDPOINT2 must be numeric");
            } else {
                this.yvalueVar = (NumericVectorVariable)this.connectRaw((short)24);
            }
        }
        this.responseVar = null;
        if (crd.isAvailable(2)) {
            if (crd.getColumnClass(2) != Double.class) {
                StatGraph.printDebug("VBar : RESPONSE must be numeric");
            } else {
                this.responseVar = (NumericVectorVariable)this.connectRaw((short)2);
            }
        }
        if (this.model.whereExpression != null) {
            VariableProcessor vp = new VariableProcessor();
            this.addVarToVP(vp, (Variable)this.xvalueVar);
            this.addVarToVP(vp, (Variable)this.yvalueVar);
            this.addVarToVP(vp, (Variable)this.responseVar);
            this.addCRDWhereClause(vp);
        }
        if (this.defaultBinSize > 0.0) {
            this.constBinSize = this.defaultBinSize;
        } else if (this.xvalueVar != null) {
            this.constBinSize = this.getBinSize(this.xvalueVar);
        }
        if (this.defaultBinSize2 > 0.0) {
            this.constBinSize2 = this.defaultBinSize2;
        } else if (this.yvalueVar != null) {
            this.constBinSize2 = this.getBinSize(this.yvalueVar);
        }
    }

    private double getBinSize(NumericVariable mpVar) {
        if (this.isPresortData()) {
            NumericVariable nvar = new NumericVariable();
            nvar.connectFrom(mpVar);
            VariableProcessor vp = new VariableProcessor();
            vp.addVariable((Variable)nvar);
            vp.setSort((Variable)nvar, 1);
            mpVar = nvar;
        }
        double minDiff = 2.0;
        GTKFormat fmt = mpVar.getFormat();
        mpVar.setFormat(null);
        int num = mpVar.getUniqueValueCount();
        if (num < 2) {
            return minDiff;
        }
        double prev = 0.0;
        try {
            prev = mpVar.uniqueValue.getValue(0);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        double mid = 0.0;
        boolean badBin = false;
        for (int i = 1; i < num; ++i) {
            try {
                mid = mpVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException mve) {
                continue;
            }
            if (i == 1) {
                minDiff = mid - prev;
            } else {
                if (Math.abs(mid - prev - minDiff) > 1.0E-6) {
                    badBin = true;
                }
                minDiff = Math.min(minDiff, mid - prev);
            }
            prev = mid;
        }
        if (badBin) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "bin.txt"));
        }
        if (minDiff < 0.0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "bin2.txt"));
        }
        mpVar.setFormat(fmt);
        return minDiff;
    }

    protected DataRange getIndRange(NumericVariable mpVar, double binSize) {
        SimpleBinnedRange range = null;
        if (mpVar != null) {
            int num = mpVar.getValueCount();
            if (num > 0) {
                double max;
                double min;
                CRD crd = this.model;
                short role = 13;
                byte values = this.xValues;
                if (mpVar == this.yvalueVar) {
                    role = 24;
                    values = this.yValues;
                }
                if (crd.whereExpression != null) {
                    min = mpVar.getMin();
                    max = mpVar.getMax();
                } else {
                    min = crd.getColumnMin(role);
                    max = crd.getColumnMax(role);
                }
                double halfbin1 = 0.0;
                double halfbin2 = 0.0;
                if (this.binAxis) {
                    SimpleBinnedRange sbr;
                    range = sbr = new SimpleBinnedRange();
                    sbr.setBinSize(binSize);
                    sbr.setEndLabels(this.endLabels);
                    switch (values) {
                        default: {
                            sbr.setFirstMidpoint(min);
                            sbr.setLastMidpoint(max);
                            break;
                        }
                        case 1: {
                            sbr.setFirstMidpoint(min + binSize / 2.0);
                            sbr.setLastMidpoint(max + binSize / 2.0);
                            break;
                        }
                        case 2: {
                            sbr.setFirstMidpoint(min - binSize / 2.0);
                            sbr.setLastMidpoint(max - binSize / 2.0);
                            break;
                        }
                    }
                } else {
                    switch (values) {
                        default: {
                            min -= binSize / 2.0;
                            max += binSize / 2.0;
                            break;
                        }
                        case 1: {
                            max += binSize;
                            break;
                        }
                        case 2: {
                            min -= binSize;
                        }
                    }
                    range = new ContinuousRange(min, max);
                }
                if (this.binAxis) {
                    ContinuousRange cr = new ContinuousRange((DataRange)range);
                    range.setDual((DataRange)cr);
                }
                if (mpVar instanceof NumericVectorVariable) {
                    range.setLabel(mpVar.getLabel());
                }
            } else {
                range = null;
            }
        }
        return range;
    }

    @Override
    protected DataRange getDepRange() {
        ContinuousRange range = null;
        if (this.responseVar != null) {
            int num = this.responseVar.getValueCount();
            if (num > 0) {
                double max;
                double min;
                CRD crd = this.model;
                if (crd.whereExpression != null) {
                    min = this.responseVar.getMin();
                    max = this.responseVar.getMax();
                } else {
                    min = crd.getColumnMin((short)2);
                    max = crd.getColumnMax((short)2);
                }
                range = new ContinuousRange(Math.min(this.baseline, min), Math.max(this.baseline, max));
                range.setLabel(this.responseVar.getLabel());
            } else {
                range = null;
            }
        }
        return range;
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        if (dimension == 1) {
            return this.xRange;
        }
        if (dimension == 2) {
            return this.yRange;
        }
        if (dimension == 3) {
            return this.zRange;
        }
        return null;
    }

    public double getDefaultBinSize2() {
        return this.defaultBinSize2;
    }

    @Override
    public double getPreferredOffset(byte dimension) {
        return 5.0;
    }
}

