/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.legend;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.RB;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.attrmap.Range;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AxisMetrics;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.ColorVector;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.TickMarkStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.ColorRampLegend;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.Rectangle;
import com.sas.graphics.util.ods.visual.IVIZColor;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Locale;

public class VLegend {
    public static final String RB_KEY = "VRectAxis.";
    private int x;
    private int y;
    private int width;
    private int height;
    private String title;
    private boolean horizontal = false;
    private boolean smooth = true;
    protected int nTicks = 6;
    protected SASFormat valueFormat;
    private Channel channel;
    private ColorEncoder colorEncoder;
    private ColorMap colorMap = null;
    private NetworkRoot root;
    public ColorRampLegend vtkLegend;
    public IVIZColor colorRamp;
    public double[] levels;
    public boolean goodLevels = false;
    private Range[] colorModelRanges = null;
    private double minValue;
    private double maxValue;
    public static final int DISPLAY_MISSING_OFF = 0;
    public static final int DISPLAY_MISSING_ON = 1;
    public static final int DISPLAY_MISSING_AUTO = 2;
    private int displayMissing = 0;
    private boolean plotHasMissingData = false;
    private Color missingColor = null;
    private String missingChickletLabel = ".";
    private Color borderLineColor = Color.black;
    private boolean autoTitle = false;
    private boolean extractScale = false;
    private boolean scientificScale = false;
    private boolean integer = false;

    public VLegend() {
        this.vtkLegend = new ColorRampLegend();
        this.vtkLegend.setSVGRender(StatGraph.VGF);
    }

    public AxisMetrics getMetrics() {
        return this.vtkLegend.getMetrics(this.channel);
    }

    public void setNTicks(int aInt) {
        this.nTicks = aInt;
    }

    public TextStyle getValueStyle() {
        return this.vtkLegend.getLabelStyle();
    }

    public TextStyle getTitleStyle() {
        return this.vtkLegend.getTitleStyle();
    }

    public TickMarkStyle getTickStyle() {
        return this.vtkLegend.getTickStyle();
    }

    public void setValueFormat(SASFormat format) {
        this.valueFormat = format;
    }

    public void setHorizontal(boolean flag) {
        this.horizontal = flag;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setSmooth(boolean flag) {
        this.smooth = flag;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setColorEncoder(ColorEncoder cei) {
        this.colorEncoder = cei;
        this.updateLeg();
    }

    public ColorEncoder getColorEncoder() {
        return this.colorEncoder;
    }

    public void setColorModelRanges(Range[] ranges) {
        if (ranges == null) {
            return;
        }
        this.smooth = false;
        for (int i = 0; i < ranges.length; ++i) {
            if (ranges[i].getColorModel().getColors().length <= 1) continue;
            this.smooth = true;
            break;
        }
        this.minValue = ranges[0].getMin().getValue();
        this.maxValue = ranges[ranges.length - 1].getMax().getValue();
        this.colorModelRanges = ranges;
        this.updateLeg();
    }

    private void updateLeg() {
        if (this.width == 0 && this.height == 0) {
            return;
        }
        if (this.colorEncoder != null) {
            this.updateLeg2();
        }
        this.vtkLegend.getStyle().setMarkerEdgeColor(this.borderLineColor);
        this.vtkLegend.getStyle().getTickStyle().setColor(this.borderLineColor);
        if (this.colorModelRanges != null) {
            int length = this.horizontal ? this.width : this.height;
            --length;
            int missingChickletSize = 0;
            int mcs_total = 0;
            Rectangle missingChicklet = null;
            RasterLabel mRasterLabel = null;
            boolean drawMissingChicklet = false;
            switch (this.displayMissing) {
                case 2: {
                    drawMissingChicklet = this.plotHasMissingData;
                    break;
                }
                case 1: {
                    drawMissingChicklet = true;
                    break;
                }
                default: {
                    drawMissingChicklet = false;
                }
            }
            if (drawMissingChicklet && this.missingColor != null) {
                double f = StatGraph.dataSizeScaleFactor;
                missingChickletSize = (int)(this.vtkLegend.getLegendThickness() * f);
                if (this.horizontal) {
                    ++missingChickletSize;
                }
                int padding = (int)(10.0 * f);
                mcs_total = missingChickletSize + padding;
                length -= mcs_total;
                missingChicklet = new Rectangle();
                missingChicklet.sizeX.setValue((double)missingChickletSize);
                missingChicklet.sizeY.setValue((double)missingChickletSize);
                missingChicklet.fillOn.setValue(true);
                missingChicklet.color.setValue(this.missingColor);
                missingChicklet.edgeOn.setValue(true);
                missingChicklet.edgeColor.setValue(this.borderLineColor);
            }
            double min = this.minValue;
            double max = this.maxValue;
            double r = max - min;
            SASFormat fmt = this.valueFormat == null ? DataModel.defaultFormat : this.valueFormat;
            boolean reformat = !NumericFormat.isNamedFormat((SASFormat)fmt) || fmt != null && fmt.isNumericFormat() && fmt.getFormatDescription().isDecimalWidthSupported();
            StringVector strings = new StringVector();
            ColorVector colors = new ColorVector();
            NumericVector labelPercentages = new NumericVector();
            NumericVector colorPercentages = new NumericVector();
            String titleSuffix = "";
            this.vtkLegend.setSmoothShading(this.smooth);
            if (this.smooth) {
                if (this.colorModelRanges.length == 1) {
                    if (min == max) {
                        if (this.integer) {
                            min = (int)min;
                        }
                        if (reformat && !NumericFormat.isNamedFormat((SASFormat)fmt)) {
                            fmt = DataModel.defaultFormat;
                        }
                        max = min + 2.0;
                        strings.addValue(fmt.format((Object)new Double(min)));
                        strings.addValue(fmt.format((Object)new Double(min + 1.0)));
                        strings.addValue(fmt.format((Object)new Double(min + 2.0)));
                        labelPercentages.addValue(0.0);
                        labelPercentages.addValue(0.5);
                        labelPercentages.addValue(1.0);
                    } else {
                        double tv;
                        int i;
                        boolean useZiAxis = this.integer;
                        if (this.integer && Math.ceil(min) > Math.floor(max)) {
                            useZiAxis = false;
                        }
                        double[] val = useZiAxis ? ZxAxis.ziaxis((long)((long)Math.floor(min)), (long)((long)Math.ceil(max)), (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8) : ZxAxis.znaxis((double)min, (double)max, (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8);
                        double minTick = val[0];
                        int tickInt = (int)(val[2] - 1.0);
                        double maxTick = minTick + val[1] * (double)tickInt;
                        double interval = val[1];
                        if (tickInt > 1) {
                            if (minTick - min < interval / 4.0) {
                                minTick += interval;
                                --tickInt;
                            }
                            if (max - maxTick < interval / 4.0) {
                                --tickInt;
                            }
                        }
                        if (reformat) {
                            titleSuffix = this.getGGoodLabels(minTick, maxTick, interval, tickInt + 1, fmt, strings);
                            for (i = 0; i < tickInt + 1; ++i) {
                                tv = minTick + (double)i * interval;
                                labelPercentages.addValue(this.fixPercentage((tv - min) / r));
                            }
                        } else {
                            for (i = 0; i < tickInt + 1; ++i) {
                                tv = minTick + (double)i * interval;
                                strings.addValue(fmt.format((Object)new Double(tv)));
                                labelPercentages.addValue(this.fixPercentage((tv - min) / r));
                            }
                        }
                    }
                    Color[] c = this.colorModelRanges[0].getColorModel().getColors();
                    for (int i = 0; i < c.length; ++i) {
                        colors.addValue(c[i]);
                        colorPercentages.addValue(this.fixPercentage((double)i / ((double)c.length - 1.0)));
                    }
                } else {
                    if (reformat && !NumericFormat.isNamedFormat((SASFormat)fmt)) {
                        fmt = DataModel.defaultFormat;
                    }
                    r = max - min;
                    double v = this.colorModelRanges[0].getMin().getValue();
                    strings.addValue(fmt.format((Object)new Double(v)));
                    labelPercentages.addValue(this.fixPercentage((v - min) / r));
                    for (int i = 0; i < this.colorModelRanges.length; ++i) {
                        Range range = this.colorModelRanges[i];
                        double v1 = range.getMin().getValue();
                        double v2 = range.getMax().getValue();
                        strings.addValue(fmt.format((Object)new Double(v2)));
                        labelPercentages.addValue(this.fixPercentage((v2 - min) / r));
                        Color[] c = range.getColorModel().getColors();
                        if (c.length == 1) {
                            colors.addValue(c[0]);
                            colorPercentages.addValue(this.fixPercentage((v1 - min) / r));
                            colors.addValue(c[0]);
                            colorPercentages.addValue(this.fixPercentage((v2 - min) / r));
                            continue;
                        }
                        for (int j = 0; j < c.length; ++j) {
                            v = v1 + (v2 - v1) / ((double)c.length - 1.0) * (double)j;
                            colors.addValue(c[j]);
                            colorPercentages.addValue(this.fixPercentage((v - min) / r));
                        }
                    }
                    this.vtkLegend.setLabelFitAlgorithm(new String[]{""});
                }
            } else {
                double v;
                if (reformat && !NumericFormat.isNamedFormat((SASFormat)fmt)) {
                    fmt = DataModel.defaultFormat;
                }
                if ((r = max - min) == 0.0) {
                    v = this.colorModelRanges[0].getMin().getValue();
                    strings.addValue(fmt.format((Object)new Double(v)));
                    labelPercentages.addValue(0.0);
                    v = this.colorModelRanges[0].getMax().getValue();
                    strings.addValue(fmt.format((Object)new Double(v)));
                    labelPercentages.addValue(1.0);
                    Color c = this.colorModelRanges[0].getColorModel().getColors()[0];
                    colors.addValue(c);
                    colorPercentages.addValue(1.0);
                } else {
                    v = this.colorModelRanges[0].getMin().getValue();
                    strings.addValue(fmt.format((Object)new Double(v)));
                    labelPercentages.addValue(this.fixPercentage((v - min) / r));
                    for (int i = 0; i < this.colorModelRanges.length; ++i) {
                        v = this.colorModelRanges[i].getMax().getValue();
                        Color c = this.colorModelRanges[i].getColorModel().getColors()[0];
                        strings.addValue(fmt.format((Object)new Double(v)));
                        labelPercentages.addValue(this.fixPercentage((v - min) / r));
                        colors.addValue(c);
                        colorPercentages.addValue(this.fixPercentage((v - min) / r));
                    }
                }
                this.vtkLegend.setLabelFitAlgorithm(new String[]{"thin_beginning_to_end"});
            }
            this.vtkLegend.labels.connectFrom((StringPipe)strings);
            this.vtkLegend.colors.connectFrom((ColorPipe)colors);
            this.vtkLegend.colorPlacementPercentage.connectFrom((NumericPipe)colorPercentages);
            this.vtkLegend.labelPlacementPercentage.connectFrom((NumericPipe)labelPercentages);
            this.vtkLegend.setLength((double)length);
            this.vtkLegend.title.setValue(this.title + titleSuffix);
            this.vtkLegend.setTitleOn(this.title != null);
            this.vtkLegend.setShowThinnedTicks(false);
            if (titleSuffix != null && titleSuffix.length() > 0) {
                this.vtkLegend.setTitleTruncateEndCount(titleSuffix.length());
                this.vtkLegend.setDropAxisAsNeeded(true);
            }
            if (this.horizontal) {
                this.vtkLegend.setOrientation(1);
                this.vtkLegend.setTitlePosition(1);
                this.vtkLegend.setTitleAngle(0.0);
            } else {
                this.vtkLegend.setOrientation(2);
                this.vtkLegend.setTitlePosition(3);
                this.vtkLegend.setTitleAngle(90.0);
            }
            AxisMetrics m = this.getMetrics();
            this.vtkLegend.setLength((double)length - m.getHighExtender() - m.getLowExtender());
            if (this.horizontal) {
                this.vtkLegend.transform.translateX.setValue(m.getLowExtender());
                this.vtkLegend.transform.translateY.setValue(0.0);
            } else {
                this.vtkLegend.transform.translateX.setValue(0.0);
                this.vtkLegend.transform.translateY.setValue(m.getLowExtender() + 1.0);
            }
            if (StatGraph.dataSizeScaleFactor < 1.0) {
                this.vtkLegend.setContinuousColorBarThickness(StatGraph.dataSizeScaleFactor);
            }
            if (missingChicklet != null) {
                mRasterLabel = new RasterLabel();
                mRasterLabel.string.setValue(this.missingChickletLabel);
                NetworkRoot nr = new NetworkRoot();
                nr.addElement((Element)mRasterLabel);
                BoundingBox bb = nr.computeBoundingBox(this.channel);
                int labelWidth = (int)bb.getSize().x;
                int labelHeight = (int)bb.getSize().y;
                if (this.horizontal) {
                    int xpos = (int)this.vtkLegend.getLength() + (int)(10.0 * StatGraph.dataSizeScaleFactor) + missingChickletSize / 2;
                    missingChicklet.coordX.setValue((double)xpos);
                    missingChicklet.coordY.setValue((double)(this.height - missingChickletSize / 2));
                    missingChicklet.transform.translateX.setValue(m.getLowExtender());
                    mRasterLabel.coordX.setValue((double)(xpos - labelWidth / 2));
                    mRasterLabel.coordY.setValue((double)(this.height - missingChickletSize) - 5.0 * StatGraph.dataSizeScaleFactor - (double)(labelHeight / 2));
                    mRasterLabel.transform.translateX.setValue(m.getLowExtender());
                } else {
                    int ypos = (int)this.vtkLegend.getLength() + (int)(10.0 * StatGraph.dataSizeScaleFactor) + missingChickletSize / 2;
                    missingChicklet.coordX.setValue((double)(missingChickletSize / 2));
                    missingChicklet.coordY.setValue((double)ypos);
                    missingChicklet.transform.translateY.setValue(m.getLowExtender() + 1.0);
                    mRasterLabel.coordX.setValue((double)missingChickletSize + 5.0 * StatGraph.dataSizeScaleFactor);
                    mRasterLabel.coordY.setValue((double)(ypos - missingChickletSize / 2));
                    mRasterLabel.transform.translateY.setValue(m.getLowExtender() + 1.0);
                }
            }
            this.root.removeAllElements();
            this.root.addElement((Element)this.vtkLegend);
            if (missingChicklet != null) {
                this.root.addElement((Element)missingChicklet);
            }
            if (mRasterLabel != null) {
                this.root.addElement((Element)mRasterLabel);
            }
        }
    }

    private double fixPercentage(double p) {
        return Math.min(1.0, Math.max(p, 0.0));
    }

    private void updateLeg2() {
        ValueMap map;
        if (this.width == 0 && this.height == 0) {
            return;
        }
        this.colorMap = null;
        if (this.colorEncoder != null && (map = this.colorEncoder.getValueMap()) instanceof ColorMap) {
            this.colorMap = (ColorMap)map;
        }
        if (this.colorMap != null) {
            double max;
            double min;
            int length = this.horizontal ? this.width : this.height;
            --length;
            if (this.goodLevels && !this.smooth) {
                min = this.levels[0];
                max = this.levels[this.levels.length - 1];
            } else {
                ContinuousRange range = (ContinuousRange)this.colorEncoder.getInput();
                min = range.getMin();
                max = range.getMax();
            }
            double r = max - min;
            SASFormat fmt = this.valueFormat == null ? DataModel.defaultFormat : this.valueFormat;
            boolean reformat = !NumericFormat.isNamedFormat((SASFormat)fmt) || fmt != null && fmt.isNumericFormat() && fmt.getFormatDescription().isDecimalWidthSupported();
            StringVector strings = new StringVector();
            ColorVector colors = new ColorVector();
            NumericVector labelPercentages = new NumericVector();
            NumericVector colorPercentages = new NumericVector();
            String titleSuffix = "";
            this.vtkLegend.setSmoothShading(this.smooth);
            if (this.smooth) {
                if (min == max) {
                    if (reformat && !NumericFormat.isNamedFormat((SASFormat)fmt)) {
                        fmt = DataModel.defaultFormat;
                    }
                    max = min + 2.0;
                    strings.addValue(fmt.format((Object)new Double(min)));
                    strings.addValue(fmt.format((Object)new Double(min + 1.0)));
                    strings.addValue(fmt.format((Object)new Double(min + 2.0)));
                    labelPercentages.addValue(0.0);
                    labelPercentages.addValue(0.5);
                    labelPercentages.addValue(1.0);
                } else {
                    double[] val = ZxAxis.znaxis((double)min, (double)max, (boolean)true, (boolean)false, (int)(this.nTicks + 1), (double)0.2, (double)0.8);
                    double minTick = val[0];
                    int tickInt = (int)(val[2] - 1.0);
                    double maxTick = minTick + val[1] * (double)tickInt;
                    double interval = val[1];
                    if (minTick - min < interval / 4.0) {
                        minTick += interval;
                        --tickInt;
                    }
                    if (max - maxTick < interval / 4.0) {
                        --tickInt;
                    }
                    if (reformat) {
                        titleSuffix = this.getGGoodLabels(minTick, maxTick, interval, tickInt + 1, fmt, strings);
                        for (int i = 0; i < tickInt + 1; ++i) {
                            double tv = minTick + (double)i * interval;
                            labelPercentages.addValue(this.fixPercentage((tv - min) / r));
                        }
                    } else {
                        for (int i = 0; i < tickInt + 1; ++i) {
                            double tv = minTick + (double)i * interval;
                            strings.addValue(fmt.format((Object)new Double(tv)));
                            labelPercentages.addValue(this.fixPercentage((tv - min) / r));
                        }
                    }
                }
                colors.addValue(this.colorEncoder.startColor);
                colors.addValue(this.colorEncoder.mediumColor);
                colors.addValue(this.colorEncoder.endColor);
                colorPercentages.addValue(0.0);
                colorPercentages.addValue(0.5);
                colorPercentages.addValue(1.0);
            } else {
                if (reformat && !NumericFormat.isNamedFormat((SASFormat)fmt)) {
                    fmt = DataModel.defaultFormat;
                }
                int alpha = this.colorEncoder.startColor.getAlpha();
                min = this.levels[0];
                max = this.levels[this.levels.length - 1];
                r = max - min;
                for (int i = 0; i < this.levels.length; ++i) {
                    strings.addValue(fmt.format((Object)new Double(this.levels[i])));
                    labelPercentages.addValue(this.fixPercentage((this.levels[i] - min) / r));
                    if (i <= 0) continue;
                    Color c = this.colorRamp.Query(this.levels[i], this.levels[0], this.levels[this.levels.length - 1], false);
                    colors.addValue(new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha));
                    colorPercentages.addValue(this.fixPercentage((this.levels[i] - min) / r));
                }
            }
            this.vtkLegend.labels.connectFrom((StringPipe)strings);
            this.vtkLegend.colors.connectFrom((ColorPipe)colors);
            this.vtkLegend.colorPlacementPercentage.connectFrom((NumericPipe)colorPercentages);
            this.vtkLegend.labelPlacementPercentage.connectFrom((NumericPipe)labelPercentages);
            this.vtkLegend.setLength((double)length);
            this.vtkLegend.title.setValue(this.title + titleSuffix);
            this.vtkLegend.setTitleOn(this.title != null);
            if (titleSuffix != null && titleSuffix.length() > 0) {
                this.vtkLegend.setTitleTruncateEndCount(titleSuffix.length());
                this.vtkLegend.setDropAxisAsNeeded(true);
            }
            if (this.horizontal) {
                this.vtkLegend.setOrientation(1);
                this.vtkLegend.setTitlePosition(1);
                this.vtkLegend.setTitleAngle(0.0);
            } else {
                this.vtkLegend.setOrientation(2);
                this.vtkLegend.setTitlePosition(3);
                this.vtkLegend.setTitleAngle(90.0);
            }
            AxisMetrics m = this.getMetrics();
            this.vtkLegend.setLength((double)length - m.getHighExtender() - m.getLowExtender());
            if (this.horizontal) {
                this.vtkLegend.transform.translateX.setValue(m.getLowExtender());
                this.vtkLegend.transform.translateY.setValue(0.0);
            } else {
                this.vtkLegend.transform.translateX.setValue(0.0);
                this.vtkLegend.transform.translateY.setValue(m.getLowExtender() + 1.0);
            }
            if (StatGraph.dataSizeScaleFactor < 1.0) {
                this.vtkLegend.setContinuousColorBarThickness(StatGraph.dataSizeScaleFactor);
            }
            this.root.removeAllElements();
            this.root.addElement((Element)this.vtkLegend);
        }
    }

    private String getGGoodLabels(double min, double max, double inc, int labelCount, SASFormat valueFormat, StringVector labels) {
        String baseName;
        boolean scaling = this.extractScale && this.title != null;
        boolean groupBy3 = !this.scientificScale;
        Object[] info = NumericFormat.getGGoodFormat((double)min, (double)max, (double)inc, (int)-1, (int)-1, (int)-1, (boolean)scaling, (boolean)groupBy3);
        SASFormat fmt = (SASFormat)info[0];
        int power = 0;
        if (info[1] != null) {
            power = ((Number)info[1]).intValue();
        }
        double scale = Math.pow(10.0, -power);
        String string = baseName = valueFormat == null || !NumericFormat.isNamedFormat((SASFormat)valueFormat) ? null : valueFormat.getBaseFormatName();
        if (baseName != null) {
            int d;
            int w = valueFormat.getFormatDescription().getMaxWidth();
            if (fmt.getFormatDescription().isDecimalWidthSupported()) {
                d = fmt.getDecimalWidth();
                if (valueFormat.isPercent()) {
                    if (scaling && !groupBy3) {
                        power += 2;
                        scale /= 100.0;
                    } else {
                        d -= 2;
                        d = Math.max(0, d);
                    }
                }
            } else {
                d = valueFormat.getDecimalWidth();
                power = 0;
                scale = 1.0;
            }
            fmt = SASFormat.getInstance((String)(baseName + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
            fmt.setInsertBlanks(false);
        }
        Locale currentLocale = Locale.getDefault();
        StatGraph.setSessionLocale();
        String suffix = " ";
        switch (power) {
            case 0: {
                suffix = "";
                break;
            }
            case 1: {
                suffix = suffix + RB.getStringResource(RB_KEY, "ten.txt");
                break;
            }
            case 2: {
                suffix = suffix + RB.getStringResource(RB_KEY, "hundred.txt");
                break;
            }
            case 3: {
                suffix = suffix + RB.getStringResource(RB_KEY, "thousand.txt");
                break;
            }
            case 6: {
                suffix = suffix + RB.getStringResource(RB_KEY, "million.txt");
                break;
            }
            case 9: {
                suffix = suffix + RB.getStringResource(RB_KEY, "billion.txt");
                break;
            }
            case 12: {
                suffix = suffix + RB.getStringResource(RB_KEY, "trillion.txt");
                break;
            }
            case -6: {
                suffix = suffix + RB.getStringResource(RB_KEY, "millionth.txt");
                break;
            }
            case -9: {
                suffix = suffix + RB.getStringResource(RB_KEY, "billionth.txt");
                break;
            }
            case -12: {
                suffix = suffix + RB.getStringResource(RB_KEY, "trillionth.txt");
                break;
            }
            default: {
                Message message = new Message(RB.getStringResource(RB_KEY, "exponent.fmt.txt"));
                suffix = suffix + message.toString((Object)Integer.toString(power));
            }
        }
        Locale.setDefault(currentLocale);
        double[] v = new double[labelCount];
        v[0] = min * scale;
        for (int i = 1; i < labelCount; ++i) {
            v[i] = v[i - 1] + inc * scale;
        }
        v = NumericFormat.processValues((double[])v, (double)(inc * scale));
        boolean eFormat = fmt.getName().startsWith("E") || fmt.getName().startsWith("e");
        for (int i = 0; i < labelCount; ++i) {
            if (eFormat) {
                labels.addValue(NumericFormat.getTrimmedValue((String)fmt.format((Object)new Double(v[i])).trim()));
                continue;
            }
            labels.addValue(fmt.format((Object)new Double(v[i])).trim());
        }
        return suffix;
    }

    public boolean isVisible() {
        return true;
    }

    public void draw(Graphics g) {
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(true);
        }
        this.root.draw(this.channel);
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(false);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.updateLeg();
    }

    public Dimension getPreferredSize() {
        if (this.width == 0 || this.height == 0) {
            this.setBounds(0, 0, 640, 480);
        }
        AxisMetrics m = this.getMetrics();
        if (this.isHorizontal()) {
            return new Dimension(50, (int)Math.ceil(m.getHeight() - 1.0E-4));
        }
        return new Dimension((int)Math.ceil(m.getWidth() - 1.0E-4), 50);
    }

    public void setChannel(Channel aChannel) {
        this.channel = aChannel;
        this.root = new NetworkRoot(this.channel);
    }

    public int getDisplayMissing() {
        return this.displayMissing;
    }

    public void setDisplayMissing(int displayMissing) {
        this.displayMissing = displayMissing;
    }

    public void setExactScale(boolean extract) {
        this.extractScale = extract;
    }

    public boolean isExtractScale() {
        return this.extractScale;
    }

    public void setScientificScale(boolean b) {
        this.scientificScale = b;
    }

    public boolean isScientificScale() {
        return this.scientificScale;
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Color missingColor) {
        this.missingColor = missingColor;
    }

    public String getMissingChickletLabel() {
        return this.missingChickletLabel;
    }

    public void setMissingChickletLabel(String missingChickletLabel) {
        this.missingChickletLabel = missingChickletLabel;
    }

    public boolean plotHasMissingData() {
        return this.plotHasMissingData;
    }

    public void setPlotHasMissingData(boolean plotHasMissing) {
        this.plotHasMissingData = plotHasMissing;
    }

    public boolean isAutoTitle() {
        return this.autoTitle;
    }

    public void setAutoTitle(boolean autoTitle) {
        this.autoTitle = autoTitle;
    }

    public Color getBorderLineColor() {
        return this.borderLineColor;
    }

    public void setBorderLineColor(Color borderLineColor) {
        this.borderLineColor = borderLineColor;
    }

    public boolean isInteger() {
        return this.integer;
    }

    public void setInteger(boolean integer) {
        this.integer = integer;
    }
}

