/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.legend;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class SizeLegendComponent
extends AbstractSGComponent {
    String title;
    private TextStyle titleStyle = new TextStyle();
    private boolean titleBorder = false;
    private String[] graphNames = null;
    private boolean clippingAllowed = false;
    private Color valueColor = null;
    private Color itemFillColor = null;
    private Color itemOutlineColor = null;
    private static final int SWATCH_SIZE = 20;
    private static final int ARROW_HEAD_SIZE = 8;
    private boolean autoTitle = false;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public Font getTitleFont() {
        return this.titleStyle.getFont();
    }

    public void setTitleFont(Font titleFont) {
        this.titleStyle.setFont(titleFont);
    }

    public Color getTitleColor() {
        return this.titleStyle.getColor();
    }

    public void setTitleColor(Color titleColor) {
        this.titleStyle.setColor(titleColor);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(Color valueColor) {
        this.valueColor = valueColor;
    }

    public boolean isTitleBorder() {
        return this.titleBorder;
    }

    public void setTitleBorder(boolean titleBorder) {
        this.titleBorder = titleBorder;
    }

    public boolean isClippingAllowed() {
        return this.clippingAllowed;
    }

    public void setClippingAllowed(boolean b) {
        this.clippingAllowed = b;
    }

    public String[] getGraphNames() {
        return this.graphNames;
    }

    public void setGraphNames(String[] graphNames) {
        this.graphNames = graphNames;
    }

    public Color getItemFillColor() {
        return this.itemFillColor;
    }

    public void setItemFillColor(Color itemFillColor) {
        this.itemFillColor = itemFillColor;
    }

    public Color getItemOutlineColor() {
        return this.itemOutlineColor;
    }

    public void setItemOutlineColor(Color itemOutlineColor) {
        this.itemOutlineColor = itemOutlineColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int textX = 0;
        int textY = 0;
        FontMetrics fm = StatGraph.getFontMetrics(this.titleStyle.getFont());
        double titleWidth = 0.0;
        if (this.title != null && fm != null) {
            Rectangle2D textBounds = fm.getStringBounds(this.title, g);
            titleWidth = textBounds.getWidth();
        }
        if (this.isHorizontal()) {
            textX = (int)(this.getBounds().getWidth() / 2.0 - titleWidth / 2.0);
        } else {
            textY = (int)(this.getBounds().getHeight() / 2.0 - titleWidth / 2.0);
        }
        Insets insets = this.getInsets();
        int startX = insets.left;
        int startY = insets.top;
        int arrowHeadSize = (int)(8.0 * StatGraph.dataDPIScaleFactor);
        int halfArrowHeadSize = (arrowHeadSize + 1) / 2;
        int gap = (int)(2.0 * StatGraph.dataDPIScaleFactor);
        int swatchSize = (int)(20.0 * StatGraph.dataDPIScaleFactor);
        int swatchX = 0;
        int swatchY = 0;
        int vertArrowXPos = 0;
        if (this.isHorizontal()) {
            swatchX = (int)(this.getBounds().getWidth() / 2.0 - (double)(swatchSize / 2));
            swatchY = startY;
            vertArrowXPos = swatchX - gap - halfArrowHeadSize;
        } else {
            swatchX = startX + arrowHeadSize + gap;
            swatchY = (int)(this.getBounds().getHeight() / 2.0 - (double)(swatchSize / 2) - (double)halfArrowHeadSize - (double)(gap / 2));
            vertArrowXPos = startX + halfArrowHeadSize;
        }
        int horzArrowYPos = swatchY + swatchSize + gap + halfArrowHeadSize - 1;
        g.setColor(this.itemOutlineColor);
        int vArrowEnd = swatchY + swatchSize;
        g.drawLine(vertArrowXPos, swatchY, vertArrowXPos, vArrowEnd);
        int[] xPoints = new int[]{vertArrowXPos, vertArrowXPos - halfArrowHeadSize, vertArrowXPos + halfArrowHeadSize + 1};
        int[] yPoints = new int[]{swatchY, swatchY + halfArrowHeadSize, swatchY + halfArrowHeadSize};
        g.fillPolygon(xPoints, yPoints, 3);
        xPoints = new int[]{vertArrowXPos, vertArrowXPos - halfArrowHeadSize + 1, vertArrowXPos + halfArrowHeadSize};
        yPoints = new int[]{vArrowEnd + 1, vArrowEnd - halfArrowHeadSize + 1, vArrowEnd - halfArrowHeadSize + 1};
        g.fillPolygon(xPoints, yPoints, 3);
        int hArrowEnd = swatchX + swatchSize;
        g.drawLine(swatchX, horzArrowYPos, hArrowEnd, horzArrowYPos);
        xPoints = new int[]{swatchX, swatchX + halfArrowHeadSize, swatchX + halfArrowHeadSize};
        yPoints = new int[]{horzArrowYPos, horzArrowYPos - halfArrowHeadSize, horzArrowYPos + halfArrowHeadSize};
        g.fillPolygon(xPoints, yPoints, 3);
        xPoints = new int[]{hArrowEnd + 1, hArrowEnd + 1 - halfArrowHeadSize, hArrowEnd + 1 - halfArrowHeadSize};
        yPoints = new int[]{horzArrowYPos, horzArrowYPos - halfArrowHeadSize, horzArrowYPos + halfArrowHeadSize};
        g.fillPolygon(xPoints, yPoints, 3);
        g.setColor(this.itemFillColor);
        g.fillRect(swatchX, swatchY, swatchSize, swatchSize);
        g.setColor(this.itemOutlineColor);
        g.drawRect(swatchX, swatchY, swatchSize, swatchSize);
        int labelGap = (int)(4.0 * StatGraph.dataDPIScaleFactor);
        if (this.title != null) {
            g.setColor(this.titleStyle.getColor());
            g.setFont(this.titleStyle.getFont());
            if (this.isHorizontal()) {
                textY = horzArrowYPos + halfArrowHeadSize + labelGap + fm.getAscent();
                g.drawString(this.title, textX, textY);
            } else {
                textX = swatchX + swatchSize + labelGap + fm.getAscent();
                Graphics2D g2 = null;
                AffineTransform oldTransform = null;
                if (g instanceof Graphics2D) {
                    g2 = (Graphics2D)g;
                    oldTransform = g2.getTransform();
                }
                g2.rotate(-1.5707963267948966, 0.0, 0.0);
                g.drawString(this.title, -((int)(this.getBounds().getHeight() - (double)textY)), textX);
                if (g2 != null && oldTransform != null) {
                    g2.setTransform(oldTransform);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int arrowHeadSize = (int)(8.0 * StatGraph.dataDPIScaleFactor);
        int gap = (int)(2.0 * StatGraph.dataDPIScaleFactor);
        int swatchSize = (int)(20.0 * StatGraph.dataDPIScaleFactor);
        int startX = insets.left;
        int halfArrowHeadSize = (arrowHeadSize + 1) / 2;
        int vertArrowXPos = startX + halfArrowHeadSize;
        int swatchX = vertArrowXPos + halfArrowHeadSize + gap;
        int labelGap = (int)(4.0 * StatGraph.dataDPIScaleFactor);
        int prefHeight = 0;
        int prefWidth = 0;
        int symbolSize = swatchSize + gap + arrowHeadSize;
        FontMetrics fm = StatGraph.getFontMetrics(this.titleStyle.getFont());
        int labelHeight = fm.getHeight();
        int titleWidth = 0;
        if (fm != null && this.title != null) {
            titleWidth = (int)fm.getStringBounds(" " + this.title + " ", null).getWidth();
        }
        if (this.isHorizontal()) {
            prefHeight = symbolSize + labelGap + labelHeight + insets.top + insets.bottom;
            prefWidth = Math.max(symbolSize, titleWidth);
            prefWidth = prefWidth + insets.left + insets.right;
        } else {
            prefHeight = Math.max(symbolSize, titleWidth);
            prefHeight = prefHeight + insets.top + insets.bottom;
            prefWidth = symbolSize + labelGap + labelHeight + insets.left + insets.right;
        }
        Dimension d = new Dimension(prefWidth, prefHeight);
        return d;
    }

    public boolean isAutoTitle() {
        return this.autoTitle;
    }

    public void setAutoTitle(boolean autoTitle) {
        this.autoTitle = autoTitle;
    }
}

