/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.labeling;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Candidate;
import com.sas.graphics.applets.statgraph.sgchart.labeling.LabelPlacementInterface;
import com.sas.graphics.applets.statgraph.sgchart.labeling.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public final class Graph
implements LabelPlacementInterface {
    public static final int RULE_L1 = 0;
    public static final int RULE_L2 = 1;
    public static final int RULE_L3 = 2;
    public static int MAX_CANDIDATES = 8;
    public static int MIN_FONTSIZE = 10;
    public static int MIN_ACCEPTABLE_SCORE = 100;
    ArrayList nodes;
    Rectangle clipBounds;
    int hMaxShift = 0;
    int vMaxShift = 0;
    double vDistanceWeight = 1.0;
    int shiftDeltaX = 0;
    int shiftDeltaY = 0;
    private ArrayList obstacles = null;
    private boolean userCandidates = false;
    private Node[] allNodes = null;

    public Graph(Rectangle bounds) {
        this(bounds, false);
    }

    public Graph(Rectangle bounds, boolean user) {
        this.clipBounds = bounds;
        this.nodes = new ArrayList();
        this.userCandidates = user;
    }

    public ArrayList getObstacles() {
        return this.obstacles;
    }

    @Override
    public void addObstacle(Shape obstacle) {
        if (this.obstacles == null) {
            this.obstacles = new ArrayList();
        }
        this.obstacles.add(obstacle);
    }

    public int getHMaxShift() {
        return this.hMaxShift;
    }

    public void setHMaxShift(int shift) {
        this.hMaxShift = shift;
    }

    public int getVMaxShift() {
        return this.vMaxShift;
    }

    public void setVMaxShift(int shift) {
        this.vMaxShift = shift;
    }

    public double getVDistanceWeight() {
        return this.vDistanceWeight;
    }

    public void setVDistanceWeight(double weight) {
        this.vDistanceWeight = weight;
    }

    public int getShiftDeltaX() {
        return this.shiftDeltaX;
    }

    public void setShiftDeltaX(int shiftDeltaX) {
        this.shiftDeltaX = shiftDeltaX;
    }

    public int getShiftDeltaY() {
        return this.shiftDeltaY;
    }

    public void setShiftDeltaY(int shiftDeltaY) {
        this.shiftDeltaY = shiftDeltaY;
    }

    public void addNode(int id, String label, int x, int y, FontMetrics fm, int ms, int[] candidateList, boolean preciseBBox, boolean diagonalOffset) {
        Node n = new Node(id, label, x, y, fm, ms, preciseBBox);
        n.diagonalOffset = diagonalOffset;
        n.createCandidates(this.clipBounds, this.obstacles, candidateList);
        this.nodes.add(n);
    }

    public boolean isFreeOfObstacles() {
        return this.obstacles == null;
    }

    public static void addObstaclePoint(GeneralPath obstacle, int x, int y) {
        if (obstacle.getCurrentPoint() == null) {
            obstacle.moveTo(x, y);
        } else {
            obstacle.lineTo(x, y);
            obstacle.moveTo(x, y);
        }
    }

    public static boolean isObstructed(ArrayList obstacles, Rectangle r) {
        if (obstacles == null) {
            return false;
        }
        boolean obstructed = false;
        for (int i = 0; i < obstacles.size(); ++i) {
            Shape obstacle = (Shape)obstacles.get(i);
            if (!obstacle.intersects(r)) continue;
            obstructed = true;
            break;
        }
        return obstructed;
    }

    public static boolean isObstructed(ArrayList obstacles, int x, int y, int w, int h) {
        if (obstacles == null) {
            return false;
        }
        boolean obstructed = false;
        for (int i = 0; i < obstacles.size(); ++i) {
            Shape obstacle = (Shape)obstacles.get(i);
            if (!obstacle.intersects(x, y, w, h)) continue;
            obstructed = true;
            break;
        }
        return obstructed;
    }

    public void buildConflictGraph() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node s = (Node)this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Node d = (Node)this.nodes.get(j);
                this.addConflict(s, d);
            }
        }
    }

    private void addConflict(Node s, Node d) {
        if (s.text == null || d.text == null) {
            return;
        }
        Iterator i = s.getCandidates();
        while (i.hasNext()) {
            Candidate sc = (Candidate)i.next();
            Rectangle rs = sc.bbox;
            Iterator j = d.getCandidates();
            while (j.hasNext()) {
                Candidate dc = (Candidate)j.next();
                Rectangle rd = dc.bbox;
                Rectangle ir = rd.intersection(rs);
                if (ir.width <= 1 || ir.height <= 1) continue;
                sc.addConflictPartner(dc);
                dc.addConflictPartner(sc);
            }
        }
    }

    public void placeLabels() {
        int i;
        Node n;
        ListIterator i2 = this.nodes.listIterator();
        while (i2.hasNext()) {
            n = (Node)i2.next();
            if (n.text == null) continue;
            n.doPhaseI(0);
        }
        i2 = this.nodes.listIterator();
        while (i2.hasNext()) {
            n = (Node)i2.next();
            if (n.text == null) continue;
            n.doPhaseI(1);
        }
        i2 = this.nodes.listIterator();
        while (i2.hasNext()) {
            n = (Node)i2.next();
            if (n.text == null) continue;
            n.doPhaseI(2);
        }
        for (int maxCandidates = MAX_CANDIDATES; maxCandidates > 0; --maxCandidates) {
            ListIterator i3 = this.nodes.listIterator();
            while (i3.hasNext()) {
                Node n2 = (Node)i3.next();
                if (n2.text == null || n2.candidates.size() != maxCandidates) continue;
                n2.doPhaseII();
            }
        }
        if (this.hMaxShift != 0 || this.vMaxShift != 0) {
            this.allNodes = new Node[this.nodes.size()];
            for (i = 0; i < this.nodes.size(); ++i) {
                this.allNodes[i] = n = (Node)this.nodes.get(i);
                if (n.text == null || !n.resolved || n.delayed) continue;
                n.resolvedCandidate = n.getCandidate(0);
            }
            for (i = 0; i < this.allNodes.length; ++i) {
                n = this.allNodes[i];
                if (n.text == null || n.text.trim().length() == 0 || !n.delayed) continue;
                this.resolveDelayed(n);
            }
        } else {
            for (i = 0; i < this.nodes.size(); ++i) {
                n = (Node)this.nodes.get(i);
                if (n.text == null || !n.delayed) continue;
                n.resolveObstructedCandidate(this.clipBounds, this.nodes);
            }
        }
    }

    private void resolveDelayed(Node node) {
        int i;
        int nNodes = this.allNodes.length;
        int ix = this.shiftDeltaX;
        int iy = this.shiftDeltaY;
        int xMax = this.shiftDeltaX == 0 ? 0 : this.hMaxShift / ix;
        int yMax = this.shiftDeltaY == 0 ? 0 : this.vMaxShift / iy;
        Candidate[] can = null;
        Rectangle[] bb = null;
        if (this.userCandidates) {
            int nc = node.candidateList.length;
            can = new Candidate[nc];
            bb = new Rectangle[nc];
            for (int i2 = 0; i2 < nc; ++i2) {
                can[i2] = new Candidate(node, node.candidateList[i2]);
                bb[i2] = can[i2].bbox;
            }
        } else {
            can = new Candidate[8];
            bb = new Rectangle[8];
            for (int i3 = 0; i3 < 8; ++i3) {
                can[i3] = new Candidate(node, i3);
                bb[i3] = can[i3].bbox;
            }
        }
        Candidate c = null;
        int deltaX = 0;
        int deltaY = 0;
        int bw = bb[0].width;
        int bh = bb[0].height;
        int y = 0;
        Candidate fc = null;
        double minDist = Double.MAX_VALUE;
        boolean overlapUp = false;
        boolean overlapDown = false;
        for (i = 0; i <= 2 * yMax; ++i) {
            y = i % 2 == 0 ? -iy * i / 2 : iy * (i / 2 + 1);
            if (this.userCandidates) {
                if (overlapUp && overlapDown) break;
                if (y < 0 && overlapUp || y > 0 && overlapDown) continue;
            }
            int x = 0;
            block3: for (int j = 0; j <= 2 * xMax; ++j) {
                x = j % 2 == 0 ? -ix * j / 2 : ix * (j / 2 + 1);
                for (int ci = 0; ci < can.length; ++ci) {
                    double ds;
                    c = can[ci];
                    int bx = bb[ci].x;
                    int by = bb[ci].y;
                    if (!this.clipBounds.contains(bx += x, by += y, bw, bh) && !this.userCandidates || Graph.isObstructed(this.obstacles, bx, by, bw, bh)) continue;
                    boolean found = true;
                    for (int k = 0; k < nNodes; ++k) {
                        Node n = this.allNodes[k];
                        if (n == node) continue;
                        if (n.text != null && n.resolved && !n.delayed) {
                            Rectangle bn = n.resolvedCandidate.bbox;
                            if (bx + bw > bn.x && by + bh > bn.y && bx < bn.x + bn.width && by < bn.y + bn.height) {
                                found = false;
                                if (y < 0 && n.y < node.y) {
                                    overlapUp = true;
                                    break;
                                }
                                if (y <= 0 || n.y <= node.y) break;
                                overlapDown = true;
                                break;
                            }
                        }
                        if (n.markerRect.width <= 0 || n.markerRect.height <= 0 || bx + bw <= n.markerRect.x || by + bh <= n.markerRect.y || bx >= n.markerRect.x + n.markerRect.width || by >= n.markerRect.y + n.markerRect.height) continue;
                        found = false;
                        if (y < 0 && n.y < node.y) {
                            overlapUp = true;
                            break;
                        }
                        if (y <= 0 || n.y <= node.y) break;
                        overlapDown = true;
                        break;
                    }
                    if (!found || !((ds = this.getMinimumDistance(c, x, y, bw, bh)) < minDist)) continue;
                    minDist = ds;
                    fc = c;
                    deltaX = x;
                    deltaY = y;
                    continue block3;
                }
            }
        }
        if (fc == null) {
            if (node.lastRemovedCandidate != null) {
                fc = node.lastRemovedCandidate;
            } else if (this.userCandidates) {
                fc = can[0];
            } else {
                for (i = 4; i < 8; ++i) {
                    fc = new Candidate(node, i);
                    Rectangle r = new Rectangle(fc.bbox);
                    r.y = this.clipBounds.y + this.clipBounds.height - r.y;
                    if (this.clipBounds.contains(r)) break;
                }
            }
        }
        if (node.getNumCandidates() > 0) {
            node.candidates.remove(0);
        }
        node.dx = deltaX;
        node.dy = deltaY;
        node.candidates.add(fc);
        fc.calcBBox();
        if (this.userCandidates) {
            int y0 = fc.bbox.y;
            int yh = fc.bbox.height;
            if (y0 < this.clipBounds.y) {
                node.dy += this.clipBounds.y - y0;
            } else if (y0 + yh > this.clipBounds.y + this.clipBounds.height) {
                node.dy -= y0 + yh - (this.clipBounds.y + this.clipBounds.height);
            }
        }
        node.resolvedCandidate = fc;
        node.setResolved(true);
        node.delayed = false;
    }

    private double getMinimumDistance(Candidate c, int x, int y, int bw, int bh) {
        double dist = (double)Math.abs(x) + this.vDistanceWeight * (double)Math.abs(y);
        double dist2 = (double)Math.abs(x) + this.vDistanceWeight * (double)Math.max(Math.abs(y) - bh, 0);
        if (!this.userCandidates) {
            return dist;
        }
        switch (c.position) {
            case 0: 
            case 1: {
                if (y <= 0) {
                    return dist;
                }
                return dist2;
            }
            case 2: 
            case 3: {
                if (y >= 0) {
                    return dist;
                }
                return dist2;
            }
            case 4: 
            case 6: {
                return (double)Math.abs(x) + this.vDistanceWeight * Math.max((double)Math.abs(y) - (double)bh * 0.5, 0.0);
            }
            case 5: 
            case 7: {
                return Math.max((double)Math.abs(x) - (double)bw * 0.5, 0.0) + this.vDistanceWeight * (double)Math.abs(y);
            }
        }
        return dist;
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public Node getNode(int index) {
        return (Node)this.nodes.get(index);
    }

    public void draw(Graphics gc) {
        ListIterator i = this.nodes.listIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.text == null) continue;
            gc.setColor(Color.lightGray);
            if (n.getLabelPosition() != -1) {
                Rectangle r = n.getCandidate((int)0).bbox;
                gc.drawRect(r.x, r.y, r.width, r.height);
            } else {
                gc.drawRect(n.x - n.textWidth, n.y - n.textHeight, 2 * n.textWidth, 2 * n.textHeight);
                gc.drawLine(n.x, n.y - n.textHeight, n.x, n.y + n.textHeight);
                gc.drawLine(n.x - n.textWidth, n.y, n.x + n.textWidth, n.y);
            }
            gc.setColor(Color.black);
            switch (n.getLabelPosition()) {
                default: {
                    break;
                }
                case 0: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + -n.textDescent);
                    break;
                }
                case 1: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy - n.textDescent);
                    break;
                }
                case 2: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight - n.textDescent);
                    break;
                }
                case 3: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight - n.textDescent);
                    break;
                }
                case 4: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    break;
                }
                case 5: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy - n.textDescent);
                    break;
                }
                case 6: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    break;
                }
                case 7: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy + n.textHeight - n.textDescent);
                }
            }
            gc.setColor(Color.red);
            gc.fillRect(n.x - 1, n.y - 1, 3, 3);
        }
    }

    public void reduceFonts() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            FontMetrics fm;
            Font f;
            Node n = (Node)this.nodes.get(i);
            if (n.text == null || n.text.trim().isEmpty() || (f = n.fm.getFont()).getSize() <= MIN_FONTSIZE) continue;
            n.reset();
            f = new Font(f.getFamily(), f.getStyle(), f.getSize() - 1);
            n.fm = fm = StatGraph.getFontMetrics(f);
            TextLayout tl = new TextLayout(n.text, f, fm.getFontRenderContext());
            n.textWidth = (int)Math.ceil(tl.getBounds().getWidth());
            n.textHeight = (int)Math.ceil(tl.getBounds().getHeight());
            n.textDescent = fm.getDescent();
            n.createCandidates(this.clipBounds, this.obstacles, n.candidateList);
        }
    }

    public int getTotalShiftedDistance() {
        int totalShift = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node n = (Node)this.nodes.get(i);
            totalShift += Math.abs(n.dx) + Math.abs(n.dy);
        }
        return totalShift;
    }
}

