/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.labeling;

import com.sas.graphics.applets.statgraph.sgchart.labeling.CurveGraph;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Rectangle;

public class CurveNode {
    public int index;
    public String text;
    public int x;
    public int y;
    public FontMetrics fm;
    private int textWidth;
    private int textHeight;
    public int out_x;
    public int out_y;
    public Color out_color;
    public int out_halign;
    public int out_valign = 1;
    public boolean rotated = false;
    public int location;
    public int position;

    public CurveNode(int index, String label, int x, int y, Color color, FontMetrics fm) {
        this.index = index;
        this.text = label;
        this.x = x;
        this.y = y;
        this.fm = fm;
        this.textWidth = Overlay.getTextWidth(fm, label);
        this.textHeight = Overlay.getTextHeight(fm, label);
        this.out_color = color;
        this.out_x = x;
        this.out_y = y;
    }

    public int getWidth() {
        return this.textWidth;
    }

    public int getHeight() {
        return this.textHeight;
    }

    public int getLower(int axis) {
        if (axis == 2 || axis == 3) {
            return this.out_y - this.textHeight / 2;
        }
        if (this.rotated) {
            double rc = Math.sin(Math.toRadians(CurveGraph.rotationAngle));
            return this.out_x - (int)((double)this.textHeight / (2.0 * rc));
        }
        return this.out_x - this.textWidth / 2;
    }

    public int getUpper(int axis) {
        if (axis == 2 || axis == 3) {
            return this.out_y + this.textHeight / 2;
        }
        if (this.rotated) {
            double rc = Math.sin(Math.toRadians(CurveGraph.rotationAngle));
            return this.out_x + (int)((double)this.textHeight / (2.0 * rc));
        }
        return this.out_x + this.textWidth / 2;
    }

    public void shift(int delta, Rectangle b, int axis) {
        if (axis == 2 || axis == 3) {
            int low = b.y;
            int high = b.y + b.height;
            this.out_y += delta;
            if (this.getUpper(axis) > high) {
                this.out_y = high - this.textHeight / 2;
            }
            if (this.getLower(axis) < low) {
                this.out_y = low + this.textHeight / 2;
            }
        } else {
            int low = b.x;
            int high = b.x + b.width;
            this.out_x += delta;
            if (this.rotated) {
                double rc = Math.sin(Math.toRadians(CurveGraph.rotationAngle));
                if (this.getUpper(axis) > high) {
                    this.out_x = high - (int)((double)this.textHeight / (2.0 * rc));
                }
                if (this.getLower(axis) < low) {
                    this.out_x = low + (int)((double)this.textHeight / (2.0 * rc));
                }
            } else {
                if (this.getUpper(axis) > high) {
                    this.out_x = high - this.textWidth / 2;
                }
                if (this.getLower(axis) < low) {
                    this.out_x = low + this.textWidth / 2;
                }
            }
        }
    }

    public void clip(Rectangle b, int axis) {
        if (axis == 2 || axis == 3) {
            int low = b.y;
            int high = b.y + b.height;
            if (this.getUpper(axis) > high) {
                this.out_y = high - this.textHeight / 2;
            }
            if (this.getLower(axis) < low) {
                this.out_y = low + this.textHeight / 2;
            }
        } else {
            int low = b.x;
            int high = b.x + b.width;
            if (this.rotated) {
                if (this.getUpper(axis) > high) {
                    this.out_x = high - this.textHeight / 2;
                }
                if (this.getLower(axis) < low) {
                    this.out_x = low + this.textHeight / 2;
                }
            } else {
                if (this.getUpper(axis) > high) {
                    this.out_x = high - this.textWidth / 2;
                }
                if (this.getLower(axis) < low) {
                    this.out_x = low + this.textWidth / 2;
                }
            }
        }
    }
}

