/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.gtk.APolygonElement;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.HashMap;

public class PolygonElement
extends APolygonElement {
    HashMap bboxMap = null;

    public PolygonElement() {
        this(false);
    }

    public PolygonElement(boolean drawOutsideLabel) {
        super((ATransform)new Transform());
        this.drawOutsideLabel = drawOutsideLabel;
    }

    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        super.init(initAction);
        this.vertexCount = initAction.getValueCount();
        if (this.vertexCount == -1) {
            this.vertexCount = 1;
        }
        this.setValueCount(1);
        initAction.popValueCount();
        initAction.setValueCount(1);
        this.bboxMap = null;
    }

    private HashMap getBBoxMap() {
        Object curID = null;
        int i = 0;
        Vec3d coord = new Vec3d(0.0, 0.0, 0.0);
        while (true) {
            try {
                coord.x = this.coordX.getValue(i);
                coord.y = this.coordY.getValue(i);
            }
            catch (MissingValueException mve) {
                if (++i < this.vertexCount) continue;
                return null;
            }
            break;
        }
        HashMap<MissingValues, BBoxInfo> map = new HashMap<MissingValues, BBoxInfo>();
        boolean numericID = !this.stringID.isConnected();
        try {
            curID = numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
        }
        catch (MissingValueException mve) {
            curID = mve.getMissingValue();
        }
        Vec3d first = new Vec3d(coord);
        Vec3d firstSeg = new Vec3d(coord);
        BBoxInfo bbi = new BBoxInfo();
        bbi.bbox = new BoundingBox();
        bbi.index = i;
        map.put((MissingValues)curID, bbi);
        bbi.bbox.union(coord);
        int firstSegi = i++;
        int firstID = firstSegi;
        while (i < this.vertexCount) {
            block17: {
                Object thisID;
                boolean thisSeg = false;
                try {
                    thisID = numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
                }
                catch (MissingValueException mve) {
                    thisID = mve.getMissingValue();
                }
                if (!thisID.equals(curID)) {
                    if (first != null && firstSeg != null) {
                        first = null;
                        firstSeg = null;
                    }
                    curID = thisID;
                    firstID = firstSegi = i;
                    if (bbi != null) {
                        bbi = null;
                    }
                }
                try {
                    coord.x = this.coordX.getValue(i);
                    coord.y = this.coordY.getValue(i);
                    if (first == null) {
                        first = new Vec3d(coord);
                    }
                    if (firstSeg == null) {
                        firstSeg = new Vec3d(coord);
                    }
                    if (bbi == null) {
                        bbi = new BBoxInfo();
                        bbi.bbox = new BoundingBox();
                        bbi.index = i;
                        map.put((MissingValues)curID, bbi);
                    }
                    bbi.bbox.union(coord);
                }
                catch (MissingValueException mve) {
                    if (i == firstSegi) break block17;
                    firstSegi = i + 1;
                    firstSeg = null;
                }
            }
            ++i;
        }
        if (firstID != i && bbi != null) {
            bbi = null;
        }
        return map;
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        boolean stippleNeeded;
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel ch = ba.getChannel();
        ch.setSubpixelRendering(this.isSubpixelRendering());
        ch.setDrawPolyOutline(true);
        if (this.bboxMap == null) {
            this.bboxMap = this.getBBoxMap();
        }
        if (this.bboxMap == null) {
            return;
        }
        if (this.drawOutsideLabel) {
            this.renderOusideLabel(ch);
            return;
        }
        ch.glDPIScaleFactor(this.getDPIScaleFactor());
        ch.glSkinType(this.getSkinType());
        ch.glSkinCategory(3);
        boolean drawFillPattern = this.fillPatternOn.getValue();
        ch.glPushAttrib(0);
        if (this.fillOn.getValue() && this.edgeOn.getValue()) {
            if (drawFillPattern) {
                ch.glPolygonMode(11);
            } else {
                ch.glPolygonMode(4);
            }
        } else if (this.fillOn.getValue()) {
            if (drawFillPattern) {
                ch.glPolygonMode(9);
            } else {
                ch.glPolygonMode(3);
            }
        } else if (this.edgeOn.getValue()) {
            if (drawFillPattern) {
                ch.glPolygonMode(10);
            } else {
                ch.glPolygonMode(2);
            }
        } else {
            ch.glPolygonMode(8);
        }
        boolean numericID = !this.stringID.isConnected();
        boolean labeled = this.label.isConnected();
        Object curID = null;
        int i = 0;
        Vec3d coord = new Vec3d(0.0, 0.0, 0.0);
        while (true) {
            try {
                coord.x = this.coordX.getValue(i);
                coord.y = this.coordY.getValue(i);
            }
            catch (MissingValueException mve) {
                if (++i < this.vertexCount) continue;
                return;
            }
            break;
        }
        try {
            curID = numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
        }
        catch (MissingValueException mve) {
            curID = mve.getMissingValue();
        }
        ch.glPushMatrix();
        double angle = this.rotate.getValue(i);
        BBoxInfo bbi = (BBoxInfo)this.bboxMap.get(curID);
        if (bbi != null) {
            ch.glRotate(bbi.bbox.getCenter().x, bbi.bbox.getCenter().y, 1.0, 0.0, 0.0, 1.0, angle);
        }
        if (this.vertexCount > 10) {
            ch.setVertexBufferReallocationSize(this.vertexCount);
        }
        ch.glBegin(2);
        ch.glColor(this.color.getValue(i));
        ch.glEdgeColor(this.edgeColor.getValue(i));
        int stipplePattern = SASLinePatterns.getStipplePattern((int)this.edgePattern.getValue(i));
        int stippleFactor = SASLinePatterns.getStippleFactor((int)this.edgePattern.getValue(i));
        boolean bl = stippleNeeded = stippleFactor > 0 && (stipplePattern & 0xFFFF) != 65535;
        if (stippleNeeded) {
            ch.glEnable(6);
            ch.glLineStipple((int)(0.5 + this.stippleScaleFactor * (double)stippleFactor), (int)((short)stipplePattern));
        }
        ch.glLineWidth((float)this.edgeWidth.getValue(i));
        if (drawFillPattern) {
            ch.glFillPatternColor(this.fillPatternColor.getValue(i));
            ch.glFillPatternType(this.fillPatternType.getValue(i));
            ch.glFillPatternWidth(this.fillPatternWidth.getValue(i));
            ch.glFillPatternScaleFactor(this.fillPatternScaleFactor.getValue(i));
        }
        ch.glEdgeFlag(true);
        ch.glVertex(coord.x, coord.y, coord.z);
        Vec3d first = new Vec3d(coord);
        Vec3d firstSeg = new Vec3d(coord);
        boolean resetFirstSeg = false;
        int firstSegi = i++;
        int firstID = firstSegi;
        while (i < this.vertexCount) {
            block43: {
                Object thisID;
                boolean thisSeg = false;
                try {
                    thisID = numericID ? new Double(this.id.getValue(i)) : this.stringID.getValue(i).trim();
                }
                catch (MissingValueException mve) {
                    thisID = mve.getMissingValue();
                }
                if (!thisID.equals(curID)) {
                    if (first != null && firstSeg != null) {
                        this.replaceObservation(ch, firstID);
                        ch.glEdgeFlag(false);
                        ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
                        ch.glVertex(first.x, first.y, first.z);
                        ch.glEdgeFlag(true);
                        first = null;
                        firstSeg = null;
                    }
                    ch.glEnd();
                    ch.glPopMatrix();
                    ch.glDisable(6);
                    if (labeled) {
                        this.drawLabel(ch, curID);
                    }
                    curID = thisID;
                    firstID = firstSegi = i;
                    ch.glPushMatrix();
                    angle = this.rotate.getValue(i);
                    bbi = (BBoxInfo)this.bboxMap.get(curID);
                    if (bbi != null) {
                        ch.glRotate(bbi.bbox.getCenter().x, bbi.bbox.getCenter().y, 1.0, 0.0, 0.0, 1.0, angle);
                    }
                    ch.glBegin(2);
                    ch.glColor(this.color.getValue(i));
                    ch.glEdgeColor(this.edgeColor.getValue(i));
                    stipplePattern = SASLinePatterns.getStipplePattern((int)this.edgePattern.getValue(i));
                    stippleFactor = SASLinePatterns.getStippleFactor((int)this.edgePattern.getValue(i));
                    boolean bl2 = stippleNeeded = stippleFactor > 0 && (stipplePattern & 0xFFFF) != 65535;
                    if (stippleNeeded) {
                        ch.glEnable(6);
                        ch.glLineStipple((int)(0.5 + this.stippleScaleFactor * (double)stippleFactor), (int)((short)stipplePattern));
                    }
                    ch.glLineWidth((float)this.edgeWidth.getValue(i));
                    if (drawFillPattern) {
                        ch.glFillPatternColor(this.fillPatternColor.getValue(i));
                        ch.glFillPatternType(this.fillPatternType.getValue(i));
                        ch.glFillPatternWidth(this.fillPatternWidth.getValue(i));
                        ch.glFillPatternScaleFactor(this.fillPatternScaleFactor.getValue(i));
                    }
                }
                try {
                    coord.x = this.coordX.getValue(i);
                    coord.y = this.coordY.getValue(i);
                    ch.glVertex(coord.x, coord.y, coord.z);
                    if (first == null) {
                        first = new Vec3d(coord);
                    }
                    if (firstSeg == null || resetFirstSeg) {
                        firstSeg = new Vec3d(coord);
                        resetFirstSeg = false;
                    }
                }
                catch (MissingValueException mve) {
                    if (i == firstSegi) break block43;
                    if (firstSeg != null && first != null) {
                        ch.glEdgeFlag(false);
                        ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
                        ch.glVertex(first.x, first.y, first.z);
                    }
                    ch.glEdgeFlag(true);
                    firstSegi = i + 1;
                    resetFirstSeg = true;
                }
            }
            ++i;
        }
        if (firstID != firstSegi && firstSeg != null) {
            ch.glEdgeFlag(false);
            ch.glVertex(firstSeg.x, firstSeg.y, firstSeg.z);
        }
        if (firstID != i) {
            this.replaceObservation(ch, firstID);
            ch.glEdgeFlag(false);
            if (first != null) {
                ch.glVertex(first.x, first.y, first.z);
                ch.glEnd();
                ch.glPopMatrix();
                if (labeled) {
                    this.drawLabel(ch, curID);
                }
            } else {
                ch.glEnd();
                ch.glPopMatrix();
            }
        }
        ch.glDisable(6);
        ch.setVertexBufferReallocationSize(10);
        ch.glPopAttrib();
        ch.glSkinType(0);
        ch.glSkinCategory(0);
        ch.setDrawPolyOutline(false);
    }

    public void renderOusideLabel(Channel ch) throws MissingValueException {
        double angle = this.labelRotation == 2 ? 90.0 : 0.0;
        for (Object key : this.bboxMap.keySet()) {
            this.drawLabel(ch, key);
        }
    }

    private Vec3d drawLabel(Channel ch, Object curID) throws MissingValueException {
        int vAlign;
        int hAlign;
        Vec3d labelCoord;
        BBoxInfo bbi = (BBoxInfo)this.bboxMap.get(curID);
        if (bbi == null) {
            return null;
        }
        boolean outline = ch.isOutlinedRasterLabel();
        double light = ch.getRasterLabelBacklight();
        int width = ch.getRasterLabelOutlineWidth();
        if (this.labelOutlineOn.getValue()) {
            ch.setOutlinedRasterLabel(true);
            ch.setRasterLabelBacklight(this.labelBacklight.getValue());
            ch.setRasterLabelOutlineWidth(this.labelOutlineWidth.getValue());
        }
        String curLabel = this.label.getValue(bbi.index);
        Color curLabelColor = this.labelColor.getValue(bbi.index);
        double curAngle = this.rotate.getValue(bbi.index);
        Vec3d size = bbi.bbox.getSize();
        Vec3d center = bbi.bbox.getCenter();
        switch (this.labelPosition) {
            default: {
                labelCoord = center;
                hAlign = 1;
                vAlign = 1;
                break;
            }
            case 2: {
                int off;
                labelCoord = new Vec3d(center.x - size.x / 2.0, center.y, center.z);
                if (this.labelLocation == 2) {
                    labelCoord.x = this.xMin - this.alignmentOffsetY;
                } else {
                    off = this.labelLocation == 1 ? -DEFAULT_INSIDELABEL_GAP : DEFAULT_INSIDELABEL_GAP;
                    labelCoord.x += (double)off;
                }
                hAlign = this.labelLocation == 0 ? 0 : 2;
                vAlign = 1;
                break;
            }
            case 3: {
                int off;
                labelCoord = new Vec3d(center.x + size.x / 2.0, center.y, center.z);
                if (this.labelLocation == 2) {
                    labelCoord.x = this.xMax + this.alignmentOffsetY2;
                } else {
                    off = this.labelLocation == 1 ? DEFAULT_INSIDELABEL_GAP : -DEFAULT_INSIDELABEL_GAP;
                    labelCoord.x += (double)off;
                }
                hAlign = this.labelLocation == 0 ? 2 : 0;
                vAlign = 1;
                break;
            }
            case 4: {
                int off;
                labelCoord = new Vec3d(center.x, center.y - size.y / 2.0, center.z);
                if (this.labelLocation == 2) {
                    labelCoord.y = this.yMin - this.alignmentOffsetX;
                } else {
                    off = this.labelLocation == 1 ? -DEFAULT_INSIDELABEL_GAP : DEFAULT_INSIDELABEL_GAP;
                    labelCoord.y += (double)off;
                }
                hAlign = 1;
                vAlign = this.labelLocation == 0 ? 3 : 0;
                break;
            }
            case 5: {
                int off;
                labelCoord = new Vec3d(center.x, center.y + size.y / 2.0, center.z);
                if (this.labelLocation == 2) {
                    labelCoord.y = this.yMax + this.alignmentOffsetX2;
                } else {
                    off = this.labelLocation == 1 ? DEFAULT_INSIDELABEL_GAP : -DEFAULT_INSIDELABEL_GAP;
                    labelCoord.y += (double)off;
                }
                hAlign = 1;
                int n = vAlign = this.labelLocation == 0 ? 0 : 3;
            }
        }
        if (this.labelRotation == 1) {
            curAngle = 0.0;
        } else if (this.labelRotation == 2 && !this.rotatedPolygon) {
            curAngle = 90.0;
        }
        double deltaX = 0.0;
        double deltaY = 0.0;
        if (this.labelSplit) {
            int[] align = new int[]{hAlign, vAlign};
            double[] delta = new double[2];
            curAngle = this.adjustAlignmentForSplit(curLabel, labelCoord, curAngle, align, delta);
            hAlign = align[0];
            vAlign = align[1];
            deltaX = delta[0];
            deltaY = delta[1];
        }
        RasterLabel.drawRasterLabel((Channel)ch, (String)curLabel, (Color)curLabelColor, (double)curAngle, (int)hAlign, (int)vAlign, (boolean)false, (boolean)false, (double)-1.0, (double)-1.0, (Font)this.getFont(), null, (boolean)false, null, (int)0, (int)0, (double)(labelCoord.x + deltaX), (double)(labelCoord.y + deltaY), (double)labelCoord.z, (boolean)this.rotatedPolygon);
        if (this.labelOutlineOn.getValue()) {
            ch.setOutlinedRasterLabel(outline);
            ch.setRasterLabelBacklight(light);
            ch.setRasterLabelOutlineWidth(width);
        }
        return labelCoord;
    }

    private double adjustAlignmentForSplit(String curLabel, Vec3d labelCoord, double curAngle, int[] align, double[] delta) {
        int hAlign = align[0];
        int vAlign = align[1];
        double deltaX = 0.0;
        double deltaY = 0.0;
        int mJus = this.multiLineJustify;
        if (mJus == Overlay.SPLIT_JUSTIFY_AUTO) {
            mJus = hAlign == 0 ? Overlay.SPLIT_JUSTIFY_LEFT : (hAlign == 2 ? Overlay.SPLIT_JUSTIFY_RIGHT : Overlay.SPLIT_JUSTIFY_CENTER);
        }
        if (this.labelLocation == 2 && this.labelRotation == 2) {
            FontMetrics fm = StatGraph.getFontMetrics(this.getFont());
            int width = Overlay.getTextWidth(fm, curLabel);
            int height = Overlay.getTextHeight(fm, curLabel, false);
            hAlign = 1;
            if (mJus == Overlay.SPLIT_JUSTIFY_CENTER) {
                vAlign = 1;
                if (this.labelPosition == 5) {
                    deltaY += (double)(width / 2);
                } else if (this.labelPosition == 4) {
                    deltaY -= (double)(width / 2);
                } else {
                    deltaX = this.labelPosition == 3 ? (deltaX += (double)(height / 2)) : (deltaX -= (double)(height / 2));
                }
            } else if (mJus == Overlay.SPLIT_JUSTIFY_LEFT) {
                vAlign = 3;
                if (this.labelPosition != 5) {
                    if (this.labelPosition == 4) {
                        deltaY -= (double)width;
                    } else if (this.labelPosition == 3) {
                        deltaY -= (double)(width / 2);
                        deltaX += (double)(height / 2);
                    } else {
                        deltaY -= (double)(width / 2);
                        deltaX -= (double)(height / 2);
                    }
                }
            } else {
                vAlign = 0;
                if (this.labelPosition == 5) {
                    deltaY += (double)width;
                } else if (this.labelPosition != 4) {
                    if (this.labelPosition == 3) {
                        deltaY += (double)(width / 2);
                        deltaX += (double)(height / 2);
                    } else {
                        deltaY += (double)(width / 2);
                        deltaX -= (double)(height / 2);
                    }
                }
            }
        } else if (this.labelRotation == 2 && !this.rotatedPolygon) {
            boolean insidePoly = this.labelLocation == 0;
            FontMetrics fm = StatGraph.getFontMetrics(this.getFont());
            int width = Overlay.getTextWidth(fm, curLabel);
            int height = Overlay.getTextHeight(fm, curLabel, false);
            hAlign = 1;
            if (mJus == Overlay.SPLIT_JUSTIFY_CENTER) {
                vAlign = 1;
                if (this.labelPosition == 5) {
                    deltaY = insidePoly ? (deltaY -= (double)(width / 2)) : (deltaY += (double)(width / 2));
                } else if (this.labelPosition == 4) {
                    deltaY = insidePoly ? (deltaY += (double)(width / 2)) : (deltaY -= (double)(width / 2));
                } else {
                    deltaX = this.labelPosition == 3 ? (insidePoly ? (deltaX -= (double)(height / 2)) : (deltaX += (double)(height / 2))) : (insidePoly ? (deltaX += (double)(height / 2)) : (deltaX -= (double)(height / 2)));
                }
            } else if (mJus == Overlay.SPLIT_JUSTIFY_LEFT) {
                vAlign = 3;
                if (this.labelPosition == 5) {
                    if (insidePoly) {
                        deltaY -= (double)width;
                    }
                } else if (this.labelPosition == 4) {
                    if (!insidePoly) {
                        deltaY -= (double)width;
                    }
                } else if (this.labelPosition == 3) {
                    deltaY -= (double)(width / 2);
                    deltaX = insidePoly ? (deltaX -= (double)(height / 2)) : (deltaX += (double)(height / 2));
                } else {
                    deltaY -= (double)(width / 2);
                    deltaX = insidePoly ? (deltaX += (double)(height / 2)) : (deltaX -= (double)(height / 2));
                }
            } else {
                vAlign = 0;
                if (this.labelPosition == 5) {
                    if (!insidePoly) {
                        deltaY += (double)width;
                    }
                } else if (this.labelPosition == 4) {
                    if (insidePoly) {
                        deltaY += (double)width;
                    }
                } else if (this.labelPosition == 3) {
                    deltaY += (double)(width / 2);
                    deltaX = insidePoly ? (deltaX -= (double)(height / 2)) : (deltaX += (double)(height / 2));
                } else {
                    deltaY += (double)(width / 2);
                    deltaX = insidePoly ? (deltaX += (double)(height / 2)) : (deltaX -= (double)(height / 2));
                }
            }
        } else {
            FontMetrics fm = StatGraph.getFontMetrics(this.getFont());
            double labelX = this.offsetSplitLabelX(curLabel, fm, labelCoord.x, hAlign, mJus);
            double offset = labelX - labelCoord.x;
            double rad = Math.toRadians(curAngle);
            deltaX = offset * Math.cos(rad);
            deltaY = offset * Math.sin(rad);
            hAlign = this.splitJustifyToGTKJustify(mJus);
        }
        align[0] = hAlign;
        align[1] = vAlign;
        delta[0] = deltaX;
        delta[1] = deltaY;
        return curAngle;
    }

    private int splitJustifyToGTKJustify(int splitJustify) {
        if (splitJustify == Overlay.SPLIT_JUSTIFY_LEFT) {
            return 0;
        }
        if (splitJustify == Overlay.SPLIT_JUSTIFY_RIGHT) {
            return 2;
        }
        if (splitJustify == Overlay.SPLIT_JUSTIFY_CENTER) {
            return 1;
        }
        return 1;
    }

    private double offsetSplitLabelX(String str, FontMetrics fm, double x, int just, int multiLineJustify) {
        int width = Overlay.getTextWidth(fm, str);
        double x2 = x;
        if (just == 2) {
            if (multiLineJustify == Overlay.SPLIT_JUSTIFY_LEFT) {
                x2 = x - (double)width;
            } else if (multiLineJustify == Overlay.SPLIT_JUSTIFY_CENTER) {
                x2 = x - (double)width * 0.5;
            }
        } else if (just == 0) {
            if (multiLineJustify == Overlay.SPLIT_JUSTIFY_RIGHT) {
                x2 = x + (double)width;
            } else if (multiLineJustify == Overlay.SPLIT_JUSTIFY_CENTER) {
                x2 = x + (double)width * 0.5;
            }
        } else if (just == 1) {
            if (multiLineJustify == Overlay.SPLIT_JUSTIFY_RIGHT) {
                x2 = x + (double)width * 0.5;
            } else if (multiLineJustify == Overlay.SPLIT_JUSTIFY_LEFT) {
                x2 = x - (double)width * 0.5;
            }
        }
        return x2;
    }

    static class BBoxInfo {
        public BoundingBox bbox;
        public int index;

        BBoxInfo() {
        }
    }
}

