/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.BooleanProperty;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class HighLowCap
extends Element {
    public static final int CAP_NONE = 0;
    public static final int CAP_SERIF = 1;
    public static final int CAP_BARBED_ARROW = 2;
    public static final int CAP_FILLED_ARROW = 3;
    public static final int CAP_OPEN_ARROW = 4;
    public static final int CAP_CLOSED_ARROW = 5;
    public static final int CAP_HIGH_SERIF = 100;
    public static final int CAP_LOW_SERIF = 101;
    public final NumericProperty beginX = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty beginY = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty beginZ = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty endX = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty endY = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty endZ = new NumericProperty((PropertyContainer)this, true);
    public final ColorProperty color = new ColorProperty((PropertyContainer)this, true);
    public final NumericProperty lineWidth = new NumericProperty((PropertyContainer)this, true);
    public final IntegerProperty capShape = new IntegerProperty((PropertyContainer)this, true);
    public final IntegerProperty linePattern = new IntegerProperty((PropertyContainer)this, true);
    public final BooleanProperty edgeOn = new BooleanProperty((PropertyContainer)this, true);
    public final ColorProperty edgeColor = new ColorProperty((PropertyContainer)this, true);
    private boolean adjustableArrowSize = false;

    public HighLowCap() {
        super((ATransform)new Transform());
        this.lineWidth.setValue(1.0);
        this.linePattern.setValue(-1);
        this.edgeOn.setValue(false);
    }

    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
        box.union(bBoxAction.pt1);
    }

    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        int index = ba.getValueIndex();
        int shape = this.capShape.getValue(index);
        if (shape == 0) {
            return;
        }
        Channel channel = ba.getChannel();
        Color c = this.color.getValue(index);
        float lw = (float)this.lineWidth.getValue(index);
        boolean edge = this.edgeOn.getValue(index) && this.edgeColor.isConnected();
        Color ec = this.edgeColor.getValue(index);
        channel.glColor(c);
        channel.glLineWidth(lw);
        int polygonMode = channel.getPolygonMode();
        if (shape == 1 || shape == 100 || shape == 101) {
            this.drawSerif(channel, index, lw, shape);
        } else if (shape == 5) {
            if (edge) {
                channel.glColor(ec);
            }
            this.drawClosedArrow(channel, index, lw);
        } else if (shape == 4) {
            this.drawOpenArrow(channel, index, lw);
        } else if (shape == 2) {
            this.drawBarbedArrow(channel, index, lw);
        } else if (shape == 3) {
            this.drawFilledArrow(channel, index, lw, ec, edge);
        }
        channel.glLineWidth(1.0f);
        channel.glPolygonMode(polygonMode);
    }

    private void drawSerif(Channel channel, int index, double lw, int shape) throws MissingValueException {
        double x1 = this.beginX.getValue(index);
        double y1 = this.beginY.getValue(index);
        double x2 = this.endX.getValue(index);
        double y2 = this.endY.getValue(index);
        channel.glBegin(1);
        if (shape == 1 || lw == 1.0) {
            channel.glVertex(x1, y1);
            channel.glVertex(x2, y2);
        } else {
            double sign = shape == 100 ? -1.0 : 1.0;
            double lw2 = Math.floor(lw * 0.5);
            if (y1 == y2) {
                y2 = y1 += lw2 * sign;
            } else {
                x2 = x1 += lw2 * sign;
            }
            channel.glVertex(x1, y1);
            channel.glVertex(x2, y2);
        }
        channel.glEnd();
    }

    private void drawFilledArrow(Channel channel, int index, double lw, Color ec, boolean edge) throws MissingValueException {
        double base;
        double wt2;
        double sign;
        double x1 = this.beginX.getValue(index);
        double y1 = this.beginY.getValue(index);
        double x2 = this.endX.getValue(index);
        double y2 = this.endY.getValue(index);
        channel.glPolygonMode(3);
        channel.glBegin(2);
        if (y1 == y2) {
            sign = x2 > x1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(x2 - x1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            wt2 = s * 0.5;
            if (!edge && lw > 1.0) {
                wt2 += lw * 0.5;
            }
            wt2 = (int)wt2;
            base = x2 - ht * sign;
            channel.glVertex(base, y1 - wt2 - 1.0);
            channel.glVertex(x2, y1);
            channel.glVertex(base, y1 + wt2);
        } else {
            sign = y2 > y1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(y2 - y1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            wt2 = s * 0.5;
            if (!edge && lw > 1.0) {
                wt2 += lw * 0.5;
            }
            wt2 = (int)wt2;
            base = y2 - ht * sign;
            channel.glVertex(x1 - wt2, base);
            channel.glVertex(x1, y2);
            channel.glVertex(x1 + wt2 + 1.0, base);
        }
        channel.glEnd();
        if (edge) {
            channel.glColor(ec);
            channel.glPolygonMode(2);
            channel.glBegin(2);
            if (y1 == y2) {
                channel.glVertex(base, y1 - wt2);
                channel.glVertex(x2 -= HighLowCap.getMiterLength(lw) * sign, y1);
                channel.glVertex(base, y1 + wt2);
            } else {
                channel.glVertex(x1 - wt2, base);
                channel.glVertex(x1, y2 -= HighLowCap.getMiterLength(lw) * sign);
                channel.glVertex(x1 + wt2, base);
            }
            channel.glEnd();
        }
    }

    private void drawClosedArrow(Channel channel, int index, double lw) throws MissingValueException {
        double x1 = this.beginX.getValue(index);
        double y1 = this.beginY.getValue(index);
        double x2 = this.endX.getValue(index);
        double y2 = this.endY.getValue(index);
        channel.glPolygonMode(2);
        channel.glBegin(2);
        if (y1 == y2) {
            double sign = x2 > x1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(x2 - x1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            wt2 = (int)wt2;
            double base = x2 - ht * sign;
            channel.glVertex(base, y1 - wt2);
            channel.glVertex(x2 -= HighLowCap.getMiterLength(lw) * sign, y1);
            channel.glVertex(base, y1 + wt2);
        } else {
            double sign = y2 > y1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(y2 - y1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            wt2 = (int)wt2;
            double base = y2 - ht * sign;
            channel.glVertex(x1 - wt2, base);
            channel.glVertex(x1, y2 -= HighLowCap.getMiterLength(lw) * sign);
            channel.glVertex(x1 + wt2, base);
        }
        channel.glEnd();
    }

    private void drawOpenArrow(Channel channel, int index, double lw) throws MissingValueException {
        double x1 = this.beginX.getValue(index);
        double y1 = this.beginY.getValue(index);
        double x2 = this.endX.getValue(index);
        double y2 = this.endY.getValue(index);
        if (y1 == y2) {
            double sign = x2 > x1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(x2 - x1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            wt2 = (int)wt2;
            double base = x2 - ht * sign;
            channel.glBegin(1);
            channel.glVertex(base, y1 - wt2);
            channel.glVertex(x2 -= HighLowCap.getMiterLength(lw) * sign, y1);
            channel.glVertex(base, y1 + wt2);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(x1, y1);
            channel.glVertex(x2, y1);
            channel.glEnd();
        } else {
            double sign = y2 > y1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(y2 - y1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            wt2 = (int)wt2;
            double base = y2 - ht * sign;
            channel.glBegin(1);
            channel.glVertex(x1 - wt2, base);
            channel.glVertex(x1, y2 -= HighLowCap.getMiterLength(lw) * sign);
            channel.glVertex(x1 + wt2, base);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(x1, y1);
            channel.glVertex(x1, y2);
            channel.glEnd();
        }
    }

    private void drawBarbedArrow(Channel channel, int index, double lw) throws MissingValueException {
        double x1 = this.beginX.getValue(index);
        double y1 = this.beginY.getValue(index);
        double x2 = this.endX.getValue(index);
        double y2 = this.endY.getValue(index);
        channel.glPolygonMode(3);
        if (y1 == y2) {
            double sign = x2 > x1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(x2 - x1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            if (lw > 1.0) {
                wt2 += lw * 0.5;
            }
            wt2 = (int)wt2;
            double base = x2 - ht * sign;
            double d = wt2 * 0.5 * sign;
            channel.glBegin(2);
            channel.glVertex(base + d, y1);
            channel.glVertex(base, y1 - wt2 - 1.0);
            channel.glVertex(x2, y1);
            channel.glVertex(base, y1 + wt2);
            channel.glVertex(base + d, y1);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(x1, y1);
            channel.glVertex(base + d, y1);
            channel.glEnd();
        } else {
            double sign = y2 > y1 ? 1.0 : -1.0;
            double s = this.getArrowSize(Math.abs(y2 - y1), lw);
            double ht = s + HighLowCap.getMiterLength(lw);
            double wt2 = s * 0.5;
            if (lw > 1.0) {
                wt2 += lw * 0.5;
            }
            wt2 = (int)wt2;
            double base = y2 - ht * sign;
            double d = wt2 * 0.5 * sign;
            channel.glBegin(2);
            channel.glVertex(x1, base + d);
            channel.glVertex(x1 - wt2, base);
            channel.glVertex(x1, y2);
            channel.glVertex(x1 + wt2 + 1.0, base);
            channel.glVertex(x1, base + d);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(x1, y1);
            channel.glVertex(x1, base + d);
            channel.glEnd();
        }
    }

    private double getArrowSize(double capSize, double lineWidth) {
        if (this.adjustableArrowSize) {
            return HighLowCap.getAdjustedArrowSize(capSize, lineWidth);
        }
        return capSize;
    }

    public void setAdjustableArrowSize(boolean adjustable) {
        this.adjustableArrowSize = adjustable;
    }

    public boolean isAdjustableArrowSize() {
        return this.adjustableArrowSize;
    }

    public static double getAdjustedArrowSize(double capSize, double lineWidth) {
        if (lineWidth <= 3.0) {
            return capSize;
        }
        return capSize * Math.sqrt(lineWidth) * 0.5;
    }

    public static double getMiterLength(double lineWidth) {
        double miterLength = 0.0;
        if (lineWidth > 1.0) {
            miterLength = 0.5 * lineWidth * Math.sqrt(5.0);
        }
        return miterLength;
    }
}

