/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.gtk;

import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import java.util.Random;

public class JitteredContinuousRangeToNumericMapper
extends ContinuousRangeToNumericMapper {
    private double jitterDefault = 0.0;
    private double jitterDistance = 0.0;
    public NumericProperty jitter = new NumericProperty((PropertyContainer)this, true);
    public NumericProperty position = new NumericProperty((PropertyContainer)this, true);
    private Random random = null;
    private int seed = 1234567;

    public JitteredContinuousRangeToNumericMapper(double jitter) {
        this.jitterDefault = jitter;
        this.random = new Random();
    }

    public void init(AInitAction ia) {
        super.init(ia);
        this.random.setSeed(this.seed);
    }

    public double getJitter() {
        return this.jitterDefault;
    }

    public void setJitter(double d) {
        this.jitterDefault = d;
    }

    public double getJitterDistance() {
        return this.jitterDistance;
    }

    public void setJitterDistance(double distance) {
        this.jitterDistance = distance;
    }

    public double getValue(int index) throws MissingValueException {
        double value = this.position.isConnected() ? this.position.getValue(index) : super.getValue(index);
        if (this.jitter.isConnected()) {
            double j_factor = this.jitter.getValue(index);
            return value + j_factor * this.jitterDistance;
        }
        double min = super.getOutputMin();
        double max = super.getOutputMax();
        return value + this.jitterDefault * (this.random.nextDouble() - 0.5) * (max - min);
    }

    public double getValue(double input) {
        double value = super.getValue(input);
        double min = super.getOutputMin();
        double max = super.getOutputMax();
        return value + this.jitterDefault * (this.random.nextDouble() - 0.5) * (max - min);
    }

    public double getValue(int index, double jitter) throws MissingValueException {
        double value = this.position.isConnected() ? this.position.getValue(index) : super.getValue(index);
        return value + jitter * this.jitterDistance;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }
}

