/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid.gtk;

import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportEvent;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.BaseGridAxis;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.util.gtk.StringToNumericMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenuItem;

public class GridAxis
extends BaseGridAxis
implements GridAxisInterface,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener,
ViewportListener {
    private static final int PAN = 0;
    private static final int ZOOM = 1;
    private static final int ZOOM_MIN = 2;
    private static final int ZOOM_MAX = 3;
    private boolean viewportEnabled = false;
    private int currentZoomPanStatus = OverlayContainer.zoomPanStatus;
    private double dataMin = Double.NaN;
    private double dataMax = Double.NaN;
    private Vector discreteValue;
    private double viewportMin;
    private double viewportMax;
    private double startOffset;
    private double strideOffset;
    private double strideValue;
    private int prevx;
    private int prevy;
    private ArrayList viewportListener;
    private boolean onAxis = false;
    private boolean dragged = false;
    private boolean exited = false;
    private Color indicatorColor;
    private double zoomPoint;
    private boolean layoutNeeded = false;
    private boolean viewportInitialized = false;

    public GridAxis() {
        this(1);
    }

    public GridAxis(byte dim) {
        super(dim);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        super.paintComponent(g);
        if (this.viewportEnabled && (Double.isNaN(this.dataMin) || Double.isNaN(this.dataMax))) {
            this.initViewport();
        }
        if (this.viewportEnabled) {
            this.drawViewportIndicator(g);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevx = e.getX();
        this.prevy = e.getY();
        if (e.isPopupTrigger()) {
            this.bringUpPopupMenu(e);
        } else {
            this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
            this.setZoomPanCursor(this.currentZoomPanStatus, true);
            if (this.currentZoomPanStatus == 1) {
                this.zoomPoint = this.getDimension() == 1 ? (double)this.prevx / (double)this.getSize().width : 1.0 - (double)this.prevy / (double)this.getSize().height;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.bringUpPopupMenu(e);
        } else if (this.exited) {
            this.onAxis = false;
            this.repaint();
        }
        if (this.dragged) {
            this.dragged = false;
            this.postZoomPanProcess();
        }
        this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
        this.setZoomPanCursor(this.currentZoomPanStatus, false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.onAxis = true;
        this.repaint();
        this.exited = false;
        this.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.dragged) {
            this.onAxis = false;
            this.repaint();
        }
        this.exited = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.preZoomPanProcess();
        this.zoomPanAxis(this.currentZoomPanStatus, e.getPoint());
        this.dragged = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
        this.setZoomPanCursor(this.currentZoomPanStatus, false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.dragged) {
            return;
        }
        if (OverlayContainer.keyCode == e.getKeyCode()) {
            return;
        }
        OverlayContainer.keyCode = e.getKeyCode();
        if (OverlayContainer.keyCode == 16) {
            this.setZoomPanCursor(0, false);
        } else if (OverlayContainer.keyCode == 17) {
            this.setZoomPanCursor(1, false);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (OverlayContainer.keyCode != -1 && !this.dragged) {
            this.setZoomPanCursor(OverlayContainer.zoomPanStatus, false);
        }
        OverlayContainer.keyCode = -1;
    }

    protected void bringUpPopupMenu(MouseEvent e) {
        if (OverlayContainer.axisPopup == null) {
            OverlayContainer.axisPopup = OverlayContainer.createAxisPopupMenu();
        }
        if (OverlayContainer.axisListener != this) {
            OverlayContainer.removeListenerFromPopup(OverlayContainer.axisPopup, OverlayContainer.axisListener);
            OverlayContainer.addListenerToPopup(OverlayContainer.axisPopup, this);
            OverlayContainer.axisListener = this;
            if (OverlayContainer.axisPopup.getParent() != null && OverlayContainer.axisPopup.getParent() != this) {
                OverlayContainer.axisPopup.getParent().remove(OverlayContainer.axisPopup);
                this.add(OverlayContainer.axisPopup);
            }
        }
        OverlayContainer.axisPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    public boolean isViewportEnabled() {
        return this.viewportEnabled;
    }

    public void setViewportEnabled(boolean enable) {
        this.viewportEnabled = enable;
        if (this.viewportEnabled) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeKeyListener(this);
        }
    }

    public void addViewportListener(ViewportListener listener) {
        if (listener == null) {
            return;
        }
        if (this.viewportListener == null) {
            this.viewportListener = new ArrayList();
        }
        if (!this.viewportListener.contains(listener)) {
            this.viewportListener.add(listener);
        }
    }

    public void removeViewportListener(ViewportListener listener) {
        if (this.viewportListener == null || listener == null) {
            return;
        }
        if (this.viewportListener.contains(listener)) {
            this.viewportListener.remove(listener);
        }
    }

    private void initViewport() {
        DataRange dr = this.getOutputRange();
        if (dr instanceof ContinuousRange) {
            this.viewportMin = ((ContinuousRange)dr).getMin();
            this.viewportMax = ((ContinuousRange)dr).getMax();
        } else if (dr instanceof SimpleBinnedRange) {
            this.viewportMin = ((SimpleBinnedRange)dr).getFirstMidpoint();
            this.viewportMax = ((SimpleBinnedRange)dr).getLastMidpoint();
            if (((SimpleBinnedRange)dr).isEndLabels()) {
                this.viewportMin -= 0.5 * ((SimpleBinnedRange)dr).getBinSize();
                this.viewportMax += 0.5 * ((SimpleBinnedRange)dr).getBinSize();
            }
        } else if (dr instanceof CustomBinnedRange) {
            this.viewportMin = ((CustomBinnedRange)dr).getMin();
            this.viewportMax = ((CustomBinnedRange)dr).getMax();
        } else if (dr instanceof DiscreteRange) {
            this.viewportMin = 0.0;
            this.viewportMax = ((DiscreteRange)dr).getValuesSize() - 1;
            this.discreteValue = ((DiscreteRange)dr).getValues();
            PositionEncoder pe = (PositionEncoder)this.ra.getEncoder(this.ra.getDimension());
            this.strideValue = ((StringToNumericMap)pe.getValueMap()).getStrideValue();
            this.strideOffset = 0.0;
            this.startOffset = 0.0;
        }
        this.dataMin = this.viewportMin;
        this.dataMax = this.viewportMax;
        OverlayContainer.loadCustomCursors();
        this.indicatorColor = OverlayContainer.computeShadedColor(this.getBackground());
        if (this.ra.getType() == 1 || !this.ra.isVisible()) {
            this.viewportEnabled = false;
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.removeKeyListener(this);
        }
        this.viewportInitialized = true;
    }

    private void getZoomPanInfo(int x, int y, boolean mouseDown) {
        if (!this.viewportEnabled) {
            return;
        }
        this.currentZoomPanStatus = OverlayContainer.zoomPanStatus;
        Dimension size = this.getSize();
        if (this.getDimension() == 1) {
            Cursor cursor = this.currentZoomPanStatus == 0 ? (mouseDown ? OverlayContainer.panClosedLRCursor : OverlayContainer.panOpenLRCursor) : OverlayContainer.zoomLRCursor;
            this.setCursor(cursor);
        } else if (this.getDimension() == 2) {
            Cursor cursor = this.currentZoomPanStatus == 0 ? (mouseDown ? OverlayContainer.panClosedUDCursor : OverlayContainer.panOpenUDCursor) : OverlayContainer.zoomUDCursor;
            this.setCursor(cursor);
        }
    }

    private void setZoomPanCursor(int zoomPanStatus, boolean mouseDown) {
        if (!this.viewportEnabled) {
            return;
        }
        if (this.getDimension() == 1) {
            Cursor cursor = zoomPanStatus == 0 ? (mouseDown ? OverlayContainer.panClosedLRCursor : OverlayContainer.panOpenLRCursor) : OverlayContainer.zoomLRCursor;
            this.setCursor(cursor);
        } else if (this.getDimension() == 2) {
            Cursor cursor = zoomPanStatus == 0 ? (mouseDown ? OverlayContainer.panClosedUDCursor : OverlayContainer.panOpenUDCursor) : OverlayContainer.zoomUDCursor;
            this.setCursor(cursor);
        }
    }

    private void zoomPanAxis(int zoomPanStatus, Point pt) {
        if (!this.viewportEnabled) {
            return;
        }
        this.ra.setDynamic(true);
        double ratio = 0.0;
        double dpix = 0.0;
        double dval = 0.0;
        Dimension size = this.getSize();
        if (this.getDimension() == 1) {
            ratio = (this.viewportMax - this.viewportMin) / (double)size.width;
            dpix = this.prevx - pt.x;
            dval = dpix * ratio;
        } else if (this.getDimension() == 2) {
            ratio = (this.viewportMax - this.viewportMin) / (double)size.height;
            dpix = pt.y - this.prevy;
            dval = dpix * ratio;
        }
        if (this.getOutputRange() instanceof DiscreteRange) {
            double accumulatedChange = this.ra.isReverse() ? -dpix : dpix;
            PositionEncoder pe = (PositionEncoder)this.ra.getEncoder(this.ra.getDimension());
            int n = this.discreteValue.size();
            if (zoomPanStatus == 0) {
                this.startOffset = pe.getStartOffset() + accumulatedChange;
                this.startOffset = Math.min(this.startOffset, this.strideOffset * 0.5);
                this.startOffset = Math.max(this.startOffset, this.strideOffset * 0.5 - (double)n * this.strideOffset);
            } else if (this.currentZoomPanStatus == 1) {
                double startOffsetChange = -accumulatedChange * (double)n * this.zoomPoint;
                if (pe.getStrideOffset() - accumulatedChange >= 0.0) {
                    this.strideOffset = pe.getStrideOffset() - accumulatedChange;
                    this.startOffset = pe.getStartOffset() - startOffsetChange;
                }
            }
        }
        switch (zoomPanStatus) {
            case 2: {
                this.viewportMin -= dval;
                this.viewportMin = Math.min(this.viewportMin, this.viewportMax);
                break;
            }
            case 3: {
                this.viewportMax -= dval;
                this.viewportMax = Math.max(this.viewportMax, this.viewportMin);
                break;
            }
            case 1: {
                if (this.zoomPoint < 0.05) {
                    this.viewportMin -= dval * (1.0 - this.zoomPoint);
                    this.viewportMin = Math.min(this.viewportMin, this.viewportMax);
                } else if (this.zoomPoint > 0.95) {
                    this.viewportMax -= dval * this.zoomPoint;
                    this.viewportMax = Math.max(this.viewportMax, this.viewportMin);
                } else {
                    double vrange = this.viewportMax - this.viewportMin;
                    double focusPoint = this.viewportMin + this.zoomPoint * vrange;
                    this.viewportMin = focusPoint - this.zoomPoint * (vrange += dval);
                    this.viewportMax = focusPoint + (1.0 - this.zoomPoint) * vrange;
                    this.viewportMax = Math.max(this.viewportMax, this.viewportMin);
                }
                this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                break;
            }
            case 0: {
                double range = this.viewportMax - this.viewportMin;
                if (dval < 0.0) {
                    this.viewportMin += dval;
                    this.viewportMin = Math.max(this.viewportMin, this.dataMin);
                    this.viewportMax = this.viewportMin + range;
                    break;
                }
                this.viewportMax += dval;
                this.viewportMax = Math.min(this.viewportMax, this.dataMax);
                this.viewportMin = this.viewportMax - range;
                break;
            }
        }
        this.setViewport();
        this.fireViewportEvent();
        this.prevx = pt.x;
        this.prevy = pt.y;
    }

    private void setViewport() {
        if (!this.viewportInitialized) {
            return;
        }
        DataRange outputRange = this.getOutputRange();
        if (outputRange instanceof StubRange) {
            return;
        }
        if (outputRange instanceof ContinuousRange) {
            ContinuousRange dr = new ContinuousRange(outputRange);
            dr.setMin(this.viewportMin);
            dr.setMax(this.viewportMax);
            this.ra.setUseRange(null, false);
            this.ra.setInputDataRange((DataRange)dr);
        } else if (outputRange instanceof BinnedRange) {
            Object dr = outputRange instanceof SimpleBinnedRange ? new SimpleBinnedRange(outputRange) : new CustomBinnedRange(outputRange);
            ((ContinuousRange)dr.getDual()).setMin(this.viewportMin);
            ((ContinuousRange)dr.getDual()).setMax(this.viewportMax);
            double[] ticks = VRectAxis.getBinTickList((BinnedRange)dr);
            this.ra.setTicks(ticks);
            this.ra.setUseRange(null, false);
            this.ra.setInputDataRange((DataRange)dr);
        } else if (outputRange instanceof DiscreteRange) {
            PositionEncoder pe = (PositionEncoder)this.ra.getEncoder(this.ra.getDimension());
            pe.setStartOffset(this.startOffset);
            pe.setStrideOffset(this.strideOffset);
            this.ra.setEncoder(this.ra.getDimension(), pe);
        }
        this.repaint();
    }

    private void resetViewport() {
        this.viewportMin = this.dataMin;
        this.viewportMax = this.dataMax;
        this.startOffset = 0.0;
        this.strideOffset = 0.0;
        this.setViewport();
        this.fireViewportEvent();
        this.postZoomPanProcess();
    }

    private void fireViewportEvent() {
        double[] min = new double[4];
        double[] max = new double[4];
        double[] start = new double[4];
        double[] stride = new double[4];
        for (int i = 0; i < 4; ++i) {
            min[i] = Double.NaN;
            max[i] = Double.NaN;
            start[i] = 0.0;
            stride[i] = 0.0;
        }
        if (this.getDimension() == 1) {
            min[0] = this.viewportMin;
            max[0] = this.viewportMax;
            min[1] = this.viewportMin;
            max[1] = this.viewportMax;
            start[0] = this.startOffset;
            stride[0] = this.strideOffset;
            start[1] = this.startOffset;
            stride[1] = this.strideOffset;
        } else if (this.getDimension() == 2) {
            min[2] = this.viewportMin;
            max[2] = this.viewportMax;
            min[3] = this.viewportMin;
            max[3] = this.viewportMax;
            start[2] = this.startOffset;
            stride[2] = this.strideOffset;
            start[3] = this.startOffset;
            stride[3] = this.strideOffset;
        }
        ViewportEvent evt = new ViewportEvent((Object)this, min, max, start, stride);
        for (int i = 0; i < this.viewportListener.size(); ++i) {
            ((ViewportListener)this.viewportListener.get(i)).viewportChanged(evt);
        }
    }

    private void drawViewportIndicator(Graphics g) {
        if (!this.viewportEnabled || !this.onAxis) {
            return;
        }
        g.setColor(this.indicatorColor);
        Dimension size = this.getSize();
        if (this.getDimension() == 1) {
            int y1;
            int lowerOffset = this.ignoreOffset ? this.innerMargin.left : 0;
            int upperOffset = this.ignoreOffset ? this.innerMargin.right : 0;
            Rectangle area = new Rectangle(this.outerMargin.left + lowerOffset, 0, size.width - this.outerMargin.left - this.outerMargin.right - lowerOffset - upperOffset, 15);
            if (this.isPrimary()) {
                int y2 = 0;
                y1 = 0;
            } else {
                int y2;
                y1 = y2 = size.height - area.height;
            }
            g.fillRect(area.x, y1, area.width - 1, area.height);
        } else if (this.getDimension() == 2) {
            int x1;
            int lowerOffset = this.ignoreOffset ? this.innerMargin.bottom : 0;
            int upperOffset = this.ignoreOffset ? this.innerMargin.top : 0;
            Rectangle area = new Rectangle(0, this.outerMargin.top + upperOffset, 15, size.height - this.outerMargin.top - this.outerMargin.bottom - lowerOffset - upperOffset);
            if (this.isPrimary()) {
                int x2;
                x1 = x2 = size.width - area.width;
            } else {
                int x2 = 0;
                x1 = 0;
            }
            g.fillRect(x1, area.y, area.width, area.height - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("Pan")) {
            OverlayContainer.zoomPanStatus = 0;
            OverlayContainer.setSelectedItemInPopUp(OverlayContainer.axisPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("Zoom")) {
            OverlayContainer.zoomPanStatus = 1;
            OverlayContainer.setSelectedItemInPopUp(OverlayContainer.axisPopup, (JMenuItem)evt.getSource());
        } else if (evt.getActionCommand().equalsIgnoreCase("Reset")) {
            this.resetViewport();
        }
        this.currentZoomPanStatus = OverlayContainer.getCurrentZoomPanStatus();
        this.setZoomPanCursor(this.currentZoomPanStatus, false);
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (evt.source == this) {
            return;
        }
        this.ra.setDynamic(true);
        int ID = -1;
        int sID = -1;
        int eID = -1;
        if (this.getDimension() == 1) {
            sID = 0;
            eID = 1;
        } else if (this.getDimension() == 2) {
            sID = 2;
            eID = 3;
        }
        for (ID = sID; ID <= eID; ++ID) {
            if (ID < 0 || Double.isNaN(evt.min[ID]) || Double.isNaN(evt.max[ID]) || this.viewportMin == evt.min[ID] && this.viewportMin == evt.min[ID] && this.startOffset == evt.startOffset[ID] && this.strideOffset == evt.strideOffset[ID]) continue;
            this.viewportMin = evt.min[ID];
            this.viewportMax = evt.max[ID];
            this.startOffset = evt.startOffset[ID];
            this.strideOffset = evt.strideOffset[ID];
        }
        this.setViewport();
    }

    public void preZoomPanProcess() {
        for (int i = 0; i < this.viewportListener.size(); ++i) {
            if (!(this.viewportListener.get(i) instanceof OverlayContainer)) continue;
            ((OverlayContainer)this.viewportListener.get(i)).preZoomPanProcess(false);
        }
    }

    public void postZoomPanProcess() {
        for (int i = 0; i < this.viewportListener.size(); ++i) {
            if (!(this.viewportListener.get(i) instanceof OverlayContainer)) continue;
            ((OverlayContainer)this.viewportListener.get(i)).postZoomPanProcess(false);
        }
        if (this.layoutNeeded) {
            this.mlList.marginChanged(new MarginChangeEvent((Object)this));
            this.invalidate();
        }
    }

    public void setLayoutNeeded(boolean needed) {
        this.layoutNeeded = needed;
    }
}

