/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.graphtable.GTablePanel;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.TableConstants;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class Table
extends AbstractSGComponent {
    private GTablePanel _gTablePanel = null;
    private GTable _gTable = null;
    private GTableModel _gTableModel = null;

    public Table() {
        super(new BorderLayout(), true);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHeaderFont(Font font) {
        if (this._gTable != null) {
            this._gTable.getTableHeader().setFont(font);
        }
    }

    public void setColors(Color headerBackColor, Color headerForeColor, Color cellBackColor, Color cellForeColor, Color gridColor) {
        if (this._gTablePanel != null) {
            this._gTablePanel.setItemColor(1, cellForeColor);
            this._gTablePanel.setItemColor(0, cellBackColor);
            this._gTablePanel.setItemColor(3, headerForeColor);
            this._gTablePanel.setItemColor(2, headerBackColor);
        }
        if (this._gTable != null) {
            this._gTable.setGridColor(gridColor);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this._gTable != null) {
            this._gTable.setFont(font);
        }
    }

    public void setModel(DataModel dataModel, int[] columns) {
        DefaultTableModel tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        Object[] values = null;
        String[] formats = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int index = columns[i];
            ColumnMetadata cmd = (ColumnMetadata)dataModel.getColumnLabel(index);
            if (dataModel.getColumnClass(index) == Double.class) {
                double[] doubleValues = dataModel.getDoubleColumn(index);
                values = new Double[doubleValues.length];
                for (int j = 0; j < doubleValues.length; ++j) {
                    values[j] = new Double(doubleValues[j]);
                }
            } else {
                values = dataModel.getStringAsClassColumn(index);
            }
            tableModel.addColumn((Object)cmd.getLabel(), values);
            formats[i] = "NONE";
            SASFormat fmt = cmd.getFormat();
            if (fmt == null) continue;
            formats[i] = fmt.getBaseFormatName() + fmt.getWidth() + ".";
            if (fmt.getDecimalWidth() <= 0) continue;
            int n = i;
            formats[n] = formats[n] + fmt.getDecimalWidth();
        }
        this._gTableModel = new GTableModel((TableModel)tableModel, false, false);
        this._gTableModel.setColumnFormats(formats);
        this._gTablePanel = new GTablePanel(this._gTableModel, false, false, 0, 0);
        this._gTable = this._gTablePanel.getTable();
        this.add((Component)this._gTablePanel);
    }

    public void calculateSize() {
        int width = 0;
        for (int i = 0; i < this._gTable.getColumnModel().getColumnCount(); ++i) {
            width += this._gTable.getColumnModel().getColumn(i).getPreferredWidth();
        }
        int height = this._gTable.getRowCount() * this._gTable.getRowHeight();
        this._gTable.setPreferredScrollableViewportSize(new Dimension(width, height));
        if (this.getUserWidth() > 0 || this.getUserHeight() > 0) {
            Dimension size = this._gTablePanel.getPreferredSize();
            if (this.getUserWidth() > 0) {
                size.width = this.getUserWidth();
            }
            if (this.getUserHeight() > 0) {
                size.height = this.getUserHeight();
            }
            this._gTablePanel.setPreferredSize(size);
        }
    }

    public void setColumnGrid(boolean b) {
        if (this._gTable != null) {
            this._gTable.setShowVerticalLines(b);
        }
    }

    public void setRowGrid(boolean b) {
        if (this._gTable != null) {
            this._gTable.setShowHorizontalLines(b);
        }
    }

    public void setHeader(boolean b) {
        if (this._gTable != null && !b) {
            this._gTable.setTableHeader(null);
        }
    }

    public String[] getFormats() {
        String[] formats = new String[]{};
        if (this._gTableModel != null) {
            formats = new String[this._gTableModel.getColumnCount()];
            for (int i = 0; i < formats.length; ++i) {
                formats[i] = this._gTableModel.getColumnFormat(i);
            }
        }
        return formats;
    }

    public void setFormats(String[] formats) {
        if (this._gTableModel != null && formats != null) {
            this._gTableModel.setColumnFormats(formats);
        }
    }

    public void setDisplay(int i, String display) {
        if (this._gTable != null) {
            int mode = TableConstants.RENDERMODE_TEXT;
            if (display.equalsIgnoreCase("Graphics")) {
                mode = TableConstants.RENDERMODE_GRAPHICS;
            } else if (display.equalsIgnoreCase("Funnel")) {
                mode = TableConstants.RENDERMODE_FUNNEL;
            }
            this._gTable.setRenderMode(i, mode);
        }
    }

    public void setLabel(int i, String label) {
        if (this._gTable != null) {
            this._gTable.getColumnModel().getColumn(i).setHeaderValue(label);
        }
    }

    public void sortColumn(int column, boolean ascending) {
        if (this._gTable != null) {
            this._gTable.sortColumn(column, ascending);
        }
    }

    public void setHeaderWrapping(boolean b) {
        if (this._gTable != null) {
            for (int i = 0; i < this._gTableModel.getColumnCount(); ++i) {
                String name = this._gTableModel.getColumnName(i);
                this._gTableModel.setColumnWrap(name, b);
            }
        }
    }

    public void setDataWrapping(boolean b) {
        this.setHeaderWrapping(b);
    }
}

