/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.EntryStub;
import com.sas.graphics.applets.statgraph.sgchart.entry.GlobalLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.LegendTextItemList;
import com.sas.graphics.applets.statgraph.sgchart.entry.RB;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.OContour;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SurfaceOverlay;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultStyledDocument;

public class Legend
extends GridPanel {
    public static final String RB_KEY = "Legend.";
    private boolean _dataAntiAliased = false;
    private boolean _textAntiAliased = false;
    private String[] _graphNames = null;
    private Color _valueColor = null;
    private boolean _titleBorder = false;
    private TextStyle titleStyle = new TextStyle();
    private String _title = null;
    private boolean _isOverlay = false;
    private boolean mergedLegend = false;
    private boolean autoLegend = false;
    private int _across = 0;
    private int _down = 0;
    private static final int _PAD = 4;
    private static final int _NPAD = 4;
    private boolean titleOnLeft = false;
    private float titleAlignment = 0.5f;
    public boolean repositionTitle = true;
    private boolean clippingAllowed = false;
    private int type = 0;
    private ColorAttr defaultAttrs;
    private LineAttrs defaultOutlineAttrs;
    public static final int SORT_DATA = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static final int SORT_REVERSEDATA = 3;
    private int sortOrder = 0;
    private String[] excludedValues = null;
    public static double DEFAULT_CHICKLET_FONT_MULTIPLIER = 1.5;
    private boolean scaleSymbolWithFont = false;
    private double customHeightScale = Double.NaN;
    private double customChickletHeight = Double.NaN;
    private double customChickletAspect = Double.NaN;
    private boolean outlineFilledChicklet = true;
    private int itemLineLength = Entry.LEGEND_LINE_LENGTH;
    private boolean subpixelRendering = false;
    private boolean sortBySymbolText = false;
    public static double GOLDEN_RATIO = 1.618;
    protected boolean globalLegend = false;
    protected boolean globalLegendRowMajor = true;
    protected boolean qcGlobalLegend = false;
    protected boolean titlePulled = false;
    protected int wrapWidth = -1;
    protected int wrapHeight = -1;

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public void setSortOrder(int sort) {
        this.sortOrder = sort;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setExcludedValues(String[] values) {
        this.excludedValues = values;
    }

    public String[] getExcludedValues() {
        return this.excludedValues;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public void setDefaultAttrs(ColorAttr attrs) {
        this.defaultAttrs = attrs;
    }

    public void setDefaultOutlineAttrs(LineAttrs attrs) {
        this.defaultOutlineAttrs = attrs;
    }

    public boolean isClippingAllowed() {
        return this.clippingAllowed;
    }

    public void setClippingAllowed(boolean b) {
        this.clippingAllowed = b;
    }

    protected int getPad() {
        if (this.type == 16) {
            return 4 * (int)Math.ceil(4.0 * StatGraph.getGapScaleFactor());
        }
        return (int)Math.ceil(4.0 * StatGraph.getGapScaleFactor());
    }

    protected int getNPad() {
        return 4;
    }

    public boolean isTextAntiAliased() {
        return this._textAntiAliased;
    }

    public void setTextAntiAliased(boolean textAntiAliased) {
        this._textAntiAliased = textAntiAliased;
    }

    public boolean isDataAntiAliased() {
        return this._dataAntiAliased;
    }

    public void setDataAntiAliased(boolean dataAntiAliased) {
        this._dataAntiAliased = dataAntiAliased;
    }

    public String[] getGraphNames() {
        return this._graphNames;
    }

    public void setGraphNames(String[] graphNames) {
        this._graphNames = graphNames;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public Color getTitleColor() {
        return this.titleStyle.getColor();
    }

    public void setTitleColor(Color titleColor) {
        this.titleStyle.setColor(titleColor);
    }

    public Color getValueColor() {
        return this._valueColor;
    }

    public void setValueColor(Color valueColor) {
        this._valueColor = valueColor;
    }

    public boolean isTitleBorder() {
        return this._titleBorder;
    }

    public void setTitleBorder(boolean titleBorder) {
        this._titleBorder = titleBorder;
    }

    public Font getTitleFont() {
        return this.titleStyle.getFont();
    }

    public void setTitleFont(Font titleFont) {
        this.titleStyle.setFont(titleFont);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public float getTitleAligment() {
        return this.titleAlignment;
    }

    public void setTitleAligment(float alignment) {
        this.titleAlignment = alignment;
    }

    public boolean isOverlay() {
        return this._isOverlay;
    }

    public void setOverlay(boolean isOverlay) {
        this._isOverlay = isOverlay;
    }

    public boolean isMergedLegend() {
        return this.mergedLegend;
    }

    public void setMergedLegend(boolean mergedLegend) {
        this.mergedLegend = mergedLegend;
    }

    public boolean isAutoLegend() {
        return this.autoLegend;
    }

    public void setAutoLegend(boolean autoLegend) {
        this.autoLegend = autoLegend;
    }

    public int getAcross() {
        return this._across;
    }

    public void setAcross(int across) {
        if (across >= 0) {
            this._across = across;
        }
    }

    public int getDown() {
        return this._down;
    }

    public void setDown(int down) {
        if (down >= 0) {
            this._down = down;
        }
    }

    public void resolveReferences(Overlay[] graphs) {
        HashMap<Legend, String[]> graphNamesRefs = new HashMap<Legend, String[]>();
        String[] graphIDs = new String[graphs.length];
        for (int i = 0; i < graphs.length; ++i) {
            graphIDs[i] = "" + i;
        }
        graphNamesRefs.put(this, graphIDs);
        HashMap<String, Overlay> graphNamesTable = new HashMap<String, Overlay>();
        for (int i = 0; i < graphs.length; ++i) {
            graphNamesTable.put("" + i, graphs[i]);
        }
        this.resolveReferences(graphNamesRefs, graphNamesTable);
    }

    private Entry cloneSymbol(Entry symbol) {
        if (symbol == null) {
            return null;
        }
        Entry clone = new Entry();
        clone.setLine(symbol.getLinePattern(), symbol.getLineWidth());
        clone.setLineColor(symbol.getLineColor());
        clone.setMarker(symbol.getMarker());
        clone.setMarkerWidth(symbol.getMarkerWidth());
        clone.setMarkerWeight(symbol.getMarkerWeight());
        clone.setForeground(symbol.getForeground());
        clone.setDataAntiAliased(this._dataAntiAliased);
        return clone;
    }

    private void trimTrailing(LegendItem[] items) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            items[i].setLabel(StringToNumericMap.trimTrailing((String)items[i].getLabel()));
        }
    }

    private void trim(Entry[] entries) {
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            String text;
            String string = text = entries[i] != null ? entries[i].getText() : null;
            if (text == null) continue;
            entries[i].setText(text.trim());
        }
    }

    private LegendItem[] getLegendItems(Object graph, int type) {
        LegendItem[] items = null;
        if (graph instanceof LegendItem) {
            items = new LegendItem[]{(LegendItem)graph};
        } else if ((type == 0 || type == 16) && graph instanceof LegendTextItemList) {
            items = ((LegendTextItemList)graph).getItems();
        } else if (graph instanceof DiscreteLegendInterface) {
            items = ((DiscreteLegendInterface)graph).getLegendItems(type);
        }
        this.trimTrailing(items);
        return items;
    }

    public LegendItem[] getLegendItems(Object graph) {
        LegendItem[] items = null;
        if (graph instanceof LegendItem) {
            items = new LegendItem[]{(LegendItem)graph};
        } else if (graph instanceof LegendTextItemList) {
            items = ((LegendTextItemList)graph).getItems();
        } else if (graph instanceof DiscreteLegendInterface) {
            items = ((DiscreteLegendInterface)graph).getLegendItems(this.type);
        }
        this.trimTrailing(items);
        return items;
    }

    public void resolveReferences(HashMap graphNamesRefs, HashMap graphNamesTable) {
        int sumWidth;
        int width;
        HashMap<Object, Cloneable> valueMap;
        String t;
        Object graph;
        String[] graphIDs = (String[])graphNamesRefs.get(this);
        if (this.isAutoLegend() && this.getTitle() == null && !this.isTitlePulled() && graphIDs.length == 1 && (graph = graphNamesTable.get(graphIDs[0])) instanceof AutoLegendInterface && (t = ((AutoLegendInterface)graph).getDefaultLegendTitle()) != null) {
            this.setTitle(t);
        }
        Entry title = null;
        if (this.getTitle() != null) {
            title = new Entry(this.getTitle());
            title.setFont(this.getTitleFont());
            title.setForeground(this.getTitleColor());
            title.setAlignmentX(this.titleAlignment);
            title.setTextAntiAliased(this._textAntiAliased);
        }
        boolean space4label = false;
        for (int i = 0; i < graphIDs.length; ++i) {
            Object graph2 = graphNamesTable.get(graphIDs[i]);
            if (graph2 == null) continue;
            if (graph2 instanceof DiscreteLegendInterface) {
                space4label = true;
                break;
            }
            if (!(graph2 instanceof LegendItem) || ((LegendItem)graph2).getLabel() == null) continue;
            space4label = true;
            break;
        }
        TreeMap<Object, Cloneable> sortMap = this.sortOrder == 0 ? null : new TreeMap<Object, Cloneable>((Comparator<Object>)new Sort.StringComparator(1, Locale.getDefault(), StatGraph.collation));
        HashMap<Object, Cloneable> hashMap = valueMap = this.sortOrder == 0 ? null : new HashMap<Object, Cloneable>();
        if (!this.isOverlay() && !this.isMergedLegend()) {
            ArrayList av;
            ArrayList as;
            GridBagConstraints cValue;
            int graphType = 0;
            int validEntries = 0;
            for (int i = 0; i < graphIDs.length; ++i) {
                LegendItem[] legendItems;
                Object graph3 = graphNamesTable.get(graphIDs[i]);
                if (graph3 == null) continue;
                if (graph3 instanceof DiscreteAttributeMap) {
                    graphType = 1;
                } else if (graph3 instanceof LegendItem) {
                    graphType = 2;
                }
                if (this.isUnsupportedGraph(graph3, graphIDs[i])) continue;
                if (graph3 instanceof Overlay) {
                    Overlay ovly = (Overlay)graph3;
                    if (ovly.isGroupAllMissings()) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "allmissings.fmt.txt"));
                        StatGraph.printWarning(msg.toString((Object)graphIDs[i]));
                        continue;
                    }
                    if (!ovly.hasLegend(this.type)) continue;
                }
                if ((legendItems = this.getLegendItems(graph3, this.type)) == null) continue;
                ++validEntries;
                EntryStub stub = new EntryStub();
                stub.setSubpixelRendering(this.subpixelRendering);
                stub.setItemLineLength(this.itemLineLength);
                stub.setOutlineFilledChicklet(this.isOutlineFilledChicklet());
                stub.setGraphType(graphType);
                stub.setForeground(this.getValueColor());
                stub.setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                stub.setType(1);
                stub.setTextAntiAliased(this.isTextAntiAliased());
                stub.setDataAntiAliased(this.isDataAntiAliased());
                stub.setGraphAttribute("group");
                stub.setAttrType(this.type);
                stub.setDefaultAttrs(this.defaultAttrs);
                stub.setDefaultOutlineAttrs(this.defaultOutlineAttrs);
                stub.setScaleSymbolWithFont(this.isScaleSymbolWithFont());
                stub.setCustomChickletHeight(this.customChickletHeight);
                stub.setCustomHeightScale(this.customHeightScale);
                stub.setCustomChickletAspect(this.customChickletAspect);
                stub.setFont(this.getFont());
                stub.setQCGlobalLegend(this.qcGlobalLegend);
                Entry[] symbols = stub.resolveReferences(legendItems, graphIDs[i]);
                stub.setType(2);
                Entry[] values = stub.resolveReferences(legendItems, graphIDs[i]);
                if (values == null || values.length == 0) {
                    values = new Entry[1];
                    String legendLabel = null;
                    if (graph3 instanceof Overlay) {
                        legendLabel = ((Overlay)graph3).getLegendLabel();
                    } else if (graph3 instanceof Region) {
                        legendLabel = ((Region)graph3).getLegendLabel();
                    }
                    if (legendLabel == null) {
                        this.setVisible(false);
                        return;
                    }
                    values[0] = new Entry(legendLabel);
                    values[0].setTextAntiAliased(this.isTextAntiAliased());
                    values[0].setFont(this.getFont());
                    values[0].setForeground(this.getValueColor());
                    values[0].setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                }
                this.trim(values);
                if (this.sortOrder == 0 || this.sortOrder == 3) {
                    GridBagConstraints cSymbol;
                    GridBagConstraints gridBagConstraints = cSymbol = this.type == 16 ? new GridBagConstraints() : null;
                    if (cSymbol != null) {
                        cSymbol.anchor = 17;
                    }
                    GridBagConstraints cValue2 = new GridBagConstraints();
                    cValue2.anchor = this.type == 16 ? 13 : 17;
                    Entry lastSymbol = symbols[symbols.length - 1];
                    for (int j = 0; j < values.length; ++j) {
                        String text;
                        int jj;
                        int n = jj = this.sortOrder == 3 ? values.length - 1 - j : j;
                        if (values[jj] == null || jj < symbols.length && symbols[jj] == null || this.excludedValues != null && this.isExcluded(text = values[jj].getRichText() != null ? this.getTextStringOfRichText(values[jj].getRichText()) : (values[jj].getText() != null ? values[jj].getText() : ""))) continue;
                        if (jj < symbols.length) {
                            if (symbols[jj].getRichText() != null) {
                                this.add(this.createTextPane(symbols[jj]));
                            } else if (cSymbol != null) {
                                this.add((Component)symbols[jj], cSymbol);
                            } else {
                                this.add(symbols[jj]);
                            }
                        } else if (lastSymbol.getRichText() != null) {
                            this.add(this.createTextPane(lastSymbol));
                        } else if (cSymbol != null) {
                            this.add((Component)this.cloneSymbol(lastSymbol), cSymbol);
                        } else {
                            this.add(this.cloneSymbol(lastSymbol));
                        }
                        if (values[jj].getRichText() != null) {
                            this.add(this.createTextPane(values[jj]), cValue2);
                            StatGraph.textWrapped = true;
                            continue;
                        }
                        if (!space4label && values[jj].getText() == null) continue;
                        this.add((Component)values[jj], cValue2);
                    }
                    continue;
                }
                Entry lastSymbol = symbols[symbols.length - 1];
                for (int j = 0; j < values.length; ++j) {
                    Component v;
                    String text;
                    if (values[j] == null || j < symbols.length && symbols[j] == null) continue;
                    if (this.sortBySymbolText) {
                        text = symbols[j] != null ? symbols[j].getText() : "";
                        v = values[j];
                    } else if (values[j].getRichText() != null) {
                        text = this.getTextStringOfRichText(values[j].getRichText());
                        v = this.createTextPane(values[j]);
                    } else if (values[j].getText() != null) {
                        text = values[j].getText();
                        v = values[j];
                    } else {
                        text = "";
                        v = values[j];
                    }
                    if (this.isExcluded(text)) continue;
                    ArrayList av2 = valueMap.containsKey(text) ? (ArrayList)valueMap.get(text) : new ArrayList();
                    av2.add(v);
                    valueMap.put(text, av2);
                    Component s = j < symbols.length ? (symbols[j].getRichText() != null ? this.createTextPane(symbols[j]) : symbols[j]) : (lastSymbol.getRichText() != null ? this.createTextPane(lastSymbol) : this.cloneSymbol(lastSymbol));
                    ArrayList as2 = sortMap.containsKey(text) ? (ArrayList)sortMap.get(text) : new ArrayList();
                    as2.add(s);
                    sortMap.put(text, as2);
                }
            }
            if (validEntries == 0) {
                this.setVisible(false);
                return;
            }
            if (this.sortOrder == 1) {
                GridBagConstraints cSymbol;
                GridBagConstraints gridBagConstraints = cSymbol = this.type == 16 ? new GridBagConstraints() : null;
                if (cSymbol != null) {
                    cSymbol.anchor = 17;
                }
                cValue = new GridBagConstraints();
                cValue.anchor = this.type == 16 ? 13 : 17;
                int size = sortMap.size();
                Iterator iter = sortMap.keySet().iterator();
                for (int i = 0; i < size; ++i) {
                    Object text = iter.next();
                    as = (ArrayList)sortMap.get(text);
                    av = (ArrayList)valueMap.get(text);
                    for (int j = 0; j < as.size(); ++j) {
                        Entry sEntry;
                        if (cSymbol != null) {
                            this.add((Component)as.get(j), cSymbol);
                        } else {
                            this.add((Component)as.get(j));
                        }
                        if (space4label || this.type == 16) {
                            this.add((Component)av.get(j), cValue);
                            continue;
                        }
                        if (!(as.get(j) instanceof Entry) || (sEntry = (Entry)as.get(j)).getText() == null) continue;
                        this.add((Component)av.get(j), cValue);
                    }
                }
            } else if (this.sortOrder == 2) {
                int i;
                GridBagConstraints cSymbol;
                GridBagConstraints gridBagConstraints = cSymbol = this.type == 16 ? new GridBagConstraints() : null;
                if (cSymbol != null) {
                    cSymbol.anchor = 17;
                }
                cValue = new GridBagConstraints();
                cValue.anchor = this.type == 16 ? 13 : 17;
                int size = sortMap.size();
                Object[] text = new Object[size];
                Iterator iter = sortMap.keySet().iterator();
                for (i = 0; i < size; ++i) {
                    text[i] = iter.next();
                }
                for (i = size - 1; i >= 0; --i) {
                    as = (ArrayList)sortMap.get(text[i]);
                    av = (ArrayList)valueMap.get(text[i]);
                    for (int j = 0; j < as.size(); ++j) {
                        Entry sEntry;
                        if (cSymbol != null) {
                            this.add((Component)as.get(j), cSymbol);
                        } else {
                            this.add((Component)as.get(j));
                        }
                        if (space4label || this.type == 16) {
                            this.add((Component)av.get(j), cValue);
                            continue;
                        }
                        if (!(as.get(j) instanceof Entry) || (sEntry = (Entry)as.get(j)).getText() == null) continue;
                        this.add((Component)av.get(j), cValue);
                    }
                }
            }
        } else if (this.isOverlay()) {
            Object graph0 = graphNamesTable.get(graphIDs[0]);
            Object graph1 = graphNamesTable.get(graphIDs[1]);
            if (graph0 != null && graph1 != null) {
                EntryStub stub = new EntryStub();
                stub.setOutlineFilledChicklet(this.isOutlineFilledChicklet());
                stub.setForeground(this.getValueColor());
                stub.setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                stub.setType(1);
                stub.setTextAntiAliased(this.isTextAntiAliased());
                stub.setDataAntiAliased(this.isDataAntiAliased());
                stub.setGraphAttribute("group");
                stub.setAttrType(this.type);
                stub.setDefaultAttrs(this.defaultAttrs);
                stub.setDefaultOutlineAttrs(this.defaultOutlineAttrs);
                stub.setScaleSymbolWithFont(this.isScaleSymbolWithFont());
                stub.setCustomChickletHeight(this.customChickletHeight);
                stub.setCustomHeightScale(this.customHeightScale);
                stub.setCustomChickletAspect(this.customChickletAspect);
                stub.setFont(this.getFont());
                LegendItem[] legendItems0 = this.getLegendItems(graph0, this.type);
                Entry[] markers = stub.resolveReferences(legendItems0, graphIDs[0]);
                LegendItem[] legendItems1 = this.getLegendItems(graph1, this.type);
                Entry[] lines = stub.resolveReferences(legendItems1, graphIDs[1]);
                if (markers[0].getMarker() == -1) {
                    Entry[] symbols = markers;
                    markers = lines;
                    lines = symbols;
                }
                for (int j = 0; j < Math.min(markers.length, lines.length); ++j) {
                    markers[j].setLine(lines[j].getLinePattern(), lines[j].getLineWidth());
                    markers[j].setLineColor(lines[j].getForeground());
                }
                stub.setType(2);
                Entry[] values = stub.resolveReferences(legendItems0, graphIDs[0]);
                if (values == null || values.length == 0) {
                    values = new Entry[]{new Entry(((Overlay)graph0).getLegendLabel())};
                    values[0].setTextAntiAliased(this.isTextAntiAliased());
                    values[0].setFont(this.getFont());
                    values[0].setForeground(this.getValueColor());
                    values[0].setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                }
                this.trim(values);
                GridBagConstraints c = new GridBagConstraints();
                if (this.sortOrder == 0 || this.sortOrder == 3) {
                    int len = Math.min(markers.length, values.length);
                    for (int j = 0; j < len; ++j) {
                        String text;
                        int jj;
                        int n = jj = this.sortOrder == 0 ? j : len - 1 - j;
                        if (this.excludedValues != null && this.isExcluded(text = values[jj].getRichText() != null ? this.getTextStringOfRichText(values[jj].getRichText()) : (values[jj].getText() != null ? values[jj].getText() : ""))) continue;
                        this.add(markers[jj]);
                        c.anchor = 17;
                        if (values[jj].getRichText() != null) {
                            this.add(this.createTextPane(values[jj]), c);
                            continue;
                        }
                        this.add((Component)values[jj], c);
                    }
                } else {
                    int size;
                    Object[] text;
                    for (int j = 0; j < Math.min(markers.length, values.length); ++j) {
                        Component v;
                        if (values[j].getRichText() != null) {
                            text = this.getTextStringOfRichText(values[j].getRichText());
                            v = this.createTextPane(values[j]);
                        } else if (values[j].getText() != null) {
                            text = values[j].getText();
                            v = values[j];
                        } else {
                            text = "";
                            v = values[j];
                        }
                        if (this.isExcluded((String)text)) continue;
                        valueMap.put(text, (Cloneable)((Object)v));
                        sortMap.put(text, markers[j]);
                    }
                    if (this.sortOrder == 1) {
                        c.anchor = 17;
                        size = sortMap.size();
                        Iterator iter = sortMap.keySet().iterator();
                        for (int i = 0; i < size; ++i) {
                            Object text2 = iter.next();
                            this.add((Component)sortMap.get(text2));
                            this.add((Component)valueMap.get(text2), c);
                        }
                    } else if (this.sortOrder == 2) {
                        int i;
                        c.anchor = 17;
                        size = sortMap.size();
                        text = new Object[size];
                        Iterator iter = sortMap.keySet().iterator();
                        for (i = 0; i < size; ++i) {
                            text[i] = iter.next();
                        }
                        for (i = size - 1; i >= 0; --i) {
                            this.add((Component)sortMap.get(text[i]));
                            this.add((Component)valueMap.get(text[i]), c);
                        }
                    }
                }
            }
        } else if (this.isMergedLegend()) {
            Object graph0 = graphNamesTable.get(graphIDs[0]);
            Object graph1 = graphNamesTable.get(graphIDs[1]);
            if (graph0 != null && graph1 != null) {
                LegendItem[] legendItems1;
                LegendItem[] legendItems0 = this.getLegendItems(graph0, this.type);
                Entry[][] mergedItems = this.mergeItems(legendItems0, legendItems1 = this.getLegendItems(graph1, this.type));
                if (mergedItems == null) {
                    this.setMergedLegend(false);
                    return;
                }
                Entry[] mergedMarkers = mergedItems[0];
                Entry[] mergedValues = mergedItems[1];
                Entry[] markers = mergedMarkers;
                Entry[] values = mergedValues;
                if (graphIDs.length > 2) {
                    ArrayList<Entry> moreChicklets = new ArrayList<Entry>();
                    ArrayList<Entry> moreValues = new ArrayList<Entry>();
                    for (int i = 2; i < graphIDs.length; ++i) {
                        int graphType = 0;
                        Object graph4 = graphNamesTable.get(graphIDs[i]);
                        if (graph4 == null) continue;
                        if (graph4 instanceof DiscreteAttributeMap) {
                            graphType = 1;
                        } else if (graph4 instanceof LegendItem) {
                            graphType = 2;
                        }
                        if (this.isUnsupportedGraph(graph4, graphIDs[i])) continue;
                        if (graph4 instanceof Overlay) {
                            Overlay ovly = (Overlay)graph4;
                            if (ovly.isGroupAllMissings()) {
                                Message msg = new Message(RB.getStringResource(RB_KEY, "allmissings.fmt.txt"));
                                StatGraph.printWarning(msg.toString((Object)graphIDs[i]));
                                continue;
                            }
                            if (!ovly.hasLegend(this.type)) continue;
                        }
                        LegendItem[] li = this.getLegendItems(graph4, this.type);
                        EntryStub stub = new EntryStub();
                        stub.setOutlineFilledChicklet(this.isOutlineFilledChicklet());
                        stub.setGraphType(graphType);
                        stub.setForeground(this.getValueColor());
                        stub.setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                        stub.setType(1);
                        stub.setTextAntiAliased(this.isTextAntiAliased());
                        stub.setDataAntiAliased(this.isDataAntiAliased());
                        stub.setGraphAttribute("group");
                        stub.setAttrType(this.type);
                        stub.setDefaultAttrs(this.defaultAttrs);
                        stub.setDefaultOutlineAttrs(this.defaultOutlineAttrs);
                        stub.setScaleSymbolWithFont(this.isScaleSymbolWithFont());
                        stub.setCustomChickletHeight(this.customChickletHeight);
                        stub.setCustomHeightScale(this.customHeightScale);
                        stub.setCustomChickletAspect(this.customChickletAspect);
                        stub.setFont(this.getFont());
                        Entry[] symbols = stub.resolveReferences(li, graphIDs[i]);
                        if (symbols != null) {
                            for (int j = 0; j < symbols.length; ++j) {
                                moreChicklets.add(symbols[j]);
                            }
                        }
                        stub.setType(2);
                        Entry[] vals = stub.resolveReferences(li, graphIDs[i]);
                        if (vals == null) continue;
                        for (int j = 0; j < symbols.length; ++j) {
                            moreValues.add(vals[j]);
                        }
                    }
                    int mm = mergedMarkers != null ? mergedMarkers.length : 0;
                    markers = new Entry[mm + moreChicklets.size()];
                    for (int j = 0; j < markers.length; ++j) {
                        markers[j] = j < mm ? mergedMarkers[j] : (Entry)moreChicklets.get(j - mm);
                    }
                    int mv = mergedValues != null ? mergedValues.length : 0;
                    values = new Entry[mv + moreValues.size()];
                    for (int j = 0; j < values.length; ++j) {
                        values[j] = j < mv ? mergedValues[j] : (Entry)moreValues.get(j - mv);
                    }
                }
                if (values == null || values.length == 0) {
                    values = new Entry[]{new Entry(((Overlay)graph0).getLegendLabel())};
                    values[0].setTextAntiAliased(this.isTextAntiAliased());
                    values[0].setFont(this.getFont());
                    values[0].setForeground(this.getValueColor());
                    values[0].setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
                }
                this.trim(values);
                GridBagConstraints c = new GridBagConstraints();
                if (this.sortOrder == 0 || this.sortOrder == 3) {
                    int minLen = Math.min(markers.length, values.length);
                    for (int j = 0; j < minLen; ++j) {
                        String text;
                        int jj;
                        int n = jj = this.sortOrder == 3 ? minLen - 1 - j : j;
                        if (this.excludedValues != null && this.isExcluded(text = values[jj].getRichText() != null ? this.getTextStringOfRichText(values[jj].getRichText()) : (values[jj].getText() != null ? values[jj].getText() : ""))) continue;
                        this.add(markers[jj]);
                        c.anchor = 17;
                        if (values[jj].getRichText() != null) {
                            this.add(this.createTextPane(values[jj]), c);
                            continue;
                        }
                        this.add((Component)values[jj], c);
                    }
                } else {
                    int size;
                    for (int j = 0; j < Math.min(markers.length, values.length); ++j) {
                        Component v;
                        String text;
                        if (values[j].getRichText() != null) {
                            text = this.getTextStringOfRichText(values[j].getRichText());
                            v = this.createTextPane(values[j]);
                        } else if (values[j].getText() != null) {
                            text = values[j].getText();
                            v = values[j];
                        } else {
                            text = "";
                            v = values[j];
                        }
                        if (this.isExcluded(text)) continue;
                        valueMap.put(text, (Cloneable)((Object)v));
                        sortMap.put(text, markers[j]);
                    }
                    if (this.sortOrder == 1) {
                        c.anchor = 17;
                        size = sortMap.size();
                        Iterator iter = sortMap.keySet().iterator();
                        for (int i = 0; i < size; ++i) {
                            Object text = iter.next();
                            this.add((Component)sortMap.get(text));
                            this.add((Component)valueMap.get(text), c);
                        }
                    } else if (this.sortOrder == 2) {
                        int i;
                        c.anchor = 17;
                        size = sortMap.size();
                        Object[] text = new Object[size];
                        Iterator iter = sortMap.keySet().iterator();
                        for (i = 0; i < size; ++i) {
                            text[i] = iter.next();
                        }
                        for (i = size - 1; i >= 0; --i) {
                            this.add((Component)sortMap.get(text[i]));
                            this.add((Component)valueMap.get(text[i]), c);
                        }
                    }
                }
            }
        }
        this.titleOnLeft = false;
        if (this.getOrder() == 0) {
            if (this.getAcross() > 0) {
                this.setColumns(2 * this.getAcross());
                if (this.repositionTitle && title != null && this.getComponents().length <= 2 * this.getAcross()) {
                    width = this.getContainerWidth();
                    sumWidth = 0;
                    Component[] components = this.getComponents();
                    for (int i = 0; i < components.length; ++i) {
                        sumWidth += components[i].getPreferredSize().width;
                    }
                    if (sumWidth + this.getPad() * components.length / 2 + this.getPad() + title.getPreferredSize().width + this.getPad() * this.getNPad() <= width) {
                        this.titleOnLeft = true;
                        this.setColumns(this.getColumns() + 1);
                    }
                }
            } else {
                int rows;
                int across;
                width = this.getContainerWidth();
                Insets in = this.getInsets();
                width -= in.left + in.right;
                Component[] components = this.getComponents();
                int[] widths = new int[components.length];
                int sumWidth2 = 0;
                boolean fit = false;
                for (across = components.length; across > 1 && !fit; --across) {
                    int column;
                    for (column = 0; column < across; ++column) {
                        widths[column] = 0;
                    }
                    for (int row = 0; row <= components.length / across; ++row) {
                        for (int column2 = 0; column2 < across; ++column2) {
                            if (row * across + column2 >= components.length) continue;
                            Component comp = components[row * across + column2];
                            if (widths[column2] >= comp.getPreferredSize().width) continue;
                            widths[column2] = comp.getPreferredSize().width;
                        }
                    }
                    sumWidth2 = 0;
                    for (column = 0; column < across; ++column) {
                        sumWidth2 += widths[column];
                    }
                    fit = sumWidth2 + this.getPad() * across / 2 <= width;
                }
                if (this.repositionTitle && title != null && across + 1 == components.length && sumWidth2 + this.getPad() * components.length / 2 + this.getPad() + title.getPreferredSize().width + this.getPad() * this.getNPad() <= width) {
                    this.titleOnLeft = true;
                }
                if (across % 2 == 1) {
                    ++across;
                }
                if (across > 6 && components.length % (across - 2) == 0) {
                    across -= 2;
                }
                if ((across = (int)Math.ceil((double)components.length / (double)(rows = (int)Math.ceil((double)components.length / (double)across)))) % 2 == 1) {
                    ++across;
                }
                if (across > 6 && components.length % (across - 2) == 0) {
                    across -= 2;
                }
                if (this.titleOnLeft) {
                    ++across;
                }
                this.setColumns(across);
            }
            if (this.getColumns() > 2 || this.qcGlobalLegend && !this.globalLegendRowMajor && this.getColumns() == 2) {
                int[] gutter = new int[this.getColumns() + 1];
                for (int i = 0; i < gutter.length; ++i) {
                    gutter[i] = this.getPad() - this.getPad() * ((i - (this.titleOnLeft ? 1 : 0)) % 2);
                }
                gutter[0] = this.getPad() / 2;
                gutter[gutter.length - 1] = this.getPad() / 2;
                if (this.titleOnLeft) {
                    gutter[0] = this.getPad();
                    gutter[1] = this.getPad() * this.getNPad();
                }
                this.setColumnGutter(gutter);
            }
        } else {
            int i;
            if (this.getDown() > 0) {
                this.setRows(2 * this.getDown());
            } else {
                int cols;
                int down;
                int height = 0;
                if (this.getWrapHeight() > 0) {
                    Insets in = this.getInsets();
                    height = this.wrapHeight - in.top - in.bottom;
                } else {
                    Container container = this.getParent();
                    if (container instanceof OverlayContainer) {
                        height = ((OverlayContainer)container).getPreferredDataAreaSize().height;
                    } else if (container instanceof RegionContainer) {
                        height = ((RegionContainer)container).getPreferredDataAreaSize().height;
                    } else if (container instanceof GridPanel) {
                        int index = -1;
                        int maxRow = -1;
                        Component[] components = container.getComponents();
                        for (int i2 = 0; i2 < components.length; ++i2) {
                            if (components[i2].equals(this)) {
                                index = i2;
                            }
                            if (maxRow >= ((GridPanel)container).getRow(i2)) continue;
                            maxRow = ((GridPanel)container).getRow(i2);
                        }
                        if (maxRow == 0 && ((GridPanel)container).getRow(index) == 0) {
                            Insets inParent = container.getParent().getInsets();
                            Insets inContainer = container.getInsets();
                            height = container.getParent().getSize().height - inParent.top - inParent.bottom - inContainer.top - inContainer.bottom;
                        }
                    } else if (container instanceof TrellisPlot) {
                        Insets in = container.getParent().getInsets();
                        height = ((TrellisPlot)container).getParent().getSize().height - in.top - in.bottom;
                    }
                }
                Component[] components = this.getComponents();
                int[] heights = new int[components.length];
                boolean fit = false;
                for (down = components.length; down > 1 && !fit; --down) {
                    int row;
                    for (int row2 = 0; row2 < down; ++row2) {
                        heights[row2] = 0;
                    }
                    for (int column = 0; column <= components.length / down; ++column) {
                        for (int row3 = 0; row3 < down; ++row3) {
                            if (column * down + row3 >= components.length) continue;
                            Component comp = components[column * down + row3];
                            if (heights[row3] >= comp.getPreferredSize().height) continue;
                            heights[row3] = comp.getPreferredSize().height;
                        }
                    }
                    int sumHeight = 0;
                    if (this.getWrapHeight() > 0) {
                        for (row = 0; row < down; row += 2) {
                            sumHeight += Math.max(heights[row], heights[row + 1]);
                        }
                    } else {
                        for (row = 0; row < down; ++row) {
                            sumHeight += heights[row];
                        }
                    }
                    if (title != null) {
                        sumHeight += title.getPreferredSize().height;
                    }
                    fit = sumHeight + this.getPad() * down / 2 <= height;
                }
                if (down % 2 == 1) {
                    ++down;
                }
                if (down > 6 && components.length % (down - 2) == 0) {
                    down -= 2;
                }
                if ((down = (int)Math.ceil((double)components.length / (double)(cols = (int)Math.ceil((double)components.length / (double)down)))) % 2 == 1) {
                    ++down;
                }
                if (down > 6 && components.length % (down - 2) == 0) {
                    down -= 2;
                }
                this.setRows(down);
            }
            if (this.getRows() > 2) {
                int[] gutter = new int[this.getRows() + 1];
                for (int i3 = 0; i3 < gutter.length; ++i3) {
                    gutter[i3] = 0;
                }
                gutter[0] = this.getPad() / 2;
                gutter[gutter.length - 1] = this.getPad() / 2;
                this.setRowGutter(gutter);
            } else if (this.repositionTitle && title != null) {
                width = this.getContainerWidth();
                sumWidth = 0;
                Component[] components = this.getComponents();
                for (int i4 = 0; i4 < components.length; ++i4) {
                    sumWidth += components[i4].getPreferredSize().width;
                }
                if (sumWidth + this.getPad() * components.length / 2 + this.getPad() + title.getPreferredSize().width + this.getPad() * this.getNPad() <= width) {
                    this.titleOnLeft = true;
                    int[] gutter = new int[]{this.getPad(), this.getPad() * this.getNPad()};
                    this.setColumnGutter(gutter);
                }
            }
            Component[] components = this.getComponents();
            int[] oldRow = this.getRow();
            int[] oldColumn = this.getColumn();
            int[] newRow = new int[oldRow.length];
            int[] newColumn = new int[oldColumn.length];
            GridBagLayout l = (GridBagLayout)this.getLayout();
            GridBagConstraints[] constraints = new GridBagConstraints[components.length];
            for (i = 1; i < newRow.length; ++i) {
                newRow[i] = oldRow[i] / 2;
                newColumn[i] = 2 * oldColumn[i] + oldRow[i] % 2;
                constraints[i] = l.getConstraints(components[i]);
            }
            this.setRow(newRow);
            this.setColumn(newColumn);
            this.removeAll();
            for (i = 0; i < components.length; ++i) {
                this.add(components[i], constraints[i]);
            }
        }
        if (title != null) {
            Component[] components = this.getComponents();
            int[] oldRow = this.getRow();
            int[] oldColumn = this.getColumn();
            int[] oldRowSpan = this.getRowSpan();
            int[] oldColumnSpan = this.getColumnSpan();
            int[] newRow = new int[oldRow.length + 1];
            int[] newColumn = new int[oldColumn.length + 1];
            int[] newRowSpan = new int[oldRowSpan.length + 1];
            int[] newColumnSpan = new int[oldColumnSpan.length + 1];
            GridBagLayout l = (GridBagLayout)this.getLayout();
            GridBagConstraints[] constraints = new GridBagConstraints[components.length];
            for (int i = 1; i < newRow.length; ++i) {
                newRow[i] = oldRow[i - 1] + (this.titleOnLeft ? 0 : 1);
                newColumn[i] = oldColumn[i - 1] + (this.titleOnLeft ? 1 : 0);
                newRowSpan[i] = oldRowSpan[i - 1];
                newColumnSpan[i] = oldColumnSpan[i - 1];
                constraints[i - 1] = l.getConstraints(components[i - 1]);
            }
            if (this.titleOnLeft) {
                newRow[0] = 0;
                newColumn[0] = 0;
                newRowSpan[0] = 1;
                newColumnSpan[0] = 1;
            } else {
                int titleWidth;
                newRow[0] = 0;
                newColumn[0] = 0;
                newRowSpan[0] = 1;
                newColumnSpan[0] = this.getColumns();
                int[] rowWidth = new int[components.length];
                for (int i = 0; i < components.length; ++i) {
                    int n = oldRow[i];
                    rowWidth[n] = rowWidth[n] + components[i].getPreferredSize().width;
                }
                int entryWidth = 0;
                for (int i = 0; i < rowWidth.length; ++i) {
                    if (rowWidth[i] <= entryWidth) continue;
                    entryWidth = rowWidth[i];
                }
                int[] gutter = this.getColumnGutter();
                if (gutter != null) {
                    for (int i = 0; i < gutter.length; ++i) {
                        entryWidth += gutter[i];
                    }
                }
                if ((titleWidth = title.getPreferredSize().width) > entryWidth) {
                    int extraPad = (titleWidth - entryWidth) / 2;
                    for (int i = 0; i < components.length; ++i) {
                        if (oldColumn[i] != 0) continue;
                        constraints[i].insets = new Insets(0, extraPad, 0, 0);
                    }
                }
            }
            this.setRow(newRow);
            this.setColumn(newColumn);
            this.setRowSpan(newRowSpan);
            this.setColumnSpan(newColumnSpan);
            this.removeAll();
            GridBagConstraints c = new GridBagConstraints();
            if (!this.titleOnLeft) {
                c.fill = 2;
            }
            this.add((Component)title, c);
            for (int i = 0; i < components.length; ++i) {
                this.add(components[i], constraints[i]);
            }
            if (this.isTitleBorder() && this.getLineBorderColor() != null) {
                if (this.titleOnLeft) {
                    this.setColumnGrid(1, 1);
                } else {
                    this.setRowGrid(1, 1);
                }
            }
        }
    }

    public Color getLineBorderColor() {
        Border border = this.getBorder();
        if (border == null) {
            return null;
        }
        if (border instanceof StyledLineBorder) {
            return ((StyledLineBorder)border).getLineStyle().getColor();
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder cb = (CompoundBorder)border;
            if (cb.getOutsideBorder() instanceof StyledLineBorder) {
                return ((StyledLineBorder)cb.getOutsideBorder()).getLineStyle().getColor();
            }
            if (cb.getOutsideBorder() instanceof CompoundBorder) {
                CompoundBorder cbo = (CompoundBorder)cb.getOutsideBorder();
                if (cbo.getOutsideBorder() instanceof StyledLineBorder) {
                    return ((StyledLineBorder)cbo.getOutsideBorder()).getLineStyle().getColor();
                }
                if (cbo.getInsideBorder() instanceof StyledLineBorder) {
                    return ((StyledLineBorder)cbo.getInsideBorder()).getLineStyle().getColor();
                }
            }
            if (cb.getInsideBorder() instanceof StyledLineBorder) {
                return ((StyledLineBorder)cb.getInsideBorder()).getLineStyle().getColor();
            }
            if (cb.getInsideBorder() instanceof CompoundBorder) {
                CompoundBorder cbi = (CompoundBorder)cb.getInsideBorder();
                if (cbi.getOutsideBorder() instanceof StyledLineBorder) {
                    return ((StyledLineBorder)cbi.getOutsideBorder()).getLineStyle().getColor();
                }
                if (cbi.getInsideBorder() instanceof StyledLineBorder) {
                    return ((StyledLineBorder)cbi.getInsideBorder()).getLineStyle().getColor();
                }
            }
        }
        return null;
    }

    private boolean validMerge(int type1, int type2) {
        boolean ok = true;
        switch (type1) {
            case 1: {
                if (type2 == 2) break;
                ok = false;
                break;
            }
            case 2: {
                if (type2 == 1) break;
                ok = false;
                break;
            }
            default: {
                ok = false;
            }
        }
        return ok;
    }

    private Entry[][] mergeItems(LegendItem[] legend1, LegendItem[] legend2) {
        int i;
        if (!this.validMerge(legend1[0].getType(), legend2[0].getType())) {
            return null;
        }
        ArrayList<LegendItem> itemList = new ArrayList<LegendItem>();
        for (i = 0; i < legend1.length; ++i) {
            itemList.add(legend1[i]);
        }
        for (i = 0; i < legend2.length; ++i) {
            LegendItem item = legend2[i];
            boolean found = false;
            for (int j = 0; j < legend1.length; ++j) {
                if (!item.getLabel().equals(legend1[j].getLabel())) continue;
                legend1[j].setType(4);
                switch (item.getType()) {
                    case 1: {
                        legend1[j].setSecondarySymbolAttrs(legend1[j].getSymbolAttrs());
                        legend1[j].setSymbolAttrs(item.getSymbolAttrs());
                        break;
                    }
                    case 2: {
                        legend1[j].setSecondarySymbolAttrs(item.getSymbolAttrs());
                    }
                }
                found = true;
                break;
            }
            if (found) continue;
            itemList.add(item);
        }
        LegendItem[] merged = new LegendItem[itemList.size()];
        for (int i2 = 0; i2 < itemList.size(); ++i2) {
            merged[i2] = (LegendItem)itemList.get(i2);
        }
        EntryStub stub = new EntryStub();
        stub.setSubpixelRendering(this.subpixelRendering);
        stub.setItemLineLength(this.itemLineLength);
        stub.setOutlineFilledChicklet(this.isOutlineFilledChicklet());
        stub.setForeground(this.getValueColor());
        stub.setBorder(new EmptyBorder(0, Entry.getDefaultMargin(), 0, Entry.getDefaultMargin()));
        stub.setType(1);
        stub.setTextAntiAliased(this.isTextAntiAliased());
        stub.setDataAntiAliased(this.isDataAntiAliased());
        stub.setGraphAttribute("group");
        stub.setAttrType(this.type);
        stub.setDefaultAttrs(this.defaultAttrs);
        stub.setDefaultOutlineAttrs(this.defaultOutlineAttrs);
        stub.setFont(this.getFont());
        stub.setScaleSymbolWithFont(this.isScaleSymbolWithFont());
        stub.setCustomChickletHeight(this.customChickletHeight);
        stub.setCustomHeightScale(this.customHeightScale);
        stub.setCustomChickletAspect(this.customChickletAspect);
        Entry[] chicklets = stub.resolveReferences(merged, "");
        stub.setType(2);
        Entry[] values = stub.resolveReferences(merged, "");
        Entry[][] items = new Entry[][]{chicklets, values};
        return items;
    }

    private boolean isExcluded(String text) {
        if (this.excludedValues == null) {
            return false;
        }
        for (int i = 0; i < this.excludedValues.length; ++i) {
            if (text != null && text.trim().length() == 0 && this.excludedValues[i].trim().length() == 0) {
                return true;
            }
            if (!this.excludedValues[i].equals(text)) continue;
            return true;
        }
        return false;
    }

    private String getTextStringOfRichText(DefaultStyledDocument richText) {
        String text;
        int l = richText.getLength();
        try {
            text = richText.getText(0, l);
        }
        catch (Exception e) {
            text = "";
        }
        return text;
    }

    private Component createTextPane(Entry richTextEntry) {
        JTextPane textPane = new JTextPane(richTextEntry.getRichText());
        textPane.setEditable(false);
        textPane.setFocusable(false);
        textPane.setBorder(EntryStub.cloneBorder(richTextEntry));
        textPane.setAlignmentX(richTextEntry.getAlignmentX());
        textPane.setAlignmentY(richTextEntry.getAlignmentY());
        textPane.setOpaque(this.isComponentOpaque());
        if (this.isComponentOpaque()) {
            textPane.setBackground(this.getBackground());
        }
        try {
            Class<?> cls = Class.forName("com.sun.java.swing.SwingUtilities2");
            Field fld = cls.getDeclaredField("AA_TEXT_PROPERTY_KEY");
            textPane.putClientProperty(fld.get(null), new Boolean(richTextEntry.isTextAntiAliased()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return textPane;
    }

    private boolean isUnsupportedGraph(Object graph, String id) {
        MapOverlay map;
        boolean unsupported = false;
        if (graph instanceof OContour) {
            OContour ctr = (OContour)graph;
            unsupported = !ctr.hasLines;
        } else if (graph instanceof SurfaceOverlay) {
            SurfaceOverlay surf = (SurfaceOverlay)graph;
            if (surf.isGradientTopColor()) {
                unsupported = true;
            }
        } else if (graph instanceof BlockOverlay) {
            BlockOverlay block = (BlockOverlay)graph;
            if (block.getFillType() == 1) {
                unsupported = true;
            }
        } else if (graph instanceof MapOverlay && (map = (MapOverlay)graph).hasColorResponse()) {
            unsupported = true;
        }
        if (unsupported) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "dlegend.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)id));
        }
        return unsupported;
    }

    public boolean isGlobalLegend() {
        return this.globalLegend;
    }

    public void setGlobalLegend(boolean b) {
        this.globalLegend = b;
    }

    public boolean isGlobalLegendRowMajor() {
        return this.globalLegendRowMajor;
    }

    public void setGlobalLegendRowMajor(boolean b) {
        this.globalLegendRowMajor = b;
    }

    public boolean isQCGlobalLegend() {
        return this.qcGlobalLegend;
    }

    public void setQCGlobalLegend(boolean b) {
        this.qcGlobalLegend = b;
    }

    public boolean isTitlePulled() {
        return this.titlePulled;
    }

    public void setTitlePulled(boolean b) {
        this.titlePulled = b;
    }

    public int getWrapWidth() {
        return this.wrapWidth;
    }

    public void setWrapWidth(int width) {
        this.wrapWidth = width;
    }

    public int getWrapHeight() {
        return this.wrapHeight;
    }

    public void setWrapHeight(int height) {
        this.wrapHeight = height;
    }

    public boolean isScaleSymbolWithFont() {
        return this.scaleSymbolWithFont;
    }

    public void setScaleSymbolWithFont(boolean scaleSymbolWithFont) {
        this.scaleSymbolWithFont = scaleSymbolWithFont;
    }

    protected int getContainerWidth() {
        if (this.wrapWidth > 0) {
            Insets in = this.getInsets();
            return this.wrapWidth - in.left - in.right;
        }
        int width = 0;
        Container container = this.getParent();
        if (container instanceof OverlayContainer) {
            width = ((OverlayContainer)container).getPreferredDataAreaSize().width;
        } else if (container instanceof RegionContainer) {
            width = ((RegionContainer)container).getPreferredDataAreaSize().width;
        } else if (container instanceof GridPanel) {
            int index = -1;
            int maxColumn = -1;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i].equals(this)) {
                    index = i;
                }
                if (maxColumn >= ((GridPanel)container).getColumn(i)) continue;
                maxColumn = ((GridPanel)container).getColumn(i);
            }
            if (maxColumn == 0 && ((GridPanel)container).getColumn(index) == 0) {
                Insets inParent = container.getParent().getInsets();
                Insets inContainer = container.getInsets();
                width = container.getParent().getSize().width - inParent.left - inParent.right - inContainer.left - inContainer.right;
            }
        } else if (container instanceof TrellisPlot) {
            Insets in = container.getParent().getInsets();
            width = ((TrellisPlot)container).getParent().getSize().width - in.left - in.right;
            width = (int)((double)width * 0.875);
        }
        return width;
    }

    private StatGraphPanel getStatGraphPanel() {
        Container comp;
        for (comp = this.getParent(); comp != null && !(comp instanceof StatGraphPanel); comp = comp.getParent()) {
        }
        return (StatGraphPanel)comp;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (!this.isVisible() || this.clippingAllowed || this.getComponentCount() == 0) {
            super.setBounds(x, y, w, h);
            return;
        }
        Container parent = this.getParent();
        if (parent == null || parent.getWidth() == 0 || parent.getHeight() == 0) {
            super.setBounds(x, y, w, h);
            return;
        }
        Insets pi = parent.getInsets();
        Rectangle parentBounds = new Rectangle(pi.left, pi.top, parent.getWidth() - pi.left - pi.right, parent.getHeight() - pi.top - pi.bottom);
        Dimension ps = this.getPreferredSize();
        if (!parentBounds.contains(x, y, w, h) || w < ps.width - 1 || h < ps.height - 1) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "clipping.txt"));
            StatGraphPanel root = this.getStatGraphPanel();
            if (this.isGlobalLegend()) {
                if (root != null) {
                    GlobalLegend gl = root.graph.getGlobalLegend();
                    JComponent glPanel = gl.getPanelComponent();
                    glPanel.removeAll();
                    glPanel.getParent().remove(glPanel);
                    glPanel.setVisible(false);
                    root.invalidate();
                    root.validate();
                }
                return;
            }
            parent.remove(this);
            this.setVisible(false);
            if (root != null) {
                root.invalidate();
                root.validate();
            }
            return;
        }
        super.setBounds(x, y, w, h);
    }

    public void printWarningForGroupAllMissings(Object graphID) {
        Message msg = new Message(RB.getStringResource(RB_KEY, "allmissings.fmt.txt"));
        StatGraph.printWarning(msg.toString(graphID));
    }

    public boolean isOutlineFilledChicklet() {
        return this.outlineFilledChicklet;
    }

    public void setOutlineFilledChicklet(boolean outlineFilledChicklet) {
        this.outlineFilledChicklet = outlineFilledChicklet;
    }

    public int getItemLineLength() {
        return this.itemLineLength;
    }

    public void setItemLineLength(int itemLineLength) {
        this.itemLineLength = itemLineLength;
    }

    public boolean isSortBySymbolText() {
        return this.sortBySymbolText;
    }

    public void setSortBySymbolText(boolean sortBySymbolText) {
        this.sortBySymbolText = sortBySymbolText;
    }

    public double getCustomHeightScale() {
        return this.customHeightScale;
    }

    public void setCustomHeightScale(double customHeightScale) {
        if (customHeightScale != 1.0) {
            this.customHeightScale = customHeightScale;
        }
    }

    public double getCustomChickletAspect() {
        return this.customChickletAspect;
    }

    public void setCustomChickletAspect(double customChickletAspect) {
        this.customChickletAspect = customChickletAspect;
    }

    public double getCustomChickletHeight() {
        return this.customChickletHeight;
    }

    public void setCustomChickletHeight(double customChickletHeight) {
        this.customChickletHeight = customChickletHeight;
    }
}

