/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.SizeLegendParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.AutoLegendInterface;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.RB;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.VLegend;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalLegend {
    public static final String RB_KEY = "GlobalLegend.";
    protected int maximumWrapSize = -1;
    protected double maximumWrapUsageRatio = 1.0;
    protected boolean rowMajor = true;
    protected int gutter = 0;
    protected JComponent[] legendComponents = null;
    protected String[] legendTitles = null;
    protected double[] wrapWeights = null;
    protected boolean titleOnLeft = true;
    protected int maxLegendTitleLength = 0;
    protected String legendTitleFrontPad = " ";
    protected String legendTitleBackPad = "  ";
    protected String title = null;
    protected TextAttrs titleAttrs = new TextAttrs();
    protected boolean displayClipped = false;
    protected boolean resized = false;
    protected JComponent gridPanel = null;
    protected GridPanel legendBodyPanel = null;
    protected boolean antiAliased = true;
    protected String position = "bottom";

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public boolean isVertical() {
        return this.position.equals("left") || this.position.equals("right");
    }

    public JComponent getPanelComponent() {
        return this.gridPanel;
    }

    public void setPanelComponent(JComponent panel) {
        if (this.isVertical()) {
            if (this.rowMajor) {
                this.gridPanel = new GridPanel();
                this.legendBodyPanel = (GridPanel)panel;
                this.gridPanel.add(panel);
                return;
            }
        } else if (!this.rowMajor) {
            this.gridPanel = new GridPanel();
            this.legendBodyPanel = (GridPanel)panel;
            this.gridPanel.add(panel);
            return;
        }
        this.gridPanel = panel;
    }

    public int getMaximumWrapSize() {
        return this.maximumWrapSize;
    }

    public void setMaximumWrapSize(int maxSize) {
        this.maximumWrapSize = maxSize;
    }

    public double getMaximumWrapUsageRatio() {
        return this.maximumWrapUsageRatio;
    }

    public void setMaximumWrapUsageRatio(double maximumWrapUsageRatio) {
        this.maximumWrapUsageRatio = maximumWrapUsageRatio;
    }

    public boolean isRowMajor() {
        return this.rowMajor;
    }

    public void setRowMajor(boolean rowMajor) {
        this.rowMajor = rowMajor;
    }

    public boolean isTitleOnLeft() {
        return this.titleOnLeft;
    }

    public void setTitleOnLeft(boolean titleOnLeft) {
        this.titleOnLeft = titleOnLeft;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title == null) {
            return;
        }
        Entry titleEntry = new Entry(title);
        titleEntry.setBorder(new EmptyBorder(0, 0, StatGraph.getExtraPadding(), 0));
        titleEntry.setFont(this.titleAttrs.getFont());
        titleEntry.setForeground(this.titleAttrs.getColor());
        titleEntry.setTextAntiAliased(this.antiAliased);
        if (this.isVertical()) {
            if (!this.rowMajor) {
                ((TrellisPlot)this.gridPanel).addGridBorderAnnotation((Component)titleEntry, 1);
            } else {
                this.gridPanel.add((Component)titleEntry, 0);
            }
        } else if (this.rowMajor) {
            ((TrellisPlot)this.gridPanel).addGridBorderAnnotation((Component)titleEntry, 1);
        } else {
            this.gridPanel.add((Component)titleEntry, 0);
        }
    }

    int getTitleLength() {
        if (this.title == null) {
            return 0;
        }
        FontMetrics fm = StatGraph.getFontMetrics(this.titleAttrs.getFont());
        return fm.stringWidth(this.title + " ");
    }

    public TextAttrs getTitleAttrs() {
        return this.titleAttrs;
    }

    public void setTitleAttrs(TextAttrs titleAttrs) {
        this.titleAttrs = titleAttrs;
    }

    public int getGutter() {
        return this.gutter;
    }

    public boolean isDisplayClipped() {
        return this.displayClipped;
    }

    public void setDisplayClipped(boolean displayClipped) {
        this.displayClipped = displayClipped;
    }

    public boolean isResized() {
        return this.resized;
    }

    public void setResized(boolean resized) {
        this.resized = resized;
    }

    public void addLegend(int i, JComponent comp, StatGraph graph) {
        this.legendComponents[i] = comp;
        if (comp instanceof Legend) {
            Legend legend = (Legend)comp;
            this.legendTitles[i] = legend.getTitle();
            legend.setOpaque(false);
            legend.setBorder(null);
            legend.repositionTitle = false;
            int len = this.getLegendTitleLength(legend);
            if (len > this.maxLegendTitleLength) {
                this.maxLegendTitleLength = len;
            }
        }
        if (this.isVertical()) {
            if (this.rowMajor) {
                this.addColumnLegend(i, comp, graph);
            } else {
                this.addRowLegend(i, comp, graph);
            }
        } else if (this.rowMajor) {
            this.addRowLegend(i, comp, graph);
        } else {
            this.addColumnLegend(i, comp, graph);
        }
    }

    public void addRowLegend(int i, JComponent comp, StatGraph graph) {
        if (!(comp instanceof Legend)) {
            if (this.isVertical()) {
                ((TrellisPlot)this.gridPanel).addCellItem(i, 0, (Component)comp);
            } else {
                ((TrellisPlot)this.gridPanel).addCellItem(0, i, (Component)comp);
            }
            return;
        }
        OverlayContainer oc = new OverlayContainer(true, false, false, true);
        oc.setOpaque(comp.isOpaque());
        oc.setBackground(comp.getBackground());
        Legend legend = (Legend)comp;
        if (this.titleOnLeft) {
            Object plot;
            String[] graphIDs;
            String legendTitle = null;
            if (legend.getTitle() != null) {
                legendTitle = legend.getTitle();
            } else if (legend.isAutoLegend() && (graphIDs = (String[])graph.getGraphNamesRefs().get(legend)) != null && graphIDs.length == 1 && (plot = graph.getGraphNamesTable().get(graphIDs[0])) instanceof AutoLegendInterface) {
                legendTitle = ((AutoLegendInterface)plot).getDefaultLegendTitle();
            }
            if (legendTitle != null) {
                JPanel panel = new JPanel(new BorderLayout());
                Entry entry = new Entry(this.legendTitleFrontPad + legendTitle + this.legendTitleBackPad);
                entry.setAlignmentY(0.0f);
                entry.setFont(legend.getTitleFont());
                entry.setForeground(legend.getTitleColor());
                entry.setTextAntiAliased(this.antiAliased);
                panel.add((Component)entry, "West");
                legend.setTitle(null);
                legend.setTitlePulled(true);
                panel.setBorder(legend.getBorder());
                legend.setBorder(null);
                panel.setOpaque(false);
                panel.add((Component)legend, "Center");
                oc.add(panel);
                panel.setAlignmentY(0.0f);
            } else {
                oc.add(legend);
                legend.setAlignmentY(0.0f);
            }
        } else {
            oc.add(legend);
            legend.setAlignmentY(0.0f);
        }
        if (this.isVertical()) {
            ((TrellisPlot)this.gridPanel).addCellItem(i, 0, (Component)oc);
        } else {
            ((TrellisPlot)this.gridPanel).addCellItem(0, i, (Component)oc);
        }
    }

    public void addColumnLegend(int i, JComponent comp, StatGraph graph) {
        if (!(comp instanceof Legend)) {
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.weightx = 0.0;
            c.fill = 0;
            this.legendBodyPanel.add((Component)new Entry(), c);
            if (comp instanceof LegendComponent) {
                c.anchor = 17;
                c.weightx = 1.0;
                c.fill = 2;
            } else {
                comp.setAlignmentX(0.0f);
            }
            this.legendBodyPanel.add((Component)comp, c);
            return;
        }
        Legend legend = (Legend)comp;
        Entry title = new Entry();
        if (this.titleOnLeft) {
            Object plot;
            String[] graphIDs;
            String legendTitle = null;
            if (legend.getTitle() != null) {
                legendTitle = legend.getTitle();
            } else if (legend.isAutoLegend() && (graphIDs = (String[])graph.getGraphNamesRefs().get(legend)) != null && graphIDs.length == 1 && (plot = graph.getGraphNamesTable().get(graphIDs[0])) instanceof AutoLegendInterface) {
                legendTitle = ((AutoLegendInterface)plot).getDefaultLegendTitle();
            }
            if (legendTitle != null) {
                title = new Entry(this.legendTitleFrontPad + legendTitle + this.legendTitleBackPad);
                title.setAlignmentY(0.0f);
                title.setFont(legend.getTitleFont());
                title.setForeground(legend.getTitleColor());
                title.setShortText(title.getText());
                title.setTextAntiAliased(this.antiAliased);
                int t1 = StatGraph.getFontMetrics(legend.getFont()).getAscent();
                int t2 = StatGraph.getFontMetrics(title.getFont()).getAscent();
                int delta = (t1 - t2) / 2;
                Insets in = legend.getInsets();
                title.setBorder(new EmptyBorder(in.top + delta, 0, in.bottom, 0));
                legend.setTitle(null);
                legend.setTitlePulled(true);
            }
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.weightx = 0.0;
        c.fill = 0;
        this.legendBodyPanel.add((Component)title, c);
        c = new GridBagConstraints();
        c.anchor = this.titleOnLeft ? 17 : 10;
        c.weightx = 1.0;
        c.fill = 0;
        this.legendBodyPanel.add((Component)legend, c);
    }

    public JComponent getLegend(int i) {
        return this.legendComponents[i];
    }

    public Component getLegendTitle(int i) {
        if (this.rowMajor) {
            return null;
        }
        int idx = -1;
        for (int j = 0; j < this.legendBodyPanel.getComponentCount(); ++j) {
            if (this.legendBodyPanel.getComponent(j) != this.legendComponents[i]) continue;
            idx = j - 1;
            break;
        }
        if (idx >= 0) {
            return this.legendBodyPanel.getComponent(idx);
        }
        return null;
    }

    private int getLegendTitleLength(Legend legend) {
        if (legend == null || legend.getTitle() == null) {
            return 0;
        }
        FontMetrics fm = StatGraph.getFontMetrics(legend.getTitleFont());
        return fm.stringWidth(this.legendTitleFrontPad + legend.getTitle() + this.legendTitleBackPad);
    }

    public int getLegendTitleLength(int i) {
        if (this.legendTitles[i] == null || !(this.legendComponents[i] instanceof Legend)) {
            return 0;
        }
        FontMetrics fm = StatGraph.getFontMetrics(((Legend)this.legendComponents[i]).getTitleFont());
        return fm.stringWidth(this.legendTitleFrontPad + this.legendTitles[i] + this.legendTitleBackPad);
    }

    public int getLegendTitleHeight(int i) {
        if (this.legendTitles[i] == null || !(this.legendComponents[i] instanceof Legend)) {
            return 0;
        }
        FontMetrics fm = StatGraph.getFontMetrics(((Legend)this.legendComponents[i]).getTitleFont());
        return fm.getHeight();
    }

    public int getLegendCount() {
        return this.legendComponents.length;
    }

    private static void addLegendSpacer(Element elem) {
        String str = elem.getAttribute("outerPad");
        if (str.equalsIgnoreCase("AUTO")) {
            elem.removeAttribute("outerPad");
            str = "";
        }
        if (str.length() > 0) {
            return;
        }
        String position = elem.getAttribute("position");
        String spacerSide = position.equalsIgnoreCase("top") ? "bottom" : (position.equalsIgnoreCase("right") ? "left" : (position.equalsIgnoreCase("left") ? "right" : "top"));
        Element outerPadElem = StatGraph.getOptionAttrsElement(elem, "OuterPadAttrs");
        if (outerPadElem == null) {
            Document doc = elem.getOwnerDocument();
            outerPadElem = doc.createElement("OuterPadAttrs");
            elem.appendChild(outerPadElem);
        }
        if (!outerPadElem.hasAttribute(spacerSide)) {
            outerPadElem.setAttribute(spacerSide, "10");
        }
    }

    public static GlobalLegend load(StatGraph graph, Element elem, JComponent rootPanel) {
        GlobalLegend gl;
        block73: {
            JComponent comp;
            int i;
            int gutter;
            String str;
            block71: {
                block72: {
                    int i2;
                    float align;
                    TrellisLayout tl;
                    if (elem.getAttribute("visible").equalsIgnoreCase("off")) {
                        return null;
                    }
                    NodeList legends = elem.getElementsByTagName("DiscreteLegend");
                    NodeList mlegends = elem.getElementsByTagName("MergedLegend");
                    NodeList alegends = elem.getElementsByTagName("AutoLegend");
                    NodeList clegends = elem.getElementsByTagName("ContinuousLegend");
                    NodeList slegends = elem.getElementsByTagName("SizeLegend");
                    int num = legends.getLength() + mlegends.getLength() + alegends.getLength() + clegends.getLength() + slegends.getLength();
                    if (num == 0) {
                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "empty.txt"), false);
                        return null;
                    }
                    gl = new GlobalLegend();
                    gl.antiAliased = graph.axisAntialiased;
                    str = elem.getAttribute("position");
                    if (str.equalsIgnoreCase("top") || str.equalsIgnoreCase("bottom") || str.equalsIgnoreCase("left") || str.equalsIgnoreCase("right")) {
                        gl.setPosition(str.toLowerCase());
                    } else if (str.length() > 0) {
                        StatGraph.printOptionError("position", str);
                    }
                    gutter = 0;
                    str = elem.getAttribute("gutter");
                    if (StatGraph.isNumber(str)) {
                        gutter = Integer.parseInt(str);
                    }
                    gl.gutter = gutter;
                    Object panel = null;
                    str = elem.getAttribute("type");
                    if (gl.isVertical()) {
                        if (str.equalsIgnoreCase("row")) {
                            gl.setRowMajor(true);
                            gl.setResized(true);
                            panel = new GridPanel();
                            ((GridPanel)panel).setRows(2);
                            ((GridPanel)panel).setOrder(1);
                        } else {
                            if (str.length() > 0 && !str.equalsIgnoreCase("column")) {
                                StatGraph.printOptionError("TYPE", str);
                            }
                            gl.setRowMajor(false);
                            panel = gl.new LegendTrellisPanel();
                            tl = new TrellisLayout(num, 1, 0, gutter);
                            ((Container)panel).setLayout((LayoutManager)tl);
                        }
                    } else if (str.equalsIgnoreCase("column")) {
                        gl.setRowMajor(false);
                        gl.setResized(true);
                        panel = new GridPanel();
                        ((GridPanel)panel).setColumns(2);
                        ((GridPanel)panel).setOrder(0);
                    } else {
                        if (str.length() > 0 && !str.equalsIgnoreCase("row")) {
                            StatGraph.printOptionError("TYPE", str);
                        }
                        panel = gl.new LegendTrellisPanel();
                        tl = new TrellisLayout(1, num, gutter, 0);
                        ((Container)panel).setLayout((LayoutManager)tl);
                    }
                    gl.setPanelComponent((JComponent)panel);
                    panel = gl.getPanelComponent();
                    ((JComponent)panel).setOpaque(true);
                    FillAttrs fillStyle = new FillAttrs();
                    GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("backgroundAttrs"), fillStyle, "LegendFill");
                    Element bgAttrsElem = StatGraph.getOptionAttrsElement(elem, "BackgroundAttrs");
                    if (bgAttrsElem != null) {
                        StatGraph.parseFillAttrs(graph, bgAttrsElem, fillStyle);
                    }
                    if (fillStyle.getTransparency() < 0.0) {
                        fillStyle.setTransparency(0.0);
                    }
                    if (fillStyle.getTransparency() < 1.0) {
                        Color bgColor = Overlay.applyTransparency(fillStyle.getColor(), fillStyle.getTransparency());
                        ((JComponent)panel).setBackground(bgColor);
                    } else {
                        ((JComponent)panel).setBackground(null);
                    }
                    if (gl.isVertical()) {
                        align = 0.5f;
                        str = elem.getAttribute("vAlign").toLowerCase();
                        if (str.length() > 0) {
                            align = str.equals("top") ? 0.0f : (str.equals("center") ? 0.5f : (str.equals("bottom") ? 1.0f : Float.NaN));
                        }
                        ((JComponent)panel).setAlignmentY(align);
                    } else {
                        align = 0.5f;
                        str = elem.getAttribute("hAlign").toLowerCase();
                        if (str.length() > 0) {
                            align = str.equals("left") ? 0.0f : (str.equals("center") ? 0.5f : (str.equals("right") ? 1.0f : Float.NaN));
                        }
                        ((JComponent)panel).setAlignmentX(align);
                    }
                    if (!elem.hasAttribute("border")) {
                        elem.setAttribute("border", "true");
                    }
                    GlobalLegend.addLegendSpacer(elem);
                    StatGraph.parseBorderOpts(graph, (JComponent)panel, elem, null);
                    str = elem.getAttribute("legendTitlePosition");
                    if (str.equalsIgnoreCase("top")) {
                        gl.setTitleOnLeft(false);
                    } else if (str.equalsIgnoreCase("left")) {
                        gl.setTitleOnLeft(true);
                    } else {
                        if (str.length() > 0) {
                            StatGraph.printOptionError("LEGENDTITLEPOSITION", str);
                        }
                        if (gl.isVertical()) {
                            gl.setTitleOnLeft(false);
                        } else {
                            gl.setTitleOnLeft(true);
                        }
                    }
                    GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("titleAttrs"), gl.getTitleAttrs(), "LabelText");
                    Element titleAttrsElem = StatGraph.getOptionAttrsElement(elem, "TitleAttrs");
                    if (titleAttrsElem != null) {
                        StatGraph.parseTextAttrs(graph, titleAttrsElem, gl.getTitleAttrs());
                    }
                    if ((str = elem.getAttribute("title")).length() > 0) {
                        gl.setTitle(str);
                    }
                    gl.legendComponents = new JComponent[num];
                    gl.legendTitles = new String[num];
                    gl.wrapWeights = new double[num];
                    for (int i3 = 0; i3 < gl.wrapWeights.length; ++i3) {
                        gl.wrapWeights[i3] = Double.NaN;
                    }
                    Insets in = rootPanel.getInsets();
                    if (gl.isVertical()) {
                        int glHeight = rootPanel.getHeight() - in.top - in.bottom;
                        gl.setMaximumWrapSize(glHeight);
                    } else {
                        int glWidth = rootPanel.getWidth() - in.left - in.right;
                        gl.setMaximumWrapSize(glWidth);
                    }
                    str = elem.getAttribute("maxWrapRatio");
                    if (StatGraph.isNumber(str)) {
                        gl.setMaximumWrapUsageRatio(Double.parseDouble(str));
                    }
                    int cnt = 0;
                    for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                        AbstractSGComponent comp2;
                        Element legElem;
                        if (!(node instanceof Element)) continue;
                        String elemTag = ((Element)node).getTagName();
                        if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                            legElem = (Element)node;
                            comp2 = (Legend)graph.getObjectFromElement(legElem);
                            if (comp2 == null) {
                                comp2 = new Legend();
                            }
                            ((Legend)comp2).setGlobalLegend(true);
                            ((Legend)comp2).setGlobalLegendRowMajor(gl.isRowMajor());
                            LegendParser.load(graph, legElem, comp2, rootPanel);
                            if (!graph.isValidDiscreteLegend((Legend)comp2)) continue;
                            gl.addLegend(cnt++, comp2, graph);
                            continue;
                        }
                        if (elemTag.equals("ContinuousLegend")) {
                            legElem = (Element)node;
                            comp2 = (LegendComponent)graph.getObjectFromElement(legElem);
                            if (comp2 == null) {
                                comp2 = new LegendComponent();
                            }
                            LegendParser.load(graph, legElem, comp2, rootPanel);
                            ((LegendComponent)comp2).setHorizontal(!gl.isVertical());
                            gl.addLegend(cnt++, comp2, graph);
                            continue;
                        }
                        if (!elemTag.equals("SizeLegend")) continue;
                        legElem = (Element)node;
                        comp2 = (SizeLegendComponent)graph.getObjectFromElement(legElem);
                        if (comp2 == null) {
                            comp2 = new SizeLegendComponent();
                        }
                        SizeLegendParser.load(graph, legElem, comp2, rootPanel);
                        comp2.setHorizontal(!gl.isVertical());
                        gl.addLegend(cnt++, comp2, graph);
                    }
                    if (cnt != num) {
                        int i4;
                        JComponent[] ll = new JComponent[cnt];
                        String[] lt = new String[cnt];
                        for (i4 = 0; i4 < cnt; ++i4) {
                            ll[i4] = gl.legendComponents[i4];
                            lt[i4] = gl.legendTitles[i4];
                        }
                        gl.legendComponents = ll;
                        gl.legendTitles = lt;
                        gl.wrapWeights = new double[cnt];
                        for (i4 = 0; i4 < gl.wrapWeights.length; ++i4) {
                            gl.wrapWeights[i4] = Double.NaN;
                        }
                        if (panel instanceof LegendTrellisPanel) {
                            for (i4 = num - 1; i4 >= cnt; --i4) {
                                ((LegendTrellisPanel)((Object)panel)).removeUnaddedColumn(i4);
                            }
                        }
                        num = cnt;
                    }
                    if ((str = elem.getAttribute("displayClipped")).equalsIgnoreCase("true")) {
                        gl.setDisplayClipped(true);
                    } else {
                        if (str.length() > 0 && !str.equalsIgnoreCase("false")) {
                            StatGraph.printOptionError("DISPLAYCLIPPED", str);
                        }
                        gl.setDisplayClipped(false);
                    }
                    for (i = 0; i < gl.getLegendCount(); ++i) {
                        comp = gl.getLegend(i);
                        if (!(comp instanceof Legend)) continue;
                        ((Legend)comp).setClippingAllowed(gl.isDisplayClipped());
                    }
                    str = elem.getAttribute("weights");
                    if ((!gl.isVertical() || gl.isRowMajor()) && (gl.isVertical() || !gl.isRowMajor())) break block71;
                    if (str.length() <= 0) break block72;
                    String[] weights = StatGraph.parseList2String(str);
                    if (weights.length == 1 && !StatGraph.isNumber(weights[0])) {
                        int i5;
                        String weightStr;
                        if (weights[0].equalsIgnoreCase("UNIFORM")) {
                            weights = new String[num];
                            double weight = 1.0 / (double)gl.getLegendCount();
                            weightStr = Double.toString(weight);
                            for (i5 = 0; i5 < weights.length; ++i5) {
                                weights[i5] = weightStr;
                            }
                        } else if (weights[0].equalsIgnoreCase("PREFERRED")) {
                            weights = new String[num];
                            for (int i6 = 0; i6 < weights.length; ++i6) {
                                weights[i6] = "PREFERRED";
                            }
                        } else {
                            StatGraph.printOptionError("WEIGHTS", weights[0]);
                            weights = new String[num];
                            double weight = 1.0 / (double)gl.getLegendCount();
                            weightStr = Double.toString(weight);
                            for (i5 = 0; i5 < weights.length; ++i5) {
                                weights[i5] = weightStr;
                            }
                        }
                    }
                    if (weights.length != num) break block73;
                    double total = 0.0;
                    for (i2 = 0; i2 < weights.length; ++i2) {
                        Legend legend;
                        if (StatGraph.isNumber(weights[i2])) {
                            total += Double.parseDouble(weights[i2]);
                            continue;
                        }
                        JComponent comp3 = gl.getLegend(i2);
                        if (!(comp3 instanceof Legend) || ((legend = (Legend)comp3).getAcross() > 0 || legend.getOrder() != 0) && (legend.getDown() > 0 || legend.getOrder() != 1)) continue;
                        if (gl.isVertical()) {
                            legend.setDown(1);
                            legend.setOrder(1);
                            continue;
                        }
                        legend.setAcross(1);
                        legend.setOrder(0);
                    }
                    if (!(total > 0.0)) break block73;
                    for (i2 = 0; i2 < weights.length; ++i2) {
                        double weight;
                        if (!StatGraph.isNumber(weights[i2])) continue;
                        gl.wrapWeights[i2] = weight = Double.parseDouble(weights[i2]) / total;
                        JComponent comp4 = gl.getLegend(i2);
                        if (!(comp4 instanceof Legend)) continue;
                        Legend legend = (Legend)comp4;
                        legend.setAcross(0);
                        legend.setDown(0);
                        if (gl.isVertical()) {
                            legend.setOrder(1);
                            continue;
                        }
                        legend.setOrder(0);
                    }
                    break block73;
                }
                double weight = 1.0 / (double)gl.getLegendCount();
                for (int i7 = 0; i7 < gl.getLegendCount(); ++i7) {
                    gl.wrapWeights[i7] = weight;
                    JComponent comp5 = gl.getLegend(i7);
                    if (!(comp5 instanceof Legend)) continue;
                    Legend legend = (Legend)comp5;
                    legend.setAcross(0);
                    legend.setDown(0);
                    if (gl.isVertical()) {
                        legend.setOrder(1);
                        continue;
                    }
                    legend.setOrder(0);
                }
                break block73;
            }
            if (str.length() > 0) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "weights.txt"));
            }
            if (gl.isVertical()) {
                gl.legendBodyPanel.setColumnGutters(gutter);
            } else {
                gl.legendBodyPanel.setRowGutters(gutter);
            }
            for (i = 0; i < gl.getLegendCount(); ++i) {
                comp = gl.getLegend(i);
                if (!(comp instanceof Legend)) continue;
                Legend legend = (Legend)comp;
                if (gl.isVertical()) {
                    legend.setOrder(1);
                    continue;
                }
                legend.setOrder(0);
            }
        }
        return gl;
    }

    public void disableLayout() {
        ((TrellisPlot)this.gridPanel).disableLayout();
    }

    public void enableLayout() {
        ((TrellisPlot)this.gridPanel).enableLayout();
    }

    public boolean resolveGlobalLegends(StatGraph graph) {
        return this.isVertical() ? this.resolveVerticalGlobalLegends(graph) : this.resolveHorizontalGlobalLegends(graph);
    }

    private int setupLegends(StatGraph graph) {
        int cLegendCount = this.getNumContinuousLegends();
        for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof Legend)) {
                if (comp instanceof LegendComponent) {
                    LegendComponent lc = (LegendComponent)comp;
                    VLegend legend = lc.getLegend();
                    String[] gids = (String[])graph.getGraphNamesRefs().get(lc);
                    Object ref = graph.getGraphNamesTable().get(gids[0]);
                    StatGraph.resolveLegendRefs(legend, ref);
                    continue;
                }
                SizeLegendComponent sl = (SizeLegendComponent)comp;
                String[] gids = (String[])graph.getGraphNamesRefs().get(sl);
                Object ref = graph.getGraphNamesTable().get(gids[0]);
                StatGraph.resolveLegendRefs(sl, ref);
                continue;
            }
            if (cLegendCount <= 0) continue;
            Legend legend = (Legend)comp;
            HashMap legendNamesTable = graph.getLegendNamesTable(legend);
            legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
        }
        return cLegendCount;
    }

    private int getNumContinuousLegends() {
        int cLegendCount = 0;
        for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof LegendComponent)) continue;
            ++cLegendCount;
        }
        return cLegendCount;
    }

    private int getContinuousLegendLenth(int globalLegendLength, int cLegendCount, boolean vertical) {
        if (cLegendCount == 0) {
            return 0;
        }
        int othersLength = 0;
        for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (comp instanceof LegendComponent) continue;
            int len = vertical ? ((Component)comp).getPreferredSize().height : ((Component)comp).getPreferredSize().width;
            othersLength += len + StatGraph.getExtraPadding();
        }
        return (globalLegendLength - othersLength) / cLegendCount;
    }

    public boolean resolveHorizontalGlobalLegends(StatGraph graph) {
        JComponent glPanel = this.getPanelComponent();
        Insets in = glPanel.getInsets();
        double globalLegendWidth = (double)(this.maximumWrapSize - in.left - in.right) * this.maximumWrapUsageRatio;
        if (this.isRowMajor()) {
            globalLegendWidth -= (double)(this.getGutter() * (this.getLegendCount() - 1));
        }
        int cLegendCount = this.setupLegends(graph);
        if (!this.isRowMajor()) {
            double[] rowWeights = new double[this.getLegendCount()];
            for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
                JComponent comp = this.getLegend(cnt);
                if (!(comp instanceof Legend)) {
                    Dimension ps = ((Component)comp).getPreferredSize();
                    if (comp instanceof LegendComponent) {
                        ps.width = (int)globalLegendWidth;
                    }
                    ((Component)comp).setPreferredSize(ps);
                    continue;
                }
                Legend legend = (Legend)comp;
                if (!graph.isValidDiscreteLegend(legend)) {
                    Component c = this.getLegendTitle(cnt);
                    if (c != null) {
                        c.getParent().remove(c);
                        c.setVisible(false);
                    }
                    legend.getParent().remove(legend);
                    legend.setVisible(false);
                    continue;
                }
                if (this.isTitleOnLeft()) {
                    legend.setWrapWidth((int)globalLegendWidth - this.maxLegendTitleLength);
                } else {
                    legend.setWrapWidth((int)globalLegendWidth);
                }
                if (cLegendCount == 0) {
                    HashMap legendNamesTable = graph.getLegendNamesTable(legend);
                    legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
                }
                Dimension ps = legend.getPreferredSize();
                rowWeights[cnt] = (double)ps.height / globalLegendWidth;
            }
            if (cLegendCount > 0) {
                Dimension d = glPanel.getPreferredSize();
                d.width = (int)globalLegendWidth;
                glPanel.setPreferredSize(d);
            }
            return true;
        }
        int cLegendWidth = this.getContinuousLegendLenth((int)globalLegendWidth, cLegendCount, false);
        double[] colWeights = new double[this.getLegendCount()];
        double totalPrefWidth = 0.0;
        int invalidLegends = 0;
        for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof Legend)) {
                Dimension ps = ((Component)comp).getPreferredSize();
                if (comp instanceof LegendComponent) {
                    ps.width = cLegendWidth - StatGraph.getExtraPadding() - 1;
                }
                totalPrefWidth += (double)(ps.width + StatGraph.getExtraPadding());
                colWeights[cnt] = (double)(ps.width + StatGraph.getExtraPadding()) / globalLegendWidth;
                continue;
            }
            Legend legend = (Legend)comp;
            if (!graph.isValidDiscreteLegend(legend)) {
                legend.setVisible(false);
                ++invalidLegends;
                continue;
            }
            if (!Double.isNaN(this.wrapWeights[cnt]) && cLegendCount == 0) continue;
            if (cLegendCount == 0) {
                HashMap legendNamesTable = graph.getLegendNamesTable(legend);
                legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
            }
            Dimension ps = legend.getPreferredSize();
            if (this.isTitleOnLeft()) {
                ps.width += this.getLegendTitleLength(cnt);
            }
            totalPrefWidth += (double)(ps.width + StatGraph.getExtraPadding());
            colWeights[cnt] = (double)(ps.width + StatGraph.getExtraPadding()) / globalLegendWidth;
        }
        if (cLegendCount > 0) {
            Dimension d = glPanel.getPreferredSize();
            d.width = (int)globalLegendWidth;
            glPanel.setPreferredSize(d);
        }
        if (invalidLegends == this.getLegendCount()) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "empty.txt"), false);
            return false;
        }
        double remainingWidth = globalLegendWidth - totalPrefWidth;
        if (remainingWidth < 0.0) {
            int i;
            if (!this.isDisplayClipped()) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "clipping.txt"), false);
                return false;
            }
            double totalWeight = 0.0;
            for (i = 0; i < colWeights.length; ++i) {
                if (colWeights[i] == 0.0) continue;
                if (totalWeight + colWeights[i] > 1.0) {
                    colWeights[i] = 1.0 - totalWeight;
                    totalWeight = 1.0;
                    for (int j = i + 1; j < colWeights.length; ++j) {
                        colWeights[j] = 0.0;
                    }
                    break;
                }
                totalWeight += colWeights[i];
            }
            for (i = 0; i < colWeights.length; ++i) {
                if (colWeights[i] != 0.0) continue;
                JComponent jc = this.getLegend(i);
                glPanel.remove(jc);
                jc.setVisible(false);
            }
            TrellisLayout tl = (TrellisLayout)glPanel.getLayout();
            tl.setColumnWeights(this.fixWeights(colWeights));
            return true;
        }
        for (int cnt = 0; cnt < this.getLegendCount() && cLegendCount == 0; ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof Legend)) continue;
            Legend legend = (Legend)comp;
            if (!graph.isValidDiscreteLegend(legend)) {
                legend.setVisible(false);
                continue;
            }
            double weight = this.wrapWeights[cnt];
            if (Double.isNaN(weight) || weight == 0.0) continue;
            double width = weight * remainingWidth;
            if (this.isTitleOnLeft()) {
                legend.setWrapWidth((int)width - this.getLegendTitleLength(cnt));
            } else {
                legend.setWrapWidth((int)width);
            }
            colWeights[cnt] = width / globalLegendWidth;
            if (cLegendCount != 0) continue;
            HashMap legendNamesTable = graph.getLegendNamesTable(legend);
            legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
        }
        this.setResized(this.maximumWrapUsageRatio < 1.0);
        if (remainingWidth > 0.0 && totalPrefWidth > 0.0) {
            int i;
            this.setResized(true);
            double actualWidth = 0.0;
            for (i = 0; i < colWeights.length; ++i) {
                actualWidth += colWeights[i] * globalLegendWidth;
            }
            if (actualWidth < globalLegendWidth) {
                for (i = 0; i < colWeights.length; ++i) {
                    colWeights[i] = colWeights[i] * globalLegendWidth / actualWidth;
                }
                Dimension d = glPanel.getPreferredSize();
                d.width = (int)(actualWidth + (double)in.left + (double)in.right + (double)(this.getGutter() * (this.getLegendCount() - 1)));
                glPanel.setPreferredSize(d);
            }
        }
        TrellisLayout tl = (TrellisLayout)glPanel.getLayout();
        tl.setColumnWeights(this.fixWeights(colWeights));
        return true;
    }

    public boolean resolveVerticalGlobalLegends(StatGraph graph) {
        JComponent glPanel = this.getPanelComponent();
        Insets in = glPanel.getInsets();
        double globalLegendHeight = (double)(this.maximumWrapSize - in.top - in.bottom) * this.maximumWrapUsageRatio;
        if (!this.isRowMajor()) {
            globalLegendHeight -= (double)(this.getGutter() * (this.getLegendCount() - 1));
        }
        int cLegendCount = this.setupLegends(graph);
        if (this.isRowMajor()) {
            double[] colWeights = new double[this.getLegendCount()];
            for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
                JComponent comp = this.getLegend(cnt);
                if (!(comp instanceof Legend)) {
                    Dimension ps = ((Component)comp).getPreferredSize();
                    if (comp instanceof LegendComponent) {
                        ps.height = (int)globalLegendHeight;
                        ((Component)comp).setPreferredSize(ps);
                        continue;
                    }
                    ((Component)comp).setMinimumSize(ps);
                    continue;
                }
                Legend legend = (Legend)comp;
                if (!graph.isValidDiscreteLegend(legend)) {
                    Component c = this.getLegendTitle(cnt);
                    if (c != null) {
                        c.getParent().remove(c);
                        c.setVisible(false);
                    }
                    legend.getParent().remove(legend);
                    legend.setVisible(false);
                    continue;
                }
                if (!this.isTitleOnLeft()) {
                    legend.setWrapHeight((int)globalLegendHeight - this.getLegendTitleHeight(cnt));
                } else {
                    legend.setWrapHeight((int)globalLegendHeight);
                }
                if (cLegendCount == 0) {
                    HashMap legendNamesTable = graph.getLegendNamesTable(legend);
                    legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
                }
                Dimension ps = legend.getPreferredSize();
                colWeights[cnt] = (double)ps.width / globalLegendHeight;
            }
            if (cLegendCount > 0) {
                Dimension d = glPanel.getPreferredSize();
                d.height = (int)globalLegendHeight;
                glPanel.setPreferredSize(d);
            }
            return true;
        }
        int cLegendHeight = this.getContinuousLegendLenth((int)globalLegendHeight, cLegendCount, true);
        double[] rowWeights = new double[this.getLegendCount()];
        double totalPrefHeight = 0.0;
        int invalidLegends = 0;
        for (int cnt = 0; cnt < this.getLegendCount(); ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof Legend)) {
                Dimension ps = ((Component)comp).getPreferredSize();
                if (comp instanceof LegendComponent) {
                    ps.height = cLegendHeight - StatGraph.getExtraPadding() - 1;
                }
                totalPrefHeight += (double)(ps.height + StatGraph.getExtraPadding());
                rowWeights[cnt] = (double)(ps.height + StatGraph.getExtraPadding()) / globalLegendHeight;
                continue;
            }
            Legend legend = (Legend)comp;
            if (!graph.isValidDiscreteLegend(legend)) {
                legend.setVisible(false);
                ++invalidLegends;
                continue;
            }
            if (!Double.isNaN(this.wrapWeights[cnt]) && cLegendCount == 0) continue;
            if (cLegendCount == 0) {
                HashMap legendNamesTable = graph.getLegendNamesTable(legend);
                legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
            }
            Dimension ps = legend.getPreferredSize();
            if (!this.isTitleOnLeft()) {
                ps.height += this.getLegendTitleHeight(cnt);
            }
            totalPrefHeight += (double)(ps.height + StatGraph.getExtraPadding());
            rowWeights[cnt] = (double)(ps.height + StatGraph.getExtraPadding()) / globalLegendHeight;
        }
        if (invalidLegends == this.getLegendCount()) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "empty.txt"), false);
            return false;
        }
        double remainingHeight = globalLegendHeight - totalPrefHeight;
        if (remainingHeight < 0.0) {
            int i;
            if (!this.isDisplayClipped()) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "clipping.txt"), false);
                return false;
            }
            double totalWeight = 0.0;
            for (i = 0; i < rowWeights.length; ++i) {
                if (rowWeights[i] == 0.0) continue;
                if (totalWeight + rowWeights[i] > 1.0) {
                    rowWeights[i] = 1.0 - totalWeight;
                    totalWeight = 1.0;
                    for (int j = i + 1; j < rowWeights.length; ++j) {
                        rowWeights[j] = 0.0;
                    }
                    break;
                }
                totalWeight += rowWeights[i];
            }
            for (i = 0; i < rowWeights.length; ++i) {
                if (rowWeights[i] != 0.0) continue;
                JComponent jc = this.getLegend(i);
                glPanel.remove(jc);
                jc.setVisible(false);
            }
            TrellisLayout tl = (TrellisLayout)glPanel.getLayout();
            tl.setRowWeights(this.fixWeights(rowWeights));
            return true;
        }
        for (int cnt = 0; cnt < this.getLegendCount() && cLegendCount == 0; ++cnt) {
            JComponent comp = this.getLegend(cnt);
            if (!(comp instanceof Legend)) continue;
            Legend legend = (Legend)comp;
            if (!graph.isValidDiscreteLegend(legend)) {
                legend.setVisible(false);
                continue;
            }
            double weight = this.wrapWeights[cnt];
            if (Double.isNaN(weight) || weight == 0.0) continue;
            double height = weight * remainingHeight;
            if (!this.isTitleOnLeft()) {
                legend.setWrapHeight((int)height - this.getLegendTitleHeight(cnt));
            } else {
                legend.setWrapHeight((int)height);
            }
            rowWeights[cnt] = height / globalLegendHeight;
            if (cLegendCount != 0) continue;
            HashMap legendNamesTable = graph.getLegendNamesTable(legend);
            legend.resolveReferences(graph.getGraphNamesRefs(), legendNamesTable);
        }
        this.setResized(this.maximumWrapUsageRatio < 1.0);
        if (remainingHeight > 0.0 && totalPrefHeight > 0.0) {
            int i;
            this.setResized(true);
            double actualHeight = 0.0;
            for (i = 0; i < rowWeights.length; ++i) {
                actualHeight += rowWeights[i] * globalLegendHeight;
            }
            if (actualHeight < globalLegendHeight) {
                for (i = 0; i < rowWeights.length; ++i) {
                    rowWeights[i] = rowWeights[i] * globalLegendHeight / actualHeight;
                }
                Dimension d = glPanel.getPreferredSize();
                d.height = (int)(actualHeight + (double)in.top + (double)in.bottom + (double)(this.getGutter() * (this.getLegendCount() - 1)));
                glPanel.setPreferredSize(d);
            }
        }
        TrellisLayout tl = (TrellisLayout)glPanel.getLayout();
        tl.setRowWeights(this.fixWeights(rowWeights));
        return true;
    }

    private double[] fixWeights(double[] weights) {
        int i;
        double total = 0.0;
        for (i = 0; i < weights.length; ++i) {
            total += weights[i];
        }
        if (total < 1.0) {
            for (i = 0; i < weights.length; ++i) {
                weights[i] = weights[i] / total;
            }
        }
        return weights;
    }

    public GridBagConstraints getConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        if (this.isVertical()) {
            if (this.gridPanel.getAlignmentY() == 0.0f) {
                c.anchor = 11;
            } else if (this.gridPanel.getAlignmentX() == 1.0f) {
                c.anchor = 15;
            }
        } else if (this.gridPanel.getAlignmentX() == 0.0f) {
            c.anchor = 17;
        } else if (this.gridPanel.getAlignmentX() == 1.0f) {
            c.anchor = 13;
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        int cLegendCount = this.getNumContinuousLegends();
        c.fill = cLegendCount > 0 ? 1 : 0;
        return c;
    }

    class LegendTrellisPanel
    extends TrellisPlot {
        LegendTrellisPanel() {
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, GlobalLegend.this.getTitleLength());
            return d;
        }

        public void removeUnaddedColumn(int col) {
            TrellisLayout layout = (TrellisLayout)this.getLayout();
            layout.removeColumn(col);
            layout.resetVisibleColumns();
        }
    }
}

