/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.util.legend.LegendItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class EntryStub
extends AbstractSGComponent {
    private boolean _dataAntiAliased = false;
    private boolean _textAntiAliased = false;
    private String _text = null;
    private String _shortText = null;
    private boolean _isWrap = false;
    private int _wrapWidth = 0;
    private double _theta = 0.0;
    private String _graphAttribute = null;
    private String _graphName = null;
    private String[] _values = null;
    private int _type = 0;
    public static final int TEXT = 0;
    public static final int SYMBOLS = 1;
    public static final int VALUES = 2;
    private ColorAttr defaultAttrs;
    private LineAttrs defaultOutlineAttrs;
    private int attrType;
    static final int PLOT = 0;
    static final int ATTRMAP = 1;
    static final int LEGENDITEM = 2;
    private int graphType = 0;
    private boolean scaleSymbolWithFont = false;
    private boolean outlineFilledChicklet = true;
    private boolean qcGlobalLegend = false;
    private int itemLineLength = Entry.LEGEND_LINE_LENGTH;
    private boolean subpixelRendering = false;
    private double customHeightScale = Double.NaN;
    private double customChickletHeight = Double.NaN;
    private double customChickletAspect = Double.NaN;

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public boolean isTextAntiAliased() {
        return this._textAntiAliased;
    }

    public void setTextAntiAliased(boolean textAntiAliased) {
        this._textAntiAliased = textAntiAliased;
    }

    public boolean isDataAntiAliased() {
        return this._dataAntiAliased;
    }

    public void setDataAntiAliased(boolean dataAntiAliased) {
        this._dataAntiAliased = dataAntiAliased;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public double getTheta() {
        return this._theta;
    }

    public void setTheta(double theta) {
        this._theta = theta;
    }

    public String getShortText() {
        return this._shortText;
    }

    public void setShortText(String text) {
        this._shortText = text;
    }

    public boolean isWrap() {
        return this._isWrap;
    }

    public void setWrap(boolean isWrap) {
        this._isWrap = isWrap;
    }

    public int getWrapWidth() {
        return this._wrapWidth;
    }

    public void setWrapWidth(int wrapWidth) {
        this._wrapWidth = wrapWidth;
    }

    public String[] getValues() {
        return this._values;
    }

    public void setValues(String[] values) {
        this._values = values;
    }

    public String getGraphAttribute() {
        return this._graphAttribute;
    }

    public void setGraphAttribute(String graphAttribute) {
        this._graphAttribute = graphAttribute;
    }

    public String getGraphName() {
        return this._graphName;
    }

    public void setGraphName(String graphName) {
        this._graphName = graphName;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void setDefaultAttrs(ColorAttr attrs) {
        this.defaultAttrs = attrs;
    }

    public void setDefaultOutlineAttrs(LineAttrs attrs) {
        this.defaultOutlineAttrs = attrs;
    }

    public void setAttrType(int type) {
        this.attrType = type;
    }

    private ColorAttr completeAttrProperties(ColorAttr attr) {
        if (attr == null) {
            return this.defaultAttrs;
        }
        switch (this.attrType) {
            default: {
                return attr;
            }
            case 7: 
            case 8: 
            case 11: {
                FillAttrs fillAttr = (FillAttrs)attr;
                FillAttrs theFillAttr = (FillAttrs)this.defaultAttrs;
                FillAttrs newFillAttr = new FillAttrs();
                newFillAttr.setColor(fillAttr.getColor() != null ? fillAttr.getColor() : theFillAttr.getColor());
                return newFillAttr;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                LineAttrs lineAttr = (LineAttrs)attr;
                LineAttrs theLineAttr = (LineAttrs)this.defaultAttrs;
                LineAttrs newLineAttr = new LineAttrs();
                newLineAttr.setColor(lineAttr.getColor() != null ? lineAttr.getColor() : theLineAttr.getColor());
                newLineAttr.setLinePattern(lineAttr.getLinePattern() >= 0 ? lineAttr.getLinePattern() : theLineAttr.getLinePattern());
                newLineAttr.setWidth(lineAttr.getWidth() > 0 ? lineAttr.getWidth() : theLineAttr.getWidth());
                return newLineAttr;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
        }
        MarkerAttrs markerAttr = (MarkerAttrs)attr;
        MarkerAttrs theMarkerAttr = (MarkerAttrs)this.defaultAttrs;
        MarkerAttrs newMarkerAttr = new MarkerAttrs();
        newMarkerAttr.setColor(markerAttr.getColor() != null ? markerAttr.getColor() : theMarkerAttr.getColor());
        newMarkerAttr.setShape(markerAttr.getShape() >= 0 ? markerAttr.getShape() : theMarkerAttr.getShape());
        newMarkerAttr.setSize(markerAttr.getSize() > 0 ? markerAttr.getSize() : theMarkerAttr.getSize());
        newMarkerAttr.setWeight(markerAttr.getWeight() >= 0 ? markerAttr.getWeight() : theMarkerAttr.getWeight());
        return newMarkerAttr;
    }

    public Entry[] resolveReferences(LegendItem[] items, String graphID) {
        int i;
        int type = this.getType();
        Entry[] entries = new Entry[]{};
        if (type == 0) {
            entries = new Entry[]{new Entry(this.getText(), this.getTheta())};
        } else if (type == 1) {
            FontMetrics fm = StatGraph.getFontMetrics(this.getFont());
            entries = new Entry[items.length];
            block7: for (int i2 = 0; i2 < items.length; ++i2) {
                if (!items[i2].isValid(this.attrType)) continue;
                entries[i2] = new Entry();
                if (this.scaleSymbolWithFont || this.isCustomChickletAspect() || this.isCustomHeightScale() || this.isCustomChickletHeight()) {
                    entries[i2].setFont(this.getFont());
                    entries[i2].setScaleSymbolWithFont(this.scaleSymbolWithFont);
                    entries[i2].setCustomChickletHeight(this.customChickletHeight);
                    entries[i2].setCustomHeightScale(this.customHeightScale);
                    entries[i2].setCustomChickletAspect(this.customChickletAspect);
                }
                switch (items[i2].getType()) {
                    case 3: {
                        int len;
                        int ms;
                        entries[i2].setItemLineLength(this.itemLineLength);
                        entries[i2].setSwatchType(items[i2].getFillType());
                        FillAttrs fillAttr = (FillAttrs)items[i2].getSymbolAttrs();
                        LineAttrs lineAttr = (LineAttrs)items[i2].getSecondarySymbolAttrs();
                        FillPatternAttrs patternAttr = items[i2].getFillPatternAttrs();
                        if (this.attrType == 0 || this.attrType == 11) {
                            entries[i2].setColor(fillAttr.getColor());
                            entries[i2].setFillPattern(patternAttr);
                            entries[i2].setSkinImage(items[i2].getSkinImage());
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setPixelBenderImages(items[i2].getPixelBenderImages());
                            if (lineAttr != null && lineAttr.getColor() != null) {
                                entries[i2].setForeground(lineAttr.getColor());
                            } else {
                                entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                                if (!items[i2].isFillOutline() || !this.isOutlineFilledChicklet() && this.graphType == 0) {
                                    entries[i2].setSwatchOutlineOn(false);
                                }
                            }
                            int w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            continue block7;
                        }
                        if (this.attrType == 7) {
                            entries[i2].setColor(fillAttr.getColor());
                            entries[i2].setFillPattern(null);
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            int w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            if (items[i2].isFillOutline() && this.isOutlineFilledChicklet()) continue block7;
                            entries[i2].setSwatchOutlineOn(false);
                            continue block7;
                        }
                        if (patternAttr != null && this.attrType == 8) {
                            entries[i2].setColor(null);
                            entries[i2].setFillPattern(patternAttr);
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            int w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            continue block7;
                        }
                        if (lineAttr == null || this.attrType != 10 && this.attrType != 4 && this.attrType != 5 && this.attrType != 6) continue block7;
                        lineAttr = (LineAttrs)this.completeAttrProperties((ColorAttr)lineAttr);
                        LineAttrs theAttrs = (LineAttrs)this.defaultAttrs;
                        Color c = theAttrs.getColor();
                        int p = theAttrs.getLinePattern();
                        int w = theAttrs.getWidth();
                        if (this.scaleSymbolWithFont || this.attrType == 5) {
                            ms = 3 * fm.getHeight() / 5;
                            w = StatGraph.getMarkerEdgeWidth(ms, 0);
                            len = Math.max(Entry.LEGEND_LINE_LENGTH, 3 * ms);
                            entries[i2].setLineLengthMultiplier((double)len / (double)Entry.LEGEND_LINE_LENGTH);
                        }
                        if (this.attrType == 4) {
                            entries[i2].setSwatchType(1);
                            c = lineAttr.getColor();
                            entries[i2].setColor(c);
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            if (items[i2].isFillOutline() && this.isOutlineFilledChicklet()) continue block7;
                            entries[i2].setSwatchOutlineOn(false);
                            continue block7;
                        }
                        if (this.attrType == 5) {
                            p = lineAttr.getLinePattern();
                            Color lColor = this.getLabelColor(items[i2]);
                            if (lColor != null) {
                                c = lColor;
                            }
                        } else if (this.attrType == 6) {
                            w = lineAttr.getWidth();
                        } else {
                            c = lineAttr.getColor();
                            p = lineAttr.getLinePattern();
                            if (!this.scaleSymbolWithFont) {
                                w = lineAttr.getWidth();
                            }
                        }
                        entries[i2].setForeground(c);
                        entries[i2].setLine(StatGraph.getStroke(p, w).getDashArray(), w);
                        continue block7;
                    }
                    case 2: {
                        int len;
                        int ms;
                        entries[i2].setItemLineLength(this.itemLineLength);
                        LineAttrs lineAttr = (LineAttrs)items[i2].getSymbolAttrs();
                        lineAttr = (LineAttrs)this.completeAttrProperties((ColorAttr)lineAttr);
                        if (this.attrType == 0 || this.attrType == 10) {
                            int w = lineAttr.getWidth();
                            if (this.scaleSymbolWithFont) {
                                int ms2 = 3 * fm.getHeight() / 5;
                                w = StatGraph.getMarkerEdgeWidth(ms2, 0);
                                int len2 = Math.max(Entry.LEGEND_LINE_LENGTH, 3 * ms2);
                                entries[i2].setLineLengthMultiplier((double)len2 / (double)Entry.LEGEND_LINE_LENGTH);
                            }
                            entries[i2].setForeground(lineAttr.getColor());
                            entries[i2].setLine(StatGraph.getStroke(lineAttr.getLinePattern(), w).getDashArray(), w);
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setSkinnedLine(items[i2].isSkinnedLine());
                            continue block7;
                        }
                        LineAttrs theAttrs = (LineAttrs)this.defaultAttrs;
                        Color c = theAttrs.getColor();
                        int p = theAttrs.getLinePattern();
                        int w = theAttrs.getWidth();
                        if (this.scaleSymbolWithFont || this.attrType == 5) {
                            ms = 3 * fm.getHeight() / 5;
                            w = StatGraph.getMarkerEdgeWidth(ms, 0);
                            len = Math.max(Entry.LEGEND_LINE_LENGTH, 3 * ms);
                            entries[i2].setLineLengthMultiplier((double)len / (double)Entry.LEGEND_LINE_LENGTH);
                        }
                        if (this.attrType == 4) {
                            c = lineAttr.getColor();
                            entries[i2].setColor(c);
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            if (this.isOutlineFilledChicklet()) continue block7;
                            entries[i2].setSwatchOutlineOn(false);
                            continue block7;
                        }
                        if (this.attrType == 5) {
                            p = lineAttr.getLinePattern();
                            Color lColor = this.getLabelColor(items[i2]);
                            if (lColor != null) {
                                c = lColor;
                            }
                            entries[i2].setForeground(c);
                            entries[i2].setLine(StatGraph.getStroke(p, w).getDashArray(), w);
                            continue block7;
                        }
                        if (this.attrType != 6) continue block7;
                        w = lineAttr.getWidth();
                        entries[i2].setForeground(c);
                        entries[i2].setLine(StatGraph.getStroke(p, w).getDashArray(), w);
                        continue block7;
                    }
                    case 1: {
                        MarkerAttrs markerAttr = (MarkerAttrs)items[i2].getSymbolAttrs();
                        markerAttr = (MarkerAttrs)this.completeAttrProperties((ColorAttr)markerAttr);
                        LineAttrs markerOutlineAttrs = items[i2].getMarkerOutlineAttrs();
                        if (this.attrType == 0 || this.attrType == 9) {
                            int w = this.scaleSymbolWithFont ? 3 * fm.getHeight() / 5 : markerAttr.getSize();
                            entries[i2].setForeground(markerAttr.getColor());
                            entries[i2].setMarker(markerAttr.getShape());
                            entries[i2].setMarkerOutline(markerOutlineAttrs);
                            entries[i2].setMarkerWidth(w);
                            entries[i2].setMarkerWeight(markerAttr.getWeight());
                            entries[i2].setSkinImage(items[i2].getSkinImage());
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setPixelBenderImages(items[i2].getPixelBenderImages());
                            continue block7;
                        }
                        MarkerAttrs theAttrs = (MarkerAttrs)this.defaultAttrs;
                        int w = this.scaleSymbolWithFont ? 3 * fm.getHeight() / 5 : theAttrs.getSize();
                        entries[i2].setForeground(theAttrs.getColor());
                        entries[i2].setMarker(theAttrs.getShape());
                        entries[i2].setMarkerWidth(w);
                        entries[i2].setMarkerWeight(theAttrs.getWeight());
                        if (this.attrType == 3) {
                            entries[i2].setMarker(-1);
                            entries[i2].setColor(markerAttr.getColor());
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            w = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, w).getDashArray(), w);
                            if (this.isOutlineFilledChicklet()) continue block7;
                            entries[i2].setSwatchOutlineOn(false);
                            continue block7;
                        }
                        if (this.attrType == 2) {
                            entries[i2].setMarkerWidth(markerAttr.getSize());
                            continue block7;
                        }
                        if (this.attrType != 1) continue block7;
                        Color lColor = this.getLabelColor(items[i2]);
                        if (lColor != null) {
                            entries[i2].setForeground(lColor);
                        }
                        entries[i2].setMarker(markerAttr.getShape());
                        entries[i2].setMarkerWidth(3 * fm.getHeight() / 5);
                        continue block7;
                    }
                    case 4: {
                        entries[i2].setItemLineLength(this.itemLineLength);
                        MarkerAttrs markerAttr = (MarkerAttrs)items[i2].getSymbolAttrs();
                        int ms = this.scaleSymbolWithFont ? 3 * fm.getHeight() / 5 : markerAttr.getSize();
                        LineAttrs lineAttr = (LineAttrs)items[i2].getSecondarySymbolAttrs();
                        int lw = this.scaleSymbolWithFont ? StatGraph.getMarkerEdgeWidth(ms, 0) : lineAttr.getWidth();
                        double multi = 1.0;
                        if (this.scaleSymbolWithFont) {
                            int len = Math.max(Entry.LEGEND_LINE_LENGTH, 3 * ms);
                            multi = (double)len / (double)Entry.LEGEND_LINE_LENGTH;
                        }
                        LineAttrs markerOutlineAttrs = items[i2].getMarkerOutlineAttrs();
                        if (this.attrType == 0) {
                            entries[i2].setForeground(markerAttr.getColor());
                            entries[i2].setMarker(markerAttr.getShape());
                            entries[i2].setMarkerOutline(markerOutlineAttrs);
                            entries[i2].setMarkerWidth(ms);
                            entries[i2].setMarkerWeight(markerAttr.getWeight());
                            entries[i2].setLineColor(lineAttr.getColor());
                            entries[i2].setLine(StatGraph.getStroke(lineAttr.getLinePattern(), lw).getDashArray(), lw);
                            entries[i2].setLineLengthMultiplier(multi);
                            entries[i2].setSkinImage(items[i2].getSkinImage());
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setPixelBenderImages(items[i2].getPixelBenderImages());
                            entries[i2].setSkinnedLine(items[i2].isSkinnedLine());
                            continue block7;
                        }
                        if (this.attrType == 9) {
                            markerAttr = (MarkerAttrs)this.completeAttrProperties((ColorAttr)markerAttr);
                            entries[i2].setForeground(markerAttr.getColor());
                            entries[i2].setMarker(markerAttr.getShape());
                            entries[i2].setMarkerOutline(markerOutlineAttrs);
                            entries[i2].setMarkerWidth(ms);
                            entries[i2].setMarkerWeight(markerAttr.getWeight());
                            entries[i2].setSkinImage(items[i2].getSkinImage());
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setPixelBenderImages(items[i2].getPixelBenderImages());
                            continue block7;
                        }
                        if (this.attrType == 10) {
                            lineAttr = (LineAttrs)this.completeAttrProperties((ColorAttr)lineAttr);
                            entries[i2].setLineColor(lineAttr.getColor());
                            entries[i2].setLine(StatGraph.getStroke(lineAttr.getLinePattern(), lw).getDashArray(), lw);
                            entries[i2].setLineLengthMultiplier(multi);
                            entries[i2].setSkinType(items[i2].getSkinType());
                            entries[i2].setSkinnedLine(items[i2].isSkinnedLine());
                            continue block7;
                        }
                        if (this.attrType == 3 || this.attrType == 1 || this.attrType == 2) {
                            markerAttr = (MarkerAttrs)this.completeAttrProperties((ColorAttr)markerAttr);
                            MarkerAttrs theAttrs = (MarkerAttrs)this.defaultAttrs;
                            ms = this.scaleSymbolWithFont ? 3 * fm.getHeight() / 5 : theAttrs.getSize();
                            entries[i2].setForeground(theAttrs.getColor());
                            entries[i2].setMarker(theAttrs.getShape());
                            entries[i2].setMarkerWidth(ms);
                            entries[i2].setMarkerWeight(theAttrs.getWeight());
                            if (this.attrType == 3) {
                                entries[i2].setMarker(-1);
                                entries[i2].setColor(markerAttr.getColor());
                                entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                                lw = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                                entries[i2].setLine(StatGraph.getStroke(1, lw).getDashArray(), lw);
                                if (this.isOutlineFilledChicklet()) continue block7;
                                entries[i2].setSwatchOutlineOn(false);
                                continue block7;
                            }
                            if (this.attrType == 2) {
                                entries[i2].setMarkerWidth(markerAttr.getSize());
                                continue block7;
                            }
                            if (this.attrType != 1) continue block7;
                            Color lColor = this.getLabelColor(items[i2]);
                            if (lColor != null) {
                                entries[i2].setForeground(lColor);
                            }
                            entries[i2].setMarker(markerAttr.getShape());
                            entries[i2].setMarkerWidth(3 * fm.getHeight() / 5);
                            continue block7;
                        }
                        if (this.attrType != 4 && this.attrType != 5 && this.attrType != 6) continue block7;
                        lineAttr = (LineAttrs)this.completeAttrProperties((ColorAttr)lineAttr);
                        LineAttrs theAttrs = (LineAttrs)this.defaultAttrs;
                        lw = theAttrs.getWidth();
                        Color c = theAttrs.getColor();
                        int p = theAttrs.getLinePattern();
                        if (this.scaleSymbolWithFont || this.attrType == 5) {
                            ms = 3 * fm.getHeight() / 5;
                            lw = StatGraph.getMarkerEdgeWidth(ms, 0);
                            int len = Math.max(Entry.LEGEND_LINE_LENGTH, 3 * ms);
                            entries[i2].setLineLengthMultiplier((double)len / (double)Entry.LEGEND_LINE_LENGTH);
                        }
                        if (this.attrType == 4) {
                            c = lineAttr.getColor();
                            entries[i2].setColor(c);
                            entries[i2].setForeground(this.defaultOutlineAttrs.getColor());
                            lw = (int)(1.0 * StatGraph.dataDPIScaleFactor);
                            entries[i2].setLine(StatGraph.getStroke(1, lw).getDashArray(), lw);
                            if (this.isOutlineFilledChicklet()) continue block7;
                            entries[i2].setSwatchOutlineOn(false);
                            continue block7;
                        }
                        if (this.attrType == 5) {
                            p = lineAttr.getLinePattern();
                            Color lColor = this.getLabelColor(items[i2]);
                            if (lColor != null) {
                                c = lColor;
                            }
                            entries[i2].setForeground(c);
                            entries[i2].setLine(StatGraph.getStroke(p, lw).getDashArray(), lw);
                            entries[i2].setLineLengthMultiplier(multi);
                            continue block7;
                        }
                        if (this.attrType != 6) continue block7;
                        lw = lineAttr.getWidth();
                        entries[i2].setForeground(c);
                        entries[i2].setLine(StatGraph.getStroke(p, lw).getDashArray(), lw);
                        entries[i2].setLineLengthMultiplier(multi);
                        continue block7;
                    }
                    case 5: {
                        TextAttrs textAttr = (TextAttrs)items[i2].getSymbolAttrs();
                        if (items[i2].getSymbolDocument() != null) {
                            entries[i2].setRichText(items[i2].getSymbolDocument());
                        } else {
                            entries[i2].setText(items[i2].getSymbolText());
                        }
                        if (this.qcGlobalLegend && (entries[i2].getText() == null || entries[i2].getText().isEmpty())) {
                            entries[i2].setNoMargin(true);
                        }
                        entries[i2].setForeground(textAttr.getColor());
                        Font fn = textAttr.getFont();
                        if (this.scaleSymbolWithFont) {
                            entries[i2].setFont(new Font(fn.getFontName(), fn.getStyle(), this.getFont().getSize()));
                            continue block7;
                        }
                        entries[i2].setFont(fn);
                    }
                }
            }
        } else if (type == 2) {
            entries = new Entry[items.length];
            for (int i3 = 0; i3 < items.length; ++i3) {
                if (!items[i3].isValid(this.attrType)) continue;
                entries[i3] = new Entry();
                if (items[i3].getLabelDocument() != null) {
                    entries[i3].setRichText(items[i3].getLabelDocument());
                } else {
                    entries[i3].setText(items[i3].getLabel());
                }
                if (this.qcGlobalLegend && items[i3].getType() == 5 && (entries[i3].getText() == null || entries[i3].getText().isEmpty())) {
                    entries[i3].setNoMargin(true);
                }
                if (items[i3].getLabelAttrs() != null) {
                    if (items[i3].getUserLabelAttributes() == null || items[i3].getUserLabelAttributes().length() == 0) {
                        entries[i3].setForeground(items[i3].getLabelAttrs().getColor());
                        entries[i3].setFont(items[i3].getLabelAttrs().getFont());
                        continue;
                    }
                    String attrs = items[i3].getUserLabelAttributes();
                    if (attrs.contains("color")) {
                        entries[i3].setForeground(items[i3].getLabelAttrs().getColor());
                    } else {
                        entries[i3].setForeground(this.getForeground());
                    }
                    Font itemFont = items[i3].getLabelAttrs().getFont();
                    Font legendFont = this.getFont();
                    String family = attrs.contains("family") ? itemFont.getFamily() : legendFont.getFamily();
                    int size = attrs.contains("size") ? itemFont.getSize() : legendFont.getSize();
                    int style = attrs.contains("style") ? itemFont.getStyle() : legendFont.getStyle();
                    entries[i3].setFont(new Font(family, style, size));
                    continue;
                }
                entries[i3].setForeground(this.getForeground());
                entries[i3].setFont(this.getFont());
            }
        }
        for (i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            entries[i].setAlignmentX(this.getAlignmentX());
            entries[i].setAlignmentY(this.getAlignmentY());
            entries[i].setTextAntiAliased(this.isTextAntiAliased());
            entries[i].setDataAntiAliased(this.isDataAntiAliased());
            if (!entries[i].isNoMargin()) {
                entries[i].setBorder(EntryStub.cloneBorder(this));
            }
            if (this.isComponentOpaque()) {
                entries[i].setBackground(this.getBackground());
            }
            entries[i].setTheta(this.getTheta());
            entries[i].setWrapWidth(this.getWrapWidth());
            entries[i].setWrap(this.isWrap());
            entries[i].setShortText(this.getShortText());
            entries[i].setUserWidth(this.getUserWidth());
            entries[i].setUserHeight(this.getUserHeight());
            entries[i].setGraphID(graphID);
        }
        for (i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            entries[i].setSubpixelRendering(this.subpixelRendering);
        }
        return entries;
    }

    private Color getLabelColor(LegendItem item) {
        String attrs;
        Color c = null;
        c = item.getLabelAttrs() != null ? (item.getUserLabelAttributes() == null || item.getUserLabelAttributes().length() == 0 ? item.getLabelAttrs().getColor() : ((attrs = item.getUserLabelAttributes()).contains("color") ? item.getLabelAttrs().getColor() : this.getForeground())) : this.getForeground();
        return c;
    }

    public static Border cloneBorder(JComponent comp) {
        AbstractBorder clone = null;
        Border border = comp.getBorder();
        if (border instanceof MatteBorder) {
            Insets in = border.getBorderInsets(comp);
            clone = BorderFactory.createMatteBorder(in.top, in.left, in.bottom, in.right, comp.getBackground());
        } else if (border instanceof EmptyBorder) {
            Insets in = border.getBorderInsets(comp);
            clone = new EmptyBorder(in.top, in.left, in.bottom, in.right);
        } else if (border instanceof CompoundBorder) {
            StyledLineBorder outside = (StyledLineBorder)((CompoundBorder)border).getOutsideBorder();
            StyledLineBorder outsideClone = new StyledLineBorder(outside.getLineStyle());
            Border inside = ((CompoundBorder)border).getInsideBorder();
            Insets in = ((EmptyBorder)inside).getBorderInsets();
            Border insideClone = BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right);
            if (inside instanceof MatteBorder) {
                insideClone = BorderFactory.createMatteBorder(in.top, in.left, in.bottom, in.right, comp.getBackground());
            }
            clone = BorderFactory.createCompoundBorder(outsideClone, insideClone);
        }
        return clone;
    }

    public boolean isScaleSymbolWithFont() {
        return this.scaleSymbolWithFont;
    }

    public void setScaleSymbolWithFont(boolean scaleSymbolWithFont) {
        this.scaleSymbolWithFont = scaleSymbolWithFont;
    }

    void setGraphType(int type) {
        this.graphType = type;
    }

    public boolean isOutlineFilledChicklet() {
        return this.outlineFilledChicklet;
    }

    public void setOutlineFilledChicklet(boolean outlineFilledChicklet) {
        this.outlineFilledChicklet = outlineFilledChicklet;
    }

    public boolean isQCGlobalLegend() {
        return this.qcGlobalLegend;
    }

    public void setQCGlobalLegend(boolean qcLegend) {
        this.qcGlobalLegend = qcLegend;
    }

    public int getItemLineLength() {
        return this.itemLineLength;
    }

    public void setItemLineLength(int itemLineLength) {
        this.itemLineLength = itemLineLength;
    }

    public double getCustomHeightScale() {
        return this.customHeightScale;
    }

    public void setCustomHeightScale(double customHeightScale) {
        this.customHeightScale = customHeightScale;
    }

    public double getCustomChickletAspect() {
        return this.customChickletAspect;
    }

    public void setCustomChickletAspect(double customChickletAspect) {
        this.customChickletAspect = customChickletAspect;
    }

    public boolean isCustomHeightScale() {
        return this.customHeightScale == this.customHeightScale;
    }

    public boolean isCustomChickletAspect() {
        return this.customChickletAspect == this.customChickletAspect;
    }

    public double getCustomChickletHeight() {
        return this.customChickletHeight;
    }

    public void setCustomChickletHeight(double customChickletHeight) {
        this.customChickletHeight = customChickletHeight;
    }

    public boolean isCustomChickletHeight() {
        return this.customChickletHeight == this.customChickletHeight;
    }
}

