/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.encoder;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.util.gtk.ContinuousRangeToLogarithmicMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousTimeToNumericMap;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class PositionEncoder
extends Encoder {
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final int TIME = 2;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    protected double outputMax = 1.0;
    protected double outputMin = 0.0;
    protected double lowerLimit = 0.0;
    protected double upperLimit = 1.0;
    protected int type = 0;
    protected int order = 0;
    protected boolean reversed = false;
    private DataRange reversedInput = null;
    private Comparator myComparator;
    private int mpc = 0;
    private double startOffset = 0.0;
    private double strideOffset = 0.0;

    public void setStartOffset(double d) {
        this.startOffset = d;
    }

    public double getStartOffset() {
        return this.startOffset;
    }

    public void setStrideOffset(double d) {
        this.strideOffset = d;
    }

    public double getStrideOffset() {
        return this.strideOffset;
    }

    public PositionEncoder() {
    }

    public PositionEncoder(DataRange range) {
        super(range);
        this.myComparator = new Sort.StringComparator(1, Locale.getDefault(), StatGraph.collation);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PositionEncoder)) {
            return false;
        }
        PositionEncoder pe = (PositionEncoder)o;
        if (!this.compare(pe)) {
            return false;
        }
        if (this.outputMin != pe.outputMin) {
            return false;
        }
        return this.outputMax == pe.outputMax;
    }

    @Override
    public DataRange getInput() {
        if (this.order == 0 && this.reversed && this.input instanceof DiscreteRange) {
            return this.reversedInput;
        }
        return this.input;
    }

    @Override
    protected void updateValueMap() {
        if (this.input == null) {
            this.outputMap = null;
            return;
        }
        if (this.outputMin == this.outputMax) {
            if (this.outputMin != 0.0) {
                this.outputMin -= 1.0E-8 * Math.abs(this.outputMin);
                this.outputMax += 1.0E-8 * Math.abs(this.outputMax);
            } else {
                this.outputMin = -1.0E-8;
                this.outputMax = 1.0E-8;
            }
        }
        if (this.input instanceof ContinuousRange) {
            ContinuousRangeToLogarithmicMap map;
            ContinuousRange cr = (ContinuousRange)this.input;
            SASFormat fmt = cr.getFormat();
            if (this.type == 1) {
                if (this.outputMap instanceof ContinuousRangeToLogarithmicMap) {
                    this.outputMap.setOwner(null);
                    map = (ContinuousRangeToLogarithmicMap)this.outputMap;
                } else {
                    map = new ContinuousRangeToLogarithmicMap();
                }
            } else if (this.type == 2 && fmt != null && fmt instanceof SASDateTimeFormat) {
                if (this.outputMap instanceof ContinuousTimeToNumericMap) {
                    this.outputMap.setOwner(null);
                    map = (ContinuousTimeToNumericMap)this.outputMap;
                } else {
                    map = new ContinuousTimeToNumericMap();
                }
            } else if (this.outputMap instanceof ContinuousRangeToNumericMap && !(this.outputMap instanceof ContinuousTimeToNumericMap)) {
                this.outputMap.setOwner(null);
                map = (ContinuousRangeToNumericMap)this.outputMap;
            } else {
                map = new ContinuousRangeToNumericMap();
            }
            if (this.reversed) {
                map.setInputMin(cr.getMax());
                map.setInputMax(cr.getMin());
            } else {
                map.setInputMin(cr.getMin());
                map.setInputMax(cr.getMax());
            }
            map.setOutputMin(this.outputMin);
            map.setOutputMax(this.outputMax);
            this.outputMap = map;
        } else if (this.input instanceof BinnedRange) {
            ContinuousRangeToNumericMap map;
            BinnedRange sbr = (BinnedRange)this.input;
            if (this.outputMap instanceof ContinuousRangeToNumericMap) {
                this.outputMap.setOwner(null);
                map = (ContinuousRangeToNumericMap)this.outputMap;
            } else {
                map = new ContinuousRangeToNumericMap();
            }
            if (this.reversed) {
                map.setInputMin(((ContinuousRange)sbr.getDual()).getMax());
                map.setInputMax(((ContinuousRange)sbr.getDual()).getMin());
            } else {
                map.setInputMin(((ContinuousRange)sbr.getDual()).getMin());
                map.setInputMax(((ContinuousRange)sbr.getDual()).getMax());
            }
            map.setOutputMin(this.outputMin);
            map.setOutputMax(this.outputMax);
            this.outputMap = map;
        } else if (this.input instanceof DiscreteRange) {
            StringToNumericMap map;
            DiscreteRange dr = (DiscreteRange)this.input;
            if (this.outputMap instanceof StringToNumericMap) {
                map = (StringToNumericMap)this.outputMap;
            } else {
                map = new StringToNumericMap();
                map.setTrimTrailing(true);
            }
            Enumeration e = this.order != 0 ? this.getSortedValues(dr, this.order) : (this.reversed ? this.getReversedValues(dr) : dr.getEnumeration());
            ArrayList<String> stripped = new ArrayList<String>();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                String str = obj instanceof String ? StringToNumericMap.trimTrailing((String)((String)obj)) : obj.toString();
                if (stripped.contains(str)) continue;
                stripped.add(str);
            }
            String[] vec = new String[stripped.size()];
            for (int i = 0; i < vec.length; ++i) {
                vec[i] = (String)stripped.get(i);
            }
            int n = vec.length;
            StringVectorVariable sv = new StringVectorVariable();
            sv.connectFrom(vec);
            sv.setBlankMissing(false);
            map.removeAllStringPipes();
            map.addStringPipe(sv.value);
            if (n >= 2) {
                map.setStartValue(this.outputMin + this.startOffset);
                map.setStrideValue((this.outputMax - this.outputMin) / (double)(n - 1) + this.strideOffset);
            } else {
                map.setStartValue((this.outputMin + this.outputMax) / 2.0 + this.startOffset);
                map.setStrideValue(this.outputMax - this.outputMin + this.strideOffset);
            }
            this.outputMap = map;
        } else {
            this.outputMap = null;
        }
    }

    public double getOutputMax() {
        return this.outputMax;
    }

    public void setOutputMax(double aOutputMax) {
        this.outputMax = aOutputMax;
        this.updateValueMap();
    }

    public double getOutputMin() {
        return this.outputMin;
    }

    public void setOutputMin(double aOutputMin) {
        this.outputMin = aOutputMin;
        this.updateValueMap();
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double limit) {
        this.lowerLimit = limit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double limit) {
        this.upperLimit = limit;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int anOrder) {
        this.order = anOrder;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean b) {
        this.reversed = b;
    }

    private Enumeration getSortedValues(DiscreteRange dr, int order) {
        int i;
        Vector ve;
        int i2;
        Vector v;
        if (dr instanceof OrdinalRange && !((OrdinalRange)dr).isChangedToDiscrete()) {
            ((OrdinalRange)dr).sortValues();
            v = (Vector)dr.getValues().clone();
        } else {
            v = dr.getValues();
        }
        int leading = dr.getLeadingBlankCount();
        int ending = dr.getMPCBlankCount() + dr.getEndingBlankCount();
        for (i2 = 0; i2 < leading && v.size() > 0; ++i2) {
            v.remove(0);
        }
        for (i2 = 0; i2 < ending && v.size() > 0; ++i2) {
            v.remove(v.size() - 1);
        }
        Vector vs = dr.getValuesAtStart();
        if (vs != null && vs.size() > 0) {
            for (int i3 = 0; i3 < vs.size(); ++i3) {
                v.remove(vs.elementAt(i3));
            }
        }
        if ((ve = dr.getValuesAtEnd()) != null && ve.size() > 0) {
            for (i = 0; i < ve.size(); ++i) {
                v.remove(ve.elementAt(i));
            }
        }
        if (!(dr instanceof OrdinalRange) || dr instanceof OrdinalRange && ((OrdinalRange)dr).isChangedToDiscrete()) {
            Collections.sort(v, this.myComparator);
        }
        if (this.reversed && order == 1 || !this.reversed && order == 2) {
            Object[] av = v.toArray();
            v.removeAllElements();
            for (int i4 = av.length - 1; i4 >= 0; --i4) {
                v.add(av[i4]);
            }
        }
        for (i = 0; i < leading; ++i) {
            v.insertElementAt("", 0);
        }
        for (i = 0; i < ending; ++i) {
            v.addElement("");
        }
        if (vs != null && vs.size() > 0) {
            for (i = 0; i < vs.size(); ++i) {
                v.insertElementAt(vs.elementAt(i), i);
            }
        }
        if (ve != null && ve.size() > 0) {
            for (i = 0; i < ve.size(); ++i) {
                v.addElement(ve.elementAt(i));
            }
        }
        return v.elements();
    }

    private Enumeration getReversedValues(DiscreteRange dr) {
        int i;
        int i2;
        Vector v = (Vector)dr.getValues().clone();
        int leading = dr.getLeadingBlankCount();
        int ending = dr.getMPCBlankCount() + dr.getEndingBlankCount();
        for (i2 = 0; i2 < leading && v.size() > 0; ++i2) {
            v.remove(0);
        }
        for (i2 = 0; i2 < ending && v.size() > 0; ++i2) {
            v.remove(v.size() - 1);
        }
        Object[] av = v.toArray();
        v.removeAllElements();
        for (i = av.length - 1; i >= 0; --i) {
            v.add(av[i]);
        }
        for (i = 0; i < leading; ++i) {
            v.insertElementAt("", 0);
        }
        for (i = 0; i < ending; ++i) {
            v.addElement("");
        }
        if (dr instanceof StubRange) {
            this.reversedInput = dr;
        } else {
            if (this.reversedInput == null) {
                this.reversedInput = new DiscreteRange((DataRange)dr);
            }
            ((DiscreteRange)this.reversedInput).setValues(v);
        }
        return v.elements();
    }

    public int getMPC() {
        return this.mpc;
    }

    public void setMPC(int mpc) {
        this.mpc = mpc;
    }
}

