/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.encoder;

import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import java.util.HashMap;
import java.util.Iterator;

public class LineEncoder
extends Encoder {
    private ColorMap colorMap = null;
    private NumericMap widthMap = null;
    private NumericMap SPMap = null;
    private NumericMap SFMap = null;
    public HashMap styleList;
    public LineAttrs[] styleArray;

    public LineEncoder(DiscreteRange range, HashMap styleList) {
        this.input = range;
        this.styleList = styleList;
        this.updateValueMap();
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public NumericMap getWidthMap() {
        return this.widthMap;
    }

    public NumericMap getSPMap() {
        return this.SPMap;
    }

    public NumericMap getSFMap() {
        return this.SFMap;
    }

    public HashMap getLineAttrsMap() {
        return this.styleList;
    }

    @Override
    public DataRange getInput() {
        return this.input;
    }

    @Override
    protected void updateValueMap() {
        this.colorMap = null;
        this.widthMap = null;
        this.SPMap = null;
        this.SFMap = null;
        if (this.input instanceof DiscreteRange) {
            StringToColorMap cMap = new StringToColorMap();
            StringToNumberMap wMap = new StringToNumberMap();
            StringToNumberMap spMap = new StringToNumberMap();
            StringToNumberMap sfMap = new StringToNumberMap();
            Iterator eKeys = this.styleList.keySet().iterator();
            String[] vec = new String[this.styleList.keySet().size()];
            int cnt = 0;
            while (eKeys.hasNext()) {
                Object keyObject = eKeys.next();
                LineAttrs style = (LineAttrs)this.styleList.get(keyObject);
                if (style == null) continue;
                cMap.add((String)keyObject, style.getColor());
                wMap.add((String)keyObject, (Number)new Integer(style.getWidth()));
                int SP = style.getStipplePattern();
                int SF = style.getStippleFactor();
                spMap.add((String)keyObject, (Number)new Integer(SP));
                sfMap.add((String)keyObject, (Number)new Integer(SF));
                vec[cnt++] = (String)keyObject;
            }
            StringVectorVariable sv = new StringVectorVariable();
            sv.setBlankMissing(false);
            sv.connectFrom(vec);
            cMap.addStringPipe(sv.value);
            wMap.addStringPipe(sv.value);
            spMap.addStringPipe(sv.value);
            sfMap.addStringPipe(sv.value);
            this.colorMap = cMap;
            this.widthMap = wMap;
            this.SPMap = spMap;
            this.SFMap = sfMap;
        }
    }
}

