/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.encoder;

import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

public class ColorEncoder
extends Encoder {
    public Color startColor;
    public Color mediumColor;
    public Color endColor;
    public Color[] rampColors;
    public HashMap colorList;
    public Color[] colorArray = null;

    public ColorEncoder(ContinuousRange range, Color startColor, Color mediumColor, Color endColor) {
        this.input = range;
        this.startColor = startColor;
        this.mediumColor = mediumColor;
        this.endColor = endColor;
        this.rampColors = new Color[]{startColor, mediumColor, endColor};
        this.updateValueMap();
    }

    public ColorEncoder(ContinuousRange range, Color[] colors) {
        this.input = range;
        this.rampColors = colors;
        this.startColor = this.rampColors[0];
        this.mediumColor = this.rampColors[(int)((double)(this.rampColors.length - 1) * 0.5)];
        this.endColor = this.rampColors[this.rampColors.length - 1];
        this.updateValueMap();
    }

    public ColorEncoder(BinnedRange range, HashMap colorList) {
        this.input = range;
        this.colorList = colorList;
        this.updateValueMap();
    }

    public ColorEncoder(DiscreteRange range, HashMap colorList) {
        this.input = range;
        this.colorList = colorList;
        this.updateValueMap();
    }

    @Override
    public DataRange getInput() {
        return this.input;
    }

    @Override
    protected void updateValueMap() {
        if (this.input == null) {
            this.outputMap = null;
            return;
        }
        if (this.input instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)this.input;
            ContinuousRangeToColorMap map = new ContinuousRangeToColorMap();
            int count = this.rampColors.length;
            double intv = (cr.getMax() - cr.getMin()) / (double)(count - 1);
            double[] d = new double[count];
            for (int i = 0; i < count - 1; ++i) {
                d[i] = cr.getMin() + (double)i * intv;
            }
            d[count - 1] = cr.getMax();
            map.setColorSpectrumValues(d);
            map.setColorSpectrumColors(this.rampColors);
            this.outputMap = map;
        } else if (this.input instanceof DiscreteRange) {
            StringToColorMap map = new StringToColorMap();
            Iterator eKeys = this.colorList.keySet().iterator();
            String[] vec = new String[this.colorList.keySet().size()];
            int cnt = 0;
            while (eKeys.hasNext()) {
                Object obj = eKeys.next();
                Color col = (Color)this.colorList.get(obj);
                if (!(obj instanceof String) || col == null) continue;
                map.add((String)obj, col);
                vec[cnt++] = (String)obj;
            }
            StringVectorVariable sv = new StringVectorVariable();
            sv.setBlankMissing(false);
            sv.connectFrom(vec);
            map.addStringPipe(sv.value);
            this.outputMap = map;
        } else {
            this.outputMap = null;
        }
    }

    public HashMap getColorList() {
        return this.colorList;
    }
}

