/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.image.DilationFilter;
import com.sas.graphics.image.GaussianFilter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextObject {
    static final Stroke textBorder = new BasicStroke(2.0f, 2, 2, 1.0f, new float[]{8.0f, 4.0f}, 0.0f);
    public static AttributedCharacterIterator.Attribute[] attributes = new AttributedCharacterIterator.Attribute[]{TextAttribute.FOREGROUND, TextAttribute.FONT, TextAttribute.FAMILY, TextAttribute.SIZE, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SUPERSCRIPT};
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int BASELINE = 3;
    public static final String[] HALIGN = new String[]{"CENTER", "LEFT", "RIGHT"};
    public static final String[] VALIGN = new String[]{"CENTER", "TOP", "BOTTOM", "BASELINE"};
    public static final int LINE_BREAK_MODE_TAIL_TRUNCATE = 0;
    public static final int LINE_BREAK_MODE_WORD_WRAP = 1;
    protected int halign = 0;
    protected int valign = 0;
    protected LineBreakMeasurer lbm;
    protected AttributedString as;
    protected double wrappingWidth = 2.147483647E9;
    protected double width = 2.147483647E9;
    protected String tooltip;
    protected boolean clip = true;
    protected int index = -1;
    protected boolean antialias = true;
    protected boolean antialiasText = true;
    protected double transparency = 0.0;
    protected double dataDPIScaleFactor = 1.0;
    protected double linearScaleFactor = 1.0;
    protected int lineBreakMode = 0;
    protected Rectangle2D bounds = null;
    protected double fitConstraintWidth = 0.0;
    protected double fitConstraintHeight = 0.0;
    protected boolean fontReduced = false;
    protected String text = null;
    protected Font font = null;
    protected Color textColor = null;
    protected String delimiter = "\n";
    protected double textBacklight = 0.0;
    protected boolean background = false;
    protected Color backgroundColor;
    protected boolean border = false;
    protected Color borderColor;
    protected BasicStroke borderStroke = new BasicStroke();
    protected boolean fullyJustified = false;
    private Insets margins = new Insets(0, 0, 0, 0);
    private int minFontSize = 5;
    protected Point2D position;

    public static int toInt(double val) {
        return (int)(val + 0.5);
    }

    public int getMinimumFontSize() {
        return this.minFontSize;
    }

    public void setMinimumFontSize(int size) {
        this.minFontSize = size;
    }

    public void setFontReduced(boolean b) {
        this.fontReduced = b;
    }

    public boolean isFontReduced() {
        return this.fontReduced;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isClip() {
        return this.clip;
    }

    public void setClip(boolean clip) {
        this.clip = clip;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String label) {
        this.text = label;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public double getDataDPIScaleFactor() {
        return this.dataDPIScaleFactor;
    }

    public void setDataDPIScaleFactor(double dataDPIScaleFactor) {
        this.dataDPIScaleFactor = dataDPIScaleFactor;
    }

    public double getLinearSizeScaleFactor() {
        return this.linearScaleFactor;
    }

    public void setLinearScaleFactor(double dataDPIScaleFactor) {
        this.linearScaleFactor = dataDPIScaleFactor;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    public boolean isDataAntialias() {
        return this.antialias;
    }

    public boolean isTextAntialias() {
        return this.antialiasText;
    }

    public void setAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setDataAntialias(boolean antialias) {
        this.antialias = antialias;
    }

    public void setTextAntialias(boolean antialias) {
        this.antialiasText = antialias;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public double getPreferredHeight(FontRenderContext frc) {
        if (this.text == null || this.text.length() == 0) {
            return 0.0;
        }
        if (this.font == null) {
            return 0.0;
        }
        this.text = this.text.trim();
        this.as = new AttributedString(this.text);
        if (this.font != null) {
            this.as.addAttribute(TextAttribute.FONT, this.font);
        }
        if (frc == null) {
            frc = new FontRenderContext(null, this.antialiasText, false);
        }
        this.lbm = new LineBreakMeasurer(this.as.getIterator(), frc);
        this.lbm.setPosition(0);
        double textHeight = 0.0;
        if (this.lineBreakMode == 1) {
            TextLayout tl = this.lbm.nextLayout(TextObject.toInt(this.wrappingWidth));
            textHeight = tl.getAscent() + tl.getDescent();
            while (this.lbm.getPosition() < this.text.length()) {
                tl = this.lbm.nextLayout(TextObject.toInt(this.wrappingWidth));
                textHeight += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
            }
        } else {
            TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
            textHeight = tl.getAscent() + tl.getDescent();
        }
        return textHeight + (double)this.margins.top + (double)this.margins.bottom;
    }

    public double getPreferredWidth(FontRenderContext frc) {
        if (this.text == null || this.text.length() == 0) {
            return 0.0;
        }
        if (this.font == null) {
            return 0.0;
        }
        this.as = new AttributedString(this.text);
        this.as.addAttribute(TextAttribute.FONT, this.font);
        if (frc == null) {
            frc = new FontRenderContext(null, this.antialiasText, false);
        }
        this.lbm = new LineBreakMeasurer(this.as.getIterator(), frc);
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
        return tl.getVisibleAdvance() + (float)this.margins.left + (float)this.margins.right;
    }

    public double getLineHeight(FontRenderContext frc, Rectangle2D renderArea) {
        if (this.text == null || this.text.length() == 0) {
            return 0.0;
        }
        String adjString = this.text;
        this.as = new AttributedString(adjString);
        if (this.font != null) {
            this.as.addAttribute(TextAttribute.FONT, this.font);
        }
        if (frc == null) {
            frc = new FontRenderContext(null, this.antialiasText, false);
        }
        this.lbm = new LineBreakMeasurer(this.as.getIterator(), frc);
        this.lbm.setPosition(0);
        double areaWidth = renderArea.getWidth();
        TextLayout tl = this.lbm.nextLayout(TextObject.toInt(Double.MAX_VALUE));
        double height = tl.getAscent() + tl.getDescent();
        double twidth = tl.getVisibleAdvance();
        if (this.lineBreakMode == 1 && twidth > areaWidth) {
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(TextObject.toInt(areaWidth));
            height = tl.getAscent() + tl.getDescent();
            while (this.lbm.getPosition() < this.text.length()) {
                tl = this.lbm.nextLayout(TextObject.toInt(areaWidth));
                height += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
            }
        }
        return height + (double)this.margins.top + (double)this.margins.bottom;
    }

    public void render(Graphics2D gc, Rectangle renderArea) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        Font adjFont = gc.getFont();
        if (this.font != null) {
            adjFont = this.font;
        }
        String adjString = this.text;
        this.as = new AttributedString(adjString);
        this.as.addAttribute(TextAttribute.FONT, adjFont);
        this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        this.lbm.setPosition(0);
        TextLayout tl = this.lbm.nextLayout(TextObject.toInt(Double.MAX_VALUE));
        double height = tl.getAscent() + tl.getDescent();
        double twidth = tl.getVisibleAdvance();
        int numLines = 1;
        if (this.lineBreakMode == 0) {
            double truncateWidth;
            if (this.fitConstraintHeight > 0.0 && height > this.fitConstraintHeight) {
                if (this.fontReduced) {
                    int size;
                    for (size = adjFont.getSize() - 1; size >= this.minFontSize; --size) {
                        adjFont = new Font(adjFont.getFamily(), adjFont.getStyle(), size);
                        this.as.addAttribute(TextAttribute.FONT, adjFont);
                        this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
                        this.lbm.setPosition(0);
                        tl = this.lbm.nextLayout(TextObject.toInt(Double.MAX_VALUE));
                        height = tl.getAscent() + tl.getDescent();
                        if (height < this.fitConstraintHeight) break;
                    }
                    if (size < this.minFontSize) {
                        return;
                    }
                } else {
                    return;
                }
            }
            double d = truncateWidth = this.fitConstraintWidth > 0.0 ? this.fitConstraintWidth : this.width;
            if (twidth > truncateWidth) {
                adjString = this.text = this.truncateByWord(tl, this.font, gc.getFontRenderContext(), this.text, truncateWidth);
                this.as = new AttributedString(adjString);
                this.as.addAttribute(TextAttribute.FONT, adjFont);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
                this.lbm.setPosition(0);
                tl = this.lbm.nextLayout(2.1474836E9f);
                twidth = tl.getVisibleAdvance();
            }
            int len = this.text.length();
            while (twidth > truncateWidth && len >= 1) {
                if (--len < 1) {
                    return;
                }
                adjString = this.text.substring(0, len) + "...";
                this.as = new AttributedString(adjString);
                this.as.addAttribute(TextAttribute.FONT, adjFont);
                this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
                this.lbm.setPosition(0);
                tl = this.lbm.nextLayout(2.1474836E9f);
                twidth = tl.getVisibleAdvance();
            }
        } else if (this.lineBreakMode == 1 && twidth > this.wrappingWidth) {
            twidth = this.wrappingWidth;
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(TextObject.toInt(twidth));
            height = tl.getAscent() + tl.getDescent();
            while (this.lbm.getPosition() < this.text.length()) {
                ++numLines;
                tl = this.lbm.nextLayout(TextObject.toInt(twidth));
                height += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
            }
        }
        double xo = 0.0;
        double yo = 0.0;
        switch (this.valign) {
            case 1: {
                yo = this.position.getY();
                break;
            }
            case 2: {
                yo = this.position.getY() - height;
                break;
            }
            default: {
                yo = this.position.getY() - height / 2.0;
            }
        }
        switch (this.halign) {
            case 1: {
                xo = this.position.getX();
                break;
            }
            case 2: {
                xo = this.position.getX() - twidth;
                break;
            }
            default: {
                xo = this.position.getX() - twidth / 2.0;
            }
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        this.bounds = new Rectangle2D.Double(xo - (double)this.margins.left, yo - (double)this.margins.top, twidth + (double)this.margins.left + (double)this.margins.right, height + (double)this.margins.top + (double)this.margins.bottom);
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fillRect(TextObject.toInt(this.bounds.getX()), TextObject.toInt(this.bounds.getY()), TextObject.toInt(this.bounds.getWidth()), TextObject.toInt(this.bounds.getHeight()));
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.drawRect(TextObject.toInt(this.bounds.getX()), TextObject.toInt(this.bounds.getY()), TextObject.toInt(this.bounds.getWidth()), TextObject.toInt(this.bounds.getHeight()));
        }
        if (this.textBacklight != 0.0) {
            int radius = ScatterOverlay.getLabelOutlineWidth(adjFont.getSize());
            this.drawBackgroundText(gc, tl, adjFont, this.textColor, adjString, xo, yo, numLines, radius);
        }
        gc.setFont(adjFont);
        if (this.textColor != null) {
            gc.setColor(this.textColor);
        }
        if (adjString.equalsIgnoreCase(":")) {
            yo += (double)tl.getAscent();
        } else if (this.fullyJustified && adjString.indexOf(":") > 0 && twidth < this.fitConstraintWidth) {
            String labelPart = adjString.substring(0, adjString.indexOf(":")).trim();
            String valuePart = adjString.substring(adjString.indexOf(":") + 1).trim();
            gc.drawString(labelPart, TextObject.toInt(xo), TextObject.toInt(yo += (double)tl.getAscent()));
            AttributedString vas = new AttributedString(valuePart);
            vas.addAttribute(TextAttribute.FONT, adjFont);
            FontRenderContext frc = new FontRenderContext(null, this.antialiasText, false);
            LineBreakMeasurer vlbm = new LineBreakMeasurer(vas.getIterator(), frc);
            vlbm.setPosition(0);
            TextLayout vtl = vlbm.nextLayout(2.1474836E9f);
            vtl.draw(gc, (float)(xo + this.fitConstraintWidth - (double)vtl.getVisibleAdvance()), (float)yo);
        } else {
            if (this.fullyJustified && adjString.indexOf(":") > 0) {
                adjString = adjString.replaceAll(":", "");
            }
            if (numLines == 1) {
                gc.drawString(adjString, TextObject.toInt(xo), TextObject.toInt(yo += (double)tl.getAscent()));
            } else {
                this.lbm.setPosition(0);
                while (this.lbm.getPosition() < this.text.length()) {
                    tl = this.lbm.nextLayout(TextObject.toInt(this.wrappingWidth));
                    double dx = tl.isLeftToRight() ? 0.0 : this.wrappingWidth - (double)tl.getAdvance();
                    tl.draw(gc, TextObject.toInt(xo + dx), TextObject.toInt(yo += (double)tl.getAscent()));
                    yo += (double)(tl.getDescent() + tl.getLeading());
                }
            }
        }
    }

    public int getVAlign() {
        return this.valign;
    }

    public void setVAlign(int align) {
        this.valign = align;
    }

    public int getHAlign() {
        return this.halign;
    }

    public void setHAlign(int align) {
        this.halign = align;
    }

    public Shape[] getImageMapRegions() {
        return new Shape[]{this.bounds};
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D p) {
        this.position = p;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Stroke getBorderStroke() {
        return this.borderStroke;
    }

    public void setBorderStroke(BasicStroke borderStroke) {
        this.borderStroke = borderStroke;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public void updateTextProperties(TextObject from) {
        this.text = from.text;
        this.tooltip = from.tooltip;
        this.clip = from.clip;
        this.antialias = from.antialias;
        this.antialiasText = from.antialiasText;
        this.transparency = from.transparency;
        this.dataDPIScaleFactor = from.dataDPIScaleFactor;
        this.linearScaleFactor = from.linearScaleFactor;
        this.text = from.text;
        this.font = from.font;
        this.textColor = from.textColor;
    }

    public void setLineBreakMode(int mode) {
        this.lineBreakMode = mode;
    }

    public void setWidth(double w) {
        this.width = w;
    }

    public void setFitConstraint(double constraintX, double constraintY) {
        this.fitConstraintWidth = constraintX;
        this.fitConstraintHeight = constraintY;
    }

    public double getFitConstraintHeight() {
        return this.fitConstraintHeight;
    }

    public double getFitConstraintWidth() {
        return this.fitConstraintWidth;
    }

    public void setWrappingWidth(double w) {
        this.wrappingWidth = w;
    }

    public double getWrappingWidth() {
        return this.wrappingWidth;
    }

    public void setDelimiter(String s) {
        this.delimiter = s;
    }

    public void setTextBacklight(double d) {
        this.textBacklight = d;
    }

    public double getTextBacklight() {
        return this.textBacklight;
    }

    private String truncateByWord(TextLayout tl, Font font, FontRenderContext frc, String label, double truncateWidth) {
        StringTokenizer tokenizer = new StringTokenizer(label, this.delimiter);
        Vector<String> words = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            words.add(tokenizer.nextToken());
        }
        int n = words.size();
        String adjText = (String)words.get(0);
        for (int i = 1; i < n; ++i) {
            String newText = adjText + this.delimiter + (String)words.get(i);
            this.as = new AttributedString(newText);
            this.as.addAttribute(TextAttribute.FONT, font);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), frc);
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(2.1474836E9f);
            double twidth = tl.getVisibleAdvance();
            if (twidth > truncateWidth) break;
            adjText = newText;
        }
        return adjText;
    }

    private void drawBackgroundText(Graphics2D gc, TextLayout tl, Font f, Color color, String text, double xo, double yo, int numLines, int radius) {
        double h;
        double w;
        if (radius == 0) {
            return;
        }
        if (numLines <= 1) {
            w = tl.getVisibleAdvance();
            h = tl.getAscent() + tl.getDescent();
        } else {
            h = 0.0;
            w = 0.0;
            this.lbm.setPosition(0);
            while (this.lbm.getPosition() < text.length()) {
                tl = this.lbm.nextLayout(TextObject.toInt(this.wrappingWidth));
                h += (double)(tl.getDescent() + tl.getLeading());
                w = Math.max(w, (double)((int)tl.getVisibleAdvance()));
            }
        }
        int margin = radius + 1;
        int img_w = TextObject.toInt(w) + margin * 2;
        int img_h = TextObject.toInt(h) + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setFont(this.font);
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        float[] HSB = Color.RGBtoHSB(r, g, b, null);
        Color c = (double)HSB[2] > 0.5 ? Color.black : Color.white;
        double alpha = this.textBacklight;
        if (alpha < 0.0 || alpha > 1.0) {
            alpha = 0.5;
        }
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(alpha * 255.0));
        g2.setColor(c);
        AffineTransform AT = new AffineTransform();
        AT.translate(margin, margin);
        g2.setTransform(AT);
        g2.setFont(this.font);
        g2.setColor(c);
        if (numLines == 1) {
            g2.drawString(text, 0, TextObject.toInt(tl.getAscent()));
        } else {
            this.lbm.setPosition(0);
            double y = 0.0;
            while (this.lbm.getPosition() < text.length()) {
                tl = this.lbm.nextLayout(TextObject.toInt(this.wrappingWidth));
                double dx = tl.isLeftToRight() ? 0.0 : this.wrappingWidth - (double)tl.getAdvance();
                tl.draw(g2, TextObject.toInt(dx), TextObject.toInt(y += (double)tl.getAscent()));
                y += (double)(tl.getDescent() + tl.getLeading());
            }
        }
        DilationFilter filter = new DilationFilter(radius);
        filter.setForeground(c);
        src = filter.filter(src, null);
        radius = (int)(radius <= 3 ? 2.0 : 2.0 + Math.sqrt((double)radius - 3.0) + 0.5);
        GaussianFilter filter2 = new GaussianFilter((float)radius, (float)radius);
        src = filter2.filter(src, null);
        gc.drawImage((Image)src, -margin + TextObject.toInt(xo), -margin + TextObject.toInt(yo), null);
        g2.dispose();
    }

    public boolean isFullyJustified() {
        return this.fullyJustified;
    }

    public void setFullyJustified(boolean fullyJustified) {
        this.fullyJustified = fullyJustified;
    }
}

