/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.ItemManager;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.LinkItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeContent;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeLinkDiagramItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.Port;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.TextObject;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import java.util.Vector;

public class NodeItem
extends NodeLinkDiagramItem {
    public static final int NODE_SIZE = 150;
    public static final byte VERTICAL = 0;
    public static final byte HORIZONTAL = 1;
    public static final byte INSIDE = 0;
    public static final byte OUTSIDE = 1;
    public static final byte LABEL_NONE = -1;
    public static final byte LABEL_INSIDE = 0;
    public static final byte TITLE_INSIDE = 1;
    public static final byte LABEL_TOP = 2;
    public static final byte LABEL_BOTTOM = 3;
    public static final byte LABEL_OVERVIEW = 4;
    public static final byte OVERVIEW_LABEL_POSITION_TOP = 0;
    public static final byte OVERVIEW_LABEL_POSITION_BOTTOM = 1;
    public static final byte OVERVIEW_LABEL_POSITION_INSIDE = 2;
    public static final byte NODE_DETAILS_JUSTIFY_LEFT = 0;
    public static final byte NODE_DETAILS_JUSTIFY_FULL = 1;
    private double nodeContentOutlineThickness = 4.0;
    private Point2D origin = new Point2D.Double(0.0, 0.0);
    private Point2D originOffset = null;
    private Rectangle2D bounds = null;
    private NodeItem parentNode = null;
    private Port inputPort;
    private Port outputPort;
    private Vector<LinkItem> inputLinks = new Vector();
    private Vector<LinkItem> outputLinks = new Vector();
    private Vector<NodeItem> childNodes = new Vector();
    private int depth = -1;
    private Vector<TextObject> topLabels = new Vector();
    private TextObject bottomLabel = null;
    private TextObject title = null;
    private Vector<TextObject> insideLabels = new Vector();
    private Vector<TextObject> overviewLabels = new Vector();
    private int overviewLabelPosition = 2;
    private Vector<NodeContent> nodeContents = new Vector();
    private boolean nodeContentOutline = true;
    private Color nodeContentOutlineColor = new Color(224, 224, 224);
    private Color backgroundColor = new Color(224, 224, 224);
    private boolean background = true;
    private boolean border = true;
    private Color borderColor = new Color(224, 224, 224);
    private double borderThickness = 1.0;
    private int borderStyle = 0;
    private double borderFactorMultiplier = 1.0;
    private boolean autoConstrainInsideLabels = true;
    private boolean LODBackgroundVisible = false;
    private double LODThreshold = 0.38;
    private Vector<TextObject> defaultTextObjects = null;
    private int dataSkin = -1;
    private int orientation = 1;
    private double transparency = 0.0;
    public static final Point2D labelOffset = new Point2D.Double(10.0, 10.0);
    private int titlePad = 2;
    private boolean roomForTitle = true;
    private int numFittedInsideLabels = 0;
    private int numFittedInputLabels = 0;
    private boolean antialias = true;
    private boolean antialiasText = true;
    private double dataDPIScaleFactor = 1.0;
    private double linearScaleFactor = 1.0;
    private boolean modifiedFlag = true;
    private boolean pct100 = true;
    private Rectangle2D screenBounds;
    private int insideLabelLineSeparator = -1;

    public static int toInt(double val) {
        return (int)(val + 0.5);
    }

    public NodeItem(String id) {
        super(id);
        this.initializePorts(id);
    }

    public NodeItem(DecisionTreeRegion tree, int index, String id) {
        super(tree, index);
        this.id = id;
        this.initializePorts(id);
    }

    public static int getScaledNodeSize() {
        return (int)(150.0 * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor);
    }

    public static Point2D getScaledLabelOffset() {
        Point2D.Double scaled = new Point2D.Double(labelOffset.getX() * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor, labelOffset.getY() * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor);
        return scaled;
    }

    private void initializePorts(String id) {
        this.inputPort = new Port(true, this, id);
        this.outputPort = new Port(false, this, id);
    }

    public NodeItem getRootNode() {
        if (this.parentNode != null) {
            return this.parentNode.getRootNode();
        }
        return this;
    }

    public Vector<NodeItem> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(Vector<NodeItem> childNodes) {
        this.childNodes = childNodes;
    }

    public Port getInputPort() {
        return this.inputPort;
    }

    public void setInputPort(Port fromPort) {
        this.inputPort = fromPort;
    }

    public Port getOutputPort() {
        return this.outputPort;
    }

    public void setOutputPort(Port toPort) {
        this.outputPort = toPort;
    }

    public Vector<LinkItem> getInputLinks() {
        return this.inputLinks;
    }

    public void setInputLinks(Vector<LinkItem> inputLinks) {
        this.inputLinks = inputLinks;
    }

    public Vector<LinkItem> getOutputLinks() {
        return this.outputLinks;
    }

    public void setOutputLinks(Vector<LinkItem> outputLinks) {
        this.outputLinks = outputLinks;
    }

    public NodeItem getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeItem parentNode) {
        if (this.parentNode == parentNode) {
            return;
        }
        if (this.parentNode != null) {
            this.parentNode.removeChildNode(this);
        }
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.addChildNode(this);
        }
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    void addChildNode(NodeItem child) {
        if (child == null) {
            return;
        }
        int obsIndex = child.getObsIndex();
        int index = -1;
        for (int i = this.childNodes.size() - 1; i >= 0; --i) {
            if (this.childNodes.elementAt(i).getObsIndex() >= obsIndex) continue;
            index = i;
            break;
        }
        this.childNodes.add(index + 1, child);
    }

    void removeChildNode(NodeItem child) {
        this.childNodes.remove(child);
    }

    public void invalidateSize() {
        this.bounds = null;
        this.originOffset = null;
    }

    private void validateSizeAndOffset() {
        ItemManager itemManager;
        if ((this.bounds == null || this.originOffset == null) && (itemManager = this.decisionTree.getItemManager()) != null) {
            Rectangle2D rect = itemManager.calculateItemSizeAndOffset(this);
            this.originOffset = new Point2D.Double(rect.getX(), rect.getY());
            this.bounds = new Rectangle2D.Double(this.origin.getX() + this.originOffset.getX(), this.origin.getY() + this.originOffset.getY(), rect.getWidth(), rect.getHeight());
        }
    }

    public Point2D getOriginOffset() {
        this.validateSizeAndOffset();
        return this.originOffset;
    }

    @Override
    public Rectangle2D getBounds() {
        this.validateSizeAndOffset();
        return this.bounds;
    }

    @Override
    public Rectangle2D getBoundsAtOrigin(Point2D origin) {
        this.validateSizeAndOffset();
        return new Rectangle2D.Double(origin.getX() + this.originOffset.getX(), origin.getY() + this.originOffset.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public void move(double newX, double newY) {
        this.origin.setLocation(newX, newY);
        if (this.bounds != null) {
            this.bounds.setRect(this.origin.getX() + this.originOffset.getX(), this.origin.getY() + this.originOffset.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        }
    }

    public double getX() {
        return this.origin.getX();
    }

    public double getY() {
        return this.origin.getY();
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public double getWidth() {
        this.validateSizeAndOffset();
        return this.bounds.getWidth();
    }

    public double getHeight() {
        this.validateSizeAndOffset();
        return this.bounds.getHeight();
    }

    public Point2D getCenter() {
        this.validateSizeAndOffset();
        return new Point2D.Double(this.bounds.getX() + this.bounds.getWidth() / 2.0, this.bounds.getY() + this.bounds.getHeight() / 2.0);
    }

    public void setLODBackgroundVisible(boolean b) {
        this.LODBackgroundVisible = b;
    }

    public boolean isLODBackgroundVisible() {
        return this.LODBackgroundVisible;
    }

    public boolean isLeaf() {
        return this.childNodes.size() == 0;
    }

    @Override
    public void dispose() {
    }

    @Override
    Rectangle2D measure() {
        int ns = NodeItem.getScaledNodeSize();
        return new Rectangle2D.Double((double)(-ns) / 2.0, (double)(-ns) / 2.0, ns, ns);
    }

    public void initNode() {
        if (this.autoConstrainInsideLabels) {
            this.setLabelFitConstraints();
        }
        this.titlePad = (int)(2.0 * StatGraph.gapScaleFactor + 0.5);
        this.modifiedFlag = false;
    }

    TextObject getDefaultTextObject(int index) {
        if (this.defaultTextObjects != null && this.defaultTextObjects.size() < index) {
            return this.defaultTextObjects.elementAt(index);
        }
        return null;
    }

    public TextObject getLabelTextObject(int labelID, int lineNum) {
        switch (labelID) {
            case 0: {
                if (this.insideLabels != null && this.insideLabels.size() <= lineNum) {
                    TextObject pText = new TextObject();
                    TextObject pDefaultTextObject = this.getDefaultTextObject(0);
                    if (pDefaultTextObject != null) {
                        pText.updateTextProperties(pDefaultTextObject);
                    }
                    pText.antialias = this.antialias;
                    pText.antialiasText = this.antialiasText;
                    pText.dataDPIScaleFactor = this.dataDPIScaleFactor;
                    pText.linearScaleFactor = this.linearScaleFactor;
                    pText.setVAlign(2);
                    pText.setHAlign(1);
                    pText.setLineBreakMode(0);
                    this.insideLabels.add(pText);
                }
                return this.insideLabels.elementAt(lineNum);
            }
            case 1: {
                if (this.title == null) {
                    this.title = new TextObject();
                    TextObject pDefaultTextObject = this.getDefaultTextObject(1);
                    if (pDefaultTextObject != null) {
                        this.title.updateTextProperties(pDefaultTextObject);
                    }
                    this.title.setVAlign(1);
                    this.title.setHAlign(1);
                    this.title.setLineBreakMode(1);
                }
                return this.title;
            }
            case 2: {
                if (this.topLabels != null && this.topLabels.size() <= lineNum) {
                    TextObject topLabel = new TextObject();
                    TextObject pDefaultTextObject = this.getDefaultTextObject(2);
                    if (pDefaultTextObject != null) {
                        topLabel.updateTextProperties(pDefaultTextObject);
                    }
                    topLabel.antialias = this.antialias;
                    topLabel.antialiasText = this.antialiasText;
                    topLabel.dataDPIScaleFactor = this.dataDPIScaleFactor;
                    topLabel.linearScaleFactor = this.linearScaleFactor;
                    topLabel.setVAlign(2);
                    topLabel.setHAlign(0);
                    topLabel.setLineBreakMode(0);
                    this.topLabels.add(topLabel);
                }
                return this.topLabels.elementAt(lineNum);
            }
            case 3: {
                if (this.bottomLabel == null) {
                    this.bottomLabel = new TextObject();
                    this.bottomLabel.antialias = this.antialias;
                    this.bottomLabel.antialiasText = this.antialiasText;
                    this.bottomLabel.dataDPIScaleFactor = this.dataDPIScaleFactor;
                    this.bottomLabel.linearScaleFactor = this.linearScaleFactor;
                    TextObject pDefaultTextObject = this.getDefaultTextObject(3);
                    if (pDefaultTextObject != null) {
                        this.bottomLabel.updateTextProperties(pDefaultTextObject);
                    }
                    this.bottomLabel.setVAlign(1);
                    this.bottomLabel.setHAlign(0);
                    this.bottomLabel.setLineBreakMode(0);
                }
                return this.bottomLabel;
            }
            case 4: {
                if (this.overviewLabels.size() <= lineNum) {
                    TextObject pText = new TextObject();
                    pText.antialias = this.antialias;
                    pText.antialiasText = this.antialiasText;
                    pText.dataDPIScaleFactor = this.dataDPIScaleFactor;
                    pText.linearScaleFactor = this.linearScaleFactor;
                    TextObject pDefaultTextObject = this.getDefaultTextObject(4);
                    if (pDefaultTextObject != null) {
                        pText.updateTextProperties(pDefaultTextObject);
                    }
                    if (this.overviewLabelPosition == 1) {
                        pText.setVAlign(1);
                        pText.setHAlign(0);
                    } else if (this.overviewLabelPosition == 0) {
                        pText.setVAlign(2);
                        pText.setHAlign(0);
                    } else {
                        pText.setVAlign(0);
                        pText.setHAlign(0);
                    }
                    pText.setLineBreakMode(0);
                    this.overviewLabels.add(pText);
                }
                return this.overviewLabels.elementAt(lineNum);
            }
        }
        return null;
    }

    public int getNumLinesForLabel(int labelID) {
        int numLines = 1;
        if (labelID == 0) {
            numLines = this.insideLabels.size();
        } else if (labelID == 4) {
            numLines = this.overviewLabels.size();
        }
        return numLines;
    }

    public void setLabel(byte labelID, String label, int lineNum) {
        if (labelID == 0 || labelID == 4) {
            StringTokenizer tokenizer = new StringTokenizer(label, "\n");
            int num = 0;
            while (tokenizer.hasMoreTokens()) {
                this.getLabelTextObject(labelID, lineNum + num).setText(tokenizer.nextToken());
                ++num;
            }
        } else {
            this.getLabelTextObject(labelID, lineNum).setText(label);
        }
    }

    public void setOverviewLabelPosition(byte pos) {
        this.overviewLabelPosition = pos;
    }

    public void setLabelFitConstraints() {
        int i;
        double labelOffsetX = NodeItem.getScaledLabelOffset().getX();
        double labelOffsetY = NodeItem.getScaledLabelOffset().getY();
        double constraintX = Math.max(1.0, this.bounds.getWidth() - labelOffsetX * 2.0);
        double constraintY = Math.max(1.0, this.bounds.getHeight() - labelOffsetY * 2.0);
        if (this.title != null) {
            this.title.setFitConstraint(constraintX, constraintY);
        }
        for (i = 0; i < this.insideLabels.size(); ++i) {
            if (this.insideLabels.elementAt(i) == null) continue;
            this.insideLabels.elementAt(i).setFitConstraint(constraintX, constraintY);
        }
        for (i = 0; i < this.overviewLabels.size(); ++i) {
            if (this.overviewLabels.elementAt(i) == null) continue;
            if (this.overviewLabelPosition == 1) {
                constraintX = this.bounds.getWidth() + labelOffsetX * 2.0;
                this.overviewLabels.elementAt(i).setVAlign(1);
                this.overviewLabels.elementAt(i).setHAlign(0);
            } else if (this.overviewLabelPosition == 0) {
                constraintX = this.bounds.getWidth() + labelOffsetX * 2.0;
                this.overviewLabels.elementAt(i).setVAlign(2);
                this.overviewLabels.elementAt(i).setHAlign(0);
            } else {
                this.overviewLabels.elementAt(i).setVAlign(0);
                this.overviewLabels.elementAt(i).setHAlign(0);
            }
            if (this.overviewLabels.elementAt(i).getFitConstraintWidth() != 0.0 || this.overviewLabels.elementAt(i).getFitConstraintWidth() != 0.0) continue;
            this.overviewLabels.elementAt(i).setFitConstraint(constraintX, constraintY);
        }
    }

    public void positionLabels(Graphics2D gc, Rectangle renderArea2D, double scale) {
        TextObject textObj;
        double theight;
        int i;
        double labelOffsetX = NodeItem.getScaledLabelOffset().getX();
        double labelOffsetY = NodeItem.getScaledLabelOffset().getY();
        int lineOffset = 0;
        this.roomForTitle = true;
        if (this.title != null) {
            Point2D.Double position = new Point2D.Double(this.bounds.getX() + labelOffsetX, this.bounds.getY() + labelOffsetY + (double)lineOffset);
            this.title.setPosition(position);
            this.title.setWidth(this.bounds.getWidth() - labelOffsetX * 2.0);
            this.title.setWrappingWidth(this.bounds.getWidth() - labelOffsetX * 2.0);
            double theight2 = this.title.getPreferredHeight(gc.getFontRenderContext());
            lineOffset = (int)((double)lineOffset + (theight2 + (double)this.titlePad));
            if ((double)lineOffset > this.bounds.getHeight() - labelOffsetY * 2.0) {
                this.roomForTitle = false;
                lineOffset = 0;
            }
        }
        double constraintHeight = this.bounds.getHeight() - labelOffsetY * 2.0;
        constraintHeight = Math.max(1.0, constraintHeight);
        this.numFittedInsideLabels = 0;
        for (i = 0; i < this.insideLabels.size(); ++i) {
            if (this.insideLabels.elementAt(i) == null) continue;
            if (i == this.insideLabelLineSeparator) {
                lineOffset = (int)((double)lineOffset + Math.ceil(1.34 * labelOffsetY));
            }
            if ((double)(lineOffset = (int)((double)lineOffset + (theight = (textObj = this.insideLabels.elementAt(i)).getPreferredHeight(gc.getFontRenderContext())))) > constraintHeight) {
                if (i > 0) {
                    if (this.insideLabelLineSeparator > 0 && i <= this.insideLabelLineSeparator + 1) {
                        this.insideLabels.elementAt(i - 1).setText("");
                        this.insideLabelLineSeparator = -1;
                        break;
                    }
                    this.insideLabels.elementAt(i - 1).setText("...");
                    break;
                }
                lineOffset = 0;
                textObj.setText("...");
                break;
            }
            Point2D.Double position = new Point2D.Double(this.bounds.getX() + labelOffsetX, this.bounds.getY() + labelOffsetY + (double)lineOffset);
            textObj.setPosition(position);
            ++this.numFittedInsideLabels;
        }
        lineOffset = 0;
        this.numFittedInputLabels = 0;
        for (i = 0; i < this.topLabels.size(); ++i) {
            if (this.topLabels.elementAt(i) == null) continue;
            textObj = this.topLabels.elementAt(i);
            theight = textObj.getPreferredHeight(gc.getFontRenderContext());
            if ((double)(lineOffset = (int)((double)lineOffset + theight)) > constraintHeight) break;
            lineOffset = (int)((double)lineOffset + theight);
            ++this.numFittedInputLabels;
        }
        lineOffset = 0;
        for (i = this.numFittedInputLabels - 1; i >= 0; --i) {
            if (this.topLabels.elementAt(i) == null) continue;
            textObj = this.topLabels.elementAt(i);
            Point2D.Double position = new Point2D.Double(this.bounds.getX() + this.bounds.getWidth() / 2.0, this.bounds.getY() - (double)lineOffset);
            textObj.setPosition(position);
            double theight3 = textObj.getPreferredHeight(gc.getFontRenderContext());
            lineOffset = (int)((double)lineOffset + theight3);
        }
        if (this.bottomLabel != null) {
            this.bottomLabel.setPosition(new Point2D.Double(this.bounds.getX() + this.bounds.getWidth() / 2.0, this.bounds.getY() + this.bounds.getHeight()));
        }
    }

    public int positionOverviewLabels(Graphics2D gc, Rectangle renderArea, double mvScale) {
        int i;
        if (this.overviewLabels.size() < 1) {
            return 0;
        }
        double constraintHeight = this.overviewLabels.elementAt(0).getFitConstraintHeight();
        int num = 1;
        if (constraintHeight > 0.0) {
            double totalHeight = this.overviewLabels.elementAt(0).getPreferredHeight(gc.getFontRenderContext());
            for (int i2 = 1; i2 < this.overviewLabels.size() && !((totalHeight += this.overviewLabels.elementAt(i2).getPreferredHeight(gc.getFontRenderContext())) > constraintHeight); ++i2) {
                ++num;
            }
        } else {
            num = this.overviewLabels.size();
        }
        double lineOffset = 0.0;
        Point2D.Double position = new Point2D.Double(this.bounds.getX() + this.bounds.getWidth() / 2.0, this.bounds.getY() + this.bounds.getHeight() / 2.0);
        double startY = ((Point2D)position).getY();
        if (this.overviewLabels.size() > 1 && this.overviewLabelPosition == 2) {
            for (i = 1; i < num; ++i) {
                if (this.overviewLabels.elementAt(i) == null) continue;
                startY -= this.overviewLabels.elementAt(i).getLineHeight(gc.getFontRenderContext(), renderArea) / 2.0;
            }
        }
        for (i = 0; i < num; ++i) {
            TextObject tObj = this.overviewLabels.elementAt(i);
            if (tObj == null) continue;
            double y = ((Point2D)position).getY();
            double x = ((Point2D)position).getX();
            y = this.overviewLabelPosition == 0 ? this.bounds.getY() - lineOffset : (this.overviewLabelPosition == 1 ? this.bounds.getY() + this.bounds.getHeight() + lineOffset : startY + lineOffset);
            lineOffset += tObj.getLineHeight(gc.getFontRenderContext(), renderArea);
            tObj.setPosition(new Point2D.Double(x, y));
        }
        return num;
    }

    public void addNodeContentColor(Color color, double percent) {
        NodeContent colorContent = new NodeContent(color, Math.max(0.0, Math.min(1.0, percent)));
        this.nodeContents.add(colorContent);
    }

    public void setNodeContentOutlineColor(Color color) {
        this.nodeContentOutlineColor = color;
    }

    public void clearNodeContentColors() {
        this.nodeContents.clear();
    }

    public void renderNodeContentColors(Graphics g, Rectangle renderArea, double mvScale) {
        Graphics2D gc = (Graphics2D)g;
        int numColors = this.nodeContents.size();
        if (numColors <= 0) {
            if (this.nodeContentOutline && this.border) {
                gc.setColor(this.backgroundColor);
                gc.fillRoundRect(NodeItem.toInt(this.bounds.getX() - this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getY() - this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getWidth() - this.borderThickness), NodeItem.toInt(this.bounds.getHeight() - this.borderThickness), 10, 10);
                Stroke savedStroke = gc.getStroke();
                BasicStroke stroke = LinkItem.getStroke(this.borderStyle, (float)this.borderThickness, (float)this.borderFactorMultiplier);
                gc.setStroke(stroke);
                gc.setColor(this.borderColor);
                gc.drawRoundRect(NodeItem.toInt(this.bounds.getX() - this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getY() - this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getWidth() - this.borderThickness), NodeItem.toInt(this.bounds.getHeight() - this.borderThickness), 10, 10);
                gc.setStroke(savedStroke);
            } else {
                gc.setColor(this.backgroundColor);
                gc.fillRoundRect(NodeItem.toInt(this.bounds.getX()), NodeItem.toInt(this.bounds.getY()), NodeItem.toInt(this.bounds.getWidth()), NodeItem.toInt(this.bounds.getHeight()), 10, 10);
            }
            return;
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        double x = this.bounds.getX() + this.nodeContentOutlineThickness / 2.0;
        double y = this.bounds.getY() + this.nodeContentOutlineThickness / 2.0;
        double w = (this.bounds.getWidth() - this.nodeContentOutlineThickness) / (double)numColors;
        double h = this.bounds.getHeight() - this.nodeContentOutlineThickness;
        if (w <= 1.0) {
            return;
        }
        Stroke savedStroke = gc.getStroke();
        BasicStroke stroke = new BasicStroke(NodeItem.toInt(this.nodeContentOutlineThickness));
        gc.setStroke(stroke);
        if (this.pct100) {
            int yi = NodeItem.toInt(y);
            int wi = NodeItem.toInt(w);
            int hi = NodeItem.toInt(h);
            for (int i = 0; i < numColors; ++i) {
                int xi = NodeItem.toInt(x);
                gc.setColor(this.backgroundColor);
                gc.fillRect(xi, yi, wi, hi);
                if (this.nodeContentOutline) {
                    gc.setColor(this.nodeContentOutlineColor);
                    gc.drawRect(xi, yi, wi, hi);
                }
                int hhi = NodeItem.toInt(h * this.nodeContents.elementAt((int)i).percent);
                gc.setColor(this.nodeContents.elementAt((int)i).color);
                gc.fillRect(xi, yi + (hi - hhi), wi, hhi);
                if (this.nodeContentOutline) {
                    gc.setColor(this.nodeContentOutlineColor);
                    gc.drawRect(xi, yi + (hi - hhi), wi, hhi);
                }
                x += w;
            }
        } else {
            x += this.nodeContentOutlineThickness / 2.0;
            y += this.nodeContentOutlineThickness / 2.0;
            w = (this.bounds.getWidth() - this.nodeContentOutlineThickness - this.borderThickness) / (double)numColors;
            gc.setColor(this.nodeContentOutlineColor);
            Rectangle2D.Double r = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            gc.fill(r);
            for (int i = 0; i < numColors; ++i) {
                double hh = h * this.nodeContents.elementAt((int)i).percent;
                gc.setColor(this.nodeContents.elementAt((int)i).color);
                r = new Rectangle2D.Double(x, y + (h - hh), w, hh);
                gc.fill(r);
                if (this.nodeContentOutline) {
                    gc.setColor(this.nodeContentOutlineColor);
                    gc.draw(r);
                }
                x += w;
            }
            stroke = LinkItem.getStroke(this.borderStyle, (float)this.borderThickness, (float)this.borderFactorMultiplier);
            gc.setStroke(stroke);
            gc.setColor(this.borderColor);
            r = new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
            gc.draw(r);
        }
        gc.setStroke(savedStroke);
    }

    public boolean isModified() {
        return this.modifiedFlag;
    }

    private boolean shouldSkipRender(Rectangle renderArea) {
        return !renderArea.contains(this.bounds) && !renderArea.intersects(this.bounds);
    }

    public void render(Graphics g, Rectangle renderArea) {
        int i;
        Graphics2D gc;
        double mvScale;
        if (this.shouldSkipRender(renderArea)) {
            return;
        }
        if (this.modifiedFlag) {
            this.initNode();
        }
        if ((mvScale = (gc = (Graphics2D)g).getTransform().getScaleY()) < this.LODThreshold) {
            if (this.LODBackgroundVisible) {
                this.renderNodeContentColors(gc, renderArea, mvScale);
            }
            if (this.overviewLabels.size() > 0) {
                TextObject firstLabel = this.overviewLabels.get(0);
                int fs = firstLabel.getMinimumFontSize();
                Font f = firstLabel.getFont();
                FontMetrics fm = gc.getFontMetrics(new Font(f.getFamily(), f.getStyle(), fs));
                if ((double)fm.getHeight() < firstLabel.getFitConstraintWidth()) {
                    int num = this.positionOverviewLabels(gc, renderArea, mvScale);
                    for (int i2 = 0; i2 < num; ++i2) {
                        TextObject tObj = this.overviewLabels.elementAt(i2);
                        tObj.render(gc, renderArea);
                    }
                }
            }
            return;
        }
        if (this.background && this.backgroundColor != null) {
            gc.setColor(this.backgroundColor);
            if (this.border) {
                gc.fillRoundRect(NodeItem.toInt(this.bounds.getX() + this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getY() + this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getWidth() - this.borderThickness), NodeItem.toInt(this.bounds.getHeight() - this.borderThickness), 10, 10);
            } else {
                gc.fillRoundRect(NodeItem.toInt(this.bounds.getX()), NodeItem.toInt(this.bounds.getY()), NodeItem.toInt(this.bounds.getWidth()), NodeItem.toInt(this.bounds.getHeight()), 10, 10);
            }
        }
        if (this.border) {
            Stroke savedStroke = gc.getStroke();
            BasicStroke stroke = LinkItem.getStroke(this.borderStyle, (float)this.borderThickness, (float)this.borderFactorMultiplier);
            gc.setStroke(stroke);
            gc.setColor(this.borderColor);
            gc.drawRoundRect(NodeItem.toInt(this.bounds.getX() + this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getY() + this.borderThickness / 2.0), NodeItem.toInt(this.bounds.getWidth() - this.borderThickness), NodeItem.toInt(this.bounds.getHeight() - this.borderThickness), 10, 10);
            gc.setStroke(savedStroke);
        }
        this.positionLabels(gc, renderArea, mvScale);
        if (this.title != null && this.roomForTitle) {
            this.title.render(gc, renderArea);
        }
        double labelOffsetX = NodeItem.getScaledLabelOffset().getX();
        double labelOffsetY = NodeItem.getScaledLabelOffset().getY();
        for (i = 0; i < this.numFittedInsideLabels; ++i) {
            TextObject tObj = this.insideLabels.elementAt(i);
            Point2D pos = tObj.getPosition();
            if (pos.getY() >= this.bounds.getY() + labelOffsetY / 2.0) {
                tObj.render(gc, renderArea);
            }
            if (i + 1 != this.insideLabelLineSeparator) continue;
            double offset = (int)(0.67 * labelOffsetY);
            gc.setColor(this.borderColor);
            BasicStroke stroke = new BasicStroke((float)this.borderThickness, 2, 0);
            gc.setStroke(stroke);
            Line2D.Double line = new Line2D.Double(pos.getX() - 0.25 * labelOffsetX, pos.getY() + offset, pos.getX() + this.bounds.getWidth() - 1.75 * labelOffsetY, pos.getY() + offset);
            gc.draw(line);
        }
        for (i = 0; i < this.numFittedInputLabels; ++i) {
            this.topLabels.elementAt(i).render(gc, renderArea);
        }
        if (this.bottomLabel != null) {
            this.bottomLabel.render(gc, renderArea);
        }
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void flipY(Rectangle2D bounds) {
        if (bounds.getY() < 0.0) {
            bounds.setRect(bounds.getX(), -bounds.getY(), bounds.getWidth(), bounds.getHeight());
        }
    }

    public double getLODThreshold() {
        return this.LODThreshold;
    }

    public void setLODThreshold(double lODThreshold) {
        this.LODThreshold = lODThreshold;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isGeometryVisible(Graphics2D gc) {
        double mvScale = gc.getTransform().getScaleY();
        return this.isLODBackgroundVisible() || mvScale > this.LODThreshold;
    }

    public void setScreenBounds(Rectangle2D rect) {
        this.screenBounds = rect;
    }

    public Rectangle2D getScreenBounds() {
        return this.screenBounds;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public double getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(double borderThickness) {
        this.borderThickness = borderThickness;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public double getBorderFactorMultiplier() {
        return this.borderFactorMultiplier;
    }

    public void setBorderFactorMultiplier(double borderFactorMultiplier) {
        this.borderFactorMultiplier = borderFactorMultiplier;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public double getNodeContentOutlineThickness() {
        return this.nodeContentOutlineThickness;
    }

    public void setNodeContentOutlineThickness(double nodeContentOutlineThickness) {
        this.nodeContentOutlineThickness = nodeContentOutlineThickness;
    }

    public boolean isPCT100() {
        return this.pct100;
    }

    public void setPCT100(boolean pct100) {
        this.pct100 = pct100;
    }

    public int getInsideLabelLineSeparator() {
        return this.insideLabelLineSeparator;
    }

    public void setInsideLabelLineSeparator(int insideLabelLineSeparator) {
        this.insideLabelLineSeparator = insideLabelLineSeparator;
    }
}

