/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.LinkItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeLinkDiagramItem;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ItemManager {
    private DecisionTreeRegion owner;
    private Vector<NodeLinkDiagramItem> items;
    private Vector<NodeLinkDiagramItem> indexedItems;
    private Vector<NodeLinkDiagramItem> displayedItems;
    private Vector<NodeLinkDiagramItem> displayedOverviewedItems;
    private HashMap<String, NodeLinkDiagramItem> idMap;
    private HashSet<NodeLinkDiagramItem> addedItems;
    private HashMap<Vector<NodeLinkDiagramItem>, HashSet<NodeLinkDiagramItem>> loadQueues;
    private HashMap<Vector<NodeLinkDiagramItem>, HashSet<NodeLinkDiagramItem>> unloadQueues;
    private HashMap<Vector<NodeLinkDiagramItem>, HashSet<NodeLinkDiagramItem>> reloadQueues;
    private HashMap<NodeLinkDiagramItem, Vector<NodeLinkDiagramItem>> itemLoadParentMap;
    private HashMap<NodeLinkDiagramItem, Vector<NodeLinkDiagramItem>> itemUnloadParentMap;
    private Vector<NodeLinkDiagramItem> itemInitQueue;
    private HashSet<NodeLinkDiagramItem> itemDisposeQueue;
    private int disposeImmediateDepth = 0;
    private Rectangle2D diagramBounds = new Rectangle2D.Double();
    private Rectangle2D allItemsDiagramBounds = new Rectangle2D.Double();
    private boolean diagramBoundsInvalid = false;
    private boolean forceLinksToBack = true;

    public ItemManager(DecisionTreeRegion owner) {
        this.owner = owner;
        this.init();
    }

    public void addItem(NodeLinkDiagramItem item) {
        this.addItem(item, true);
    }

    public void addItem(NodeLinkDiagramItem item, boolean addToInitQueue) {
        String uid;
        NodeLinkDiagramItem existingItem;
        if (item != null && ((existingItem = this.idMap.get(uid = item.getId())) == null || existingItem == item)) {
            this.addedItems.add(item);
            if (addToInitQueue) {
                if (this.itemInitQueue == null) {
                    this.itemInitQueue = new Vector();
                }
                this.itemInitQueue.add(item);
            }
            if (existingItem == null) {
                this.idMap.put(uid, item);
                this.owner.itemAdded(item);
            }
        }
    }

    public void endAddItems(boolean disposeMissingItems) {
        if (disposeMissingItems) {
            Iterator<NodeLinkDiagramItem> items = this.idMap.values().iterator();
            if (this.itemDisposeQueue == null) {
                this.itemDisposeQueue = new HashSet();
            }
            while (items.hasNext()) {
                NodeLinkDiagramItem item = items.next();
                if (this.addedItems.contains(item)) continue;
                this.itemDisposeQueue.add(item);
            }
        }
        this.addedItems.clear();
    }

    public void removeItem(NodeLinkDiagramItem item) {
        if (item != null) {
            this.idMap.remove(item.getId());
            this.addedItems.remove(item);
            if (this.itemInitQueue != null && this.itemInitQueue.contains(item)) {
                this.itemInitQueue.remove(item);
            }
            this.owner.itemRemoved(item);
        }
    }

    public NodeLinkDiagramItem getItem(String uid) {
        if (uid != null && uid.length() > 0) {
            return this.idMap.get(uid);
        }
        return null;
    }

    public NodeLinkDiagramItem getItemForObsIndex(int obsIndex) {
        if (obsIndex > this.indexedItems.size()) {
            return this.indexedItems.elementAt(obsIndex);
        }
        return null;
    }

    public Vector<NodeLinkDiagramItem> getIndexedItems() {
        return this.indexedItems;
    }

    public Vector<NodeLinkDiagramItem> getItems() {
        return this.items;
    }

    public void disposeItemImpl(NodeLinkDiagramItem item) {
        Vector<NodeLinkDiagramItem> itemParent = item.getParent();
        if (itemParent != null) {
            itemParent.remove(item);
            this.unloadItem(item, itemParent);
        }
        this.removeItem(item);
        this.owner.disposingItem(item);
        item.dispose();
    }

    public void disposeItem(NodeLinkDiagramItem item) {
        this.disposeItem(item, true);
    }

    public void disposeItem(NodeLinkDiagramItem item, boolean disposeImmediately) {
        if (disposeImmediately || this.disposeImmediateDepth > 0) {
            ++this.disposeImmediateDepth;
            this.disposeItemImpl(item);
            --this.disposeImmediateDepth;
        } else {
            if (this.itemDisposeQueue == null) {
                this.itemDisposeQueue = new HashSet();
            }
            this.itemDisposeQueue.add(item);
        }
    }

    public void disposeItems(Set<NodeLinkDiagramItem> items, boolean disposeImmediately) {
        if (disposeImmediately || this.disposeImmediateDepth > 0) {
            ++this.disposeImmediateDepth;
            Iterator<NodeLinkDiagramItem> it = items.iterator();
            while (it.hasNext()) {
                this.disposeItemImpl(it.next());
            }
            --this.disposeImmediateDepth;
        } else {
            if (this.itemDisposeQueue == null) {
                this.itemDisposeQueue = new HashSet();
            }
            this.itemDisposeQueue.addAll(items);
        }
    }

    public int disposeItemsFromQueue() {
        if (this.itemDisposeQueue == null) {
            return 0;
        }
        int disposeCount = 0;
        Iterator<NodeLinkDiagramItem> it = this.itemDisposeQueue.iterator();
        while (it.hasNext()) {
            this.disposeItemImpl(it.next());
            ++disposeCount;
        }
        this.itemDisposeQueue.clear();
        return disposeCount;
    }

    public void disposeAllItems() {
        ArrayList<NodeLinkDiagramItem> list = new ArrayList<NodeLinkDiagramItem>();
        Iterator<NodeLinkDiagramItem> it = this.idMap.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        for (int i = 0; i < list.size(); ++i) {
            this.disposeItemImpl((NodeLinkDiagramItem)list.get(i));
        }
        if (this.itemDisposeQueue != null) {
            this.itemDisposeQueue.clear();
        }
    }

    public boolean isInQueue(HashMap<Vector<NodeLinkDiagramItem>, HashSet<NodeLinkDiagramItem>> queueMap, NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        HashSet<NodeLinkDiagramItem> pset = queueMap.get(parent);
        if (pset == null) {
            return false;
        }
        return pset.contains(item);
    }

    boolean isItemLoadPending(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        return this.isInQueue(this.loadQueues, item, parent);
    }

    boolean isItemUnloadPending(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        return this.isInQueue(this.unloadQueues, item, parent);
    }

    boolean isItemReloadPending(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        return this.isInQueue(this.reloadQueues, item, parent);
    }

    public void loadItem(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        if (item != null) {
            HashSet<NodeLinkDiagramItem> loadQueue;
            boolean loaded = false;
            HashSet<NodeLinkDiagramItem> unloadQueue = this.unloadQueues.get(parent);
            if (unloadQueue != null && unloadQueue.contains(item)) {
                unloadQueue.remove(item);
                this.itemUnloadParentMap.remove(item);
                if (unloadQueue.isEmpty()) {
                    this.unloadQueues.remove(parent);
                }
                loaded = true;
            }
            if (!(loaded || (loadQueue = this.loadQueues.get(parent)) != null && loadQueue.contains(item))) {
                if (loadQueue == null) {
                    loadQueue = new HashSet();
                    this.loadQueues.put(parent, loadQueue);
                }
                loadQueue.add(item);
                this.itemLoadParentMap.put(item, parent);
                loaded = true;
            }
            if (loaded) {
                this.invalidateDiagramBounds();
            }
        }
    }

    public void unloadItem(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        if (item != null) {
            HashSet<NodeLinkDiagramItem> unloadQueue;
            boolean unloaded = false;
            HashSet<NodeLinkDiagramItem> loadQueue = this.loadQueues.get(parent);
            if (loadQueue != null && loadQueue.contains(item)) {
                loadQueue.remove(item);
                this.itemLoadParentMap.remove(item);
                if (loadQueue.isEmpty()) {
                    this.loadQueues.remove(parent);
                }
                unloaded = true;
            }
            if (!(unloaded || (unloadQueue = this.unloadQueues.get(parent)) != null && unloadQueue.contains(item))) {
                HashSet<NodeLinkDiagramItem> reloadQueue;
                if (this.reloadQueues.containsKey(parent) && (reloadQueue = this.reloadQueues.get(parent)) != null) {
                    reloadQueue.remove(item);
                    if (reloadQueue.isEmpty()) {
                        this.reloadQueues.remove(parent);
                    }
                }
                if (unloadQueue == null) {
                    unloadQueue = new HashSet();
                    this.unloadQueues.put(parent, unloadQueue);
                }
                unloadQueue.add(item);
                this.itemUnloadParentMap.put(item, parent);
                unloaded = true;
            }
            if (unloaded) {
                this.invalidateDiagramBounds();
            }
        }
    }

    public void reloadItem(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        HashSet<NodeLinkDiagramItem> reloadQueue;
        if (!(item == null || (reloadQueue = this.reloadQueues.get(parent)) != null && reloadQueue.contains(item))) {
            HashSet<NodeLinkDiagramItem> unloadQueue;
            if (this.unloadQueues.containsKey(parent) && (unloadQueue = this.unloadQueues.get(parent)) != null) {
                unloadQueue.remove(item);
                this.itemUnloadParentMap.remove(item);
                if (unloadQueue.isEmpty()) {
                    this.unloadQueues.remove(parent);
                }
            }
            if (reloadQueue == null) {
                reloadQueue = new HashSet();
                this.reloadQueues.put(parent, reloadQueue);
            }
            reloadQueue.add(item);
        }
    }

    private void addItemToInitQueue(NodeLinkDiagramItem item) {
        if (item != null) {
            this.itemInitQueue.add(item);
        }
    }

    public void initializeItems() {
        if (!this.itemInitQueue.isEmpty()) {
            int i;
            for (i = 0; i < this.itemInitQueue.size(); ++i) {
                this.owner.preInitializeItem(this.itemInitQueue.elementAt(i));
            }
            for (i = 0; i < this.itemInitQueue.size(); ++i) {
                this.owner.initializeItem(this.itemInitQueue.elementAt(i));
            }
            this.itemInitQueue.clear();
        }
    }

    public boolean isValidItem(NodeLinkDiagramItem item) {
        if (item != null) {
            String uid = item.getId();
            return uid != null && this.getItem(uid) == item;
        }
        return false;
    }

    public void draw(Graphics g) {
        Rectangle2D dataBounds = this.getDiagramBounds(true);
        Rectangle renderArea = new Rectangle((int)dataBounds.getX(), (int)dataBounds.getY(), (int)dataBounds.getWidth(), (int)dataBounds.getHeight());
        Iterator<NodeLinkDiagramItem> it = this.items.iterator();
        Vector<NodeItem> nList = new Vector<NodeItem>();
        while (it.hasNext()) {
            NodeLinkDiagramItem item = it.next();
            if (item instanceof NodeItem) {
                nList.add((NodeItem)item);
                continue;
            }
            LinkItem link = (LinkItem)item;
            if (!this.isItemRendered(link.getFromNode()) || !this.isItemRendered(link.getToNode())) continue;
            link.render(g, renderArea);
        }
        for (int i = 0; i < nList.size(); ++i) {
            NodeItem node = (NodeItem)nList.get(i);
            if (!this.isItemRendered(node)) continue;
            node.render(g, renderArea);
        }
    }

    private boolean hasDisplayListNode(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        if (parent != null) {
            Iterator<NodeLinkDiagramItem> it = parent.iterator();
            while (it.hasNext()) {
                if (this.displayedItems.contains(it.next())) continue;
                return false;
            }
        }
        return this.displayedItems.contains(item);
    }

    private NodeLinkDiagramItem getDisplayListNode(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent) {
        if (parent != null) {
            Iterator<NodeLinkDiagramItem> it = parent.iterator();
            while (it.hasNext()) {
                if (this.displayedItems.contains(it.next())) continue;
                return null;
            }
        }
        return item;
    }

    private void updateDisplayListNodes(Graphics g) {
        for (NodeLinkDiagramItem item : this.items) {
            if (!item.isDirty()) continue;
            item.updateDisplayListNode(g);
        }
    }

    private int unloadDisplayListNodesFromQueue(Vector<NodeLinkDiagramItem> parent) {
        int unloadCount = 0;
        if (this.unloadQueues.containsKey(parent)) {
            HashSet<NodeLinkDiagramItem> queue = this.unloadQueues.get(parent);
            for (NodeLinkDiagramItem item : queue) {
                if (this.unloadDisplayListNode(item)) {
                    ++unloadCount;
                }
                this.itemUnloadParentMap.remove(item);
            }
            this.unloadQueues.remove(parent);
        }
        return unloadCount;
    }

    private boolean unloadDisplayListNode(NodeLinkDiagramItem item) {
        return this.displayedItems.remove(item);
    }

    private NodeLinkDiagramItem loadDisplayListNode(NodeLinkDiagramItem item, Vector<NodeLinkDiagramItem> parent, Graphics editor) {
        if (this.displayedItems == null) {
            this.displayedItems = new Vector();
        }
        if (!this.displayedItems.contains(item)) {
            this.displayedItems.add(item);
            return item;
        }
        return null;
    }

    private NodeLinkDiagramItem loadOverviewDisplayListNode(NodeLinkDiagramItem item, Graphics editor, Color blendColor, HashMap<NodeLinkDiagramItem, Point2D> itemLocations) {
        if (item != null) {
            Point2D point;
            Rectangle2D rect;
            Rectangle2D overrideBounds = null;
            if (itemLocations != null && itemLocations.containsKey(item) && (rect = item.getBoundsAtOrigin(point = itemLocations.get(item))) != null) {
                overrideBounds = rect;
            }
            item.createOverviewDisplayListNode(editor, overrideBounds, blendColor);
            return item;
        }
        return null;
    }

    public void invalidateDiagramBounds() {
        this.diagramBoundsInvalid = true;
    }

    private void validateDiagramBounds() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = minX;
        double maxY = maxX;
        double unrenderedMinX = minX;
        double unrenderedMaxX = maxX;
        double unrenderedMinY = minY;
        double unrenderedMaxY = maxY;
        for (NodeLinkDiagramItem rectItem : this.items) {
            if (!(rectItem instanceof NodeItem)) continue;
            Rectangle2D itemBounds = rectItem.getBounds();
            ((NodeItem)rectItem).flipY(itemBounds);
            if (this.isItemRendered(rectItem)) {
                minX = Math.min(minX, itemBounds.getX());
                maxX = Math.max(maxX, itemBounds.getX() + itemBounds.getWidth());
                minY = Math.min(minY, itemBounds.getY());
                maxY = Math.max(maxY, itemBounds.getY() + itemBounds.getHeight());
                continue;
            }
            unrenderedMinX = Math.min(unrenderedMinX, itemBounds.getX());
            unrenderedMaxX = Math.max(unrenderedMaxX, itemBounds.getX() + itemBounds.getWidth());
            unrenderedMinY = Math.min(unrenderedMinY, itemBounds.getY());
            unrenderedMaxY = Math.max(unrenderedMaxY, itemBounds.getY() + itemBounds.getHeight());
        }
        if (minX <= maxX && minY <= maxY) {
            this.diagramBounds.setFrame(minX, minY, maxX - minX, maxY - minY);
        } else {
            this.diagramBounds.setFrame(0.0, 0.0, 0.0, 0.0);
        }
        if (unrenderedMinX <= unrenderedMaxX && unrenderedMinY <= unrenderedMaxY) {
            if (minX <= maxX && minY <= maxY) {
                double x1 = Math.min(unrenderedMinX, minX);
                double x2 = Math.max(unrenderedMaxX, maxX);
                double y1 = Math.min(unrenderedMinY, minY);
                double y2 = Math.max(unrenderedMaxY, maxY);
                this.allItemsDiagramBounds.setFrame(x1, y1, x2 - x1, y2 - y1);
            } else {
                this.allItemsDiagramBounds.setFrame(unrenderedMinX, unrenderedMinY, unrenderedMaxX - unrenderedMinX, unrenderedMaxY - unrenderedMinY);
            }
        } else {
            this.allItemsDiagramBounds = this.diagramBounds;
        }
        this.diagramBoundsInvalid = false;
    }

    public Rectangle2D getDiagramBounds(boolean includeUnrenderedItems) {
        if (this.diagramBoundsInvalid) {
            this.validateDiagramBounds();
        }
        return includeUnrenderedItems ? this.allItemsDiagramBounds : this.diagramBounds;
    }

    public boolean isItemRendered(NodeLinkDiagramItem item) {
        Vector<NodeLinkDiagramItem> parent;
        if (item != null && (parent = item.getParent()) != null) {
            return this.isItemLoadPending(item, parent) || this.hasDisplayListNode(item, parent) && !this.isItemUnloadPending(item, parent);
        }
        return false;
    }

    public NodeLinkDiagramItem getItemAtPoint(Point2D pt) {
        for (NodeLinkDiagramItem item : this.items) {
            Rectangle2D rect = item.getBounds();
            if (!rect.contains(pt)) continue;
            return item;
        }
        return null;
    }

    public Rectangle2D calculateItemSizeAndOffset(NodeLinkDiagramItem item) {
        Rectangle2D sizeAndOffset = new Rectangle2D.Double();
        if (item != null) {
            sizeAndOffset = item.measure();
        }
        return sizeAndOffset;
    }

    public void init() {
        this.addedItems = new HashSet();
        this.items = new Vector();
        this.indexedItems = new Vector();
        this.displayedItems = new Vector();
        this.displayedOverviewedItems = new Vector();
        this.idMap = new HashMap();
        this.loadQueues = new HashMap();
        this.unloadQueues = new HashMap();
        this.reloadQueues = new HashMap();
        this.itemLoadParentMap = new HashMap();
        this.itemUnloadParentMap = new HashMap();
        this.itemInitQueue = new Vector();
        this.itemDisposeQueue = new HashSet();
        this.disposeImmediateDepth = 0;
        this.allItemsDiagramBounds = new Rectangle2D.Double();
    }

    public void reset() {
        this.addedItems.clear();
        this.items.clear();
        this.indexedItems.clear();
        this.displayedItems.clear();
        this.displayedOverviewedItems.clear();
        this.idMap.clear();
        this.addedItems.clear();
        this.loadQueues.clear();
        this.unloadQueues.clear();
        this.reloadQueues.clear();
        this.itemLoadParentMap.clear();
        this.itemLoadParentMap.clear();
        this.itemUnloadParentMap.clear();
        this.itemInitQueue.clear();
        this.itemDisposeQueue.clear();
        this.disposeImmediateDepth = 0;
        this.diagramBounds.setFrame(0.0, 0.0, 0.0, 0.0);
        this.allItemsDiagramBounds.setFrame(0.0, 0.0, 0.0, 0.0);
        this.diagramBoundsInvalid = false;
        this.forceLinksToBack = true;
    }
}

